import chimera.extension

# -----------------------------------------------------------------------------
#
class PlaceObjectEMO(chimera.extension.EMO):

  def name(self):
    return 'Place Object'
  def description(self):
    return 'Place objects in a 3D map'
  def categories(self):
    return ['Utilities']
  def icon(self):
    return self.path('PlaceObject.png')
  def activate(self):
    from chimera.dialogs import display
    self.module('gui').show_placeobjectdialog()
    return None

# -----------------------------------------------------------------------------
#
chimera.extension.manager.registerExtension(PlaceObjectEMO(__file__))

