TITL Trigonal trypsin
CELL  1.54178   54.735   54.735  106.786  90.00  90.00 120.00
ZERR        6    0.055    0.055    0.107   0.00   0.00   0.00
 
REM Space group P 31 2 1
 
LATT -1
SYMM -Y, X-Y, 1/3+Z
SYMM -X+Y, -X, 2/3+Z
SYMM Y, X, -Z
SYMM X-Y, -Y, 2/3-Z
SYMM -X, -X+Y, 1/3-Z
SFAC  C  H  N  O  S  CA
UNIT  6142 13524 1682 3444 87 6
 
DEFS 0.02 0.1 0.01 0.04
CGLS 20 -1
SHEL 99 0.1
FMAP 2
PLAN 200 2.3
LIST 6
WPDB 2
 
DELU $C_* $N_* $O_* $S_*
SIMU 0.1 $C_* $N_* $O_* $S_*
ISOR 0.1 O_2001 > LAST
CONN 0 O_2001 > LAST
BUMP
REM HOPE
 
REM Remove MERG 4 instruction if Friedel opposites should not be merged
 
MERG 4
 
REM MORE 0 would reduce output if not required for diagnostic purposes
 
REM MORE 0
 
REM Remove 'REM ' before RTAB to activate remaining tables
 
RTAB_* Cvol CA
RTAB_* Omeg CA_+ N_+ C CA
RTAB_* Phi C_- N CA C
RTAB_* Psi N CA C N_+
RTAB_ARG Chi1 N CA CB CG
RTAB_ARG Chi2 CA CB CG CD
RTAB_ARG Chi3 CB CG CD NE
RTAB_ARG Chi4 CG CD NE CZ
RTAB_ASN Chi1 N CA CB CG
RTAB_ASN Chi2 CA CB CG OD1
RTAB_ASP Chi1 N CA CB CG
RTAB_ASP Chi2 CA CB CG OD1
RTAB_CYS Chi1 N CA CB SG
RTAB_GLN Chi1 N CA CB CG
RTAB_GLN Chi2 CA CB CG CD
RTAB_GLN Chi3 CB CG CD OE1
RTAB_GLU Chi1 N CA CB CG
RTAB_GLU Chi2 CA CB CG CD
RTAB_GLU Chi3 CB CG CD OE1
RTAB_HIS Chi1 N CA CB CG
RTAB_HIS Chi2 CA CB CG ND1
RTAB_ILE Chi1 N CA CB CG1
RTAB_ILE Chi2 CA CB CG1 CD1
RTAB_ILE Cvol CB
RTAB_LEU Chi1 N CA CB CG
RTAB_LEU Chi2 CA CB CG CD1
RTAB_LYS Chi1 N CA CB CG
RTAB_LYS Chi2 CA CB CG CD
RTAB_LYS Chi3 CB CG CD CE
RTAB_LYS Chi4 CG CD CE NZ
RTAB_MET Chi1 N CA CB CG
RTAB_MET Chi2 CA CB CG SD
RTAB_MET Chi3 CB CG SD CE
RTAB_PHE Chi1 N CA CB CG
RTAB_PHE Chi2 CA CB CG CD1
RTAB_PRO Chi1 N CA CB CG
RTAB_PRO Chi2 CA CB CG CD
RTAB_PRO Chi3 CB CG CD N
RTAB_SER Chi1 N CA CB OG
RTAB_THR Chi1 N CA CB OG1
RTAB_THR Cvol CB
RTAB_TRP Chi1 N CA CB CG
RTAB_TRP Chi2 CA CB CG CD1
RTAB_TYR Chi1 N CA CB CG
RTAB_TYR Chi2 CA CB CG CD1
RTAB_VAL Chi1 N CA CB CG1
 
REM Remove 'REM ' in following to activate H-atom generation
 
DFIX_* 1.329 C_- N
DANG_* 2.425 CA_- N
DANG_* 2.250 O_- N
DANG_* 2.435 C_- CA
FLAT_* 0.5 O_- CA_- N C_- CA
 
CHIV_ALA C
CHIV_ALA 2.477 CA
DFIX_ALA 1.231 C O
DFIX_ALA 1.525 C CA
DFIX_ALA 1.521 CA CB
DFIX_ALA 1.458 N CA
DANG_ALA 2.462 C N
DANG_ALA 2.401 O CA
DANG_ALA 2.503 C CB
DANG_ALA 2.446 CB N
 
CHIV_ARG C CZ
CHIV_ARG 2.503 CA
FLAT_ARG CD NH1 NH2 NE CZ
DFIX_ARG 1.231 C O
DFIX_ARG 1.458 CA N
DFIX_ARG 1.525 C CA
DFIX_ARG 1.530 CA CB
DFIX_ARG 1.520 CB CG CG CD
DFIX_ARG 1.460 CD NE
DFIX_ARG 1.326 CZ NE CZ NH1 CZ NH2
DANG_ARG 2.455 N CB
DANG_ARG 2.401 O CA
DANG_ARG 2.504 C CB
DANG_ARG 2.462 C N
DANG_ARG 2.559 CA CG
DANG_ARG 2.510 CB CD
DANG_ARG 2.471 CG NE
DANG_ARG 2.466 CD CZ
DANG_ARG 2.299 NE NH1 NE NH2
DANG_ARG 2.293 NH1 NH2
 
CHIV_ASN C CG
CHIV_ASN 2.503 CA
DFIX_ASN 1.231 C O CG OD1
DFIX_ASN 1.525 C CA
DFIX_ASN 1.458 N CA
DFIX_ASN 1.530 CA CB
DFIX_ASN 1.516 CB CG
DFIX_ASN 1.328 CG ND2
DANG_ASN 2.401 O CA
DANG_ASN 2.462 C N
DANG_ASN 2.455 CB N
DANG_ASN 2.504 C CB
DANG_ASN 2.534 CA CG
DANG_ASN 2.393 CB OD1
DANG_ASN 2.419 CB ND2
DANG_ASN 2.245 OD1 ND2
 
CHIV_ASP C CG
CHIV_ASP 2.503 CA
DFIX_ASP 1.231 C O
DFIX_ASP 1.525 C CA
DFIX_ASP 1.530 CA CB
DFIX_ASP 1.516 CB CG
DFIX_ASP 1.458 CA N
DFIX_ASP 1.249 CG OD1 CG OD2
DANG_ASP 2.401 O CA
DANG_ASP 2.462 C N
DANG_ASP 2.455 CB N
DANG_ASP 2.504 C CB
DANG_ASP 2.534 CA CG
DANG_ASP 2.379 CB OD1 CB OD2
DANG_ASP 2.194 OD1 OD2
 
FLAT_BAM  C1 C2 C3 C4 C5 C6 C N1 N2
DFIX_BAM  1.414 C1   C2
DFIX_BAM  1.418 C1   C6
DFIX_BAM  1.412 C1   C
DFIX_BAM  1.391 C2   C3
DFIX_BAM  1.386 C3   C4
DFIX_BAM  1.390 C4   C5
DFIX_BAM  1.391 C5   C6
DFIX_BAM  1.307 C    N1
DFIX_BAM  1.310 C    N2
DANG_BAM  2.406 C2   C6
DANG_BAM  2.471 C2   C
DANG_BAM  2.470 C6   C
DANG_BAM  2.450 C1   C3
DANG_BAM  2.406 C2   C4
DANG_BAM  2.406 C3   C5
DANG_BAM  2.406 C4   C6
DANG_BAM  2.454 C1   C5
DANG_BAM  2.348 C1   N1
DANG_BAM  2.361 C1   N2
DANG_BAM  2.270 N1   N2
 
CHIV_CYS C
CHIV_CYS 2.503 CA
DFIX_CYS 1.231 C O
DFIX_CYS 1.525 C CA
DFIX_CYS 1.458 N CA
DFIX_CYS 1.530 CA CB
DFIX_CYS 1.808 CB SG
DANG_CYS 2.401 O CA
DANG_CYS 2.504 C CB
DANG_CYS 2.455 CB N
DANG_CYS 2.462 C N
DANG_CYS 2.810 CA SG
 
DFIX_EDO  1.536 C1   O1
DFIX_EDO  1.540 C1   C2
DFIX_EDO  1.568 C2   O2
DANG_EDO  2.589 O1   C2
DANG_EDO  2.516 C1   O2
 
CHIV_GLN C CD
CHIV_GLN 2.503 CA
DFIX_GLN 1.231 C O
DFIX_GLN 1.458 N CA
DFIX_GLN 1.525 C CA
DFIX_GLN 1.530 CA CB
DFIX_GLN 1.520 CB CG
DFIX_GLN 1.516 CG CD
DFIX_GLN 1.231 CD OE1
DFIX_GLN 1.328 CD NE2
DANG_GLN 2.401 O CA
DANG_GLN 2.462 C N
DANG_GLN 2.455 CB N
DANG_GLN 2.504 C CB
DANG_GLN 2.559 CA CG
DANG_GLN 2.526 CB CD
DANG_GLN 2.393 CG OE1
DANG_GLN 2.419 CG NE2
DANG_GLN 2.245 OE1 NE2
 
CHIV_GLU C CD
CHIV_GLU 2.503 CA
DFIX_GLU 1.231 C O
DFIX_GLU 1.458 N CA
DFIX_GLU 1.525 C CA
DFIX_GLU 1.530 CA CB
DFIX_GLU 1.520 CB CG
DFIX_GLU 1.516 CG CD
DFIX_GLU 1.249 CD OE1 CD OE2
DANG_GLU 2.401 O CA
DANG_GLU 2.462 C N
DANG_GLU 2.455 CB N
DANG_GLU 2.504 C CB
DANG_GLU 2.559 CA CG
DANG_GLU 2.526 CB CD
DANG_GLU 2.379 CG OE1 CG OE2
DANG_GLU 2.194 OE1 OE2
 
CHIV_GLY C
DFIX_GLY 1.231 O C
DFIX_GLY 1.516 C CA
DFIX_GLY 1.451 CA N
DANG_GLY 2.467 C N
DANG_GLY 2.393 O CA
 
FLAT_HIS CB ND1 NE2 CD2 CE1 CG
CHIV_HIS C
CHIV_HIS 2.503 CA
DFIX_HIS 1.231 C O
DFIX_HIS 1.525 C CA
DFIX_HIS 1.458 CA N
DFIX_HIS 1.530 CA CB
DFIX_HIS 1.497 CB CG
DFIX_HIS 1.378 CG ND1
DFIX_HIS 1.321 ND1 CE1 CE1 NE2
DFIX_HIS 1.374 NE2 CD2
DFIX_HIS 1.354 CD2 CG
DANG_HIS 2.401 O CA
DANG_HIS 2.462 C N
DANG_HIS 2.504 C CB
DANG_HIS 2.455 N CB
DANG_HIS 2.536 CA CG
DANG_HIS 2.524 CB ND1
DANG_HIS 2.597 CB CD2
DANG_HIS 2.202 CG CE1
DANG_HIS 2.196 CG NE2
DANG_HIS 2.194 CE1 CD2
DANG_HIS 2.143 ND1 NE2
DANG_HIS 2.170 ND1 CD2
 
CHIV_ILE C
CHIV_ILE 2.516 CA
CHIV_ILE 2.495 CB
DFIX_ILE 1.231 C O
DFIX_ILE 1.525 C CA
DFIX_ILE 1.458 CA N
DFIX_ILE 1.540 CA CB
DFIX_ILE 1.530 CB CG1
DFIX_ILE 1.521 CB CG2
DFIX_ILE 1.513 CG1 CD1
DANG_ILE 2.401 O CA
DANG_ILE 2.462 C N
DANG_ILE 2.479 N CB
DANG_ILE 2.576 CA CG1
DANG_ILE 2.515 CA CG2
DANG_ILE 2.549 CB CD1
DANG_ILE 2.510 CG1 CG2
DANG_ILE 2.497 C CB
 
CHIV_LEU C
CHIV_LEU 2.503 CA
CHIV_LEU -2.589 CG
DFIX_LEU 1.231 C O
DFIX_LEU 1.525 C CA
DFIX_LEU 1.458 N CA
DFIX_LEU 1.530 CA CB CB CG
DFIX_LEU 1.521 CG CD1 CG CD2
DANG_LEU 2.401 O CA
DANG_LEU 2.462 C N
DANG_LEU 2.455 N CB
DANG_LEU 2.504 C CB
DANG_LEU 2.599 CA CG
DANG_LEU 2.510 CB CD1 CB CD2
DANG_LEU 2.504 CD1 CD2
 
CHIV_LYS C
CHIV_LYS 2.503 CA
DFIX_LYS 1.231 C O
DFIX_LYS 1.525 C CA
DFIX_LYS 1.458 CA N
DFIX_LYS 1.530 CA CB
DFIX_LYS 1.520 CB CG CG CD CD CE
DFIX_LYS 1.489 CE NZ
DANG_LYS 2.401 O CA
DANG_LYS 2.462 C N
DANG_LYS 2.455 N CB
DANG_LYS 2.504 C CB
DANG_LYS 2.559 CA CG
DANG_LYS 2.510 CB CD CG CE
DANG_LYS 2.493 CD NZ
 
CHIV_MET C
CHIV_MET 2.503 CA
DFIX_MET 1.231 C O
DFIX_MET 1.458 N CA
DFIX_MET 1.525 C CA
DFIX_MET 1.530 CA CB
DFIX_MET 1.520 CB CG
DFIX_MET 1.803 CG SD
DFIX_MET 1.791 SD CE
DANG_MET 2.401 O CA
DANG_MET 2.462 C N
DANG_MET 2.455 N CB
DANG_MET 2.559 CA CG
DANG_MET 2.771 CB SD
DANG_MET 2.504 C CB
DANG_MET 2.771 CG CE
 
FLAT_PHE CG CD1 CE2 CB CD2 CE1 CZ
CHIV_PHE C
CHIV_PHE 2.503 CA
DFIX_PHE 1.231 C O
DFIX_PHE 1.458 N CA
DFIX_PHE 1.525 C CA
DFIX_PHE 1.530 CA CB
DFIX_PHE 1.502 CB CG
DFIX_PHE 1.384 CG CD1 CG CD2
DFIX_PHE 1.382 CD1 CE1 CD2 CE2 CE1 CZ CE2 CZ
DANG_PHE 2.401 O CA
DANG_PHE 2.462 C N
DANG_PHE 2.504 C CB
DANG_PHE 2.455 N CB
DANG_PHE 2.555 CA CG
DANG_PHE 2.525 CB CD1 CB CD2
DANG_PHE 2.404 CG CE1 CG CE2
DANG_PHE 2.394 CD1 CZ CD2 CZ CE1 CE2
DANG_PHE 2.380 CD1 CD2
 
CHIV_PRO C N
CHIV_PRO 2.728 CA
DFIX_PRO 1.231 C O
DFIX_PRO 1.525 C CA
DFIX_PRO 1.466 CA N
DFIX_PRO 1.473 N CD
DFIX_PRO 1.503 CD CG
DFIX_PRO 1.492 CG CB
DFIX_PRO 1.530 CB CA
DANG_PRO 2.401 O CA
DANG_PRO 2.477 C N
DANG_PRO 2.504 C CB
DANG_PRO 2.437 CA CD
DANG_PRO 2.332 N CG
DANG_PRO 2.393 CD CB
DANG_PRO 2.390 CA CG
DANG_PRO 2.345 N CB
DANG_PRO 2.497 CD C_-
 
CHIV_SER C
CHIV_SER 2.503 CA
DFIX_SER 1.231 C O
DFIX_SER 1.525 C CA
DFIX_SER 1.458 N CA
DFIX_SER 1.530 CA CB
DFIX_SER 1.417 CB OG
DANG_SER 2.401 O CA
DANG_SER 2.462 C N
DANG_SER 2.504 C CB
DANG_SER 2.455 N CB
DANG_SER 2.431 CA OG
 
SADI_SO4 S O1 S O2 S O3 S O4
SADI_SO4 O1 O2 O1 O3 O1 O4 O2 O3 O2 O4 O3 O4
 
CHIV_THR C
CHIV_THR 2.516 CA
CHIV_THR -2.628 CB
DFIX_THR 1.231 C O
DFIX_THR 1.525 C CA
DFIX_THR 1.458 N CA
DFIX_THR 1.540 CA CB
DFIX_THR 1.433 CB OG1
DFIX_THR 1.521 CB CG2
DANG_THR 2.401 O CA
DANG_THR 2.462 C N
DANG_THR 2.497 C CB
DANG_THR 2.479 N CB
DANG_THR 2.430 CA OG1
DANG_THR 2.515 CA CG2
DANG_THR 2.373 OG1 CG2
 
FLAT_TRP CB CE2 CZ3 CG CD1 NE1 CD2 CZ2 CH2 CE3
CHIV_TRP C
CHIV_TRP 2.503 CA
DFIX_TRP 1.231 C O
DFIX_TRP 1.525 C CA
DFIX_TRP 1.458 N CA
DFIX_TRP 1.530 CA CB
DFIX_TRP 1.498 CB CG
DFIX_TRP 1.365 CG CD1
DFIX_TRP 1.374 CD1 NE1
DFIX_TRP 1.370 NE1 CE2
DFIX_TRP 1.394 CE2 CZ2
DFIX_TRP 1.368 CZ2 CH2
DFIX_TRP 1.400 CH2 CZ3
DFIX_TRP 1.382 CZ3 CE3
DFIX_TRP 1.398 CE3 CD2
DFIX_TRP 1.433 CD2 CG
DFIX_TRP 1.409 CD2 CE2
DANG_TRP 2.401 O CA
DANG_TRP 2.462 C N
DANG_TRP 2.504 C CB
DANG_TRP 2.455 N CB
DANG_TRP 2.534 CA CG
DANG_TRP 2.562 CB CD1
DANG_TRP 2.621 CB CD2
DANG_TRP 2.246 CG NE1
DANG_TRP 2.605 CG CE3
DANG_TRP 2.288 CG CE2
DANG_TRP 2.233 CD1 CE2
DANG_TRP 2.239 CD1 CD2
DANG_TRP 2.240 NE1 CD2
DANG_TRP 2.361 CE2 CH2
DANG_TRP 2.416 CE2 CE3
DANG_TRP 2.390 CD2 CZ3
DANG_TRP 2.456 CD2 CZ2
DANG_TRP 2.423 CE3 CH2
DANG_TRP 2.415 CZ3 CZ2
DANG_TRP 2.506 NE1 CZ2
 
FLAT_TYR CB CD1 CE2 CG CD2 CE1 CZ OH
CHIV_TYR C
CHIV_TYR 2.503 CA
DFIX_TYR 1.231 C O
DFIX_TYR 1.458 N CA
DFIX_TYR 1.525 C CA
DFIX_TYR 1.530 CA CB
DFIX_TYR 1.512 CB CG
DFIX_TYR 1.389 CG CD2 CG CD1
DFIX_TYR 1.382 CD2 CE2 CD1 CE1
DFIX_TYR 1.378 CE2 CZ CE1 CZ
DFIX_TYR 1.376 CZ OH
DANG_TYR 2.401 O CA
DANG_TYR 2.462 C N
DANG_TYR 2.455 N CB
DANG_TYR 2.504 C CB
DANG_TYR 2.550 CA CG
DANG_TYR 2.523 CB CD1 CB CD2
DANG_TYR 2.414 CG CE1 CG CE2
DANG_TYR 2.385 CZ CD1 CZ CD2
DANG_TYR 2.384 OH CE1 OH CE2
DANG_TYR 2.382 CD1 CD2
DANG_TYR 2.390 CE1 CE2
 
CHIV_VAL C
CHIV_VAL 2.516 CA
CHIV_VAL -2.622 CB
DFIX_VAL 1.231 C O
DFIX_VAL 1.458 N CA
DFIX_VAL 1.525 C CA
DFIX_VAL 1.540 CA CB
DFIX_VAL 1.521 CB CG2 CB CG1
DANG_VAL 2.401 O CA
DANG_VAL 2.462 C N
DANG_VAL 2.497 C CB
DANG_VAL 2.515 CA CG1 CA CG2
DANG_VAL 2.479 N CB
DANG_VAL 2.504 CG1 CG2
 
DFIX 2.031 SG_7 SG_137 SG_25 SG_41 SG_109 SG_210 SG_116 SG_183 SG_148 SG_162
DFIX 2.031 SG_173 SG_197
DANG 3.035 CB_7 SG_137 SG_7 CB_137 CB_25 SG_41 SG_25 CB_41 CB_109 SG_210
DANG 3.035 SG_109 CB_210 CB_116 SG_183 SG_116 CB_183 CB_148 SG_162
DANG 3.035 SG_148 CB_162 CB_173 SG_197 SG_173 CB_197
DFIX_223 1.249 C OT1 C OT2
DANG_223 2.379 CA OT1 CA OT2
DANG_223 2.194 OT1 OT2
 
WGHT    0.100000
SWAT    1.037964    3.6659
FVAR       0.05519
RESI    1   ILE
N     3    0.788320    1.112503    0.108369    11.00000    0.11910    0.13742 =
         0.13161   -0.00771   -0.01013    0.03549
AFIX  33
H0A   2    0.774917    1.099100    0.103650    11.00000   -1.50000
H0B   2    0.801916    1.125177    0.103473    11.00000   -1.50000
H0C   2    0.780961    1.120913    0.112884    11.00000   -1.50000
AFIX   0
CA    1    0.800167    1.099805    0.116797    11.00000    0.12650    0.13388 =
         0.14454    0.00750   -0.00843    0.03250
AFIX  13
HA    2    0.785254    1.086284    0.122341    11.00000   -1.20000
AFIX   0
CB    1    0.812865    1.084553    0.109464    11.00000    0.14914    0.13260 =
         0.14498    0.01104   -0.01717    0.04799
AFIX  13
HB    2    0.827523    1.098813    0.104054    11.00000   -1.20000
AFIX   0
CG2   1    0.827674    1.073913    0.118040    11.00000    0.10944    0.25326 =
         0.25717    0.05335   -0.01854    0.07984
AFIX  33
HG2A  2    0.841170    1.089178    0.123126    11.00000   -1.50000
HG2B  2    0.837195    1.066581    0.113086    11.00000   -1.50000
HG2C  2    0.814018    1.059255    0.123328    11.00000   -1.50000
AFIX   0
CG1   1    0.791692    1.061319    0.100721    11.00000    0.11034    0.11399 =
         0.22261   -0.01172   -0.01678    0.03308
AFIX  23
HG1A  2    0.782502    1.069158    0.095697    11.00000   -1.20000
HG1B  2    0.802118    1.056039    0.095049    11.00000   -1.20000
AFIX   0
CD1   1    0.769071    1.034813    0.107037    11.00000    0.14336    0.11447 =
         0.25275    0.01752    0.01775    0.06379
AFIX  33
HD1A  2    0.756643    1.021965    0.100806    11.00000   -1.50000
HD1B  2    0.758494    1.039627    0.112691    11.00000   -1.50000
HD1C  2    0.777744    1.026056    0.111615    11.00000   -1.50000
AFIX   0
C     1    0.823047    1.123176    0.124618    11.00000    0.15787    0.12030 =
         0.14882    0.01210   -0.03324    0.04159
O     4    0.842024    1.143658    0.119164    11.00000    0.14090    0.11878 =
         0.18071    0.00523   -0.02108    0.03812
 
RESI    2   VAL
N     3    0.820965    1.119666    0.136959    11.00000    0.15249    0.16035 =
         0.14931   -0.01411   -0.01605    0.05952
AFIX  43
H0    2    0.806449    1.105038    0.139971    11.00000   -1.20000
AFIX   0
CA    1    0.842267    1.139580    0.145646    11.00000    0.16215    0.18416 =
         0.14499   -0.00524   -0.03236    0.06717
AFIX  13
HA    2    0.854819    1.157039    0.141138    11.00000   -1.20000
AFIX   0
C     1    0.859738    1.127340    0.151001    11.00000    0.13331    0.19459 =
         0.17516    0.02813   -0.00743    0.05335
O     4    0.848197    1.103021    0.154781    11.00000    0.16134    0.20078 =
         0.19428    0.04586   -0.01800    0.06062
CB    1    0.828247    1.146463    0.156532    11.00000    0.16289    0.17167 =
         0.14827   -0.01485   -0.02638    0.05413
AFIX  13
HB    2    0.815712    1.128952    0.161010    11.00000   -1.20000
AFIX   0
CG1   1    0.850803    1.166630    0.165524    11.00000    0.18877    0.12290 =
         0.19528   -0.02354   -0.04130    0.04122
AFIX  33
HG1A  2    0.861758    1.158456    0.168389    11.00000   -1.50000
HG1B  2    0.842029    1.170092    0.172557    11.00000   -1.50000
HG1C  2    0.862894    1.184101    0.161316    11.00000   -1.50000
AFIX   0
CG2   1    0.810804    1.159077    0.151631    11.00000    0.17487    0.24381 =
         0.18631    0.01314    0.00255    0.09530
AFIX  33
HG2A  2    0.796729    1.146060    0.145940    11.00000   -1.50000
HG2B  2    0.822910    1.176434    0.147345    11.00000   -1.50000
HG2C  2    0.801781    1.162684    0.158520    11.00000   -1.50000
AFIX   0
 
RESI    3   GLY
N     3    0.887520    1.144195    0.150919    11.00000    0.13375    0.20798 =
         0.21479   -0.02222   -0.05502    0.03584
AFIX  43
H0    2    0.894720    1.160689    0.147607    11.00000   -1.20000
AFIX   0
CA    1    0.906029    1.134870    0.156442    11.00000    0.11981    0.22373 =
         0.27961    0.00117   -0.06780    0.02371
AFIX  23
HA1   2    0.898066    1.125517    0.164344    11.00000   -1.20000
HA2   2    0.924301    1.151243    0.158164    11.00000   -1.20000
AFIX   0
C     1    0.909968    1.114855    0.147952    11.00000    0.11088    0.18259 =
         0.28975    0.04601   -0.04003    0.01888
O     4    0.918863    1.099939    0.152368    11.00000    0.18351    0.22650 =
         0.31652    0.06613   -0.05638    0.06258
 
RESI    4   GLY
N     3    0.903253    1.114451    0.135922    11.00000    0.10648    0.21870 =
         0.27315    0.04290   -0.00284    0.08117
AFIX  43
H0    2    0.897352    1.125518    0.133398    11.00000   -1.20000
AFIX   0
CA    1    0.905671    1.095706    0.126941    11.00000    0.13895    0.16811 =
         0.31649    0.05559    0.04753    0.04805
AFIX  23
HA1   2    0.889408    1.087910    0.121431    11.00000   -1.20000
HA2   2    0.905315    1.080146    0.131450    11.00000   -1.20000
AFIX   0
C     1    0.932063    1.109924    0.119106    11.00000    0.10216    0.19534 =
         0.23509    0.05640   -0.00193    0.05487
O     4    0.953565    1.131603    0.122556    11.00000    0.09865    0.28436 =
         0.23763    0.00433    0.00298    0.03565
 
RESI    5   TYR
N     3    0.930924    1.097432    0.108239    11.00000    0.10960    0.17931 =
         0.29806    0.01614    0.00877    0.04054
AFIX  43
H0    2    0.915483    1.082724    0.105992    11.00000   -1.20000
AFIX   0
CA    1    0.955692    1.108500    0.100097    11.00000    0.11798    0.18416 =
         0.25908    0.01822   -0.00123    0.05609
AFIX  13
HA    2    0.967969    1.128521    0.102069    11.00000   -1.20000
AFIX   0
C     1    0.946370    1.106217    0.086497    11.00000    0.13526    0.18003 =
         0.28320    0.08822   -0.01399    0.05058
O     4    0.922029    1.089768    0.083344    11.00000    0.12251    0.22730 =
         0.23486    0.03754    0.00046    0.07963
CB    1    0.972710    1.093418    0.102043    11.00000    0.12709    0.23915 =
         0.25401    0.08420    0.01304    0.08172
AFIX  23
HB1   2    0.989081    1.101907    0.096595    11.00000   -1.20000
HB2   2    0.979410    1.096241    0.110621    11.00000   -1.20000
AFIX   0
CG    1    0.955834    1.062046    0.099393    11.00000    0.13862    0.23370 =
         0.27512    0.07699   -0.03174    0.11136
CD1   1    0.939005    1.044006    0.108804    11.00000    0.15275    0.24022 =
         0.31952    0.09554   -0.04366    0.04643
AFIX  43
HD1   2    0.938170    1.051144    0.116596    11.00000   -1.20000
AFIX   0
CD2   1    0.956567    1.050922    0.087751    11.00000    0.12133    0.32097 =
         0.39862   -0.01479    0.03461    0.10434
AFIX  43
HD2   2    0.967747    1.062970    0.081406    11.00000   -1.20000
AFIX   0
CE1   1    0.923411    1.015198    0.106503    11.00000    0.14163    0.22651 =
         0.46159    0.08287    0.06159    0.11621
AFIX  43
HE1   2    0.912238    1.003003    0.112810    11.00000   -1.20000
AFIX   0
CE2   1    0.940894    1.022194    0.085490    11.00000    0.16494    0.31982 =
         0.37068   -0.01338   -0.06089    0.16176
AFIX  43
HE2   2    0.941480    1.014869    0.077710    11.00000   -1.20000
AFIX   0
CZ    1    0.924389    1.004651    0.095011    11.00000    0.21558    0.29379 =
         0.45948    0.04072   -0.00947    0.17969
OH    4    0.908570    0.975907    0.092850    11.00000    0.21731    0.31398 =
         0.51306    0.00027   -0.01539    0.16453
AFIX  83
HH    2    0.910530    0.972592    0.085545    11.00000   -1.50000
AFIX   0
 
RESI    6   THR
N     3    0.965188    1.122664    0.078107    11.00000    0.13754    0.21675 =
         0.28526    0.06838    0.01645    0.07999
AFIX  43
H0    2    0.981723    1.135311    0.080545    11.00000   -1.20000
AFIX   0
CA    1    0.958374    1.119730    0.064716    11.00000    0.09654    0.17739 =
         0.27989    0.04973    0.03350    0.03776
AFIX  13
HA    2    0.941319    1.121006    0.063429    11.00000   -1.20000
AFIX   0
C     1    0.953476    1.091770    0.059652    11.00000    0.14275    0.17034 =
         0.35222    0.04162    0.00623    0.04930
O     4    0.972876    1.086040    0.060276    11.00000    0.18395    0.22617 =
         0.26524    0.02276    0.00412    0.10095
CB    1    0.982982    1.143604    0.057383    11.00000    0.10012    0.18050 =
         0.30414    0.06615    0.02431    0.01905
AFIX  13
HB    2    1.000290    1.142784    0.058655    11.00000   -1.20000
AFIX   0
OG1   4    0.986400    1.169652    0.062237    11.00000    0.16790    0.18238 =
         0.27887    0.04606   -0.00896    0.02320
AFIX  83
HG1   2    0.989239    1.170421    0.069804    11.00000   -1.50000
AFIX   0
CG2   1    0.976147    1.141888    0.043490    11.00000    0.24906    0.23843 =
         0.27395    0.05025    0.07004    0.09493
AFIX  33
HG2A  2    0.991647    1.157114    0.039154    11.00000   -1.50000
HG2B  2    0.959467    1.143243    0.042345    11.00000   -1.50000
HG2C  2    0.973013    1.124224    0.040202    11.00000   -1.50000
AFIX   0
 
RESI    7   CYS
N     3    0.928970    1.074042    0.054495    11.00000    0.14405    0.20021 =
         0.25635    0.02188    0.03042    0.04725
AFIX  43
H0    2    0.916402    1.078974    0.053667    11.00000   -1.20000
AFIX   0
CA    1    0.922744    1.046008    0.050135    11.00000    0.14311    0.20783 =
         0.26337    0.02401    0.02103    0.06628
AFIX  13
HA    2    0.923486    1.035199    0.057296    11.00000   -1.20000
AFIX   0
C     1    0.943386    1.047544    0.040174    11.00000    0.13244    0.24704 =
         0.30882    0.01256    0.02021    0.08676
O     4    0.953104    1.031577    0.040719    11.00000    0.14310    0.25916 =
         0.33959   -0.00293   -0.00486    0.09796
CB    1    0.892715    1.031626    0.045071    11.00000    0.12082    0.19162 =
         0.29638    0.01383    0.04247    0.04085
AFIX  23
HB1   2    0.888047    1.012954    0.042228    11.00000   -1.20000
HB2   2    0.892631    1.042089    0.037755    11.00000   -1.20000
AFIX   0
SG    5    0.865114    1.027756    0.055157    11.00000    0.14994    0.18972 =
         0.22952    0.01185    0.00927    0.09181
 
RESI    8   GLY
N     3    0.950413    1.066285    0.031040    11.00000    0.12873    0.22224 =
         0.24471   -0.02852    0.02200    0.07519
AFIX  43
H0    2    0.945771    1.079036    0.032008    11.00000   -1.20000
AFIX   0
CA    1    0.965241    1.067429    0.019505    11.00000    0.14799    0.26659 =
         0.27954   -0.04791    0.03285    0.12031
AFIX  23
HA1   2    0.974086    1.055934    0.020236    11.00000   -1.20000
HA2   2    0.979681    1.086679    0.017661    11.00000   -1.20000
AFIX   0
C     1    0.942785    1.055974    0.009243    11.00000    0.13404    0.24076 =
         0.24509   -0.04073    0.06289    0.08955
O     4    0.918168    1.036769    0.011194    11.00000    0.14379    0.19824 =
         0.31550    0.04820    0.02642    0.08929
 
RESI    9   ALA
N     3    0.951362    1.068417   -0.001780    11.00000    0.15444    0.29111 =
         0.24488   -0.02945    0.06969    0.07739
AFIX  43
H0    2    0.968820    1.080670   -0.003020    11.00000   -1.20000
AFIX   0
CA    1    0.930832    1.061048   -0.011733    11.00000    0.15730    0.17129 =
         0.30429    0.03066    0.04375    0.05815
AFIX  13
HA    2    0.916997    1.066430   -0.009133    11.00000   -1.20000
AFIX   0
C     1    0.915275    1.029812   -0.014749    11.00000    0.12361    0.18139 =
         0.29623    0.00552    0.09480    0.05889
O     4    0.928337    1.017447   -0.017435    11.00000    0.13051    0.21109 =
         0.35297    0.01223    0.07567    0.08506
CB    1    0.946119    1.078086   -0.023344    11.00000    0.19284    0.16658 =
         0.27832   -0.00229    0.05067    0.04036
AFIX  33
HB1   2    0.956107    1.097812   -0.021308    11.00000   -1.50000
HB2   2    0.932622    1.074651   -0.029828    11.00000   -1.50000
HB3   2    0.959249    1.072519   -0.026203    11.00000   -1.50000
AFIX   0
 
RESI   10   ASN
N     3    0.887327    1.017585   -0.014626    11.00000    0.12138    0.15046 =
         0.30132    0.03692    0.08189    0.06416
AFIX  43
H0    2    0.880015    1.027367   -0.012004    11.00000   -1.20000
AFIX   0
CA    1    0.868048    0.988416   -0.018680    11.00000    0.14954    0.15572 =
         0.28314    0.01486    0.04550    0.07735
AFIX  13
HA    2    0.848859    0.985049   -0.017464    11.00000   -1.20000
AFIX   0
C     1    0.870422    0.966481   -0.010829    11.00000    0.20175    0.17193 =
         0.31913    0.03177    0.06698    0.11156
O     4    0.861888    0.942651   -0.015170    11.00000    0.24062    0.17558 =
         0.32946    0.04245    0.11601    0.12389
CB    1    0.871366    0.985126   -0.032892    11.00000    0.23259    0.16554 =
         0.29886    0.03427    0.10650    0.08519
AFIX  23
HB1   2    0.889556    0.986739   -0.034507    11.00000   -1.20000
HB2   2    0.856780    0.966653   -0.035676    11.00000   -1.20000
AFIX   0
CG    1    0.869076    1.007772   -0.040012    11.00000    0.22746    0.22480 =
         0.25461    0.02358    0.10877    0.13655
OD1   4    0.846748    1.008221   -0.040015    11.00000    0.18299    0.22089 =
         0.33905   -0.04954    0.02770    0.08929
ND2   3    0.891960    1.027240   -0.045632    11.00000    0.22366    0.18103 =
         0.23168    0.02682    0.08163    0.13723
AFIX  93
HD2A  2    0.891704    1.040906   -0.049486    11.00000   -1.20000
HD2B  2    0.907179    1.026304   -0.045452    11.00000   -1.20000
AFIX   0
 
RESI   11   THR
N     3    0.880656    0.973032    0.000688    11.00000    0.14723    0.19221 =
         0.30640    0.05751    0.08497    0.11357
AFIX  43
H0    2    0.886837    0.990027    0.003244    11.00000   -1.20000
AFIX   0
CA    1    0.882016    0.953269    0.009180    11.00000    0.14480    0.20285 =
         0.34059    0.05838    0.09504    0.14164
AFIX  13
HA    2    0.888038    0.941929    0.004387    11.00000   -1.20000
AFIX   0
C     1    0.853433    0.933200    0.015032    11.00000    0.12834    0.20384 =
         0.23550    0.04104    0.03725    0.10830
O     4    0.850995    0.912802    0.021007    11.00000    0.14407    0.17614 =
         0.39085    0.06218    0.05400    0.10956
CB    1    0.903618    0.968205    0.019737    11.00000    0.10967    0.18130 =
         0.41083    0.11708    0.05863    0.08863
AFIX  13
HB    2    0.902311    0.954328    0.025897    11.00000   -1.20000
AFIX   0
OG1   4    0.898041    0.988260    0.025617    11.00000    0.16592    0.21276 =
         0.37205    0.03063   -0.01747    0.10254
AFIX  83
HG1   2    0.911971    1.004035    0.025033    11.00000   -1.50000
AFIX   0
CG2   1    0.933094    0.983601    0.014103    11.00000    0.13543    0.25517 =
         0.54273    0.15833    0.11201    0.07929
AFIX  33
HG2A  2    0.946727    0.992704    0.020647    11.00000   -1.50000
HG2B  2    0.934371    0.997497    0.008245    11.00000   -1.50000
HG2C  2    0.936782    0.970313    0.009862    11.00000   -1.50000
AFIX   0
 
RESI   12   VAL
N     3    0.833212    0.939315    0.013606    11.00000    0.11009    0.16684 =
         0.23227    0.04826    0.05879    0.08450
AFIX  43
H0    2    0.837050    0.954239    0.009420    11.00000   -1.20000
AFIX   0
CA    1    0.804636    0.922505    0.018643    11.00000    0.11566    0.12740 =
         0.22965    0.02756    0.05547    0.06638
AFIX  13
HA    2    0.802258    0.904629    0.021798    11.00000   -1.20000
AFIX   0
C     1    0.784619    0.916312    0.007695    11.00000    0.09687    0.15394 =
         0.20497    0.00990    0.07713    0.07172
O     4    0.771488    0.929011    0.006623    11.00000    0.11238    0.15465 =
         0.19403    0.01185    0.06164    0.07763
CB    1    0.800023    0.938051    0.029436    11.00000    0.12165    0.14674 =
         0.20293    0.02724    0.05531    0.06466
AFIX  13
HB    2    0.799519    0.954361    0.025956    11.00000   -1.20000
AFIX   0
CG1   1    0.772170    0.919611    0.036252    11.00000    0.13195    0.21530 =
         0.19316    0.05774    0.06429    0.06741
AFIX  33
HG1A  2    0.770000    0.930303    0.042843    11.00000   -1.50000
HG1B  2    0.772195    0.903467    0.039750    11.00000   -1.50000
HG1C  2    0.756814    0.913475    0.030444    11.00000   -1.50000
AFIX   0
CG2   1    0.824286    0.948943    0.038893    11.00000    0.13810    0.14574 =
         0.22237    0.03309    0.04046    0.06085
AFIX  33
HG2A  2    0.841750    0.961292    0.034735    11.00000   -1.50000
HG2B  2    0.825181    0.933287    0.042433    11.00000   -1.50000
HG2C  2    0.821132    0.959077    0.045438    11.00000   -1.50000
AFIX   0
 
RESI   13   PRO
N     3    0.783921    0.898332   -0.000877    11.00000    0.11568    0.13505 =
         0.24563    0.00028    0.06714    0.06696
CA    1    0.770915    0.896897   -0.012974    11.00000    0.12790    0.15302 =
         0.23150   -0.03384    0.06307    0.07168
AFIX  13
HA    2    0.778967    0.915937   -0.016471    11.00000   -1.20000
AFIX   0
C     1    0.739020    0.882859   -0.012911    11.00000    0.12718    0.10852 =
         0.22165   -0.03975    0.05663    0.06287
O     4    0.727738    0.884614   -0.022618    11.00000    0.12479    0.11225 =
         0.22176   -0.03220    0.05603    0.04686
CB    1    0.781301    0.879826   -0.020699    11.00000    0.16453    0.19581 =
         0.26962   -0.02780    0.08393    0.11401
AFIX  23
HB1   2    0.767843    0.868959   -0.027204    11.00000   -1.20000
HB2   2    0.799416    0.892283   -0.024547    11.00000   -1.20000
AFIX   0
CG    1    0.783729    0.861077   -0.011504    11.00000    0.23535    0.19928 =
         0.29314   -0.01880    0.09272    0.14330
AFIX  23
HG1   2    0.795877    0.854229   -0.014596    11.00000   -1.20000
HG2   2    0.765371    0.845091   -0.009521    11.00000   -1.20000
AFIX   0
CD    1    0.796539    0.879875   -0.000253    11.00000    0.19090    0.18386 =
         0.28118    0.00011    0.08577    0.12768
AFIX  23
HD1   2    0.791373    0.869011    0.007444    11.00000   -1.20000
HD2   2    0.816937    0.890761   -0.000886    11.00000   -1.20000
AFIX   0
 
RESI   14   TYR
N     3    0.725243    0.870025   -0.002431    11.00000    0.12261    0.11670 =
         0.24361   -0.00257    0.05237    0.06065
AFIX  43
H0    2    0.734668    0.868458    0.003651    11.00000   -1.20000
AFIX   0
CA    1    0.694866    0.858499   -0.000804    11.00000    0.11552    0.08352 =
         0.19073    0.01209    0.03191    0.04680
AFIX  13
HA    2    0.685824    0.852112   -0.009001    11.00000   -1.20000
AFIX   0
C     1    0.688079    0.880377    0.004072    11.00000    0.11443    0.07613 =
         0.19148    0.02803    0.05521    0.04044
O     4    0.663008    0.874482    0.004444    11.00000    0.12451    0.11127 =
         0.15446   -0.00367    0.04299    0.05726
CB    1    0.681880    0.832871    0.008194    11.00000    0.17457    0.07365 =
         0.18163    0.00913    0.02498    0.04640
AFIX  23
HB1   2    0.662492    0.827650    0.009981    11.00000   -1.20000
HB2   2    0.681725    0.816966    0.004108    11.00000   -1.20000
AFIX   0
CG    1    0.697756    0.838899    0.020174    11.00000    0.11349    0.10097 =
         0.17205    0.01012    0.05376    0.04799
CD1   1    0.691044    0.850366    0.030331    11.00000    0.11764    0.17777 =
         0.16026    0.01032    0.05349    0.08101
AFIX  43
HD1   2    0.676305    0.854166    0.029820    11.00000   -1.20000
AFIX   0
CD2   1    0.720306    0.834288    0.021484    11.00000    0.13648    0.12825 =
         0.20914    0.02009    0.06589    0.07441
AFIX  43
HD2   2    0.725114    0.827017    0.014650    11.00000   -1.20000
AFIX   0
CE1   1    0.706606    0.855974    0.041138    11.00000    0.11092    0.14996 =
         0.17919   -0.00732    0.03273    0.07927
AFIX  43
HE1   2    0.702141    0.863582    0.047955    11.00000   -1.20000
AFIX   0
CE2   1    0.735826    0.839679    0.032077    11.00000    0.10517    0.11229 =
         0.24883    0.00570    0.04923    0.06598
AFIX  43
HE2   2    0.750741    0.836136    0.032544    11.00000   -1.20000
AFIX   0
CZ    1    0.728618    0.850664    0.042174    11.00000    0.11607    0.13751 =
         0.21114    0.01746    0.04657    0.07498
OH    4    0.744187    0.856437    0.052930    11.00000    0.11612    0.17079 =
         0.21449    0.04295    0.04764    0.09611
AFIX  83
HH    2    0.756573    0.852350    0.051944    11.00000   -1.50000
AFIX   0
 
RESI   15   GLN
N     3    0.709080    0.905073    0.008103    11.00000    0.12794    0.08921 =
         0.17260    0.00964    0.04099    0.05330
AFIX  43
H0    2    0.726037    0.907995    0.007796    11.00000   -1.20000
AFIX   0
CA    1    0.704498    0.927237    0.012990    11.00000    0.11283    0.11921 =
         0.14378   -0.01035    0.02666    0.06583
AFIX  13
HA    2    0.688982    0.919074    0.019051    11.00000   -1.20000
AFIX   0
C     1    0.697241    0.941495    0.002547    11.00000    0.12493    0.09905 =
         0.12651   -0.00821    0.05101    0.06817
O     4    0.713382    0.951262   -0.006515    11.00000    0.12995    0.13210 =
         0.13517   -0.00812    0.05077    0.06331
CB    1    0.731286    0.950429    0.019485    11.00000    0.11615    0.10695 =
         0.17323   -0.00331    0.02642    0.04849
AFIX  23
HB1   2    0.734703    0.942888    0.027083    11.00000   -1.20000
HB2   2    0.747383    0.956260    0.013992    11.00000   -1.20000
AFIX   0
CG    1    0.728251    0.976109    0.022744    11.00000    0.10116    0.10637 =
         0.16624   -0.00703    0.00574    0.04802
AFIX  23
HG1   2    0.747050    0.992414    0.023331    11.00000   -1.20000
HG2   2    0.718870    0.979406    0.015786    11.00000   -1.20000
AFIX   0
CD    1    0.712656    0.974854    0.034466    11.00000    0.12057    0.09472 =
         0.18582    0.01074    0.02301    0.05835
OE1   4    0.693069    0.979276    0.036595    11.00000    0.13219    0.13493 =
         0.21661   -0.00942    0.02211    0.07966
NE2   3    0.722353    0.968233    0.044068    11.00000    0.09334    0.08941 =
         0.16521   -0.00478    0.03601    0.04414
AFIX  93
HE2A  2    0.715155    0.967155    0.051347    11.00000   -1.20000
HE2B  2    0.736030    0.964886    0.043205    11.00000   -1.20000
AFIX   0
 
RESI   16   VAL
N     3    0.673225    0.941700    0.003791    11.00000    0.10040    0.08878 =
         0.16510    0.01953    0.04149    0.04707
AFIX  43
H0    2    0.661996    0.932663    0.009868    11.00000   -1.20000
AFIX   0
CA    1    0.665688    0.957287   -0.005158    11.00000    0.15723    0.10372 =
         0.14002   -0.01230    0.00268    0.07081
AFIX  13
HA    2    0.680860    0.965893   -0.011371    11.00000   -1.20000
AFIX   0
C     1    0.664300    0.981186    0.001646    11.00000    0.13204    0.09871 =
         0.13531    0.00176    0.01521    0.06175
O     4    0.661436    0.981001    0.013023    11.00000    0.11689    0.11349 =
         0.12662    0.01311    0.02462    0.06879
CB    1    0.638223    0.938145   -0.012193    11.00000    0.13299    0.13361 =
         0.18536   -0.03347    0.00233    0.08003
AFIX  13
HB    2    0.636499    0.949425   -0.018895    11.00000   -1.20000
AFIX   0
CG1   1    0.637702    0.912497   -0.018374    11.00000    0.18889    0.16165 =
         0.23458   -0.08645   -0.03287    0.09824
AFIX  33
HG1A  2    0.653948    0.918794   -0.023660    11.00000   -1.50000
HG1B  2    0.620886    0.902452   -0.023314    11.00000   -1.50000
HG1C  2    0.637946    0.900240   -0.012006    11.00000   -1.50000
AFIX   0
CG2   1    0.612624    0.928105   -0.003787    11.00000    0.16533    0.15492 =
         0.17819   -0.04040    0.03376    0.03931
AFIX  33
HG2A  2    0.595837    0.916302   -0.008503    11.00000   -1.50000
HG2B  2    0.611815    0.944103   -0.000623    11.00000   -1.50000
HG2C  2    0.614019    0.917557    0.003084    11.00000   -1.50000
AFIX   0
 
RESI   17   SER
N     3    0.666981    1.001619   -0.005954    11.00000    0.13542    0.10215 =
         0.10052   -0.00533    0.03912    0.06692
AFIX  43
H0    2    0.671309    1.001188   -0.013661    11.00000   -1.20000
AFIX   0
CA    1    0.662944    1.024587   -0.001844    11.00000    0.13322    0.10595 =
         0.11461    0.00431    0.03684    0.07346
AFIX  13
HA    2    0.661214    1.024212    0.007297    11.00000   -1.20000
AFIX   0
C     1    0.635558    1.019886   -0.007862    11.00000    0.13226    0.08106 =
         0.11783   -0.00281    0.02746    0.05864
O     4    0.631835    1.014887   -0.019185    11.00000    0.10429    0.12000 =
         0.13447   -0.02921    0.01882    0.04534
CB    1    0.687966    1.052856   -0.006011    11.00000    0.13719    0.10455 =
         0.09714    0.00289    0.02518    0.06519
AFIX  23
HB1   2    0.702291    1.060289    0.000474    11.00000   -1.20000
HB2   2    0.696271    1.050313   -0.013570    11.00000   -1.20000
AFIX   0
OG    4    0.677941    1.071849   -0.008293    11.00000    0.14302    0.14224 =
         0.37879    0.09805    0.06486    0.08062
AFIX  83
HG    2    0.673589    1.076110   -0.001633    11.00000   -1.50000
AFIX   0
 
RESI   18   LEU
N     3    0.616642    1.021007   -0.000746    11.00000    0.11780    0.11137 =
         0.11637   -0.00834    0.01778    0.05606
AFIX  43
H0    2    0.619242    1.021940    0.007222    11.00000   -1.20000
AFIX   0
CA    1    0.591662    1.020784   -0.005370    11.00000    0.12632    0.10271 =
         0.11887   -0.00515    0.02403    0.06380
AFIX  13
HA    2    0.586802    1.011447   -0.013558    11.00000   -1.20000
AFIX   0
C     1    0.598648    1.051190   -0.007082    11.00000    0.09873    0.09136 =
         0.11235   -0.01204    0.01139    0.03764
O     4    0.608505    1.068235    0.001468    11.00000    0.12232    0.09349 =
         0.11516   -0.00789    0.00085    0.03854
CB    1    0.566462    1.005148    0.003324    11.00000    0.11919    0.09781 =
         0.14958    0.00102    0.02717    0.05265
AFIX  23
HB1   2    0.549931    1.003499   -0.000819    11.00000   -1.20000
HB2   2    0.569747    1.016499    0.010782    11.00000   -1.20000
AFIX   0
CG    1    0.559949    0.975768    0.007345    11.00000    0.12318    0.10005 =
         0.14295    0.00285    0.01276    0.04644
AFIX  13
HG    2    0.575571    0.977818    0.012581    11.00000   -1.20000
AFIX   0
CD1   1    0.533115    0.961514    0.015152    11.00000    0.13783    0.16097 =
         0.15312    0.02221    0.03110    0.02121
AFIX  33
HD1A  2    0.535040    0.973170    0.022226    11.00000   -1.50000
HD1B  2    0.529961    0.943543    0.018023    11.00000   -1.50000
HD1C  2    0.517412    0.958836    0.010131    11.00000   -1.50000
AFIX   0
CD2   1    0.557713    0.957916   -0.003842    11.00000    0.16460    0.09509 =
         0.21404   -0.03157    0.03363    0.03755
AFIX  33
HD2A  2    0.574957    0.967148   -0.008546    11.00000   -1.50000
HD2B  2    0.542326    0.955391   -0.009053    11.00000   -1.50000
HD2C  2    0.554434    0.939852   -0.001044    11.00000   -1.50000
AFIX   0
 
RESI   19   ASN
N     3    0.593500    1.057039   -0.018687    11.00000    0.10643    0.06706 =
         0.11788   -0.01578    0.00326    0.02080
AFIX  43
H0    2    0.585265    1.043458   -0.023976    11.00000   -1.20000
AFIX   0
CA    1    0.601297    1.085327   -0.022616    11.00000    0.11336    0.07662 =
         0.13552   -0.00403    0.01169    0.03121
AFIX  13
HA    2    0.609620    1.098099   -0.015468    11.00000   -1.20000
AFIX   0
C     1    0.576055    1.087175   -0.027254    11.00000    0.11253    0.08781 =
         0.11097   -0.00676    0.01891    0.03434
O     4    0.559333    1.070044   -0.034830    11.00000    0.14296    0.11208 =
         0.13562   -0.02673   -0.01449    0.05411
CB    1    0.623827    1.093889   -0.032846    11.00000    0.10913    0.11754 =
         0.10946    0.01380    0.00011    0.05065
AFIX  23
HB1   2    0.638851    1.091010   -0.029736    11.00000   -1.20000
HB2   2    0.615480    1.081667   -0.040041    11.00000   -1.20000
AFIX   0
CG    1    0.636346    1.124246   -0.037002    11.00000    0.11752    0.10752 =
         0.10458   -0.00440    0.03059    0.06404
OD1   4    0.622328    1.132189   -0.043215    11.00000    0.12553    0.11828 =
         0.18038    0.02872    0.02135    0.06256
ND2   3    0.662994    1.142228   -0.033913    11.00000    0.10331    0.11702 =
         0.18867    0.03404    0.04184    0.05682
AFIX  93
HD2A  2    0.670756    1.159586   -0.036209    11.00000   -1.20000
HD2B  2    0.672460    1.136498   -0.029620    11.00000   -1.20000
AFIX   0
 
RESI   20   SER
N     3    0.573825    1.108786   -0.022848    11.00000    0.11233    0.08682 =
         0.12514   -0.00779    0.00215    0.03742
AFIX  43
H0    2    0.585332    1.119678   -0.017206    11.00000   -1.20000
AFIX   0
CA    1    0.551727    1.113891   -0.027648    11.00000    0.12550    0.12583 =
         0.20066   -0.00469   -0.01800    0.05803
AFIX  13
HA    2    0.544435    1.103374   -0.035480    11.00000   -1.20000
AFIX   0
C     1    0.564705    1.145299   -0.030424    11.00000    0.13489    0.12865 =
         0.17648   -0.00128    0.00899    0.07831
O     4    0.554542    1.159945   -0.026888    11.00000    0.17403    0.18789 =
         0.22966    0.04144    0.05112    0.13378
CB    1    0.527856    1.102485   -0.018031    11.00000    0.14238    0.10869 =
         0.30118    0.02175    0.03618    0.07417
AFIX  23
HB1   2    0.511304    1.101954   -0.021605    11.00000   -1.20000
HB2   2    0.522867    1.083472   -0.015599    11.00000   -1.20000
AFIX   0
OG    4    0.537188    1.120405   -0.007505    11.00000    0.16424    0.17903 =
         0.30217   -0.00246    0.09325    0.07300
AFIX  83
HG    2    0.524265    1.115148   -0.002437    11.00000   -1.50000
AFIX   0
 
RESI   21   GLY
N     3    0.588527    1.155959   -0.037203    11.00000    0.13492    0.11829 =
         0.17209   -0.01909    0.00363    0.07800
AFIX  43
H0    2    0.593092    1.144425   -0.040458    11.00000   -1.20000
AFIX   0
CA    1    0.606878    1.185803   -0.039308    11.00000    0.14995    0.12937 =
         0.18206    0.01050   -0.00495    0.06862
AFIX  23
HA1   2    0.596662    1.195561   -0.037338    11.00000   -1.20000
HA2   2    0.611836    1.188864   -0.048116    11.00000   -1.20000
AFIX   0
C     1    0.633760    1.198564   -0.031614    11.00000    0.13099    0.11307 =
         0.16423    0.00724    0.01665    0.06661
O     4    0.653481    1.222864   -0.033354    11.00000    0.13908    0.12437 =
         0.15678    0.00996    0.02529    0.05724
 
RESI   22   TYR
N     3    0.634303    1.182142   -0.022726    11.00000    0.11584    0.09789 =
         0.15099   -0.00256    0.00760    0.04424
AFIX  43
H0    2    0.620799    1.164899   -0.022820    11.00000   -1.20000
AFIX   0
CA    1    0.654964    1.189667   -0.012794    11.00000    0.10846    0.08874 =
         0.16072   -0.00641    0.01437    0.04786
AFIX  13
HA    2    0.673902    1.198813   -0.016471    11.00000   -1.20000
AFIX   0
C     1    0.649385    1.162758   -0.006337    11.00000    0.08297    0.09014 =
         0.13631   -0.00385    0.02257    0.03642
O     4    0.624729    1.142206   -0.006444    11.00000    0.09549    0.08926 =
         0.13599   -0.00070   -0.00530    0.03584
CB    1    0.653268    1.210089   -0.003064    11.00000    0.13134    0.07429 =
         0.15745   -0.01011    0.02859    0.02553
AFIX  23
HB1   2    0.664210    1.211353    0.004302    11.00000   -1.20000
HB2   2    0.661247    1.228802   -0.006672    11.00000   -1.20000
AFIX   0
CG    1    0.622854    1.199553    0.000670    11.00000    0.13729    0.07170 =
         0.18996   -0.02318    0.03303    0.04119
CD1   1    0.606427    1.207889   -0.005839    11.00000    0.18574    0.10279 =
         0.24025   -0.02862    0.01880    0.08933
AFIX  43
HD1   2    0.613964    1.220162   -0.012595    11.00000   -1.20000
AFIX   0
CD2   1    0.611155    1.180981    0.010507    11.00000    0.16782    0.17160 =
         0.23393    0.04253    0.08979    0.09503
AFIX  43
HD2   2    0.621992    1.175121    0.014899    11.00000   -1.20000
AFIX   0
CE1   1    0.578940    1.197987   -0.002295    11.00000    0.17982    0.16759 =
         0.20174   -0.04304   -0.01951    0.10194
AFIX  43
HE1   2    0.568030    1.203907   -0.006585    11.00000   -1.20000
AFIX   0
CE2   1    0.583506    1.171060    0.013864    11.00000    0.16081    0.12894 =
         0.29117    0.04818    0.08608    0.08503
AFIX  43
HE2   2    0.575711    1.158530    0.020520    11.00000   -1.20000
AFIX   0
CZ    1    0.567465    1.179572    0.007442    11.00000    0.15763    0.13469 =
         0.26679   -0.02226    0.01204    0.06870
OH    4    0.539970    1.168705    0.011062    11.00000    0.15168    0.22897 =
         0.28868   -0.06619    0.00578    0.08708
AFIX  83
HH    2    0.532293    1.174958    0.006524    11.00000   -1.50000
AFIX   0
 
RESI   23   HIS
N     3    0.669888    1.161990   -0.000313    11.00000    0.08034    0.09342 =
         0.15386    0.01016    0.02307    0.03293
AFIX  43
H0    2    0.686742    1.176094   -0.000959    11.00000   -1.20000
AFIX   0
CA    1    0.665080    1.138032    0.007444    11.00000    0.09961    0.10655 =
         0.10765    0.01727   -0.00034    0.01192
AFIX  13
HA    2    0.655032    1.120715    0.002482    11.00000   -1.20000
AFIX   0
C     1    0.647160    1.135933    0.018611    11.00000    0.10354    0.08723 =
         0.14467    0.00399    0.01138    0.02322
O     4    0.653754    1.156379    0.025754    11.00000    0.10805    0.08783 =
         0.18420   -0.00785    0.01214    0.02244
CB    1    0.693603    1.141574    0.011695    11.00000    0.10761    0.07069 =
         0.11834    0.00457    0.01373    0.02519
AFIX  23
HB1   2    0.702570    1.138143    0.004608    11.00000   -1.20000
HB2   2    0.705771    1.160899    0.014393    11.00000   -1.20000
AFIX   0
CG    1    0.690841    1.122091    0.022155    11.00000    0.09895    0.07785 =
         0.14240    0.02524    0.03605    0.04017
ND1   3    0.685114    1.095062    0.021676    11.00000    0.11856    0.07975 =
         0.17107    0.01243    0.00960    0.04044
AFIX  43
HD1   2    0.683308    1.087187    0.014503    11.00000   -1.20000
AFIX   0
CE1   1    0.682319    1.080926    0.031626    11.00000    0.14818    0.07922 =
         0.17051    0.03961    0.03667    0.03946
AFIX  43
HE1   2    0.678309    1.062423    0.032707    11.00000   -1.20000
AFIX   0
NE2   3    0.686924    1.100885    0.039980    11.00000    0.12840    0.09951 =
         0.16292    0.02212    0.00061    0.05453
CD2   1    0.691616    1.125057    0.034714    11.00000    0.19822    0.11432 =
         0.13472    0.02272    0.02409    0.08905
AFIX  43
HD2   2    0.694868    1.141203    0.039001    11.00000   -1.20000
AFIX   0
 
RESI   24   PHE
N     3    0.625109    1.110929    0.021217    11.00000    0.10413    0.08528 =
         0.12548    0.00059    0.02455    0.02516
AFIX  43
H0    2    0.619902    1.096812    0.016249    11.00000   -1.20000
AFIX   0
CA    1    0.609966    1.108294    0.032892    11.00000    0.12286    0.06479 =
         0.12820   -0.01581    0.02211    0.03699
AFIX  13
HA    2    0.621748    1.125093    0.037953    11.00000   -1.20000
AFIX   0
C     1    0.604105    1.082732    0.040616    11.00000    0.13226    0.07260 =
         0.14758    0.01154    0.04814    0.03909
O     4    0.594952    1.082062    0.051368    11.00000    0.18383    0.11807 =
         0.14179    0.00493    0.04741    0.07750
CB    1    0.582356    1.107722    0.030238    11.00000    0.12336    0.12072 =
         0.14975    0.02085    0.04216    0.05308
AFIX  23
HB1   2    0.574342    1.109174    0.038114    11.00000   -1.20000
HB2   2    0.586328    1.124095    0.025236    11.00000   -1.20000
AFIX   0
CG    1    0.560617    1.081311    0.023421    11.00000    0.09732    0.12707 =
         0.17770    0.01734    0.03468    0.06028
CD1   1    0.540492    1.057885    0.029684    11.00000    0.10063    0.12233 =
         0.19105    0.02858    0.03958    0.05870
AFIX  43
HD1   2    0.540315    1.058192    0.038390    11.00000   -1.20000
AFIX   0
CD2   1    0.559795    1.080190    0.010629    11.00000    0.12370    0.13737 =
         0.17379    0.01114    0.02056    0.04625
AFIX  43
HD2   2    0.572598    1.095973    0.006110    11.00000   -1.20000
AFIX   0
CE1   1    0.520489    1.033868    0.023548    11.00000    0.08787    0.14241 =
         0.20327    0.02609    0.02011    0.06141
AFIX  43
HE1   2    0.507144    1.018523    0.028131    11.00000   -1.20000
AFIX   0
CE2   1    0.540581    1.056397    0.004217    11.00000    0.09498    0.14193 =
         0.19896   -0.00189    0.04312    0.03645
AFIX  43
HE2   2    0.541192    1.056236   -0.004485    11.00000   -1.20000
AFIX   0
CZ    1    0.520334    1.032668    0.010521    11.00000    0.11139    0.14054 =
         0.20133    0.02223    0.03554    0.05452
AFIX  43
HZ    2    0.507225    1.016653    0.006223    11.00000   -1.20000
AFIX   0
 
RESI   25   CYS
N     3    0.607166    1.062312    0.036181    11.00000    0.12922    0.09288 =
         0.10352    0.01479    0.02844    0.05988
AFIX  43
H0    2    0.612982    1.063568    0.028600    11.00000   -1.20000
AFIX   0
CA    1    0.601110    1.036952    0.043566    11.00000    0.13407    0.09704 =
         0.13384    0.01173    0.01696    0.06875
AFIX  13
HA    2    0.608876    1.042906    0.052004    11.00000   -1.20000
AFIX   0
C     1    0.615830    1.022963    0.037321    11.00000    0.09950    0.06207 =
         0.10132   -0.00814   -0.00171    0.02770
O     4    0.622362    1.028341    0.026239    11.00000    0.11728    0.08900 =
         0.11793    0.00040    0.01576    0.03995
CB    1    0.569567    1.015223    0.044653    11.00000    0.15237    0.09469 =
         0.23918    0.04149    0.07919    0.07072
AFIX  23
HB1   2    0.567675    0.996769    0.045783    11.00000   -1.20000
HB2   2    0.560652    1.014869    0.036752    11.00000   -1.20000
AFIX   0
SG    5    0.550082    1.020477    0.057067    11.00000    0.13414    0.12969 =
         0.14295    0.01513    0.02479    0.06119
 
RESI   26   GLY
N     3    0.619182    1.004982    0.044195    11.00000    0.08770    0.08564 =
         0.12548    0.00310    0.01581    0.04499
AFIX  43
H0    2    0.615432    1.003950    0.052063    11.00000   -1.20000
AFIX   0
CA    1    0.628783    0.987034    0.039196    11.00000    0.07949    0.09444 =
         0.10928    0.00240    0.01604    0.04428
AFIX  23
HA1   2    0.640323    0.984451    0.045356    11.00000   -1.20000
HA2   2    0.640258    0.995713    0.031828    11.00000   -1.20000
AFIX   0
C     1    0.603318    0.958195    0.035687    11.00000    0.09950    0.07377 =
         0.15473    0.01084   -0.01288    0.04754
O     4    0.579186    0.952502    0.038096    11.00000    0.10173    0.08761 =
         0.12843   -0.01214    0.00060    0.04142
 
RESI   27   GLY
N     3    0.610262    0.940765    0.030426    11.00000    0.08963    0.07517 =
         0.13630    0.01401    0.01623    0.03336
AFIX  43
H0    2    0.627583    0.947148    0.028333    11.00000   -1.20000
AFIX   0
CA    1    0.589906    0.911000    0.027961    11.00000    0.07021    0.08799 =
         0.12114   -0.00825    0.01401    0.02966
AFIX  23
HA1   2    0.577737    0.909362    0.021023    11.00000   -1.20000
HA2   2    0.578250    0.902386    0.035290    11.00000   -1.20000
AFIX   0
C     1    0.606560    0.896330    0.024781    11.00000    0.08158    0.09712 =
         0.10743   -0.02753    0.01686    0.03308
O     4    0.632602    0.909760    0.023689    11.00000    0.07990    0.09957 =
         0.16334   -0.00008    0.02478    0.04129
 
RESI   28   SER
N     3    0.591129    0.868727    0.023213    11.00000    0.09739    0.09324 =
         0.11139   -0.01126    0.00540    0.04121
AFIX  43
H0    2    0.573120    0.860964    0.023951    11.00000   -1.20000
AFIX   0
CA    1    0.602990    0.850690    0.020297    11.00000    0.10224    0.11004 =
         0.13299   -0.02036    0.02017    0.05195
AFIX  13
HA    2    0.623036    0.862665    0.018288    11.00000   -1.20000
AFIX   0
C     1    0.588058    0.831734    0.009060    11.00000    0.09919    0.10189 =
         0.12685   -0.01295    0.02863    0.05142
O     4    0.562030    0.817394    0.008782    11.00000    0.09913    0.10457 =
         0.17604   -0.02529    0.02498    0.03055
CB    1    0.600190    0.831611    0.031140    11.00000    0.11286    0.15194 =
         0.15423   -0.01251   -0.01576    0.08210
AFIX  23
HB1   2    0.580415    0.818191    0.032616    11.00000   -1.20000
HB2   2    0.609638    0.821126    0.029101    11.00000   -1.20000
AFIX   0
OG    4    0.612362    0.847948    0.042133    11.00000    0.12575    0.11985 =
         0.15260    0.00050    0.00229    0.05373
AFIX  83
HG    2    0.604266    0.856700    0.043867    11.00000   -1.50000
AFIX   0
 
RESI   29   LEU
N     3    0.603833    0.831227   -0.000143    11.00000    0.13433    0.11638 =
         0.13836   -0.01526    0.04824    0.05873
AFIX  43
H0    2    0.621763    0.842414    0.000321    11.00000   -1.20000
AFIX   0
CA    1    0.592900    0.813056   -0.010966    11.00000    0.13265    0.11600 =
         0.12542   -0.00688    0.04383    0.06391
AFIX  13
HA    2    0.576089    0.813298   -0.013947    11.00000   -1.20000
AFIX   0
C     1    0.584413    0.783039   -0.007189    11.00000    0.11902    0.11188 =
         0.17735   -0.00943    0.06459    0.06398
O     4    0.602132    0.778155   -0.003098    11.00000    0.14243    0.09867 =
         0.19373   -0.02602    0.02981    0.06768
CB    1    0.614418    0.822609   -0.021686    11.00000    0.13657    0.14535 =
         0.13966   -0.01209    0.05939    0.06396
AFIX  23
HB1   2    0.622510    0.842809   -0.022711    11.00000   -1.20000
HB2   2    0.629561    0.819358   -0.019125    11.00000   -1.20000
AFIX   0
CG    1    0.603873    0.808813   -0.034445    11.00000    0.14606    0.14226 =
         0.13448    0.00147    0.06655    0.05702
AFIX  13
HG    2    0.594202    0.788327   -0.033246    11.00000   -1.20000
AFIX   0
CD1   1    0.582706    0.816106   -0.039682    11.00000    0.12541    0.20010 =
         0.15970   -0.01759    0.04703    0.06413
AFIX  33
HD1A  2    0.568153    0.811698   -0.033605    11.00000   -1.50000
HD1B  2    0.574498    0.805382   -0.047167    11.00000   -1.50000
HD1C  2    0.592000    0.835878   -0.041605    11.00000   -1.50000
AFIX   0
CD2   1    0.628318    0.816782   -0.043564    11.00000    0.16675    0.28167 =
         0.13960   -0.02607    0.06195    0.12233
AFIX  33
HD2A  2    0.641527    0.812149   -0.039922    11.00000   -1.50000
HD2B  2    0.637602    0.836665   -0.045240    11.00000   -1.50000
HD2C  2    0.621150    0.806529   -0.051245    11.00000   -1.50000
AFIX   0
 
RESI   30   ILE
N     3    0.557372    0.763062   -0.009058    11.00000    0.12582    0.12477 =
         0.21550   -0.02067    0.05156    0.05587
AFIX  43
H0    2    0.545499    0.767204   -0.012283    11.00000   -1.20000
AFIX   0
CA    1    0.548679    0.733869   -0.005420    11.00000    0.14489    0.11906 =
         0.18464   -0.02531    0.03460    0.04664
AFIX  13
HA    2    0.564746    0.734170   -0.001219    11.00000   -1.20000
AFIX   0
C     1    0.541303    0.714673   -0.016741    11.00000    0.14620    0.13616 =
         0.20805   -0.04520    0.02042    0.06380
O     4    0.540809    0.692192   -0.015171    11.00000    0.20738    0.14083 =
         0.21915   -0.02763    0.06346    0.08231
CB    1    0.523934    0.721771    0.003870    11.00000    0.15660    0.13840 =
         0.17634   -0.01270    0.03135    0.05621
AFIX  13
HB    2    0.518851    0.702208    0.005604    11.00000   -1.20000
AFIX   0
CG1   1    0.498215    0.721296   -0.001503    11.00000    0.16446    0.18665 =
         0.18367    0.02018    0.05933    0.08625
AFIX  23
HG1A  2    0.496314    0.715808   -0.010243    11.00000   -1.20000
HG1B  2    0.500835    0.740166   -0.001124    11.00000   -1.20000
AFIX   0
CG2   1    0.534014    0.738251    0.016263    11.00000    0.16795    0.12770 =
         0.19854   -0.03297    0.04567    0.04834
AFIX  33
HG2A  2    0.550383    0.737854    0.019208    11.00000   -1.50000
HG2B  2    0.519261    0.729724    0.022394    11.00000   -1.50000
HG2C  2    0.538681    0.757447    0.014913    11.00000   -1.50000
AFIX   0
CD1   1    0.471227    0.701114    0.005391    11.00000    0.15626    0.16206 =
         0.22509    0.07718    0.02917    0.05883
AFIX  33
HD1A  2    0.455589    0.701762    0.001677    11.00000   -1.50000
HD1B  2    0.472881    0.706555    0.014034    11.00000   -1.50000
HD1C  2    0.468173    0.682285    0.004816    11.00000   -1.50000
AFIX   0
 
RESI   31   ASN
N     3    0.536726    0.722608   -0.027797    11.00000    0.18222    0.14494 =
         0.18371   -0.05977    0.02761    0.07836
AFIX  43
H0    2    0.532960    0.736092   -0.027964    11.00000   -1.20000
AFIX   0
CA    1    0.537633    0.710064   -0.039697    11.00000    0.16531    0.09591 =
         0.21171   -0.05687    0.05802    0.05180
AFIX  13
HA    2    0.554427    0.708029   -0.039460    11.00000   -1.20000
AFIX   0
C     1    0.542733    0.731620   -0.049980    11.00000    0.18915    0.15929 =
         0.18296   -0.05006    0.02187    0.07643
O     4    0.545977    0.755153   -0.047254    11.00000    0.18942    0.14675 =
         0.15182   -0.01578    0.04115    0.07692
CB    1    0.512455    0.680596   -0.042064    11.00000    0.15327    0.15756 =
         0.20762   -0.06917    0.04469    0.01191
AFIX  23
HB1   2    0.516947    0.672269   -0.049076    11.00000   -1.20000
HB2   2    0.509889    0.668998   -0.034766    11.00000   -1.20000
AFIX   0
CG    1    0.484776    0.679580   -0.044815    11.00000    0.15651    0.18700 =
         0.26959   -0.05936    0.07775    0.03526
OD1   4    0.483382    0.698794   -0.049981    11.00000    0.13914    0.18344 =
         0.23283   -0.07187    0.03818    0.01648
ND2   3    0.461277    0.656148   -0.041327    11.00000    0.16830    0.17964 =
         0.37169   -0.04125    0.13355    0.05683
AFIX  93
HD2A  2    0.445046    0.654513   -0.042712    11.00000   -1.20000
HD2B  2    0.462396    0.642713   -0.037699    11.00000   -1.20000
AFIX   0
 
RESI   32   SER
N     3    0.545092    0.725503   -0.061755    11.00000    0.16132    0.15616 =
         0.19600   -0.07402    0.02390    0.03271
AFIX  43
H0    2    0.541500    0.708820   -0.063777    11.00000   -1.20000
AFIX   0
CA    1    0.553963    0.747709   -0.071342    11.00000    0.18265    0.21112 =
         0.17028   -0.06198    0.03669    0.07200
AFIX  13
HA    2    0.572540    0.763362   -0.068979    11.00000   -1.20000
AFIX   0
C     1    0.533591    0.759140   -0.072479    11.00000    0.12156    0.22224 =
         0.16731   -0.03114    0.02650    0.03440
O     4    0.541766    0.781404   -0.078206    11.00000    0.17358    0.24134 =
         0.12848   -0.03361    0.03381    0.07531
CB    1    0.556661    0.736690   -0.084053    11.00000    0.18468    0.27008 =
         0.19511   -0.10141    0.05823    0.03432
AFIX  23
HB1   2    0.564362    0.751991   -0.090084    11.00000   -1.20000
HB2   2    0.569479    0.729340   -0.083426    11.00000   -1.20000
AFIX   0
OG    4    0.529736    0.714972   -0.088188    11.00000    0.25149    0.22960 =
         0.17483   -0.05816    0.04893   -0.02003
AFIX  83
HG    2    0.531409    0.708885   -0.094957    11.00000   -1.50000
AFIX   0
 
RESI   33   GLN
N     3    0.507579    0.743919   -0.067610    11.00000    0.14224    0.20252 =
         0.19152   -0.11548    0.05950    0.01115
AFIX  43
H0    2    0.502896    0.728826   -0.063389    11.00000   -1.20000
AFIX   0
CA    1    0.487502    0.753646   -0.069667    11.00000    0.12189    0.33647 =
         0.17765   -0.11014    0.03418    0.04599
AFIX  13
HA    2    0.496621    0.770639   -0.074884    11.00000   -1.20000
AFIX   0
C     1    0.477004    0.760697   -0.057703    11.00000    0.12855    0.17508 =
         0.14286   -0.05081    0.03024    0.02890
O     4    0.458714    0.767693   -0.058639    11.00000    0.13141    0.20391 =
         0.14127   -0.04716    0.01211    0.04181
CB    1    0.462417    0.730828   -0.076879    11.00000    0.20387    0.55571 =
         0.28756   -0.29078   -0.04665    0.10646
AFIX  23
HB1   2    0.448557    0.718116   -0.070889    11.00000   -1.20000
HB2   2    0.453809    0.739715   -0.081591    11.00000   -1.20000
AFIX   0
CG    1    0.469129    0.713524   -0.085853    11.00000    0.33029    0.62094 =
         0.33176   -0.33063    0.02814    0.11951
AFIX  23
HG1   2    0.481968    0.726068   -0.092192    11.00000   -1.20000
HG2   2    0.478953    0.705742   -0.081254    11.00000   -1.20000
AFIX   0
CD    1    0.444081    0.689625   -0.092355    11.00000    0.34972    0.55541 =
         0.43414   -0.34316    0.05233    0.07788
OE1   4    0.444812    0.670341   -0.098061    11.00000    0.56262    0.40514 =
         0.35426   -0.17264   -0.12984    0.22230
NE2   3    0.420040    0.690021   -0.092175    11.00000    0.30838    0.51591 =
         0.64042   -0.42721    0.01774    0.02776
AFIX  93
HE2A  2    0.405434    0.677058   -0.095971    11.00000   -1.20000
HE2B  2    0.419064    0.703241   -0.088263    11.00000   -1.20000
AFIX   0
 
RESI   34   TRP
N     3    0.487530    0.758590   -0.046714    11.00000    0.12675    0.13245 =
         0.15751   -0.04465    0.03787    0.04093
AFIX  43
H0    2    0.501477    0.755516   -0.046664    11.00000   -1.20000
AFIX   0
CA    1    0.476113    0.761336   -0.034870    11.00000    0.11627    0.13068 =
         0.13734   -0.03119    0.02744    0.03257
AFIX  13
HA    2    0.465304    0.770915   -0.036359    11.00000   -1.20000
AFIX   0
C     1    0.498664    0.777871   -0.025119    11.00000    0.08900    0.09856 =
         0.13482   -0.00897    0.04059    0.02167
O     4    0.518951    0.774386   -0.023276    11.00000    0.11195    0.12255 =
         0.15420   -0.02082    0.02783    0.04313
CB    1    0.456214    0.731887   -0.029734    11.00000    0.13786    0.10416 =
         0.14934   -0.06020    0.02718    0.01965
AFIX  23
HB1   2    0.465792    0.721035   -0.030143    11.00000   -1.20000
HB2   2    0.452767    0.733692   -0.020965    11.00000   -1.20000
AFIX   0
CG    1    0.428261    0.715386   -0.036166    11.00000    0.13871    0.09332 =
         0.15767   -0.04602    0.02510    0.03452
CD1   1    0.421280    0.695732   -0.045401    11.00000    0.12223    0.12371 =
         0.20318   -0.08814    0.01064    0.02369
AFIX  43
HD1   2    0.433485    0.690271   -0.048773    11.00000   -1.20000
AFIX   0
NE1   3    0.393971    0.685250   -0.048982    11.00000    0.11447    0.14974 =
         0.19251   -0.07322    0.03354    0.01895
AFIX  43
HE1   2    0.385466    0.672775   -0.054713    11.00000   -1.20000
AFIX   0
CE2   1    0.382212    0.697673   -0.042037    11.00000    0.14513    0.10318 =
         0.18709   -0.02845    0.02103    0.04582
CZ2   1    0.354888    0.693329   -0.042410    11.00000    0.15964    0.09550 =
         0.14352    0.00165    0.01290    0.06056
AFIX  43
HZ2   2    0.341440    0.680477   -0.047918    11.00000   -1.20000
AFIX   0
CH2   1    0.348695    0.709005   -0.034212    11.00000    0.16364    0.11096 =
         0.14146    0.00991    0.02142    0.07056
AFIX  43
HH2   2    0.330690    0.706748   -0.034111    11.00000   -1.20000
AFIX   0
CZ3   1    0.369311    0.728192   -0.026091    11.00000    0.16637    0.13473 =
         0.11621   -0.00177    0.02900    0.07580
AFIX  43
HZ3   2    0.364599    0.738551   -0.020706    11.00000   -1.20000
AFIX   0
CE3   1    0.396322    0.732506   -0.025678    11.00000    0.14755    0.07356 =
         0.16475    0.00444    0.04448    0.04517
AFIX  43
HE3   2    0.409560    0.745363   -0.020103    11.00000   -1.20000
AFIX   0
CD2   1    0.403284    0.717056   -0.033857    11.00000    0.14791    0.08486 =
         0.13568   -0.00578    0.03558    0.04107
 
RESI   35   VAL
N     3    0.494494    0.796182   -0.018721    11.00000    0.13651    0.13572 =
         0.10733   -0.01899    0.02523    0.06061
AFIX  43
H0    2    0.480260    0.797866   -0.020863    11.00000   -1.20000
AFIX   0
CA    1    0.511707    0.813747   -0.008400    11.00000    0.12964    0.12227 =
         0.10594   -0.00107    0.01760    0.05808
AFIX  13
HA    2    0.527419    0.810273   -0.007038    11.00000   -1.20000
AFIX   0
C     1    0.494174    0.806358    0.003426    11.00000    0.12855    0.07490 =
         0.10578   -0.01381    0.01709    0.04314
O     4    0.469269    0.801259    0.002841    11.00000    0.13641    0.12347 =
         0.11718    0.01106    0.02477    0.06157
CB    1    0.523691    0.845055   -0.012039    11.00000    0.14874    0.11994 =
         0.10123    0.00380    0.01839    0.05712
AFIX  13
HB    2    0.508276    0.846976   -0.015651    11.00000   -1.20000
AFIX   0
CG1   1    0.534399    0.863831   -0.000599    11.00000    0.11853    0.12575 =
         0.11267   -0.00310   -0.00661    0.04825
AFIX  33
HG1A  2    0.519418    0.857891    0.005398    11.00000   -1.50000
HG1B  2    0.540858    0.883013   -0.002995    11.00000   -1.50000
HG1C  2    0.549715    0.862502    0.003059    11.00000   -1.50000
AFIX   0
CG2   1    0.546574    0.853952   -0.021956    11.00000    0.15353    0.10899 =
         0.13068   -0.00398    0.02855    0.03765
AFIX  33
HG2A  2    0.539056    0.841825   -0.029118    11.00000   -1.50000
HG2B  2    0.562091    0.852548   -0.018591    11.00000   -1.50000
HG2C  2    0.553005    0.873092   -0.024413    11.00000   -1.50000
AFIX   0
 
RESI   36   VAL
N     3    0.505541    0.805942    0.014081    11.00000    0.10629    0.07006 =
         0.10714    0.00064    0.03542    0.03190
AFIX  43
H0    2    0.522045    0.807733    0.013607    11.00000   -1.20000
AFIX   0
CA    1    0.494259    0.802882    0.026617    11.00000    0.13245    0.12223 =
         0.10086   -0.03497    0.03197    0.04453
AFIX  13
HA    2    0.474115    0.796536    0.025832    11.00000   -1.20000
AFIX   0
C     1    0.508410    0.831931    0.032780    11.00000    0.08981    0.11697 =
         0.11717   -0.02927    0.01384    0.04016
O     4    0.534081    0.846390    0.032600    11.00000    0.09056    0.11203 =
         0.11678    0.00597    0.02626    0.03629
CB    1    0.497070    0.781315    0.035179    11.00000    0.30482    0.11652 =
         0.11932    0.04175    0.11153    0.06265
AFIX  13
HB    2    0.517112    0.787361    0.036141    11.00000   -1.20000
AFIX   0
CG1   1    0.484963    0.781666    0.047946    11.00000    0.60322    0.18580 =
         0.20434    0.10976    0.25244    0.24788
AFIX  33
HG1A  2    0.494560    0.800519    0.051228    11.00000   -1.50000
HG1B  2    0.487470    0.769366    0.053542    11.00000   -1.50000
HG1C  2    0.465214    0.775335    0.047130    11.00000   -1.50000
AFIX   0
CG2   1    0.481666    0.751233    0.030566    11.00000    0.23262    0.13854 =
         0.26339   -0.00316    0.08627    0.07748
AFIX  33
HG2A  2    0.487643    0.750507    0.022190    11.00000   -1.50000
HG2B  2    0.461723    0.744312    0.030623    11.00000   -1.50000
HG2C  2    0.485832    0.739741    0.035949    11.00000   -1.50000
AFIX   0
 
RESI   37   SER
N     3    0.492088    0.840311    0.038313    11.00000    0.09469    0.08129 =
         0.14192   -0.01408    0.00996    0.04045
AFIX  43
H0    2    0.474089    0.829721    0.037713    11.00000   -1.20000
AFIX   0
CA    1    0.503243    0.866672    0.045374    11.00000    0.11187    0.08156 =
         0.11364   -0.00292    0.02155    0.03692
AFIX  13
HA    2    0.521830    0.871425    0.048651    11.00000   -1.20000
AFIX   0
C     1    0.483839    0.862123    0.056466    11.00000    0.07674    0.09483 =
         0.09630   -0.01393   -0.00422    0.02605
O     4    0.465093    0.838280    0.059429    11.00000    0.09710    0.08774 =
         0.11929    0.00510    0.01427    0.03437
CB    1    0.506904    0.890730    0.036901    11.00000    0.11220    0.08237 =
         0.11384   -0.00883    0.01690    0.04540
AFIX  23
HB1   2    0.517292    0.890891    0.029512    11.00000   -1.20000
HB2   2    0.488373    0.886747    0.034159    11.00000   -1.20000
AFIX   0
OG    4    0.520785    0.917749    0.042211    11.00000    0.11681    0.08685 =
         0.11124   -0.01167    0.00172    0.04794
AFIX  83
HG    2    0.536748    0.921691    0.044325    11.00000   -1.50000
AFIX   0
 
RESI   38   ALA
N     3    0.488386    0.884851    0.062767    11.00000    0.06376    0.08927 =
         0.10473   -0.00748    0.00791    0.02221
AFIX  43
H0    2    0.502322    0.900817    0.060461    11.00000   -1.20000
AFIX   0
CA    1    0.471618    0.884773    0.073244    11.00000    0.09267    0.09398 =
         0.09424   -0.00311    0.00419    0.04762
AFIX  13
HA    2    0.464231    0.866737    0.077652    11.00000   -1.20000
AFIX   0
C     1    0.446713    0.887376    0.068474    11.00000    0.09201    0.09427 =
         0.09589    0.00097    0.00837    0.04820
O     4    0.450789    0.904247    0.060119    11.00000    0.10378    0.11208 =
         0.11245    0.02467    0.01869    0.05262
CB    1    0.488635    0.908686    0.082574    11.00000    0.10777    0.11101 =
         0.11168   -0.02206   -0.00937    0.05854
AFIX  33
HB1   2    0.504613    0.907465    0.085443    11.00000   -1.50000
HB2   2    0.476914    0.907016    0.089584    11.00000   -1.50000
HB3   2    0.495026    0.926540    0.078534    11.00000   -1.50000
AFIX   0
 
RESI   39   ALA
N     3    0.421738    0.871375    0.073915    11.00000    0.09085    0.08498 =
         0.10057   -0.00633    0.01486    0.04045
AFIX  43
H0    2    0.419801    0.859042    0.079409    11.00000   -1.20000
AFIX   0
CA    1    0.397679    0.874637    0.070615    11.00000    0.08660    0.07382 =
         0.10893    0.00770    0.00502    0.02979
AFIX  13
HA    2    0.393927    0.870535    0.061663    11.00000   -1.20000
AFIX   0
C     1    0.402980    0.904520    0.072901    11.00000    0.10009    0.08967 =
         0.10299    0.00478    0.00356    0.04689
O     4    0.392196    0.914942    0.066228    11.00000    0.07551    0.08442 =
         0.15067    0.01286   -0.00514    0.03504
CB    1    0.371489    0.853476    0.077787    11.00000    0.08080    0.10267 =
         0.15225    0.01840    0.00973    0.02303
AFIX  33
HB1   2    0.368233    0.834763    0.076359    11.00000   -1.50000
HB2   2    0.355476    0.854664    0.074944    11.00000   -1.50000
HB3   2    0.374261    0.857672    0.086575    11.00000   -1.50000
AFIX   0
 
RESI   40   HIS
N     3    0.420387    0.919168    0.082347    11.00000    0.08760    0.08437 =
         0.12947   -0.00386   -0.00741    0.04129
AFIX  43
H0    2    0.428346    0.912035    0.086812    11.00000   -1.20000
AFIX   0
CA    1    0.425398    0.947507    0.084813    11.00000    0.10907    0.08500 =
         0.15401   -0.00442    0.00418    0.04881
AFIX  13
HA    2    0.406960    0.946354    0.084447    11.00000   -1.20000
AFIX   0
C     1    0.443613    0.968503    0.074734    11.00000    0.12835    0.07238 =
         0.16462   -0.01201    0.00420    0.02790
O     4    0.446278    0.992396    0.074376    11.00000    0.15448    0.08189 =
         0.19004    0.00014   -0.02232    0.04976
CB    1    0.436483    0.956782    0.098047    11.00000    0.12644    0.11825 =
         0.16310   -0.02855   -0.00912    0.08702
AFIX  23
HB1   2    0.431416    0.970655    0.100642    11.00000   -1.20000
HB2   2    0.426491    0.940563    0.103502    11.00000   -1.20000
AFIX   0
CG    1    0.466987    0.968859    0.100340    11.00000    0.11614    0.09251 =
         0.17885   -0.00802   -0.00622    0.05792
ND1   3    0.488118    0.995531    0.098177    11.00000    0.16323    0.09752 =
         0.28737    0.00892    0.00035    0.05393
AFIX  43
HD1   2    0.486176    1.008909    0.095012    11.00000   -1.20000
AFIX   0
CE1   1    0.512069    0.997600    0.101710    11.00000    0.12527    0.11465 =
         0.09536   -0.02027    0.02287    0.02627
AFIX  43
HE1   2    0.529512    1.014036    0.101200    11.00000   -1.20000
AFIX   0
NE2   3    0.508183    0.973233    0.106099    11.00000    0.10509    0.16234 =
         0.20151    0.01841   -0.02617    0.03656
CD2   1    0.479886    0.955113    0.105207    11.00000    0.09472    0.11420 =
         0.10067    0.00801    0.00349    0.05036
AFIX  43
HD2   2    0.470727    0.936224    0.107557    11.00000   -1.20000
AFIX   0
 
RESI   41   CYS
N     3    0.455183    0.959345    0.066469    11.00000    0.11391    0.09745 =
         0.12534    0.01108   -0.01434    0.05035
AFIX  43
H0    2    0.453601    0.943039    0.067530    11.00000   -1.20000
AFIX   0
CA    1    0.470590    0.976195    0.055575    11.00000    0.11832    0.12939 =
         0.14458    0.04337   -0.00260    0.05020
AFIX  13
HA    2    0.479833    0.996164    0.057921    11.00000   -1.20000
AFIX   0
C     1    0.451630    0.971642    0.044201    11.00000    0.09374    0.11066 =
         0.12533    0.04165    0.02097    0.03926
O     4    0.461588    0.983701    0.034243    11.00000    0.11145    0.17879 =
         0.14790    0.08703    0.02253    0.04347
CB    1    0.493214    0.969473    0.051561    11.00000    0.11186    0.15575 =
         0.16831    0.05945    0.00928    0.05641
AFIX  23
HB1   2    0.500890    0.978675    0.043602    11.00000   -1.20000
HB2   2    0.484378    0.949293    0.050200    11.00000   -1.20000
AFIX   0
SG    5    0.522338    0.980003    0.062531    11.00000    0.10443    0.13935 =
         0.18182    0.02988    0.00070    0.03824
 
RESI   42   TYR
N     3    0.424182    0.953685    0.045413    11.00000    0.09204    0.10952 =
         0.13597    0.02284    0.01950    0.04562
AFIX  43
H0    2    0.417811    0.945402    0.052486    11.00000   -1.20000
AFIX   0
CA    1    0.404770    0.947693    0.035197    11.00000    0.10186    0.12368 =
         0.16876    0.02458   -0.00194    0.04481
AFIX  13
HA    2    0.409483    0.938398    0.028550    11.00000   -1.20000
AFIX   0
C     1    0.407338    0.974797    0.029815    11.00000    0.10940    0.12571 =
         0.15657    0.00886   -0.01385    0.05338
O     4    0.405677    0.991456    0.037185    11.00000    0.15118    0.13244 =
         0.17800    0.01125    0.00423    0.06807
CB    1    0.373654    0.926894    0.039589    11.00000    0.09044    0.14991 =
         0.17692    0.02741    0.01239    0.06493
AFIX  23
HB1   2    0.370588    0.907918    0.040442    11.00000   -1.20000
HB2   2    0.370079    0.932809    0.047614    11.00000   -1.20000
AFIX   0
CG    1    0.353922    0.927710    0.029474    11.00000    0.10614    0.17690 =
         0.15858    0.02253   -0.00858    0.05131
CD1   1    0.351436    0.915081    0.018125    11.00000    0.12749    0.21472 =
         0.19061   -0.02005   -0.00573    0.01024
AFIX  43
HD1   2    0.361664    0.905923    0.016815    11.00000   -1.20000
AFIX   0
CD2   1    0.339015    0.941885    0.031083    11.00000    0.12248    0.20029 =
         0.18010    0.08911    0.00606    0.07994
AFIX  43
HD2   2    0.340366    0.950765    0.038686    11.00000   -1.20000
AFIX   0
CE1   1    0.334659    0.915142    0.008523    11.00000    0.14555    0.20931 =
         0.15775    0.00232   -0.00970   -0.03564
AFIX  43
HE1   2    0.332901    0.905897    0.000983    11.00000   -1.20000
AFIX   0
CE2   1    0.322340    0.943193    0.021793    11.00000    0.13219    0.19501 =
         0.23311    0.05591   -0.06036    0.04717
AFIX  43
HE2   2    0.312569    0.952867    0.022953    11.00000   -1.20000
AFIX   0
CZ    1    0.320674    0.929714    0.010775    11.00000    0.11020    0.30419 =
         0.20955    0.04431   -0.02402    0.00655
OH    4    0.304102    0.930580    0.001557    11.00000    0.19103    0.42102 =
         0.19389    0.09922   -0.02949    0.04082
AFIX  83
HH    2    0.296734    0.939613    0.003961    11.00000   -1.50000
AFIX   0
 
RESI   43   LYS
N     3    0.408240    0.977169    0.017506    11.00000    0.13759    0.14027 =
         0.15975    0.01307   -0.02054    0.07345
AFIX  43
H0    2    0.413007    0.966813    0.013294    11.00000   -1.20000
AFIX   0
CA    1    0.401775    0.995959    0.010601    11.00000    0.16585    0.17197 =
         0.18222    0.03243   -0.00862    0.09880
AFIX  13
HA    2    0.384573    0.994480    0.014149    11.00000   -1.20000
AFIX   0
C     1    0.395561    0.985363   -0.002848    11.00000    0.14926    0.16636 =
         0.14210    0.08843    0.05261    0.07065
O     4    0.403012    0.969233   -0.006611    11.00000    0.18888    0.25270 =
         0.19059   -0.00004   -0.01338    0.12927
CB    1    0.424259    1.026483    0.010617    11.00000    0.23237    0.17719 =
         0.15928    0.07462    0.03874    0.07908
AFIX  23
HB1   2    0.418079    1.036752    0.005316    11.00000   -1.20000
HB2   2    0.426060    1.033719    0.019063    11.00000   -1.20000
AFIX   0
CG    1    0.452357    1.032541    0.006330    11.00000    0.20978    0.25099 =
         0.23398    0.10437    0.05071    0.07495
AFIX  23
HG1   2    0.450815    1.024801   -0.001993    11.00000   -1.20000
HG2   2    0.459455    1.023523    0.011907    11.00000   -1.20000
AFIX   0
CD    1    0.473223    1.064599    0.006063    11.00000    0.22194    0.24389 =
         0.36329    0.08179    0.08376    0.08414
AFIX  23
HD1   2    0.488149    1.068717    0.000090    11.00000   -1.20000
HD2   2    0.463460    1.074395    0.003391    11.00000   -1.20000
AFIX   0
CE    1    0.485718    1.074823    0.018770    11.00000    0.12549    0.20166 =
         0.36208    0.08834    0.10195    0.05268
AFIX  23
HE1   2    0.470294    1.070907    0.024414    11.00000   -1.20000
HE2   2    0.493562    1.063262    0.021491    11.00000   -1.20000
AFIX   0
NZ    3    0.507862    1.104827    0.020700    11.00000    0.21153    0.26587 =
         0.64497   -0.13750    0.20878    0.04557
AFIX  33
HZ1   2    0.512038    1.107894    0.028811    11.00000   -1.50000
HZ2   2    0.501518    1.116046    0.018032    11.00000   -1.50000
HZ3   2    0.523265    1.108470    0.016412    11.00000   -1.50000
AFIX   0
 
RESI   44   SER
N     3    0.381849    0.994812   -0.009646    11.00000    0.21221    0.19168 =
         0.17951    0.05502   -0.00782    0.10052
AFIX  43
H0    2    0.375303    1.004598   -0.006238    11.00000   -1.20000
AFIX   0
CA    1    0.377951    0.988420   -0.023028    11.00000    0.28125    0.26274 =
         0.16543    0.06626   -0.00212    0.15523
AFIX  13
HA    2    0.374575    0.969245   -0.024307    11.00000   -1.20000
AFIX   0
C     1    0.404877    1.009030   -0.029948    11.00000    0.30123    0.32034 =
         0.19330    0.08368    0.02703    0.17952
O     4    0.423897    1.031248   -0.025494    11.00000    0.25907    0.27174 =
         0.32292    0.05883    0.08780    0.18045
CB    1    0.352426    0.989880   -0.027954    11.00000    0.28599    0.32866 =
         0.22088    0.04896   -0.05082    0.15948
AFIX  23
HB1   2    0.350152    0.985574   -0.036834    11.00000   -1.20000
HB2   2    0.335518    0.975867   -0.023704    11.00000   -1.20000
AFIX   0
OG    4    0.355788    1.016882   -0.026005    11.00000    0.33628    0.38328 =
         0.42276    0.05985   -0.03765    0.24309
AFIX  83
HG    2    0.356549    1.020061   -0.018468    11.00000   -1.50000
AFIX   0
 
RESI   45   GLY
N     3    0.407833    1.002187   -0.041624    11.00000    0.27885    0.41316 =
         0.26048    0.04193    0.06580    0.26555
AFIX  43
H0    2    0.395274    0.986248   -0.044669    11.00000   -1.20000
AFIX   0
CA    1    0.431868    1.021150   -0.049297    11.00000    0.28781    0.47585 =
         0.24086    0.08115    0.04778    0.24673
AFIX  23
HA1   2    0.433937    1.039792   -0.048829    11.00000   -1.20000
HA2   2    0.427537    1.014942   -0.057929    11.00000   -1.20000
AFIX   0
C     1    0.459931    1.023773   -0.046055    11.00000    0.24847    0.32963 =
         0.29320    0.02753    0.03547    0.17791
O     4    0.482583    1.046172   -0.048221    11.00000    0.28448    0.34491 =
         0.52362    0.13079    0.09115    0.18588
 
RESI   46   ILE
N     3    0.459857    1.001793   -0.040837    11.00000    0.17868    0.29115 =
         0.19807    0.00420    0.02864    0.12136
AFIX  43
H0    2    0.444086    0.986396   -0.039823    11.00000   -1.20000
AFIX   0
CA    1    0.485894    1.003114   -0.036776    11.00000    0.12779    0.16337 =
         0.14846   -0.00499    0.02957    0.03308
AFIX  13
HA    2    0.498035    1.021576   -0.032925    11.00000   -1.20000
AFIX   0
C     1    0.501239    1.000016   -0.048013    11.00000    0.12395    0.15520 =
         0.12465   -0.01167    0.00379    0.03858
O     4    0.488869    0.981913   -0.055965    11.00000    0.12922    0.18089 =
         0.16261   -0.04611   -0.03014    0.07445
CB    1    0.479102    0.979801   -0.026790    11.00000    0.17116    0.19835 =
         0.19864    0.03790    0.10263    0.10018
AFIX  13
HB    2    0.464297    0.961946   -0.030301    11.00000   -1.20000
AFIX   0
CG1   1    0.467836    0.984425   -0.014405    11.00000    0.23616    0.21656 =
         0.12533    0.00314    0.02498    0.14118
AFIX  23
HG1A  2    0.482760    1.001556   -0.010655    11.00000   -1.20000
HG1B  2    0.452540    0.987896   -0.016386    11.00000   -1.20000
AFIX   0
CG2   1    0.503926    0.976063   -0.023954    11.00000    0.18037    0.15018 =
         0.28976   -0.00335    0.04063    0.08458
AFIX  33
HG2A  2    0.511312    0.973207   -0.031622    11.00000   -1.50000
HG2B  2    0.498042    0.959973   -0.018608    11.00000   -1.50000
HG2C  2    0.518284    0.992620   -0.019820    11.00000   -1.50000
AFIX   0
CD1   1    0.457296    0.961722   -0.004612    11.00000    0.23026    0.25813 =
         0.13818    0.02648    0.04681    0.15918
AFIX  33
HD1A  2    0.450584    0.967404    0.002493    11.00000   -1.50000
HD1B  2    0.472387    0.958686   -0.002059    11.00000   -1.50000
HD1C  2    0.442175    0.944559   -0.008009    11.00000   -1.50000
AFIX   0
 
RESI   47   GLN
N     3    0.528967    1.018050   -0.048713    11.00000    0.12180    0.14778 =
         0.17086   -0.05412    0.01155    0.06203
AFIX  43
H0    2    0.535911    1.032843   -0.044056    11.00000   -1.20000
AFIX   0
CA    1    0.548177    1.014302   -0.056836    11.00000    0.13011    0.14162 =
         0.11644   -0.03568   -0.00212    0.06922
AFIX  13
HA    2    0.536910    0.998882   -0.062670    11.00000   -1.20000
AFIX   0
C     1    0.565547    1.005537   -0.048706    11.00000    0.11336    0.11471 =
         0.11056   -0.02924    0.00439    0.04563
O     4    0.579088    1.020200   -0.039694    11.00000    0.12993    0.12521 =
         0.14311   -0.04373   -0.02817    0.05212
CB    1    0.567299    1.040370   -0.064413    11.00000    0.15213    0.14495 =
         0.12219   -0.02251   -0.00438    0.06990
AFIX  23
HB1   2    0.580037    1.055208   -0.058783    11.00000   -1.20000
HB2   2    0.555916    1.046875   -0.068644    11.00000   -1.20000
AFIX   0
CG    1    0.584822    1.034963   -0.074267    11.00000    0.13186    0.14691 =
         0.13258   -0.01796    0.01160    0.03850
AFIX  23
HG1   2    0.595698    1.027580   -0.070264    11.00000   -1.20000
HG2   2    0.572493    1.021417   -0.080451    11.00000   -1.20000
AFIX   0
CD    1    0.604355    1.063174   -0.080447    11.00000    0.15550    0.12537 =
         0.13933   -0.02787   -0.00211    0.04397
OE1   4    0.623815    1.082552   -0.074613    11.00000    0.15895    0.13168 =
         0.19539   -0.01176   -0.04425    0.03301
NE2   3    0.599007    1.064871   -0.092202    11.00000    0.17803    0.17199 =
         0.17106    0.01730   -0.03443    0.01008
AFIX  93
HE2A  2    0.609339    1.080151   -0.096319    11.00000   -1.20000
HE2B  2    0.585145    1.050712   -0.095844    11.00000   -1.20000
AFIX   0
 
RESI   48   VAL
N     3    0.564624    0.981763   -0.051954    11.00000    0.11874    0.09650 =
         0.11447   -0.01186    0.00930    0.03351
AFIX  43
H0    2    0.553705    0.971689   -0.057935    11.00000   -1.20000
AFIX   0
CA    1    0.582141    0.972520   -0.045400    11.00000    0.10324    0.07400 =
         0.11183    0.00561    0.01916    0.01327
AFIX  13
HA    2    0.584981    0.979470   -0.036763    11.00000   -1.20000
AFIX   0
C     1    0.610889    0.985366   -0.051870    11.00000    0.10565    0.07708 =
         0.09443   -0.00479    0.01461    0.01201
O     4    0.612066    0.984325   -0.063430    11.00000    0.13619    0.13573 =
         0.09412   -0.01154    0.01761    0.03697
CB    1    0.567711    0.940141   -0.045123    11.00000    0.10241    0.07733 =
         0.17827    0.00104    0.04000    0.01631
AFIX  13
HB    2    0.564867    0.933390   -0.053792    11.00000   -1.20000
AFIX   0
CG1   1    0.585668    0.930141   -0.038573    11.00000    0.19062    0.10943 =
         0.20170    0.00873    0.03056    0.07614
AFIX  33
HG1A  2    0.603764    0.938244   -0.042581    11.00000   -1.50000
HG1B  2    0.576512    0.909944   -0.039030    11.00000   -1.50000
HG1C  2    0.588114    0.935895   -0.029957    11.00000   -1.50000
AFIX   0
CG2   1    0.538697    0.926875   -0.038732    11.00000    0.09446    0.15674 =
         0.16090    0.01518    0.03894   -0.02282
AFIX  33
HG2A  2    0.527339    0.933397   -0.042768    11.00000   -1.50000
HG2B  2    0.541079    0.932238   -0.030065    11.00000   -1.50000
HG2C  2    0.529548    0.906703   -0.039373    11.00000   -1.50000
AFIX   0
 
RESI   49   ARG
N     3    0.632973    0.998722   -0.044335    11.00000    0.10276    0.11947 =
         0.10032   -0.01934    0.01200    0.04096
AFIX  43
H0    2    0.630105    0.999651   -0.036475    11.00000   -1.20000
AFIX   0
CA    1    0.661975    1.011904   -0.048894    11.00000    0.10455    0.10117 =
         0.13574   -0.02291    0.02033    0.04384
AFIX  13
HA    2    0.661307    1.010231   -0.058040    11.00000   -1.20000
AFIX   0
C     1    0.675881    0.995584   -0.043794    11.00000    0.11862    0.10275 =
         0.14045   -0.01515    0.03329    0.05034
O     4    0.680410    0.995725   -0.032386    11.00000    0.10060    0.08824 =
         0.14701   -0.00650    0.02576    0.03485
CB    1    0.678207    1.043193   -0.045645    11.00000    0.10209    0.10376 =
         0.12493   -0.02005    0.03321    0.04471
AFIX  23
HB1   2    0.697387    1.051392   -0.048730    11.00000   -1.20000
HB2   2    0.679020    1.045392   -0.036615    11.00000   -1.20000
AFIX   0
CG    1    0.664344    1.058946   -0.051352    11.00000    0.10431    0.08129 =
         0.14540   -0.00639    0.01565    0.02286
AFIX  23
HG1   2    0.661462    1.054665   -0.060226    11.00000   -1.20000
HG2   2    0.645932    1.051921   -0.047549    11.00000   -1.20000
AFIX   0
CD    1    0.681056    1.090681   -0.049750    11.00000    0.09908    0.07580 =
         0.15895    0.02157    0.00801   -0.00510
AFIX  23
HD1   2    0.677787    1.095757   -0.041470    11.00000   -1.20000
HD2   2    0.701052    1.097296   -0.050598    11.00000   -1.20000
AFIX   0
NE    3    0.672441    1.103642   -0.059093    11.00000    0.12079    0.08314 =
         0.13517   -0.00413    0.01588    0.02642
AFIX  43
HE    2    0.655662    1.093445   -0.062013    11.00000   -1.20000
AFIX   0
CZ    1    0.687257    1.129500   -0.063781    11.00000    0.13871    0.06492 =
         0.13287   -0.01455    0.01075    0.03795
NH1   3    0.712812    1.146944   -0.059200    11.00000    0.12033    0.08303 =
         0.14796    0.00298    0.02162    0.02860
AFIX  93
HH1A  2    0.719552    1.141424   -0.053272    11.00000   -1.20000
HH1B  2    0.722582    1.163734   -0.062169    11.00000   -1.20000
AFIX   0
NH2   3    0.675781    1.137153   -0.072923    11.00000    0.11588    0.10084 =
         0.18343    0.03247    0.01170    0.01482
AFIX  93
HH2A  2    0.659162    1.125430   -0.075639    11.00000   -1.20000
HH2B  2    0.685015    1.153801   -0.076090    11.00000   -1.20000
AFIX   0
 
RESI   50   LEU
N     3    0.681202    0.980890   -0.052234    11.00000    0.11747    0.10051 =
         0.16069   -0.02245    0.03290    0.04928
AFIX  43
H0    2    0.676076    0.981070   -0.059830    11.00000   -1.20000
AFIX   0
CA    1    0.694774    0.964818   -0.049665    11.00000    0.09445    0.08769 =
         0.18874   -0.03165    0.01860    0.03198
AFIX  13
HA    2    0.693966    0.961286   -0.040636    11.00000   -1.20000
AFIX   0
C     1    0.725801    0.980763   -0.053803    11.00000    0.11747    0.09069 =
         0.21024   -0.00316    0.05597    0.04773
O     4    0.734015    0.999735   -0.061711    11.00000    0.14282    0.12356 =
         0.16967   -0.00370    0.05223    0.05867
CB    1    0.679192    0.936168   -0.056603    11.00000    0.13212    0.08739 =
         0.16628   -0.02243    0.03001    0.04313
AFIX  23
HB1   2    0.682674    0.939540   -0.065515    11.00000   -1.20000
HB2   2    0.687093    0.924619   -0.053938    11.00000   -1.20000
AFIX   0
CG    1    0.647370    0.919743   -0.054409    11.00000    0.12536    0.09948 =
         0.18187   -0.04291    0.01452    0.01154
AFIX  13
HG    2    0.643535    0.926543   -0.046576    11.00000   -1.20000
AFIX   0
CD1   1    0.630514    0.923762   -0.064787    11.00000    0.14333    0.19117 =
         0.19547   -0.05196    0.01437    0.06766
AFIX  33
HD1A  2    0.610785    0.913345   -0.062776    11.00000   -1.50000
HD1B  2    0.633728    0.917038   -0.072569    11.00000   -1.50000
HD1C  2    0.636429    0.943429   -0.065544    11.00000   -1.50000
AFIX   0
CD2   1    0.636183    0.888572   -0.053047    11.00000    0.15824    0.10883 =
         0.32903   -0.00786    0.07712    0.03148
AFIX  33
HD2A  2    0.616219    0.879157   -0.051565    11.00000   -1.50000
HD2B  2    0.645341    0.885270   -0.046120    11.00000   -1.50000
HD2C  2    0.639850    0.881393   -0.060585    11.00000   -1.50000
AFIX   0
 
RESI   51   GLY
N     3    0.742655    0.971942   -0.048649    11.00000    0.10147    0.11252 =
         0.18024   -0.02713    0.03403    0.04505
AFIX  43
H0    2    0.735962    0.958549   -0.043216    11.00000   -1.20000
AFIX   0
CA    1    0.772202    0.985255   -0.052354    11.00000    0.12186    0.10134 =
         0.19653    0.01869    0.07213    0.05462
AFIX  23
HA1   2    0.773210    0.984695   -0.061410    11.00000   -1.20000
HA2   2    0.780222    0.974368   -0.048957    11.00000   -1.20000
AFIX   0
C     1    0.790008    1.015733   -0.048033    11.00000    0.10759    0.11827 =
         0.18627   -0.00325    0.04749    0.04360
O     4    0.812729    1.031675   -0.053034    11.00000    0.10549    0.14050 =
         0.22031   -0.01481    0.06150    0.04023
 
RESI   52   GLU
N     3    0.780901    1.025350   -0.038912    11.00000    0.11778    0.10702 =
         0.19169   -0.00119    0.05834    0.03234
AFIX  43
H0    2    0.765057    1.013598   -0.035515    11.00000   -1.20000
AFIX   0
CA    1    0.795075    1.053776   -0.034108    11.00000    0.11138    0.09970 =
         0.17557    0.00729    0.03646    0.04383
AFIX  13
HA    2    0.803630    1.066926   -0.041116    11.00000   -1.20000
AFIX   0
C     1    0.817901    1.059265   -0.024573    11.00000    0.11492    0.13517 =
         0.18075    0.00096    0.03682    0.06660
O     4    0.814203    1.042167   -0.016362    11.00000    0.12337    0.14811 =
         0.18779    0.00854    0.02179    0.05893
CB    1    0.774120    1.060138   -0.027504    11.00000    0.08556    0.09761 =
         0.16846   -0.00341    0.01928    0.02818
AFIX  23
HB1   2    0.761883    1.044089   -0.022299    11.00000   -1.20000
HB2   2    0.784578    1.076167   -0.021998    11.00000   -1.20000
AFIX   0
CG    1    0.755889    1.066461   -0.035995    11.00000    0.10048    0.10693 =
         0.15048   -0.01688    0.01546    0.04405
AFIX  23
HG1   2    0.747633    1.051805   -0.042317    11.00000   -1.20000
HG2   2    0.740546    1.065521   -0.031073    11.00000   -1.20000
AFIX   0
CD    1    0.770683    1.094388   -0.042437    11.00000    0.10475    0.09876 =
         0.18201   -0.02054   -0.00149    0.04344
OE1   4    0.797006    1.108021   -0.042877    11.00000    0.10574    0.13373 =
         0.15668   -0.00006    0.02342    0.04631
OE2   4    0.756172    1.103574   -0.047444    11.00000    0.11417    0.12302 =
         0.15337    0.00104    0.01162    0.05201
 
RESI   53   ASP
N     3    0.841312    1.084293   -0.025520    11.00000    0.09413    0.17737 =
         0.14690    0.01678    0.05096    0.04948
AFIX  43
H0    2    0.844920    1.093651   -0.032398    11.00000   -1.20000
AFIX   0
CA    1    0.860733    1.095928   -0.015130    11.00000    0.11728    0.14610 =
         0.17457    0.01556    0.02335    0.07440
AFIX  13
HA    2    0.852408    1.083278   -0.007944    11.00000   -1.20000
AFIX   0
C     1    0.863685    1.124418   -0.011742    11.00000    0.12248    0.13775 =
         0.16485    0.03208    0.04403    0.07041
O     4    0.849308    1.125832   -0.003083    11.00000    0.16740    0.12338 =
         0.20356    0.01258    0.08767    0.04457
CB    1    0.889874    1.098897   -0.017813    11.00000    0.11570    0.16145 =
         0.22745   -0.00582    0.02688    0.07570
AFIX  23
HB1   2    0.887506    1.081000   -0.020646    11.00000   -1.20000
HB2   2    0.899486    1.112805   -0.024335    11.00000   -1.20000
AFIX   0
CG    1    0.907215    1.108057   -0.005816    11.00000    0.10823    0.16295 =
         0.24687    0.04779    0.01279    0.05136
OD1   4    0.895394    1.096253    0.004335    11.00000    0.14541    0.14262 =
         0.24465    0.03956    0.01754    0.03553
OD2   4    0.932550    1.126894   -0.006117    11.00000    0.11237    0.22460 =
         0.24929   -0.00223    0.03413    0.03345
 
RESI   54   ASN
N     3    0.880698    1.147204   -0.018318    11.00000    0.12382    0.14995 =
         0.16113    0.04052    0.04281    0.07270
AFIX  43
H0    2    0.892042    1.146651   -0.023732    11.00000   -1.20000
AFIX   0
CA    1    0.880059    1.173451   -0.016299    11.00000    0.10441    0.11431 =
         0.18563    0.01212    0.01996    0.03300
AFIX  13
HA    2    0.879750    1.176290   -0.007252    11.00000   -1.20000
AFIX   0
C     1    0.853147    1.170672   -0.021904    11.00000    0.11099    0.08315 =
         0.14610    0.00842    0.02706    0.03767
O     4    0.849666    1.168787   -0.033469    11.00000    0.11901    0.12281 =
         0.15116    0.00663    0.02841    0.03264
CB    1    0.906507    1.198213   -0.021582    11.00000    0.10590    0.13755 =
         0.14937   -0.00111    0.02300    0.03303
AFIX  23
HB1   2    0.922860    1.197410   -0.018644    11.00000   -1.20000
HB2   2    0.906095    1.196928   -0.030647    11.00000   -1.20000
AFIX   0
CG    1    0.909237    1.226083   -0.017749    11.00000    0.11297    0.11670 =
         0.16667    0.02236    0.01241    0.02482
OD1   4    0.889389    1.230057   -0.017501    11.00000    0.13959    0.12989 =
         0.15917    0.00171   -0.00639    0.04957
ND2   3    0.935545    1.245542   -0.014823    11.00000    0.13750    0.12986 =
         0.27077   -0.00589   -0.04508    0.02778
AFIX  93
HD2A  2    0.939253    1.262144   -0.012585    11.00000   -1.20000
HD2B  2    0.948835    1.241512   -0.015170    11.00000   -1.20000
AFIX   0
 
RESI   55   ILE
N     3    0.832729    1.170209   -0.014825    11.00000    0.11046    0.10918 =
         0.15747   -0.01431    0.02186    0.03572
AFIX  43
H0    2    0.835431    1.172399   -0.006873    11.00000   -1.20000
AFIX   0
CA    1    0.806201    1.166209   -0.019814    11.00000    0.12485    0.12878 =
         0.13319   -0.02674    0.02312    0.06095
AFIX  13
HA    2    0.799727    1.151493   -0.026245    11.00000   -1.20000
AFIX   0
C     1    0.809257    1.192628   -0.025940    11.00000    0.09923    0.10307 =
         0.15951   -0.04556    0.00966    0.03867
O     4    0.789252    1.190567   -0.031939    11.00000    0.09904    0.11628 =
         0.17240   -0.00895    0.00260    0.02429
CB    1    0.783622    1.155838   -0.009553    11.00000    0.13644    0.14163 =
         0.16592   -0.01003    0.03967    0.08362
AFIX  13
HB    2    0.767740    1.157356   -0.012873    11.00000   -1.20000
AFIX   0
CG1   1    0.793300    1.173285    0.002378    11.00000    0.17156    0.17173 =
         0.13665    0.00081    0.05209    0.08862
AFIX  23
HG1A  2    0.805017    1.193048    0.000217    11.00000   -1.20000
HG1B  2    0.804665    1.167718    0.007257    11.00000   -1.20000
AFIX   0
CG2   1    0.773007    1.124614   -0.007300    11.00000    0.16074    0.13943 =
         0.21325    0.01438    0.03236    0.07094
AFIX  33
HG2A  2    0.758531    1.117621   -0.001014    11.00000   -1.50000
HG2B  2    0.788354    1.122212   -0.004518    11.00000   -1.50000
HG2C  2    0.765451    1.114344   -0.014948    11.00000   -1.50000
AFIX   0
CD1   1    0.768219    1.169502    0.010351    11.00000    0.19289    0.27929 =
         0.18023   -0.03359    0.08210    0.08825
AFIX  33
HD1A  2    0.775127    1.180882    0.017762    11.00000   -1.50000
HD1B  2    0.756825    1.150034    0.012679    11.00000   -1.50000
HD1C  2    0.757060    1.175230    0.005588    11.00000   -1.50000
AFIX   0
 
RESI   56   ASN
N     3    0.834054    1.216149   -0.024957    11.00000    0.10936    0.11239 =
         0.14762   -0.04026   -0.00728    0.03044
AFIX  43
H0    2    0.847017    1.215894   -0.020504    11.00000   -1.20000
AFIX   0
CA    1    0.840195    1.242363   -0.031111    11.00000    0.11220    0.11696 =
         0.18916   -0.02133    0.01834    0.04661
AFIX  13
HA    2    0.822042    1.240636   -0.033370    11.00000   -1.20000
AFIX   0
C     1    0.857452    1.249256   -0.043038    11.00000    0.09126    0.13247 =
         0.16167   -0.01436   -0.00613    0.05116
O     4    0.861798    1.270888   -0.048869    11.00000    0.13041    0.14370 =
         0.18422   -0.00323   -0.00115    0.07160
CB    1    0.855012    1.267658   -0.022178    11.00000    0.16130    0.10164 =
         0.15756    0.00285    0.01812    0.04515
AFIX  23
HB1   2    0.868656    1.265710   -0.017115    11.00000   -1.20000
HB2   2    0.865040    1.284932   -0.026995    11.00000   -1.20000
AFIX   0
CG    1    0.833932    1.269251   -0.013872    11.00000    0.24312    0.21440 =
         0.31638   -0.09950    0.06387    0.09171
OD1   4    0.810007    1.261444   -0.017353    11.00000    0.17125    0.38216 =
         0.56771   -0.30896    0.06234    0.04677
ND2   3    0.842649    1.279418   -0.002719    11.00000    0.44183    0.45782 =
         0.21228   -0.02695    0.08992    0.26190
AFIX  93
HD2A  2    0.831353    1.280783    0.002457    11.00000   -1.20000
HD2B  2    0.859712    1.284778   -0.000517    11.00000   -1.20000
AFIX   0
 
RESI   57   VAL
N     3    0.866449    1.232274   -0.046829    11.00000    0.12224    0.09606 =
         0.14607    0.00550    0.03220    0.03380
AFIX  43
H0    2    0.861226    1.217118   -0.042570    11.00000   -1.20000
AFIX   0
CA    1    0.884678    1.237004   -0.057733    11.00000    0.12265    0.11365 =
         0.14596    0.00382    0.02506    0.04517
AFIX  13
HA    2    0.884487    1.251512   -0.063042    11.00000   -1.20000
AFIX   0
C     1    0.873461    1.209954   -0.065283    11.00000    0.11249    0.11713 =
         0.16457   -0.01214    0.03879    0.02625
O     4    0.867067    1.188028   -0.059569    11.00000    0.09450    0.10810 =
         0.16556   -0.01862    0.02875    0.00442
CB    1    0.915109    1.247230   -0.053626    11.00000    0.11332    0.10328 =
         0.15896    0.00495    0.02702    0.03210
AFIX  13
HB    2    0.915300    1.231995   -0.048885    11.00000   -1.20000
AFIX   0
CG1   1    0.934995    1.254278   -0.064820    11.00000    0.12845    0.10050 =
         0.20734   -0.00221    0.05802    0.01143
AFIX  33
HG1A  2    0.928153    1.238091   -0.070184    11.00000   -1.50000
HG1B  2    0.953539    1.259435   -0.061885    11.00000   -1.50000
HG1C  2    0.935766    1.269728   -0.069410    11.00000   -1.50000
AFIX   0
CG2   1    0.925991    1.273027   -0.045015    11.00000    0.13807    0.10746 =
         0.17548   -0.00137    0.01058    0.04116
AFIX  33
HG2A  2    0.913227    1.268702   -0.038115    11.00000   -1.50000
HG2B  2    0.927234    1.288648   -0.049641    11.00000   -1.50000
HG2C  2    0.944322    1.277876   -0.041899    11.00000   -1.50000
AFIX   0
 
RESI   58   VAL
N     3    0.871616    1.211856   -0.077753    11.00000    0.10484    0.12356 =
         0.17807   -0.02183   -0.00313    0.04219
AFIX  43
H0    2    0.874927    1.227540   -0.081068    11.00000   -1.20000
AFIX   0
CA    1    0.864087    1.187621   -0.085602    11.00000    0.16176    0.12967 =
         0.14643    0.00417    0.04932    0.06502
AFIX  13
HA    2    0.849544    1.170706   -0.081346    11.00000   -1.20000
AFIX   0
C     1    0.890548    1.185229   -0.087022    11.00000    0.14654    0.13675 =
         0.17021   -0.00520    0.05169    0.05208
O     4    0.911645    1.203645   -0.091907    11.00000    0.14688    0.14434 =
         0.20344    0.00893    0.04138    0.05006
CB    1    0.853056    1.189695   -0.098453    11.00000    0.15333    0.12705 =
         0.13289    0.01215    0.05285    0.03746
AFIX  13
HB    2    0.866880    1.207712   -0.102217    11.00000   -1.20000
AFIX   0
CG1   1    0.849131    1.166264   -0.107256    11.00000    0.25975    0.18186 =
         0.15822   -0.01895    0.04966    0.09063
AFIX  33
HG1A  2    0.866532    1.166089   -0.107932    11.00000   -1.50000
HG1B  2    0.843668    1.169405   -0.115372    11.00000   -1.50000
HG1C  2    0.834706    1.148463   -0.104037    11.00000   -1.50000
AFIX   0
CG2   1    0.825064    1.189232   -0.097490    11.00000    0.19075    0.22012 =
         0.18326    0.01631    0.03504    0.10191
AFIX  33
HG2A  2    0.827131    1.203997   -0.091974    11.00000   -1.50000
HG2B  2    0.810903    1.171325   -0.094248    11.00000   -1.50000
HG2C  2    0.819516    1.192081   -0.105642    11.00000   -1.50000
AFIX   0
 
RESI   59   GLU
N     3    0.888962    1.161920   -0.082819    11.00000    0.12104    0.14724 =
         0.17089   -0.00084    0.01556    0.04805
AFIX  43
H0    2    0.873035    1.148493   -0.080167    11.00000   -1.20000
AFIX   0
CA    1    0.913635    1.158306   -0.082551    11.00000    0.11349    0.16408 =
         0.19972    0.00235    0.03598    0.04654
AFIX  13
HA    2    0.930009    1.176386   -0.084933    11.00000   -1.20000
AFIX   0
C     1    0.911910    1.136163   -0.091691    11.00000    0.12910    0.15194 =
         0.23101    0.00692    0.04178    0.05384
O     4    0.933402    1.134510   -0.094226    11.00000    0.15699    0.19554 =
         0.28896    0.01669    0.05343    0.09616
CB    1    0.918774    1.151577   -0.069191    11.00000    0.13714    0.10671 =
         0.22588    0.02025    0.03305    0.06095
AFIX  23
HB1   2    0.901936    1.134897   -0.066239    11.00000   -1.20000
HB2   2    0.934002    1.147356   -0.069324    11.00000   -1.20000
AFIX   0
CG    1    0.926257    1.175751   -0.060082    11.00000    0.10665    0.15965 =
         0.20327    0.00149    0.04564    0.07491
AFIX  23
HG1   2    0.942857    1.192501   -0.063156    11.00000   -1.20000
HG2   2    0.910865    1.179725   -0.059876    11.00000   -1.20000
AFIX   0
CD    1    0.931941    1.169781   -0.046889    11.00000    0.11221    0.24961 =
         0.20153    0.02417    0.05172    0.06621
OE1   4    0.911666    1.150517   -0.040958    11.00000    0.14992    0.16494 =
         0.18219   -0.01066    0.04378    0.04950
OE2   4    0.956110    1.184367   -0.042493    11.00000    0.12030    0.38589 =
         0.25389    0.08548    0.02157    0.04006
 
RESI   60   GLY
N     3    0.886923    1.119325   -0.096798    11.00000    0.12580    0.18196 =
         0.20669   -0.02018    0.06469    0.04385
AFIX  43
H0    2    0.872165    1.119335   -0.094042    11.00000   -1.20000
AFIX   0
CA    1    0.884576    1.101058   -0.106953    11.00000    0.18369    0.19433 =
         0.20448   -0.02181    0.10166    0.03424
AFIX  23
HA1   2    0.903459    1.105568   -0.109375    11.00000   -1.20000
HA2   2    0.876296    1.105348   -0.114047    11.00000   -1.20000
AFIX   0
C     1    0.867684    1.070072   -0.104537    11.00000    0.16868    0.18669 =
         0.24707   -0.03913    0.06690    0.02684
O     4    0.864987    1.053063   -0.112949    11.00000    0.24399    0.20775 =
         0.31098   -0.06986    0.10170    0.03256
 
RESI   61   ASN
N     3    0.855642    1.061486   -0.093431    11.00000    0.15710    0.16756 =
         0.30958    0.00958    0.13487    0.07006
AFIX  43
H0    2    0.857655    1.073182   -0.087597    11.00000   -1.20000
AFIX   0
CA    1    0.838660    1.030855   -0.091653    11.00000    0.16625    0.15594 =
         0.37446    0.00131    0.11297    0.08432
AFIX  13
HA    2    0.838300    1.021801   -0.099622    11.00000   -1.20000
AFIX   0
C     1    0.808391    1.021880   -0.088160    11.00000    0.16130    0.13135 =
         0.29279    0.01108    0.10404    0.06910
O     4    0.791551    0.997218   -0.085231    11.00000    0.16662    0.13551 =
         0.30316    0.01609    0.10256    0.08078
CB    1    0.853249    1.021633   -0.081837    11.00000    0.17522    0.18928 =
         0.40924    0.01464    0.10927    0.10378
AFIX  23
HB1   2    0.856344    1.032375   -0.074195    11.00000   -1.20000
HB2   2    0.841116    1.001818   -0.079877    11.00000   -1.20000
AFIX   0
CG    1    0.881276    1.026361   -0.086788    11.00000    0.19972    0.29605 =
         0.45003   -0.05314    0.08820    0.15715
OD1   4    0.881740    1.012863   -0.096177    11.00000    0.39366    0.31415 =
         0.49336   -0.02768    0.16959    0.24439
ND2   3    0.904244    1.045077   -0.080766    11.00000    0.18226    0.32555 =
         0.37736    0.11048    0.05015    0.12653
AFIX  93
HD2A  2    0.920599    1.048506   -0.083262    11.00000   -1.20000
HD2B  2    0.902798    1.053797   -0.074361    11.00000   -1.20000
AFIX   0
 
RESI   62   GLU
N     3    0.800804    1.041496   -0.088942    11.00000    0.13545    0.11938 =
         0.20496   -0.01309    0.06677    0.05246
AFIX  43
H0    2    0.812540    1.058021   -0.091749    11.00000   -1.20000
AFIX   0
CA    1    0.772628    1.034971   -0.085042    11.00000    0.12826    0.10496 =
         0.18634   -0.00008    0.05823    0.04202
AFIX  13
HA    2    0.768402    1.025340   -0.076927    11.00000   -1.20000
AFIX   0
C     1    0.749638    1.016257   -0.094336    11.00000    0.14360    0.12153 =
         0.19655   -0.03338    0.05045    0.05950
O     4    0.753887    1.017283   -0.105510    11.00000    0.17961    0.16612 =
         0.19906   -0.04678    0.06812    0.04979
CB    1    0.771283    1.061881   -0.083621    11.00000    0.12107    0.11329 =
         0.18524   -0.02592    0.02760    0.04587
AFIX  23
HB1   2    0.774469    1.070713   -0.091790    11.00000   -1.20000
HB2   2    0.752285    1.056707   -0.081076    11.00000   -1.20000
AFIX   0
CG    1    0.791403    1.083386   -0.074595    11.00000    0.12066    0.11661 =
         0.16396   -0.01764    0.03158    0.03294
AFIX  23
HG1   2    0.793216    1.073443   -0.067457    11.00000   -1.20000
HG2   2    0.782969    1.094207   -0.071581    11.00000   -1.20000
AFIX   0
CD    1    0.820516    1.103794   -0.079198    11.00000    0.13468    0.11079 =
         0.15070   -0.01981    0.04241    0.03182
OE1   4    0.829033    1.101449   -0.089613    11.00000    0.15784    0.14404 =
         0.17499   -0.02311    0.05633    0.06206
OE2   4    0.836171    1.124475   -0.072110    11.00000    0.09148    0.13495 =
         0.15930   -0.02335    0.01766    0.03836
 
RESI   63   GLN
N     3    0.724143    0.999577   -0.089024    11.00000    0.13647    0.13053 =
         0.18212   -0.02984    0.03695    0.05229
AFIX  43
H0    2    0.723389    0.996511   -0.081096    11.00000   -1.20000
AFIX   0
CA    1    0.697955    0.986596   -0.096106    11.00000    0.14649    0.13458 =
         0.14926   -0.03413    0.04031    0.04952
AFIX  13
HA    2    0.701831    0.994675   -0.104553    11.00000   -1.20000
AFIX   0
C     1    0.677664    0.994137   -0.089567    11.00000    0.12640    0.14033 =
         0.12190   -0.02187    0.03719    0.04113
O     4    0.674066    0.990209   -0.078226    11.00000    0.13990    0.14270 =
         0.12545   -0.01120    0.04397    0.05000
CB    1    0.684863    0.955039   -0.097157    11.00000    0.14033    0.12733 =
         0.14642   -0.01139    0.04338    0.03900
AFIX  23
HB1   2    0.666658    0.947427   -0.101234    11.00000   -1.20000
HB2   2    0.681669    0.947051   -0.088804    11.00000   -1.20000
AFIX   0
CG    1    0.702824    0.945939   -0.104442    11.00000    0.15473    0.10994 =
         0.20444   -0.02936    0.07386    0.02321
AFIX  23
HG1   2    0.703722    0.951452   -0.113138    11.00000   -1.20000
HG2   2    0.721867    0.955607   -0.101117    11.00000   -1.20000
AFIX   0
CD    1    0.691197    0.914406   -0.103748    11.00000    0.15339    0.11368 =
         0.19990    0.01403    0.12647    0.02224
OE1   4    0.666254    0.897481   -0.106030    11.00000    0.16322    0.11699 =
         0.26739   -0.00766    0.10925    0.01096
NE2   3    0.709692    0.906524   -0.100871    11.00000    0.21293    0.14499 =
         0.19589   -0.00674    0.08152    0.06539
AFIX  93
HE2A  2    0.704504    0.888889   -0.100526    11.00000   -1.20000
HE2B  2    0.726931    0.919024   -0.099340    11.00000   -1.20000
AFIX   0
 
RESI   64   PHE
N     3    0.664913    1.004349   -0.096498    11.00000    0.13025    0.11213 =
         0.12640   -0.00003    0.05578    0.02986
AFIX  43
H0    2    0.668712    1.006758   -0.104369    11.00000   -1.20000
AFIX   0
CA    1    0.644689    1.011766   -0.091486    11.00000    0.12349    0.11810 =
         0.13678   -0.01331    0.03877    0.03086
AFIX  13
HA    2    0.643818    1.009503   -0.082365    11.00000   -1.20000
AFIX   0
C     1    0.616038    0.990484   -0.097088    11.00000    0.13466    0.13175 =
         0.10989    0.02090    0.01530    0.03866
O     4    0.612978    0.988788   -0.108432    11.00000    0.19864    0.16270 =
         0.10437    0.00775    0.02123    0.03055
CB    1    0.652943    1.041922   -0.094603    11.00000    0.13879    0.13129 =
         0.13434    0.00098    0.03715    0.04730
AFIX  23
HB1   2    0.653206    1.043483   -0.103656    11.00000   -1.20000
HB2   2    0.637961    1.044984   -0.091599    11.00000   -1.20000
AFIX   0
CG    1    0.680381    1.065868   -0.089801    11.00000    0.19465    0.10612 =
         0.11030   -0.03288    0.02522    0.04526
CD1   1    0.696455    1.063255   -0.080469    11.00000    0.15355    0.10837 =
         0.11557   -0.03831    0.03392    0.03441
AFIX  43
HD1   2    0.690391    1.045638   -0.076904    11.00000   -1.20000
AFIX   0
CD2   1    0.690742    1.092569   -0.095168    11.00000    0.21102    0.12527 =
         0.16196   -0.00863    0.01934    0.03904
AFIX  43
HD2   2    0.680805    1.094615   -0.101760    11.00000   -1.20000
AFIX   0
CE1   1    0.721008    1.085864   -0.076346    11.00000    0.12637    0.09141 =
         0.20056   -0.02276    0.03895    0.03286
AFIX  43
HE1   2    0.731379    1.083641   -0.070003    11.00000   -1.20000
AFIX   0
CE2   1    0.714933    1.115816   -0.091103    11.00000    0.14849    0.12660 =
         0.19627    0.01756    0.05400    0.03174
AFIX  43
HE2   2    0.720826    1.133505   -0.094554    11.00000   -1.20000
AFIX   0
CZ    1    0.730381    1.112322   -0.081737    11.00000    0.17775    0.11167 =
         0.15187   -0.01604    0.04579    0.04342
AFIX  43
HZ    2    0.747155    1.127731   -0.079008    11.00000   -1.20000
AFIX   0
 
RESI   65   ILE
N     3    0.595133    0.974340   -0.089300    11.00000    0.14558    0.09098 =
         0.11234    0.00392    0.01815    0.01736
AFIX  43
H0    2    0.597904    0.977138   -0.081374    11.00000   -1.20000
AFIX   0
CA    1    0.567667    0.952057   -0.093682    11.00000    0.14449    0.09966 =
         0.13606   -0.03061    0.02454    0.02544
AFIX  13
HA    2    0.565375    0.955706   -0.102466    11.00000   -1.20000
AFIX   0
C     1    0.544457    0.952873   -0.085900    11.00000    0.14283    0.09073 =
         0.10487   -0.03304    0.00443    0.03315
O     4    0.545961    0.952422   -0.074372    11.00000    0.15575    0.12573 =
         0.10852   -0.02958    0.00013    0.05360
CB    1    0.565181    0.923048   -0.092759    11.00000    0.14820    0.10865 =
         0.12855   -0.05704   -0.00142    0.03817
AFIX  13
HB    2    0.566073    0.919155   -0.083864    11.00000   -1.20000
AFIX   0
CG1   1    0.588480    0.921011   -0.099352    11.00000    0.17438    0.10419 =
         0.16297   -0.02916    0.03789    0.04194
AFIX  23
HG1A  2    0.606371    0.937269   -0.097029    11.00000   -1.20000
HG1B  2    0.586164    0.922044   -0.108307    11.00000   -1.20000
AFIX   0
CG2   1    0.536247    0.901148   -0.097549    11.00000    0.16236    0.11274 =
         0.14682   -0.05199    0.01121    0.00075
AFIX  33
HG2A  2    0.521996    0.903211   -0.093233    11.00000   -1.50000
HG2B  2    0.533391    0.882598   -0.096071    11.00000   -1.50000
HG2C  2    0.535069    0.903797   -0.106369    11.00000   -1.50000
AFIX   0
CD1   1    0.589923    0.894689   -0.096634    11.00000    0.20560    0.13866 =
         0.18812   -0.02208    0.04857    0.08135
AFIX  33
HD1A  2    0.605489    0.895420   -0.101108    11.00000   -1.50000
HD1B  2    0.572688    0.878414   -0.099258    11.00000   -1.50000
HD1C  2    0.592510    0.893497   -0.087810    11.00000   -1.50000
AFIX   0
 
RESI   66   SER
N     3    0.524778    0.955247   -0.092439    11.00000    0.15463    0.13940 =
         0.11860    0.02977    0.02592    0.04553
AFIX  43
H0    2    0.525644    0.956033   -0.100481    11.00000   -1.20000
AFIX   0
CA    1    0.501988    0.956496   -0.085987    11.00000    0.10659    0.13942 =
         0.13322    0.00422   -0.00818    0.01832
AFIX  13
HA    2    0.510050    0.970399   -0.079219    11.00000   -1.20000
AFIX   0
C     1    0.481472    0.927895   -0.080358    11.00000    0.16393    0.11938 =
         0.14864    0.01255    0.03909    0.05288
O     4    0.476580    0.905582   -0.085405    11.00000    0.15972    0.13565 =
         0.19775   -0.03215    0.02333    0.03894
CB    1    0.486152    0.965405   -0.094952    11.00000    0.17366    0.23541 =
         0.23303    0.09626    0.01191    0.08424
AFIX  23
HB1   2    0.479370    0.952744   -0.102084    11.00000   -1.20000
HB2   2    0.470012    0.964475   -0.090734    11.00000   -1.20000
AFIX   0
OG    4    0.504648    0.993378   -0.099060    11.00000    0.32375    0.23860 =
         0.29088    0.13262    0.11070    0.13564
AFIX  83
HG    2    0.518212    0.994031   -0.102643    11.00000   -1.50000
AFIX   0
 
RESI   67   ALA
N     3    0.469371    0.927848   -0.069689    11.00000    0.14050    0.12965 =
         0.16831    0.00754    0.04202    0.04888
AFIX  43
H0    2    0.475043    0.943633   -0.065885    11.00000   -1.20000
AFIX   0
CA    1    0.446696    0.902118   -0.064023    11.00000    0.14425    0.14062 =
         0.15111    0.02184    0.03460    0.06135
AFIX  13
HA    2    0.452232    0.887636   -0.064124    11.00000   -1.20000
AFIX   0
C     1    0.419919    0.891627   -0.071775    11.00000    0.14604    0.15938 =
         0.15972    0.06881    0.02721    0.04019
O     4    0.412950    0.907921   -0.075922    11.00000    0.16474    0.17397 =
         0.19877    0.04776    0.02289    0.06987
CB    1    0.442088    0.907550   -0.050510    11.00000    0.20778    0.15798 =
         0.14639    0.02230    0.04308    0.06594
AFIX  33
HB1   2    0.459433    0.914596   -0.045944    11.00000   -1.50000
HB2   2    0.427934    0.890269   -0.046770    11.00000   -1.50000
HB3   2    0.435987    0.921218   -0.050279    11.00000   -1.50000
AFIX   0
 
RESI   68   SER
N     3    0.404626    0.863835   -0.073588    11.00000    0.13827    0.16149 =
         0.17622    0.05320    0.01951    0.04381
AFIX  43
H0    2    0.411191    0.853355   -0.071017    11.00000   -1.20000
AFIX   0
CA    1    0.377130    0.850518   -0.079778    11.00000    0.15698    0.17336 =
         0.15494    0.04023    0.00473    0.06372
AFIX  13
HA    2    0.376189    0.864775   -0.084980    11.00000   -1.20000
AFIX   0
C     1    0.353046    0.839580   -0.070257    11.00000    0.12951    0.15856 =
         0.14864    0.02235   -0.00670    0.02142
O     4    0.330022    0.837228   -0.072875    11.00000    0.15209    0.20439 =
         0.19185    0.06851    0.00566    0.05764
CB    1    0.372665    0.826283   -0.088204    11.00000    0.20938    0.20448 =
         0.19461    0.00714    0.01073    0.07736
AFIX  23
HB1   2    0.353798    0.817519   -0.091705    11.00000   -1.20000
HB2   2    0.385981    0.833648   -0.095092    11.00000   -1.20000
AFIX   0
OG    4    0.376115    0.805736   -0.081809    11.00000    0.21421    0.16917 =
         0.23810   -0.00392    0.00736    0.06684
AFIX  83
HG    2    0.373459    0.793030   -0.086664    11.00000   -1.50000
AFIX   0
 
RESI   69   LYS
N     3    0.358141    0.832231   -0.059277    11.00000    0.12179    0.17996 =
         0.12606   -0.00904   -0.00025    0.04813
AFIX  43
H0    2    0.374392    0.833944   -0.057858    11.00000   -1.20000
AFIX   0
CA    1    0.336702    0.821188   -0.049412    11.00000    0.16588    0.12347 =
         0.13306   -0.00861    0.02177    0.05641
AFIX  13
HA    2    0.326765    0.831917   -0.049575    11.00000   -1.20000
AFIX   0
C     1    0.351180    0.825943   -0.036722    11.00000    0.11769    0.14391 =
         0.13282    0.02591    0.04322    0.03758
O     4    0.373095    0.825141   -0.036269    11.00000    0.16181    0.14877 =
         0.18355    0.01774    0.03028    0.08099
CB    1    0.315140    0.790204   -0.051782    11.00000    0.21168    0.14046 =
         0.15927   -0.02094    0.04034    0.02941
AFIX  23
HB1   2    0.300092    0.784694   -0.045714    11.00000   -1.20000
HB2   2    0.306982    0.788996   -0.059982    11.00000   -1.20000
AFIX   0
CG    1    0.324119    0.768887   -0.051334    11.00000    0.40606    0.11870 =
         0.34406    0.02696    0.03242    0.08689
AFIX  23
HG1   2    0.332311    0.769645   -0.043188    11.00000   -1.20000
HG2   2    0.338648    0.773517   -0.057587    11.00000   -1.20000
AFIX   0
CD    1    0.299900    0.738808   -0.053666    11.00000    0.61485    0.12119 =
         0.43074    0.03597   -0.15729    0.06475
AFIX  23
HD1   2    0.305685    0.725524   -0.050988    11.00000   -1.20000
HD2   2    0.283791    0.735543   -0.048630    11.00000   -1.20000
AFIX   0
CE    1    0.291075    0.733340   -0.067345    11.00000    0.74928    0.21559 =
         0.41972   -0.01870   -0.14110    0.11485
AFIX  23
HE1   2    0.278259    0.740316   -0.069104    11.00000   -1.20000
HE2   2    0.307599    0.743617   -0.072603    11.00000   -1.20000
AFIX   0
NZ    3    0.276904    0.702530   -0.070508    11.00000    0.74535    0.19876 =
         0.26157    0.04684    0.05619    0.11784
AFIX  33
HZ1   2    0.271049    0.699980   -0.078425    11.00000   -1.50000
HZ2   2    0.262178    0.692942   -0.065465    11.00000   -1.50000
HZ3   2    0.289079    0.696394   -0.069511    11.00000   -1.50000
AFIX   0
 
RESI   70   SER
N     3    0.338518    0.829024   -0.026960    11.00000    0.12055    0.13366 =
         0.11910    0.02836    0.03923    0.02994
AFIX  43
H0    2    0.324067    0.830799   -0.028520    11.00000   -1.20000
AFIX   0
CA    1    0.345737    0.829823   -0.013888    11.00000    0.18000    0.18561 =
         0.12369    0.01981    0.02790    0.07844
AFIX  13
HA    2    0.361323    0.825925   -0.013219    11.00000   -1.20000
AFIX   0
C     1    0.320217    0.806665   -0.006964    11.00000    0.16115    0.19865 =
         0.07579    0.00241    0.00836    0.06175
O     4    0.295973    0.801413   -0.009358    11.00000    0.17594    0.22345 =
         0.14233    0.02174    0.02663    0.10173
CB    1    0.355026    0.858756   -0.007929    11.00000    0.32030    0.17839 =
         0.15329   -0.01011   -0.06107    0.06968
AFIX  23
HB1   2    0.339627    0.862702   -0.008333    11.00000   -1.20000
HB2   2    0.359641    0.858425    0.000816    11.00000   -1.20000
AFIX   0
OG    4    0.378712    0.880171   -0.014213    11.00000    0.59599    0.22286 =
         0.27653    0.03285    0.03886   -0.03232
AFIX  83
HG    2    0.383841    0.895333   -0.010736    11.00000   -1.50000
AFIX   0
 
RESI   71   ILE
N     3    0.326488    0.792870    0.001570    11.00000    0.14799    0.16064 =
         0.09441   -0.00724    0.02474    0.06352
AFIX  43
H0    2    0.343697    0.796781    0.002421    11.00000   -1.20000
AFIX   0
CA    1    0.304725    0.771312    0.009468    11.00000    0.10124    0.14768 =
         0.11090   -0.00411    0.00840    0.06445
AFIX  13
HA    2    0.287793    0.773051    0.008863    11.00000   -1.20000
AFIX   0
C     1    0.314819    0.776676    0.022997    11.00000    0.07569    0.11687 =
         0.10745    0.00370    0.01601    0.03105
O     4    0.333793    0.773053    0.026771    11.00000    0.11298    0.11788 =
         0.13022   -0.01865   -0.01418    0.05680
CB    1    0.296842    0.741352    0.005659    11.00000    0.11668    0.15385 =
         0.13106   -0.02216    0.00035    0.06573
AFIX  13
HB    2    0.313694    0.739597    0.006678    11.00000   -1.20000
AFIX   0
CG1   1    0.287727    0.735040   -0.008031    11.00000    0.19068    0.14559 =
         0.15207   -0.03176   -0.04905    0.07846
AFIX  23
HG1A  2    0.269491    0.733811   -0.008828    11.00000   -1.20000
HG1B  2    0.301014    0.751022   -0.013013    11.00000   -1.20000
AFIX   0
CG2   1    0.274523    0.720771    0.014807    11.00000    0.10570    0.12463 =
         0.16558   -0.04361    0.00234    0.04352
AFIX  33
HG2A  2    0.269293    0.701790    0.012557    11.00000   -1.50000
HG2B  2    0.258201    0.722971    0.014456    11.00000   -1.50000
HG2C  2    0.282067    0.724634    0.023150    11.00000   -1.50000
AFIX   0
CD1   1    0.285470    0.708851   -0.013661    11.00000    0.19277    0.13954 =
         0.12599   -0.00325    0.00882    0.07543
AFIX  33
HD1A  2    0.279270    0.707065   -0.022193    11.00000   -1.50000
HD1B  2    0.272116    0.692670   -0.008976    11.00000   -1.50000
HD1C  2    0.303581    0.710072   -0.013414    11.00000   -1.50000
AFIX   0
 
RESI   72   VAL
N     3    0.302081    0.786545    0.030098    11.00000    0.10709    0.15268 =
         0.11375   -0.01098    0.00878    0.06121
AFIX  43
H0    2    0.290350    0.790527    0.026597    11.00000   -1.20000
AFIX   0
CA    1    0.306616    0.791109    0.043453    11.00000    0.05419    0.14401 =
         0.10571   -0.00309    0.00500    0.04348
AFIX  13
HA    2    0.326580    0.797949    0.045213    11.00000   -1.20000
AFIX   0
C     1    0.289063    0.763214    0.050198    11.00000    0.08727    0.11596 =
         0.10651   -0.02740   -0.00882    0.03805
O     4    0.265302    0.745972    0.046568    11.00000    0.08340    0.13058 =
         0.13337   -0.02987   -0.00482    0.03533
CB    1    0.299737    0.813706    0.047450    11.00000    0.08598    0.13310 =
         0.08978    0.00750    0.00144    0.05142
AFIX  13
HB    2    0.281510    0.808850    0.043709    11.00000   -1.20000
AFIX   0
CG1   1    0.296795    0.815140    0.061431    11.00000    0.10052    0.13500 =
         0.09978   -0.01677    0.01715    0.02470
AFIX  33
HG1A  2    0.282882    0.796928    0.064495    11.00000   -1.50000
HG1B  2    0.291041    0.828669    0.063323    11.00000   -1.50000
HG1C  2    0.314590    0.820737    0.065376    11.00000   -1.50000
AFIX   0
CG2   1    0.321559    0.842874    0.042431    11.00000    0.12261    0.15112 =
         0.15600    0.03213    0.06550    0.06253
AFIX  33
HG2A  2    0.323632    0.841747    0.033557    11.00000   -1.50000
HG2B  2    0.339374    0.849012    0.046464    11.00000   -1.50000
HG2C  2    0.315320    0.856107    0.044132    11.00000   -1.50000
AFIX   0
 
RESI   73   HIS
N     3    0.300766    0.758923    0.060209    11.00000    0.07893    0.14165 =
         0.11860    0.00522    0.00700    0.03897
AFIX  43
H0    2    0.317335    0.771836    0.062476    11.00000   -1.20000
AFIX   0
CA    1    0.286387    0.733006    0.067467    11.00000    0.08625    0.10601 =
         0.09475   -0.02608    0.01317    0.02178
AFIX  13
HA    2    0.284376    0.717513    0.062149    11.00000   -1.20000
AFIX   0
C     1    0.256795    0.726556    0.071291    11.00000    0.08793    0.10928 =
         0.11689   -0.01577    0.01014    0.03745
O     4    0.253193    0.745765    0.075304    11.00000    0.10434    0.11110 =
         0.12367   -0.01182    0.00620    0.04439
CB    1    0.303711    0.734280    0.079127    11.00000    0.08846    0.10839 =
         0.11184   -0.00611    0.01595    0.03624
AFIX  23
HB1   2    0.323368    0.741967    0.076854    11.00000   -1.20000
HB2   2    0.302563    0.746445    0.085422    11.00000   -1.20000
AFIX   0
CG    1    0.292124    0.705079    0.084264    11.00000    0.10953    0.10995 =
         0.11194   -0.01074    0.03218    0.04163
ND1   3    0.297588    0.684145    0.081784    11.00000    0.17256    0.13236 =
         0.19593    0.01866    0.06222    0.08211
AFIX  43
HD1   2    0.309780    0.684940    0.076475    11.00000   -1.20000
AFIX   0
CE1   1    0.280990    0.662046    0.088911    11.00000    0.12147    0.13126 =
         0.09600   -0.00122    0.00186    0.06832
AFIX  43
HE1   2    0.280864    0.644995    0.088757    11.00000   -1.20000
AFIX   0
NE2   3    0.264696    0.667295    0.096242    11.00000    0.16105    0.10702 =
         0.14961   -0.00281    0.03728    0.05380
CD2   1    0.273165    0.694059    0.093488    11.00000    0.14292    0.09268 =
         0.07128   -0.02110    0.01417    0.03624
AFIX  43
HD2   2    0.266383    0.704357    0.097678    11.00000   -1.20000
AFIX   0
 
RESI   74   PRO
N     3    0.235756    0.700324    0.070161    11.00000    0.08055    0.11671 =
         0.14089   -0.02486    0.00654    0.03581
CA    1    0.206839    0.693348    0.073163    11.00000    0.08782    0.13067 =
         0.11302   -0.03197    0.01976    0.03498
AFIX  13
HA    2    0.200325    0.701904    0.066902    11.00000   -1.20000
AFIX   0
C     1    0.202997    0.702141    0.086105    11.00000    0.13329    0.11023 =
         0.09234   -0.00791    0.01312    0.06085
O     4    0.184841    0.708447    0.088788    11.00000    0.10922    0.15702 =
         0.11669   -0.03248    0.02218    0.05861
CB    1    0.189206    0.661115    0.072115    11.00000    0.07847    0.13947 =
         0.18750   -0.07581   -0.03137    0.01633
AFIX  23
HB1   2    0.178127    0.653133    0.079648    11.00000   -1.20000
HB2   2    0.176497    0.655733    0.065013    11.00000   -1.20000
AFIX   0
CG    1    0.209508    0.650973    0.070425    11.00000    0.12084    0.11852 =
         0.34146   -0.01879   -0.00255    0.03745
AFIX  23
HG1   2    0.202065    0.635431    0.064519    11.00000   -1.20000
HG2   2    0.212730    0.644383    0.078349    11.00000   -1.20000
AFIX   0
CD    1    0.237020    0.675386    0.065512    11.00000    0.09996    0.12635 =
         0.22157   -0.05505   -0.00647    0.04658
AFIX  23
HD1   2    0.253212    0.674893    0.068900    11.00000   -1.20000
HD2   2    0.237762    0.675218    0.056439    11.00000   -1.20000
AFIX   0
 
RESI   75   SER
N     3    0.217967    0.701982    0.095275    11.00000    0.12805    0.10816 =
         0.11017   -0.00860    0.01667    0.04652
AFIX  43
H0    2    0.229789    0.696634    0.093270    11.00000   -1.20000
AFIX   0
CA    1    0.218787    0.709163    0.108509    11.00000    0.09251    0.11835 =
         0.10852   -0.00750   -0.01022    0.03463
AFIX  13
HA    2    0.201020    0.708860    0.110145    11.00000   -1.20000
AFIX   0
C     1    0.242360    0.738622    0.112637    11.00000    0.10817    0.11176 =
         0.09972   -0.00221   -0.00109    0.03734
O     4    0.245724    0.744820    0.124030    11.00000    0.12880    0.12364 =
         0.09280   -0.00707   -0.00094    0.05581
CB    1    0.218716    0.686822    0.117224    11.00000    0.15501    0.10933 =
         0.12333    0.00289    0.00143    0.04235
AFIX  23
HB1   2    0.236404    0.686892    0.116422    11.00000   -1.20000
HB2   2    0.216796    0.691157    0.125850    11.00000   -1.20000
AFIX   0
OG    4    0.195638    0.659471    0.113966    11.00000    0.17566    0.13177 =
         0.22676    0.03066    0.01118   -0.00629
AFIX  83
HG    2    0.180742    0.659541    0.114593    11.00000   -1.50000
AFIX   0
 
RESI   76   TYR
N     3    0.257511    0.756575    0.103587    11.00000    0.07769    0.11636 =
         0.09064   -0.00951    0.01474    0.04033
AFIX  43
H0    2    0.254885    0.751484    0.095857    11.00000   -1.20000
AFIX   0
CA    1    0.278948    0.785483    0.107244    11.00000    0.11430    0.10541 =
         0.11249    0.00323    0.02139    0.05441
AFIX  13
HA    2    0.292861    0.784260    0.112582    11.00000   -1.20000
AFIX   0
C     1    0.266504    0.800288    0.114573    11.00000    0.09880    0.10149 =
         0.12366    0.00177    0.02270    0.04390
O     4    0.245393    0.800646    0.110654    11.00000    0.12060    0.14219 =
         0.13327   -0.02764   -0.00491    0.07368
CB    1    0.294237    0.802610    0.095591    11.00000    0.11396    0.10548 =
         0.10646    0.00452    0.01457    0.05125
AFIX  23
HB1   2    0.304559    0.794375    0.091800    11.00000   -1.20000
HB2   2    0.280300    0.801178    0.089575    11.00000   -1.20000
AFIX   0
CG    1    0.314554    0.833460    0.098203    11.00000    0.10267    0.10013 =
         0.10810   -0.01462    0.01902    0.05284
CD1   1    0.336576    0.841209    0.106492    11.00000    0.08252    0.11889 =
         0.16220    0.00500    0.01353    0.03822
AFIX  43
HD1   2    0.338484    0.827004    0.110334    11.00000   -1.20000
AFIX   0
CD2   1    0.312653    0.855605    0.092937    11.00000    0.15132    0.10686 =
         0.12637   -0.02033    0.00074    0.06751
AFIX  43
HD2   2    0.297957    0.851422    0.087401    11.00000   -1.20000
AFIX   0
CE1   1    0.355855    0.868752    0.109391    11.00000    0.09939    0.13233 =
         0.12778   -0.04562    0.00506    0.06824
AFIX  43
HE1   2    0.370383    0.872900    0.115022    11.00000   -1.20000
AFIX   0
CE2   1    0.331681    0.883770    0.095543    11.00000    0.10770    0.09842 =
         0.20706    0.00136    0.02004    0.06351
AFIX  43
HE2   2    0.329876    0.898106    0.091774    11.00000   -1.20000
AFIX   0
CZ    1    0.353369    0.889951    0.103880    11.00000    0.07980    0.11536 =
         0.21703   -0.02733    0.02546    0.05387
OH    4    0.372460    0.917341    0.106808    11.00000    0.11056    0.12503 =
         0.26581   -0.02325    0.02631    0.03880
AFIX  83
HH    2    0.368678    0.927919    0.102897    11.00000   -1.50000
AFIX   0
 
RESI   77   ASN
N     3    0.280856    0.812859    0.125129    11.00000    0.11521    0.13264 =
         0.12511   -0.01122    0.00952    0.07853
AFIX  43
H0    2    0.295068    0.811064    0.127189    11.00000   -1.20000
AFIX   0
CA    1    0.273018    0.829365    0.133135    11.00000    0.10245    0.14711 =
         0.12489   -0.01199    0.00176    0.08325
AFIX  13
HA    2    0.256974    0.829999    0.129418    11.00000   -1.20000
AFIX   0
C     1    0.298155    0.859130    0.133933    11.00000    0.12486    0.13795 =
         0.13264   -0.02902   -0.01053    0.07835
O     4    0.320040    0.864637    0.139317    11.00000    0.17049    0.13346 =
         0.22082   -0.05271   -0.08278    0.09121
CB    1    0.264987    0.816396    0.146166    11.00000    0.19233    0.12937 =
         0.10567   -0.03476   -0.00146    0.09052
AFIX  23
HB1   2    0.281148    0.816706    0.150063    11.00000   -1.20000
HB2   2    0.250018    0.796895    0.145515    11.00000   -1.20000
AFIX   0
CG    1    0.255088    0.832859    0.154267    11.00000    0.18473    0.15945 =
         0.12884   -0.04515   -0.00212    0.10304
OD1   4    0.268514    0.858657    0.155522    11.00000    0.22578    0.14978 =
         0.15938   -0.02536    0.02856    0.12490
ND2   3    0.230205    0.816884    0.159308    11.00000    0.21828    0.19316 =
         0.27170   -0.07553    0.07025    0.08389
AFIX  93
HD2A  2    0.222531    0.824365    0.163734    11.00000   -1.20000
HD2B  2    0.221556    0.798921    0.158189    11.00000   -1.20000
AFIX   0
 
RESI   78   SER
N     3    0.294874    0.878670    0.128239    11.00000    0.08899    0.14476 =
         0.15731   -0.01990   -0.00244    0.07043
AFIX  43
H0    2    0.278962    0.874437    0.124874    11.00000   -1.20000
AFIX   0
CA    1    0.318362    0.907391    0.127700    11.00000    0.13248    0.12849 =
         0.17280   -0.02487   -0.00305    0.07574
AFIX  13
HA    2    0.335155    0.906617    0.125140    11.00000   -1.20000
AFIX   0
C     1    0.325169    0.923751    0.140015    11.00000    0.20165    0.15419 =
         0.21400   -0.06881   -0.02489    0.11787
O     4    0.347807    0.945670    0.141153    11.00000    0.20527    0.20808 =
         0.30274   -0.11814   -0.05279    0.09530
CB    1    0.312150    0.923298    0.117530    11.00000    0.14589    0.12600 =
         0.24714   -0.03482   -0.06072    0.08101
AFIX  23
HB1   2    0.328061    0.942272    0.116676    11.00000   -1.20000
HB2   2    0.309205    0.913727    0.109556    11.00000   -1.20000
AFIX   0
OG    4    0.287598    0.924427    0.120887    11.00000    0.20103    0.17590 =
         0.28480    0.01357   -0.00058    0.13545
AFIX  83
HG    2    0.284354    0.933143    0.115519    11.00000   -1.50000
AFIX   0
 
RESI   79   ASN
N     3    0.306348    0.913548    0.148873    11.00000    0.24493    0.17649 =
         0.13923   -0.03410   -0.04384    0.15366
AFIX  43
H0    2    0.290470    0.898773    0.147168    11.00000   -1.20000
AFIX   0
CA    1    0.310071    0.925230    0.161498    11.00000    0.30917    0.19022 =
         0.17580   -0.07728   -0.06663    0.17744
AFIX  13
HA    2    0.318891    0.945742    0.160615    11.00000   -1.20000
AFIX   0
C     1    0.330817    0.919447    0.168885    11.00000    0.31909    0.18421 =
         0.13940   -0.09210   -0.08432    0.16944
O     4    0.351706    0.937687    0.174066    11.00000    0.43153    0.18513 =
         0.23986   -0.08055   -0.19452    0.14838
CB    1    0.281476    0.914874    0.167965    11.00000    0.35980    0.26283 =
         0.16312   -0.07618   -0.03286    0.23652
AFIX  23
HB1   2    0.270653    0.894463    0.167403    11.00000   -1.20000
HB2   2    0.284765    0.919815    0.176770    11.00000   -1.20000
AFIX   0
CG    1    0.264016    0.926862    0.162516    11.00000    0.29687    0.34645 =
         0.29556    0.02255   -0.04347    0.20652
OD1   4    0.273872    0.948834    0.156061    11.00000    0.49533    0.35452 =
         0.28285    0.01884   -0.00202    0.31256
ND2   3    0.236432    0.912853    0.164916    11.00000    0.32874    0.66066 =
         0.50621    0.10065    0.05827    0.30419
AFIX  93
HD2A  2    0.225799    0.918967    0.162043    11.00000   -1.20000
HD2B  2    0.229262    0.897698    0.169338    11.00000   -1.20000
AFIX   0
 
RESI   80   THR
N     3    0.326357    0.893361    0.168636    11.00000    0.20053    0.16767 =
         0.11753   -0.04280   -0.01441    0.12254
AFIX  43
H0    2    0.313105    0.881364    0.163875    11.00000   -1.20000
AFIX   0
CA    1    0.342424    0.883539    0.175905    11.00000    0.18185    0.16012 =
         0.10904   -0.04466   -0.01984    0.10198
AFIX  13
HA    2    0.352032    0.896908    0.182744    11.00000   -1.20000
AFIX   0
C     1    0.364362    0.880856    0.168253    11.00000    0.15578    0.14857 =
         0.11776   -0.01657   -0.01940    0.08619
O     4    0.381718    0.876329    0.173773    11.00000    0.15775    0.12642 =
         0.13276   -0.01403   -0.02464    0.07684
CB    1    0.321972    0.854685    0.181576    11.00000    0.20028    0.16354 =
         0.10141   -0.03498    0.00400    0.11420
AFIX  13
HB    2    0.332341    0.847954    0.186648    11.00000   -1.20000
AFIX   0
OG1   4    0.305037    0.833808    0.172328    11.00000    0.20076    0.16143 =
         0.15985   -0.04609   -0.02588    0.10993
AFIX  83
HG1   2    0.315367    0.831659    0.167441    11.00000   -1.50000
AFIX   0
CG2   1    0.298408    0.854663    0.189377    11.00000    0.16837    0.20991 =
         0.15605   -0.04252   -0.00197    0.10905
AFIX  33
HG2A  2    0.286255    0.836067    0.192623    11.00000   -1.50000
HG2B  2    0.287666    0.860186    0.184191    11.00000   -1.50000
HG2C  2    0.306567    0.867724    0.196197    11.00000   -1.50000
AFIX   0
 
RESI   81   LEU
N     3    0.363454    0.881992    0.155857    11.00000    0.12315    0.13396 =
         0.11712   -0.00634    0.00535    0.07151
AFIX  43
H0    2    0.352076    0.886964    0.152777    11.00000   -1.20000
AFIX   0
CA    1    0.379579    0.875750    0.146955    11.00000    0.09186    0.09662 =
         0.15324   -0.00201    0.01336    0.05109
AFIX  13
HA    2    0.373543    0.877773    0.138567    11.00000   -1.20000
AFIX   0
C     1    0.374843    0.846384    0.147865    11.00000    0.10859    0.10116 =
         0.14587    0.03155    0.02221    0.05664
O     4    0.389927    0.837930    0.143613    11.00000    0.12445    0.12284 =
         0.16642   -0.00025    0.01260    0.07854
CB    1    0.411100    0.897581    0.148058    11.00000    0.09500    0.12255 =
         0.20035   -0.01472   -0.00422    0.03837
AFIX  23
HB1   2    0.417311    0.896545    0.156449    11.00000   -1.20000
HB2   2    0.421417    0.892422    0.142265    11.00000   -1.20000
AFIX   0
CG    1    0.418880    0.927714    0.145500    11.00000    0.11934    0.13519 =
         0.34699    0.08132   -0.02455    0.01222
AFIX  13
HG    2    0.413811    0.934933    0.152860    11.00000   -1.20000
AFIX   0
CD1   1    0.450805    0.946206    0.143322    11.00000    0.11445    0.13134 =
         0.38468    0.06731   -0.00407    0.04492
AFIX  33
HD1A  2    0.460796    0.944812    0.150424    11.00000   -1.50000
HD1B  2    0.455497    0.965480    0.142229    11.00000   -1.50000
HD1C  2    0.456059    0.939873    0.135954    11.00000   -1.50000
AFIX   0
CD2   1    0.404117    0.930830    0.134370    11.00000    0.15257    0.10636 =
         0.33276    0.02297   -0.07218    0.00065
AFIX  33
HD2A  2    0.409541    0.950321    0.133343    11.00000   -1.50000
HD2B  2    0.384086    0.919846    0.135598    11.00000   -1.50000
HD2C  2    0.409239    0.924325    0.127018    11.00000   -1.50000
AFIX   0
 
RESI   82   ASN
N     3    0.352061    0.825903    0.152843    11.00000    0.13248    0.10944 =
         0.10445    0.01044    0.01737    0.04626
AFIX  43
H0    2    0.341295    0.830870    0.156569    11.00000   -1.20000
AFIX   0
CA    1    0.342364    0.796180    0.152993    11.00000    0.11413    0.09740 =
         0.12076    0.00407    0.02302    0.03458
AFIX  13
HA    2    0.357837    0.793519    0.155934    11.00000   -1.20000
AFIX   0
C     1    0.335881    0.786185    0.139373    11.00000    0.10633    0.12171 =
         0.11400    0.00564    0.01366    0.06676
O     4    0.321282    0.792188    0.132692    11.00000    0.10668    0.09756 =
         0.14848    0.02684    0.02175    0.05907
CB    1    0.316630    0.778868    0.161433    11.00000    0.11077    0.10913 =
         0.11215    0.00997    0.01387    0.04161
AFIX  23
HB1   2    0.319448    0.788861    0.169281    11.00000   -1.20000
HB2   2    0.300099    0.777532    0.157427    11.00000   -1.20000
AFIX   0
CG    1    0.310974    0.749389    0.164229    11.00000    0.11409    0.10829 =
         0.13679    0.01659    0.01434    0.04370
OD1   4    0.330845    0.744906    0.164044    11.00000    0.13796    0.15182 =
         0.11662    0.04963    0.03210    0.07522
ND2   3    0.284974    0.730391    0.167207    11.00000    0.13105    0.12268 =
         0.22360    0.03377    0.04886    0.04308
AFIX  93
HD2A  2    0.281017    0.713576    0.169192    11.00000   -1.20000
HD2B  2    0.271921    0.734776    0.167170    11.00000   -1.20000
AFIX   0
 
RESI   83   ASN
N     3    0.346168    0.770446    0.135222    11.00000    0.07137    0.10480 =
         0.10704    0.00129   -0.00178    0.04516
AFIX  43
H0    2    0.355440    0.766333    0.140495    11.00000   -1.20000
AFIX   0
CA    1    0.343345    0.759349    0.122566    11.00000    0.08980    0.12538 =
         0.10315    0.00325    0.02495    0.04420
AFIX  13
HA    2    0.352886    0.748239    0.122399    11.00000   -1.20000
AFIX   0
C     1    0.358666    0.783742    0.113112    11.00000    0.10463    0.09474 =
         0.10440   -0.00942    0.00293    0.04239
O     4    0.346622    0.783510    0.103534    11.00000    0.09343    0.10613 =
         0.09549   -0.01147    0.01355    0.04097
CB    1    0.312965    0.739814    0.119135    11.00000    0.11390    0.10087 =
         0.09057    0.00438   -0.00248    0.04368
AFIX  23
HB1   2    0.312399    0.731580    0.111021    11.00000   -1.20000
HB2   2    0.303735    0.750924    0.118260    11.00000   -1.20000
AFIX   0
CG    1    0.296334    0.716391    0.128195    11.00000    0.09900    0.09922 =
         0.09426    0.00185   -0.00034    0.03924
OD1   4    0.300941    0.696843    0.129232    11.00000    0.09892    0.10249 =
         0.19521    0.04194    0.05033    0.04052
ND2   3    0.277182    0.719209    0.134498    11.00000    0.13513    0.08889 =
         0.17217    0.00915    0.04924    0.04340
AFIX  93
HD2A  2    0.266662    0.706613    0.139875    11.00000   -1.20000
HD2B  2    0.275206    0.733644    0.133234    11.00000   -1.20000
AFIX   0
 
RESI   84   ASP
N     3    0.384670    0.803887    0.115966    11.00000    0.10403    0.08306 =
         0.10013   -0.00964    0.00316    0.04430
AFIX  43
H0    2    0.392059    0.802046    0.122752    11.00000   -1.20000
AFIX   0
CA    1    0.401571    0.829023    0.108307    11.00000    0.11494    0.08792 =
         0.08949   -0.00337    0.00681    0.04585
AFIX  13
HA    2    0.388921    0.835025    0.104733    11.00000   -1.20000
AFIX   0
C     1    0.415356    0.822225    0.097636    11.00000    0.09597    0.08245 =
         0.12168   -0.00490    0.00911    0.05151
O     4    0.440855    0.829483    0.097491    11.00000    0.10098    0.07443 =
         0.12887   -0.00029    0.00694    0.03998
CB    1    0.423915    0.853375    0.116166    11.00000    0.08270    0.10457 =
         0.10025   -0.00292    0.01663    0.03236
AFIX  23
HB1   2    0.415245    0.854757    0.123855    11.00000   -1.20000
HB2   2    0.438550    0.849113    0.118420    11.00000   -1.20000
AFIX   0
CG    1    0.437324    0.881521    0.109568    11.00000    0.08001    0.10512 =
         0.11317    0.00101    0.00425    0.02674
OD1   4    0.426495    0.883437    0.099527    11.00000    0.08630    0.10108 =
         0.11286   -0.00672    0.00755    0.04074
OD2   4    0.458556    0.901220    0.114843    11.00000    0.10166    0.10075 =
         0.12254    0.00853   -0.00392    0.03416
 
RESI   85   ILE
N     3    0.397879    0.807692    0.088198    11.00000    0.08808    0.08777 =
         0.11395   -0.00784    0.02133    0.04562
AFIX  43
H0    2    0.380697    0.804121    0.088463    11.00000   -1.20000
AFIX   0
CA    1    0.407091    0.797787    0.077529    11.00000    0.09032    0.07537 =
         0.10915    0.00456    0.01623    0.04531
AFIX  13
HA    2    0.426915    0.811712    0.075930    11.00000   -1.20000
AFIX   0
C     1    0.390217    0.796926    0.066020    11.00000    0.08329    0.08463 =
         0.11972    0.00320    0.00959    0.04257
O     4    0.364781    0.788558    0.066653    11.00000    0.08553    0.10310 =
         0.12122   -0.00759    0.00939    0.04527
CB    1    0.405368    0.768983    0.080133    11.00000    0.09969    0.06992 =
         0.11369   -0.00281    0.00672    0.04258
AFIX  13
HB    2    0.417122    0.771694    0.087506    11.00000   -1.20000
AFIX   0
CG1   1    0.417809    0.760319    0.069451    11.00000    0.11071    0.09442 =
         0.16252   -0.01882    0.01415    0.06059
AFIX  23
HG1A  2    0.404920    0.754682    0.062408    11.00000   -1.20000
HG1B  2    0.435312    0.776745    0.066868    11.00000   -1.20000
AFIX   0
CG2   1    0.375506    0.746569    0.083581    11.00000    0.11758    0.08404 =
         0.12321    0.01263    0.02010    0.02840
AFIX  33
HG2A  2    0.368939    0.753210    0.090396    11.00000   -1.50000
HG2B  2    0.375343    0.729623    0.086049    11.00000   -1.50000
HG2C  2    0.363361    0.742706    0.076476    11.00000   -1.50000
AFIX   0
CD1   1    0.423663    0.737082    0.072175    11.00000    0.21442    0.10644 =
         0.14542    0.02040    0.07943    0.10438
AFIX  33
HD1A  2    0.431294    0.733199    0.064842    11.00000   -1.50000
HD1B  2    0.406457    0.720454    0.074534    11.00000   -1.50000
HD1C  2    0.437017    0.742595    0.078908    11.00000   -1.50000
AFIX   0
 
RESI   86   MET
N     3    0.404328    0.805403    0.055326    11.00000    0.08208    0.09244 =
         0.10475   -0.01808   -0.00032    0.02282
AFIX  43
H0    2    0.422242    0.811896    0.055510    11.00000   -1.20000
AFIX   0
CA    1    0.391427    0.804402    0.043346    11.00000    0.08573    0.09528 =
         0.11109   -0.03191   -0.00601    0.04121
AFIX  13
HA    2    0.371478    0.789782    0.043715    11.00000   -1.20000
AFIX   0
C     1    0.405692    0.796739    0.032983    11.00000    0.11411    0.10966 =
         0.10000   -0.00177    0.01252    0.06393
O     4    0.430815    0.803309    0.034243    11.00000    0.10630    0.13751 =
         0.12100   -0.02011    0.01484    0.06111
CB    1    0.393270    0.832064    0.040691    11.00000    0.16838    0.10739 =
         0.11596   -0.03034   -0.00342    0.07783
AFIX  23
HB1   2    0.378503    0.828338    0.034688    11.00000   -1.20000
HB2   2    0.388221    0.837872    0.048388    11.00000   -1.20000
AFIX   0
CG    1    0.419258    0.856960    0.035992    11.00000    0.20500    0.12902 =
         0.23713    0.01412    0.01175    0.06295
AFIX  23
HG1   2    0.426646    0.851454    0.028955    11.00000   -1.20000
HG2   2    0.433442    0.864138    0.042539    11.00000   -1.20000
AFIX   0
SD    5    0.411969    0.884307    0.031144    11.00000    0.44787    0.14607 =
         0.22757    0.04646    0.13411    0.17839
CE    1    0.386386    0.868630    0.019594    11.00000    0.35642    0.32084 =
         0.34765    0.14728    0.08166    0.24854
AFIX  33
HE1   2    0.381780    0.882185    0.016343    11.00000   -1.50000
HE2   2    0.369781    0.852982    0.023103    11.00000   -1.50000
HE3   2    0.393458    0.862057    0.012951    11.00000   -1.50000
AFIX   0
 
RESI   87   LEU
N     3    0.390616    0.784299    0.023041    11.00000    0.10367    0.08275 =
         0.10835   -0.01708    0.02107    0.03263
AFIX  43
H0    2    0.372962    0.779056    0.023308    11.00000   -1.20000
AFIX   0
CA    1    0.401180    0.778595    0.011589    11.00000    0.09031    0.07986 =
         0.11555   -0.00971    0.02990    0.02730
AFIX  13
HA    2    0.420536    0.782580    0.012962    11.00000   -1.20000
AFIX   0
C     1    0.400990    0.796899    0.000985    11.00000    0.10017    0.09847 =
         0.10705   -0.00669    0.00532    0.01543
O     4    0.381104    0.801125   -0.000240    11.00000    0.12651    0.12087 =
         0.15220    0.03228    0.02761    0.04377
CB    1    0.382540    0.747465    0.008123    11.00000    0.13628    0.08523 =
         0.10107   -0.02596    0.00090    0.02169
AFIX  23
HB1   2    0.362939    0.742744    0.008314    11.00000   -1.20000
HB2   2    0.386896    0.744618   -0.000370    11.00000   -1.20000
AFIX   0
CG    1    0.386322    0.727580    0.016837    11.00000    0.11882    0.08175 =
         0.15348   -0.01685    0.00109    0.02445
AFIX  13
HG    2    0.387184    0.734156    0.025448    11.00000   -1.20000
AFIX   0
CD1   1    0.361966    0.697355    0.015997    11.00000    0.09230    0.09432 =
         0.15697    0.00772    0.01723    0.01800
AFIX  33
HD1A  2    0.365129    0.685711    0.021732    11.00000   -1.50000
HD1B  2    0.360744    0.690456    0.007622    11.00000   -1.50000
HD1C  2    0.344663    0.696836    0.018107    11.00000   -1.50000
AFIX   0
CD2   1    0.414370    0.728953    0.013925    11.00000    0.08382    0.15846 =
         0.27674   -0.00982   -0.01524    0.01891
AFIX  33
HD2A  2    0.417021    0.716817    0.019567    11.00000   -1.50000
HD2B  2    0.429551    0.747990    0.014920    11.00000   -1.50000
HD2C  2    0.414127    0.722914    0.005463    11.00000   -1.50000
AFIX   0
 
RESI   88   ILE
N     3    0.423044    0.807084   -0.006401    11.00000    0.11999    0.07986 =
         0.10676   -0.00590    0.01528    0.02616
AFIX  43
H0    2    0.436251    0.803472   -0.004649    11.00000   -1.20000
AFIX   0
CA    1    0.426419    0.824250   -0.017454    11.00000    0.08769    0.08112 =
         0.11050   -0.00697    0.01371    0.01983
AFIX  13
HA    2    0.409023    0.824886   -0.018759    11.00000   -1.20000
AFIX   0
C     1    0.431269    0.810118   -0.028711    11.00000    0.11733    0.09162 =
         0.10402   -0.00883    0.01336    0.02975
O     4    0.450637    0.804992   -0.028760    11.00000    0.13749    0.11838 =
         0.11456   -0.00621    0.02231    0.05883
CB    1    0.451124    0.854475   -0.015925    11.00000    0.10049    0.07346 =
         0.13824   -0.00409    0.02482    0.02344
AFIX  13
HB    2    0.468327    0.853272   -0.015117    11.00000   -1.20000
AFIX   0
CG1   1    0.448824    0.868786   -0.004299    11.00000    0.11409    0.08885 =
         0.14741   -0.02300    0.00275    0.04343
AFIX  23
HG1A  2    0.443090    0.855633    0.002647    11.00000   -1.20000
HG1B  2    0.434237    0.873680   -0.005550    11.00000   -1.20000
AFIX   0
CG2   1    0.454124    0.871220   -0.027814    11.00000    0.18665    0.12131 =
         0.14951    0.03475    0.03077    0.00746
AFIX  33
HG2A  2    0.455759    0.861391   -0.034921    11.00000   -1.50000
HG2B  2    0.470690    0.889524   -0.027216    11.00000   -1.50000
HG2C  2    0.437808    0.873280   -0.028784    11.00000   -1.50000
AFIX   0
CD1   1    0.476273    0.895357   -0.000886    11.00000    0.13954    0.10464 =
         0.18978   -0.05218    0.03634    0.01976
AFIX  33
HD1A  2    0.473505    0.903565    0.006539    11.00000   -1.50000
HD1B  2    0.481913    0.908643   -0.007652    11.00000   -1.50000
HD1C  2    0.490699    0.890610    0.000604    11.00000   -1.50000
AFIX   0
 
RESI   89   LYS
N     3    0.413014    0.803860   -0.037851    11.00000    0.13147    0.10680 =
         0.10740   -0.00858    0.01332    0.04863
AFIX  43
H0    2    0.398775    0.806292   -0.036881    11.00000   -1.20000
AFIX   0
CA    1    0.416920    0.792729   -0.049710    11.00000    0.17890    0.10660 =
         0.09455   -0.01117    0.01683    0.03236
AFIX  13
HA    2    0.428099    0.783598   -0.048075    11.00000   -1.20000
AFIX   0
C     1    0.432817    0.816466   -0.059179    11.00000    0.16486    0.11244 =
         0.12917    0.00834    0.03623    0.04059
O     4    0.426762    0.835085   -0.060428    11.00000    0.21766    0.14329 =
         0.13203    0.00976    0.00535    0.08230
CB    1    0.389209    0.771252   -0.055494    11.00000    0.17790    0.09324 =
         0.12067   -0.00335    0.00092    0.03603
AFIX  23
HB1   2    0.379863    0.780929   -0.058840    11.00000   -1.20000
HB2   2    0.377201    0.758467   -0.049011    11.00000   -1.20000
AFIX   0
CG    1    0.392502    0.754290   -0.065828    11.00000    0.20138    0.12092 =
         0.13306   -0.03648   -0.00029    0.03295
AFIX  23
HG1   2    0.401946    0.744651   -0.062548    11.00000   -1.20000
HG2   2    0.404215    0.766940   -0.072413    11.00000   -1.20000
AFIX   0
CD    1    0.363835    0.732471   -0.071344    11.00000    0.16886    0.15197 =
         0.10996   -0.02801    0.01429    0.04692
AFIX  23
HD1   2    0.350547    0.722645   -0.064632    11.00000   -1.20000
HD2   2    0.356402    0.741917   -0.076454    11.00000   -1.20000
AFIX   0
CE    1    0.367535    0.711378   -0.079317    11.00000    0.22496    0.17004 =
         0.20722   -0.10137    0.00060    0.04035
AFIX  23
HE1   2    0.382820    0.721582   -0.085212    11.00000   -1.20000
HE2   2    0.372674    0.700375   -0.073940    11.00000   -1.20000
AFIX   0
NZ    3    0.341563    0.692102   -0.086289    11.00000    0.19956    0.19534 =
         0.19166   -0.08852    0.00620    0.05596
AFIX  33
HZ1   2    0.344550    0.680206   -0.090828    11.00000   -1.50000
HZ2   2    0.336934    0.702100   -0.091330    11.00000   -1.50000
HZ3   2    0.327579    0.682403   -0.080903    11.00000   -1.50000
AFIX   0
 
RESI   90   LEU
N     3    0.452372    0.814476   -0.065511    11.00000    0.17235    0.15560 =
         0.12280    0.00359    0.02933    0.05553
AFIX  43
H0    2    0.455362    0.800833   -0.063811    11.00000   -1.20000
AFIX   0
CA    1    0.469275    0.834553   -0.075345    11.00000    0.18860    0.11344 =
         0.11180   -0.03571    0.03873   -0.02008
AFIX  13
HA    2    0.473232    0.853434   -0.072880    11.00000   -1.20000
AFIX   0
C     1    0.453691    0.826935   -0.087849    11.00000    0.18565    0.13729 =
         0.10724   -0.01446    0.03720   -0.04192
O     4    0.439808    0.802180   -0.091049    11.00000    0.27991    0.12948 =
         0.12012   -0.00847   -0.00730   -0.03680
CB    1    0.497374    0.834885   -0.076761    11.00000    0.17799    0.18164 =
         0.14809   -0.04566    0.03672   -0.01343
AFIX  23
HB1   2    0.508213    0.848171   -0.083327    11.00000   -1.20000
HB2   2    0.493316    0.816344   -0.079525    11.00000   -1.20000
AFIX   0
CG    1    0.515994    0.842705   -0.064896    11.00000    0.21824    0.28301 =
         0.17373   -0.13308   -0.00110    0.05240
AFIX  13
HG    2    0.506075    0.827689   -0.058710    11.00000   -1.20000
AFIX   0
CD1   1    0.544127    0.844469   -0.067790    11.00000    0.17100    0.33273 =
         0.24931   -0.03003    0.03570    0.01474
AFIX  33
HD1A  2    0.540757    0.826916   -0.071315    11.00000   -1.50000
HD1B  2    0.554843    0.848172   -0.060209    11.00000   -1.50000
HD1C  2    0.554484    0.859429   -0.073667    11.00000   -1.50000
AFIX   0
CD2   1    0.519808    0.869875   -0.059379    11.00000    0.35382    0.18220 =
         0.14909   -0.04431   -0.02776    0.03876
AFIX  33
HD2A  2    0.501656    0.867948   -0.057807    11.00000   -1.50000
HD2B  2    0.530073    0.885058   -0.065168    11.00000   -1.50000
HD2C  2    0.530112    0.873848   -0.051663    11.00000   -1.50000
AFIX   0
 
RESI   91   LYS
N     3    0.457091    0.848660   -0.094667    11.00000    0.19641    0.11909 =
         0.11135   -0.02528    0.03094   -0.04652
AFIX  43
H0    2    0.468235    0.865466   -0.091977    11.00000   -1.20000
AFIX   0
CA    1    0.442706    0.845092   -0.106484    11.00000    0.20066    0.15638 =
         0.12083   -0.02984    0.03112    0.00672
AFIX  13
HA    2    0.422407    0.832919   -0.105084    11.00000   -1.20000
AFIX   0
C     1    0.452209    0.830767   -0.116067    11.00000    0.22536    0.14435 =
         0.09225   -0.01456   -0.01141    0.04884
O     4    0.436114    0.815365   -0.124126    11.00000    0.24359    0.20375 =
         0.12450   -0.05593   -0.03090    0.06095
CB    1    0.447680    0.872774   -0.111827    11.00000    0.30298    0.21165 =
         0.24725   -0.04396   -0.01307    0.12596
AFIX  23
HB1   2    0.443368    0.882455   -0.105343    11.00000   -1.20000
HB2   2    0.467631    0.884252   -0.113694    11.00000   -1.20000
AFIX   0
CG    1    0.431520    0.871715   -0.123362    11.00000    0.54058    0.46118 =
         0.25247    0.06903   -0.04606    0.21886
AFIX  23
HG1   2    0.418488    0.878222   -0.121244    11.00000   -1.20000
HG2   2    0.420462    0.852263   -0.126098    11.00000   -1.20000
AFIX   0
CD    1    0.450084    0.889430   -0.134174    11.00000    0.81500    0.60884 =
         0.32866    0.15908    0.03200    0.18386
AFIX  23
HD1   2    0.469056    0.892775   -0.132877    11.00000   -1.20000
HD2   2    0.450996    0.907590   -0.134101    11.00000   -1.20000
AFIX   0
CE    1    0.439674    0.875798   -0.147054    11.00000    0.93026    0.61416 =
         0.26503    0.22100    0.02323    0.29913
AFIX  23
HE1   2    0.429395    0.855446   -0.146108    11.00000   -1.20000
HE2   2    0.426726    0.881418   -0.150377    11.00000   -1.20000
AFIX   0
NZ    3    0.463220    0.883873   -0.156168    11.00000    1.07600    0.75247 =
         0.35431    0.26536    0.12019    0.48090
AFIX  33
HZ1   2    0.456208    0.875484   -0.163483    11.00000   -1.50000
HZ2   2    0.474984    0.878442   -0.153241    11.00000   -1.50000
HZ3   2    0.472489    0.902502   -0.157208    11.00000   -1.50000
AFIX   0
 
RESI   92   SER
N     3    0.478671    0.837398   -0.115070    11.00000    0.22007    0.13433 =
         0.11516   -0.04173   -0.01524    0.03759
AFIX  43
H0    2    0.488842    0.849864   -0.109578    11.00000   -1.20000
AFIX   0
CA    1    0.492003    0.825372   -0.122485    11.00000    0.25704    0.16256 =
         0.13977   -0.01072    0.01249    0.07598
AFIX  13
HA    2    0.477188    0.808093   -0.126406    11.00000   -1.20000
AFIX   0
C     1    0.509153    0.817457   -0.113960    11.00000    0.26016    0.15385 =
         0.08471   -0.01520    0.02095    0.07263
O     4    0.520984    0.831326   -0.104403    11.00000    0.29405    0.16354 =
         0.09673   -0.02779    0.02068    0.08860
CB    1    0.510409    0.845519   -0.132915    11.00000    0.36036    0.24594 =
         0.16288    0.05899    0.07066    0.17573
AFIX  23
HB1   2    0.518924    0.836562   -0.137642    11.00000   -1.20000
HB2   2    0.498449    0.848712   -0.138591    11.00000   -1.20000
AFIX   0
OG    4    0.532089    0.871953   -0.128428    11.00000    0.44943    0.14916 =
         0.43675    0.04810    0.24377    0.11536
AFIX  83
HG    2    0.542389    0.869452   -0.123666    11.00000   -1.50000
AFIX   0
 
RESI   93   ALA
N     3    0.511471    0.794896   -0.117004    11.00000    0.24116    0.16943 =
         0.14526   -0.05346   -0.01448    0.07487
AFIX  43
H0    2    0.503217    0.784983   -0.123534    11.00000   -1.20000
AFIX   0
CA    1    0.528502    0.787667   -0.108856    11.00000    0.19927    0.14045 =
         0.17988   -0.02218    0.00870    0.04399
AFIX  13
HA    2    0.522003    0.786554   -0.100213    11.00000   -1.20000
AFIX   0
C     1    0.559286    0.810765   -0.109567    11.00000    0.20112    0.14573 =
         0.16809   -0.04605    0.03273    0.04870
O     4    0.570920    0.823484   -0.119175    11.00000    0.23032    0.19462 =
         0.16786   -0.03591    0.04713    0.05043
CB    1    0.525258    0.759401   -0.112354    11.00000    0.20697    0.15000 =
         0.27982   -0.06831   -0.03750    0.04887
AFIX  33
HB1   2    0.505700    0.745139   -0.111949    11.00000   -1.50000
HB2   2    0.535877    0.754810   -0.106623    11.00000   -1.50000
HB3   2    0.532140    0.760322   -0.120710    11.00000   -1.50000
AFIX   0
 
RESI   94   ALA
N     3    0.571827    0.815732   -0.098393    11.00000    0.17687    0.14624 =
         0.17343   -0.05002    0.02603    0.06095
AFIX  43
H0    2    0.562074    0.808624   -0.091699    11.00000   -1.20000
AFIX   0
CA    1    0.602445    0.833487   -0.097789    11.00000    0.17418    0.16214 =
         0.16333   -0.06827    0.05993    0.04021
AFIX  13
HA    2    0.608011    0.851648   -0.101787    11.00000   -1.20000
AFIX   0
C     1    0.616825    0.819741   -0.104389    11.00000    0.20358    0.15785 =
         0.17444    0.00136    0.06579    0.08540
O     4    0.605876    0.793967   -0.104414    11.00000    0.22283    0.15518 =
         0.20663   -0.03383    0.06793    0.06790
CB    1    0.612709    0.838574   -0.084372    11.00000    0.16158    0.18904 =
         0.18174   -0.03937    0.03623    0.05232
AFIX  33
HB1   2    0.603902    0.847296   -0.079869    11.00000   -1.50000
HB2   2    0.632809    0.850749   -0.084236    11.00000   -1.50000
HB3   2    0.607926    0.820906   -0.080500    11.00000   -1.50000
AFIX   0
 
RESI   95   SER
N     3    0.641427    0.837555   -0.109463    11.00000    0.21145    0.14840 =
         0.20285   -0.03336    0.08426    0.08083
AFIX  43
H0    2    0.646912    0.855275   -0.109421    11.00000   -1.20000
AFIX   0
CA    1    0.659696    0.828180   -0.115159    11.00000    0.22470    0.15800 =
         0.24151   -0.01014    0.10161    0.09252
AFIX  13
HA    2    0.647800    0.808987   -0.118360    11.00000   -1.20000
AFIX   0
C     1    0.677970    0.827223   -0.104642    11.00000    0.19260    0.13823 =
         0.25703   -0.02311    0.09386    0.06935
O     4    0.695377    0.849354   -0.099670    11.00000    0.27807    0.13232 =
         0.24447   -0.02982    0.07663    0.07926
CB    1    0.676444    0.847239   -0.126075    11.00000    0.21780    0.20127 =
         0.23587   -0.01347    0.11446    0.06552
AFIX  23
HB1   2    0.663589    0.845975   -0.132628    11.00000   -1.20000
HB2   2    0.686900    0.866672   -0.123255    11.00000   -1.20000
AFIX   0
OG    4    0.695587    0.838966   -0.130933    11.00000    0.36692    0.26562 =
         0.28383   -0.01443    0.17840    0.16198
AFIX  83
HG    2    0.686686    0.822634   -0.133437    11.00000   -1.50000
AFIX   0
 
RESI   96   LEU
N     3    0.672618    0.801526   -0.101226    11.00000    0.18839    0.13330 =
         0.24096   -0.01632    0.08840    0.05385
AFIX  43
H0    2    0.660565    0.787056   -0.105410    11.00000   -1.20000
AFIX   0
CA    1    0.686942    0.797550   -0.090459    11.00000    0.21475    0.12779 =
         0.22449   -0.03866    0.07569    0.06190
AFIX  13
HA    2    0.688852    0.810977   -0.083930    11.00000   -1.20000
AFIX   0
C     1    0.716182    0.803993   -0.094221    11.00000    0.23258    0.10447 =
         0.21947   -0.00718    0.07733    0.08305
O     4    0.721267    0.795739   -0.103903    11.00000    0.26009    0.14980 =
         0.28522   -0.04698    0.09852    0.10679
CB    1    0.671300    0.767937   -0.084864    11.00000    0.23622    0.17192 =
         0.31824    0.03210    0.13901    0.12131
AFIX  23
HB1   2    0.670514    0.754639   -0.091080    11.00000   -1.20000
HB2   2    0.682016    0.767189   -0.077787    11.00000   -1.20000
AFIX   0
CG    1    0.641398    0.758611   -0.080522    11.00000    0.23897    0.19424 =
         0.36065    0.01920    0.16106    0.11163
AFIX  13
HG    2    0.631626    0.762484   -0.087248    11.00000   -1.20000
AFIX   0
CD1   1    0.625350    0.727088   -0.077830    11.00000    0.22777    0.22075 =
         0.69498    0.11278    0.19245    0.12372
AFIX  33
HD1A  2    0.606784    0.721699   -0.074845    11.00000   -1.50000
HD1B  2    0.635230    0.722777   -0.071577    11.00000   -1.50000
HD1C  2    0.623913    0.716902   -0.085371    11.00000   -1.50000
AFIX   0
CD2   1    0.642163    0.775445   -0.068940    11.00000    0.22108    0.34690 =
         0.23527    0.02139    0.13742    0.12203
AFIX  33
HD2A  2    0.623241    0.769293   -0.066221    11.00000   -1.50000
HD2B  2    0.651416    0.795155   -0.070982    11.00000   -1.50000
HD2C  2    0.652311    0.772446   -0.062352    11.00000   -1.50000
AFIX   0
 
RESI   97   ASN
N     3    0.735996    0.820302   -0.086293    11.00000    0.22805    0.15775 =
         0.23661   -0.01121    0.04632    0.11557
AFIX  43
H0    2    0.731547    0.825805   -0.079565    11.00000   -1.20000
AFIX   0
CA    1    0.765369    0.829155   -0.088764    11.00000    0.24403    0.19118 =
         0.26323   -0.03199    0.05573    0.14976
AFIX  13
HA    2    0.766153    0.813023   -0.092279    11.00000   -1.20000
AFIX   0
C     1    0.780468    0.836339   -0.076092    11.00000    0.19983    0.17475 =
         0.27129   -0.05289    0.05478    0.09693
O     4    0.766001    0.832233   -0.066647    11.00000    0.23520    0.18614 =
         0.27169   -0.06848    0.07301    0.08406
CB    1    0.779428    0.853416   -0.097975    11.00000    0.21050    0.16541 =
         0.28250   -0.04370    0.04807    0.07880
AFIX  23
HB1   2    0.769866    0.847549   -0.105986    11.00000   -1.20000
HB2   2    0.798856    0.858108   -0.099202    11.00000   -1.20000
AFIX   0
CG    1    0.778854    0.879489   -0.093472    11.00000    0.16387    0.15657 =
         0.27526   -0.00811    0.09767    0.06458
OD1   4    0.787547    0.888685   -0.082831    11.00000    0.27806    0.14142 =
         0.25746    0.00418    0.10065    0.09271
ND2   3    0.768491    0.890811   -0.101291    11.00000    0.27064    0.29492 =
         0.29171   -0.03356    0.07360    0.19313
AFIX  93
HD2A  2    0.767524    0.905405   -0.099066    11.00000   -1.20000
HD2B  2    0.762731    0.883569   -0.108593    11.00000   -1.20000
AFIX   0
 
RESI   98   SER
N     3    0.808219    0.847363   -0.075770    11.00000    0.19574    0.19070 =
         0.36109    0.02383    0.06225    0.08711
AFIX  43
H0    2    0.817747    0.852143   -0.082623    11.00000   -1.20000
AFIX   0
CA    1    0.822727    0.851431   -0.063733    11.00000    0.17964    0.18638 =
         0.39127   -0.02276    0.03993    0.10569
AFIX  13
HA    2    0.813679    0.833120   -0.059472    11.00000   -1.20000
AFIX   0
C     1    0.820826    0.872439   -0.054903    11.00000    0.22929    0.18739 =
         0.42128   -0.03391    0.06492    0.10314
O     4    0.822988    0.871158   -0.043365    11.00000    0.21200    0.24258 =
         0.42159   -0.07123    0.01926    0.12513
CB    1    0.853653    0.859649   -0.066044    11.00000    0.18270    0.26024 =
         0.52027    0.00332    0.06100    0.12943
AFIX  23
HB1   2    0.861737    0.857764   -0.058271    11.00000   -1.20000
HB2   2    0.854213    0.846657   -0.072058    11.00000   -1.20000
AFIX   0
OG    4    0.870316    0.887579   -0.070579    11.00000    0.30362    0.32281 =
         0.68827    0.09478    0.25910    0.12980
AFIX  83
HG    2    0.886626    0.891098   -0.071527    11.00000   -1.50000
AFIX   0
 
RESI   99   ARG
N     3    0.817006    0.891818   -0.060370    11.00000    0.19314    0.18417 =
         0.41347   -0.03678    0.08868    0.09809
AFIX  43
H0    2    0.815866    0.891462   -0.068407    11.00000   -1.20000
AFIX   0
CA    1    0.814559    0.913893   -0.053785    11.00000    0.17913    0.18584 =
         0.33433   -0.04114    0.05157    0.09077
AFIX  13
HA    2    0.824279    0.917208   -0.045724    11.00000   -1.20000
AFIX   0
C     1    0.784655    0.907925   -0.051266    11.00000    0.18853    0.16117 =
         0.23289   -0.01935    0.05182    0.09572
O     4    0.779299    0.922993   -0.044724    11.00000    0.21705    0.13698 =
         0.28028   -0.01128    0.07162    0.09878
CB    1    0.830544    0.940969   -0.061727    11.00000    0.20659    0.18160 =
         0.32946   -0.04636    0.09961    0.09471
AFIX  23
HB1   2    0.822275    0.937669   -0.070024    11.00000   -1.20000
HB2   2    0.828815    0.956081   -0.057872    11.00000   -1.20000
AFIX   0
CG    1    0.861552    0.949612   -0.062769    11.00000    0.21384    0.21992 =
         0.39228    0.02017    0.09739    0.11978
AFIX  23
HG1   2    0.868090    0.947295   -0.054651    11.00000   -1.20000
HG2   2    0.863371    0.936997   -0.068583    11.00000   -1.20000
AFIX   0
CD    1    0.880262    0.979481   -0.067089    11.00000    0.23950    0.33487 =
         0.48363    0.17233    0.09733    0.07202
AFIX  23
HD1   2    0.873563    0.981540   -0.075212    11.00000   -1.20000
HD2   2    0.877931    0.991866   -0.061327    11.00000   -1.20000
AFIX   0
NE    3    0.910315    0.989350   -0.068158    11.00000    0.26822    0.53644 =
         0.71563    0.18449    0.25779    0.10531
AFIX  43
HE    2    0.921380    1.000591   -0.062485    11.00000   -1.20000
AFIX   0
CZ    1    0.921536    0.982058   -0.077308    11.00000    0.37558    0.68676 =
         0.88832    0.03767    0.30662    0.12670
NH1   3    0.904922    0.964733   -0.086162    11.00000    0.66787    0.98477 =
         0.97591   -0.16137    0.25537    0.14153
AFIX  93
HH1A  2    0.912036    0.959887   -0.092191    11.00000   -1.20000
HH1B  2    0.887032    0.958340   -0.085878    11.00000   -1.20000
AFIX   0
NH2   3    0.949326    0.992674   -0.077201    11.00000    0.41384    1.02357 =
         1.22118   -0.01421    0.38182    0.27836
AFIX  93
HH2A  2    0.959343    1.003897   -0.071290    11.00000   -1.20000
HH2B  2    0.957285    0.988319   -0.083043    11.00000   -1.20000
AFIX   0
 
RESI  100   VAL
N     3    0.764432    0.885382   -0.056819    11.00000    0.17204    0.14174 =
         0.23933   -0.00138    0.09008    0.06544
AFIX  43
H0    2    0.769315    0.875670   -0.061440    11.00000   -1.20000
AFIX   0
CA    1    0.734452    0.875661   -0.055728    11.00000    0.17380    0.16991 =
         0.22307    0.01405    0.10058    0.07344
AFIX  13
HA    2    0.731610    0.884366   -0.048266    11.00000   -1.20000
AFIX   0
C     1    0.718670    0.843610   -0.053800    11.00000    0.16746    0.16259 =
         0.18569   -0.00620    0.05614    0.05256
O     4    0.712236    0.826614   -0.062391    11.00000    0.22179    0.18272 =
         0.20298   -0.01430    0.07679    0.09576
CB    1    0.723277    0.884089   -0.067037    11.00000    0.16810    0.13632 =
         0.24476    0.00706    0.07421    0.04370
AFIX  13
HB    2    0.725753    0.875251   -0.074543    11.00000   -1.20000
AFIX   0
CG1   1    0.691839    0.873288   -0.065169    11.00000    0.17280    0.11793 =
         0.26700   -0.01373    0.06815    0.05627
AFIX  33
HG1A  2    0.684684    0.878733   -0.072194    11.00000   -1.50000
HG1B  2    0.689130    0.881247   -0.057647    11.00000   -1.50000
HG1C  2    0.681944    0.853094   -0.064493    11.00000   -1.50000
AFIX   0
CG2   1    0.739670    0.916177   -0.068736    11.00000    0.24094    0.13902 =
         0.23063    0.02714    0.11668    0.03244
AFIX  33
HG2A  2    0.732218    0.921228   -0.075781    11.00000   -1.50000
HG2B  2    0.759227    0.922352   -0.070167    11.00000   -1.50000
HG2C  2    0.737840    0.925058   -0.061323    11.00000   -1.50000
AFIX   0
 
RESI  101   ALA
N     3    0.713495    0.835134   -0.041933    11.00000    0.16930    0.15893 =
         0.19803    0.00589    0.08716    0.04378
AFIX  43
H0    2    0.716423    0.847312   -0.036187    11.00000   -1.20000
AFIX   0
CA    1    0.703062    0.805973   -0.038385    11.00000    0.21204    0.18338 =
         0.23548    0.02478    0.11400    0.09663
AFIX  13
HA    2    0.694923    0.793932   -0.045766    11.00000   -1.20000
AFIX   0
C     1    0.680596    0.796991   -0.028397    11.00000    0.18317    0.11447 =
         0.21524    0.01376    0.09501    0.08012
O     4    0.680692    0.814153   -0.020964    11.00000    0.19641    0.12183 =
         0.21746   -0.01584    0.07294    0.06143
CB    1    0.726292    0.801225   -0.032965    11.00000    0.16336    0.21554 =
         0.34328    0.07840    0.14050    0.07644
AFIX  33
HB1   2    0.741307    0.807175   -0.038945    11.00000   -1.50000
HB2   2    0.718654    0.781551   -0.031154    11.00000   -1.50000
HB3   2    0.733464    0.811975   -0.025402    11.00000   -1.50000
AFIX   0
 
RESI  102   SER
N     3    0.660828    0.770177   -0.028307    11.00000    0.18680    0.14745 =
         0.21514   -0.06015    0.08328    0.04482
AFIX  43
H0    2    0.661086    0.759110   -0.033956    11.00000   -1.20000
AFIX   0
CA    1    0.638603    0.758777   -0.018931    11.00000    0.13846    0.11605 =
         0.22916    0.00693    0.06062    0.05164
AFIX  13
HA    2    0.633928    0.773427   -0.016906    11.00000   -1.20000
AFIX   0
C     1    0.648321    0.751255   -0.006938    11.00000    0.18643    0.09683 =
         0.23110   -0.03559    0.04101    0.08762
O     4    0.667078    0.745144   -0.006736    11.00000    0.23449    0.24107 =
         0.21333   -0.00379    0.06386    0.17020
CB    1    0.612109    0.733612   -0.024772    11.00000    0.14787    0.21077 =
         0.29565   -0.06771    0.03287    0.05325
AFIX  23
HB1   2    0.596781    0.726438   -0.018759    11.00000   -1.20000
HB2   2    0.606384    0.740062   -0.032071    11.00000   -1.20000
AFIX   0
OG    4    0.617079    0.711753   -0.028305    11.00000    0.28113    0.22151 =
         0.42929   -0.14653    0.02863    0.07999
AFIX  83
HG    2    0.629140    0.717404   -0.033806    11.00000   -1.50000
AFIX   0
 
RESI  103   ILE
N     3    0.634804    0.751781    0.003223    11.00000    0.17496    0.13018 =
         0.21722   -0.01879    0.03437    0.09998
AFIX  43
H0    2    0.623186    0.757977    0.002595    11.00000   -1.20000
AFIX   0
CA    1    0.638682    0.742333    0.015460    11.00000    0.14419    0.13437 =
         0.23090   -0.01674    0.01682    0.07991
AFIX  13
HA    2    0.655018    0.739583    0.014896    11.00000   -1.20000
AFIX   0
C     1    0.613285    0.714287    0.018995    11.00000    0.14977    0.14455 =
         0.22688   -0.00489    0.06344    0.10238
O     4    0.589516    0.711029    0.017290    11.00000    0.14589    0.09540 =
         0.25420   -0.01519    0.02826    0.07359
CB    1    0.645151    0.764947    0.025575    11.00000    0.16962    0.16061 =
         0.20817   -0.01151    0.03541    0.09026
AFIX  13
HB    2    0.662317    0.782056    0.022918    11.00000   -1.20000
AFIX   0
CG1   1    0.651384    0.756881    0.038321    11.00000    0.18897    0.18902 =
         0.20190    0.01911    0.05787    0.09040
AFIX  23
HG1A  2    0.635724    0.738711    0.040791    11.00000   -1.20000
HG1B  2    0.653148    0.770702    0.044478    11.00000   -1.20000
AFIX   0
CG2   1    0.622166    0.772597    0.026638    11.00000    0.14504    0.18589 =
         0.20009   -0.04240    0.04206    0.08229
AFIX  33
HG2A  2    0.618713    0.777928    0.018552    11.00000   -1.50000
HG2B  2    0.628047    0.788084    0.032352    11.00000   -1.50000
HG2C  2    0.605182    0.756624    0.029683    11.00000   -1.50000
AFIX   0
CD1   1    0.678466    0.755298    0.038189    11.00000    0.18913    0.18034 =
         0.31967    0.05540    0.02438    0.08786
AFIX  33
HD1A  2    0.681466    0.749769    0.046317    11.00000   -1.50000
HD1B  2    0.694134    0.773456    0.036081    11.00000   -1.50000
HD1C  2    0.676818    0.741675    0.032087    11.00000   -1.50000
AFIX   0
 
RESI  104   SER
N     3    0.617978    0.694563    0.023905    11.00000    0.14186    0.13079 =
         0.28253   -0.01120    0.05354    0.09536
AFIX  43
H0    2    0.635041    0.698205    0.025004    11.00000   -1.20000
AFIX   0
CA    1    0.594542    0.666828    0.027450    11.00000    0.14901    0.13344 =
         0.21337   -0.01824    0.02060    0.08382
AFIX  13
HA    2    0.582146    0.658464    0.020189    11.00000   -1.20000
AFIX   0
C     1    0.577376    0.668163    0.038213    11.00000    0.16424    0.09747 =
         0.27397   -0.03902    0.05865    0.06431
O     4    0.589247    0.683384    0.047234    11.00000    0.14457    0.13360 =
         0.23670   -0.01777    0.03853    0.07717
CB    1    0.606646    0.647736    0.031250    11.00000    0.18578    0.14845 =
         0.35612    0.00713    0.05159    0.11767
AFIX  23
HB1   2    0.621130    0.657089    0.037575    11.00000   -1.20000
HB2   2    0.591796    0.630203    0.034746    11.00000   -1.20000
AFIX   0
OG    4    0.618186    0.642093    0.020619    11.00000    0.30847    0.33393 =
         0.48839   -0.00037    0.13564    0.24543
AFIX  83
HG    2    0.630841    0.656960    0.017746    11.00000   -1.50000
AFIX   0
 
RESI  105   LEU
N     3    0.549747    0.650992    0.037497    11.00000    0.16706    0.16176 =
         0.16302   -0.02392    0.03033    0.08625
AFIX  43
H0    2    0.542124    0.642622    0.030573    11.00000   -1.20000
AFIX   0
CA    1    0.532345    0.646419    0.048605    11.00000    0.17749    0.18265 =
         0.17513   -0.00065    0.05191    0.08097
AFIX  13
HA    2    0.538128    0.664702    0.052528    11.00000   -1.20000
AFIX   0
C     1    0.535991    0.627553    0.058089    11.00000    0.15765    0.16769 =
         0.21583    0.02291    0.08270    0.07753
O     4    0.544398    0.611487    0.054622    11.00000    0.24048    0.19635 =
         0.29012    0.02664    0.11253    0.12164
CB    1    0.501426    0.632971    0.044753    11.00000    0.16723    0.12775 =
         0.21079    0.00610    0.05488    0.05347
AFIX  23
HB1   2    0.496272    0.615378    0.040506    11.00000   -1.20000
HB2   2    0.490180    0.628264    0.052327    11.00000   -1.20000
AFIX   0
CG    1    0.493048    0.649897    0.036426    11.00000    0.17715    0.16326 =
         0.24482    0.00594    0.05728    0.09019
AFIX  13
HG    2    0.504858    0.655436    0.028896    11.00000   -1.20000
AFIX   0
CD1   1    0.462235    0.632389    0.032450    11.00000    0.17702    0.19976 =
         0.31665    0.03126    0.04323    0.08424
AFIX  33
HD1A  2    0.457576    0.643341    0.026955    11.00000   -1.50000
HD1B  2    0.450364    0.627070    0.039727    11.00000   -1.50000
HD1C  2    0.459373    0.615738    0.028167    11.00000   -1.50000
AFIX   0
CD2   1    0.497901    0.676589    0.043140    11.00000    0.32850    0.17527 =
         0.23057    0.00689    0.04409    0.13902
AFIX  33
HD2A  2    0.517321    0.687498    0.045617    11.00000   -1.50000
HD2B  2    0.486078    0.671496    0.050427    11.00000   -1.50000
HD2C  2    0.493357    0.687555    0.037599    11.00000   -1.50000
AFIX   0
 
RESI  106   PRO
N     3    0.530111    0.630087    0.069799    11.00000    0.13013    0.17180 =
         0.19394    0.01442    0.03134    0.07711
CA    1    0.531502    0.612594    0.079739    11.00000    0.16013    0.18847 =
         0.22839    0.02359    0.00934    0.08590
AFIX  13
HA    2    0.550310    0.614590    0.080055    11.00000   -1.20000
AFIX   0
C     1    0.508935    0.581635    0.077766    11.00000    0.19295    0.16953 =
         0.27016    0.00855    0.00277    0.10778
O     4    0.486848    0.575378    0.072464    11.00000    0.20271    0.13394 =
         0.35492    0.03433   -0.03936    0.07700
CB    1    0.525413    0.623365    0.091804    11.00000    0.26667    0.16821 =
         0.19243    0.03046    0.01780    0.07442
AFIX  23
HB1   2    0.508148    0.608730    0.095586    11.00000   -1.20000
HB2   2    0.540727    0.628721    0.097712    11.00000   -1.20000
AFIX   0
CG    1    0.522488    0.648127    0.088638    11.00000    0.18616    0.23375 =
         0.16638    0.03111    0.04466    0.11192
AFIX  23
HG1   2    0.538581    0.665240    0.091782    11.00000   -1.20000
HG2   2    0.505540    0.646257    0.092440    11.00000   -1.20000
AFIX   0
CD    1    0.520859    0.649550    0.074719    11.00000    0.19025    0.19473 =
         0.16416    0.02398    0.06107    0.10754
AFIX  23
HD1   2    0.501714    0.643560    0.072089    11.00000   -1.20000
HD2   2    0.533190    0.668623    0.071757    11.00000   -1.20000
AFIX   0
 
RESI  107   THR
N     3    0.516880    0.564230    0.082360    11.00000    0.23053    0.20319 =
         0.22950   -0.01274    0.00660    0.15134
AFIX  43
H0    2    0.534048    0.570508    0.084680    11.00000   -1.20000
AFIX   0
CA    1    0.496258    0.534389    0.083438    11.00000    0.33488    0.18678 =
         0.19074   -0.01877   -0.11672    0.14660
AFIX  13
HA    2    0.481066    0.529798    0.077408    11.00000   -1.20000
AFIX   0
C     1    0.483623    0.527398    0.096537    11.00000    0.22717    0.19326 =
         0.23295    0.00498   -0.08984    0.06921
O     4    0.459903    0.508125    0.098657    11.00000    0.25731    0.42779 =
         0.37818    0.01644   -0.10960   -0.04185
CB    1    0.509583    0.516207    0.080527    11.00000    0.52262    0.23368 =
         0.21479    0.03374   -0.05901    0.25891
AFIX  13
HB    2    0.525353    0.520648    0.086193    11.00000   -1.20000
AFIX   0
OG1   4    0.518695    0.521054    0.067771    11.00000    0.64405    0.32260 =
         0.23988   -0.01807   -0.00667    0.29328
AFIX  83
HG1   2    0.531936    0.537199    0.067006    11.00000   -1.50000
AFIX   0
CG2   1    0.486633    0.485964    0.081905    11.00000    0.98780    0.17322 =
         0.21845   -0.04304   -0.02118    0.22103
AFIX  33
HG2A  2    0.494235    0.473799    0.080335    11.00000   -1.50000
HG2B  2    0.471852    0.481925    0.076004    11.00000   -1.50000
HG2C  2    0.479159    0.482857    0.090254    11.00000   -1.50000
AFIX   0
 
RESI  108   SER
N     3    0.500301    0.544034    0.105343    11.00000    0.18634    0.14700 =
         0.20289   -0.01501   -0.02406    0.09299
AFIX  43
H0    2    0.516818    0.557092    0.103095    11.00000   -1.20000
AFIX   0
CA    1    0.493406    0.542413    0.118568    11.00000    0.18488    0.09412 =
         0.21565    0.01699    0.01534    0.08136
AFIX  13
HA    2    0.473293    0.536252    0.119287    11.00000   -1.20000
AFIX   0
C     1    0.510059    0.571278    0.124714    11.00000    0.17761    0.10872 =
         0.20302    0.01214    0.00596    0.07165
O     4    0.530174    0.590643    0.119084    11.00000    0.20858    0.09788 =
         0.22938    0.02772    0.01301    0.06267
CB    1    0.498586    0.520388    0.125144    11.00000    0.20502    0.14041 =
         0.23688    0.00059   -0.02541    0.11710
AFIX  23
HB1   2    0.492623    0.518275    0.133822    11.00000   -1.20000
HB2   2    0.488008    0.502229    0.121027    11.00000   -1.20000
AFIX   0
OG    4    0.527704    0.530129    0.124433    11.00000    0.20592    0.19890 =
         0.23119    0.00956    0.00995    0.13169
AFIX  83
HG    2    0.536405    0.545168    0.128180    11.00000   -1.50000
AFIX   0
 
RESI  109   CYS
N     3    0.502243    0.573993    0.136458    11.00000    0.19658    0.10380 =
         0.19872    0.00972   -0.00477    0.06393
AFIX  43
H0    2    0.489321    0.559299    0.140219    11.00000   -1.20000
AFIX   0
CA    1    0.515009    0.600851    0.142811    11.00000    0.20497    0.13894 =
         0.24249   -0.03836   -0.05499    0.10049
AFIX  13
HA    2    0.518082    0.615295    0.136598    11.00000   -1.20000
AFIX   0
C     1    0.543609    0.608839    0.148581    11.00000    0.19257    0.14031 =
         0.23107    0.03892   -0.03788    0.07190
O     4    0.550451    0.591612    0.151896    11.00000    0.21847    0.15198 =
         0.28914    0.01840   -0.04562    0.10124
CB    1    0.495460    0.601463    0.153059    11.00000    0.24979    0.16953 =
         0.25202   -0.02342   -0.03361    0.14158
AFIX  23
HB1   2    0.504763    0.619871    0.157027    11.00000   -1.20000
HB2   2    0.492543    0.587579    0.159405    11.00000   -1.20000
AFIX   0
SG    5    0.461078    0.594269    0.147165    11.00000    0.20718    0.14447 =
         0.21478    0.03309    0.01006    0.08242
 
RESI  110   ALA
N     3    0.561634    0.636220    0.149841    11.00000    0.14441    0.14270 =
         0.30009    0.02871   -0.00569    0.08035
AFIX  43
H0    2    0.556188    0.647778    0.147509    11.00000   -1.20000
AFIX   0
CA    1    0.589775    0.647933    0.154862    11.00000    0.13593    0.15663 =
         0.27845    0.02020    0.01343    0.08168
AFIX  13
HA    2    0.596301    0.634476    0.153317    11.00000   -1.20000
AFIX   0
C     1    0.588478    0.651279    0.169013    11.00000    0.15111    0.16027 =
         0.27291    0.03739    0.01475    0.07653
O     4    0.568599    0.652116    0.173605    11.00000    0.22352    0.21340 =
         0.27700    0.02142    0.02434    0.14744
CB    1    0.610941    0.676054    0.149060    11.00000    0.16320    0.15616 =
         0.23664    0.00829   -0.02651    0.05415
AFIX  33
HB1   2    0.611488    0.673887    0.140161    11.00000   -1.50000
HB2   2    0.629305    0.682238    0.152526    11.00000   -1.50000
HB3   2    0.605394    0.689791    0.150831    11.00000   -1.50000
AFIX   0
 
RESI  111   SER
N     3    0.610135    0.652603    0.174819    11.00000    0.14707    0.31741 =
         0.30713    0.02354   -0.01570    0.09008
AFIX  43
H0    2    0.623712    0.653995    0.170249    11.00000   -1.20000
AFIX   0
CA    1    0.613287    0.651940    0.188178    11.00000    0.19553    0.21783 =
         0.31443    0.05882   -0.02430    0.07776
AFIX  13
HA    2    0.594646    0.642471    0.192146    11.00000   -1.20000
AFIX   0
C     1    0.630769    0.681508    0.193515    11.00000    0.26076    0.19256 =
         0.26120    0.08377    0.00520    0.11589
O     4    0.650364    0.700405    0.187676    11.00000    0.22720    0.18552 =
         0.28355    0.05674    0.01705    0.11043
CB    1    0.628189    0.635103    0.190627    11.00000    0.30688    0.16099 =
         0.46842    0.11462    0.00371    0.10111
AFIX  23
HB1   2    0.647207    0.645150    0.187285    11.00000   -1.20000
HB2   2    0.629362    0.632732    0.199568    11.00000   -1.20000
AFIX   0
OG    4    0.612425    0.607800    0.184663    11.00000    0.41150    0.16892 =
         0.81489    0.04642   -0.21018    0.11066
AFIX  83
HG    2    0.620014    0.598445    0.186145    11.00000   -1.50000
AFIX   0
 
RESI  112   ALA
N     3    0.625055    0.686180    0.205101    11.00000    0.21252    0.25203 =
         0.27129    0.08194    0.00100    0.15376
AFIX  43
H0    2    0.609908    0.673843    0.208801    11.00000   -1.20000
AFIX   0
CA    1    0.644532    0.712205    0.211449    11.00000    0.21434    0.23104 =
         0.24705    0.08328    0.05460    0.15266
AFIX  13
HA    2    0.644808    0.727986    0.206987    11.00000   -1.20000
AFIX   0
C     1    0.674487    0.716590    0.211451    11.00000    0.21003    0.22391 =
         0.22599    0.05220    0.02407    0.14428
O     4    0.677888    0.696530    0.213500    11.00000    0.20455    0.22003 =
         0.27834    0.04015   -0.00366    0.13864
CB    1    0.634972    0.711909    0.224660    11.00000    0.26503    0.28171 =
         0.26048    0.09678    0.07879    0.18790
AFIX  33
HB1   2    0.616114    0.708873    0.224591    11.00000   -1.50000
HB2   2    0.647373    0.729665    0.228588    11.00000   -1.50000
HB3   2    0.635318    0.696998    0.229245    11.00000   -1.50000
AFIX   0
 
RESI  113   GLY
N     3    0.695172    0.742540    0.208955    11.00000    0.20932    0.22911 =
         0.28881    0.07373    0.02427    0.14414
AFIX  43
H0    2    0.690554    0.755154    0.207490    11.00000   -1.20000
AFIX   0
CA    1    0.724612    0.751239    0.208505    11.00000    0.21091    0.20425 =
         0.25264    0.06340    0.02085    0.14360
AFIX  23
HA1   2    0.728058    0.738995    0.213883    11.00000   -1.20000
HA2   2    0.735422    0.770282    0.211764    11.00000   -1.20000
AFIX   0
C     1    0.734902    0.750490    0.195375    11.00000    0.20511    0.17355 =
         0.24811    0.07903    0.03553    0.08142
O     4    0.760463    0.762581    0.193234    11.00000    0.19968    0.24647 =
         0.23070    0.05365    0.01064    0.13028
 
RESI  114   THR
N     3    0.715302    0.736540    0.186620    11.00000    0.18270    0.18822 =
         0.24887    0.06096    0.03618    0.12276
AFIX  43
H0    2    0.697711    0.727549    0.188587    11.00000   -1.20000
AFIX   0
CA    1    0.724021    0.736726    0.173751    11.00000    0.22307    0.20621 =
         0.25103    0.06233    0.03310    0.15931
AFIX  13
HA    2    0.737671    0.730106    0.173629    11.00000   -1.20000
AFIX   0
C     1    0.738219    0.766603    0.168545    11.00000    0.18610    0.21413 =
         0.22421    0.06858    0.00522    0.15344
O     4    0.727154    0.781386    0.170468    11.00000    0.20529    0.18595 =
         0.21189    0.05170    0.02406    0.14047
CB    1    0.698786    0.717065    0.165504    11.00000    0.24740    0.20653 =
         0.21990    0.08582    0.03336    0.13558
AFIX  13
HB    2    0.684433    0.722744    0.165962    11.00000   -1.20000
AFIX   0
OG1   4    0.687091    0.688534    0.170212    11.00000    0.42413    0.19616 =
         0.20811    0.07669    0.04608    0.12665
AFIX  83
HG1   2    0.682770    0.688049    0.177598    11.00000   -1.50000
AFIX   0
CG2   1    0.707650    0.717855    0.151874    11.00000    0.25597    0.25672 =
         0.23050    0.08964    0.06712    0.04784
AFIX  33
HG2A  2    0.691437    0.705487    0.146950    11.00000   -1.50000
HG2B  2    0.721347    0.711819    0.151388    11.00000   -1.50000
HG2C  2    0.715736    0.736755    0.148721    11.00000   -1.50000
AFIX   0
 
RESI  115   GLN
N     3    0.761661    0.775273    0.161874    11.00000    0.19301    0.17672 =
         0.25928    0.02511    0.01884    0.12526
AFIX  43
H0    2    0.768442    0.764224    0.160864    11.00000   -1.20000
AFIX   0
CA    1    0.775891    0.803132    0.156291    11.00000    0.17991    0.17884 =
         0.24952    0.02982    0.00929    0.12281
AFIX  13
HA    2    0.772977    0.815810    0.161774    11.00000   -1.20000
AFIX   0
C     1    0.763115    0.802718    0.143579    11.00000    0.17781    0.15589 =
         0.25105    0.00725   -0.00418    0.11257
O     4    0.755506    0.783305    0.135996    11.00000    0.23212    0.15397 =
         0.24489    0.01821    0.03961    0.09405
CB    1    0.807824    0.814562    0.155304    11.00000    0.17435    0.28088 =
         0.34131    0.11848    0.00412    0.12420
AFIX  23
HB1   2    0.810800    0.800650    0.151008    11.00000   -1.20000
HB2   2    0.816004    0.831422    0.150158    11.00000   -1.20000
AFIX   0
CG    1    0.823553    0.821664    0.167643    11.00000    0.15701    0.40732 =
         0.34968    0.09044    0.00136    0.08036
AFIX  23
HG1   2    0.840573    0.820636    0.166406    11.00000   -1.20000
HG2   2    0.811935    0.807067    0.173611    11.00000   -1.20000
AFIX   0
CD    1    0.831952    0.849869    0.173564    11.00000    0.22077    0.34469 =
         0.38921    0.09603   -0.01759   -0.00946
OE1   4    0.836415    0.870793    0.167464    11.00000    0.51685    0.51312 =
         0.53518    0.10114   -0.09997    0.32013
NE2   3    0.834584    0.851417    0.186074    11.00000    0.19974    0.49260 =
         0.40440    0.01675   -0.08502    0.14500
AFIX  93
HE2A  2    0.839402    0.867056    0.189854    11.00000   -1.20000
HE2B  2    0.831454    0.836769    0.190312    11.00000   -1.20000
AFIX   0
 
RESI  116   CYS
N     3    0.760766    0.825165    0.141026    11.00000    0.14226    0.14962 =
         0.22934    0.04024    0.02816    0.08887
AFIX  43
H0    2    0.766588    0.838195    0.146618    11.00000   -1.20000
AFIX   0
CA    1    0.749267    0.829553    0.129657    11.00000    0.15642    0.16696 =
         0.21155    0.04082    0.03974    0.10164
AFIX  13
HA    2    0.746810    0.815037    0.123603    11.00000   -1.20000
AFIX   0
C     1    0.768432    0.858535    0.123781    11.00000    0.13141    0.16767 =
         0.19752    0.03457    0.02263    0.08858
O     4    0.785723    0.878277    0.130472    11.00000    0.20830    0.18051 =
         0.18474    0.03176   -0.00764    0.08843
CB    1    0.720343    0.826401    0.132285    11.00000    0.14404    0.23253 =
         0.16163    0.04492    0.03249    0.10716
AFIX  23
HB1   2    0.711959    0.827001    0.124371    11.00000   -1.20000
HB2   2    0.723051    0.842478    0.137196    11.00000   -1.20000
AFIX   0
SG    5    0.696039    0.794905    0.140363    11.00000    0.15393    0.21830 =
         0.24690    0.04458    0.03527    0.08578
 
RESI  117   LEU
N     3    0.764171    0.860164    0.111719    11.00000    0.08057    0.12602 =
         0.20333    0.02452    0.00409    0.05068
AFIX  43
H0    2    0.752520    0.844929    0.107866    11.00000   -1.20000
AFIX   0
CA    1    0.778165    0.886455    0.104526    11.00000    0.10495    0.12871 =
         0.19426    0.02727    0.03258    0.06328
AFIX  13
HA    2    0.793272    0.900892    0.109703    11.00000   -1.20000
AFIX   0
C     1    0.756734    0.896000    0.101834    11.00000    0.09036    0.10247 =
         0.19865    0.02187    0.01867    0.04255
O     4    0.735292    0.880251    0.095763    11.00000    0.12263    0.11755 =
         0.17364   -0.00139    0.00581    0.06117
CB    1    0.791255    0.883583    0.092365    11.00000    0.13389    0.19369 =
         0.19263    0.02201    0.03211    0.09743
AFIX  23
HB1   2    0.804174    0.876939    0.094489    11.00000   -1.20000
HB2   2    0.776284    0.869012    0.087350    11.00000   -1.20000
AFIX   0
CG    1    0.807229    0.909947    0.084140    11.00000    0.11441    0.20961 =
         0.22329    0.03306    0.07093    0.08324
AFIX  13
HG    2    0.794975    0.918015    0.082839    11.00000   -1.20000
AFIX   0
CD1   1    0.834024    0.932126    0.090516    11.00000    0.16264    0.23742 =
         0.27078    0.02716    0.04092    0.05831
AFIX  33
HD1A  2    0.829425    0.936648    0.098542    11.00000   -1.50000
HD1B  2    0.842893    0.948809    0.085426    11.00000   -1.50000
HD1C  2    0.846687    0.924937    0.091608    11.00000   -1.50000
AFIX   0
CD2   1    0.813258    0.901665    0.071448    11.00000    0.21524    0.25728 =
         0.20425    0.04939    0.07152    0.14475
AFIX  33
HD2A  2    0.795952    0.887298    0.067811    11.00000   -1.50000
HD2B  2    0.826031    0.894579    0.072441    11.00000   -1.50000
HD2C  2    0.821606    0.917876    0.066061    11.00000   -1.50000
AFIX   0
 
RESI  118   ILE
N     3    0.763117    0.921432    0.106023    11.00000    0.10432    0.12950 =
         0.16483   -0.00849   -0.01243    0.06173
AFIX  43
H0    2    0.778539    0.931013    0.110155    11.00000   -1.20000
AFIX   0
CA    1    0.745196    0.933942    0.103950    11.00000    0.10219    0.09583 =
         0.12836    0.00422   -0.00006    0.04336
AFIX  13
HA    2    0.728094    0.920150    0.099549    11.00000   -1.20000
AFIX   0
C     1    0.761166    0.959522    0.095596    11.00000    0.11153    0.10903 =
         0.11263    0.00136   -0.00845    0.03164
O     4    0.786671    0.975474    0.097799    11.00000    0.10349    0.12466 =
         0.20302    0.04760   -0.00843    0.02864
CB    1    0.736535    0.940898    0.116570    11.00000    0.09555    0.13379 =
         0.11600    0.00254   -0.01000    0.05380
AFIX  13
HB    2    0.753582    0.956333    0.120366    11.00000   -1.20000
AFIX   0
CG1   1    0.724711    0.915885    0.125791    11.00000    0.12520    0.16786 =
         0.17129    0.04577    0.05234    0.05358
AFIX  23
HG1A  2    0.706549    0.901266    0.122716    11.00000   -1.20000
HG1B  2    0.737272    0.908176    0.125879    11.00000   -1.20000
AFIX   0
CG2   1    0.715860    0.951787    0.114355    11.00000    0.11282    0.20961 =
         0.18255   -0.00693    0.00475    0.09846
AFIX  33
HG2A  2    0.723905    0.967089    0.108470    11.00000   -1.50000
HG2B  2    0.712325    0.958265    0.122133    11.00000   -1.50000
HG2C  2    0.698448    0.936802    0.111081    11.00000   -1.50000
AFIX   0
CD1   1    0.721033    0.923149    0.139220    11.00000    0.25774    0.23783 =
         0.13828    0.05510    0.02329    0.10913
AFIX  33
HD1A  2    0.713556    0.906486    0.144312    11.00000   -1.50000
HD1B  2    0.708250    0.930360    0.139301    11.00000   -1.50000
HD1C  2    0.738983    0.937164    0.142485    11.00000   -1.50000
AFIX   0
 
RESI  119   SER
N     3    0.748268    0.964010    0.086119    11.00000    0.11755    0.12318 =
         0.12850    0.01351    0.00424    0.05726
AFIX  43
H0    2    0.730315    0.953775    0.085151    11.00000   -1.20000
AFIX   0
CA    1    0.765434    0.986962    0.077282    11.00000    0.10900    0.13485 =
         0.12741    0.01587   -0.00613    0.06048
AFIX  13
HA    2    0.782356    1.001169    0.081655    11.00000   -1.20000
AFIX   0
C     1    0.748463    1.000562    0.073102    11.00000    0.09329    0.11049 =
         0.13582    0.01627   -0.00756    0.03578
O     4    0.722289    0.988084    0.073580    11.00000    0.09415    0.11654 =
         0.17332    0.02235    0.01688    0.05687
CB    1    0.774536    0.976082    0.066179    11.00000    0.11690    0.14519 =
         0.16885    0.01589    0.03590    0.05113
AFIX  23
HB1   2    0.780165    0.989397    0.059301    11.00000   -1.20000
HB2   2    0.790555    0.974027    0.068489    11.00000   -1.20000
AFIX   0
OG    4    0.751817    0.949757    0.062440    11.00000    0.11642    0.13673 =
         0.20767   -0.00935    0.02525    0.07628
AFIX  83
HG    2    0.738505    0.951700    0.060291    11.00000   -1.50000
AFIX   0
 
RESI  120   GLY
N     3    0.763515    1.027051    0.068846    11.00000    0.12109    0.09178 =
         0.16873    0.00895   -0.00364    0.03579
AFIX  43
H0    2    0.781621    1.035624    0.069296    11.00000   -1.20000
AFIX   0
CA    1    0.749914    1.041632    0.063481    11.00000    0.10778    0.09274 =
         0.19088    0.01200    0.00637    0.03431
AFIX  23
HA1   2    0.734054    1.038296    0.068716    11.00000   -1.20000
HA2   2    0.742611    1.033815    0.055269    11.00000   -1.20000
AFIX   0
C     1    0.769669    1.073213    0.062244    11.00000    0.10503    0.09254 =
         0.18453    0.00515   -0.00258    0.04320
O     4    0.794517    1.084299    0.065652    11.00000    0.10523    0.09240 =
         0.16377    0.02227   -0.00820    0.03423
 
RESI  121   TRP
N     3    0.757632    1.086700    0.057213    11.00000    0.08747    0.10048 =
         0.15657    0.02230    0.00545    0.03390
AFIX  43
H0    2    0.740028    1.076996    0.055319    11.00000   -1.20000
AFIX   0
CA    1    0.772217    1.116828    0.054680    11.00000    0.12264    0.10455 =
         0.14295    0.02960    0.01586    0.04653
AFIX  13
HA    2    0.792530    1.124159    0.055586    11.00000   -1.20000
AFIX   0
C     1    0.763701    1.133029    0.063656    11.00000    0.14201    0.10327 =
         0.15113   -0.00598   -0.00692    0.03841
O     4    0.766263    1.155909    0.060788    11.00000    0.15655    0.11486 =
         0.18261    0.00324    0.00040    0.06020
CB    1    0.766431    1.121864    0.041131    11.00000    0.13301    0.11858 =
         0.14108    0.02788    0.02431    0.05210
AFIX  23
HB1   2    0.746158    1.112274    0.039927    11.00000   -1.20000
HB2   2    0.773481    1.141900    0.040082    11.00000   -1.20000
AFIX   0
CG    1    0.778741    1.112591    0.031064    11.00000    0.10434    0.10703 =
         0.15451    0.01708    0.01710    0.04463
CD1   1    0.805542    1.127861    0.026505    11.00000    0.10886    0.11984 =
         0.14834    0.02788    0.01785    0.03560
AFIX  43
HD1   2    0.818764    1.145740    0.029341    11.00000   -1.20000
AFIX   0
NE1   3    0.810541    1.113803    0.017345    11.00000    0.11709    0.15455 =
         0.14515    0.02881    0.03794    0.04270
AFIX  43
HE1   2    0.826212    1.119780    0.013401    11.00000   -1.20000
AFIX   0
CE2   1    0.786278    1.088293    0.015407    11.00000    0.12470    0.13553 =
         0.16262    0.01413    0.03819    0.05267
CZ2   1    0.780802    1.066741    0.006986    11.00000    0.11015    0.15721 =
         0.18991   -0.00102    0.01830    0.06910
AFIX  43
HZ2   2    0.794643    1.068324    0.001453    11.00000   -1.20000
AFIX   0
CH2   1    0.754720    1.043287    0.007033    11.00000    0.12845    0.14628 =
         0.15734    0.01166    0.01961    0.05920
AFIX  43
HH2   2    0.750573    1.028519    0.001544    11.00000   -1.20000
AFIX   0
CZ3   1    0.734154    1.041503    0.015390    11.00000    0.12384    0.11648 =
         0.17562    0.00773    0.02700    0.04597
AFIX  43
HZ3   2    0.716389    1.025416    0.015249    11.00000   -1.20000
AFIX   0
CE3   1    0.739199    1.062820    0.023905    11.00000    0.10567    0.08547 =
         0.18913    0.02177    0.01746    0.04953
AFIX  43
HE3   2    0.725212    1.061022    0.029401    11.00000   -1.20000
AFIX   0
CD2   1    0.765669    1.086760    0.023933    11.00000    0.10822    0.10059 =
         0.15114    0.03122    0.02861    0.04027
 
RESI  122   GLY
N     3    0.753303    1.121056    0.074703    11.00000    0.10500    0.11430 =
         0.15159   -0.01103   -0.00471    0.04940
AFIX  43
H0    2    0.751819    1.105057    0.076509    11.00000   -1.20000
AFIX   0
CA    1    0.744496    1.134934    0.083672    11.00000    0.11769    0.09929 =
         0.17307   -0.01442   -0.00155    0.05176
AFIX  23
HA1   2    0.731802    1.121177    0.089700    11.00000   -1.20000
HA2   2    0.734244    1.142614    0.079346    11.00000   -1.20000
AFIX   0
C     1    0.769327    1.158486    0.090539    11.00000    0.12115    0.08572 =
         0.17623   -0.00444    0.00454    0.04299
O     4    0.794060    1.165158    0.088683    11.00000    0.11451    0.12260 =
         0.15498   -0.00238   -0.01282    0.04803
 
RESI  123   ASN
N     3    0.761383    1.171113    0.098890    11.00000    0.11810    0.09799 =
         0.19197   -0.02488   -0.01852    0.05001
AFIX  43
H0    2    0.743672    1.165167    0.099800    11.00000   -1.20000
AFIX   0
CA    1    0.781552    1.194764    0.106620    11.00000    0.14836    0.12334 =
         0.12948   -0.01030   -0.01817    0.04533
AFIX  13
HA    2    0.792940    1.210938    0.101160    11.00000   -1.20000
AFIX   0
C     1    0.801207    1.187475    0.113775    11.00000    0.15318    0.14817 =
         0.11818   -0.00179   -0.00822    0.05920
O     4    0.792470    1.164165    0.118823    11.00000    0.13762    0.13238 =
         0.17333   -0.00592   -0.01083    0.05766
CB    1    0.764762    1.202513    0.115566    11.00000    0.18593    0.14686 =
         0.21470   -0.05778   -0.02783    0.08000
AFIX  23
HB1   2    0.751144    1.204763    0.110625    11.00000   -1.20000
HB2   2    0.754156    1.186552    0.121088    11.00000   -1.20000
AFIX   0
CG    1    0.780372    1.228345    0.123605    11.00000    0.17783    0.14146 =
         0.22309   -0.05850   -0.03205    0.06797
OD1   4    0.805628    1.245532    0.122350    11.00000    0.18646    0.14525 =
         0.25251   -0.00039   -0.03290    0.04713
ND2   3    0.764840    1.232474    0.132090    11.00000    0.23991    0.27297 =
         0.30967   -0.15558   -0.01432    0.09976
AFIX  93
HD2A  2    0.772487    1.247275    0.136746    11.00000   -1.20000
HD2B  2    0.747201    1.220329    0.132893    11.00000   -1.20000
AFIX   0
 
RESI  124   THR
N     3    0.828108    1.208179    0.114135    11.00000    0.16193    0.13411 =
         0.16457    0.00112   -0.03593    0.05279
AFIX  43
H0    2    0.832825    1.223848    0.110403    11.00000   -1.20000
AFIX   0
CA    1    0.849510    1.204949    0.120634    11.00000    0.15662    0.16648 =
         0.12872    0.01769   -0.01970    0.05468
AFIX  13
HA    2    0.841759    1.184821    0.122362    11.00000   -1.20000
AFIX   0
C     1    0.857391    1.220522    0.133130    11.00000    0.19053    0.17667 =
         0.14350   -0.00273   -0.03331    0.06244
O     4    0.875448    1.218951    0.139553    11.00000    0.18188    0.17022 =
         0.17710    0.00167   -0.05293    0.04488
CB    1    0.876528    1.215119    0.112957    11.00000    0.15517    0.13432 =
         0.18623    0.00128   -0.00251    0.03662
AFIX  13
HB    2    0.889937    1.211856    0.117721    11.00000   -1.20000
AFIX   0
OG1   4    0.889185    1.244820    0.110162    11.00000    0.17552    0.13791 =
         0.23069    0.02084    0.00400    0.04157
AFIX  83
HG1   2    0.879628    1.250970    0.113258    11.00000   -1.50000
AFIX   0
CG2   1    0.870050    1.199281    0.100483    11.00000    0.19521    0.16624 =
         0.16859    0.01221    0.00667    0.08045
AFIX  33
HG2A  2    0.887240    1.205664    0.095867    11.00000   -1.50000
HG2B  2    0.857292    1.202839    0.095707    11.00000   -1.50000
HG2C  2    0.861556    1.179410    0.102054    11.00000   -1.50000
AFIX   0
 
RESI  125   LYS
N     3    0.845080    1.234866    0.136793    11.00000    0.17955    0.20120 =
         0.16776   -0.02422   -0.03473    0.06444
AFIX  43
H0    2    0.833182    1.236308    0.132038    11.00000   -1.20000
AFIX   0
CA    1    0.852336    1.248347    0.149283    11.00000    0.23175    0.29330 =
         0.21544   -0.09076   -0.07413    0.12951
AFIX  13
HA    2    0.869204    1.248241    0.152282    11.00000   -1.20000
AFIX   0
CB    1    0.859533    1.278846    0.147920    11.00000    0.39831    0.23249 =
         0.37725   -0.12591   -0.08238    0.06394
AFIX  23
HB1   2    0.855295    1.285282    0.155650    11.00000   -1.20000
HB2   2    0.848328    1.280425    0.141270    11.00000   -1.20000
AFIX   0
CG    1    0.890910    1.297034    0.144862    11.00000    0.40884    0.24310 =
         0.63056   -0.09864   -0.00107    0.12725
AFIX  23
HG1   2    0.901743    1.301410    0.152550    11.00000   -1.20000
HG2   2    0.896606    1.286450    0.139503    11.00000   -1.20000
AFIX   0
CD    1    0.897500    1.324377    0.138350    11.00000    0.56165    0.22786 =
         0.66500   -0.05221    0.04224    0.08312
AFIX  23
HD1   2    0.883717    1.320349    0.131798    11.00000   -1.20000
HD2   2    0.896083    1.336923    0.144346    11.00000   -1.20000
AFIX   0
CE    1    0.926946    1.338931    0.132669    11.00000    0.51919    0.25431 =
         0.63968   -0.03036   -0.01310    0.15997
AFIX  23
HE1   2    0.929898    1.324954    0.128420    11.00000   -1.20000
HE2   2    0.928189    1.352428    0.126452    11.00000   -1.20000
AFIX   0
NZ    3    0.949664    1.353798    0.142048    11.00000    0.58657    0.46433 =
         0.56158   -0.09462    0.04736   -0.05480
AFIX  33
HZ1   2    0.966319    1.362249    0.138201    11.00000   -1.50000
HZ2   2    0.949207    1.341406    0.147575    11.00000   -1.50000
HZ3   2    0.947098    1.366662    0.145996    11.00000   -1.50000
AFIX   0
C     1    0.829215    1.233286    0.158845    11.00000    0.28661    0.28402 =
         0.19375   -0.11127   -0.04031    0.17788
O     4    0.803998    1.223499    0.156160    11.00000    0.24356    0.28921 =
         0.29589    0.02049   -0.05207   -0.00251
 
RESI  126   SER
N     3    0.837404    1.231354    0.170320    11.00000    0.35751    0.36966 =
         0.21828   -0.06173   -0.08139    0.09493
AFIX  43
H0    2    0.855004    1.237556    0.171751    11.00000   -1.20000
AFIX   0
CA    1    0.817035    1.218835    0.180651    11.00000    0.47681    0.48163 =
         0.21691   -0.05498   -0.02848    0.13722
AFIX  13
HA    2    0.799737    1.203139    0.177155    11.00000   -1.20000
AFIX   0
CB    1    0.826521    1.206938    0.191475    11.00000    0.61831    0.49793 =
         0.22091   -0.02089    0.00859    0.21637
AFIX  23
HB1   2    0.810008    1.191161    0.195207    11.00000   -1.20000
HB2   2    0.838276    1.199860    0.188131    11.00000   -1.20000
AFIX   0
OG    4    0.841538    1.226834    0.200796    11.00000    0.70501    0.46631 =
         0.34087   -0.06374   -0.17585    0.37585
AFIX  83
HG    2    0.832410    1.234142    0.203146    11.00000   -1.50000
AFIX   0
C     1    0.809592    1.240503    0.185662    11.00000    0.37525    0.44902 =
         0.39023    0.03881    0.09358    0.09653
O     4    0.789858    1.233689    0.193006    11.00000    0.32503    0.59494 =
         0.33573    0.09195    0.04133    0.15505
 
RESI  127   SER
N     3    0.825937    1.266617    0.181455    11.00000    0.36696    0.43301 =
         0.51239    0.02839    0.06990    0.04935
AFIX  43
H0    2    0.839108    1.270102    0.176149    11.00000   -1.20000
AFIX   0
CA    1    0.821537    1.289345    0.185837    11.00000    0.54332    0.44098 =
         0.40539   -0.00702   -0.01520    0.11048
AFIX  13
HA    2    0.804270    1.281144    0.190880    11.00000   -1.20000
AFIX   0
CB    1    0.846433    1.309373    0.194141    11.00000    0.63917    0.51771 =
         0.53556   -0.04386   -0.12943    0.12385
AFIX  23
HB1   2    0.853178    1.328741    0.191626    11.00000   -1.20000
HB2   2    0.840360    1.307305    0.202801    11.00000   -1.20000
AFIX   0
OG    4    0.868562    1.303022    0.192990    11.00000    0.60333    0.65807 =
         1.10329   -0.28192   -0.28203    0.14755
AFIX  83
HG    2    0.863713    1.287702    0.196253    11.00000   -1.50000
AFIX   0
C     1    0.817566    1.303933    0.174517    11.00000    0.71153    0.44499 =
         0.29003   -0.06211    0.00610    0.17755
O     4    0.793741    1.298407    0.171083    11.00000    0.75967    0.67262 =
         0.36435    0.08624   -0.09070    0.17212
 
RESI  128   GLY
N     3    0.840677    1.322519    0.168661    11.00000    0.78463    0.44336 =
         0.23588   -0.10740    0.00818    0.10918
AFIX  43
H0    2    0.857209    1.326119    0.170959    11.00000   -1.20000
AFIX   0
CA    1    0.836212    1.336632    0.157946    11.00000    0.74283    0.44495 =
         0.30060   -0.06295    0.06714    0.14677
AFIX  23
HA1   2    0.854434    1.349924    0.154412    11.00000   -1.20000
HA2   2    0.827645    1.347341    0.160945    11.00000   -1.20000
AFIX   0
C     1    0.817907    1.317053    0.147689    11.00000    0.57390    0.40993 =
         0.31097   -0.03231    0.03955    0.21285
O     4    0.797921    1.292893    0.149626    11.00000    0.31810    0.48750 =
         0.29798    0.04384   -0.05755    0.22902
 
RESI  129   THR
N     3    0.824493    1.327435    0.136350    11.00000    0.45325    0.32841 =
         0.30925   -0.04642    0.05440    0.26397
AFIX  43
H0    2    0.835278    1.345341    0.135454    11.00000   -1.20000
AFIX   0
CA    1    0.814345    1.309979    0.125287    11.00000    0.39383    0.28249 =
         0.31484   -0.02965    0.07922    0.13592
AFIX  13
HA    2    0.809276    1.290654    0.127543    11.00000   -1.20000
AFIX   0
CB    1    0.789170    1.309251    0.118576    11.00000    0.36167    0.35244 =
         0.33284   -0.02493    0.08382    0.12760
AFIX  13
HB    2    0.784345    1.297598    0.111012    11.00000   -1.20000
AFIX   0
OG1   4    0.797881    1.337858    0.115355    11.00000    0.67822    0.54955 =
         0.73831    0.34582    0.13329    0.28416
AFIX  83
HG1   2    0.811775    1.344144    0.110793    11.00000   -1.50000
AFIX   0
CG2   1    0.763671    1.299549    0.126724    11.00000    0.52584    0.53853 =
         0.31803    0.14811    0.17728    0.37160
AFIX  33
HG2A  2    0.748852    1.299754    0.122000    11.00000   -1.50000
HG2B  2    0.768361    1.311954    0.133788    11.00000   -1.50000
HG2C  2    0.757466    1.280725    0.129605    11.00000   -1.50000
AFIX   0
C     1    0.837993    1.321013    0.115457    11.00000    0.35042    0.19760 =
         0.24046   -0.01822    0.01998    0.11241
O     4    0.852323    1.346280    0.113052    11.00000    0.26124    0.18689 =
         0.34594   -0.04519   -0.01879    0.08985
 
RESI  130   SER
N     3    0.840309    1.300736    0.109858    11.00000    0.32459    0.18810 =
         0.16134   -0.01331   -0.01704    0.10656
AFIX  43
H0    2    0.830184    1.283772    0.112586    11.00000   -1.20000
AFIX   0
CA    1    0.858708    1.305459    0.099524    11.00000    0.27801    0.16366 =
         0.18045   -0.02008   -0.01852    0.06097
AFIX  13
HA    2    0.859264    1.320159    0.094091    11.00000   -1.20000
AFIX   0
C     1    0.845986    1.277561    0.092369    11.00000    0.21471    0.14246 =
         0.15295    0.00744   -0.00905    0.06079
O     4    0.842789    1.255887    0.097327    11.00000    0.27133    0.15636 =
         0.17599    0.02422   -0.03643    0.06223
CB    1    0.888400    1.313800    0.103645    11.00000    0.28240    0.18870 =
         0.26145   -0.06574   -0.05342    0.06138
AFIX  23
HB1   2    0.895518    1.329869    0.109250    11.00000   -1.20000
HB2   2    0.888145    1.298282    0.108147    11.00000   -1.20000
AFIX   0
OG    4    0.906732    1.320955    0.092853    11.00000    0.26505    0.23005 =
         0.30341   -0.09498   -0.03054    0.04244
AFIX  83
HG    2    0.901144    1.307097    0.088310    11.00000   -1.50000
AFIX   0
 
RESI  131   TYR
N     3    0.838734    1.279213    0.080878    11.00000    0.24351    0.12518 =
         0.15946    0.00801   -0.00997    0.07239
AFIX  43
H0    2    0.840284    1.294724    0.078170    11.00000   -1.20000
AFIX   0
CA    1    0.828119    1.254969    0.072737    11.00000    0.22877    0.10261 =
         0.14845    0.01854    0.00252    0.03264
AFIX  13
HA    2    0.821134    1.237941    0.077882    11.00000   -1.20000
AFIX   0
C     1    0.851461    1.257194    0.064246    11.00000    0.24706    0.08279 =
         0.18533   -0.01457    0.02622    0.00103
O     4    0.866947    1.278956    0.058455    11.00000    0.26667    0.12375 =
         0.18719    0.02466    0.04467    0.04083
CB    1    0.803371    1.253155    0.065101    11.00000    0.30559    0.16199 =
         0.14389    0.00548   -0.03489    0.08808
AFIX  23
HB1   2    0.808808    1.271297    0.061334    11.00000   -1.20000
HB2   2    0.798143    1.239319    0.058464    11.00000   -1.20000
AFIX   0
CG    1    0.778747    1.244624    0.073906    11.00000    0.29921    0.20559 =
         0.25468    0.07978   -0.00412    0.16315
CD1   1    0.758097    1.216733    0.075373    11.00000    0.27262    0.22379 =
         0.40243    0.12601    0.04189    0.17357
AFIX  43
HD1   2    0.758888    1.202560    0.070906    11.00000   -1.20000
AFIX   0
CD2   1    0.777167    1.265067    0.080728    11.00000    0.23808    0.28639 =
         0.31207   -0.00843   -0.04549    0.16766
AFIX  43
HD2   2    0.791237    1.283781    0.079729    11.00000   -1.20000
AFIX   0
CE1   1    0.736242    1.210314    0.083612    11.00000    0.26046    0.30729 =
         0.47025    0.12111    0.05397    0.19342
AFIX  43
HE1   2    0.722097    1.191638    0.084634    11.00000   -1.20000
AFIX   0
CE2   1    0.755671    1.258913    0.088931    11.00000    0.27623    0.36355 =
         0.33439    0.00525   -0.01383    0.19600
AFIX  43
HE2   2    0.754995    1.273108    0.093434    11.00000   -1.20000
AFIX   0
CZ    1    0.735124    1.231200    0.090332    11.00000    0.22540    0.36941 =
         0.43499    0.07955   -0.00141    0.22319
OH    4    0.713184    1.224601    0.098538    11.00000    0.33730    0.45301 =
         0.44040    0.09532    0.07688    0.24330
AFIX  83
HH    2    0.714741    1.239166    0.101462    11.00000   -1.50000
AFIX   0
 
RESI  132   PRO
N     3    0.853061    1.233959    0.063785    11.00000    0.19254    0.11443 =
         0.15683    0.00077   -0.00825    0.01821
CA    1    0.875342    1.233048    0.056612    11.00000    0.21331    0.16308 =
         0.17011    0.01107    0.02424    0.03128
AFIX  13
HA    2    0.893202    1.250814    0.057536    11.00000   -1.20000
AFIX   0
C     1    0.867208    1.227136    0.042853    11.00000    0.36803    0.14316 =
         0.16966   -0.00630    0.00746    0.10949
O     4    0.842735    1.215700    0.038851    11.00000    0.42561    0.32783 =
         0.17655   -0.04794   -0.06757    0.17717
CB    1    0.877439    1.208643    0.062669    11.00000    0.19228    0.20407 =
         0.15800    0.00980    0.02788    0.06203
AFIX  23
HB1   2    0.884425    1.200127    0.056753    11.00000   -1.20000
HB2   2    0.889684    1.215032    0.069946    11.00000   -1.20000
AFIX   0
CG    1    0.847671    1.188523    0.066287    11.00000    0.17187    0.16452 =
         0.17056    0.02301   -0.00261    0.07011
AFIX  23
HG1   2    0.846992    1.176873    0.073274    11.00000   -1.20000
HG2   2    0.837366    1.176372    0.059308    11.00000   -1.20000
AFIX   0
CD    1    0.835304    1.206858    0.069956    11.00000    0.17312    0.12642 =
         0.14821    0.02316   -0.00449    0.04803
AFIX  23
HD1   2    0.815922    1.198514    0.067125    11.00000   -1.20000
HD2   2    0.835774    1.209202    0.078972    11.00000   -1.20000
AFIX   0
 
RESI  133   ASP
N     3    0.888322    1.234705    0.034956    11.00000    0.46942    0.14751 =
         0.20340   -0.03613    0.07551    0.13255
AFIX  43
H0    2    0.905791    1.243495    0.037130    11.00000   -1.20000
AFIX   0
CA    1    0.878408    1.226261    0.021824    11.00000    0.42663    0.16958 =
         0.19851   -0.00580    0.05129    0.15369
AFIX  13
HA    2    0.859604    1.224188    0.021160    11.00000   -1.20000
AFIX   0
C     1    0.875869    1.198381    0.018094    11.00000    0.22771    0.13325 =
         0.12311   -0.00719    0.01876    0.06667
O     4    0.858262    1.182380    0.010348    11.00000    0.19546    0.16404 =
         0.13927   -0.00030    0.00650    0.07275
CB    1    0.897714    1.249452    0.012824    11.00000    0.41965    0.15200 =
         0.23309    0.02545   -0.01112    0.11288
AFIX  23
HB1   2    0.890902    1.243464    0.004361    11.00000   -1.20000
HB2   2    0.896423    1.266161    0.014573    11.00000   -1.20000
AFIX   0
CG    1    0.928309    1.257309    0.013381    11.00000    0.40040    0.35644 =
         0.43809    0.08069    0.03504    0.11724
OD1   4    0.937507    1.248573    0.021949    11.00000    0.35537    0.49198 =
         0.46543    0.11890    0.11137    0.22085
OD2   4    0.944373    1.273013    0.004954    11.00000    0.44851    0.71625 =
         0.73822    0.40174    0.11847    0.17135
 
RESI  134   VAL
N     3    0.893532    1.192419    0.023986    11.00000    0.15003    0.11509 =
         0.21136   -0.01905   -0.01219    0.00991
AFIX  43
H0    2    0.905182    1.204179    0.029358    11.00000   -1.20000
AFIX   0
CA    1    0.893548    1.166157    0.021504    11.00000    0.13441    0.13637 =
         0.22121    0.01060    0.03557    0.03016
AFIX  13
HA    2    0.884534    1.158776    0.013377    11.00000   -1.20000
AFIX   0
C     1    0.877181    1.144071    0.031497    11.00000    0.12637    0.13554 =
         0.19864   -0.00116    0.01156    0.04330
O     4    0.871917    1.150964    0.041619    11.00000    0.17238    0.13897 =
         0.17124    0.00727    0.00009    0.05965
CB    1    0.924025    1.171671    0.020930    11.00000    0.13606    0.19261 =
         0.19807    0.06105    0.01467    0.04202
AFIX  13
HB    2    0.922928    1.153338    0.019989    11.00000   -1.20000
AFIX   0
CG1   1    0.938964    1.189085    0.009416    11.00000    0.18012    0.14664 =
         0.24801    0.07004    0.08078    0.06282
AFIX  33
HG1A  2    0.928165    1.179816    0.002074    11.00000   -1.50000
HG1B  2    0.957342    1.191017    0.008764    11.00000   -1.50000
HG1C  2    0.940820    1.207422    0.010137    11.00000   -1.50000
AFIX   0
CG2   1    0.940428    1.185062    0.032996    11.00000    0.18059    0.18637 =
         0.24017   -0.01178   -0.00738    0.06502
AFIX  33
HG2A  2    0.930603    1.173123    0.039984    11.00000   -1.50000
HG2B  2    0.942042    1.203202    0.034167    11.00000   -1.50000
HG2C  2    0.958922    1.187255    0.032401    11.00000   -1.50000
AFIX   0
 
RESI  135   LEU
N     3    0.869058    1.117590    0.028795    11.00000    0.11093    0.12814 =
         0.21081    0.00652    0.00154    0.04729
AFIX  43
H0    2    0.874760    1.113927    0.021918    11.00000   -1.20000
AFIX   0
CA    1    0.850744    1.094235    0.037040    11.00000    0.10091    0.13275 =
         0.17131   -0.01022    0.01500    0.04841
AFIX  13
HA    2    0.834972    1.096753    0.039642    11.00000   -1.20000
AFIX   0
C     1    0.866967    1.094411    0.048785    11.00000    0.09368    0.14122 =
         0.17414   -0.01295    0.00511    0.02237
O     4    0.890750    1.097605    0.047992    11.00000    0.09970    0.14657 =
         0.17782    0.02080    0.02146    0.04020
CB    1    0.838811    1.066173    0.030099    11.00000    0.08368    0.12913 =
         0.17796   -0.00869    0.01238    0.02321
AFIX  23
HB1   2    0.830870    1.067854    0.022244    11.00000   -1.20000
HB2   2    0.854350    1.063106    0.028079    11.00000   -1.20000
AFIX   0
CG    1    0.816337    1.040096    0.036901    11.00000    0.08027    0.13182 =
         0.18389   -0.00306    0.02776    0.03443
AFIX  13
HG    2    0.823695    1.039629    0.045210    11.00000   -1.20000
AFIX   0
CD1   1    0.788594    1.040066    0.038712    11.00000    0.07466    0.15046 =
         0.14109   -0.02150   -0.00073    0.03757
AFIX  33
HD1A  2    0.775392    1.023252    0.043079    11.00000   -1.50000
HD1B  2    0.780981    1.040617    0.030686    11.00000   -1.50000
HD1C  2    0.792001    1.056310    0.043506    11.00000   -1.50000
AFIX   0
CD2   1    0.811188    1.013528    0.029788    11.00000    0.13347    0.12972 =
         0.14907    0.01473    0.02748    0.05730
AFIX  33
HD2A  2    0.797104    0.997068    0.034081    11.00000   -1.50000
HD2B  2    0.828435    1.012992    0.029382    11.00000   -1.50000
HD2C  2    0.804807    1.013925    0.021457    11.00000   -1.50000
AFIX   0
 
RESI  136   LYS
N     3    0.852931    1.090835    0.059469    11.00000    0.08966    0.10253 =
         0.18368    0.02834    0.01737    0.04288
AFIX  43
H0    2    0.836603    1.089483    0.059098    11.00000   -1.20000
AFIX   0
CA    1    0.863570    1.089096    0.071657    11.00000    0.11287    0.13532 =
         0.17813    0.02914    0.01535    0.04513
AFIX  13
HA    2    0.883366    1.094207    0.070664    11.00000   -1.20000
AFIX   0
C     1    0.847199    1.058604    0.076243    11.00000    0.12126    0.13017 =
         0.15237    0.01895    0.00204    0.05306
O     4    0.822566    1.043410    0.073182    11.00000    0.11923    0.12435 =
         0.19458    0.01264   -0.00023    0.04660
CB    1    0.862399    1.109524    0.081027    11.00000    0.14579    0.13020 =
         0.19197    0.01144   -0.02593    0.06221
AFIX  23
HB1   2    0.842832    1.104577    0.081986    11.00000   -1.20000
HB2   2    0.868741    1.106583    0.089075    11.00000   -1.20000
AFIX   0
CG    1    0.879435    1.140658    0.077935    11.00000    0.14718    0.13844 =
         0.32482    0.03588    0.01264    0.08297
AFIX  23
HG1   2    0.875271    1.151196    0.084038    11.00000   -1.20000
HG2   2    0.873804    1.143864    0.069766    11.00000   -1.20000
AFIX   0
CD    1    0.911256    1.151681    0.077884    11.00000    0.14299    0.18921 =
         0.38030    0.00555    0.07266    0.06389
AFIX  23
HD1   2    0.917427    1.150054    0.086201    11.00000   -1.20000
HD2   2    0.915563    1.140578    0.072167    11.00000   -1.20000
AFIX   0
CE    1    0.926518    1.182326    0.073803    11.00000    0.14418    0.18385 =
         0.46360    0.00477    0.01351    0.05738
AFIX  23
HE1   2    0.926597    1.183503    0.064739    11.00000   -1.20000
HE2   2    0.916985    1.191838    0.077126    11.00000   -1.20000
AFIX   0
NZ    3    0.955821    1.195951    0.078570    11.00000    0.14247    0.26326 =
         0.53284   -0.15260   -0.01276    0.03725
AFIX  33
HZ1   2    0.965255    1.213775    0.075963    11.00000   -1.50000
HZ2   2    0.964225    1.186727    0.075710    11.00000   -1.50000
HZ3   2    0.955599    1.195544    0.086902    11.00000   -1.50000
AFIX   0
 
RESI  137   CYS
N     3    0.862384    1.051236    0.083282    11.00000    0.11653    0.16419 =
         0.22898    0.05122    0.02084    0.07347
AFIX  43
H0    2    0.879577    1.064073    0.084656    11.00000   -1.20000
AFIX   0
CA    1    0.853195    1.023861    0.088936    11.00000    0.15768    0.14957 =
         0.23295    0.01696   -0.02344    0.09379
AFIX  13
HA    2    0.832776    1.012005    0.087774    11.00000   -1.20000
AFIX   0
C     1    0.859765    1.026131    0.102887    11.00000    0.08859    0.15162 =
         0.22613    0.02909   -0.01071    0.04879
O     4    0.879329    1.046268    0.108207    11.00000    0.08744    0.14575 =
         0.25761    0.03773   -0.02558    0.03098
CB    1    0.868002    1.010103    0.082168    11.00000    0.13503    0.18117 =
         0.24455    0.02576    0.00144    0.09242
AFIX  23
HB1   2    0.866628    0.995145    0.087519    11.00000   -1.20000
HB2   2    0.887857    1.024152    0.081563    11.00000   -1.20000
AFIX   0
SG    5    0.856574    0.995659    0.067060    11.00000    0.16860    0.18583 =
         0.24469    0.01346    0.00313    0.09266
 
RESI  138   LEU
N     3    0.842379    1.003324    0.109230    11.00000    0.08435    0.14215 =
         0.21731    0.00464   -0.01035    0.02997
AFIX  43
H0    2    0.828898    0.989776    0.105122    11.00000   -1.20000
AFIX   0
CA    1    0.843976    0.999152    0.122318    11.00000    0.14243    0.16883 =
         0.21451    0.01849    0.00261    0.08111
AFIX  13
HA    2    0.863628    1.010564    0.125049    11.00000   -1.20000
AFIX   0
C     1    0.833465    0.968018    0.125427    11.00000    0.10638    0.16376 =
         0.22718    0.00434   -0.01261    0.07890
O     4    0.810657    0.948724    0.121536    11.00000    0.11125    0.17253 =
         0.24542    0.01711   -0.01249    0.07266
CB    1    0.825679    1.008448    0.129645    11.00000    0.20964    0.17972 =
         0.22200   -0.02285   -0.01652    0.11695
AFIX  23
HB1   2    0.832748    1.028272    0.127928    11.00000   -1.20000
HB2   2    0.806601    0.998073    0.126388    11.00000   -1.20000
AFIX   0
CG    1    0.824328    1.004449    0.143878    11.00000    0.16338    0.11598 =
         0.22454   -0.01491    0.00201    0.05223
AFIX  13
HG    2    0.818364    0.984649    0.145580    11.00000   -1.20000
AFIX   0
CD1   1    0.853181    1.022605    0.149833    11.00000    0.19879    0.27447 =
         0.26795   -0.06858   -0.05362    0.09851
AFIX  33
HD1A  2    0.866439    1.018043    0.146189    11.00000   -1.50000
HD1B  2    0.851928    1.019064    0.158680    11.00000   -1.50000
HD1C  2    0.859373    1.042160    0.148385    11.00000   -1.50000
AFIX   0
CD2   1    0.801987    1.010310    0.149101    11.00000    0.20188    0.18803 =
         0.27317   -0.02215    0.02467    0.09607
AFIX  33
HD2A  2    0.784486    0.998889    0.144789    11.00000   -1.50000
HD2B  2    0.807856    1.029880    0.147948    11.00000   -1.50000
HD2C  2    0.799482    1.005870    0.157871    11.00000   -1.50000
AFIX   0
 
RESI  139   LYS
N     3    0.850934    0.963669    0.132555    11.00000    0.10843    0.19690 =
         0.24463    0.04667   -0.00156    0.07588
AFIX  43
H0    2    0.867352    0.977747    0.134198    11.00000   -1.20000
AFIX   0
CA    1    0.843487    0.936293    0.137653    11.00000    0.15496    0.18308 =
         0.23142    0.00837   -0.02912    0.09794
AFIX  13
HA    2    0.828583    0.921894    0.132382    11.00000   -1.20000
AFIX   0
C     1    0.831419    0.933994    0.150671    11.00000    0.16433    0.20368 =
         0.20046    0.02751   -0.04568    0.08581
O     4    0.844616    0.952873    0.158312    11.00000    0.16033    0.21061 =
         0.21773    0.01411   -0.02835    0.06867
CB    1    0.868952    0.931291    0.137354    11.00000    0.17229    0.25996 =
         0.31649    0.00889   -0.05597    0.13902
AFIX  23
HB1   2    0.886318    0.948860    0.138884    11.00000   -1.20000
HB2   2    0.866882    0.917896    0.143798    11.00000   -1.20000
AFIX   0
CG    1    0.869868    0.919678    0.124358    11.00000    0.43926    0.47143 =
         0.41481   -0.00159    0.13727    0.30021
AFIX  23
HG1   2    0.864678    0.900020    0.125201    11.00000   -1.20000
HG2   2    0.855945    0.920482    0.119021    11.00000   -1.20000
AFIX   0
CD    1    0.898307    0.935464    0.118093    11.00000    0.51626    0.65499 =
         0.48314    0.13447    0.21264    0.28180
AFIX  23
HD1   2    0.912522    0.935141    0.123402    11.00000   -1.20000
HD2   2    0.903363    0.954982    0.116813    11.00000   -1.20000
AFIX   0
CE    1    0.897277    0.921725    0.105497    11.00000    0.52293    0.76750 =
         0.55460    0.11787    0.27541    0.46192
AFIX  23
HE1   2    0.881318    0.902656    0.105365    11.00000   -1.20000
HE2   2    0.894738    0.932285    0.098827    11.00000   -1.20000
AFIX   0
NZ    3    0.923747    0.920992    0.103338    11.00000    0.52662    0.94002 =
         0.74033    0.24820    0.26421    0.53485
AFIX  33
HZ1   2    0.922897    0.913177    0.095924    11.00000   -1.50000
HZ2   2    0.925801    0.910868    0.109335    11.00000   -1.50000
HZ3   2    0.938382    0.938493    0.103464    11.00000   -1.50000
AFIX   0
 
RESI  140   ALA
N     3    0.806092    0.911757    0.152980    11.00000    0.17672    0.17760 =
         0.24213   -0.01377   -0.01160    0.08879
AFIX  43
H0    2    0.798029    0.898639    0.147470    11.00000   -1.20000
AFIX   0
CA    1    0.792110    0.909723    0.164847    11.00000    0.18558    0.15920 =
         0.22118    0.02134   -0.01687    0.10515
AFIX  13
HA    2    0.806538    0.918587    0.171365    11.00000   -1.20000
AFIX   0
C     1    0.772447    0.878717    0.168402    11.00000    0.19886    0.14245 =
         0.22582    0.00830   -0.02996    0.11876
O     4    0.758207    0.861418    0.160176    11.00000    0.17601    0.17398 =
         0.22310   -0.01299    0.01760    0.10314
CB    1    0.774144    0.924029    0.164712    11.00000    0.21555    0.14317 =
         0.36523    0.08645    0.07918    0.11324
AFIX  33
HB1   2    0.785799    0.943583    0.162579    11.00000   -1.50000
HB2   2    0.766022    0.922480    0.172846    11.00000   -1.50000
HB3   2    0.759362    0.914982    0.158625    11.00000   -1.50000
AFIX   0
 
RESI  141   PRO
N     3    0.771869    0.872089    0.180301    11.00000    0.13852    0.17789 =
         0.21900    0.02178    0.00843    0.07836
CA    1    0.753294    0.843241    0.184335    11.00000    0.15761    0.17068 =
         0.21652    0.01384    0.01649    0.08906
AFIX  13
HA    2    0.753309    0.829855    0.178245    11.00000   -1.20000
AFIX   0
C     1    0.723428    0.836948    0.186919    11.00000    0.16337    0.14830 =
         0.18327    0.06517    0.03229    0.09297
O     4    0.717876    0.855074    0.190590    11.00000    0.15049    0.15509 =
         0.23204    0.02555    0.00375    0.08763
CB    1    0.766417    0.841447    0.196916    11.00000    0.14746    0.16237 =
         0.27825    0.03875   -0.01836    0.05965
AFIX  23
HB1   2    0.752214    0.827630    0.202476    11.00000   -1.20000
HB2   2    0.781118    0.836738    0.195604    11.00000   -1.20000
AFIX   0
CG    1    0.778286    0.870801    0.201968    11.00000    0.18443    0.16766 =
         0.23208    0.03401   -0.01957    0.06781
AFIX  23
HG1   2    0.793654    0.875144    0.207716    11.00000   -1.20000
HG2   2    0.763822    0.872651    0.206397    11.00000   -1.20000
AFIX   0
CD    1    0.788866    0.890625    0.190781    11.00000    0.27833    0.16282 =
         0.22718    0.02626   -0.04194    0.09429
AFIX  23
HD1   2    0.785439    0.906252    0.191875    11.00000   -1.20000
HD2   2    0.808866    0.897977    0.189418    11.00000   -1.20000
AFIX   0
 
RESI  142   ILE
N     3    0.703623    0.810160    0.185044    11.00000    0.15491    0.15385 =
         0.22433    0.04267    0.02099    0.09652
AFIX  43
H0    2    0.707854    0.798767    0.181386    11.00000   -1.20000
AFIX   0
CA    1    0.674697    0.800151    0.189211    11.00000    0.16139    0.17394 =
         0.20553    0.06860    0.03961    0.09227
AFIX  13
HA    2    0.668274    0.812899    0.186182    11.00000   -1.20000
AFIX   0
C     1    0.674804    0.799940    0.203516    11.00000    0.17815    0.18681 =
         0.20229    0.04848    0.01297    0.12004
O     4    0.688007    0.790300    0.209302    11.00000    0.18292    0.18203 =
         0.22614    0.03125    0.00145    0.12629
CB    1    0.655446    0.770208    0.183991    11.00000    0.13412    0.20292 =
         0.20217    0.04624    0.01168    0.10122
AFIX  13
HB    2    0.663783    0.758796    0.186590    11.00000   -1.20000
AFIX   0
CG1   1    0.654289    0.769275    0.169698    11.00000    0.13277    0.21151 =
         0.20003    0.07682   -0.01317    0.07529
AFIX  23
HG1A  2    0.646925    0.781205    0.166905    11.00000   -1.20000
HG1B  2    0.673460    0.777564    0.166592    11.00000   -1.20000
AFIX   0
CG2   1    0.625995    0.756406    0.189648    11.00000    0.13253    0.20019 =
         0.23945    0.06230    0.01646    0.09973
AFIX  33
HG2A  2    0.627391    0.757479    0.198615    11.00000   -1.50000
HG2B  2    0.615576    0.736989    0.187119    11.00000   -1.50000
HG2C  2    0.616441    0.766045    0.186779    11.00000   -1.50000
AFIX   0
CD1   1    0.637136    0.740933    0.163682    11.00000    0.17837    0.23590 =
         0.21218    0.02859    0.03904    0.09984
AFIX  33
HD1A  2    0.638307    0.743021    0.154740    11.00000   -1.50000
HD1B  2    0.617812    0.732764    0.166262    11.00000   -1.50000
HD1C  2    0.644296    0.728853    0.166188    11.00000   -1.50000
AFIX   0
 
RESI  143   LEU
N     3    0.660169    0.809754    0.209312    11.00000    0.18227    0.17181 =
         0.18853    0.05406    0.00727    0.11881
AFIX  43
H0    2    0.651684    0.816341    0.204856    11.00000   -1.20000
AFIX   0
CA    1    0.657682    0.809963    0.223009    11.00000    0.13277    0.19629 =
         0.18816    0.05742    0.00327    0.12148
AFIX  13
HA    2    0.674027    0.809842    0.226684    11.00000   -1.20000
AFIX   0
C     1    0.631376    0.784407    0.227770    11.00000    0.14878    0.19315 =
         0.19467    0.04498    0.01146    0.11174
O     4    0.610935    0.769934    0.220755    11.00000    0.13642    0.23233 =
         0.18124    0.03951    0.02693    0.10768
CB    1    0.658885    0.837535    0.226828    11.00000    0.17005    0.19290 =
         0.21606    0.02500    0.00732    0.10819
AFIX  23
HB1   2    0.642860    0.837822    0.223111    11.00000   -1.20000
HB2   2    0.656741    0.837433    0.235848    11.00000   -1.20000
AFIX   0
CG    1    0.685595    0.864723    0.223184    11.00000    0.15687    0.19895 =
         0.18092    0.02631   -0.02191    0.09940
AFIX  13
HG    2    0.689234    0.863412    0.214294    11.00000   -1.20000
AFIX   0
CD1   1    0.681673    0.890178    0.224840    11.00000    0.18679    0.18021 =
         0.36798   -0.01553   -0.08695    0.09179
AFIX  33
HD1A  2    0.665990    0.887728    0.219868    11.00000   -1.50000
HD1B  2    0.698465    0.906914    0.222197    11.00000   -1.50000
HD1C  2    0.678092    0.891944    0.233498    11.00000   -1.50000
AFIX   0
CD2   1    0.710854    0.867912    0.230616    11.00000    0.14531    0.40057 =
         0.44337    0.24745    0.00402    0.13269
AFIX  33
HD2A  2    0.712622    0.851481    0.229418    11.00000   -1.50000
HD2B  2    0.708119    0.869957    0.239351    11.00000   -1.50000
HD2C  2    0.727705    0.884304    0.227754    11.00000   -1.50000
AFIX   0
 
RESI  144   SER
N     3    0.631872    0.778894    0.239991    11.00000    0.15079    0.22786 =
         0.19269    0.05371    0.02406    0.10703
AFIX  43
H0    2    0.646346    0.789198    0.244584    11.00000   -1.20000
AFIX   0
CA    1    0.606694    0.754582    0.245136    11.00000    0.18418    0.17815 =
         0.23234    0.07087    0.02882    0.11448
AFIX  13
HA    2    0.602576    0.737769    0.240269    11.00000   -1.20000
AFIX   0
C     1    0.581288    0.758694    0.244681    11.00000    0.16318    0.18891 =
         0.21805    0.08868    0.05881    0.10212
O     4    0.584395    0.782704    0.245350    11.00000    0.16149    0.19458 =
         0.25899    0.07904    0.03265    0.11190
CB    1    0.611910    0.749957    0.258833    11.00000    0.19851    0.25502 =
         0.23446    0.09188    0.03547    0.13013
AFIX  23
HB1   2    0.595621    0.733179    0.262096    11.00000   -1.20000
HB2   2    0.628120    0.747296    0.259362    11.00000   -1.20000
AFIX   0
OG    4    0.616828    0.773753    0.265980    11.00000    0.19496    0.30435 =
         0.22805    0.05466    0.00490    0.16152
AFIX  83
HG    2    0.619488    0.771317    0.273318    11.00000   -1.50000
AFIX   0
 
RESI  145   ASP
N     3    0.556512    0.735284    0.243620    11.00000    0.17182    0.19729 =
         0.29104    0.07484    0.06557    0.09920
AFIX  43
H0    2    0.555660    0.719203    0.243050    11.00000   -1.20000
AFIX   0
CA    1    0.530547    0.736870    0.243418    11.00000    0.16103    0.27895 =
         0.26894    0.02810    0.03996    0.11259
AFIX  13
HA    2    0.531667    0.748680    0.236296    11.00000   -1.20000
AFIX   0
C     1    0.528491    0.751073    0.255332    11.00000    0.15741    0.21272 =
         0.22631    0.09458    0.07015    0.09346
O     4    0.519681    0.768049    0.254784    11.00000    0.17238    0.21898 =
         0.21179    0.05704    0.00906    0.10169
CB    1    0.504659    0.707548    0.241510    11.00000    0.18860    0.36966 =
         0.49158   -0.10134   -0.01236    0.08250
AFIX  23
HB1   2    0.506111    0.694306    0.247063    11.00000   -1.20000
HB2   2    0.487884    0.708225    0.243848    11.00000   -1.20000
AFIX   0
CG    1    0.501278    0.696774    0.228190    11.00000    0.26303    0.61057 =
         0.61322   -0.29213    0.00794    0.06214
OD1   4    0.515670    0.713823    0.219675    11.00000    0.34655    0.88910 =
         0.52310   -0.40189    0.11012   -0.16147
OD2   4    0.483787    0.671195    0.226256    11.00000    0.67067    0.80040 =
         0.76920   -0.41891   -0.07234   -0.25260
 
RESI  146   SER
N     3    0.536534    0.745138    0.266173    11.00000    0.15150    0.19788 =
         0.25224    0.08021    0.03827    0.08952
AFIX  43
H0    2    0.543430    0.734053    0.266153    11.00000   -1.20000
AFIX   0
CA    1    0.534014    0.756797    0.277995    11.00000    0.16361    0.23404 =
         0.23152    0.09532    0.05660    0.08727
AFIX  13
HA    2    0.514670    0.753344    0.278568    11.00000   -1.20000
AFIX   0
C     1    0.553731    0.788595    0.278035    11.00000    0.16878    0.23816 =
         0.17934    0.06821    0.05741    0.08132
O     4    0.545584    0.804186    0.282306    11.00000    0.18315    0.25019 =
         0.17707    0.04637    0.02334    0.09672
CB    1    0.538705    0.741816    0.289176    11.00000    0.29419    0.30496 =
         0.25214    0.11676    0.07111    0.18460
AFIX  23
HB1   2    0.536476    0.749824    0.296901    11.00000   -1.20000
HB2   2    0.524401    0.721994    0.289027    11.00000   -1.20000
AFIX   0
OG    4    0.565927    0.744289    0.289050    11.00000    0.20922    0.49252 =
         0.44005    0.27249    0.00379    0.12300
AFIX  83
HG    2    0.567873    0.737419    0.282565    11.00000   -1.50000
AFIX   0
 
RESI  147   SER
N     3    0.579357    0.798144    0.273145    11.00000    0.16565    0.23324 =
         0.20814    0.09264    0.05860    0.08107
AFIX  43
H0    2    0.584768    0.787033    0.270157    11.00000   -1.20000
AFIX   0
CA    1    0.597617    0.828825    0.273218    11.00000    0.12161    0.23541 =
         0.17923    0.04058   -0.01180    0.07644
AFIX  13
HA    2    0.597221    0.835508    0.281689    11.00000   -1.20000
AFIX   0
C     1    0.586585    0.842818    0.264255    11.00000    0.13274    0.20736 =
         0.14652    0.04187    0.01552    0.06915
O     4    0.589478    0.866101    0.266171    11.00000    0.20387    0.21348 =
         0.18786    0.05359    0.02636    0.09353
CB    1    0.628149    0.836863    0.270327    11.00000    0.11082    0.29160 =
         0.39042    0.01618   -0.01221    0.07573
AFIX  23
HB1   2    0.640909    0.855904    0.273210    11.00000   -1.20000
HB2   2    0.632838    0.824138    0.274630    11.00000   -1.20000
AFIX   0
OG    4    0.631036    0.835151    0.257381    11.00000    0.24288    0.44439 =
         0.46579   -0.05308    0.16368    0.07146
AFIX  83
HG    2    0.621249    0.818737    0.255096    11.00000   -1.50000
AFIX   0
 
RESI  148   CYS
N     3    0.574548    0.829621    0.253886    11.00000    0.13078    0.22894 =
         0.15424    0.04550    0.00385    0.08155
AFIX  43
H0    2    0.573971    0.813916    0.252353    11.00000   -1.20000
AFIX   0
CA    1    0.561996    0.839969    0.244732    11.00000    0.13205    0.17147 =
         0.13517    0.02821    0.01975    0.07322
AFIX  13
HA    2    0.576534    0.858877    0.242088    11.00000   -1.20000
AFIX   0
C     1    0.537721    0.842291    0.250652    11.00000    0.12328    0.14340 =
         0.15207    0.02499    0.02039    0.05290
O     4    0.536577    0.864263    0.250064    11.00000    0.16695    0.17562 =
         0.14031    0.02603    0.01487    0.09326
CB    1    0.552967    0.820631    0.233268    11.00000    0.17319    0.19686 =
         0.14132    0.00796    0.00554    0.08923
AFIX  23
HB1   2    0.537743    0.802184    0.235717    11.00000   -1.20000
HB2   2    0.568712    0.818386    0.230667    11.00000   -1.20000
AFIX   0
SG    5    0.541385    0.832733    0.219940    11.00000    0.18020    0.20603 =
         0.14618    0.00442    0.00860    0.11221
 
RESI  149   LYS
N     3    0.518306    0.819464    0.256558    11.00000    0.12666    0.18359 =
         0.12627    0.05186    0.01738    0.06003
AFIX  43
H0    2    0.520292    0.804874    0.257090    11.00000   -1.20000
AFIX   0
CA    1    0.493768    0.818733    0.262136    11.00000    0.12294    0.20245 =
         0.14469    0.03993    0.01837    0.06648
AFIX  13
HA    2    0.485402    0.825467    0.255882    11.00000   -1.20000
AFIX   0
C     1    0.501957    0.838118    0.273469    11.00000    0.14711    0.23599 =
         0.19869   -0.00884    0.00617    0.08578
O     4    0.487621    0.849076    0.275947    11.00000    0.18631    0.22695 =
         0.25214   -0.02381   -0.03123    0.11045
CB    1    0.471537    0.788440    0.265743    11.00000    0.14605    0.19319 =
         0.09993    0.05395    0.04952    0.10112
AFIX  23
HB1   2    0.480132    0.780467    0.271072    11.00000   -1.20000
HB2   2    0.456527    0.788739    0.270446    11.00000   -1.20000
AFIX   0
CG    1    0.459103    0.769876    0.254102    11.00000    0.19056    0.19137 =
         0.16354    0.02162   -0.01201    0.09830
AFIX  23
HG1   2    0.462277    0.781829    0.246870    11.00000   -1.20000
HG2   2    0.468807    0.759380    0.252662    11.00000   -1.20000
AFIX   0
CD    1    0.427622    0.749271    0.255422    11.00000    0.23676    0.31405 =
         0.22833   -0.00076    0.03122    0.00448
AFIX  23
HD1   2    0.417757    0.759679    0.256653    11.00000   -1.20000
HD2   2    0.424304    0.737434    0.262711    11.00000   -1.20000
AFIX   0
CE    1    0.416196    0.730896    0.243841    11.00000    0.47575    0.33512 =
         0.25535   -0.00797    0.00985   -0.17685
AFIX  23
HE1   2    0.424825    0.742420    0.236480    11.00000   -1.20000
HE2   2    0.421562    0.716485    0.244096    11.00000   -1.20000
AFIX   0
NZ    3    0.384652    0.716861    0.242635    11.00000    0.46679    0.90865 =
         0.22178    0.03430   -0.02806   -0.30115
AFIX  33
HZ1   2    0.379145    0.706481    0.235692    11.00000   -1.50000
HZ2   2    0.379580    0.729963    0.242249    11.00000   -1.50000
HZ3   2    0.376560    0.705833    0.249249    11.00000   -1.50000
AFIX   0
 
RESI  150   SER
N     3    0.524080    0.842391    0.280314    11.00000    0.16498    0.23940 =
         0.18105   -0.03268    0.00598    0.10599
AFIX  43
H0    2    0.532651    0.833275    0.278527    11.00000   -1.20000
AFIX   0
CA    1    0.534048    0.862035    0.290699    11.00000    0.13211    0.23235 =
         0.15990   -0.01732    0.03943    0.06284
AFIX  13
HA    2    0.518280    0.857427    0.296391    11.00000   -1.20000
AFIX   0
C     1    0.546271    0.892214    0.286233    11.00000    0.20391    0.23802 =
         0.12163   -0.02645   -0.02095    0.09451
O     4    0.544756    0.910248    0.292500    11.00000    0.26382    0.23317 =
         0.16697   -0.04690    0.00791    0.08132
CB    1    0.556868    0.859195    0.297739    11.00000    0.24756    0.21696 =
         0.23631   -0.01881   -0.05507    0.09514
AFIX  23
HB1   2    0.570485    0.859386    0.291868    11.00000   -1.20000
HB2   2    0.566713    0.874843    0.303500    11.00000   -1.20000
AFIX   0
OG    4    0.543586    0.833293    0.304435    11.00000    0.25744    0.23509 =
         0.32165    0.02204    0.02017    0.10812
AFIX  83
HG    2    0.531942    0.833196    0.309297    11.00000   -1.50000
AFIX   0
 
RESI  151   ALA
N     3    0.559106    0.898553    0.275234    11.00000    0.21119    0.22120 =
         0.14830   -0.01420    0.00240    0.09103
AFIX  43
H0    2    0.559729    0.885475    0.271029    11.00000   -1.20000
AFIX   0
CA    1    0.572213    0.926876    0.269994    11.00000    0.19391    0.21618 =
         0.16445   -0.01941    0.00185    0.07603
AFIX  13
HA    2    0.582837    0.940260    0.276692    11.00000   -1.20000
AFIX   0
C     1    0.549859    0.933626    0.265261    11.00000    0.20702    0.19176 =
         0.19335   -0.01597   -0.00234    0.07544
O     4    0.554700    0.958103    0.266043    11.00000    0.25962    0.19879 =
         0.20666   -0.03899   -0.02648    0.09172
CB    1    0.592917    0.930843    0.259503    11.00000    0.22781    0.24170 =
         0.18204   -0.01400    0.02572    0.09259
AFIX  33
HB1   2    0.606912    0.926727    0.262630    11.00000   -1.50000
HB2   2    0.601948    0.949987    0.256583    11.00000   -1.50000
HB3   2    0.582883    0.918304    0.252712    11.00000   -1.50000
AFIX   0
 
RESI  152   TYR
N     3    0.526609    0.911996    0.260495    11.00000    0.23473    0.19754 =
         0.16843   -0.03907   -0.03377    0.11447
AFIX  43
H0    2    0.524992    0.895538    0.260502    11.00000   -1.20000
AFIX   0
CA    1    0.503639    0.915289    0.255228    11.00000    0.22905    0.27074 =
         0.13281   -0.01230   -0.00337    0.13289
AFIX  13
HA    2    0.507200    0.934243    0.257286    11.00000   -1.20000
AFIX   0
C     1    0.475001    0.893806    0.260634    11.00000    0.23566    0.32487 =
         0.15116   -0.03474    0.03125    0.12827
O     4    0.456838    0.874639    0.254182    11.00000    0.23832    0.27210 =
         0.12802    0.00693    0.02739    0.12405
CB    1    0.504090    0.912821    0.241209    11.00000    0.19335    0.30351 =
         0.13724   -0.01901    0.01341    0.14512
AFIX  23
HB1   2    0.488507    0.914370    0.237782    11.00000   -1.20000
HB2   2    0.500748    0.894115    0.239192    11.00000   -1.20000
AFIX   0
CG    1    0.530679    0.934054    0.234733    11.00000    0.19812    0.23995 =
         0.13608   -0.04575    0.00228    0.12722
CD1   1    0.536282    0.961277    0.232744    11.00000    0.22405    0.22869 =
         0.21905   -0.08041   -0.00928    0.13172
AFIX  43
HD1   2    0.523535    0.966645    0.235503    11.00000   -1.20000
AFIX   0
CD2   1    0.550060    0.927017    0.230173    11.00000    0.18610    0.21006 =
         0.12742    0.00495    0.02061    0.11619
AFIX  43
HD2   2    0.546579    0.908687    0.231245    11.00000   -1.20000
AFIX   0
CE1   1    0.560796    0.980735    0.226656    11.00000    0.24135    0.24237 =
         0.26306    0.00216    0.00610    0.16332
AFIX  43
HE1   2    0.564391    0.999098    0.225559    11.00000   -1.20000
AFIX   0
CE2   1    0.574409    0.946388    0.224081    11.00000    0.15926    0.16548 =
         0.15220   -0.01687   -0.00857    0.07881
AFIX  43
HE2   2    0.587165    0.941120    0.221226    11.00000   -1.20000
AFIX   0
CZ    1    0.579707    0.973512    0.222253    11.00000    0.19408    0.18613 =
         0.17435   -0.00677   -0.02653    0.11712
OH    4    0.603074    0.993913    0.216327    11.00000    0.25344    0.17488 =
         0.16620    0.01221    0.00491    0.13498
AFIX  83
HH    2    0.613001    0.987404    0.214097    11.00000   -1.50000
AFIX   0
 
RESI  153   PRO
N     3    0.470746    0.896736    0.272702    11.00000    0.23825    0.35157 =
         0.14386   -0.02561    0.00717    0.16382
CA    1    0.444239    0.876226    0.278828    11.00000    0.25602    0.33436 =
         0.13550    0.00012    0.02797    0.20078
AFIX  13
HA    2    0.442885    0.857711    0.279338    11.00000   -1.20000
AFIX   0
C     1    0.418640    0.873924    0.272056    11.00000    0.23601    0.31631 =
         0.12736    0.04293    0.04275    0.16421
O     4    0.418187    0.895372    0.268697    11.00000    0.24099    0.29646 =
         0.14331    0.02328   -0.00961    0.14601
CB    1    0.446477    0.888325    0.291792    11.00000    0.32249    0.41452 =
         0.12524   -0.01275    0.01716    0.19792
AFIX  23
HB1   2    0.432872    0.894634    0.292729    11.00000   -1.20000
HB2   2    0.442502    0.873994    0.298066    11.00000   -1.20000
AFIX   0
CG    1    0.475354    0.912316    0.293494    11.00000    0.37143    0.38655 =
         0.16016   -0.03908    0.03243    0.16366
AFIX  23
HG1   2    0.485495    0.907312    0.299459    11.00000   -1.20000
HG2   2    0.474572    0.928451    0.296755    11.00000   -1.20000
AFIX   0
CD    1    0.490435    0.919709    0.281114    11.00000    0.27321    0.39029 =
         0.14319   -0.04759   -0.00963    0.18517
AFIX  23
HD1   2    0.493803    0.937900    0.278166    11.00000   -1.20000
HD2   2    0.508326    0.920137    0.281729    11.00000   -1.20000
AFIX   0
 
RESI  154   GLY
N     3    0.397930    0.847864    0.270028    11.00000    0.24858    0.30170 =
         0.13463    0.02560    0.03163    0.18816
AFIX  43
H0    2    0.400595    0.834344    0.272374    11.00000   -1.20000
AFIX   0
CA    1    0.371121    0.840164    0.264187    11.00000    0.24640    0.29837 =
         0.13287    0.02191    0.02686    0.17615
AFIX  23
HA1   2    0.364270    0.852024    0.267633    11.00000   -1.20000
HA2   2    0.357676    0.820823    0.266437    11.00000   -1.20000
AFIX   0
C     1    0.371741    0.842670    0.250061    11.00000    0.22919    0.29756 =
         0.12711   -0.03367    0.02053    0.19017
O     4    0.349591    0.837091    0.244937    11.00000    0.25434    0.47355 =
         0.15803    0.05263    0.02169    0.24241
 
RESI  155   GLN
N     3    0.395575    0.850412    0.243889    11.00000    0.23868    0.23659 =
         0.12941    0.00674    0.02980    0.18322
AFIX  43
H0    2    0.409721    0.851288    0.247806    11.00000   -1.20000
AFIX   0
CA    1    0.398242    0.857440    0.230644    11.00000    0.25978    0.23278 =
         0.13027    0.02006    0.02848    0.17559
AFIX  13
HA    2    0.380077    0.854598    0.227648    11.00000   -1.20000
AFIX   0
C     1    0.406991    0.840354    0.222317    11.00000    0.24179    0.23725 =
         0.12242    0.04292    0.05639    0.17218
O     4    0.406628    0.843140    0.210879    11.00000    0.32077    0.24230 =
         0.12623    0.04333    0.04668    0.20273
CB    1    0.420908    0.888562    0.228389    11.00000    0.19290    0.24625 =
         0.10488   -0.01227   -0.00140    0.13616
AFIX  23
HB1   2    0.438892    0.891364    0.231341    11.00000   -1.20000
HB2   2    0.422594    0.892053    0.219438    11.00000   -1.20000
AFIX   0
CG    1    0.415410    0.910276    0.234644    11.00000    0.31437    0.23542 =
         0.10511   -0.00834    0.00740    0.16295
AFIX  23
HG1   2    0.414353    0.907802    0.243661    11.00000   -1.20000
HG2   2    0.397757    0.908342    0.231706    11.00000   -1.20000
AFIX   0
CD    1    0.439960    0.939114    0.231146    11.00000    0.39901    0.23091 =
         0.17579   -0.02593   -0.03973    0.10444
OE1   4    0.439777    0.951751    0.221724    11.00000    0.36483    0.26068 =
         0.15470    0.01626    0.08106    0.14364
NE2   3    0.462492    0.948823    0.238219    11.00000    0.32467    0.33465 =
         0.23629   -0.04671   -0.00113    0.13428
AFIX  93
HE2A  2    0.477473    0.964315    0.236266    11.00000   -1.20000
HE2B  2    0.462292    0.939700    0.244811    11.00000   -1.20000
AFIX   0
 
RESI  156   ILE
N     3    0.415048    0.823929    0.227598    11.00000    0.23913    0.19788 =
         0.09224   -0.00565    0.00424    0.14536
AFIX  43
H0    2    0.415735    0.823693    0.235640    11.00000   -1.20000
AFIX   0
CA    1    0.422796    0.806297    0.220698    11.00000    0.20024    0.16399 =
         0.10754    0.00997    0.02438    0.10959
AFIX  13
HA    2    0.428357    0.814202    0.212258    11.00000   -1.20000
AFIX   0
C     1    0.397903    0.776495    0.219436    11.00000    0.22708    0.17041 =
         0.11767    0.00877    0.02038    0.09307
O     4    0.385184    0.762375    0.228526    11.00000    0.27754    0.17286 =
         0.13170    0.02968    0.04854    0.10945
CB    1    0.448109    0.805923    0.226691    11.00000    0.22696    0.19488 =
         0.12446   -0.00773    0.00316    0.13630
AFIX  13
HB    2    0.442109    0.797531    0.235027    11.00000   -1.20000
AFIX   0
CG1   1    0.473160    0.836162    0.228603    11.00000    0.23326    0.22029 =
         0.07895   -0.01259   -0.02020    0.12034
AFIX  23
HG1A  2    0.467755    0.845619    0.234759    11.00000   -1.20000
HG1B  2    0.488890    0.834885    0.232039    11.00000   -1.20000
AFIX   0
CG2   1    0.456827    0.787742    0.219562    11.00000    0.24433    0.22675 =
         0.12024    0.00075    0.01640    0.16026
AFIX  33
HG2A  2    0.472474    0.787950    0.223726    11.00000   -1.50000
HG2B  2    0.462273    0.794951    0.211214    11.00000   -1.50000
HG2C  2    0.441285    0.768747    0.219207    11.00000   -1.50000
AFIX   0
CD1   1    0.483139    0.854290    0.216848    11.00000    0.30549    0.22126 =
         0.13409    0.02101    0.02071    0.12580
AFIX  33
HD1A  2    0.498903    0.872451    0.218871    11.00000   -1.50000
HD1B  2    0.468062    0.856568    0.213576    11.00000   -1.50000
HD1C  2    0.488745    0.845284    0.210685    11.00000   -1.50000
AFIX   0
 
RESI  157   THR
N     3    0.392289    0.767770    0.207420    11.00000    0.20941    0.16688 =
         0.11330    0.02641   -0.00533    0.10516
AFIX  43
H0    2    0.401297    0.779257    0.201415    11.00000   -1.20000
AFIX   0
CA    1    0.370718    0.738561    0.204693    11.00000    0.15648    0.18416 =
         0.07861    0.01891    0.04738    0.08551
AFIX  13
HA    2    0.360014    0.730085    0.212379    11.00000   -1.20000
AFIX   0
C     1    0.383937    0.721399    0.200453    11.00000    0.16364    0.16699 =
         0.10951    0.03253    0.04725    0.08591
O     4    0.409424    0.732043    0.198497    11.00000    0.16448    0.15746 =
         0.15311    0.03649    0.04082    0.09503
CB    1    0.350288    0.738211    0.194729    11.00000    0.15007    0.23823 =
         0.10970   -0.00070    0.03644    0.11148
AFIX  13
HB    2    0.334553    0.718940    0.193600    11.00000   -1.20000
AFIX   0
OG1   4    0.364797    0.748689    0.183204    11.00000    0.15608    0.27940 =
         0.11312    0.04550    0.03885    0.13273
AFIX  83
HG1   2    0.371228    0.738759    0.180878    11.00000   -1.50000
AFIX   0
CG2   1    0.339067    0.757822    0.198212    11.00000    0.20519    0.25360 =
         0.15615   -0.01735    0.01277    0.14695
AFIX  33
HG2A  2    0.325948    0.756641    0.191943    11.00000   -1.50000
HG2B  2    0.354476    0.776866    0.198712    11.00000   -1.50000
HG2C  2    0.329715    0.752300    0.206175    11.00000   -1.50000
AFIX   0
 
RESI  158   SER
N     3    0.367070    0.693969    0.198659    11.00000    0.16731    0.17790 =
         0.11933    0.00725    0.00600    0.08604
AFIX  43
H0    2    0.349410    0.686842    0.200284    11.00000   -1.20000
AFIX   0
CA    1    0.376808    0.675276    0.194092    11.00000    0.20134    0.16328 =
         0.12527    0.05784    0.03885    0.10509
AFIX  13
HA    2    0.391414    0.676266    0.199724    11.00000   -1.20000
AFIX   0
C     1    0.388220    0.681667    0.180768    11.00000    0.13166    0.15727 =
         0.11304    0.04028    0.01625    0.06910
O     4    0.400901    0.671562    0.175536    11.00000    0.17028    0.13197 =
         0.16942    0.01382    0.03520    0.06829
CB    1    0.352000    0.645120    0.193832    11.00000    0.27614    0.14797 =
         0.23645    0.10016    0.11844    0.10033
AFIX  23
HB1   2    0.359020    0.632423    0.191886    11.00000   -1.20000
HB2   2    0.343614    0.640298    0.202112    11.00000   -1.20000
AFIX   0
OG    4    0.330940    0.640795    0.185096    11.00000    0.30822    0.17828 =
         0.34670    0.03872   -0.01718   -0.02148
AFIX  83
HG    2    0.337964    0.645406    0.178102    11.00000   -1.50000
AFIX   0
 
RESI  159   ASN
N     3    0.382967    0.698799    0.174148    11.00000    0.13606    0.16268 =
         0.10682    0.03816    0.00504    0.06820
AFIX  43
H0    2    0.372229    0.704064    0.177674    11.00000   -1.20000
AFIX   0
CA    1    0.392885    0.710020    0.161670    11.00000    0.13424    0.11634 =
         0.11258    0.02548    0.02682    0.06176
AFIX  13
HA    2    0.396030    0.696282    0.157121    11.00000   -1.20000
AFIX   0
C     1    0.420246    0.738331    0.161158    11.00000    0.14652    0.09714 =
         0.10498   -0.00339    0.03615    0.07330
O     4    0.429115    0.751155    0.151155    11.00000    0.11272    0.10151 =
         0.12249    0.01445    0.02104    0.04957
CB    1    0.370333    0.713244    0.154526    11.00000    0.16771    0.13296 =
         0.07854    0.01536    0.00569    0.07362
AFIX  23
HB1   2    0.367223    0.727241    0.158656    11.00000   -1.20000
HB2   2    0.376891    0.719776    0.146084    11.00000   -1.20000
AFIX   0
CG    1    0.342804    0.685350    0.153986    11.00000    0.15498    0.15958 =
         0.13857   -0.05014   -0.00779    0.07502
OD1   4    0.342652    0.664104    0.150618    11.00000    0.16154    0.13747 =
         0.15965    0.00215    0.03993    0.06968
ND2   3    0.319230    0.686017    0.157077    11.00000    0.15747    0.15278 =
         0.22135   -0.01261    0.01141    0.08009
AFIX  93
HD2A  2    0.303047    0.670858    0.156709    11.00000   -1.20000
HD2B  2    0.320394    0.701601    0.159414    11.00000   -1.20000
AFIX   0
 
RESI  160   MET
N     3    0.434806    0.747541    0.171689    11.00000    0.13570    0.12331 =
         0.12480    0.01868    0.01637    0.06816
AFIX  43
H0    2    0.427752    0.737439    0.178300    11.00000   -1.20000
AFIX   0
CA    1    0.461688    0.773307    0.172943    11.00000    0.14518    0.11026 =
         0.12790    0.01554    0.00929    0.07539
AFIX  13
HA    2    0.469151    0.780473    0.164568    11.00000   -1.20000
AFIX   0
C     1    0.482763    0.768008    0.179972    11.00000    0.13889    0.11158 =
         0.14233    0.01934    0.01006    0.06891
O     4    0.473908    0.748842    0.187734    11.00000    0.13651    0.15509 =
         0.17501    0.05426    0.01099    0.08858
CB    1    0.458205    0.795751    0.180013    11.00000    0.15525    0.13352 =
         0.09128    0.01282    0.02602    0.08435
AFIX  23
HB1   2    0.452393    0.789345    0.188536    11.00000   -1.20000
HB2   2    0.476358    0.812975    0.180393    11.00000   -1.20000
AFIX   0
CG    1    0.436817    0.802344    0.174106    11.00000    0.16226    0.14322 =
         0.10857    0.00501    0.02047    0.09659
AFIX  23
HG1   2    0.419646    0.784897    0.172162    11.00000   -1.20000
HG2   2    0.444374    0.812660    0.166358    11.00000   -1.20000
AFIX   0
SD    5    0.428926    0.823255    0.184807    11.00000    0.15294    0.14998 =
         0.11459   -0.00110    0.00403    0.09208
CE    1    0.399256    0.821734    0.177250    11.00000    0.15596    0.17482 =
         0.09724    0.00113    0.01377    0.10530
AFIX  33
HE1   2    0.392888    0.832400    0.181986    11.00000   -1.50000
HE2   2    0.384354    0.802454    0.176702    11.00000   -1.50000
HE3   2    0.404503    0.829526    0.168981    11.00000   -1.50000
AFIX   0
 
RESI  161   PHE
N     3    0.509736    0.785595    0.177301    11.00000    0.13287    0.12830 =
         0.12223   -0.00488    0.00532    0.06718
AFIX  43
H0    2    0.514215    0.796479    0.170876    11.00000   -1.20000
AFIX   0
CA    1    0.531834    0.786380    0.185344    11.00000    0.15148    0.15165 =
         0.09805   -0.01736   -0.00488    0.07913
AFIX  13
HA    2    0.523967    0.780132    0.193748    11.00000   -1.20000
AFIX   0
C     1    0.555985    0.816922    0.186221    11.00000    0.12804    0.15602 =
         0.12864    0.00228   -0.00464    0.07453
O     4    0.557991    0.834776    0.178470    11.00000    0.13694    0.17008 =
         0.14767    0.01314    0.00267    0.09467
CB    1    0.542909    0.767679    0.180792    11.00000    0.14089    0.14898 =
         0.16095    0.03003    0.03004    0.08049
AFIX  23
HB1   2    0.555296    0.767328    0.187197    11.00000   -1.20000
HB2   2    0.527052    0.748645    0.180038    11.00000   -1.20000
AFIX   0
CG    1    0.558669    0.775355    0.168573    11.00000    0.12263    0.09307 =
         0.14743    0.02865    0.01849    0.07117
CD1   1    0.544302    0.766912    0.157392    11.00000    0.13415    0.12308 =
         0.15765    0.00608    0.00938    0.06864
AFIX  43
HD1   2    0.524691    0.756628    0.157450    11.00000   -1.20000
AFIX   0
CD2   1    0.588355    0.791033    0.168103    11.00000    0.11993    0.14793 =
         0.15979    0.01886    0.01932    0.09038
AFIX  43
HD2   2    0.598620    0.796935    0.175514    11.00000   -1.20000
AFIX   0
CE1   1    0.558598    0.773487    0.145958    11.00000    0.12498    0.12399 =
         0.14960    0.02058    0.00377    0.06065
AFIX  43
HE1   2    0.548550    0.767348    0.138499    11.00000   -1.20000
AFIX   0
CE2   1    0.602319    0.797707    0.156842    11.00000    0.10490    0.15416 =
         0.16738   -0.00244    0.01520    0.07811
AFIX  43
HE2   2    0.621921    0.808165    0.156717    11.00000   -1.20000
AFIX   0
CZ    1    0.587709    0.789138    0.145764    11.00000    0.12370    0.17813 =
         0.16256    0.03196    0.00480    0.10456
AFIX  43
HZ    2    0.597345    0.793837    0.138178    11.00000   -1.20000
AFIX   0
 
RESI  162   CYS
N     3    0.574280    0.822194    0.195379    11.00000    0.11759    0.16893 =
         0.15397   -0.00041   -0.01001    0.07940
AFIX  43
H0    2    0.571815    0.809040    0.200509    11.00000   -1.20000
AFIX   0
CA    1    0.598431    0.850209    0.196701    11.00000    0.11125    0.16134 =
         0.11930    0.02784   -0.01381    0.08045
AFIX  13
HA    2    0.596388    0.862968    0.190913    11.00000   -1.20000
AFIX   0
C     1    0.625097    0.849180    0.193251    11.00000    0.12434    0.14335 =
         0.14699    0.03259    0.01525    0.07801
O     4    0.627109    0.827997    0.195362    11.00000    0.15420    0.15150 =
         0.15663    0.01232    0.00044    0.09831
CB    1    0.601630    0.861563    0.209858    11.00000    0.16633    0.15179 =
         0.13960    0.00660   -0.00355    0.09706
AFIX  23
HB1   2    0.620092    0.878344    0.210470    11.00000   -1.20000
HB2   2    0.601565    0.847682    0.215526    11.00000   -1.20000
AFIX   0
SG    5    0.576038    0.870477    0.215520    11.00000    0.18057    0.18161 =
         0.16306    0.00175    0.00916    0.10815
 
RESI  163   ALA
N     3    0.645966    0.872437    0.188381    11.00000    0.13217    0.15678 =
         0.15502    0.03715    0.02767    0.08037
AFIX  43
H0    2    0.643277    0.886292    0.186728    11.00000   -1.20000
AFIX   0
CA    1    0.673654    0.875404    0.185695    11.00000    0.13145    0.12911 =
         0.14881    0.02899    0.02724    0.06658
AFIX  13
HA    2    0.676991    0.863403    0.191434    11.00000   -1.20000
AFIX   0
C     1    0.695879    0.906340    0.187953    11.00000    0.14008    0.13029 =
         0.16995    0.00491   -0.00048    0.06795
O     4    0.689665    0.924839    0.186588    11.00000    0.13302    0.12725 =
         0.20036    0.00798   -0.00655    0.06086
CB    1    0.676010    0.867775    0.172507    11.00000    0.15642    0.13695 =
         0.16119    0.00019    0.00641    0.08969
AFIX  33
HB1   2    0.661765    0.848561    0.170951    11.00000   -1.50000
HB2   2    0.694317    0.869866    0.171214    11.00000   -1.50000
HB3   2    0.673463    0.879992    0.166874    11.00000   -1.50000
AFIX   0
 
RESI  164   GLY
N     3    0.720754    0.910195    0.191381    11.00000    0.14913    0.14406 =
         0.22198    0.01315   -0.01451    0.07399
AFIX  43
H0    2    0.723439    0.896098    0.192283    11.00000   -1.20000
AFIX   0
CA    1    0.743474    0.938861    0.193589    11.00000    0.14455    0.14033 =
         0.23362    0.02133   -0.02533    0.07518
AFIX  23
HA1   2    0.735926    0.951557    0.193701    11.00000   -1.20000
HA2   2    0.757114    0.944622    0.186840    11.00000   -1.20000
AFIX   0
C     1    0.757892    0.940774    0.205917    11.00000    0.12691    0.19178 =
         0.23337    0.02160   -0.02115    0.08303
O     4    0.762364    0.921881    0.209542    11.00000    0.13275    0.19992 =
         0.24173    0.03216   -0.02612    0.08777
 
RESI  165   TYR
N     3    0.766252    0.964643    0.212251    11.00000    0.16427    0.19597 =
         0.21657    0.02272   -0.02591    0.08601
AFIX  43
H0    2    0.760844    0.975932    0.209485    11.00000   -1.20000
AFIX   0
CA    1    0.783647    0.973189    0.223383    11.00000    0.17001    0.24692 =
         0.22477    0.01431   -0.03840    0.08934
AFIX  13
HA    2    0.783780    0.956717    0.226898    11.00000   -1.20000
AFIX   0
C     1    0.772838    0.985374    0.233220    11.00000    0.22296    0.26479 =
         0.19506    0.03035   -0.05919    0.15213
O     4    0.769970    1.006016    0.231501    11.00000    0.37889    0.23626 =
         0.20729   -0.00676   -0.12276    0.17766
CB    1    0.814132    0.995568    0.219735    11.00000    0.16295    0.25217 =
         0.30123    0.02527   -0.03858    0.08209
AFIX  23
HB1   2    0.814302    1.012181    0.216458    11.00000   -1.20000
HB2   2    0.826063    1.001110    0.227112    11.00000   -1.20000
AFIX   0
CG    1    0.825727    0.983897    0.209910    11.00000    0.18151    0.25779 =
         0.30302    0.07052    0.00592    0.09233
CD1   1    0.822619    0.987152    0.197158    11.00000    0.13767    0.20975 =
         0.30098    0.08063    0.01956    0.05004
AFIX  43
HD1   2    0.813364    0.996638    0.194584    11.00000   -1.20000
AFIX   0
CD2   1    0.839336    0.969634    0.213628    11.00000    0.19898    0.23597 =
         0.30014    0.06128    0.00115    0.09283
AFIX  43
HD2   2    0.841507    0.967275    0.222101    11.00000   -1.20000
AFIX   0
CE1   1    0.833143    0.976432    0.188327    11.00000    0.15847    0.24341 =
         0.31846    0.07084    0.03044    0.06562
AFIX  43
HE1   2    0.831063    0.978749    0.179840    11.00000   -1.20000
AFIX   0
CE2   1    0.849778    0.958816    0.204693    11.00000    0.15505    0.29587 =
         0.31587    0.04778    0.00944    0.09013
AFIX  43
HE2   2    0.858894    0.949151    0.207207    11.00000   -1.20000
AFIX   0
CZ    1    0.846728    0.962301    0.192139    11.00000    0.14593    0.25780 =
         0.31544    0.06872    0.03561    0.07075
OH    4    0.857050    0.951347    0.183357    11.00000    0.15209    0.28791 =
         0.32071    0.06588    0.04113    0.08220
AFIX  83
HH    2    0.853356    0.954537    0.176314    11.00000   -1.50000
AFIX   0
 
RESI  166   LEU
N     3    0.766077    0.972461    0.244414    11.00000    0.30020    0.22744 =
         0.19951    0.01798   -0.04773    0.15397
AFIX  43
H0    2    0.767831    0.958003    0.245985    11.00000   -1.20000
AFIX   0
CA    1    0.755509    0.984502    0.253810    11.00000    0.22549    0.26348 =
         0.21322   -0.00554   -0.04616    0.12195
AFIX  13
HA    2    0.740009    0.986046    0.250044    11.00000   -1.20000
AFIX   0
C     1    0.777304    1.013493    0.258649    11.00000    0.23581    0.24688 =
         0.19072    0.00540   -0.01847    0.11738
O     4    0.769468    1.028658    0.263754    11.00000    0.27619    0.24038 =
         0.21760    0.03730    0.01230    0.13891
CB    1    0.743471    0.963554    0.264810    11.00000    0.21657    0.23238 =
         0.21552   -0.01303   -0.06285    0.10991
AFIX  23
HB1   2    0.758115    0.960018    0.267856    11.00000   -1.20000
HB2   2    0.738822    0.972403    0.271552    11.00000   -1.20000
AFIX   0
CG    1    0.717176    0.935058    0.261799    11.00000    0.19067    0.25706 =
         0.19851   -0.03465   -0.06271    0.10673
AFIX  13
HG    2    0.722349    0.926049    0.255195    11.00000   -1.20000
AFIX   0
CD1   1    0.707925    0.915664    0.273159    11.00000    0.25750    0.23295 =
         0.29795    0.01504   -0.03331    0.12782
AFIX  33
HD1A  2    0.723389    0.913567    0.276043    11.00000   -1.50000
HD1B  2    0.692432    0.897529    0.270885    11.00000   -1.50000
HD1C  2    0.702120    0.923665    0.279712    11.00000   -1.50000
AFIX   0
CD2   1    0.692912    0.938629    0.256820    11.00000    0.22330    0.24907 =
         0.36346   -0.00955   -0.09945    0.11769
AFIX  33
HD2A  2    0.699372    0.951294    0.249805    11.00000   -1.50000
HD2B  2    0.686480    0.946204    0.263306    11.00000   -1.50000
HD2C  2    0.677669    0.920627    0.254226    11.00000   -1.50000
AFIX   0
 
RESI  167   GLU
N     3    0.804543    1.022002    0.257162    11.00000    0.23254    0.26898 =
         0.15709   -0.02064   -0.03882    0.11834
AFIX  43
H0    2    0.809361    1.010977    0.253575    11.00000   -1.20000
AFIX   0
CA    1    0.826420    1.049721    0.261509    11.00000    0.29400    0.28813 =
         0.23641    0.02771   -0.12394    0.06634
AFIX  13
HA    2    0.821513    1.052650    0.269987    11.00000   -1.20000
AFIX   0
C     1    0.828547    1.073364    0.253115    11.00000    0.31010    0.28311 =
         0.21565    0.02981   -0.02154    0.11325
O     4    0.842363    1.097967    0.256880    11.00000    0.29629    0.28014 =
         0.31869    0.01722   -0.02471    0.08937
CB    1    0.854847    1.050828    0.262075    11.00000    0.29181    0.51580 =
         0.47481    0.12921   -0.22087    0.11126
AFIX  23
HB1   2    0.869336    1.069923    0.264136    11.00000   -1.20000
HB2   2    0.859117    1.046499    0.253833    11.00000   -1.20000
AFIX   0
CG    1    0.856223    1.030638    0.271556    11.00000    0.44797    0.65482 =
         0.47720    0.16568   -0.23011    0.22326
AFIX  23
HG1   2    0.837788    1.013771    0.271973    11.00000   -1.20000
HG2   2    0.869395    1.025075    0.268466    11.00000   -1.20000
AFIX   0
CD    1    0.864967    1.042097    0.284697    11.00000    0.68168    0.85883 =
         0.47900    0.16500   -0.30857    0.14244
OE1   4    0.852630    1.053712    0.289757    11.00000    0.80285    1.06367 =
         0.52223   -0.15026   -0.28484    0.15153
OE2   4    0.883902    1.039487    0.290228    11.00000    0.70289    1.14306 =
         0.81589    0.13780   -0.58704    0.10247
 
RESI  168   GLY
N     3    0.814934    1.065220    0.242274    11.00000    0.35887    0.29852 =
         0.21010    0.04193   -0.03739    0.17122
AFIX  43
H0    2    0.804640    1.047455    0.240809    11.00000   -1.20000
AFIX   0
CA    1    0.816683    1.084989    0.232807    11.00000    0.30532    0.31561 =
         0.25893    0.07275    0.01229    0.19173
AFIX  23
HA1   2    0.817491    1.101092    0.237006    11.00000   -1.20000
HA2   2    0.799411    1.076014    0.227939    11.00000   -1.20000
AFIX   0
C     1    0.841286    1.095730    0.223865    11.00000    0.27937    0.30041 =
         0.26749    0.04770    0.00577    0.14245
O     4    0.858642    1.087777    0.224582    11.00000    0.32872    0.39834 =
         0.23458    0.06415    0.03368    0.21451
 
RESI  169   GLY
N     3    0.842875    1.113840    0.215264    11.00000    0.20285    0.22186 =
         0.21525   -0.01327   -0.05660    0.05779
AFIX  43
H0    2    0.829219    1.117295    0.214687    11.00000   -1.20000
AFIX   0
CA    1    0.866438    1.128096    0.206794    11.00000    0.20859    0.17801 =
         0.23610   -0.02382   -0.04445    0.05673
AFIX  23
HA1   2    0.882897    1.129082    0.210712    11.00000   -1.20000
HA2   2    0.870301    1.147296    0.205688    11.00000   -1.20000
AFIX   0
C     1    0.862782    1.114922    0.194058    11.00000    0.20058    0.22062 =
         0.21012   -0.01712   -0.05628    0.03859
O     4    0.878466    1.129186    0.185268    11.00000    0.23365    0.24363 =
         0.22158    0.02161   -0.04497    0.06330
 
RESI  170   LYS
N     3    0.842785    1.088029    0.192839    11.00000    0.16968    0.21182 =
         0.18041   -0.02534   -0.04768    0.07089
AFIX  43
H0    2    0.832417    1.079474    0.199218    11.00000   -1.20000
AFIX   0
CA    1    0.837702    1.072441    0.181144    11.00000    0.18899    0.23004 =
         0.17578   -0.02283   -0.05604    0.08463
AFIX  13
HA    2    0.846289    1.085820    0.174215    11.00000   -1.20000
AFIX   0
C     1    0.806328    1.054145    0.178774    11.00000    0.19589    0.17172 =
         0.14982   -0.01332   -0.04858    0.06993
O     4    0.791609    1.035723    0.186592    11.00000    0.21242    0.16931 =
         0.17890    0.00481   -0.04947    0.08337
CB    1    0.851625    1.054092    0.182107    11.00000    0.17660    0.19725 =
         0.24097   -0.00978   -0.00189    0.06394
AFIX  23
HB1   2    0.844197    1.042126    0.189439    11.00000   -1.20000
HB2   2    0.846246    1.041879    0.174828    11.00000   -1.20000
AFIX   0
CG    1    0.883714    1.070445    0.182987    11.00000    0.18469    0.29007 =
         0.27623    0.04119   -0.04849    0.09436
AFIX  23
HG1   2    0.891468    1.081745    0.175491    11.00000   -1.20000
HG2   2    0.889403    1.083126    0.190108    11.00000   -1.20000
AFIX   0
CD    1    0.895477    1.050633    0.184429    11.00000    0.21937    0.30456 =
         0.40115    0.09073   -0.07547    0.11140
AFIX  23
HD1   2    0.882056    1.032122    0.181199    11.00000   -1.20000
HD2   2    0.898664    1.048696    0.193217    11.00000   -1.20000
AFIX   0
CE    1    0.923170    1.062543    0.177238    11.00000    0.23426    0.48411 =
         0.63092    0.01023   -0.01838    0.18955
AFIX  23
HE1   2    0.919017    1.058125    0.168425    11.00000   -1.20000
HE2   2    0.933372    1.082919    0.178072    11.00000   -1.20000
AFIX   0
NZ    3    0.941566    1.051447    0.181580    11.00000    0.49139    0.75681 =
         0.96879   -0.15997   -0.12436    0.48841
AFIX  33
HZ1   2    0.957349    1.059141    0.177068    11.00000   -1.50000
HZ2   2    0.932540    1.032791    0.180654    11.00000   -1.50000
HZ3   2    0.945823    1.055765    0.189620    11.00000   -1.50000
AFIX   0
 
RESI  171   ASP
N     3    0.796273    1.058766    0.168275    11.00000    0.14207    0.18837 =
         0.16118    0.02435   -0.01632    0.05254
AFIX  43
H0    2    0.807683    1.070546    0.162842    11.00000   -1.20000
AFIX   0
CA    1    0.765832    1.043891    0.165900    11.00000    0.14780    0.15852 =
         0.15007    0.00717   -0.01388    0.06007
AFIX  13
HA    2    0.757969    1.023576    0.167132    11.00000   -1.20000
AFIX   0
C     1    0.760346    1.049614    0.152557    11.00000    0.12817    0.14037 =
         0.13589    0.00025   -0.00314    0.05061
O     4    0.779075    1.068539    0.146247    11.00000    0.12997    0.16013 =
         0.18190    0.02989   -0.01926    0.02881
CB    1    0.752327    1.054818    0.174940    11.00000    0.16362    0.17591 =
         0.11972    0.01912   -0.00702    0.06783
AFIX  23
HB1   2    0.761222    1.056901    0.183030    11.00000   -1.20000
HB2   2    0.757099    1.073579    0.172188    11.00000   -1.20000
AFIX   0
CG    1    0.720720    1.038236    0.176955    11.00000    0.16267    0.18741 =
         0.10623   -0.03597   -0.01572    0.05676
OD1   4    0.705901    1.014761    0.171834    11.00000    0.16862    0.14058 =
         0.18360   -0.01626   -0.02415    0.07709
OD2   4    0.710574    1.049570    0.183907    11.00000    0.16070    0.17109 =
         0.17786   -0.04218   -0.02740    0.07293
 
RESI  172   SER
N     3    0.734286    1.033321    0.148571    11.00000    0.12611    0.12502 =
         0.14720   -0.00569   -0.00364    0.05152
AFIX  43
H0    2    0.722967    1.018548    0.152790    11.00000   -1.20000
AFIX   0
CA    1    0.724460    1.040027    0.137132    11.00000    0.11042    0.13581 =
         0.14725   -0.00005   -0.00244    0.04447
AFIX  13
HA    2    0.740554    1.049102    0.131396    11.00000   -1.20000
AFIX   0
C     1    0.715506    1.061789    0.140341    11.00000    0.10547    0.13382 =
         0.14947   -0.02173   -0.02547    0.04257
O     4    0.714521    1.068163    0.151456    11.00000    0.18381    0.17345 =
         0.14397   -0.00134   -0.00445    0.09217
CB    1    0.701761    1.013963    0.130695    11.00000    0.15919    0.12422 =
         0.15203   -0.00538   -0.01819    0.05006
AFIX  23
HB1   2    0.695903    1.019402    0.123122    11.00000   -1.20000
HB2   2    0.709313    1.001932    0.128323    11.00000   -1.20000
AFIX   0
OG    4    0.677863    0.998608    0.138676    11.00000    0.11612    0.13227 =
         0.22628    0.03101   -0.01820    0.04674
AFIX  83
HG    2    0.682770    0.993917    0.145064    11.00000   -1.50000
AFIX   0
 
RESI  173   CYS
N     3    0.709205    1.073496    0.130983    11.00000    0.12277    0.17379 =
         0.12948   -0.03433   -0.01377    0.08193
AFIX  43
H0    2    0.708359    1.067529    0.123456    11.00000   -1.20000
AFIX   0
CA    1    0.703672    1.096604    0.133430    11.00000    0.16299    0.15127 =
         0.13870   -0.01935   -0.01783    0.07689
AFIX  13
HA    2    0.692682    1.092245    0.141181    11.00000   -1.20000
AFIX   0
C     1    0.685644    1.097930    0.122777    11.00000    0.19751    0.17992 =
         0.09720    0.00179    0.00810    0.11235
O     4    0.677646    1.081209    0.113847    11.00000    0.17527    0.17904 =
         0.13590   -0.01802   -0.01660    0.10984
CB    1    0.731298    1.123955    0.135447    11.00000    0.15951    0.15867 =
         0.26305   -0.02455   -0.00499    0.06484
AFIX  23
HB1   2    0.740023    1.131086    0.127354    11.00000   -1.20000
HB2   2    0.743851    1.119830    0.140246    11.00000   -1.20000
AFIX   0
SG    5    0.728128    1.151701    0.143504    11.00000    0.26843    0.16017 =
         0.21699   -0.03448   -0.04600    0.10003
 
RESI  174   GLN
N     3    0.678931    1.117946    0.123391    11.00000    0.18158    0.19543 =
         0.18272   -0.06116   -0.05308    0.11326
AFIX  43
H0    2    0.684659    1.128928    0.129801    11.00000   -1.20000
AFIX   0
CA    1    0.662565    1.122753    0.114018    11.00000    0.21147    0.21918 =
         0.17254   -0.03784   -0.02562    0.14574
AFIX  13
HA    2    0.643062    1.107068    0.114169    11.00000   -1.20000
AFIX   0
C     1    0.675115    1.124476    0.101162    11.00000    0.15678    0.11280 =
         0.18302   -0.02894   -0.01869    0.07830
O     4    0.700600    1.139520    0.099857    11.00000    0.14436    0.15006 =
         0.21486   -0.02394   -0.03866    0.07273
CB    1    0.662865    1.150300    0.116852    11.00000    0.27080    0.25309 =
         0.22467   -0.05342   -0.00870    0.19191
AFIX  23
HB1   2    0.655007    1.148743    0.125150    11.00000   -1.20000
HB2   2    0.682381    1.165354    0.117151    11.00000   -1.20000
AFIX   0
CG    1    0.647353    1.159034    0.107976    11.00000    0.34733    0.40707 =
         0.60946    0.09426   -0.04716    0.28723
AFIX  23
HG1   2    0.632371    1.142253    0.104025    11.00000   -1.20000
HG2   2    0.660287    1.170617    0.101443    11.00000   -1.20000
AFIX   0
CD    1    0.634694    1.175134    0.113886    11.00000    0.55560    0.51081 =
         0.82825    0.17582    0.07702    0.44745
OE1   4    0.638215    1.197108    0.108913    11.00000    0.95592    0.60801 =
         1.22882    0.28573    0.12987    0.64228
NE2   3    0.619390    1.164643    0.124330    11.00000    0.91870    0.67916 =
         0.95110    0.12611    0.32408    0.53903
AFIX  93
HE2A  2    0.611613    1.173219    0.127811    11.00000   -1.20000
HE2B  2    0.617343    1.149331    0.127555    11.00000   -1.20000
AFIX   0
 
RESI  175   GLY
N     3    0.657152    1.109468    0.092259    11.00000    0.13789    0.12077 =
         0.17654   -0.03344   -0.00597    0.06873
AFIX  43
H0    2    0.639402    1.099632    0.093851    11.00000   -1.20000
AFIX   0
CA    1    0.667693    1.109698    0.079641    11.00000    0.18337    0.15313 =
         0.15695    0.00807    0.00377    0.11900
AFIX  23
HA1   2    0.685673    1.126880    0.078556    11.00000   -1.20000
HA2   2    0.654620    1.109978    0.073588    11.00000   -1.20000
AFIX   0
C     1    0.671497    1.084629    0.076917    11.00000    0.11301    0.10364 =
         0.13784    0.01998    0.03483    0.05579
O     4    0.673203    1.078087    0.066244    11.00000    0.13244    0.12547 =
         0.13608    0.01271    0.01538    0.07048
 
RESI  176   ASP
N     3    0.672630    1.070405    0.086532    11.00000    0.10887    0.07889 =
         0.13607    0.00649    0.01440    0.02985
AFIX  43
H0    2    0.672291    1.076627    0.093887    11.00000   -1.20000
AFIX   0
CA    1    0.674431    1.044699    0.085665    11.00000    0.10034    0.07576 =
         0.13667   -0.00348   -0.01446    0.02452
AFIX  13
HA    2    0.684653    1.045546    0.077993    11.00000   -1.20000
AFIX   0
C     1    0.644794    1.018658    0.085009    11.00000    0.09060    0.08553 =
         0.11419   -0.03857   -0.01039    0.03386
O     4    0.642005    0.995793    0.081610    11.00000    0.09601    0.06987 =
         0.14195   -0.01133    0.01142    0.03675
CB    1    0.689837    1.040944    0.096873    11.00000    0.09902    0.10802 =
         0.15134   -0.02588   -0.03309    0.03728
AFIX  23
HB1   2    0.680762    1.041698    0.104549    11.00000   -1.20000
HB2   2    0.688153    1.022466    0.096390    11.00000   -1.20000
AFIX   0
CG    1    0.720910    1.063297    0.097388    11.00000    0.09829    0.13621 =
         0.14751   -0.01301   -0.01888    0.03249
OD1   4    0.734356    1.070955    0.087092    11.00000    0.13920    0.10564 =
         0.15940    0.00381    0.00375    0.04244
OD2   4    0.732447    1.072586    0.107720    11.00000    0.10167    0.10539 =
         0.15731   -0.01093   -0.03554    0.01567
 
RESI  177   SER
N     3    0.623613    1.022485    0.088581    11.00000    0.10852    0.07753 =
         0.12723   -0.02437    0.00398    0.04541
AFIX  43
H0    2    0.627211    1.039227    0.090491    11.00000   -1.20000
AFIX   0
CA    1    0.594280    0.999106    0.089378    11.00000    0.10043    0.10864 =
         0.11618   -0.01369   -0.00267    0.04687
AFIX  13
HA    2    0.592922    0.986827    0.096343    11.00000   -1.20000
AFIX   0
C     1    0.585822    0.981727    0.077354    11.00000    0.06074    0.08875 =
         0.10164    0.01049    0.00466    0.03155
O     4    0.592590    0.992843    0.067175    11.00000    0.09094    0.08957 =
         0.10645    0.01806    0.01320    0.03439
CB    1    0.574746    1.010714    0.092061    11.00000    0.10664    0.12847 =
         0.17164   -0.04107   -0.00842    0.05465
AFIX  23
HB1   2    0.578168    1.025546    0.086147    11.00000   -1.20000
HB2   2    0.555214    0.995873    0.091302    11.00000   -1.20000
AFIX   0
OG    4    0.580415    1.021702    0.104598    11.00000    0.33785    0.27861 =
         0.16421   -0.05886    0.03884    0.19269
AFIX  83
HG    2    0.570313    1.028383    0.106241    11.00000   -1.50000
AFIX   0
 
RESI  178   GLY
N     3    0.570797    0.953743    0.079376    11.00000    0.10012    0.08241 =
         0.10564    0.00652    0.01640    0.04522
AFIX  43
H0    2    0.567091    0.947576    0.086943    11.00000   -1.20000
AFIX   0
CA    1    0.560795    0.933915    0.069213    11.00000    0.09494    0.11442 =
         0.09255   -0.00741   -0.00560    0.05797
AFIX  23
HA1   2    0.556672    0.942455    0.062168    11.00000   -1.20000
HA2   2    0.543206    0.917536    0.071750    11.00000   -1.20000
AFIX   0
C     1    0.580676    0.924004    0.064820    11.00000    0.08875    0.11841 =
         0.07720   -0.00849    0.00114    0.05280
O     4    0.572278    0.903709    0.057837    11.00000    0.10110    0.10134 =
         0.12258   -0.00913    0.00873    0.04797
 
RESI  179   GLY
N     3    0.607450    0.939218    0.068556    11.00000    0.08075    0.11309 =
         0.10022    0.00340    0.01670    0.04459
AFIX  43
H0    2    0.612165    0.953425    0.073412    11.00000   -1.20000
AFIX   0
CA    1    0.628808    0.932576    0.064697    11.00000    0.09076    0.12252 =
         0.12032   -0.00523   -0.00068    0.05732
AFIX  23
HA1   2    0.647203    0.949312    0.065649    11.00000   -1.20000
HA2   2    0.626202    0.927673    0.055879    11.00000   -1.20000
AFIX   0
C     1    0.628508    0.908534    0.071980    11.00000    0.10983    0.10306 =
         0.16380    0.00266    0.02502    0.05573
O     4    0.612006    0.896784    0.080681    11.00000    0.12013    0.09655 =
         0.13732   -0.00318    0.02047    0.06219
 
RESI  180   PRO
N     3    0.646747    0.901152    0.067559    11.00000    0.09376    0.08587 =
         0.12732   -0.00489    0.01327    0.03764
CA    1    0.646431    0.875806    0.072286    11.00000    0.11129    0.09546 =
         0.14662    0.00647    0.02619    0.05259
AFIX  13
HA    2    0.626924    0.860178    0.072706    11.00000   -1.20000
AFIX   0
C     1    0.661156    0.878017    0.084619    11.00000    0.11926    0.09812 =
         0.15119   -0.00029    0.01587    0.05921
O     4    0.682946    0.899819    0.087605    11.00000    0.11794    0.11159 =
         0.16847   -0.00626    0.01920    0.05155
CB    1    0.662247    0.870107    0.061753    11.00000    0.09941    0.09447 =
         0.15361    0.00271    0.02539    0.04562
AFIX  23
HB1   2    0.671943    0.860680    0.064986    11.00000   -1.20000
HB2   2    0.649387    0.858637    0.055177    11.00000   -1.20000
AFIX   0
CG    1    0.682819    0.899032    0.057042    11.00000    0.11222    0.08957 =
         0.17595   -0.00211    0.03750    0.04643
AFIX  23
HG1   2    0.699075    0.908325    0.062527    11.00000   -1.20000
HG2   2    0.689172    0.898222    0.048653    11.00000   -1.20000
AFIX   0
CD    1    0.666135    0.914057    0.057109    11.00000    0.10854    0.09666 =
         0.15989    0.01426    0.03206    0.04865
AFIX  23
HD1   2    0.678320    0.934150    0.058433    11.00000   -1.20000
HD2   2    0.655966    0.911102    0.049302    11.00000   -1.20000
AFIX   0
 
RESI  181   VAL
N     3    0.649099    0.854073    0.091188    11.00000    0.09710    0.10800 =
         0.17453    0.01137    0.00657    0.06334
AFIX  43
H0    2    0.631901    0.841873    0.089408    11.00000   -1.20000
AFIX   0
CA    1    0.662391    0.847004    0.100944    11.00000    0.07350    0.09986 =
         0.18582    0.01730    0.01230    0.04496
AFIX  13
HA    2    0.682122    0.862023    0.101672    11.00000   -1.20000
AFIX   0
C     1    0.661424    0.819756    0.097101    11.00000    0.08846    0.10358 =
         0.19128    0.02506    0.02402    0.05613
O     4    0.638552    0.797610    0.096994    11.00000    0.10573    0.09102 =
         0.21510    0.03283    0.04173    0.04742
CB    1    0.647603    0.843354    0.113604    11.00000    0.10525    0.12357 =
         0.18269    0.02185    0.02267    0.07214
AFIX  13
HB    2    0.628881    0.826485    0.113018    11.00000   -1.20000
AFIX   0
CG1   1    0.663605    0.838341    0.124060    11.00000    0.16231    0.13465 =
         0.18180   -0.01852   -0.03217    0.07648
AFIX  33
HG1A  2    0.653892    0.835842    0.131856    11.00000   -1.50000
HG1B  2    0.682316    0.854300    0.124673    11.00000   -1.50000
HG1C  2    0.664670    0.821727    0.122229    11.00000   -1.50000
AFIX   0
CG2   1    0.643416    0.868069    0.116629    11.00000    0.14437    0.14261 =
         0.23727   -0.04007   -0.01240    0.08873
AFIX  33
HG2A  2    0.633624    0.870975    0.109852    11.00000   -1.50000
HG2B  2    0.661451    0.884741    0.117785    11.00000   -1.50000
HG2C  2    0.632522    0.864147    0.124167    11.00000   -1.50000
AFIX   0
 
RESI  182   VAL
N     3    0.686033    0.822793    0.093919    11.00000    0.10023    0.10986 =
         0.17646    0.01574    0.03614    0.05578
AFIX  43
H0    2    0.700927    0.839068    0.094740    11.00000   -1.20000
AFIX   0
CA    1    0.688830    0.799281    0.089016    11.00000    0.14457    0.14078 =
         0.21716    0.02883    0.04665    0.10058
AFIX  13
HA    2    0.669739    0.783276    0.087815    11.00000   -1.20000
AFIX   0
C     1    0.703439    0.790434    0.098683    11.00000    0.10375    0.13940 =
         0.23292    0.03392    0.04118    0.07400
O     4    0.726057    0.807482    0.103413    11.00000    0.12172    0.15673 =
         0.32115   -0.00003    0.00498    0.07920
CB    1    0.703612    0.806178    0.076230    11.00000    0.11623    0.15465 =
         0.20898   -0.00010    0.02826    0.09415
AFIX  13
HB    2    0.721231    0.824290    0.076795    11.00000   -1.20000
AFIX   0
CG1   1    0.710325    0.783611    0.072348    11.00000    0.16394    0.12900 =
         0.22402    0.03434    0.06146    0.09776
AFIX  33
HG1A  2    0.722215    0.782104    0.078543    11.00000   -1.50000
HG1B  2    0.719894    0.788539    0.064425    11.00000   -1.50000
HG1C  2    0.693127    0.765861    0.071612    11.00000   -1.50000
AFIX   0
CG2   1    0.684423    0.808515    0.066308    11.00000    0.14750    0.14806 =
         0.20094   -0.03909   -0.00595    0.09797
AFIX  33
HG2A  2    0.679969    0.822679    0.068824    11.00000   -1.50000
HG2B  2    0.667331    0.790685    0.065529    11.00000   -1.50000
HG2C  2    0.694019    0.813637    0.058393    11.00000   -1.50000
AFIX   0
 
RESI  183   CYS
N     3    0.689907    0.763223    0.101668    11.00000    0.11561    0.13841 =
         0.26552    0.04080    0.03832    0.08698
AFIX  43
H0    2    0.674242    0.751940    0.098010    11.00000   -1.20000
AFIX   0
CA    1    0.701282    0.752174    0.111092    11.00000    0.17140    0.16093 =
         0.27993    0.03373    0.02063    0.12088
AFIX  13
HA    2    0.720963    0.766460    0.112736    11.00000   -1.20000
AFIX   0
C     1    0.700568    0.725857    0.105686    11.00000    0.15048    0.18045 =
         0.30582    0.01041   -0.01490    0.13112
O     4    0.677904    0.706816    0.101334    11.00000    0.14061    0.16352 =
         0.26749    0.03289    0.02710    0.09553
CB    1    0.684894    0.745099    0.123448    11.00000    0.17850    0.27201 =
         0.24539    0.02429   -0.00605    0.16043
AFIX  23
HB1   2    0.697362    0.746437    0.130199    11.00000   -1.20000
HB2   2    0.669565    0.725715    0.123097    11.00000   -1.20000
AFIX   0
SG    5    0.670458    0.767608    0.127077    11.00000    0.15908    0.22687 =
         0.24626    0.02054    0.02531    0.11526
 
RESI  184   SER
N     3    0.723740    0.724242    0.105628    11.00000    0.14648    0.21762 =
         0.39825   -0.00323    0.01555    0.13801
AFIX  43
H0    2    0.739087    0.737949    0.108608    11.00000   -1.20000
AFIX   0
CA    1    0.723734    0.699174    0.100508    11.00000    0.15644    0.22152 =
         0.38790    0.01366    0.02270    0.14873
AFIX  13
HA    2    0.743285    0.703182    0.100109    11.00000   -1.20000
AFIX   0
C     1    0.711008    0.691048    0.087478    11.00000    0.18169    0.15426 =
         0.41745    0.00502   -0.01552    0.12398
O     4    0.694698    0.666226    0.085039    11.00000    0.14265    0.15325 =
         0.45005    0.01092    0.03752    0.09878
CB    1    0.707498    0.674851    0.109841    11.00000    0.28389    0.25150 =
         0.45634    0.07676    0.00827    0.17199
AFIX  23
HB1   2    0.688437    0.671464    0.110842    11.00000   -1.20000
HB2   2    0.706387    0.657739    0.106639    11.00000   -1.20000
AFIX   0
OG    4    0.721376    0.681790    0.121520    11.00000    0.30340    0.27233 =
         0.45601    0.09397    0.00815    0.19636
AFIX  83
HG    2    0.737755    0.685520    0.120580    11.00000   -1.50000
AFIX   0
 
RESI  185   GLY
N     3    0.717953    0.711836    0.079334    11.00000    0.13694    0.16138 =
         0.34775    0.00056    0.06209    0.10243
AFIX  43
H0    2    0.728913    0.728918    0.081748    11.00000   -1.20000
AFIX   0
CA    1    0.707775    0.706860    0.066526    11.00000    0.14324    0.20577 =
         0.32866    0.00405    0.09070    0.08891
AFIX  23
HA1   2    0.710118    0.691705    0.063150    11.00000   -1.20000
HA2   2    0.719815    0.723674    0.061695    11.00000   -1.20000
AFIX   0
C     1    0.677659    0.699442    0.064394    11.00000    0.14315    0.09583 =
         0.25398    0.04972    0.09197    0.06558
O     4    0.667095    0.691981    0.053933    11.00000    0.20208    0.17269 =
         0.26915    0.00066    0.06821    0.10932
 
RESI  186   LYS
N     3    0.663037    0.700774    0.073915    11.00000    0.13395    0.10878 =
         0.27274    0.00385    0.07366    0.06419
AFIX  43
H0    2    0.671001    0.706061    0.081120    11.00000   -1.20000
AFIX   0
CA    1    0.633851    0.693530    0.072509    11.00000    0.13532    0.10822 =
         0.26683    0.01502    0.06864    0.06815
AFIX  13
HA    2    0.628115    0.688618    0.063755    11.00000   -1.20000
AFIX   0
C     1    0.629021    0.717426    0.076469    11.00000    0.14590    0.11355 =
         0.23588    0.01031    0.03471    0.07863
O     4    0.641200    0.732592    0.085542    11.00000    0.12376    0.11294 =
         0.22145    0.01734    0.03508    0.07279
CB    1    0.614744    0.668128    0.080992    11.00000    0.12068    0.12085 =
         0.30922    0.04748    0.04640    0.06873
AFIX  23
HB1   2    0.617502    0.674504    0.089621    11.00000   -1.20000
HB2   2    0.595207    0.661568    0.078847    11.00000   -1.20000
AFIX   0
CG    1    0.619990    0.643559    0.080039    11.00000    0.17106    0.15113 =
         0.31159    0.05567    0.04922    0.11132
AFIX  23
HG1   2    0.608998    0.629749    0.086406    11.00000   -1.20000
HG2   2    0.639762    0.650211    0.081692    11.00000   -1.20000
AFIX   0
CD    1    0.612335    0.629418    0.067277    11.00000    0.22787    0.22323 =
         0.33540    0.01115    0.02274    0.18002
AFIX  23
HD1   2    0.624104    0.642952    0.060965    11.00000   -1.20000
HD2   2    0.592867    0.623760    0.065416    11.00000   -1.20000
AFIX   0
CE    1    0.616006    0.603557    0.066512    11.00000    0.30706    0.17601 =
         0.39290    0.00253    0.00046    0.16062
AFIX  23
HE1   2    0.634984    0.608680    0.069069    11.00000   -1.20000
HE2   2    0.602855    0.589094    0.072176    11.00000   -1.20000
AFIX   0
NZ    3    0.610894    0.592304    0.053508    11.00000    0.29382    0.24019 =
         0.42206   -0.04832   -0.00308    0.18548
AFIX  33
HZ1   2    0.611073    0.576136    0.053375    11.00000   -1.50000
HZ2   2    0.624366    0.604729    0.048489    11.00000   -1.50000
HZ3   2    0.594186    0.589315    0.050883    11.00000   -1.50000
AFIX   0
 
RESI  187   LEU
N     3    0.610010    0.720061    0.069890    11.00000    0.16409    0.11358 =
         0.17774    0.00608    0.03439    0.08241
AFIX  43
H0    2    0.602649    0.709529    0.063421    11.00000   -1.20000
AFIX   0
CA    1    0.601166    0.740180    0.073242    11.00000    0.17727    0.11691 =
         0.17934    0.03216    0.04249    0.09438
AFIX  13
HA    2    0.617808    0.758252    0.075403    11.00000   -1.20000
AFIX   0
C     1    0.581468    0.729321    0.084440    11.00000    0.15629    0.09754 =
         0.17609    0.01317    0.03439    0.07290
O     4    0.556068    0.712493    0.083025    11.00000    0.14743    0.17398 =
         0.16361    0.00715    0.01197    0.09020
CB    1    0.585905    0.744497    0.062339    11.00000    0.17521    0.13368 =
         0.16302   -0.01004    0.02466    0.10071
AFIX  23
HB1   2    0.568961    0.726745    0.060518    11.00000   -1.20000
HB2   2    0.597929    0.749808    0.054998    11.00000   -1.20000
AFIX   0
CG    1    0.577701    0.767089    0.064756    11.00000    0.12668    0.12000 =
         0.20081   -0.00234    0.02145    0.07879
AFIX  13
HG    2    0.567410    0.762831    0.072702    11.00000   -1.20000
AFIX   0
CD1   1    0.603314    0.796407    0.065575    11.00000    0.14754    0.11764 =
         0.29687   -0.00019   -0.03379    0.08184
AFIX  33
HD1A  2    0.615472    0.796901    0.072171    11.00000   -1.50000
HD1B  2    0.597351    0.809842    0.067309    11.00000   -1.50000
HD1C  2    0.613337    0.801041    0.057766    11.00000   -1.50000
AFIX   0
CD2   1    0.558359    0.766123    0.054320    11.00000    0.14355    0.18260 =
         0.24714   -0.04096   -0.01827    0.10931
AFIX  33
HD2A  2    0.541954    0.747657    0.053976    11.00000   -1.50000
HD2B  2    0.568188    0.770247    0.046470    11.00000   -1.50000
HD2C  2    0.552715    0.779853    0.055922    11.00000   -1.50000
AFIX   0
 
RESI  188   GLN
N     3    0.592858    0.738922    0.095581    11.00000    0.09787    0.10712 =
         0.18035    0.01492    0.03708    0.06184
AFIX  43
H0    2    0.610522    0.751208    0.096079    11.00000   -1.20000
AFIX   0
CA    1    0.576074    0.729106    0.107089    11.00000    0.10658    0.09510 =
         0.17435    0.00552    0.03462    0.05946
AFIX  13
HA    2    0.559265    0.710886    0.105290    11.00000   -1.20000
AFIX   0
C     1    0.566266    0.749129    0.111661    11.00000    0.09527    0.07895 =
         0.16358   -0.01268    0.02018    0.03875
O     4    0.545843    0.740536    0.118846    11.00000    0.10043    0.11205 =
         0.15970    0.00495    0.02610    0.06583
CB    1    0.592900    0.724384    0.117251    11.00000    0.13619    0.10132 =
         0.18724    0.01278    0.01476    0.06260
AFIX  23
HB1   2    0.610796    0.741690    0.118277    11.00000   -1.20000
HB2   2    0.582708    0.720732    0.125093    11.00000   -1.20000
AFIX   0
CG    1    0.598802    0.700384    0.114862    11.00000    0.14489    0.10910 =
         0.21149    0.01455    0.00348    0.07164
AFIX  23
HG1   2    0.613402    0.702336    0.120606    11.00000   -1.20000
HG2   2    0.606144    0.702298    0.106431    11.00000   -1.20000
AFIX   0
CD    1    0.573545    0.671029    0.116297    11.00000    0.15766    0.10628 =
         0.15045    0.03946    0.03976    0.07452
OE1   4    0.549582    0.666993    0.118098    11.00000    0.16140    0.11434 =
         0.25850    0.01725    0.06144    0.07565
NE2   3    0.578928    0.649979    0.115523    11.00000    0.16346    0.11254 =
         0.23039    0.01729    0.05398    0.07691
AFIX  93
HE2A  2    0.565446    0.632830    0.116287    11.00000   -1.20000
HE2B  2    0.595898    0.653485    0.114259    11.00000   -1.20000
AFIX   0
 
RESI  189   GLY
N     3    0.579875    0.775860    0.107765    11.00000    0.10399    0.08413 =
         0.18335    0.00080    0.01544    0.04818
AFIX  43
H0    2    0.593621    0.781558    0.102543    11.00000   -1.20000
AFIX   0
CA    1    0.571054    0.795369    0.112515    11.00000    0.09388    0.08613 =
         0.13645   -0.00230   -0.00408    0.04689
AFIX  23
HA1   2    0.582799    0.805735    0.119588    11.00000   -1.20000
HA2   2    0.551683    0.784735    0.115402    11.00000   -1.20000
AFIX   0
C     1    0.573388    0.815862    0.102495    11.00000    0.10973    0.08981 =
         0.12365   -0.00190    0.02196    0.05758
O     4    0.587567    0.819954    0.093089    11.00000    0.11573    0.10446 =
         0.15271    0.00967    0.03972    0.05885
 
RESI  190   ILE
N     3    0.558401    0.828338    0.105056    11.00000    0.10788    0.07624 =
         0.13160   -0.00601    0.01354    0.05292
AFIX  43
H0    2    0.547430    0.822249    0.111463    11.00000   -1.20000
AFIX   0
CA    1    0.558889    0.851090    0.098077    11.00000    0.09984    0.06952 =
         0.12823    0.01113    0.01436    0.03062
AFIX  13
HA    2    0.573741    0.857549    0.091712    11.00000   -1.20000
AFIX   0
C     1    0.566113    0.875093    0.107260    11.00000    0.09672    0.07490 =
         0.14443    0.00336    0.02569    0.04580
O     4    0.552828    0.870503    0.117074    11.00000    0.10219    0.09819 =
         0.14074    0.02110    0.03118    0.05472
CB    1    0.530694    0.842601    0.091612    11.00000    0.10603    0.05971 =
         0.14099    0.02998    0.00849    0.01843
AFIX  13
HB    2    0.516140    0.835485    0.098130    11.00000   -1.20000
AFIX   0
CG1   1    0.522871    0.818585    0.082366    11.00000    0.13685    0.08491 =
         0.15590    0.00592   -0.03616    0.05205
AFIX  23
HG1A  2    0.528002    0.805373    0.085819    11.00000   -1.20000
HG1B  2    0.533252    0.826057    0.074626    11.00000   -1.20000
AFIX   0
CG2   1    0.529950    0.866898    0.085237    11.00000    0.12604    0.08622 =
         0.13466    0.02273    0.00654    0.04888
AFIX  33
HG2A  2    0.511742    0.860265    0.081510    11.00000   -1.50000
HG2B  2    0.544196    0.874614    0.078854    11.00000   -1.50000
HG2C  2    0.533440    0.881236    0.091299    11.00000   -1.50000
AFIX   0
CD1   1    0.491143    0.803287    0.079674    11.00000    0.13902    0.13738 =
         0.20433   -0.03036   -0.04928    0.05465
AFIX  33
HD1A  2    0.486453    0.788137    0.073894    11.00000   -1.50000
HD1B  2    0.486176    0.816313    0.076102    11.00000   -1.50000
HD1C  2    0.480912    0.795823    0.087339    11.00000   -1.50000
AFIX   0
 
RESI  191   VAL
N     3    0.586643    0.900420    0.104003    11.00000    0.08253    0.08030 =
         0.12257   -0.00094    0.01623    0.03494
AFIX  43
H0    2    0.595920    0.902488    0.097209    11.00000   -1.20000
AFIX   0
CA    1    0.593695    0.924955    0.111872    11.00000    0.11417    0.07489 =
         0.09435    0.01448    0.00302    0.05295
AFIX  13
HA    2    0.599710    0.921846    0.120074    11.00000   -1.20000
AFIX   0
C     1    0.567751    0.928259    0.113812    11.00000    0.11424    0.09277 =
         0.10739   -0.00135    0.00354    0.05961
O     4    0.556711    0.932536    0.104612    11.00000    0.09410    0.10431 =
         0.11969    0.00009    0.00126    0.04975
CB    1    0.618206    0.952155    0.106223    11.00000    0.10315    0.07033 =
         0.13013    0.00513    0.00483    0.04348
AFIX  13
HB    2    0.611539    0.955512    0.098242    11.00000   -1.20000
AFIX   0
CG1   1    0.625598    0.977356    0.114565    11.00000    0.12003    0.08813 =
         0.14580   -0.01558   -0.01965    0.04816
AFIX  33
HG1A  2    0.608946    0.978524    0.116146    11.00000   -1.50000
HG1B  2    0.639444    0.994285    0.110473    11.00000   -1.50000
HG1C  2    0.633082    0.975205    0.122353    11.00000   -1.50000
AFIX   0
CG2   1    0.644333    0.949626    0.103366    11.00000    0.11227    0.11766 =
         0.13445    0.01924    0.00808    0.06648
AFIX  33
HG2A  2    0.639175    0.933868    0.097894    11.00000   -1.50000
HG2B  2    0.651767    0.946826    0.111032    11.00000   -1.50000
HG2C  2    0.658401    0.966603    0.099385    11.00000   -1.50000
AFIX   0
 
RESI  192   SER
N     3    0.557956    0.926736    0.125317    11.00000    0.09741    0.08641 =
         0.11994   -0.00075    0.01196    0.03167
AFIX  43
H0    2    0.567809    0.926280    0.131492    11.00000   -1.20000
AFIX   0
CA    1    0.531432    0.925794    0.128074    11.00000    0.10994    0.09221 =
         0.10572    0.00812    0.01593    0.04840
AFIX  13
HA    2    0.523876    0.927457    0.120000    11.00000   -1.20000
AFIX   0
C     1    0.534750    0.950380    0.136033    11.00000    0.13698    0.08389 =
         0.13274   -0.00124   -0.02533    0.06771
O     4    0.528646    0.967257    0.131036    11.00000    0.14795    0.10490 =
         0.08272    0.01842    0.00773    0.07546
CB    1    0.509937    0.896623    0.133336    11.00000    0.08930    0.08631 =
         0.11596   -0.01437    0.00564    0.04041
AFIX  23
HB1   2    0.507883    0.882062    0.127543    11.00000   -1.20000
HB2   2    0.516789    0.893604    0.141232    11.00000   -1.20000
AFIX   0
OG    4    0.483086    0.894617    0.135225    11.00000    0.08184    0.13559 =
         0.10415   -0.00313    0.00184    0.04804
AFIX  83
HG    2    0.477281    0.897124    0.128544    11.00000   -1.50000
AFIX   0
 
RESI  193   TRP
N     3    0.543927    0.952671    0.147882    11.00000    0.10590    0.07541 =
         0.12606   -0.00211   -0.01096    0.06056
AFIX  43
H0    2    0.548590    0.940977    0.150864    11.00000   -1.20000
AFIX   0
CA    1    0.545760    0.975904    0.155634    11.00000    0.14261    0.09645 =
         0.14786   -0.01825   -0.00144    0.06591
AFIX  13
HA    2    0.553675    0.992899    0.150416    11.00000   -1.20000
AFIX   0
C     1    0.565420    0.981898    0.166609    11.00000    0.13834    0.14319 =
         0.13076   -0.03286    0.00851    0.09245
O     4    0.577376    0.968455    0.167972    11.00000    0.12970    0.11169 =
         0.15225   -0.04428   -0.00798    0.07153
CB    1    0.516633    0.969302    0.159781    11.00000    0.15340    0.10778 =
         0.11606   -0.00933   -0.00803    0.09181
AFIX  23
HB1   2    0.518582    0.985484    0.164364    11.00000   -1.20000
HB2   2    0.505619    0.967283    0.152337    11.00000   -1.20000
AFIX   0
CG    1    0.499964    0.943521    0.167788    11.00000    0.15897    0.12174 =
         0.11121   -0.00975    0.00295    0.07479
CD1   1    0.484018    0.916556    0.163617    11.00000    0.14209    0.11980 =
         0.10858   -0.00590    0.03218    0.07176
AFIX  43
HD1   2    0.481940    0.911114    0.155256    11.00000   -1.20000
AFIX   0
NE1   3    0.471456    0.898560    0.173487    11.00000    0.14052    0.12588 =
         0.09753   -0.00485    0.00287    0.08554
AFIX  43
HE1   2    0.460303    0.880632    0.172970    11.00000   -1.20000
AFIX   0
CE2   1    0.479730    0.914064    0.184350    11.00000    0.13757    0.13205 =
         0.10042   -0.01180    0.00655    0.08784
CZ2   1    0.472920    0.905525    0.196756    11.00000    0.15131    0.18169 =
         0.10366   -0.00571    0.02032    0.09595
AFIX  43
HZ2   2    0.461084    0.886656    0.198800    11.00000   -1.20000
AFIX   0
CH2   1    0.484200    0.925778    0.205810    11.00000    0.19382    0.20094 =
         0.08496   -0.00236    0.00347    0.09126
AFIX  43
HH2   2    0.480028    0.920650    0.214176    11.00000   -1.20000
AFIX   0
CZ3   1    0.501995    0.954216    0.202693    11.00000    0.25638    0.17411 =
         0.10678   -0.01550   -0.03234    0.12886
AFIX  43
HZ3   2    0.509339    0.967552    0.209071    11.00000   -1.20000
AFIX   0
CE3   1    0.508931    0.962999    0.190444    11.00000    0.15574    0.13651 =
         0.11309   -0.01443   -0.02099    0.08988
AFIX  43
HE3   2    0.520746    0.981927    0.188495    11.00000   -1.20000
AFIX   0
CD2   1    0.497561    0.942421    0.181044    11.00000    0.13488    0.13220 =
         0.10927   -0.01018   -0.02604    0.07820
 
RESI  194   GLY
N     3    0.568390    1.001907    0.174424    11.00000    0.14140    0.14757 =
         0.14922   -0.03726   -0.01113    0.10766
AFIX  43
H0    2    0.559899    1.011136    0.172705    11.00000   -1.20000
AFIX   0
CA    1    0.585023    1.009052    0.185621    11.00000    0.15080    0.12158 =
         0.17585   -0.04630   -0.03899    0.06957
AFIX  23
HA1   2    0.604304    1.014366    0.183538    11.00000   -1.20000
HA2   2    0.577532    0.992832    0.191150    11.00000   -1.20000
AFIX   0
C     1    0.584497    1.033326    0.192158    11.00000    0.15274    0.12712 =
         0.18476   -0.05108   -0.04949    0.07641
O     4    0.570505    1.043277    0.187915    11.00000    0.25644    0.19859 =
         0.18738   -0.05190   -0.07263    0.15891
 
RESI  195   SER
N     3    0.598432    1.042514    0.202484    11.00000    0.21988    0.13017 =
         0.16802   -0.04026   -0.06317    0.09901
AFIX  43
H0    2    0.605529    1.033163    0.205833    11.00000   -1.20000
AFIX   0
CA    1    0.602670    1.068076    0.208722    11.00000    0.21287    0.16903 =
         0.22827   -0.08626   -0.05804    0.10770
AFIX  13
HA    2    0.589725    1.073681    0.205133    11.00000   -1.20000
AFIX   0
C     1    0.632781    1.091977    0.207075    11.00000    0.22890    0.14031 =
         0.23220   -0.08625   -0.07420    0.09674
O     4    0.652035    1.089644    0.212062    11.00000    0.20408    0.22743 =
         0.19193   -0.03413   -0.03543    0.09822
CB    1    0.596232    1.061833    0.222544    11.00000    0.27699    0.30167 =
         0.23235   -0.10519   -0.00681    0.13903
AFIX  23
HB1   2    0.576739    1.047201    0.223714    11.00000   -1.20000
HB2   2    0.608323    1.055464    0.226180    11.00000   -1.20000
AFIX   0
OG    4    0.601184    1.087015    0.228264    11.00000    0.26685    0.35189 =
         0.34905   -0.21105   -0.00841    0.11138
AFIX  83
HG    2    0.591020    1.092315    0.225055    11.00000   -1.50000
AFIX   0
 
RESI  196   GLY
N     3    0.637290    1.113698    0.200132    11.00000    0.27847    0.15731 =
         0.24958   -0.06820   -0.02477    0.13619
AFIX  43
H0    2    0.623207    1.115381    0.197729    11.00000   -1.20000
AFIX   0
CA    1    0.665754    1.134950    0.196447    11.00000    0.30709    0.17724 =
         0.21575   -0.06121    0.00267    0.13135
AFIX  23
HA1   2    0.677004    1.143943    0.203836    11.00000   -1.20000
HA2   2    0.665094    1.149321    0.191382    11.00000   -1.20000
AFIX   0
C     1    0.679107    1.120832    0.188959    11.00000    0.28370    0.19527 =
         0.14663   -0.04714   -0.04045    0.15079
O     4    0.664025    1.098709    0.183361    11.00000    0.28056    0.25006 =
         0.16264   -0.09809   -0.01527    0.14252
 
RESI  197   CYS
N     3    0.706753    1.133123    0.189218    11.00000    0.28717    0.20069 =
         0.22065   -0.07336   -0.04541    0.14194
AFIX  43
H0    2    0.715975    1.148756    0.193241    11.00000   -1.20000
AFIX   0
CA    1    0.722442    1.121856    0.183140    11.00000    0.23536    0.14596 =
         0.22059   -0.03521   -0.03044    0.09689
AFIX  13
HA    2    0.710302    1.101418    0.182168    11.00000   -1.20000
AFIX   0
C     1    0.747921    1.127755    0.191016    11.00000    0.26926    0.19391 =
         0.22447   -0.04225   -0.05613    0.12187
O     4    0.764029    1.151508    0.194995    11.00000    0.27332    0.17736 =
         0.16933    0.00106   -0.05328    0.10073
CB    1    0.733006    1.135320    0.170122    11.00000    0.26902    0.25013 =
         0.21074   -0.01564   -0.02846    0.12711
AFIX  23
HB1   2    0.742946    1.126735    0.166278    11.00000   -1.20000
HB2   2    0.746481    1.155211    0.171254    11.00000   -1.20000
AFIX   0
SG    5    0.705855    1.132005    0.159452    11.00000    0.27884    0.25291 =
         0.22669   -0.02699   -0.02570    0.15592
 
RESI  198   ALA
N     3    0.751019    1.105453    0.192721    11.00000    0.22328    0.19838 =
         0.17897   -0.03593   -0.02748    0.11238
AFIX  43
H0    2    0.738317    1.089096    0.190120    11.00000   -1.20000
AFIX   0
CA    1    0.776394    1.108970    0.199104    11.00000    0.19823    0.20586 =
         0.20694   -0.02058   -0.01952    0.09340
AFIX  13
HA    2    0.775241    1.090517    0.199083    11.00000   -1.20000
AFIX   0
C     1    0.779552    1.118493    0.212641    11.00000    0.24876    0.24285 =
         0.18630    0.00244   -0.03782    0.11535
O     4    0.802806    1.129698    0.217620    11.00000    0.25068    0.19851 =
         0.22346   -0.01709   -0.04667    0.10613
CB    1    0.802972    1.129250    0.191766    11.00000    0.21420    0.18715 =
         0.17709    0.00852   -0.05391    0.05718
AFIX  33
HB1   2    0.801072    1.123034    0.183233    11.00000   -1.50000
HB2   2    0.819099    1.129553    0.195474    11.00000   -1.50000
HB3   2    0.805397    1.147870    0.191994    11.00000   -1.50000
AFIX   0
 
RESI  199   GLN
N     3    0.756445    1.113797    0.218609    11.00000    0.25376    0.22835 =
         0.16195   -0.02351   -0.03746    0.09941
AFIX  43
H0    2    0.740936    1.106117    0.214431    11.00000   -1.20000
AFIX   0
CA    1    0.755136    1.120529    0.231594    11.00000    0.34316    0.23471 =
         0.17018   -0.06590   -0.05949    0.12886
AFIX  13
HA    2    0.772789    1.137573    0.233847    11.00000   -1.20000
AFIX   0
C     1    0.750760    1.096465    0.240255    11.00000    0.24563    0.25916 =
         0.14577   -0.04484   -0.02858    0.11770
O     4    0.737441    1.071435    0.236714    11.00000    0.26502    0.25265 =
         0.13359   -0.03318   -0.04585    0.12975
CB    1    0.730588    1.125951    0.233472    11.00000    0.44481    0.27610 =
         0.18576   -0.03014   -0.01494    0.21828
AFIX  23
HB1   2    0.712978    1.108758    0.231763    11.00000   -1.20000
HB2   2    0.730241    1.131166    0.242124    11.00000   -1.20000
AFIX   0
CG    1    0.733085    1.149330    0.224921    11.00000    0.48094    0.34431 =
         0.32104    0.07054   -0.01004    0.22675
AFIX  23
HG1   2    0.717070    1.152031    0.226281    11.00000   -1.20000
HG2   2    0.732649    1.143770    0.216262    11.00000   -1.20000
AFIX   0
CD    1    0.760245    1.177013    0.227307    11.00000    0.66215    0.27025 =
         0.27449   -0.01449   -0.09927    0.22892
OE1   4    0.765391    1.187368    0.237839    11.00000    1.11277    0.33608 =
         0.36122   -0.12961   -0.04848    0.37844
NE2   3    0.777830    1.188668    0.217754    11.00000    0.45977    0.31466 =
         0.29894   -0.04029   -0.17489    0.08360
AFIX  93
HE2A  2    0.793552    1.204091    0.218815    11.00000   -1.20000
HE2B  2    0.773507    1.180799    0.210500    11.00000   -1.20000
AFIX   0
 
RESI  200   LYS
N     3    0.762729    1.105168    0.251502    11.00000    0.34323    0.25799 =
         0.18650   -0.04210   -0.08700    0.08487
AFIX  43
H0    2    0.771530    1.122910    0.253185    11.00000   -1.20000
AFIX   0
CA    1    0.761217    1.085280    0.260991    11.00000    0.25346    0.26019 =
         0.18200   -0.06109   -0.08624    0.10716
AFIX  13
HA    2    0.769838    1.074707    0.257618    11.00000   -1.20000
AFIX   0
C     1    0.730366    1.064597    0.264017    11.00000    0.24941    0.25985 =
         0.14903   -0.05456   -0.07777    0.12511
O     4    0.713311    1.072953    0.265423    11.00000    0.29940    0.30111 =
         0.19365   -0.06718   -0.05688    0.17166
CB    1    0.777265    1.100923    0.272631    11.00000    0.23055    0.40645 =
         0.22433   -0.11166   -0.13627    0.18097
AFIX  23
HB1   2    0.766567    1.108007    0.277030    11.00000   -1.20000
HB2   2    0.795170    1.116991    0.270174    11.00000   -1.20000
AFIX   0
CG    1    0.782662    1.082357    0.281401    11.00000    0.34909    0.50926 =
         0.23652   -0.08569   -0.13522    0.27361
AFIX  23
HG1   2    0.794521    1.076281    0.277286    11.00000   -1.20000
HG2   2    0.764934    1.065715    0.283567    11.00000   -1.20000
AFIX   0
CD    1    0.797307    1.098974    0.293351    11.00000    0.41904    0.60141 =
         0.24224   -0.11417   -0.17780    0.33439
AFIX  23
HD1   2    0.817616    1.108536    0.292280    11.00000   -1.20000
HD2   2    0.791924    1.113101    0.294927    11.00000   -1.20000
AFIX   0
CE    1    0.788657    1.078677    0.304409    11.00000    0.52789    0.65789 =
         0.27569   -0.07491   -0.23013    0.35393
AFIX  23
HE1   2    0.791501    1.089326    0.312060    11.00000   -1.20000
HE2   2    0.768643    1.065223    0.303728    11.00000   -1.20000
AFIX   0
NZ    3    0.804050    1.062754    0.305526    11.00000    0.68849    0.83050 =
         0.78598    0.09468   -0.24866    0.50746
AFIX  33
HZ1   2    0.797476    1.051189    0.312079    11.00000   -1.50000
HZ2   2    0.822372    1.074816    0.306578    11.00000   -1.50000
HZ3   2    0.801502    1.052742    0.298589    11.00000   -1.50000
AFIX   0
 
RESI  201   ASN
N     3    0.723962    1.037977    0.264614    11.00000    0.24591    0.26054 =
         0.18902   -0.03820   -0.02540    0.12555
AFIX  43
H0    2    0.737306    1.034544    0.262898    11.00000   -1.20000
AFIX   0
CA    1    0.696715    1.013722    0.267868    11.00000    0.27077    0.29020 =
         0.14865    0.01571    0.00705    0.13170
AFIX  13
HA    2    0.698512    0.996891    0.266867    11.00000   -1.20000
AFIX   0
C     1    0.673128    1.010198    0.259194    11.00000    0.25899    0.21851 =
         0.16172   -0.04102   -0.03539    0.07621
O     4    0.648266    0.997942    0.262319    11.00000    0.25131    0.31415 =
         0.18042   -0.00672   -0.04132    0.03725
CB    1    0.689740    1.014981    0.281626    11.00000    0.33749    0.29773 =
         0.14621   -0.01878   -0.01349    0.15102
AFIX  23
HB1   2    0.693291    1.033889    0.283332    11.00000   -1.20000
HB2   2    0.669689    1.002217    0.282775    11.00000   -1.20000
AFIX   0
CG    1    0.705249    1.007883    0.291330    11.00000    0.57583    0.35762 =
         0.16198   -0.01013   -0.05291    0.28532
OD1   4    0.710843    1.018523    0.301865    11.00000    0.66842    0.64409 =
         0.26716   -0.19227   -0.21371    0.48514
ND2   3    0.713670    0.989267    0.288967    11.00000    0.59020    0.50008 =
         0.16826   -0.02393   -0.03211    0.37507
AFIX  93
HD2A  2    0.722393    0.985410    0.294634    11.00000   -1.20000
HD2B  2    0.710370    0.981138    0.281777    11.00000   -1.20000
AFIX   0
 
RESI  202   LYS
N     3    0.680369    1.020553    0.247766    11.00000    0.21983    0.25415 =
         0.14359   -0.06173   -0.05181    0.07576
AFIX  43
H0    2    0.697959    1.030104    0.245832    11.00000   -1.20000
AFIX   0
CA    1    0.659269    1.016197    0.238334    11.00000    0.21146    0.23769 =
         0.15883   -0.09311   -0.06225    0.09124
AFIX  13
HA    2    0.640853    1.000758    0.241015    11.00000   -1.20000
AFIX   0
C     1    0.667227    1.008406    0.226009    11.00000    0.16398    0.19800 =
         0.14218   -0.05277   -0.06405    0.09519
O     4    0.677950    1.025099    0.217408    11.00000    0.20690    0.17839 =
         0.19408   -0.03497   -0.01821    0.09284
CB    1    0.657798    1.043284    0.237257    11.00000    0.31523    0.30010 =
         0.20231   -0.13270   -0.07206    0.18189
AFIX  23
HB1   2    0.676782    1.059038    0.236160    11.00000   -1.20000
HB2   2    0.647133    1.042101    0.229802    11.00000   -1.20000
AFIX   0
CG    1    0.644516    1.049333    0.248353    11.00000    0.36693    0.34379 =
         0.18564   -0.12511   -0.05038    0.19826
AFIX  23
HG1   2    0.644568    1.066798    0.246738    11.00000   -1.20000
HG2   2    0.656371    1.052426    0.255613    11.00000   -1.20000
AFIX   0
CD    1    0.614371    1.026639    0.251679    11.00000    0.38558    0.40320 =
         0.45512   -0.16983    0.05648    0.20248
AFIX  23
HD1   2    0.601333    1.027258    0.245710    11.00000   -1.20000
HD2   2    0.612716    1.008181    0.251130    11.00000   -1.20000
AFIX   0
CE    1    0.606612    1.031032    0.264820    11.00000    0.49998    0.51178 =
         0.46804   -0.11909    0.15768    0.17586
AFIX  23
HE1   2    0.622336    1.047886    0.268363    11.00000   -1.20000
HE2   2    0.590627    1.034063    0.264338    11.00000   -1.20000
AFIX   0
NZ    3    0.599386    1.006743    0.273296    11.00000    0.68216    0.30305 =
         0.57750   -0.14055    0.33478    0.03994
AFIX  33
HZ1   2    0.607021    1.013130    0.280796    11.00000   -1.50000
HZ2   2    0.606091    0.996237    0.270111    11.00000   -1.50000
HZ3   2    0.580728    0.996346    0.274048    11.00000   -1.50000
AFIX   0
 
RESI  203   PRO
N     3    0.663594    0.982626    0.224929    11.00000    0.17362    0.18466 =
         0.13224   -0.03517   -0.04735    0.07806
CA    1    0.672339    0.974304    0.213463    11.00000    0.16736    0.15602 =
         0.13205   -0.02449   -0.04685    0.07484
AFIX  13
HA    2    0.691769    0.988253    0.211199    11.00000   -1.20000
AFIX   0
C     1    0.652183    0.969502    0.202711    11.00000    0.14747    0.13237 =
         0.13066   -0.02726   -0.03461    0.07694
O     4    0.629186    0.968121    0.204255    11.00000    0.16635    0.18210 =
         0.17111   -0.04387   -0.04100    0.10647
CB    1    0.670115    0.946306    0.217429    11.00000    0.17466    0.20599 =
         0.17346    0.01733   -0.02374    0.11732
AFIX  23
HB1   2    0.664900    0.933465    0.210383    11.00000   -1.20000
HB2   2    0.687856    0.949395    0.220851    11.00000   -1.20000
AFIX   0
CG    1    0.647640    0.934993    0.227149    11.00000    0.20745    0.20547 =
         0.14713    0.01668   -0.02234    0.11072
AFIX  23
HG1   2    0.649560    0.921827    0.232567    11.00000   -1.20000
HG2   2    0.629126    0.925342    0.223285    11.00000   -1.20000
AFIX   0
CD    1    0.651543    0.960241    0.234511    11.00000    0.21577    0.22237 =
         0.15079   -0.00784   -0.02066    0.09735
AFIX  23
HD1   2    0.633698    0.957473    0.237643    11.00000   -1.20000
HD2   2    0.664436    0.964382    0.241465    11.00000   -1.20000
AFIX   0
 
RESI  204   GLY
N     3    0.660091    0.966614    0.191288    11.00000    0.12843    0.20787 =
         0.11938   -0.00840   -0.01711    0.04682
AFIX  43
H0    2    0.676601    0.968682    0.190243    11.00000   -1.20000
AFIX   0
CA    1    0.641745    0.960113    0.180611    11.00000    0.13344    0.17299 =
         0.11701    0.02335   -0.01689    0.00597
AFIX  23
HA1   2    0.652226    0.961584    0.173052    11.00000   -1.20000
HA2   2    0.635547    0.973869    0.180056    11.00000   -1.20000
AFIX   0
C     1    0.616030    0.930683    0.181366    11.00000    0.09976    0.12055 =
         0.14895    0.01062   -0.00252    0.05440
O     4    0.617937    0.911670    0.186326    11.00000    0.13551    0.15995 =
         0.13478   -0.00072   -0.03206    0.08821
 
RESI  205   VAL
N     3    0.592737    0.928558    0.176532    11.00000    0.11791    0.12178 =
         0.12122    0.00262   -0.01933    0.06250
AFIX  43
H0    2    0.593325    0.943723    0.173944    11.00000   -1.20000
AFIX   0
CA    1    0.566131    0.901995    0.175339    11.00000    0.11194    0.13009 =
         0.13128   -0.01715   -0.02431    0.07196
AFIX  13
HA    2    0.568243    0.887383    0.179680    11.00000   -1.20000
AFIX   0
C     1    0.560646    0.893889    0.161594    11.00000    0.11760    0.11756 =
         0.12697   -0.01144   -0.01832    0.08106
O     4    0.563481    0.911203    0.153463    11.00000    0.13858    0.13196 =
         0.13887   -0.00072   -0.02046    0.09193
CB    1    0.541509    0.903552    0.181532    11.00000    0.12614    0.14939 =
         0.11170    0.00743    0.00495    0.07475
AFIX  13
HB    2    0.536999    0.915568    0.176363    11.00000   -1.20000
AFIX   0
CG1   1    0.515154    0.873750    0.182132    11.00000    0.14608    0.13319 =
         0.12791    0.00021    0.01591    0.07245
AFIX  33
HG1A  2    0.510401    0.865947    0.173848    11.00000   -1.50000
HG1B  2    0.499620    0.874989    0.185591    11.00000   -1.50000
HG1C  2    0.519086    0.861819    0.187332    11.00000   -1.50000
AFIX   0
CG2   1    0.548561    0.915902    0.194759    11.00000    0.17232    0.13780 =
         0.12668   -0.00878   -0.00595    0.08720
AFIX  33
HG2A  2    0.532592    0.916355    0.198203    11.00000   -1.50000
HG2B  2    0.564428    0.934716    0.194430    11.00000   -1.50000
HG2C  2    0.553089    0.904385    0.199944    11.00000   -1.50000
AFIX   0
 
RESI  206   TYR
N     3    0.552869    0.867382    0.158864    11.00000    0.10078    0.11179 =
         0.10048    0.00555    0.02874    0.05812
AFIX  43
H0    2    0.548385    0.855915    0.165072    11.00000   -1.20000
AFIX   0
CA    1    0.551134    0.855727    0.146546    11.00000    0.09663    0.10444 =
         0.09819    0.00539    0.00999    0.05005
AFIX  13
HA    2    0.552838    0.869495    0.140236    11.00000   -1.20000
AFIX   0
C     1    0.522649    0.828534    0.144894    11.00000    0.11359    0.09268 =
         0.11058    0.01366    0.00604    0.04817
O     4    0.511325    0.811316    0.153208    11.00000    0.10580    0.10175 =
         0.13302    0.03593    0.01926    0.05946
CB    1    0.575538    0.849677    0.144874    11.00000    0.12169    0.07637 =
         0.09710    0.00321    0.01144    0.06274
AFIX  23
HB1   2    0.574040    0.836060    0.151085    11.00000   -1.20000
HB2   2    0.574451    0.841715    0.136639    11.00000   -1.20000
AFIX   0
CG    1    0.603554    0.876773    0.146328    11.00000    0.09951    0.09683 =
         0.12270    0.00268    0.00525    0.06356
CD1   1    0.614530    0.894739    0.136309    11.00000    0.10194    0.10578 =
         0.12319    0.00514    0.00283    0.04702
AFIX  43
HD1   2    0.604774    0.890104    0.128755    11.00000   -1.20000
AFIX   0
CD2   1    0.618358    0.884539    0.157485    11.00000    0.13092    0.11487 =
         0.12501    0.00647   -0.00315    0.04718
AFIX  43
HD2   2    0.611038    0.872624    0.164369    11.00000   -1.20000
AFIX   0
CE1   1    0.639900    0.919616    0.137330    11.00000    0.07789    0.12853 =
         0.15375    0.02357   -0.01196    0.04861
AFIX  43
HE1   2    0.647250    0.931445    0.130421    11.00000   -1.20000
AFIX   0
CE2   1    0.643627    0.909393    0.158716    11.00000    0.06900    0.13411 =
         0.14324    0.02256    0.00516    0.05716
AFIX  43
HE2   2    0.653280    0.914215    0.166298    11.00000   -1.20000
AFIX   0
CZ    1    0.654338    0.927027    0.148430    11.00000    0.08464    0.13095 =
         0.14404    0.02325   -0.01000    0.04362
OH    4    0.679733    0.952671    0.148861    11.00000    0.11877    0.10213 =
         0.17386    0.01020   -0.01928    0.03957
AFIX  83
HH    2    0.686571    0.954987    0.155892    11.00000   -1.50000
AFIX   0
 
RESI  207   THR
N     3    0.510980    0.825314    0.133703    11.00000    0.11034    0.09303 =
         0.11806    0.00363   -0.00213    0.04439
AFIX  43
H0    2    0.518920    0.838623    0.128270    11.00000   -1.20000
AFIX   0
CA    1    0.484914    0.799626    0.130412    11.00000    0.09460    0.08201 =
         0.08654    0.01789    0.02835    0.03950
AFIX  13
HA    2    0.470852    0.795517    0.136971    11.00000   -1.20000
AFIX   0
C     1    0.490637    0.775050    0.129502    11.00000    0.11552    0.10043 =
         0.12025    0.02914    0.02727    0.06435
O     4    0.511160    0.778349    0.123216    11.00000    0.08519    0.09978 =
         0.12974   -0.00454    0.01150    0.04215
CB    1    0.473120    0.802536    0.117856    11.00000    0.11699    0.09651 =
         0.11245    0.00289   -0.00721    0.05795
AFIX  13
HB    2    0.486647    0.805169    0.111246    11.00000   -1.20000
AFIX   0
OG1   4    0.470600    0.827481    0.118518    11.00000    0.10062    0.10305 =
         0.16413    0.00108   -0.00690    0.06009
AFIX  83
HG1   2    0.486048    0.841182    0.120117    11.00000   -1.50000
AFIX   0
CG2   1    0.444984    0.776828    0.114711    11.00000    0.09265    0.10996 =
         0.13737    0.00066   -0.00293    0.05980
AFIX  33
HG2A  2    0.438527    0.779572    0.106759    11.00000   -1.50000
HG2B  2    0.431458    0.774143    0.121068    11.00000   -1.50000
HG2C  2    0.447146    0.760488    0.114316    11.00000   -1.50000
AFIX   0
 
RESI  208   LYS
N     3    0.472657    0.751687    0.135468    11.00000    0.10356    0.08368 =
         0.12264    0.01703    0.01271    0.04497
AFIX  43
H0    2    0.458020    0.750600    0.138995    11.00000   -1.20000
AFIX   0
CA    1    0.477428    0.727621    0.136128    11.00000    0.11840    0.09404 =
         0.15738    0.02259    0.03741    0.06094
AFIX  13
HA    2    0.497818    0.734859    0.136190    11.00000   -1.20000
AFIX   0
C     1    0.465010    0.709011    0.124745    11.00000    0.11925    0.10263 =
         0.16038    0.01629    0.03426    0.07551
O     4    0.440378    0.689861    0.124208    11.00000    0.12439    0.11456 =
         0.14185    0.02010    0.03636    0.07166
CB    1    0.464976    0.711649    0.148459    11.00000    0.17224    0.09253 =
         0.16176    0.02848    0.03494    0.08134
AFIX  23
HB1   2    0.444553    0.702271    0.148089    11.00000   -1.20000
HB2   2    0.471234    0.724987    0.155345    11.00000   -1.20000
AFIX   0
CG    1    0.474111    0.689615    0.150870    11.00000    0.19170    0.09805 =
         0.28934    0.06992    0.06664    0.09261
AFIX  23
HG1   2    0.470211    0.677970    0.143466    11.00000   -1.20000
HG2   2    0.494300    0.699279    0.152337    11.00000   -1.20000
AFIX   0
CD    1    0.459063    0.670836    0.162010    11.00000    0.23183    0.15278 =
         0.24589    0.07657    0.04107    0.12307
AFIX  23
HD1   2    0.438994    0.660814    0.160236    11.00000   -1.20000
HD2   2    0.464935    0.656840    0.162643    11.00000   -1.20000
AFIX   0
CE    1    0.463300    0.684504    0.174372    11.00000    0.25545    0.19115 =
         0.26318    0.03883   -0.00316    0.14154
AFIX  23
HE1   2    0.458112    0.699028    0.173902    11.00000   -1.20000
HE2   2    0.483080    0.693449    0.176650    11.00000   -1.20000
AFIX   0
NZ    3    0.445702    0.663220    0.184319    11.00000    0.38899    0.34247 =
         0.22619    0.09386    0.01375    0.18505
AFIX  33
HZ1   2    0.449983    0.671508    0.191797    11.00000   -1.50000
HZ2   2    0.449289    0.649053    0.184265    11.00000   -1.50000
HZ3   2    0.427488    0.656586    0.182743    11.00000   -1.50000
AFIX   0
 
RESI  209   VAL
N     3    0.483053    0.714492    0.115233    11.00000    0.10529    0.11495 =
         0.15838    0.00657    0.02439    0.06674
AFIX  43
H0    2    0.500791    0.725515    0.116513    11.00000   -1.20000
AFIX   0
CA    1    0.473607    0.702393    0.102801    11.00000    0.10134    0.09297 =
         0.17476   -0.01049    0.02876    0.05620
AFIX  13
HA    2    0.459529    0.707186    0.099906    11.00000   -1.20000
AFIX   0
C     1    0.459841    0.670265    0.103097    11.00000    0.08741    0.09774 =
         0.19820    0.00283    0.01887    0.05243
O     4    0.441163    0.655768    0.095669    11.00000    0.10467    0.08452 =
         0.18179    0.01702    0.01229    0.04238
CB    1    0.498394    0.714902    0.093487    11.00000    0.09024    0.10945 =
         0.12980    0.01887    0.00113    0.06268
AFIX  13
HB    2    0.513469    0.712322    0.097029    11.00000   -1.20000
AFIX   0
CG1   1    0.489373    0.698860    0.081112    11.00000    0.11229    0.14641 =
         0.16271   -0.02555   -0.00087    0.07479
AFIX  33
HG1A  2    0.481879    0.679097    0.082650    11.00000   -1.50000
HG1B  2    0.505396    0.705654    0.075649    11.00000   -1.50000
HG1C  2    0.475168    0.701733    0.077251    11.00000   -1.50000
AFIX   0
CG2   1    0.510247    0.746715    0.091600    11.00000    0.13193    0.11077 =
         0.15177    0.01312    0.02731    0.07605
AFIX  33
HG2A  2    0.515720    0.756123    0.099551    11.00000   -1.50000
HG2B  2    0.496040    0.749805    0.087891    11.00000   -1.50000
HG2C  2    0.526381    0.754081    0.086178    11.00000   -1.50000
AFIX   0
 
RESI  210   CYS
N     3    0.469322    0.658441    0.111293    11.00000    0.12857    0.09211 =
         0.14863   -0.00871    0.00467    0.04788
AFIX  43
H0    2    0.482118    0.668758    0.116637    11.00000   -1.20000
AFIX   0
CA    1    0.457973    0.628261    0.111129    11.00000    0.11573    0.09575 =
         0.19289    0.00873    0.01162    0.04935
AFIX  13
HA    2    0.461536    0.623091    0.102821    11.00000   -1.20000
AFIX   0
C     1    0.426126    0.612379    0.113280    11.00000    0.11825    0.09337 =
         0.21784    0.00939    0.02108    0.05041
O     4    0.412128    0.587848    0.109657    11.00000    0.12327    0.10821 =
         0.30690   -0.02883    0.02339    0.03380
CB    1    0.472103    0.618678    0.120863    11.00000    0.13239    0.09259 =
         0.18946   -0.00602   -0.00514    0.04883
AFIX  23
HB1   2    0.491885    0.626813    0.118719    11.00000   -1.20000
HB2   2    0.463538    0.598326    0.120395    11.00000   -1.20000
AFIX   0
SG    5    0.469511    0.628339    0.136807    11.00000    0.17937    0.12652 =
         0.18351    0.02655    0.02788    0.08115
 
RESI  211   ASN
N     3    0.414037    0.625481    0.118758    11.00000    0.11697    0.11057 =
         0.18838    0.03024    0.00557    0.06970
AFIX  43
H0    2    0.424127    0.642897    0.120901    11.00000   -1.20000
AFIX   0
CA    1    0.383602    0.610372    0.121158    11.00000    0.12090    0.12730 =
         0.15428    0.01938    0.01149    0.06252
AFIX  13
HA    2    0.377715    0.591187    0.124002    11.00000   -1.20000
AFIX   0
C     1    0.367191    0.608941    0.109423    11.00000    0.11023    0.09600 =
         0.16913    0.02075    0.00332    0.05469
O     4    0.341564    0.592914    0.109244    11.00000    0.11670    0.13829 =
         0.17432    0.02425    0.00709    0.04389
CB    1    0.376450    0.625548    0.131172    11.00000    0.11631    0.09072 =
         0.16266    0.02482    0.03294    0.02135
AFIX  23
HB1   2    0.385081    0.645266    0.128825    11.00000   -1.20000
HB2   2    0.356180    0.617848    0.131137    11.00000   -1.20000
AFIX   0
CG    1    0.385394    0.624062    0.144421    11.00000    0.15620    0.15749 =
         0.15072    0.02532    0.04433    0.07445
OD1   4    0.396860    0.610244    0.146814    11.00000    0.17723    0.18465 =
         0.20605    0.02149    0.00841    0.09715
ND2   3    0.380276    0.638878    0.152882    11.00000    0.18389    0.20492 =
         0.19475   -0.03138    0.03448    0.08583
AFIX  93
HD2A  2    0.385097    0.639131    0.160566    11.00000   -1.20000
HD2B  2    0.372156    0.648177    0.150651    11.00000   -1.20000
AFIX   0
 
RESI  212   TYR
N     3    0.381338    0.625321    0.099943    11.00000    0.11167    0.13783 =
         0.14873    0.01110    0.01117    0.06420
AFIX  43
H0    2    0.399411    0.634664    0.100633    11.00000   -1.20000
AFIX   0
CA    1    0.369702    0.629164    0.088603    11.00000    0.09791    0.14335 =
         0.14393    0.01423    0.01790    0.06777
AFIX  13
HA    2    0.349340    0.620925    0.089842    11.00000   -1.20000
AFIX   0
C     1    0.374053    0.615280    0.077202    11.00000    0.12577    0.09619 =
         0.15323    0.01037    0.01969    0.04600
O     4    0.365119    0.618030    0.066894    11.00000    0.12728    0.12177 =
         0.15330   -0.00712    0.01168    0.06246
CB    1    0.382327    0.661291    0.085696    11.00000    0.12977    0.13571 =
         0.15582   -0.01147   -0.00691    0.08767
AFIX  23
HB1   2    0.402665    0.670413    0.084847    11.00000   -1.20000
HB2   2    0.374586    0.663707    0.077930    11.00000   -1.20000
AFIX   0
CG    1    0.374748    0.674021    0.096359    11.00000    0.13528    0.14264 =
         0.12186    0.02722    0.03056    0.07819
CD1   1    0.347669    0.669975    0.097533    11.00000    0.13820    0.14946 =
         0.17225   -0.00111    0.02231    0.08265
AFIX  43
HD1   2    0.333946    0.659462    0.091597    11.00000   -1.20000
AFIX   0
CD2   1    0.394120    0.689228    0.105858    11.00000    0.13793    0.07739 =
         0.17146   -0.00170    0.01751    0.05550
AFIX  43
HD2   2    0.412167    0.691646    0.105399    11.00000   -1.20000
AFIX   0
CE1   1    0.341282    0.681749    0.107635    11.00000    0.12765    0.12465 =
         0.18008   -0.00307    0.01985    0.07266
AFIX  43
HE1   2    0.323229    0.679277    0.108225    11.00000   -1.20000
AFIX   0
CE2   1    0.387488    0.700689    0.115811    11.00000    0.11985    0.06668 =
         0.15547    0.02056    0.03005    0.04008
AFIX  43
HE2   2    0.400991    0.710947    0.121869    11.00000   -1.20000
AFIX   0
CZ    1    0.360597    0.696903    0.116788    11.00000    0.12648    0.09796 =
         0.17431    0.01116    0.02527    0.05587
OH    4    0.353546    0.708195    0.126709    11.00000    0.13768    0.12557 =
         0.15613    0.01668    0.02353    0.07511
AFIX  83
HH    2    0.337154    0.704550    0.125950    11.00000   -1.50000
AFIX   0
 
RESI  213   VAL
N     3    0.387388    0.600547    0.078124    11.00000    0.12895    0.12250 =
         0.16302   -0.01658    0.00120    0.06190
AFIX  43
H0    2    0.392141    0.597245    0.085330    11.00000   -1.20000
AFIX   0
CA    1    0.393809    0.590085    0.066682    11.00000    0.13242    0.15692 =
         0.13988   -0.00849   -0.00572    0.08291
AFIX  13
HA    2    0.404070    0.606431    0.061166    11.00000   -1.20000
AFIX   0
C     1    0.367572    0.568844    0.059496    11.00000    0.13912    0.10289 =
         0.15176   -0.00947   -0.00217    0.07966
O     4    0.367377    0.569601    0.047860    11.00000    0.15994    0.13292 =
         0.14698   -0.03380   -0.00302    0.06908
CB    1    0.413758    0.578399    0.069254    11.00000    0.17834    0.19919 =
         0.15612   -0.05664   -0.04176    0.12670
AFIX  13
HB    2    0.404854    0.562891    0.075294    11.00000   -1.20000
AFIX   0
CG1   1    0.419322    0.567354    0.057101    11.00000    0.20504    0.24525 =
         0.18925   -0.04970    0.00937    0.14714
AFIX  33
HG1A  2    0.401838    0.552450    0.053844    11.00000   -1.50000
HG1B  2    0.431904    0.560267    0.058714    11.00000   -1.50000
HG1C  2    0.427725    0.582394    0.051098    11.00000   -1.50000
AFIX   0
CG2   1    0.440919    0.601951    0.074840    11.00000    0.15266    0.22772 =
         0.25754   -0.06867   -0.04956    0.12437
AFIX  33
HG2A  2    0.436701    0.608663    0.082382    11.00000   -1.50000
HG2B  2    0.449783    0.617153    0.068936    11.00000   -1.50000
HG2C  2    0.453424    0.594910    0.076732    11.00000   -1.50000
AFIX   0
 
RESI  214   SER
N     3    0.345061    0.549631    0.065687    11.00000    0.18046    0.08588 =
         0.16782   -0.00154   -0.00043    0.05896
AFIX  43
H0    2    0.346149    0.548649    0.073687    11.00000   -1.20000
AFIX   0
CA    1    0.318598    0.530142    0.059513    11.00000    0.15537    0.11040 =
         0.19202   -0.01893   -0.00054    0.06282
AFIX  13
HA    2    0.322726    0.519375    0.053380    11.00000   -1.20000
AFIX   0
C     1    0.306240    0.545687    0.052341    11.00000    0.13362    0.09678 =
         0.17522    0.01131    0.02900    0.04148
O     4    0.297686    0.538954    0.041250    11.00000    0.16626    0.11720 =
         0.17620   -0.00434    0.01988    0.06126
CB    1    0.297373    0.509005    0.068899    11.00000    0.22050    0.09877 =
         0.24369    0.03969   -0.02325    0.02373
AFIX  23
HB1   2    0.296209    0.519072    0.076142    11.00000   -1.20000
HB2   2    0.278847    0.499030    0.065059    11.00000   -1.20000
AFIX   0
OG    4    0.305490    0.489356    0.072779    11.00000    0.45971    0.18943 =
         0.46348    0.10661    0.06650    0.18100
AFIX  83
HG    2    0.321058    0.497766    0.076111    11.00000   -1.50000
AFIX   0
 
RESI  215   TRP
N     3    0.305631    0.566493    0.058663    11.00000    0.10602    0.10406 =
         0.16851    0.00801    0.02984    0.03851
AFIX  43
H0    2    0.311259    0.569808    0.066315    11.00000   -1.20000
AFIX   0
CA    1    0.295456    0.583483    0.052592    11.00000    0.10933    0.11516 =
         0.15206   -0.00290    0.02112    0.04614
AFIX  13
HA    2    0.276531    0.570425    0.049391    11.00000   -1.20000
AFIX   0
C     1    0.313455    0.599652    0.041424    11.00000    0.09726    0.07823 =
         0.13342   -0.02373    0.00215    0.03038
O     4    0.302480    0.600033    0.031543    11.00000    0.12049    0.12091 =
         0.12811   -0.03499   -0.00450    0.04345
CB    1    0.292327    0.602882    0.062176    11.00000    0.10856    0.13138 =
         0.16112   -0.00902    0.03273    0.05351
AFIX  23
HB1   2    0.277128    0.591340    0.067913    11.00000   -1.20000
HB2   2    0.309577    0.612750    0.067021    11.00000   -1.20000
AFIX   0
CG    1    0.286348    0.624059    0.056226    11.00000    0.10568    0.12468 =
         0.13151   -0.03407    0.00067    0.04661
CD1   1    0.260521    0.618963    0.052081    11.00000    0.11211    0.12907 =
         0.18287   -0.05276   -0.00845    0.05474
AFIX  43
HD1   2    0.243817    0.601756    0.052597    11.00000   -1.20000
AFIX   0
NE1   3    0.263178    0.643142    0.047073    11.00000    0.09840    0.14757 =
         0.12941   -0.03042    0.00636    0.05345
AFIX  43
HE1   2    0.249550    0.644677    0.043919    11.00000   -1.20000
AFIX   0
CE2   1    0.290514    0.664517    0.047781    11.00000    0.08624    0.13638 =
         0.13401   -0.03315    0.00897    0.05965
CZ2   1    0.303467    0.692690    0.043953    11.00000    0.11129    0.14203 =
         0.15794   -0.01845    0.00547    0.06642
AFIX  43
HZ2   2    0.293033    0.699822    0.040167    11.00000   -1.20000
AFIX   0
CH2   1    0.331992    0.709638    0.045910    11.00000    0.11031    0.12479 =
         0.15585    0.00279    0.03141    0.05609
AFIX  43
HH2   2    0.341089    0.728460    0.043458    11.00000   -1.20000
AFIX   0
CZ3   1    0.347128    0.698482    0.051567    11.00000    0.09601    0.13722 =
         0.17454   -0.01266    0.00402    0.04738
AFIX  43
HZ3   2    0.366401    0.710193    0.052803    11.00000   -1.20000
AFIX   0
CE3   1    0.334882    0.671007    0.055392    11.00000    0.09352    0.13170 =
         0.12463   -0.02081    0.00088    0.05582
AFIX  43
HE3   2    0.345656    0.664263    0.059174    11.00000   -1.20000
AFIX   0
CD2   1    0.305720    0.653057    0.053526    11.00000    0.09503    0.12885 =
         0.13566   -0.02766    0.01483    0.05877
 
RESI  216   ILE
N     3    0.341328    0.612219    0.042771    11.00000    0.10041    0.08206 =
         0.16343    0.01181    0.01106    0.04185
AFIX  43
H0    2    0.348564    0.611324    0.049785    11.00000   -1.20000
AFIX   0
CA    1    0.359230    0.627343    0.032332    11.00000    0.09846    0.06422 =
         0.14737   -0.01044    0.00550    0.03380
AFIX  13
HA    2    0.354840    0.641923    0.029785    11.00000   -1.20000
AFIX   0
C     1    0.353568    0.607832    0.021242    11.00000    0.09098    0.09237 =
         0.16152   -0.02411   -0.01520    0.05651
O     4    0.349887    0.613712    0.010501    11.00000    0.14027    0.10728 =
         0.14931   -0.01436   -0.00167    0.06567
CB    1    0.390703    0.642090    0.036050    11.00000    0.10051    0.07912 =
         0.13896   -0.01925    0.00750    0.04352
AFIX  13
HB    2    0.394397    0.627886    0.039770    11.00000   -1.20000
AFIX   0
CG1   1    0.398248    0.665427    0.045812    11.00000    0.12739    0.08118 =
         0.15082   -0.02731   -0.01317    0.05024
AFIX  23
HG1A  2    0.395867    0.680205    0.042018    11.00000   -1.20000
HG1B  2    0.384978    0.657620    0.052701    11.00000   -1.20000
AFIX   0
CG2   1    0.408793    0.653499    0.024385    11.00000    0.10177    0.13950 =
         0.15150   -0.00403    0.01496    0.06136
AFIX  33
HG2A  2    0.403873    0.638383    0.018557    11.00000   -1.50000
HG2B  2    0.428329    0.661752    0.026623    11.00000   -1.50000
HG2C  2    0.405617    0.667578    0.020597    11.00000   -1.50000
AFIX   0
CD1   1    0.427964    0.678581    0.051062    11.00000    0.12508    0.09419 =
         0.21859   -0.05987   -0.02453    0.04127
AFIX  33
HD1A  2    0.431030    0.693221    0.056879    11.00000   -1.50000
HD1B  2    0.441355    0.686450    0.044345    11.00000   -1.50000
HD1C  2    0.430287    0.664386    0.055281    11.00000   -1.50000
AFIX   0
 
RESI  217   LYS
N     3    0.353651    0.584033    0.023673    11.00000    0.13698    0.09250 =
         0.15826   -0.02282    0.00482    0.06878
AFIX  43
H0    2    0.354968    0.579715    0.031289    11.00000   -1.20000
AFIX   0
CA    1    0.351538    0.565268    0.013578    11.00000    0.14353    0.11543 =
         0.17495   -0.02840    0.02100    0.08088
AFIX  13
HA    2    0.366147    0.576354    0.007380    11.00000   -1.20000
AFIX   0
C     1    0.322936    0.553136    0.007211    11.00000    0.15479    0.10952 =
         0.14358   -0.04300    0.01612    0.06905
O     4    0.320283    0.551102   -0.004289    11.00000    0.19390    0.12240 =
         0.15067   -0.02280    0.01715    0.08249
CB    1    0.356904    0.541958    0.018553    11.00000    0.17566    0.08396 =
         0.27716   -0.04408   -0.01405    0.07278
AFIX  23
HB1   2    0.345122    0.533291    0.025842    11.00000   -1.20000
HB2   2    0.351480    0.527508    0.012187    11.00000   -1.20000
AFIX   0
CG    1    0.387427    0.552972    0.022085    11.00000    0.20896    0.22904 =
         0.17925   -0.01403   -0.02406    0.14346
AFIX  23
HG1   2    0.399138    0.561287    0.014744    11.00000   -1.20000
HG2   2    0.392945    0.567735    0.028302    11.00000   -1.20000
AFIX   0
CD    1    0.392827    0.530547    0.027218    11.00000    0.28306    0.25373 =
         0.25344    0.02073   -0.01875    0.17685
AFIX  23
HD1   2    0.379576    0.520781    0.033951    11.00000   -1.20000
HD2   2    0.411673    0.539515    0.030750    11.00000   -1.20000
AFIX   0
CE    1    0.390200    0.509214    0.017613    11.00000    0.39031    0.26974 =
         0.43038   -0.06951   -0.07456    0.22625
AFIX  23
HE1   2    0.370790    0.494035    0.016975    11.00000   -1.20000
HE2   2    0.396320    0.518013    0.009459    11.00000   -1.20000
AFIX   0
NZ    3    0.408645    0.498266    0.022052    11.00000    0.70134    0.26050 =
         0.60857   -0.06253   -0.19574    0.37148
AFIX  33
HZ1   2    0.408513    0.486134    0.016466    11.00000   -1.50000
HZ2   2    0.402287    0.489557    0.029364    11.00000   -1.50000
HZ3   2    0.426182    0.512550    0.022986    11.00000   -1.50000
AFIX   0
 
RESI  218   GLN
N     3    0.300351    0.544859    0.014189    11.00000    0.13299    0.11321 =
         0.16032   -0.00582    0.01138    0.06025
AFIX  43
H0    2    0.302107    0.546356    0.022199    11.00000   -1.20000
AFIX   0
CA    1    0.272462    0.533224    0.008641    11.00000    0.14298    0.08725 =
         0.17802   -0.01652   -0.01765    0.02833
AFIX  13
HA    2    0.270006    0.518541    0.002685    11.00000   -1.20000
AFIX   0
C     1    0.269011    0.555301    0.001519    11.00000    0.14155    0.10987 =
         0.18551   -0.03830   -0.02038    0.06279
O     4    0.256571    0.550247   -0.008504    11.00000    0.13268    0.10195 =
         0.18127   -0.02336   -0.01545    0.04269
CB    1    0.249735    0.519415    0.018712    11.00000    0.11328    0.22371 =
         0.22871    0.03399   -0.01832    0.01394
AFIX  23
HB1   2    0.254012    0.532348    0.025661    11.00000   -1.20000
HB2   2    0.231568    0.515019    0.015291    11.00000   -1.20000
AFIX   0
CG    1    0.248500    0.492248    0.023345    11.00000    0.33719    0.25789 =
         0.43874    0.19621   -0.00085    0.02245
AFIX  23
HG1   2    0.240099    0.477734    0.016969    11.00000   -1.20000
HG2   2    0.267417    0.495784    0.025014    11.00000   -1.20000
AFIX   0
CD    1    0.230992    0.482449    0.035210    11.00000    0.54042    0.33361 =
         0.41731    0.17562    0.05760    0.11068
OE1   4    0.229753    0.500409    0.041741    11.00000    0.58458    0.51600 =
         0.57295    0.00830   -0.00719    0.19757
NE2   3    0.218682    0.455154    0.037332    11.00000    0.73499    0.34886 =
         0.81999    0.27858    0.42316    0.04923
AFIX  93
HE2A  2    0.208408    0.448079    0.043895    11.00000   -1.20000
HE2B  2    0.220910    0.444385    0.032157    11.00000   -1.20000
AFIX   0
 
RESI  219   THR
N     3    0.280171    0.580658    0.006642    11.00000    0.12402    0.10327 =
         0.15428   -0.01813   -0.00384    0.04877
AFIX  43
H0    2    0.288743    0.583736    0.013713    11.00000   -1.20000
AFIX   0
CA    1    0.278279    0.603203    0.000641    11.00000    0.12416    0.11806 =
         0.12639   -0.03733   -0.01452    0.07157
AFIX  13
HA    2    0.258306    0.596421   -0.001067    11.00000   -1.20000
AFIX   0
C     1    0.293855    0.611676   -0.011776    11.00000    0.13062    0.09344 =
         0.12278   -0.04193   -0.01031    0.05027
O     4    0.283407    0.614118   -0.021614    11.00000    0.14029    0.13551 =
         0.13020   -0.00821    0.00647    0.06961
CB    1    0.288931    0.628701    0.009537    11.00000    0.13664    0.11618 =
         0.09635   -0.02486   -0.00783    0.06032
AFIX  13
HB    2    0.308371    0.634823    0.012058    11.00000   -1.20000
AFIX   0
OG1   4    0.271180    0.620843    0.020499    11.00000    0.15021    0.17319 =
         0.13855   -0.02768    0.02674    0.08752
AFIX  83
HG1   2    0.271510    0.607761    0.024082    11.00000   -1.50000
AFIX   0
CG2   1    0.287810    0.653107    0.003340    11.00000    0.13716    0.11287 =
         0.18486   -0.01789    0.00125    0.06989
AFIX  33
HG2A  2    0.294496    0.668614    0.009096    11.00000   -1.50000
HG2B  2    0.268712    0.647208    0.001004    11.00000   -1.50000
HG2C  2    0.299513    0.658920   -0.003998    11.00000   -1.50000
AFIX   0
 
RESI  220   ILE
N     3    0.319970    0.616159   -0.012061    11.00000    0.12801    0.09180 =
         0.12242   -0.02618   -0.00145    0.04059
AFIX  43
H0    2    0.327771    0.614609   -0.005348    11.00000   -1.20000
AFIX   0
CA    1    0.335387    0.623776   -0.023919    11.00000    0.12818    0.09811 =
         0.13430   -0.01569    0.00818    0.03185
AFIX  13
HA    2    0.334400    0.639867   -0.027350    11.00000   -1.20000
AFIX   0
C     1    0.321035    0.599711   -0.033256    11.00000    0.14455    0.09585 =
         0.11587   -0.00770    0.02881    0.04060
O     4    0.319522    0.605129   -0.044369    11.00000    0.13621    0.16024 =
         0.12020   -0.00251    0.02044    0.05351
CB    1    0.366828    0.633281   -0.022145    11.00000    0.14407    0.20773 =
         0.11683   -0.03029    0.00575    0.08248
AFIX  13
HB    2    0.375681    0.639414   -0.030392    11.00000   -1.20000
AFIX   0
CG1   1    0.373307    0.611114   -0.017737    11.00000    0.15266    0.20625 =
         0.23011   -0.03025   -0.02044    0.08341
AFIX  23
HG1A  2    0.371258    0.599113   -0.024810    11.00000   -1.20000
HG1B  2    0.359161    0.599471   -0.011605    11.00000   -1.20000
AFIX   0
CG2   1    0.380461    0.659476   -0.013682    11.00000    0.10438    0.15317 =
         0.14346    0.00705    0.01129    0.01630
AFIX  33
HG2A  2    0.376263    0.673365   -0.016874    11.00000   -1.50000
HG2B  2    0.400528    0.667154   -0.013541    11.00000   -1.50000
HG2C  2    0.373114    0.654280   -0.005341    11.00000   -1.50000
AFIX   0
CD1   1    0.402345    0.621297   -0.011942    11.00000    0.14038    0.31628 =
         0.62784    0.08115   -0.06874    0.08813
AFIX  33
HD1A  2    0.403768    0.605334   -0.009226    11.00000   -1.50000
HD1B  2    0.404826    0.633214   -0.004894    11.00000   -1.50000
HD1C  2    0.416689    0.631743   -0.018062    11.00000   -1.50000
AFIX   0
 
RESI  221   ALA
N     3    0.309956    0.573393   -0.029410    11.00000    0.14201    0.09494 =
         0.16015   -0.01778    0.01726    0.05592
AFIX  43
H0    2    0.310476    0.569915   -0.021591    11.00000   -1.20000
AFIX   0
CA    1    0.296777    0.550044   -0.038348    11.00000    0.12781    0.08870 =
         0.16798   -0.01204    0.01424    0.03692
AFIX  13
HA    2    0.310262    0.554008   -0.045158    11.00000   -1.20000
AFIX   0
C     1    0.270072    0.547376   -0.044095    11.00000    0.14040    0.10769 =
         0.17253   -0.02478    0.00457    0.05011
O     4    0.261762    0.535439   -0.054412    11.00000    0.17726    0.17419 =
         0.18651   -0.05971   -0.02097    0.07731
CB    1    0.290782    0.522545   -0.032268    11.00000    0.20053    0.10033 =
         0.17612   -0.02009   -0.00045    0.06964
AFIX  33
HB1   2    0.307918    0.524604   -0.028829    11.00000   -1.50000
HB2   2    0.283463    0.507796   -0.038429    11.00000   -1.50000
HB3   2    0.277170    0.517830   -0.025698    11.00000   -1.50000
AFIX   0
 
RESI  222   SER
N     3    0.256982    0.558258   -0.037791    11.00000    0.14960    0.11823 =
         0.16084   -0.02009   -0.00909    0.06307
AFIX  43
H0    2    0.264215    0.566906   -0.030870    11.00000   -1.20000
AFIX   0
CA    1    0.230919    0.556155   -0.042107    11.00000    0.14947    0.12040 =
         0.18296   -0.01275    0.00142    0.06626
AFIX  13
HA    2    0.222172    0.540804   -0.048230    11.00000   -1.20000
AFIX   0
C     1    0.235988    0.583390   -0.048319    11.00000    0.13724    0.11508 =
         0.19702   -0.00836    0.00415    0.06125
O     4    0.215628    0.585420   -0.051865    11.00000    0.14107    0.16353 =
         0.26025    0.04949    0.01854    0.07199
CB    1    0.210743    0.549117   -0.030964    11.00000    0.18511    0.16096 =
         0.18799    0.01693    0.02009    0.11167
AFIX  23
HB1   2    0.220780    0.560724   -0.023805    11.00000   -1.20000
HB2   2    0.195576    0.552659   -0.033122    11.00000   -1.20000
AFIX   0
OG    4    0.199763    0.520321   -0.028093    11.00000    0.22909    0.17474 =
         0.33608    0.07164    0.09766    0.11481
AFIX  83
HG    2    0.212707    0.517603   -0.026152    11.00000   -1.50000
AFIX   0
 
RESI  223   ASN
N     3    0.262293    0.604704   -0.049486    11.00000    0.14025    0.12769 =
         0.17538   -0.00679    0.01944    0.05775
AFIX  43
H0    2    0.276137    0.602322   -0.047399    11.00000   -1.20000
AFIX   0
CA    1    0.268089    0.632343   -0.054300    11.00000    0.13836    0.14193 =
         0.16269    0.01989   -0.00988    0.03371
AFIX  13
HA    2    0.250886    0.629744   -0.058355    11.00000   -1.20000
AFIX   0
CB    1    0.275768    0.654124   -0.043716    11.00000    0.11322    0.10014 =
         0.22014    0.01390   -0.00304    0.03154
AFIX  23
HB1   2    0.289407    0.653464   -0.038134    11.00000   -1.20000
HB2   2    0.284152    0.672954   -0.047233    11.00000   -1.20000
AFIX   0
CG    1    0.249312    0.647491   -0.036494    11.00000    0.11639    0.15141 =
         0.23157    0.00083   -0.01490    0.06211
OD1   4    0.233354    0.655722   -0.040480    11.00000    0.19842    0.22082 =
         0.29968    0.01473   -0.00295    0.14623
ND2   3    0.244067    0.632068   -0.026220    11.00000    0.12822    0.17203 =
         0.21268   -0.00167    0.01614    0.08271
AFIX  93
HD2A  2    0.228995    0.627296   -0.021967    11.00000   -1.20000
HD2B  2    0.255737    0.626833   -0.023806    11.00000   -1.20000
AFIX   0
C     1    0.291492    0.643777   -0.064064    11.00000    0.17361    0.21223 =
         0.17557    0.04077    0.01457    0.05427
OT1   4    0.298592    0.627335   -0.068408    11.00000    0.24205    0.29421 =
         0.24524    0.10909    0.08785    0.14634
OT2   4    0.301716    0.669161   -0.067167    11.00000    0.15513    0.19733 =
         0.23262    0.04659    0.02397    0.00986
 
RESI 1001   BAM
C1    1    0.635217    1.039277    0.153582    11.00000    0.27540    0.24442 =
         0.21897   -0.01527   -0.02426    0.14193
C2    1    0.626259    1.024956    0.142148    11.00000    0.42326    0.29274 =
         0.23023   -0.03094   -0.08757    0.23289
C3    1    0.610672    1.029285    0.133184    11.00000    0.41290    0.26436 =
         0.19161    0.01360   -0.03508    0.22696
C4    1    0.602830    1.049268    0.135543    11.00000    0.41482    0.24829 =
         0.24069   -0.03195   -0.06398    0.21418
C5    1    0.610940    1.063989    0.146746    11.00000    0.33621    0.29381 =
         0.28686   -0.08025   -0.10313    0.19637
C6    1    0.625739    1.058749    0.155908    11.00000    0.30850    0.28231 =
         0.29103   -0.05950   -0.08443    0.17930
C     1    0.651765    1.034998    0.162523    11.00000    0.20858    0.26055 =
         0.19137   -0.03261    0.00059    0.12904
N1    3    0.656627    1.014034    0.161169    11.00000    0.17076    0.19548 =
         0.17273    0.01824    0.02820    0.06885
N2    3    0.659686    1.050787    0.172873    11.00000    0.29629    0.26958 =
         0.35192   -0.15394   -0.14619    0.11741
 
RESI 1101   EDO
C1    1    0.797913    1.218319   -0.066677    11.00000    0.16793    0.16705 =
         0.21418   -0.02474    0.00888    0.08393
O1    4    0.787881    1.189879   -0.072793    11.00000    0.19782    0.17260 =
         0.17877   -0.01164    0.01180    0.11240
C2    1    0.775597    1.216220   -0.057442    11.00000    0.16865    0.15429 =
         0.16337   -0.02466   -0.01516    0.09392
O2    4    0.747711    1.208492   -0.063726    11.00000    0.14955    0.11512 =
         0.18681    0.01991   -0.00474    0.05163
 
RESI 1102   EDO
C1    1    0.557213    0.706263    0.155840    11.00000    0.41381    0.19084 =
         0.28091    0.00773   -0.02171    0.11923
O1    4    0.540119    0.677433    0.149166    11.00000    0.30378    0.19986 =
         0.22151    0.00701   -0.04306    0.16855
C2    1    0.551586    0.705291    0.170159    11.00000    0.40154    0.38396 =
         0.28009   -0.10043   -0.06752    0.16099
O2    4    0.534347    0.673148    0.173586    11.00000    0.31683    0.52807 =
         0.35685    0.17311   -0.01151    0.08625
 
RESI 1103   EDO
C1    1    0.636655    0.805754   -0.152293    11.00000    0.46271    0.25096 =
         0.43035   -0.12419   -0.14236    0.06376
O1    4    0.661012    0.835302   -0.156169    11.00000    0.75735    0.38447 =
         0.88157    0.06059   -0.10140   -0.05565
C2    1    0.644711    0.782932   -0.152218    11.00000    0.33030    0.37944 =
         0.39610   -0.27750   -0.00793    0.10689
O2    4    0.660597    0.782675   -0.140222    11.00000    0.34239    0.38274 =
         0.52421   -0.23526   -0.03162    0.21054
 
RESI 1104   EDO
C1    1    0.765418    1.109330   -0.111256    11.00000    0.26073    0.23864 =
         0.27348   -0.04955    0.06816    0.10954
O1    4    0.782833    1.120286   -0.123216    11.00000    0.24779    0.31438 =
         0.23293   -0.03766    0.02005    0.07767
C2    1    0.742488    1.078083   -0.112074    11.00000    0.22029    0.22611 =
         0.25068   -0.01584   -0.00794    0.13073
O2    4    0.725239    1.074367   -0.124040    11.00000    0.27260    0.36813 =
         0.24504    0.01058   -0.01864    0.14057
 
RESI 1105   EDO
C1    1    0.449740    0.973881    0.175599    11.00000    0.28991    0.18554 =
         0.27846   -0.00716   -0.00825    0.02902
O1    4    0.461033    1.000447    0.184008    11.00000    0.35633    0.22120 =
         0.30226   -0.02178    0.02699    0.14393
C2    1    0.433146    0.946692    0.183494    11.00000    0.21638    0.21223 =
         0.24433    0.01207    0.01954    0.12948
O2    4    0.405270    0.946244    0.187087    11.00000    0.25448    0.21686 =
         0.33758   -0.06378    0.02988    0.15264
 
RESI 1106   EDO
C1    1    0.226112    0.735797    0.024194    11.00000    0.25507    0.44617 =
         0.40675   -0.05472   -0.18437    0.07107
O1    4    0.254046    0.763847    0.021223    11.00000    0.25654    0.84632 =
         0.48172   -0.14099    0.05265   -0.08371
C2    1    0.203523    0.738811    0.016105    11.00000    0.29141    0.18699 =
         0.34657   -0.04756   -0.01016    0.17156
O2    4    0.208238    0.723830    0.004079    11.00000    0.13553    0.15218 =
         0.28754   -0.01896   -0.00473    0.07354
 
RESI 1201   SO4
S     5    0.572798    1.072825    0.104830    11.00000    0.41919    0.34448 =
         0.36483    0.06473   -0.11482    0.15501
O1    4    0.578367    1.101926    0.103461    11.00000    0.59459    0.29246 =
         0.80095    0.16577   -0.14924    0.08479
O2    4    0.558977    1.061126    0.117256    11.00000    0.49176    0.51657 =
         0.43388    0.17949   -0.04202    0.26086
O3    4    0.599604    1.071947    0.104189    11.00000    0.21643    0.36994 =
         0.62969   -0.11491   -0.16459   -0.03199
O4    4    0.553629    1.054356    0.094737    11.00000    0.29599    0.51412 =
         0.49055   -0.03760   -0.14984    0.17365
 
RESI 1301   CA2
CA    6    0.834643    1.144108   -0.052664    11.00000    0.12326    0.11454 =
         0.15486   -0.00403    0.03521    0.04728
 
RESI 2001   HOH
O     4    0.710318    0.967166    0.168631    11.00000    0.15997    0.16359 =
         0.17455    0.01863   -0.00899    0.07941
 
RESI 2002   HOH
O     4    0.696355    1.050036    0.052380    11.00000    0.06203    0.12563 =
         0.14078   -0.00691    0.01280    0.02332
 
RESI 2003   HOH
O     4    0.571251    0.853055    0.054104    11.00000    0.10894    0.11129 =
         0.18314    0.00599    0.02424    0.04173
 
RESI 2004   HOH
O     4    0.564553    0.778682    0.212881    11.00000    0.21581    0.19760 =
         0.16062    0.05913    0.03653    0.13017
 
RESI 2005   HOH
O     4    0.405756    0.786471    0.141687    11.00000    0.11412    0.14400 =
         0.12780   -0.01629   -0.01199    0.07039
 
RESI 2006   HOH
O     4    0.682090    0.997432    0.063743    11.00000    0.09896    0.06601 =
         0.17865   -0.00068    0.00344    0.03044
 
RESI 2007   HOH
O     4    0.517920    0.687077    0.126768    11.00000    0.11533    0.11853 =
         0.17031    0.01394    0.00413    0.06483
 
RESI 2008   HOH
O     4    0.889724    1.299653   -0.069926    11.00000    0.24163    0.15111 =
         0.14875   -0.01081   -0.03372    0.09793
 
RESI 2009   HOH
O     4    0.738231    0.893005    0.068533    11.00000    0.10478    0.15701 =
         0.17945    0.01280    0.02108    0.06907
 
RESI 2010   HOH
O     4    0.379563    0.865077    0.199577    11.00000    0.17904    0.24370 =
         0.17603   -0.01920   -0.01840    0.13923
 
RESI 2011   HOH
O     4    0.442740    0.844791    0.148620    11.00000    0.12097    0.15270 =
         0.13774    0.02560    0.00245    0.06384
 
RESI 2012   HOH
O     4    0.888224    1.265127   -0.088546    11.00000    0.20648    0.14537 =
         0.16336   -0.00415   -0.02279    0.09639
 
RESI 2013   HOH
O     4    0.719437    0.928341   -0.029699    11.00000    0.18378    0.11898 =
         0.19324    0.00979    0.06562    0.07299
 
RESI 2014   HOH
O     4    0.251126    0.854301    0.109732    11.00000    0.11043    0.20279 =
         0.18546   -0.03334   -0.00545    0.08611
 
RESI 2015   HOH
O     4    0.525468    0.954488   -0.119298    11.00000    0.26314    0.28168 =
         0.13596    0.01162   -0.00219    0.10857
 
RESI 2016   HOH
O     4    0.813188    1.127921    0.084963    11.00000    0.09795    0.12406 =
         0.18853   -0.00827   -0.01871    0.01796
 
RESI 2017   HOH
O     4    0.729048    0.996751   -0.022791    11.00000    0.11179    0.10073 =
         0.17237   -0.01957    0.00835    0.04768
 
RESI 2018   HOH
O     4    0.798252    1.152298   -0.059025    11.00000    0.11789    0.13815 =
         0.17750    0.00946    0.02135    0.07074
 
RESI 2019   HOH
O     4    0.195653    0.763671    0.094684    11.00000    0.20906    0.20703 =
         0.25398   -0.01160    0.02190    0.12984
 
RESI 2020   HOH
O     4    0.860639    1.121444   -0.048159    11.00000    0.10474    0.14935 =
         0.15937    0.00012    0.04494    0.04501
 
RESI 2021   HOH
O     4    0.775604    0.770498    0.115262    11.00000    0.27443    0.40646 =
         0.48668   -0.20186   -0.09118    0.12190
 
RESI 2022   HOH
O     4    0.856803    1.040823   -0.001413    11.00000    0.15219    0.14667 =
         0.26403    0.02073    0.06556    0.07524
 
RESI 2023   HOH
O     4    0.427514    0.817314    0.254014    11.00000    0.25156    0.32665 =
         0.14782    0.02527    0.00078    0.20420
 
RESI 2024   HOH
O     4    0.968487    1.138447    0.013658    11.00000    0.16783    0.28390 =
         0.19935    0.01005    0.02615    0.08940
 
RESI 2025   HOH
O     4    0.728776    1.017338    0.231703    11.00000    0.29849    0.30287 =
         0.19811   -0.02417   -0.05130    0.11175
 
RESI 2026   HOH
O     4    0.263489    0.930996    0.097002    11.00000    0.55604    0.37385 =
         0.32374    0.10939    0.02413    0.35284
 
RESI 2027   HOH
O     4    0.740836    1.140054   -0.036899    11.00000    0.09586    0.12603 =
         0.13890    0.01804    0.03603    0.04478
 
RESI 2028   HOH
O     4    0.697253    1.080710    0.208765    11.00000    0.20076    0.20355 =
         0.19375   -0.00447   -0.00368    0.08661
 
RESI 2029   HOH
O     4    0.434311    0.964637   -0.069580    11.00000    0.31630    0.29976 =
         0.26633    0.00514   -0.01920    0.16369
 
RESI 2030   HOH
O     4    0.695658    1.121849   -0.020145    11.00000    0.13925    0.08968 =
         0.14189   -0.00248    0.03164    0.05600
 
RESI 2031   HOH
O     4    0.800618    0.965655   -0.027655    11.00000    0.16715    0.13669 =
         0.33524    0.01691    0.06018    0.05822
 
RESI 2032   HOH
O     4    0.583431    0.750819   -0.120279    11.00000    0.18483    0.16950 =
         0.18547   -0.04387    0.04366    0.06571
 
RESI 2033   HOH
O     4    0.236971    0.673292    0.150753    11.00000    0.26450    0.16349 =
         0.22101    0.02346    0.03648    0.08453
 
RESI 2034   HOH
O     4    0.910249    1.011057    0.139557    11.00000    0.13587    0.24130 =
         0.29424    0.07278   -0.03851    0.05649
 
RESI 2035   HOH
O     4    0.294519    0.967114    0.133979    11.00000    0.37691    0.22652 =
         0.24504    0.02565    0.08182    0.19173
 
RESI 2036   HOH
O     4    0.584502    0.871131   -0.130118    11.00000    0.27177    0.34616 =
         0.26474   -0.01092    0.04980    0.10299
 
RESI 2037   HOH
O     4    0.357156    0.636924   -0.064881    11.00000    0.17482    0.18291 =
         0.19030   -0.08418    0.02420   -0.00243
 
RESI 2038   HOH
O     4    0.788328    0.907646    0.228980    11.00000    0.24481    0.22506 =
         0.24703    0.02644   -0.05030    0.12666
 
RESI 2039   HOH
O     4    0.638497    0.667656    0.117062    11.00000    0.15279    0.30688 =
         0.42267    0.10399    0.12140    0.14875
 
RESI 2040   HOH
O     4    0.920165    1.099034    0.026805    11.00000    0.11491    0.20508 =
         0.27282    0.00831    0.00247    0.07358
 
RESI 2041   HOH
O     4    0.360937    0.544046   -0.016113    11.00000    0.29016    0.24327 =
         0.22941   -0.02554   -0.02843    0.17576
 
RESI 2042   HOH
O     4    0.306056    0.571163    0.087482    11.00000    0.20466    0.17675 =
         0.19264    0.04444   -0.01477    0.02663
 
RESI 2043   HOH
O     4    0.732604    1.040140    0.207985    11.00000    0.20875    0.18011 =
         0.29458    0.01226    0.00268    0.10525
 
RESI 2044   HOH
O     4    0.776733    0.983489   -0.009184    11.00000    0.11895    0.15969 =
         0.21491    0.00864    0.01636    0.06067
 
RESI 2045   HOH
O     4    0.776867    0.928581    0.249514    11.00000    0.22611    0.33683 =
         0.27989    0.07625   -0.01676    0.18309
 
RESI 2046   HOH
O     4    0.547109    0.669212   -0.068467    11.00000    0.24261    0.16094 =
         0.16067   -0.05135    0.07316    0.05152
 
RESI 2047   HOH
O     4    0.743349    0.998324    0.198473    11.00000    0.16620    0.17221 =
         0.24496    0.02729   -0.00070    0.08109
 
RESI 2048   HOH
O     4    0.825725    0.983042    0.003374    11.00000    0.13933    0.17764 =
         0.22655    0.00768    0.04118    0.09118
 
RESI 2049   HOH
O     4    0.855363    1.079576   -0.065175    11.00000    0.14710    0.13902 =
         0.17855   -0.02510    0.03448    0.05693
 
RESI 2050   HOH
O     4    0.530884    1.019651    0.134244    11.00000    0.35632    0.16896 =
         0.26280   -0.03956   -0.05170    0.17832
 
RESI 2051   HOH
O     4    0.443930    0.811949    0.292701    11.00000    0.20141    0.26278 =
         0.23186    0.06759    0.03447    0.09819
 
RESI 2052   HOH
O     4    0.965881    1.167461   -0.022150    11.00000    0.21786    0.40470 =
         0.39124    0.21764    0.03586    0.11447
 
RESI 2053   HOH
O     4    0.353377    0.932831    0.070754    11.00000    0.24519    0.32863 =
         0.25000    0.07120    0.05985    0.19316
 
RESI 2054   HOH
O     4    0.770094    0.947193   -0.099599    11.00000    0.19710    0.17103 =
         0.21549   -0.00521    0.03741    0.11049
 
RESI 2055   HOH
O     4    0.118119    0.589929    0.067251    11.00000    0.23836    0.38153 =
         0.22347    0.03669    0.04652    0.13429
 
RESI 2056   HOH
O     4    0.799647    1.044625   -0.121942    11.00000    0.26656    0.29975 =
         0.27570    0.00236    0.08000    0.11876
 
RESI 2057   HOH
O     4    0.384489    0.784421    0.277998    11.00000    0.17560    0.15077 =
         0.16414    0.05349    0.04829    0.10906
 
RESI 2058   HOH
O     4    0.366849    0.957403    0.093960    11.00000    0.26485    0.12695 =
         0.33133    0.02150    0.05527    0.08194
 
RESI 2059   HOH
O     4    0.895006    1.146814    0.116946    11.00000    0.19384    0.26065 =
         0.22935    0.07316    0.00926    0.10549
 
RESI 2060   HOH
O     4    0.326430    0.814766    0.208407    11.00000    0.21916    0.21723 =
         0.20039   -0.00418    0.00665    0.11256
 
RESI 2061   HOH
O     4    0.784933    0.838060    0.055189    11.00000    0.24713    0.22028 =
         0.33329   -0.03797   -0.03238    0.16047
 
RESI 2062   HOH
O     4    0.615162    0.961029    0.148505    11.00000    0.17886    0.14264 =
         0.20981   -0.00516    0.01248    0.06759
 
RESI 2063   HOH
O     4    0.767930    0.765566    0.078765    11.00000    0.13836    0.23006 =
         0.57145    0.13257   -0.00436    0.10393
 
RESI 2064   HOH
O     4    0.788691    1.198183    0.044128    11.00000    0.38060    0.11182 =
         0.20342    0.01822   -0.05470    0.03557
 
RESI 2065   HOH
O     4    0.259026    0.790022    0.177241    11.00000    0.16956    0.16004 =
         0.25576    0.01788    0.04750    0.06799
 
RESI 2066   HOH
O     4    0.289165    0.777317    0.191572    11.00000    0.16911    0.21954 =
         0.15280    0.00751    0.04518    0.09858
 
RESI 2067   HOH
O     4    0.455005    0.706192    0.204903    11.00000    0.46693    0.25559 =
         0.53439    0.10443   -0.18329    0.16493
 
RESI 2068   HOH
O     4    0.275742    0.608019    0.092808    11.00000    0.21751    0.17670 =
         0.22803   -0.00191    0.03298    0.10596
 
RESI 2069   HOH
O     4    0.547260    1.074083    0.186430    11.00000    0.27842    0.23355 =
         0.30300    0.06679    0.09929    0.17290
 
RESI 2070   HOH
O     4    0.557364    1.021428   -0.107131    11.00000    0.33618    0.21814 =
         0.24426   -0.04053    0.01180    0.05904
 
RESI 2071   HOH
O     4    0.837824    1.290556    0.034162    11.00000    0.28821    0.18235 =
         0.28831    0.00414   -0.00907    0.11488
 
RESI 2072   HOH
O     4    0.546753    1.038721    0.160178    11.00000    0.34902    0.18663 =
         0.25444    0.00946    0.01934    0.13857
 
RESI 2073   HOH
O     4    0.538456    0.699450   -0.111284    11.00000    0.20430    0.15623 =
         0.14645   -0.02655    0.01128    0.08076
 
RESI 2074   HOH
O     4    0.208749    0.732111    0.144379    11.00000    0.15641    0.23773 =
         0.27151   -0.02806    0.07402    0.02862
 
RESI 2075   HOH
O     4    0.682952    1.019800   -0.121831    11.00000    0.29403    0.26717 =
         0.24646    0.07497    0.11746    0.13038
 
RESI 2076   HOH
O     4    0.635598    0.750854   -0.117908    11.00000    0.31847    0.23422 =
         0.28035   -0.07806    0.00524    0.15113
 
RESI 2077   HOH
O     4    0.565920    0.575853    0.096433    11.00000    0.17622    0.24234 =
         0.34247    0.09419    0.02751    0.12978
 
RESI 2078   HOH
O     4    0.769118    0.846862    0.233139    11.00000    0.31718    0.31209 =
         0.16087    0.01377   -0.01631    0.19392
 
RESI 2079   HOH
O     4    0.238626    0.760843   -0.012441    11.00000    0.29843    0.46463 =
         0.28694    0.12661    0.02939    0.23464
 
RESI 2080   HOH
O     4    0.719982    0.801486    0.230465    11.00000    0.23666    0.25509 =
         0.21832    0.02871   -0.00827    0.16558
 
RESI 2081   HOH
O     4    0.731371    0.786526    0.003725    11.00000    0.49614    0.38429 =
         0.33205   -0.06916    0.08083    0.27949
 
RESI 2082   HOH
O     4    0.239840    0.743307    0.163986    11.00000    0.16018    0.21715 =
         0.26828   -0.03052    0.00824    0.08819
 
RESI 2083   HOH
O     4    0.648205    0.649118    0.226253    11.00000    0.34153    0.28717 =
         0.32926    0.08014    0.03385    0.16784
 
RESI 2084   HOH
O     4    0.262845    0.640010    0.159370    11.00000    0.20279    0.32606 =
         0.35275    0.03128    0.03548    0.04253
 
RESI 2085   HOH
O     4    0.897887    1.267514    0.086568    11.00000    0.31282    0.21147 =
         0.23254   -0.02668    0.00088    0.04347
 
RESI 2086   HOH
O     4    0.383146    0.911068    0.207626    11.00000    0.25944    0.24560 =
         0.19945   -0.00695   -0.03251    0.14186
 
RESI 2087   HOH
O     4    0.808270    0.835700    0.224511    11.00000    0.40969    0.35939 =
         0.25845    0.03374   -0.00988    0.27460
 
RESI 2088   HOH
O     4    0.382678    0.852277    0.310462    11.00000    0.19272    0.31588 =
         0.55188    0.12423    0.05464    0.08894
 
RESI 2089   HOH
O     4    0.632951    0.907414    0.283848    11.00000    0.40197    0.43240 =
         0.20564   -0.01297   -0.08458    0.23250
 
RESI 2090   HOH
O     4    0.901458    1.073266   -0.058305    11.00000    0.18675    0.18635 =
         0.34325    0.05381    0.07757    0.07686
 
RESI 2091   HOH
O     4    0.672455    0.739101   -0.049260    11.00000    0.29576    0.18316 =
         0.24097   -0.03912    0.04550    0.14171
 
RESI 2092   HOH
O     4    0.574530    1.117289    0.214457    11.00000    0.31245    0.20279 =
         0.73814   -0.00050   -0.17618    0.17978
 
RESI 2093   HOH
O     4    0.337744    0.895834    0.222378    11.00000    0.28926    0.18950 =
         0.27641    0.02140    0.06466    0.07998
 
RESI 2094   HOH
O     4    0.821849    0.866685    0.036235    11.00000    0.35278    0.31637 =
         0.40219    0.14058    0.17740    0.23184
 
RESI 2095   HOH
O     4    0.793913    1.173168   -0.132906    11.00000    0.30344    0.32372 =
         0.21221   -0.02354    0.01264    0.08710
 
RESI 2096   HOH
O     4    1.006828    1.116828   -0.000399    11.00000    0.15877    0.45236 =
         0.43035    0.13718    0.01884    0.03741
 
RESI 2097   HOH
O     4    0.386780    0.557773    0.140726    11.00000    0.41731    0.20381 =
         0.49719    0.03782   -0.08889    0.15922
 
RESI 2098   HOH
O     4    0.402028    0.605232    0.172549    11.00000    0.37658    0.27148 =
         0.31358    0.10511   -0.06859    0.12077
 
RESI 2099   HOH
O     4    0.351377    0.942759    0.242272    11.00000    0.61824    0.77692 =
         0.38412   -0.10119    0.18684    0.19324
 
RESI 2100   HOH
O     4    0.280381    0.677782    0.186554    11.00000    0.26017    0.39809 =
         0.56067   -0.05884    0.23160    0.08142
 
RESI 2101   HOH
O     4    0.980660    1.232876   -0.015064    11.00000    0.20680    0.35725 =
         0.34398    0.05566    0.02040    0.13170
 
RESI 2102   HOH
O     4    0.524930    0.617404    0.014761    11.00000    0.26829    0.20385 =
         0.30310   -0.04993   -0.00082    0.11018
 
RESI 2103   HOH
O     4    0.248717    0.560320   -0.075479    11.00000    0.42079    0.35157 =
         0.31828   -0.11914   -0.05610    0.19820
 
RESI 2104   HOH
O     4    0.940299    1.067373    0.143582    11.00000    0.20142    0.30753 =
         0.41219    0.03719    0.00398    0.12696
 
RESI 2105   HOH
O     4    0.435753    0.752090   -0.104796    11.00000    0.64326    0.32775 =
         0.18748   -0.04838   -0.03592    0.01366
 
RESI 2106   HOH
O     4    0.773886    0.851323    0.258434    11.00000    0.31229    0.29614 =
         0.30581    0.00444   -0.03081    0.18301
 
RESI 2107   HOH
O     4    0.696636    0.615333    0.119592    11.00000    0.46111    0.21831 =
         0.54973    0.05615   -0.06880    0.17665
 
RESI 2108   HOH
O     4    0.850567    1.217925   -0.129509    11.00000    0.37656    0.18444 =
         0.29174    0.01997   -0.01762    0.12880
 
RESI 2109   HOH
O     4    0.696675    1.235455    0.054854    11.00000    0.49482    0.32789 =
         0.42640    0.00788   -0.06430    0.27025
 
RESI 2110   HOH
O     4    0.370710    0.769197   -0.099665    11.00000    0.41660    0.23411 =
         0.23584    0.01339    0.05330    0.13251
 
RESI 2111   HOH
O     4    0.720271    0.773714   -0.063641    11.00000    0.35058    0.14594 =
         0.31093   -0.01572    0.13029    0.08599
 
RESI 2112   HOH
O     4    0.912809    1.201582    0.141816    11.00000    0.23116    0.22641 =
         0.31227    0.05598   -0.05720    0.08501
 
RESI 2113   HOH
O     4    0.957712    1.117396   -0.051515    11.00000    0.37233    0.30089 =
         0.47828    0.11985    0.05809    0.14540
 
RESI 2114   HOH
O     4    0.648101    0.641582    0.157574    11.00000    0.24665    0.34106 =
         0.42332    0.08136    0.05093    0.20194
 
RESI 2115   HOH
O     4    0.349119    0.537008    0.094083    11.00000    0.35101    0.28366 =
         0.38361    0.04298   -0.03226    0.05618
 
RESI 2116   HOH
O     4    0.552443    0.567418    0.054460    11.00000    0.31197    0.23413 =
         0.49845   -0.04459   -0.04547    0.13897
 
RESI 2117   HOH
O     4    0.683147    0.795715    0.251354    11.00000    0.30073    0.27016 =
         0.31717    0.01788    0.04151    0.12929
 
RESI 2118   HOH
O     4    0.747878    0.869344   -0.127213    11.00000    0.35459    0.39941 =
         0.37404   -0.06685    0.02829    0.22394
 
RESI 2119   HOH
O     4    0.130626    0.646753    0.100368    11.00000    0.56368    0.31036 =
         0.35045    0.14109   -0.03540    0.11565
 
RESI 2120   HOH
O     4    0.639031    0.909037   -0.123839    11.00000    0.35553    0.33650 =
         0.33083   -0.03683    0.10502    0.13901
 
RESI 2121   HOH
O     4    0.942096    1.202248    0.115265    11.00000    0.26367    0.58122 =
         0.42204    0.03815    0.00302    0.18061
 
RESI 2122   HOH
O     4    0.185201    0.764283    0.147251    11.00000    0.23473    0.39130 =
         0.44947   -0.07736    0.05336    0.11363
 
RESI 2123   HOH
O     4    0.990360    1.174001   -0.087361    11.00000    0.16022    0.43473 =
         0.44972   -0.00933    0.04655    0.08061
 
RESI 2124   HOH
O     4    0.789534    0.743883    0.158584    11.00000    0.34914    0.32316 =
         0.44257    0.10202    0.10097    0.24149
 
RESI 2125   HOH
O     4    0.546393    0.669821    0.004863    11.00000    0.35152    0.16870 =
         0.36346   -0.03774   -0.06671    0.09063
 
RESI 2126   HOH
O     4    0.673505    0.699253    0.017425    11.00000    0.31544    0.37888 =
         0.84269    0.10451    0.10548    0.28693
 
RESI 2127   HOH
O     4    0.633860    1.180277    0.043842    11.00000    0.39482    0.28314 =
         0.27876   -0.03757   -0.00428    0.18952
 
RESI 2128   HOH
O     4    0.916744    1.180332    0.184582    11.00000    0.43696    0.42284 =
         0.18050   -0.01888    0.01123    0.12202
 
RESI 2129   HOH
O     4    0.605604    1.075460    0.078700    11.00000    0.34427    0.30885 =
         0.26856    0.03040   -0.05321    0.00828
 
RESI 2130   HOH
O     4    0.820908    1.097923   -0.115875    11.00000    0.26402    0.28506 =
         0.35428   -0.05791    0.04173    0.09862
 
RESI 2131   HOH
O     4    0.327336    0.693489    0.228119    11.00000    0.52483    0.33437 =
         0.34654    0.06414    0.21922    0.12592
 
RESI 2132   HOH
O     4    0.554782    0.681459    0.241204    11.00000    0.44317    0.27488 =
         0.57481    0.05383    0.05182    0.22360
 
RESI 2133   HOH
O     4    0.951541    1.121936    0.175406    11.00000    0.41843    0.34626 =
         0.59663    0.02600   -0.14703    0.20994
 
RESI 2134   HOH
O     4    0.224505    0.806134    0.190393    11.00000    0.24739    0.37013 =
         0.21203   -0.03307   -0.00230    0.17208
 
RESI 2135   HOH
O     4    0.731443    1.193106    0.197814    11.00000    0.28727    0.24035 =
         0.36490   -0.07817   -0.03777    0.13523
 
RESI 2136   HOH
O     4    0.216318    0.493864   -0.012943    11.00000    0.40498    0.41638 =
         0.22989   -0.02275    0.00163    0.06975
 
RESI 2137   HOH
O     4    0.362604    0.943099   -0.054074    11.00000    0.21615    0.41709 =
         0.51329   -0.06817    0.02958    0.05557
 
RESI 2138   HOH
O     4    0.950418    0.912067   -0.074224    11.00000    0.29751    0.39692 =
         0.74913    0.03202    0.10915    0.18985
 
RESI 2139   HOH
O     4    0.749309    0.883308    0.266184    11.00000    0.46538    0.28093 =
         0.33611    0.06939   -0.03950    0.21328
 
RESI 2140   HOH
O     4    0.380202    0.797289   -0.123935    11.00000    0.22895    0.51848 =
         0.34467   -0.03779   -0.06442    0.12225
 
RESI 2141   HOH
O     4    0.707632    1.206887    0.138296    11.00000    0.25470    0.25510 =
         0.45213   -0.02874   -0.06059    0.06828
 
RESI 2142   HOH
O     4    0.843359    0.921044    0.232607    11.00000    0.25415    0.51545 =
         0.40037    0.10043   -0.01817    0.25370
 
RESI 2143   HOH
O     4    0.267814    0.637905    0.130675    11.00000    0.45184    0.27376 =
         0.40726    0.06864   -0.05655    0.05075
 
RESI 2144   HOH
O     4    0.611155    0.687319    0.257274    11.00000    0.47915    0.51790 =
         0.58887    0.05518    0.09579    0.28225
 
RESI 2145   HOH
O     4    0.404340    0.939591   -0.030666    11.00000    0.38890    0.42842 =
         0.51529   -0.14434   -0.09519    0.30320
 
RESI 2146   HOH
O     4    0.892791    0.955719    0.056105    11.00000    0.28003    0.64504 =
         0.44168    0.06566    0.05588    0.20357
 
RESI 2147   HOH
O     4    0.378038    1.029071    0.034157    11.00000    0.50113    0.51362 =
         0.32952   -0.11074    0.00417    0.29279
 
RESI 2148   HOH
O     4    0.685428    0.837491    0.264140    11.00000    0.37991    0.48507 =
         0.56034   -0.05128   -0.01988    0.30804
 
RESI 2149   HOH
O     4    0.362341    1.027759    0.006059    11.00000    0.32067    0.52565 =
         0.42932   -0.11167   -0.05926    0.27513
 
RESI 2150   HOH
O     4    0.530712    1.124723    0.041269    11.00000    0.32211    0.37445 =
         0.28558   -0.03178    0.07038    0.22513
 
RESI 2151   HOH
O     4    1.010834    1.196291    0.015869    11.00000    0.23529    0.37202 =
         0.36773    0.08912    0.02905    0.08503
 
RESI 2152   HOH
O     4    0.566170    1.218707   -0.027550    11.00000    0.43950    0.26332 =
         0.50145    0.03955    0.10445    0.16451
 
RESI 2153   HOH
O     4    0.531818    0.699989    0.197118    11.00000    0.54950    0.37953 =
         0.36818    0.00129   -0.01916    0.18680
 
RESI 2154   HOH
O     4    0.456389    0.608312   -0.002228    11.00000    0.63598    0.60929 =
         0.62523   -0.05550   -0.04182    0.31388
 
RESI 2155   HOH
O     4    0.539901    0.691156    0.271107    11.00000    0.32792    0.52632 =
         0.47072   -0.02706    0.01004    0.29531
 
RESI 2156   HOH
O     4    0.513599    0.842772    0.325136    11.00000    0.28078    0.40506 =
         0.29037   -0.01465    0.12430    0.01463
 
RESI 2157   HOH
O     4    0.826384    0.980497    0.251500    11.00000    0.36415    0.57489 =
         0.41370   -0.15016   -0.01004    0.32594
 
RESI 2158   HOH
O     4    0.599091    0.689476   -0.050797    11.00000    0.53219    0.36875 =
         0.32598   -0.15001   -0.01957    0.21639
 
RESI 2159   HOH
O     4    0.383202    0.837193   -0.139246    11.00000    0.21967    0.54912 =
         0.42085    0.00118   -0.02190    0.15361
 
RESI 2160   HOH
O     4    0.606916    0.604164    0.110854    11.00000    0.51346    0.20515 =
         0.41555    0.03823   -0.08727    0.15931
 
RESI 2161   HOH
O     4    0.297037    0.590715    0.227726    11.00000    0.33547    0.21963 =
         0.49658    0.05674   -0.15430    0.09245
 
RESI 2162   HOH
O     4    0.862594    1.270681    0.019613    10.50000    0.54002    0.29053 =
         0.32895   -0.10642   -0.18904    0.28828
 
RESI 2163   HOH
O     4    0.497425    0.986540   -0.130006    11.00000    0.77501    0.63750 =
         0.54968    0.11932   -0.03772    0.29878
 
RESI 2164   HOH
O     4    0.975688    1.307734   -0.089120    11.00000    0.44475    0.42900 =
         0.30767    0.13860    0.02657    0.17335
 
RESI 2165   HOH
O     4    0.709237    1.115166    0.271672    11.00000    0.47704    0.42110 =
         0.35506    0.05800    0.03880    0.26628
 
RESI 2166   HOH
O     4    0.941420    1.025304   -0.052432    11.00000    0.27762    0.34919 =
         0.51930    0.08267    0.12271    0.17371
 
RESI 2167   HOH
O     4    0.798098    1.168954    0.255015    11.00000    0.48523    0.30901 =
         0.52499    0.00414   -0.17559    0.10675
 
RESI 2168   HOH
O     4    1.019917    1.163769    0.088892    11.00000    0.20865    0.33790 =
         0.40536    0.05597   -0.01820   -0.05528
 
RESI 2169   HOH
O     4    0.769970    0.770845    0.047338    11.00000    0.25076    0.40945 =
         0.38805    0.08965    0.00938    0.00581
 
RESI 2170   HOH
O     4    0.900230    0.988315    0.164213    11.00000    0.33516    0.41062 =
         0.41776    0.04622    0.09222    0.21305
 
RESI 2171   HOH
O     4    0.693204    0.730104   -0.026496    11.00000    0.46689    0.25081 =
         0.62849   -0.16871    0.11364    0.19757
 
RESI 2172   HOH
O     4    0.688746    0.641742    0.056977    11.00000    0.35484    0.36604 =
         0.41463    0.00010    0.06485    0.15675
 
RESI 2173   HOH
O     4    0.506941    1.039760   -0.082535    11.00000    0.43515    0.49272 =
         0.39463   -0.09321   -0.14458    0.18438
 
RESI 2174   HOH
O     4    0.572566    1.187921   -0.066184    11.00000    0.35822    0.31685 =
         0.40332   -0.04511   -0.07380    0.09477
 
RESI 2175   HOH
O     4    0.181208    0.506763    0.003402    11.00000    0.63322    0.45357 =
         0.65380    0.06495   -0.04336    0.36244
 
RESI 2176   HOH
O     4    0.499446    0.781842   -0.148662    11.00000    0.51457    0.41858 =
         0.51740   -0.26246   -0.18286    0.29165
 
RESI 2177   HOH
O     4    0.639759    0.627679    0.134540    11.00000    0.45352    0.40632 =
         0.32540    0.04018    0.00168    0.32444
 
RESI 2178   HOH
O     4    0.464817    0.945460    0.261438    11.00000    0.48866    0.26956 =
         0.32890    0.00343   -0.16117    0.07627
 
RESI 2179   HOH
O     4    0.752423    0.984553    0.298960    11.00000    0.69556    0.64694 =
         0.28153   -0.00636   -0.20028    0.30966
 
RESI 2180   HOH
O     4    0.288614    0.477239    0.007830    11.00000    0.52862    0.41490 =
         0.39213   -0.10598    0.00515    0.18448
 
RESI 2181   HOH
O     4    0.772490    0.788703   -0.013148    11.00000    0.47491    0.58912 =
         0.53282   -0.02948   -0.16289    0.26207
 
RESI 2182   HOH
O     4    0.462645    0.743535   -0.133958    11.00000    0.46906    0.60002 =
         0.43773   -0.10435   -0.09662    0.37951
 
RESI 2183   HOH
O     4    0.949963    0.989700    0.131086    11.00000    0.31759    0.46913 =
         0.54020    0.05964   -0.07399    0.24932
 
RESI 2184   HOH
O     4    0.941728    1.278229    0.119640    11.00000    0.29970    0.46199 =
         0.39929   -0.07827   -0.10184    0.07360
 
RESI 2185   HOH
O     4    0.781628    1.233343    0.034094    11.00000    0.59818    0.38536 =
         0.46058   -0.02144   -0.18338    0.22038
 
RESI 2186   HOH
O     4    0.278648    0.609732    0.117962    11.00000    0.67246    0.47646 =
         0.40897   -0.06942    0.00601    0.24945
 
RESI 2187   HOH
O     4    0.515661    1.064186    0.080999    11.00000    0.37596    0.38233 =
         0.69778    0.10323   -0.05215    0.23298
 
RESI 2188   HOH
O     4    0.702486    1.011739    0.344146    11.00000    2.00000    2.00000 =
         2.00000   -0.00837    0.00305    1.06876
 
RESI 2189   HOH
O     4    0.562707    0.811319   -0.143670    11.00000    0.59411    0.28701 =
         0.26821   -0.07857    0.05775    0.16246
 
RESI 2190   HOH
O     4    0.159041    0.576810   -0.050010    11.00000    0.24563    0.57105 =
         0.39903   -0.04206    0.00239    0.22819
 
RESI 2191   HOH
O     4    0.439164    1.027341    0.098216    11.00000    0.53299    0.50328 =
         0.62780   -0.09330   -0.10035    0.27917
 
RESI 2192   HOH
O     4    0.219181    0.544405    0.055189    11.00000    0.37186    0.34804 =
         0.58003    0.13576   -0.02057    0.17041
 
RESI 2193   HOH
O     4    1.014280    1.155685   -0.021021    11.00000    0.48659    0.55046 =
         0.58290    0.09471   -0.01897    0.29644
 
RESI 2194   HOH
O     4    0.304206    0.667501    0.210733    11.00000    0.24962    0.54403 =
         0.50514    0.00399    0.12767    0.21746
 
RESI 2195   HOH
O     4    0.295316    0.614569    0.138079    11.00000    0.43481    0.40943 =
         0.58096    0.10688    0.12289    0.13996
 
RESI 2196   HOH
O     4    0.855118    1.105832    0.281647    11.00000    0.55953    0.50401 =
         0.45398   -0.08077    0.01185    0.25902
 
RESI 2197   HOH
O     4    0.574912    1.103593    0.248036    11.00000    0.58952    0.35215 =
         0.60011   -0.24175    0.01865    0.21436
 
RESI 2198   HOH
O     4    0.432842    0.792249   -0.147461    11.00000    0.52048    0.48534 =
         0.27349   -0.18474   -0.13061    0.19762
 
RESI 2199   HOH
O     4    0.775341    0.958558   -0.120732    11.00000    0.58888    0.53412 =
         0.45381   -0.08414    0.07554    0.30540
 
RESI 2200   HOH
O     4    1.000291    1.330048   -0.055068    11.00000    0.36463    0.45748 =
         0.75409    0.07688    0.15334    0.17555
 
RESI 2201   HOH
O     4    0.650478    0.621712    0.036477    11.00000    0.30637    0.43372 =
         0.45805    0.06289    0.09380    0.25911
 
RESI 2202   HOH
O     4    0.391814    0.930241    0.275704    11.00000    0.70675    0.52418 =
         0.71031    0.01966   -0.02581    0.44754
 
RESI 2203   HOH
O     4    0.869724    0.910028    0.193785    11.00000    0.54635    0.63986 =
         0.53546   -0.10370   -0.00081    0.31995
 
RESI 2204   HOH
O     4    0.336797    0.589120    0.175209    11.00000    0.61368    0.24044 =
         0.47925    0.08730    0.03762    0.14487
 
RESI 2205   HOH
O     4    0.991727    1.219718   -0.077928    11.00000    0.26818    0.45712 =
         0.47833   -0.15927    0.09604    0.06112
 
RESI 2206   HOH
O     4    0.502833    1.068884    0.058448    11.00000    0.43970    0.47197 =
         0.47436    0.07599    0.16263    0.24495
 
RESI 2207   HOH
O     4    0.520881    0.913744   -0.135279    11.00000    0.67056    0.40051 =
         0.25116   -0.12259    0.01097    0.27558
 
RESI 2208   HOH
O     4    0.518391    0.614302   -0.029608    11.00000    0.68517    0.47650 =
         0.59933   -0.08028   -0.02381    0.39639
 
RESI 2209   HOH
O     4    0.983890    1.037409   -0.017260    11.00000    0.28390    0.46798 =
         0.54451   -0.01129    0.03475    0.19885
 
RESI 2210   HOH
O     4    0.524192    0.903138    0.317357    11.00000    0.55083    0.28337 =
         0.35040   -0.14129   -0.12534    0.19502
 
RESI 2211   HOH
O     4    0.635815    0.772137    0.288833    11.00000    0.43170    0.60357 =
         0.48561    0.00622   -0.12466    0.30246
 
RESI 2212   HOH
O     4    0.868325    1.139718   -0.131690    11.00000    0.50707    0.33304 =
         0.45931   -0.04872    0.05987    0.22444
 
RESI 2213   HOH
O     4    0.966748    1.168261    0.141154    11.00000    0.24247    0.41488 =
         0.39743    0.00322    0.09176    0.05638
 
RESI 2214   HOH
O     4    0.191392    0.550053   -0.074360    10.50000    0.35445    0.56915 =
         0.48664    0.04782   -0.21838    0.25877
 
RESI 2215   HOH
O     4    0.864698    1.155238    0.252409    11.00000    0.70400    0.41940 =
         0.56727   -0.03204   -0.04005    0.17234
 
RESI 2216   HOH
O     4    0.623223    0.982388    0.294544    11.00000    0.78652    0.74158 =
         0.75541   -0.00309    0.05554    0.35645
 
RESI 2217   HOH
O     4    1.022770    1.232606    0.030239    11.00000    0.30888    0.52891 =
         0.55667   -0.01900   -0.10718    0.15456
 
RESI 2218   HOH
O     4    0.493376    1.096659   -0.047952    11.00000    0.41435    0.65295 =
         0.52558    0.10772   -0.10311    0.26956
 
RESI 2219   HOH
O     4    0.990064    1.270451    0.024101    11.00000    0.41740    0.39854 =
         0.46311    0.00425   -0.05065    0.05823
 
RESI 2220   HOH
O     4    0.281442    0.617028    0.211616    11.00000    0.61395    0.84531 =
         0.79720   -0.02016    0.14288    0.32404
 
RESI 2221   HOH
O     4    0.558947    0.584822    0.010308    11.00000    0.55787    0.42635 =
         0.64536   -0.08460   -0.00424    0.17503
 
RESI 2222   HOH
O     4    0.571689    0.630689    0.218194    11.00000    0.51445    0.60460 =
         0.41243   -0.00355   -0.07992    0.20191
 
RESI 2223   HOH
O     4    0.436258    1.010162    0.119770    11.00000    0.38379    0.26636 =
         0.44967   -0.04280    0.00137    0.14722
 
RESI 2224   HOH
O     4    0.996328    0.996328    0.000000    10.50000    0.42142    0.42142 =
         0.52856    0.02818   -0.02818    0.26520
 
RESI 2225   HOH
O     4    1.034638    1.222501    0.056390    10.50000    0.34758    0.17140 =
         0.47537   -0.01578    0.00338    0.13974
 
RESI 2226   HOH
O     4    0.676041    0.742681    0.262779    11.00000    0.40149    0.62911 =
         0.62527    0.07659   -0.04026    0.35032
 
RESI 2227   HOH
O     4    1.001807    1.279128   -0.053947    11.00000    0.45367    0.68122 =
         0.87466    0.05571   -0.07922    0.36694
 
RESI 2228   HOH
O     4    0.532799    1.080057   -0.062108    11.00000    0.51349    0.38416 =
         0.52387   -0.00539    0.04583    0.24217
 
RESI 2229   HOH
O     4    0.844546    0.982387   -0.117305    11.00000    0.46630    0.56079 =
         0.62649   -0.15964    0.12094    0.30377
 
RESI 2230   HOH
O     4    0.418640    0.567351   -0.009534    11.00000    0.51781    0.37437 =
         0.31941   -0.02515   -0.05553    0.20832
 
RESI 2231   HOH
O     4    0.578750    0.812053    0.310438    10.50000    0.51667    0.40273 =
         0.21661    0.00239    0.00467    0.19263
 
RESI 2232   HOH
O     4    0.315319    0.568875    0.152626    10.50000    0.42777    0.32624 =
         0.36259    0.02020   -0.04493    0.23469
 
RESI 2233   HOH
O     4    0.478537    1.022895    0.129350    11.00000    0.44773    0.44244 =
         0.52576   -0.00370    0.00965    0.25295
 
RESI 2234   HOH
O     4    0.317220    0.491701    0.109057    10.50000    0.55038    0.39995 =
         0.40887    0.15249   -0.12925    0.24802
 
RESI 2235   HOH
O     4    0.593227    0.636995    0.237640    11.00000    0.67156    0.46781 =
         0.61111    0.03258    0.23924    0.32171
 
RESI 2236   HOH
O     4    0.578191    1.000340   -0.125018    11.00000    0.46070    0.61155 =
         0.52517    0.06715   -0.04391    0.26857
 
RESI 2237   HOH
O     4    0.671147    0.900367   -0.146220    11.00000    0.62546    0.60383 =
         0.55832    0.08067   -0.00313    0.28481
 
RESI 2238   HOH
O     4    0.830067    0.901493    0.260473    11.00000    0.48718    0.62606 =
         0.41130   -0.10113   -0.10987    0.27166
 
RESI 2239   HOH
O     4    0.316070    0.475019    0.036567    11.00000    0.64447    0.50229 =
         0.56825    0.04369    0.09532    0.31353
 
RESI 2240   HOH
O     4    0.851276    0.888014    0.212554    11.00000    0.31399    0.32455 =
         0.48711    0.04257   -0.02598    0.10720
 
RESI 2241   HOH
O     4    0.693891    1.204466   -0.042358    11.00000    0.28814    0.23516 =
         0.30866    0.09779    0.19279    0.13137
 
RESI 2242   HOH
O     4    0.784822    1.229750   -0.032452    10.50000    2.00000    2.00000 =
         2.00000   -0.02285    0.03624    1.48968
 
RESI 2243   HOH
O     4    0.692795    1.215677    0.024570    11.00000    0.36290    0.28601 =
         0.30905    0.04011    0.05343    0.15449
 
RESI 2244   HOH
O     4    0.379252    0.973339    0.119569    11.00000    0.51565    0.43176 =
         0.34212   -0.08796   -0.06295    0.19629
 
RESI 2245   HOH
O     4    0.477518    0.544446    0.045791    11.00000    0.48946    0.46526 =
         0.43870   -0.17841   -0.17347    0.22961
 
RESI 2246   HOH
O     4    0.563237    1.096454    0.162939    11.00000    0.53544    0.29083 =
         0.43930   -0.02778   -0.09326    0.22527
 
RESI 2247   HOH
O     4    0.894471    0.979531    0.235874    11.00000    0.50601    0.43751 =
         0.49702   -0.07937   -0.19117    0.27439
 
RESI 2248   HOH
O     4    0.177078    0.753668    0.114505    11.00000    0.62025    0.39608 =
         0.39179   -0.03765   -0.12677    0.34114
 
RESI 2249   HOH
O     4    0.366118    0.664410    0.230591    11.00000    0.54174    0.58965 =
         0.35241   -0.10687    0.12291    0.11342
 
RESI 2250   HOH
O     4    0.651102    0.968283   -0.132903    11.00000    0.69471    0.32147 =
         0.49187   -0.09330   -0.03958    0.21651
 
RESI 2251   HOH
O     4    1.003475    1.091074    0.134687    11.00000    0.53043    0.60912 =
         0.45496   -0.07613   -0.32777    0.17593
 
RESI 2252   HOH
O     4    0.852044    1.182182   -0.142879    11.00000    0.54384    0.52992 =
         0.41340   -0.24679    0.01735    0.24599
 
RESI 2253   HOH
O     4    0.339676    0.902576   -0.065601    11.00000    0.65049    0.66360 =
         0.72231   -0.07210    0.02575    0.41801
 
RESI 2254   HOH
O     4    0.950050    1.257689    0.044453    11.00000    0.63574    0.54030 =
         0.54947    0.02429    0.08065    0.35594
 
RESI 2255   HOH
O     4    0.788912    0.815864    0.085760    11.00000    0.52985    0.69461 =
         0.81335   -0.06508    0.03531    0.45332
 
RESI 2256   HOH
O     4    0.548310    0.780416    0.328648    11.00000    0.47427    0.62587 =
         0.70484   -0.01908    0.12097    0.31860
 
RESI 2257   HOH
O     4    0.967848    1.179305    0.101679    11.00000    0.64343    0.41053 =
         0.54761    0.14248    0.08425    0.21875
 
RESI 2258   HOH
O     4    0.654435    0.603299    0.007680    11.00000    0.77458    0.73591 =
         0.64983   -0.22400    0.09241    0.35113
 
RESI 2259   HOH
O     4    0.734337    1.241538    0.042324    11.00000    0.39719    0.59022 =
         0.50811    0.07190   -0.07111    0.12712
 
RESI 2260   HOH
O     4    0.943263    1.265371    0.077372    11.00000    0.33692    0.50440 =
         0.54166   -0.00920   -0.08070    0.08012
 
RESI 2261   HOH
O     4    0.665152    1.148559    0.146629    11.00000    0.45486    0.85944 =
         0.58079    0.02761    0.23130    0.31993
 
RESI 2262   HOH
O     4    0.897704    1.079314    0.211603    11.00000    0.49941    0.54530 =
         0.44528   -0.00951    0.09826    0.24279
 
RESI 2263   HOH
O     4    0.472160    0.575329    0.018697    11.00000    0.42057    0.29624 =
         0.67317   -0.11831   -0.01224    0.09464
 
RESI 2264   HOH
O     4    0.668426    1.172166    0.066844    11.00000    0.61296    0.45407 =
         0.82872    0.07598   -0.16405    0.37874
 
RESI 2265   HOH
O     4    0.559485    0.572336    0.180291    11.00000    0.59195    0.49236 =
         0.66053   -0.00378   -0.10999    0.38027
 
RESI 2266   HOH
O     4    0.221281    0.940681    0.125386    11.00000    0.82568    0.62076 =
         0.67779   -0.11298    0.20365    0.35822
 
RESI 2267   HOH
O     4    0.743046    0.736763   -0.019609    11.00000    0.63105    0.38579 =
         0.66046   -0.26237   -0.04545    0.16824
 
RESI 2268   HOH
O     4    0.757537    0.681827    0.133725    11.00000    0.65775    0.63186 =
         0.72108   -0.03227   -0.21595    0.43739
 
RESI 2269   HOH
O     4    0.800292    0.785996    0.212023    11.00000    0.36403    0.51190 =
         0.57927   -0.12058    0.06391    0.12181
 
RESI 2270   HOH
O     4    0.883316    1.018617    0.239355    11.00000    0.39058    0.63723 =
         0.51193    0.03903   -0.06484    0.31435
 
REM  Trigonal trypsin
REM R1(Free) =  0.2066 for  1828 Fo > 4sig(Fo)  and  0.2216 for all  2135 data
REM R1 =  0.1747 for  34070 Fo > 4sig(Fo)  and  0.1911 for all  40506 data
REM   7621 parameters refined using   6791 restraints
 
REM Highest difference peak  0.791,  deepest hole -0.442,  1-sigma level  0.089
 
REM  Trigonal trypsin
REM R1(Free) =  0.2029 for  1828 Fo > 4sig(Fo)  and  0.2179 for all  2135 data
REM R1 =  0.1701 for  34070 Fo > 4sig(Fo)  and  0.1866 for all  40506 data
REM   7705 parameters refined using   6818 restraints
 
REM Highest difference peak  0.659,  deepest hole -0.433,  1-sigma level  0.089
 
HKLF 4
 
REM  Trigonal trypsin
REM R1(Free) =  0.1760 for  1893 Fo > 4sig(Fo)  and  0.1898 for all  2180 data
REM R1 =  0.1240 for  36026 Fo > 4sig(Fo)  and  0.1362 for all  41292 data
REM  17441 parameters refined using  20829 restraints
 
END  
     
WGHT      0.2000      0.0000 
REM Highest difference peak  0.589,  deepest hole -0.655,  1-sigma level  0.075
Q2    4   0.6530  1.0366  0.1941  11.00000  0.75    0.48
Q4    4   0.5781  1.2197 -0.0844  11.00000  0.75    0.40
Q6    4   0.3099  0.9276 -0.0461  11.00000  0.75    0.38
Q8    4   1.0124  1.1415  0.1270  11.00000  0.75    0.37
Q9    4   0.9408  0.9904  0.0600  11.00000  0.75    0.37
Q11   4   0.3098  0.9981  0.0051  11.00000  0.75    0.35
Q15   4   0.3581  0.4895  0.0571  11.00000  0.75    0.34
Q17   4   0.6942  1.1371 -0.1207  11.00000  0.75    0.33
Q21   4   0.9210  1.0113  0.2095  11.00000  0.75    0.33
Q25   4   0.8229  0.8388  0.1126  11.00000  0.75    0.32
Q27   4   0.8213  0.8293 -0.0304  11.00000  0.75    0.32
Q29   4   0.9981  1.0495  0.1254  11.00000  0.75    0.32
Q30   4   0.7117  1.1553  0.0608  11.00000  0.75    0.32
Q31   4   0.9988  1.2286 -0.0545  11.00000  0.75    0.31
Q33   4   0.1629  0.6762  0.1390  11.00000  0.75    0.31
Q36   4   0.6102  0.7945  0.3007  11.00000  0.75    0.31
Q37   4   0.8303  1.2417  0.2194  11.00000  0.75    0.31
Q41   4   0.8168  1.0022 -0.1286  11.00000  0.75    0.30
Q45   4   0.3052  0.5527  0.1256  11.00000  0.75    0.30
Q48   4   0.4414  1.0199  0.0547  11.00000  0.75    0.30
Q53   4   0.4630  1.0751  0.0529  11.00000  0.75    0.29
Q54   4   0.7515  1.2191  0.1612  11.00000  0.75    0.29
Q55   4   0.9098  1.3277  0.1785  11.00000  0.75    0.29
Q56   4   0.7653  1.0520 -0.1443  11.00000  0.75    0.29
Q59   4   0.2481  0.6294 -0.0857  11.00000  0.75    0.29
Q60   4   0.9742  1.2440  0.0580  11.00000  0.75    0.29
Q70   4   0.9558  1.2429  0.0940  11.00000  0.75    0.28
Q71   4   1.0000  1.0986  0.1667  10.50000  0.75    0.28
Q73   4   0.9261  1.2208  0.1679  11.00000  0.75    0.28
Q76   4   0.1006  0.6305  0.1199  11.00000  0.75    0.28
Q77   4   0.3130  0.6169  0.1657  11.00000  0.75    0.27
Q81   4   0.8798  1.0647 -0.1377  11.00000  0.75    0.27
Q83   4   1.0127  1.2154 -0.0088  11.00000  0.75    0.27
Q85   4   0.4372  0.5316 -0.0075  11.00000  0.75    0.27
Q87   4   0.4136  0.9227 -0.1076  11.00000  0.75    0.27
Q88   4   0.5423  0.9955  0.2937  11.00000  0.75    0.27
Q89   4   0.9906  1.0106  0.1117  11.00000  0.75    0.27
Q90   4   0.6785  1.0735 -0.1285  11.00000  0.75    0.27
Q95   4   0.9648  1.0711 -0.0873  11.00000  0.75    0.26
Q99   4   0.7572  0.9019  0.2882  11.00000  0.75    0.26
Q101  4   0.6701  0.8765 -0.1776  11.00000  0.75    0.26
Q104  4   1.0381  1.1325  0.0181  11.00000  0.75    0.26
Q105  4   0.9397  1.1292  0.2000  11.00000  0.75    0.26
Q109  4   0.9015  1.2535  0.1722  11.00000  0.75    0.26
Q115  4   0.9618  0.9482  0.1361  11.00000  0.75    0.26
Q118  4   0.2463  0.9714  0.0981  11.00000  0.75    0.26
Q124  4   0.1334  0.5985  0.0904  11.00000  0.75    0.25
Q125  4   0.9498  1.2812  0.1439  11.00000  0.75    0.25
Q126  4   0.5924  0.9239  0.3263  11.00000  0.75    0.25
Q130  4   0.4029  0.4491  0.0202  11.00000  0.75    0.25
Q131  4   0.4437  1.0874 -0.0164  11.00000  0.75    0.25
Q133  4   0.8390  0.9510 -0.0977  11.00000  0.75    0.25
Q135  4   1.0089  1.0519  0.0097  11.00000  0.75    0.25
Q137  4   0.6341  1.1156  0.1662  11.00000  0.75    0.25
Q140  4   0.8476  0.7998  0.1998  11.00000  0.75    0.25
Q144  4   0.6010  0.7100  0.2825  11.00000  0.75    0.25
Q145  4   0.7172  0.8510 -0.1633  11.00000  0.75    0.24
Q148  4   0.8617  0.8978 -0.0244  11.00000  0.75    0.24
Q152  4   0.3020  0.5536  0.1929  11.00000  0.75    0.24
Q161  4   0.6581  1.1137  0.2462  11.00000  0.75    0.24
Q163  4   0.4113  0.6775  0.2219  11.00000  0.75    0.24
Q165  4   0.9528  1.3693  0.0981  11.00000  0.75    0.24
Q168  4   0.2690  0.4388  0.0744  11.00000  0.75    0.24
Q171  4   0.7728  0.8245  0.2798  11.00000  0.75    0.24
Q172  4   0.7082  1.0668  0.3058  11.00000  0.75    0.24
Q176  4   0.4634  1.1198  0.0056  11.00000  0.75    0.24
Q193  4   0.8107  1.3902  0.1631  11.00000  0.75    0.23
Q199  4   1.0708  1.1952  0.0531  11.00000  0.75    0.23
