
namespace coot {

   // these are in simple-restraint.hh, in release, they are ints.
   enum restraint_type_t {BOND_RESTRAINT=1, ANGLE_RESTRAINT=2, TORSION_RESTRAINT=4, PLANE_RESTRAINT=8,
			  NON_BONDED_CONTACT_RESTRAINT=16, CHIRAL_VOLUME_RESTRAINT=32, RAMACHANDRAN_RESTRAINT=64,
			  START_POS_RESTRAINT=128,
			  TARGET_POS_RESTRANT=256, // restraint to make an atom be at a position
			  PARALLEL_PLANES_RESTRAINT=512,
			  GEMAN_MCCLURE_DISTANCE_RESTRAINT=1024,
			  TRANS_PEPTIDE_RESTRAINT=2048
   };

#ifdef __CUDACC__
   class bond_restraint {
   public:
      __host__ __device__ bond_restraint(restraint_type_t type_in, int idx_1, int idx_2, float d_ideal, float sigma) :
         type(type_in), m_idx_1(idx_1), m_idx_2(idx_2), m_d_target(d_ideal), m_sigma(sigma) { }

      __host__ __device__ bond_restraint() {}      

      restraint_type_t type;
      int m_idx_1, m_idx_2;
      float m_d_target, m_sigma;
      __host__ __device__ float distortion(const float *atom_positions) const { 
                                   if (type == BOND_RESTRAINT) return distortion_bond(atom_positions);
                                   if (type == NON_BONDED_CONTACT_RESTRAINT) return distortion_nbc(atom_positions);
                                   return 0.0;
                                 }
      __host__ __device__ float distortion_nbc(const float *atom_positions) const {
         float lj_epsilon = 0.5;
         float x1 = atom_positions[3*m_idx_1];
         float y1 = atom_positions[3*m_idx_1+1];
         float z1 = atom_positions[3*m_idx_1+2];
         float x2 = atom_positions[3*m_idx_2];
         float y2 = atom_positions[3*m_idx_2+1];
         float z2 = atom_positions[3*m_idx_2+2];
	 float dist_sq = (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2) + (z1-z2)*(z1-z2);

         float lj_sigma = m_d_target;
         float lj_r_min = 1.122462048309373 * lj_sigma;

         if (dist_sq < 0.81) dist_sq = 0.81; // 0.9^2
         float alpha_sqrd = lj_r_min*lj_r_min/dist_sq;
         float alpha_up_6  = alpha_sqrd * alpha_sqrd * alpha_sqrd;
         float alpha_up_12 = alpha_up_6 * alpha_up_6;
         float V_lj = lj_epsilon * (alpha_up_12 - 2.0 * alpha_up_6);
         float Vlj_at_rmax = -0.016316891136 * lj_epsilon;
         V_lj += Vlj_at_rmax;
	 return V_lj;
      }
      __host__ __device__ float distortion_bond(const float *atom_positions) const {
         float x1 = atom_positions[3*m_idx_1];
         float y1 = atom_positions[3*m_idx_1+1];
         float z1 = atom_positions[3*m_idx_1+2];
         float x2 = atom_positions[3*m_idx_2];
         float y2 = atom_positions[3*m_idx_2+1];
         float z2 = atom_positions[3*m_idx_2+2];
	 float dist_sq = (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2) + (z1-z2)*(z1-z2);
	 float dist = sqrt(dist_sq);
	 float d = dist - m_d_target;
	 float p = d/m_sigma;
	 return p*p;
      }
      
   };
#endif // __CUDACC__
}
