
// use the #shader "directive" to separate the shaders on parsing
// -----------------------------------------
#shader vertex

#version 330 core

layout(location = 0) in vec3 model_rotation_matrix_0;
layout(location = 1) in vec3 model_rotation_matrix_1;
layout(location = 2) in vec3 model_rotation_matrix_2;
layout(location = 3) in vec3 model_translation;
layout(location = 4) in vec3 position; // origin-based cylinder
layout(location = 5) in vec3 normal;   // ditto.  (Not normalized)
layout(location = 6) in vec4 colour;

uniform mat4 mvp;
out vec4 colour_transfer;
out vec3 normal_transfer;

void main() {

   mat3 model_rotation_matrix = mat3(model_rotation_matrix_0, model_rotation_matrix_1, model_rotation_matrix_2);
   vec3 p2 = position * model_rotation_matrix;
   vec4 p3 = vec4(model_translation + p2, 1.0);
   gl_Position = mvp * p3;

   vec4 r = mvp * vec4(normal, 1.0);
   normal_transfer = r.xyz;
   colour_transfer = colour;
}


// -----------------------------------------
#shader fragment

#version 330 core

struct Material {
    vec4 emission;
    vec4 ambient;
    vec4 diffuse;
    vec4 specular;
    float shininess;
};
uniform Material material;

struct LightSource {
    bool is_on;
    bool directional;
    vec4 position;
    vec4 ambient;
    vec4 diffuse;
    vec4 specular;
    vec4 halfVector;
    vec3 spotDirection;
    float spotExponent;
    float spotCutoff;
    float spotCosCutoff;
    float constantAttenuation;
    float linearAttenuation;
    float quadraticAttenuation;
};

uniform LightSource light_sources[2];

in vec4 colour_transfer;
in vec4 normal_transfer;

out vec4 outputColor;

void main() {

   outputColor = vec4(0,0,0,0);

   for (int i=0; i<2; i++) {
      if (light_sources[i].is_on) {
         vec4 light_dir = light_sources[i].position;
         light_dir.x = -1;
         light_dir.z =  4;
         light_dir = normalize(light_dir);
         vec4 norm = normalize(normal_transfer);
         float dp = dot(norm, light_dir);
         dp = max(dp, 0.05); // no negative dot products for diffuse for now, also, zero is avoided.

         // use the lights
         vec4 ambient  = material.ambient  * light_sources[i].ambient * 0.1;
         vec4 diffuse  = material.diffuse  * light_sources[i].diffuse * dp * 0.7;
         vec4 specular = material.specular * light_sources[i].specular * material.shininess * 0.01;

         ambient = 0.2 * colour_transfer;
         diffuse = dp * colour_transfer;
         specular = vec4(0,0,0,0);

         outputColor += ambient + diffuse + specular;
      }
   }


}
