# -----------------------------------------------------------------------------
# Save and restore placeobject state.
#
  
# -----------------------------------------------------------------------------
#
def save_placeobject_state(placeobjectdialog, file):

  s = PlaceObject_Dialog_State()
  s.state_from_dialog(placeobjectdialog)
  
  from SessionUtil import objecttree
  t = objecttree.instance_tree_to_basic_tree(s)

  file.write('\n')
  file.write('def restore_placeobject():\n')
  file.write(' placeobject_state = \\\n')
  objecttree.write_basic_tree(t, file, indent = '  ')
  file.write('\n')
  file.write(' from PlaceObject import session\n')
  file.write(' session.restore_placeobject_state(placeobject_state)\n')
  file.write('\n')
  file.write('try:\n')
  file.write('  restore_placeobject()\n')
  file.write('except:\n')
  file.write("  reportRestoreError('Error restoring placeobject')\n")
  file.write('\n')
  
# -----------------------------------------------------------------------------
#
def restore_placeobject_state(placeobjectdialog_basic_state):

  c = PlaceObject_Dialog_State
  name_to_class = {}
  name_to_class[c.__name__] = c

  from SessionUtil import objecttree
  s = objecttree.basic_tree_to_instance_tree(placeobjectdialog_basic_state,
                                             name_to_class)

  import PlaceObject.gui
  d = PlaceObject.gui.placeobjectdialog(create = True)

  set_dialog_state(s, d)

# -----------------------------------------------------------------------------
#
def set_dialog_state(placeobjectdialog_state, placeobjectdialog):

  placeobjectdialog_state.restore_state(placeobjectdialog)

# -----------------------------------------------------------------------------
#
class PlaceObject_Dialog_State:

  version = 2
  
  state_attributes = ('is_visible',
                      'geometry',
                      'coordinate_file',
                      'object_style',
                      'selfobj_file',
                      'phioffset',
                      'zoffset',
                      'voxel',
                      'colour_style',
                      'customWell',
                      'rowno',
                      'ccrange1',
                      'ccrange2',
                      'lowerWell',
                      'upperWell',
                      'visual_option',
                      'particle_no',
                      'lower_cc',
                      'upper_cc',
                      'class_no',
		      'surface_colours',
		      'surface_display',
		      'version',
                      )
  
  # ---------------------------------------------------------------------------
  #
  def state_from_dialog(self, placeobjectdialog):

    d = placeobjectdialog

    self.is_visible = d.isVisible()
    t = d.uiMaster().winfo_toplevel()
    self.geometry = t.wm_geometry()

    self.coordinate_file=[]
    self.object_style=[]
    self.selfobj_file=[]
    self.phioffset=[]
    self.zoffset=[]
    self.voxel=[]

    self.colour_style=[]
    self.customWell=[]

    self.rowno=[]
    self.ccrange1=[]
    self.ccrange2=[]
    self.lowerWell=[]
    self.upperWell=[]

    self.visual_option=[]
    self.particle_no=[]
    self.lower_cc=[]
    self.upper_cc=[]
    self.class_no=[]
    self.surface_colours=[]
    self.surface_display=[]

    shown_panels = d.shown_panels()
    for npl in range(len(shown_panels)):
      self.coordinate_file.append(shown_panels[npl].coordinate_file.get())

      self.object_style.append(shown_panels[npl].object_style.get())
      self.selfobj_file.append(shown_panels[npl].selfobj_file.get())
      self.phioffset.append(shown_panels[npl].object_phioffset.get())
      self.zoffset.append(shown_panels[npl].object_zoffset.get())
      self.voxel.append(shown_panels[npl].object_voxel.get())

      self.colour_style.append(shown_panels[npl].colour_style.get())
      self.customWell.append(shown_panels[npl].customWell.rgba)

      self.rowno.append(shown_panels[npl].rowno.get())
      self.ccrange1.append(shown_panels[npl].ccrange1.get())
      self.ccrange2.append(shown_panels[npl].ccrange2.get())
      self.lowerWell.append(shown_panels[npl].lowerccWell.rgba)
      self.upperWell.append(shown_panels[npl].upperccWell.rgba)

      self.visual_option.append(shown_panels[npl].visual_option.get())
      self.particle_no.append(shown_panels[npl].particle_no.get())
      self.lower_cc.append(shown_panels[npl].lower_cc.get())
      self.upper_cc.append(shown_panels[npl].upper_cc.get())
      self.class_no.append(shown_panels[npl].class_no.get())

      # Surface_Colours and Surface_Display
      MList=shown_panels[npl].ModelList
      for mp in range(len(MList)):
        self.surface_colours.append(MList[mp].surfacePieces[0].color)
        self.surface_display.append(MList[mp].display)

  # ---------------------------------------------------------------------------
  #
  def restore_state(self, placeobjectdialog):

    d = placeobjectdialog
    if self.is_visible:
      d.enter()

    t = d.uiMaster().winfo_toplevel()
    t.wm_geometry(self.geometry)
    t.wm_geometry('')		# restore standard size

    for np in range(len(self.coordinate_file)-1):
      d.Add()

    restore_panels=d.gui_panels
    mpid=0
    for npl in range(len(restore_panels)):
      restore_panels[npl].coordinate_file.set(self.coordinate_file[npl])

      restore_panels[npl].object_style.set(self.object_style[npl])
      restore_panels[npl].selfobj_file.set(self.selfobj_file[npl])
      restore_panels[npl].object_phioffset.set(self.phioffset[npl])
      restore_panels[npl].object_zoffset.set(self.zoffset[npl])
      restore_panels[npl].object_voxel.set(self.voxel[npl])

      restore_panels[npl].colour_style.set(self.colour_style[npl])
      restore_panels[npl].customWell.showColor(color=self.customWell[npl])

      restore_panels[npl].rowno.set(self.rowno[npl])
      restore_panels[npl].lowerccWell.showColor(color=self.lowerWell[npl])
      restore_panels[npl].upperccWell.showColor(color=self.upperWell[npl])

      restore_panels[npl].visual_option.set(self.visual_option[npl])
      restore_panels[npl].particle_no.set(self.particle_no[npl])
      restore_panels[npl].lower_cc.set(self.lower_cc[npl])
      restore_panels[npl].upper_cc.set(self.upper_cc[npl])
      restore_panels[npl].class_no.set(self.class_no[npl])

      restore_panels[npl].PlaceObject()
      restore_panels[npl].ccrange1.set(self.ccrange1[npl])
      restore_panels[npl].ccrange2.set(self.ccrange2[npl])
      restore_panels[npl].PlaceObject()

      # Surface_Colours and Surface_Display
      MList=restore_panels[npl].ModelList
      for mp in range(len(MList)):
        MList[mp].display=self.surface_display[mpid+mp]
        for sp in MList[mp].surfacePieces:
          sp.color=self.surface_colours[mpid+mp]
      mpid+=len(MList)
