#    Import the standard modules
import os
import Tkinter
import Tix
import numpy as np

#    Import the Chimera modules and classes
import chimera
from chimera.baseDialog import ModelessDialog
from CGLtk import Hybrid

import PlaceObject

# -----------------------------------------------------------------------------

class PlaceObjectDialog(ModelessDialog):

    name = "Place Object"
    buttons = ("  Add  ", "Close")
    help = "file://"+chimera.pathFinder().dataRoot+"/PlaceObject/PlaceObject.html"

    title = "Place Object In Map"

    # -------------------------------------------------------------------------
    #    GUI Panel
    def fillInUI(self, parent):
        #    Fill in the GUI
        objectScroll=Tix.ScrolledWindow(parent)
        objectScroll.pack(side='top',anchor='nw')
        self.window=objectScroll.window
        OBJ0=ObjectPanel(self.window)

    # Add New Coordinate File
    def Add(self):
        OBJnew=ObjectPanel(self.window)

class ObjectPanel:

    # -------------------------------------------------------------------------
    ## Registers
    CoordFile=''
    CoordTime=-1
    ModelList=[]

    SafeCopy=[]
    Motlist0=[]
    MotlistSize=0

    ObjPath0=''
    STLgeom=[]

    Phioffset0=0.0
    Zoffset0=0.0
    Voxel0=1.0

    CCstep=0.002
    CCmax0=-1
    CCmin0=-1
    CCmax=-1
    CCmin=-1

    CLXrow0=19
    CLXrow=-1
    CLXmax=1
    CLXmin=0

    Redclx=[]
    Greenclx=[]
    Blueclx=[]
    Redcc=[]
    Greencc=[]
    Bluecc=[]
    SelfColor=(0,0,0,1)
    Redshow=[]
    Greenshow=[]
    Blueshow=[]

    ## Flags
    isCFch=0
    isOSch=0
    isCSch=0
    isVch=0
    isPch=0
    isZch=0

    def __init__(self,parent):

        # Panel Frame
        panelFrame = Tkinter.Frame(parent,border=5)
        panelFrame.pack(side='top',anchor='nw',expand='yes')
        self.panel=panelFrame

        nrow = 0
        # Fill in Panel Frame

        # Instructor
        self.objectLabel = Tkinter.Label(panelFrame)
        self.objectLabel.grid(row=nrow, column=0, columnspan=2, sticky='w') 
        nrow += 1

        # Coordinate File
        self.coordEntry = Hybrid.Entry(panelFrame, 'Coordinate File ', 20, browse=True)
        self.coordEntry.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.coordinate_file=self.coordEntry.variable
        nrow += 1
  
        # Object Style
        self.objectFrame = Tkinter.Frame(panelFrame)
        self.objectFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')

        objectModeMap = ('Sphere', 'ArrowX', 'ArrowY','ArrowZ', 'Rectangle',
                         'Triangle', 'Square', 'Pentagon', 'Hexagon', 'Object ...')
        objectOption = Hybrid.Option_Menu(self.objectFrame, 'Object Style ', *objectModeMap)
        objectOption.add_callback(self.ObjectStyleOption)
        objectOption.frame.grid(row=0, column=0, columnspan=1, sticky='w') 
        self.object_style=objectOption.variable
        self.object_style.set('Sphere',invoke_callbacks=False)
  
        ## Object Voxel Size
        voxelEntry = Hybrid.Entry(self.objectFrame, '    Voxel-Size ',5,'1.0')
        voxelEntry.frame.grid(row=0, column=1, columnspan=1, sticky='w')
        self.object_voxel=voxelEntry.variable

        ## Z Offset
        zoffsetEntry = Hybrid.Entry(self.objectFrame, '    Z-Offset ',5,'0.0')
        zoffsetEntry.frame.grid(row=0, column=2, columnspan=1, sticky='w')
        self.object_zoffset=zoffsetEntry.variable

        ## Phi Offset
        phioffsetEntry = Hybrid.Entry(self.objectFrame, '    Phi-Offset ',5,'0.0')
        phioffsetEntry.frame.grid(row=0, column=3, columnspan=1, sticky='w')
        self.object_phioffset=phioffsetEntry.variable
        nrow += 1
        self.insertrow = nrow
  
        ## Object
        self.selfobj = Hybrid.Entry(panelFrame, 'Object File', 20, browse=True)
        self.selfobj.frame.grid(row=self.insertrow, column=0, columnspan=2, sticky='ew')
        self.selfobj_file=self.selfobj.variable
        self.insertflag = 0
        for child in self.selfobj.frame.winfo_children():
            child.configure(state='disabled')
        child.configure(bd=0)

        # Color Style
        self.colorRadio = Hybrid.Radiobutton_Row(panelFrame, 'Color Style ',
                          ('Class', 'Cross-Correlation', 'Manually'),self.ColorStyleOption)
        self.colorRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.color_style = self.colorRadio.variable
        self.color_style.set('Class',invoke_callbacks=False)
        nrow += 1
  
        # Color Range
        self.colorFrame = Tkinter.Frame(panelFrame)
        self.colorFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')

        rangeLabel = Tkinter.Label(self.colorFrame)
        rangeLabel.grid(row=0, column=0, columnspan=1, sticky='w')
        rangeLabel.configure(text='Color Range')

        ## Row No.
        rownoEntry = Hybrid.Entry(self.colorFrame, '    Row-No. ',5,'20')
        rownoEntry.frame.grid(row=0, column=1, columnspan=1, sticky='w')
        self.rowno=rownoEntry.variable
        self.rowno_children=rownoEntry.frame.winfo_children()
        self.rowno_children[0].config(state='normal')
        self.rowno_children[1].config(state='normal')

        ## CC Range
        ccrangeEntry1 = Hybrid.Entry(self.colorFrame, '    CC-Range ',8,'0.0')
        ccrangeEntry1.frame.grid(row=0, column=2, columnspan=1, sticky='w')
        self.ccrange1=ccrangeEntry1.variable
        self.ccrange1_children=ccrangeEntry1.frame.winfo_children()
        self.ccrange1_children[0].config(state='disabled')
        self.ccrange1_children[1].config(state='disabled')

        ccrangeEntry2 = Hybrid.Entry(self.colorFrame, ' - ',8,'1.0')
        ccrangeEntry2.frame.grid(row=0, column=3, columnspan=1, sticky='w')
        self.ccrange2=ccrangeEntry2.variable
        self.ccrange2_children=ccrangeEntry2.frame.winfo_children()
        self.ccrange2_children[0].config(state='disabled')
        self.ccrange2_children[1].config(state='disabled')

        self.autoccButton = Tkinter.Button(self.colorFrame, text='auto', width=1, command=self.AutoCC)
        self.autoccButton.grid(row=0, column=4, columnspan=1, sticky='w')
        self.autoccButton.config(state='disabled')

        ## Color Editor
        mcolorLabel = Tkinter.Label(self.colorFrame, text='    Color')
        mcolorLabel.grid(row=0, column=5, sticky='e') 
        self.mcolorL=mcolorLabel
        self.mcolorL.configure(state='disabled')

        from CGLtk.color import ColorWell
        mcolorWell = ColorWell.ColorWell(self.colorFrame, width=25, height=25)
        mcolorWell.grid(row=0, column=6, padx=5) 
        self.mcolorW=mcolorWell
        self.mcolorW.disable()
        nrow += 1

        # Visualization
        self.visualRadio = Hybrid.Radiobutton_Row(panelFrame, 'Visualization ',
                           ('All','None','One', 'Cross-Correlation', 'Class-number'),self.VisualizationOption)
        self.visualRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.visual_option = self.visualRadio.variable
        self.visual_option.set('All',invoke_callbacks=False)
        for child in self.visualRadio.frame.winfo_children():
            child.configure(state='disabled')
        nrow += 1
  
        # Particle No.
        self.particleScale = Hybrid.Scale(panelFrame, 'Particle Number ', 1, 100, 1, 1)
        self.particleScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.particle_no=self.particleScale.variable
        for child in self.particleScale.frame.winfo_children():
            child.configure(state='disabled')
        self.particle_no_children=self.particleScale.frame.winfo_children()
        self.particle_no_children[1].configure(width=8)
        self.particleScale.variable.block_callbacks=1
        self.particleScale.callback(self.VisualObject)
        self.particleScale.entry.bind('<KeyPress-Return>', self.VisualObject)
        nrow += 1
  
        # LowCC
        self.lowerthresholdScale = Hybrid.Scale(panelFrame, 'Lower CC Threshold ', 0, 1, self.CCstep, 0.000)
        self.lowerthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.lower_cc=self.lowerthresholdScale.variable
        for child in self.lowerthresholdScale.frame.winfo_children():
            child.configure(state='disabled')
        self.lower_cc_children=self.lowerthresholdScale.frame.winfo_children()
        self.lower_cc_children[1].configure(width=8)
        self.lowerthresholdScale.variable.block_callbacks=1
        self.lowerthresholdScale.callback(self.VisualObject)
        self.lowerthresholdScale.entry.bind('<KeyPress-Return>', self.VisualObject)
        nrow += 1

        # HighCC
        self.upperthresholdScale = Hybrid.Scale(panelFrame, 'Upper CC Threshold ', 0, 1, self.CCstep, 1.000)
        self.upperthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.upper_cc=self.upperthresholdScale.variable
        for child in self.upperthresholdScale.frame.winfo_children():
            child.configure(state='disabled')
        self.upper_cc_children=self.upperthresholdScale.frame.winfo_children()
        self.upper_cc_children[1].configure(width=8)
        self.upperthresholdScale.variable.block_callbacks=1
        self.upperthresholdScale.callback(self.VisualObject)
        self.upperthresholdScale.entry.bind('<KeyPress-Return>', self.VisualObject)
        nrow += 1

        # Class No.
        self.classScale = Hybrid.Scale(panelFrame, 'Class Number ', 1, 20, 1, 1)
        self.classScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
        self.class_no=self.classScale.variable
        for child in self.classScale.frame.winfo_children():
            child.configure(state='disabled')
        self.class_no_children=self.classScale.frame.winfo_children()
        self.classScale.variable.block_callbacks=1
        self.classScale.callback(self.VisualObject)
        self.classScale.entry.bind('<KeyPress-Return>', self.VisualObject)
        nrow += 1

        # Button Frame
        self.buttonFrame = Tkinter.Frame(panelFrame)
        self.buttonFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')

        ## Delete
        deleteButton = Tkinter.Button(self.buttonFrame, text='Delete', command=self.DeleteObject)
        deleteButton.pack(side='right', anchor='e')

        ## Save
        saveButton = Tkinter.Button(self.buttonFrame, text='Save', command=self.SaveObject)
        saveButton.pack(side='right', anchor='e')

        ## Focus
        focusButton = Tkinter.Button(self.buttonFrame, text='Focus', command=self.FocusObject)
        focusButton.pack(side='right', anchor='e')

        ## Apply
        applyButton = Tkinter.Button(self.buttonFrame, text='Apply', command=self.PlaceObject)
        applyButton.pack(side='right', anchor='e')
        nrow += 1
        self.poprow = nrow

    # -------------------------------------------------------------------------
    #    Control
    def ObjectStyleOption(self):
        if ((self.object_style.get() == 'Object ...') and (self.insertflag == 0)):
            nrow = self.poprow
            self.buttonFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.classScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.upperthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.lowerthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.particleScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.visualRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.colorFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow -= 1
            self.colorRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            self.insertflag = 1
            for child in self.selfobj.frame.winfo_children():
                child.configure(state='normal')
            child.configure(bd=2)

        elif ((self.object_style.get() != 'Object ...') and (self.insertflag == 1)):
            nrow = self.insertrow
            self.colorRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.colorFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.visualRadio.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.particleScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.lowerthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.upperthresholdScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.classScale.frame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            nrow += 1
            self.buttonFrame.grid(row=nrow, column=0, columnspan=2, sticky='ew')
            self.insertflag = 0
            for child in self.selfobj.frame.winfo_children():
                child.configure(state='disabled')
            child.configure(bd=0)
        else:
            return


    def ColorStyleOption(self):
        if (self.color_style.get() == 'Class'):
            self.rowno_children[0].config(state='normal')
            self.rowno_children[1].config(state='normal')
        else:
            self.rowno_children[0].config(state='disabled')
            self.rowno_children[1].config(state='disabled')

        if ((self.color_style.get() == 'Cross-Correlation') and (self.CCmax0 >= 0)):
            self.ccrange1_children[0].config(state='normal')
            self.ccrange1_children[1].config(state='normal')
            self.ccrange2_children[0].config(state='normal')
            self.ccrange2_children[1].config(state='normal')
            self.autoccButton.config(state='normal')
        else:
            self.ccrange1_children[0].config(state='disabled')
            self.ccrange1_children[1].config(state='disabled')
            self.ccrange2_children[0].config(state='disabled')
            self.ccrange2_children[1].config(state='disabled')
            self.autoccButton.config(state='disabled')

        if (self.color_style.get() == 'Manually'):
            self.mcolorL.configure(state='normal')
            self.mcolorW.enable()
        else:
            self.mcolorL.configure(state='disabled')
            self.mcolorW.disable()

        if self.ModelList:
            self.ch_Color()

    def VisualizationOption(self):
        if (self.visual_option.get() == 'One'):
            self.particleScale.variable.block_callbacks=0
            child=self.particle_no_children
            child[0].configure(state='active')
            child[1].configure(state='normal')
            child[2].configure(state='active')
        else:
            self.particleScale.variable.block_callbacks=1
            for child in self.particle_no_children:
                child.configure(state='disabled')

        if (self.visual_option.get() == 'Cross-Correlation'):
            self.lowerthresholdScale.variable.block_callbacks=0
            child=self.lower_cc_children
            child[0].configure(state='active')
            child[1].configure(state='normal')
            child[2].configure(state='active')
            self.upperthresholdScale.variable.block_callbacks=0
            child=self.upper_cc_children
            child[0].configure(state='active')
            child[1].configure(state='normal')
            child[2].configure(state='active')
        else:
            self.lowerthresholdScale.variable.block_callbacks=1
            for child in self.lower_cc_children:
                child.configure(state='disabled')
            self.upperthresholdScale.variable.block_callbacks=1
            for child in self.upper_cc_children:
                child.configure(state='disabled')

        if (self.visual_option.get() == 'Class-number'):
            self.classScale.variable.block_callbacks=0
            child=self.class_no_children
            child[0].configure(state='active')
            child[1].configure(state='normal')
            child[2].configure(state='active')
        else:
            self.classScale.variable.block_callbacks=1
            for child in self.class_no_children:
                child.configure(state='disabled')

        self.VisualObject()

    # -------------------------------------------------------------------------
    #    Auto CC-Range
    def AutoCC(self):
        self.ccrange1.set(self.CCmin0)
        self.ccrange2.set(self.CCmax0)

    # -------------------------------------------------------------------------
    def DeleteObject(self):
        self.CoordFile=''
        self.SafeCopy=[]
        self.Motlist0=[]

        if self.ModelList:
            chimera.openModels.close(self.ModelList)
        self.ModelList=[]

        self.panel.destroy()

    # -------------------------------------------------------------------------
    def SaveObject(self):
        if (self.CoordFile and self.MotlistSize and self.ModelList):
            motlist=np.copy(self.SafeCopy)
            mpind=[]
            for lpn in range(0,self.MotlistSize):
                if self.ModelList[lpn].display:
                   mpind.append(lpn)
            import qio
            newmotlfile=self.CoordFile[0:-3]+'_display.em'
            qio.write(newmotlfile,motlist[mpind,:].T)

    # -------------------------------------------------------------------------
    def FocusObject(self):
        from ModelPanel import focusCmd
        if (self.CoordFile and self.MotlistSize and self.ModelList):
            focusCmd(self.ModelList)
            chimera.viewer.clipping=False

    # -------------------------------------------------------------------------
    # Hardcoded Color
    def redcolor(self):
        return [0.7,1.0,0.7,0.7,1.0,1.0,0.7,0.90,0.60,0.8]
    def greencolor(self):
        return [0.7,1.0,1.0,0.7,0.7,0.7,1.0,0.75,0.75,0.8]
    def bluecolor(self):
        return [0.7,0.7,1.0,1.0,1.0,0.7,0.7,0.60,0.90,0.6]

    # -------------------------------------------------------------------------
    # Reset Flag
    def ResetFlag(self):
        self.isCFch=0
        self.isOSch=0
        self.isCSch=0
        self.isVch=0
        self.isPch=0
        self.isZch=0

    # Reset Register
    def ResetRegister(self):

        self.CoordFile=''
        self.CoordTime=-1
        if self.ModelList:
            chimera.openModels.close(self.ModelList)
            self.ModelList=[]

        self.SafeCopy=[]
        self.Motlist0=[]
        self.MotlistSize=0

        self.ObjPath0=''
        self.STLgeom=[]

        self.Phioffset0=0.0
        self.Zoffset0=0.0
        self.Voxel0=1.0

        self.CCstep=0.002
        self.CCmax0=-1
        self.CCmin0=-1
        self.CCmax=-1
        self.CCmin=-1

        self.CLXrow0=19
        self.CLXrow=-1
        self.CLXmax=1
        self.CLXmin=0

        self.Redclx=[]
        self.Greenclx=[]
        self.Blueclx=[]
        self.Redcc=[]
        self.Greencc=[]
        self.Bluecc=[]
        self.SelfColor=(0,0,0,1)
        self.Redshow=[]
        self.Greenshow=[]
        self.Blueshow=[]

    # -------------------------------------------------------------------------
    #    Coordinate File Initialization
    def CoordFile_update(self):
        from VolumeData import open_file

        # -------------------------------------------------------------------------
        ## Read In The Coordinate File
        motlfile=open_file(self.CoordFile,'tom_em')
        motlsize=motlfile[0].size[1]
        motlist=motlfile[0].full_matrix()[0,:,:]
        self.SafeCopy=np.copy(motlist)

        # -------------------------------------------------------------------------
        ## Updata Registers
        motlist[:,13:16]=np.add(motlist[:,7:10],motlist[:,10:13])
        self.Motlist0=np.copy(motlist)
        self.MotlistSize=motlsize

        self.CCmax0=max(motlist[:,0])
        self.CCmin0=min(motlist[:,0])

        if (self.CLXrow0 != motlist.shape[1]-1):
            self.objectLabel.config(text='Coordinate File Format Wrong!!!',fg='red')
            return

        self.CLXmax=max(motlist[:,self.CLXrow0])
        self.CLXmin=min(motlist[:,self.CLXrow0])

        ## Update GUI Range
        self.ccrange1.set(self.CCmin0)
        self.ccrange2.set(self.CCmax0)
        self.particleScale.set_value(self.MotlistSize)
        self.lowerthresholdScale.set_value(self.CCmin0-self.CCstep)
        self.upperthresholdScale.set_value(self.CCmax0+self.CCstep)
        self.classScale.set_value(int(self.CLXmin))
        self.particleScale.set_range(1,self.MotlistSize,1)
        self.lowerthresholdScale.set_range(self.CCmin0-self.CCstep,self.CCmax0+self.CCstep,self.CCstep)
        self.upperthresholdScale.set_range(self.CCmin0-self.CCstep,self.CCmax0+self.CCstep,self.CCstep)
        self.classScale.set_range(self.CLXmin,self.CLXmax,1)
        for child in self.visualRadio.frame.winfo_children():
            child.configure(state='normal')
        self.ColorStyleOption()

    # -------------------------------------------------------------------------
    #    Object Style Implementation
    def ObjectStyle_update(self):
        self.chimeraroot=chimera.pathFinder().dataRoot
        if (self.object_style.get() == 'Sphere'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Sphere.stl'
        elif (self.object_style.get() == 'ArrowX'):
            objpath=self.chimeraroot+'/PlaceObject/objects/ArrowX.stl'
        elif (self.object_style.get() == 'ArrowY'):
            objpath=self.chimeraroot+'/PlaceObject/objects/ArrowY.stl'
        elif (self.object_style.get() == 'ArrowZ'):
            objpath=self.chimeraroot+'/PlaceObject/objects/ArrowZ.stl'
        elif (self.object_style.get() == 'Rectangle'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Rectangle.stl'
        elif (self.object_style.get() == 'Triangle'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Triangle.stl'
        elif (self.object_style.get() == 'Square'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Square.stl'
        elif (self.object_style.get() == 'Pentagon'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Pentagon.stl'
        elif (self.object_style.get() == 'Hexagon'):
            objpath=self.chimeraroot+'/PlaceObject/objects/Hexagon.stl'
        elif (self.object_style.get() == 'Object ...'):
            if (self.selfobj_file.get() == ''):
                self.objectLabel.config(text='No Object File Found!!!',fg='red')
                return
            else:
                objpath=self.selfobj_file.get()

        return objpath

    # -------------------------------------------------------------------------
    #    Color Style Implementation
    def ColorStyle_update(self):

        motlist=np.copy(self.Motlist0)
        motlsize=self.MotlistSize

        ## Check the Class No.
        clxrow=float(self.rowno.get())-1
        if ((clxrow<0.0) or (clxrow>self.CLXrow0)):
            self.objectLabel.config(text='Class Row No. Error!!!',fg='red')
            return

        ## Update Class Color
        if (self.CLXrow != clxrow):
            self.isCSch=1
            self.CLXrow=clxrow
            self.CLXmax=max(motlist[:,clxrow])
            self.CLXmin=min(motlist[:,clxrow])
            self.classScale.set_value(int(self.CLXmin))
            self.classScale.set_range(self.CLXmin,self.CLXmax,1)

            redtmp=np.array(self.redcolor())
            greentmp=np.array(self.greencolor())
            bluetmp=np.array(self.bluecolor())

            def intf(x):
               return np.int(x)
            qint=np.vectorize(intf)
            self.Redclx=redtmp[qint(np.mod(motlist[:,clxrow],10))]
            self.Greenclx=greentmp[qint(np.mod(motlist[:,clxrow],10))]
            self.Blueclx=bluetmp[qint(np.mod(motlist[:,clxrow],10))]

        ## Check the CC-Range
        ccmin=float(self.ccrange1.get())
        ccmax=float(self.ccrange2.get())
        if ((ccmin<0.0) or (ccmax>1.0) or (ccmin > ccmax)):
            self.objectLabel.config(text='CC Range Error!!!',fg='red')
            return

        ## Update CC Color
        if (self.CCmax != ccmax) or (self.CCmin != ccmin):
            self.isCSch=1
            self.CCmax=ccmax
            self.CCmin=ccmin
            if (ccmax > ccmin):
                self.Redcc=np.cos(np.pi*0.5*(motlist[:,0]-ccmin)/(ccmax-ccmin))
                self.Greencc=np.sin(np.pi*0.5*(motlist[:,0]-ccmin)/(ccmax-ccmin))
                self.Bluecc=np.array([0]*motlsize,ndmin=1)
            else:
                self.Redcc=np.cos(np.pi*0.5*motlist[:,0])
                self.Greencc=np.sin(np.pi*0.5*motlist[:,0])
                self.Bluecc=np.array([0]*motlsize,ndmin=1)

        ## Check Color Well
        if (self.SelfColor!=self.mcolorW.rgba):
            self.SelfColor=self.mcolorW.rgba
            self.isCSch=1

    # -------------------------------------------------------------------------
    ## Update Voxelsize, Zoffset and Phioffset
    def VPZ_update(self):
        ## Voxel Size
        voxel=float(self.object_voxel.get())
        if (voxel<=0.0):
            self.objectLabel.config(text='Voxel Size Error!!!',fg='red')
            return
        elif ((voxel>0.0) and (voxel != self.Voxel0)):
            self.Voxel0=voxel
            self.isVch=1

        ## Rotation and Phi-Offset
        phioffset=float(self.object_phioffset.get())
        if (phioffset != self.Phioffset0):
            self.Phioffset0=phioffset
            self.isPch=1

        ## Translation and Z-Offset
        zoffset=float(self.object_zoffset.get())
        if (zoffset != self.Zoffset0):
            self.Zoffset0=zoffset
            self.isZch=1

    ## Change Voxelsize, Zoffset and Phioffset
    def ch_VPZ(self):
        from qtools import rotation_matrix_zxz

        if not self.ModelList:
            self.objectLabel.config(text='No Objects Displayed!!!',fg='red')
            return

        motlist=np.copy(self.Motlist0)
        objlist=self.ModelList
        for lpn in range(0,self.MotlistSize):
            objxyz0=self.STLgeom[0]
            objxyz1=self.STLgeom[1]

            ## Voxel Size
            if (self.Voxel0>0.0) and (self.Voxel0!=1.0):
                objxyz0=objxyz0*self.Voxel0
  
            ## Rotation and Phi-Offset
            angles=motlist[lpn,16:19]
            if (self.Phioffset0):
                angles[0]=angles[0]+self.Phioffset0
            rot=np.array(rotation_matrix_zxz(angles))
            objxyz0=np.dot(objxyz0,rot.T)

            ## Translation and Z-Offset
            coord=motlist[lpn,13:16]
            if (self.Zoffset0 == 0.0):
                objxyz0=objxyz0+coord
            else:
                vecZ=np.array([0,0,1.0],ndmin=2)
                rotZ=np.dot(vecZ,rot.T)*self.Zoffset0
                objxyz0=objxyz0+coord+rotZ[0,:]
  
            for sp in objlist[lpn].surfacePieces:
                sp.geometry=(objxyz0,objxyz1)

        motlname=os.path.basename(self.CoordFile)
        self.objectLabel.config(text="%s #%d" % (motlname,objlist[0].id),fg='blue')

    def define_Color(self):
        if (self.color_style.get() == 'Class'):
            self.Redshow=self.Redclx
            self.Greenshow=self.Greenclx
            self.Blueshow=self.Blueclx
        if (self.color_style.get() == 'Cross-Correlation'):
            self.Redshow=self.Redcc
            self.Greenshow=self.Greencc
            self.Blueshow=self.Bluecc
        if (self.color_style.get() == 'Manually'):
            self.Redshow=np.array([float(self.SelfColor[0])]*self.MotlistSize,ndmin=1)
            self.Greenshow=np.array([float(self.SelfColor[1])]*self.MotlistSize,ndmin=1)
            self.Blueshow=np.array([float(self.SelfColor[2])]*self.MotlistSize,ndmin=1)

    def ch_Color(self):
        if not self.ModelList:
            self.objectLabel.config(text='No Objects Displayed!!!',fg='red')
            return
        self.define_Color()
        objlist=self.ModelList
        for lpn in range(0,self.MotlistSize):
            for sp in objlist[lpn].surfacePieces:
                sp.color=(self.Redshow[lpn],self.Greenshow[lpn],self.Blueshow[lpn],1) 

        motlname=os.path.basename(self.CoordFile)
        self.objectLabel.config(text="%s #%d" % (motlname,objlist[0].id),fg='blue')

    # -------------------------------------------------------------------------
    #   Change Display
    def ch_Display(self):
        from _surface import SurfaceModel
        from Matrix import orthogonalize
        from ModelPanel import focusCmd,groupCmd
        from Lighting import setReflectivity,setContrast

        #    Display all objects
        motlname=os.path.basename(self.CoordFile)
        motlist=np.copy(self.Motlist0)

        if self.ModelList:
            chimera.openModels.close(self.ModelList)

        objlist=[]
        for lpn in range(0,self.MotlistSize):
            objlist.append(SurfaceModel())

            spvertex=self.STLgeom[0]
            spnormals=self.STLgeom[1]
            spcolor=(self.Redshow[lpn],self.Greenshow[lpn],self.Blueshow[lpn],1) 
            objlist[lpn].name=motlname
            objlist[lpn].addPiece(spvertex,spnormals,spcolor)

        #    Voxelsize, Rotation and translation
        self.ModelList=objlist
        chimera.openModels.add(self.ModelList)

        self.VPZ_update()
        self.ch_VPZ()

        if (self.MotlistSize>1.0):
            groupCmd(objlist,motlname)
        focusCmd(objlist)
        chimera.viewer.clipping=False
        setReflectivity(0)

        self.objectLabel.config(text="%s #%d" % (motlname,objlist[0].id),fg='blue')

    # -------------------------------------------------------------------------
    #    Place Object
    def PlaceObject(self):
        from ReadSTL import read_stl
        from os.path import getmtime

        ## CoordFile Update
        if (self.coordinate_file.get() == ''):
            self.objectLabel.config(text='No Coordinate File Found!!!',fg='red')
            return
        timenow=getmtime(self.coordinate_file.get())
        if ((self.coordinate_file.get() != self.CoordFile) or 
         ((self.coordinate_file.get() == self.CoordFile) and (timenow != self.CoordTime))):
            if self.ModelList:
                chimera.openModels.close(self.ModelList)
            self.ResetRegister()
            self.CoordFile=self.coordinate_file.get()
            self.CoordTime=timenow
            self.CoordFile_update()
            self.isCFch=1

        ## ObjectStyle Update
        objpath=self.ObjectStyle_update()
        if (objpath == ''):
            self.objectLabel.config(text='No Object File Found!!!',fg='red')
            return
        if ((objpath != '') and (objpath !=self.ObjPath0)):
            self.ObjPath0=objpath
            objstl=read_stl(objpath)
            for sp in objstl.surfacePieces:
                if len(sp.geometry[0])>0:
                    self.STLgeom=sp.geometry
            self.isOSch=1

        ## ColorStyle Update
        self.ColorStyle_update()
        if self.isCSch:
            if self.ModelList:
                self.ch_Color()
            else:
                self.define_Color()

        if self.isCFch:
            self.ch_Display()
            self.ResetFlag()
        else:
            self.VPZ_update()
            if (self.isOSch) or (self.isVch) or (self.isPch) or (self.isZch):
                self.ch_VPZ()
                self.ResetFlag()

    # -------------------------------------------------------------------------
    #    Visualization Implementation
    def VisualObject(self, event = None):
        from Midas import modeldisplay,unmodeldisplay

        if not self.ModelList:
            self.objectLabel.config(text='No Objects Displayed!!!',fg='red')
            return

        motlist=np.copy(self.Motlist0)
        motlsize=self.MotlistSize

        ## Define sublist and subrgblist
        objarray=np.array(self.ModelList)
        def intf(x):
           return np.int(x)
        qint=np.vectorize(intf)

        if (self.visual_option.get() == 'All'):
            modeldisplay(self.ModelList)

        if (self.visual_option.get() == 'None'):
            unmodeldisplay(self.ModelList)

        if (self.visual_option.get() == 'One'):
            subind=self.particle_no.get()
            if subind == '':
                return
            subind=int(subind)-1
            if (subind > motlsize-1) or (subind < 0):
                unmodeldisplay(self.ModelList)
                return
            else:
                unmodeldisplay(self.ModelList)
                modeldisplay([self.ModelList[subind]])

        if (self.visual_option.get() == 'Cross-Correlation'):
            lowercc=self.lower_cc.get()
            uppercc=self.upper_cc.get()
            if ((lowercc == '') or (uppercc == '')):
                return
            lowercc=float(lowercc)
            uppercc=float(uppercc)
            subind=np.where((motlist[:,0] >= lowercc)&(motlist[:,0] <= uppercc))[0]
            if (len(subind)==0):
                unmodeldisplay(self.ModelList)
                return
            elif (len(subind)==1):
                unmodeldisplay(self.ModelList)
                modeldisplay([self.ModelList[subind]])
            else:
                unmodeldisplay(self.ModelList)
                modeldisplay(objarray[qint(subind)].tolist())

        if (self.visual_option.get() == 'Class-number'):
            nclx=self.class_no.get()
            if nclx == '':
                return
            nclx=float(nclx)
            subind=np.where(motlist[:,self.CLXrow] == nclx)[0]
            if (len(subind)==0):
                unmodeldisplay(self.ModelList)
                return
            elif (len(subind)==1):
                unmodeldisplay(self.ModelList)
                modeldisplay([self.ModelList[subind]])
            else:
                unmodeldisplay(self.ModelList)
                modeldisplay(objarray[qint(subind)].tolist())

# -----------------------------------------------------------------------------
def placeobjectdialog(create=False):
    from chimera import dialogs
    return dialogs.find(PlaceObjectDialog.name, create=create)

# -----------------------------------------------------------------------------
def show_placeobjectdialog():
    from chimera import dialogs
    return dialogs.display(PlaceObjectDialog.name)

# -------------------------------------------------------------------------
chimera.dialogs.register(PlaceObjectDialog.name, PlaceObjectDialog)

