
// edit to adjust legend scale and frequency of breaks:
var max_score = 15
var min_score = 0
var no_breaks = 5

// edit to adjust colours corresponding to complete similarity (col1) and dissimilarity (col2):
var col1 = [1.0,1.0,0];
var col2 = [0.8,0,0];

///////////

var dataset = new Array();

for (var i = 0; i < 101; i++) {
    dataset.push(i);
}
          
var w = 300;
var h = 100;
var barPadding = 0;
var bar_height = 20
    
var svg = d3.select("body")
            .append("svg")
            .attr("width", w)
            .attr("height", h);
    
svg.selectAll("rect")
   .data(dataset)
   .enter()
   .append("rect")
   .attr("x", 0)
   .attr("y", 0)
   .attr("color","black")
   .attr("fill", function(d) {
    return "rgb(" + Math.floor(255*(col1[0]*(100-d)+col2[0]*d)/100) + "," + Math.floor(255*(col1[1]*(100-d)+col2[1]*d)/100) + "," + Math.floor(255*(col1[2]*(100-d)+col2[2]*d)/100) + ")";
    })
   .attr("x", function(d, i) {
    return 20 + i * (w / dataset.length-0.7);
    })
   .attr("y", function(d) {
    return bar_height;
    })
   .attr("width", w / dataset.length - barPadding)
   .attr("height", function(d) {
    return bar_height;
    });   
   
svg.selectAll("text")
   .data(dataset)
   .enter()
   .append("text")
   .text(function(d) {
   if(d<2){return ((max_score-min_score)*d/100+min_score) + '\u00B0';}
   else if(d>99){return '>' + ((max_score-min_score)*d/100+min_score) + '\u00B0';}
   else{return(max_score-min_score)*d/100+min_score;}
   })
   .attr("x", function(d, i) {
        return 20 + i * (w / dataset.length-0.7);
   })
   .attr("y", function(d) {
        return 60;
   })
   .attr("opacity", function(d) {
        return Math.abs(Math.floor((d-1)%(100/no_breaks)/(100/no_breaks-1)));
   })
    .attr("style","text-anchor:middle");

   