//
// This file is part of ProSMART.
//

#ifndef alignClass_Align_H
#define alignClass_Align_H

#include "prosmart_array_tools.h"

//important note - this is specific to ProSMART ALIGN only - not ProSMART.
struct residue_alignment
{  
    int res1;
    int res2;
	string type1;		//sse type
	string type2;
    double dist;		//minimum
    double dist2;		//central
    double dist3;		//sidechain RMSD
    double dist4;		//sidechain average position
    double dist5;   //max distance between atoms in residue after local superposition
    int dist6;   //no of atoms with interatomic distances after local superposition greater than X
    int dist7;    //total no of atoms in residue
   
    //int n_global;   //no of atoms with interatomic distances after global superposition greater than X
    //double max_global;   //max distance between atoms in residue after global superposition

#ifdef RUN_AREAIMOL
	double asa1;     //total accessible surface area for res1
	double asa2;     //total accessible surface area for res2
#endif
    double complete1;
    double complete2;
    double rot;		//forward prediction
	vector<double> other;	//any other scores
    int frag1;		//original fragments (from alignment - the one whose score generates the min score)
    int frag2;
	vector<int> frags;
    vector<string> atoms;       //this lists atom names of corresponding atoms (only for sequence-identical residues)
    vector<int> atom_indexes;   //this indexes the atom names, to allow corrections for errors and nomenclature inconsistencies
};

class Align
{
private:
    vector<int> align1;
	vector<int> align2;
public:
    void printout(int, int);
	void printout(Array2D<double>&);
    void add(int,int);
	void erase(int);
	void edit(int,int,int);
	void edit_entry(int,int,int);
	void insert_start(int, int);
	void insert(int, int, int);
	void insert(vector<int>&,vector<int>&);
    Array2D<int> get();
	Array2D<int> get_residues(int);
	Array2D<int> get_T();
	Array2D<int> get(vector<int>);
	Align get_cluster(vector<int>);
	int get(int, int);
	unsigned int len();
	int last1();
	int last2();
	void clear();
	double dist();
	double distperfrag();
	void reorder_align();
	Array2D<double> align_DM(Array2D<double>&);
	void pop_back();
};

ostream& operator<<(ostream&, Align &);

#endif
