//
// This file is part of ProSMART.
//

#include "alignClass_Frag.h"

void Frag::erase(int i)
{
    frag.erase(frag.begin()+i);
    return;
}

int Frag::last_res()
{
  return (*res).last();
}

string Frag::get_resid(int idx)
{
  return (*res).get_resid(idx);
}

string Frag::get_resid_frag(int idx, int mod)
{
  return (*res).get_resid(frag[idx]+mod);
}

vector<string> Frag::get_resid(Align &al, int protein)
{
  return (*res).get_resid(al,protein);
}

vector<int> Frag::get_residues(Align &al, int protein) //protein = 1 or 2.
{  
  Array1D<bool> resarray((*res).last()+1,(bool)0);
  int temp;
  vector<int> res_out;
  
  for(unsigned int i=1; i<=al.len(); i++){
    temp = (*res).res(frag[al.get(protein,i)]);
	for(int j=0; j<frag_len; j++){
      resarray[temp+j] = 1;
	}
  }
  for(int i=0; i<resarray.dim1(); i++){
    if(resarray[i]==1){
	  res_out.push_back(i);
	}
  }
  
  return res_out;
}

int Frag::idx(int i)
{
  return (*res).res(frag[i]);
}

int Frag::res_idx(int i)
{
  return (*res).res(i);
}

void Frag::ca_crds(Coords &crds, int idx)
{
  crds.clear();
  for(int i=0; i<frag_len; i++){
    crds.add((*res).crd_CA(frag[idx]+i));
  }
  return;
}

Coords Frag::ca_crds_norm(int idx)
{
  Coords crds;
  for(int i=0; i<frag_len; i++){
    crds.add((*res).crd_CA(frag[idx]+i));
  }
  
  return crds.rmmean();
}

Coords Frag::ca_crds_mainnorm(int idx)
//returns ca coords, normalised by mean of all main chain coords.
{
  Coords crds;
  Coords maincrds;
  for(int i=0; i<frag_len; i++){
    crds.add((*res).crd_CA(frag[idx]+i));
	maincrds.add((*res).crd_N(frag[idx]+i));
	maincrds.add((*res).crd_CA(frag[idx]+i));
	maincrds.add((*res).crd_C(frag[idx]+i));
	maincrds.add((*res).crd_O(frag[idx]+i));
  }
  coord mm = maincrds.mean();
  
  return crds - mm;
}

void Frag::crds(Coords &crds, int idx)
{
  crds.clear();
  if(mode==1){
    for(int i=0; i<frag_len; i++){
	  crds.add((*res).crd_CA(frag[idx]+i));
    }
  } else {
	for(int i=0; i<frag_len; i++){
      crds.add((*res).crd_N(frag[idx]+i));
	  crds.add((*res).crd_CA(frag[idx]+i));
	  crds.add((*res).crd_C(frag[idx]+i));
	  crds.add((*res).crd_O(frag[idx]+i));
    }
  }
  
  return;
}

Coords Frag::get_central_ca()
{
    Coords result;
    int offset = (frag_len-1)/2;
    for(unsigned int i=0; i<frag.size(); i++){
        result.add((*res).crd_CA(frag[i] + offset));
    }
    return result;
}

Coords Frag::central_side(int idx, int offset, bool main)
{
  return (*res).crd_side(frag[idx] + ((frag_len-1)/2) + offset, main);
}

vector<string> Frag::get_side_atom(int idx, int offset)
{
  return (*res).side_atoms(frag[idx] + ((frag_len-1)/2) + offset);
}

string Frag::get_side_resid(int idx, int offset)
{
    return (*res).get_resid(frag[idx] + ((frag_len-1)/2) + offset);
}

string Frag::get_side_orig(int idx, int offset)
{
    return (*res).get_orig_resnum(frag[idx] + ((frag_len-1)/2) + offset);
}

/*vector<string> Frag::get_side_element(int idx, int offset)
{
    return (*res).side_elements(frag[idx] + ((frag_len-1)/2) + offset);
}*/

Coords Frag::crds_norm(int idx)
{
  Coords crds;
  if(mode==1){
	for(int i=0; i<frag_len; i++){
	  crds.add((*res).crd_CA(frag[idx]+i));
    }
  } else {
	for(int i=0; i<frag_len; i++){
      crds.add((*res).crd_N(frag[idx]+i));
	  crds.add((*res).crd_CA(frag[idx]+i));
	  crds.add((*res).crd_C(frag[idx]+i));
	  crds.add((*res).crd_O(frag[idx]+i));
    }
  }
  
  return crds.rmmean();
}

Coords Frag::get_crds(int idx)
{
  Coords crds;
  if(mode==1){
		for(int i=0; i<frag_len; i++){
			crds.add((*res).crd_CA(frag[idx]+i));
    }
  } else {
		for(int i=0; i<frag_len; i++){
      crds.add((*res).crd_N(frag[idx]+i));
			crds.add((*res).crd_CA(frag[idx]+i));
			crds.add((*res).crd_C(frag[idx]+i));
			crds.add((*res).crd_O(frag[idx]+i));
    }
  }
  
  return crds;
}

coord Frag::get_mean(int idx)
{
	int fi = frag[idx];
	int fii = 0;
	
	if(mode==1){
		coord result = (*res).crd_CA(fi);
		for(int i=1; i<frag_len; i++){
			result = add_coords(result,(*res).crd_CA(fi+i));
		}
		return result/frag_len;
	} else {
		coord result = (*res).crd_N(fi);
		result = add_coords(result,(*res).crd_CA(fi));
		result = add_coords(result,(*res).crd_C(fi));
		result = add_coords(result,(*res).crd_O(fi));
		for(int i=1; i<frag_len; i++){
			fii = fi + i;
			result = add_coords(result,(*res).crd_N(fii));
			result = add_coords(result,(*res).crd_CA(fii));
			result = add_coords(result,(*res).crd_C(fii));
			result = add_coords(result,(*res).crd_O(fii));
		}
		return result/(4*frag_len);
	}
}

int Frag::len()
{
  return frag_len;
}

int Frag::size()
{
  return frag.size();
}

int Frag::res_size()
{
  return (*res).size();
}

void Frag::create(Residues &r1, int len, int ALIGN_MODE)
{
    bool valid;
    int current_res;
    int N = r1.size()-len+1;
    
    mode = ALIGN_MODE;
    frag_len = len;
    res = &r1;
    
	frag.clear();
    for(int i=0; i<N; i++){
        current_res = r1.res(i);
		valid = 1;
		for(int j=0; j<len; j++){
            if(r1.valid(i+j)==0){		//returns 1 if no mainchain atoms are missing
				valid = 0;
				break;
			}            
            if(r1.res(i+j)!=current_res+j){			//make sure there are no residues missing - only take full, continuous fragments.
                valid = 0;
                break;
                /*coord c1 = r1.crd_C(i+j-1);       //distance criteria for detection of consecutive residues
                coord c2 = r1.crd_N(i+j);
                if(dist(c1,c2)>1.6){                //1.6 is a guess.
                    valid = 0;
                    break;
                }*/
			}
		}
		if(valid == 1){
			frag.push_back(i);
		}
    }
	
	return;
}

vector<int> Frag::filter(vector<res_corresp> &orig, vector<vector<int> > &res_ranges)
{
	vector<int> result;
	for(unsigned int i=0; i<frag.size(); i++){
		for(unsigned int j=0; j<res_ranges.size(); j++){
			if(orig[(*res).res(frag[i])].res>=res_ranges[j][0] && orig[(*res).res(frag[i]+frag_len-1)].res<=res_ranges[j][1]){
				result.push_back(i);
				break;
			}
		}
	}
	return result;
}



