//
// This file is part of ProSMART.
//

#include "alignClass_Residues.h"

Coords Residues::crds1(vector<residue_alignment> &align)
{
    Coords result;
    int temp;
    
    for(unsigned int i=0; i<align.size(); i++){
        temp = index[align[i].res1];
        result.add((*pdb).crd(N[temp]));
        result.add((*pdb).crd(CA[temp]));
        result.add((*pdb).crd(C[temp]));
        result.add((*pdb).crd(O[temp]));
    }
    
    return result;
}

Coords Residues::crds1_all()
{
    Coords result;
    
    for(unsigned int i=0; i<N.size(); i++){
        if(N[i]>=0) result.add((*pdb).crd(N[i]));
        if(CA[i]>=0) result.add((*pdb).crd(CA[i]));
        if(C[i]>=0) result.add((*pdb).crd(C[i]));
        if(O[i]>=0) result.add((*pdb).crd(O[i]));
    }
    
    return result;
}

Coords Residues::crds2(vector<residue_alignment> &align)
{
    Coords result;
    int temp;
    
    for(unsigned int i=0; i<align.size(); i++){
        temp = index[align[i].res2];
        result.add((*pdb).crd(N[temp]));
        result.add((*pdb).crd(CA[temp]));
        result.add((*pdb).crd(C[temp]));
        result.add((*pdb).crd(O[temp]));
    }
    
    return result;
}

Coords Residues::crds1norm(vector<residue_alignment> &align)
{
    Coords result;
    int temp;
    
    for(unsigned int i=0; i<align.size(); i++){
        temp = index[align[i].res1];
        result.add((*pdb).crd(N[temp]));
        result.add((*pdb).crd(CA[temp]));
        result.add((*pdb).crd(C[temp]));
        result.add((*pdb).crd(O[temp]));
    }
    
    return result.rmmean();
}

Coords Residues::crds2norm(vector<residue_alignment> &align)
{
    Coords result;
    int temp;
    
    for(unsigned int i=0; i<align.size(); i++){
        temp = index[align[i].res2];
        result.add((*pdb).crd(N[temp]));
        result.add((*pdb).crd(CA[temp]));
        result.add((*pdb).crd(C[temp]));
        result.add((*pdb).crd(O[temp]));
    }
    
    return result.rmmean();
}

vector<string> Residues::get_resid(Align &al, int protein)
{
    vector<string> temp;
    for(unsigned int i=1; i<=al.len(); i++){
        temp.push_back(resid[al.get(protein,i)]);
    }
    return temp;
}

string Residues::get_resid(int idx)
{
    return resid[idx];
}

string Residues::get_seq()
{
    string result = "";
    for(unsigned int i=0; i<resid.size(); i++){
        result += convert_resid((*pdb).get_resid(N[i]));  //convert 3char to 1char
    }
    
    return result;
}

string Residues::get_resid_indexed(int idx)
{
    if(index[idx]>=0){
        return resid[index[idx]];
    } else {
        return "";
    }
}

bool Residues::get_complete_indexed(int idx)
{
    if(index[idx]>=0){
        return complete[index[idx]];
    } else {
        return 0;
    }
}

vector<unsigned int> Residues::get_incomplete_residues()
{
    vector<unsigned int> result;
    for(unsigned int i=0; i<complete.size(); i++)
        if(!complete[i])
            result.push_back(residue[i]);
    return result;
}

bool Residues::valid_occup_indexed(int idx)
{
    if(index[idx]>=0){
        if((*pdb).get_occup(N[index[idx]])<=0.0) return 0;
        if((*pdb).get_occup(CA[index[idx]])<=0.0) return 0;
        if((*pdb).get_occup(C[index[idx]])<=0.0) return 0;
        if((*pdb).get_occup(O[index[idx]])<=0.0) return 0;
        for(unsigned int i=0; i<side[index[idx]].size(); i++){
            if((*pdb).get_occup(side[index[idx]][i])<=0.0) return 0;
        }
        return 1;
    }
    return 0;
}

bool Residues::valid_alt_indexed(int idx)
{
    if(index[idx]>=0){
        if((*pdb).get_alt(N[index[idx]])!=' ') return 0;
        if((*pdb).get_alt(CA[index[idx]])!=' ') return 0;
        if((*pdb).get_alt(C[index[idx]])!=' ') return 0;
        if((*pdb).get_alt(O[index[idx]])!=' ') return 0;
        for(unsigned int i=0; i<side[index[idx]].size(); i++){
            if((*pdb).get_alt(side[index[idx]][i])!=' ') return 0;
        }
        return 1;
    }
    return 0;
}

double Residues::get_asa_indexed(int idx)
{
    double result = 0.0;
    if(index[idx]>=0){
        result += (*pdb).get_asa(N[index[idx]]);
        result += (*pdb).get_asa(CA[index[idx]]);
        result += (*pdb).get_asa(C[index[idx]]);
        result += (*pdb).get_asa(O[index[idx]]);
        for(unsigned int i=0; i<side[index[idx]].size(); i++){
            result += (*pdb).get_asa(side[index[idx]][i]);
        }
    } else {
        result = -1.0;
    }
    
    return result;
}

string Residues::get_orig_resnum(int i)
{
    return (*pdb).get_orig_resnum(CA[i]);
}

string Residues::get_orig_resnum_idx(int i)
{
    return (*pdb).get_orig_resnum(CA[index[i]]);
}

coord Residues::crd_N(int i)
{
    return (*pdb).crd(N[i]);;
}

coord Residues::crd_CA(int i)
{
    return (*pdb).crd(CA[i]);;
}

coord Residues::crd_C(int i)
{
    return (*pdb).crd(C[i]);;
}

coord Residues::crd_O(int i)
{
    return (*pdb).crd(O[i]);;
}

Coords Residues::crd_side_idx(int i, bool main)
{
    return crd_side(index[i],main);
}

Coords Residues::crd_side(int i, bool main)
{
    Coords result;
    if(main){
        result.add((*pdb).crd(N[i]));
        result.add((*pdb).crd(CA[i]));
        result.add((*pdb).crd(C[i]));
        result.add((*pdb).crd(O[i]));
    } else {
        result.add((*pdb).crd(CA[i]));
    }
    for(unsigned int j=0; j<side[i].size(); j++){
        result.add((*pdb).crd(side[i][j]));
    }
    return result;
}

void Residues::erase(int i)
{
    residue.erase(residue.begin()+i);
    resid.erase(resid.begin()+i);
    side.erase(side.begin()+i);
    side_atom.erase(side_atom.begin()+i);
    side_element.erase(side_element.begin()+i);
    N.erase(N.begin()+i);
    CA.erase(CA.begin()+i);
    C.erase(C.begin()+i);
    O.erase(O.begin()+i);
    B.erase(B.begin()+i);
    return;
}

double Residues::get_bfact(int idx)
{
	return B[idx];
}

int Residues::get_res(int idx)
{
    return residue[idx];
}

vector<string> Residues::side_atoms_idx(int idx)
{
    return side_atom[index[idx]];
}

vector<string> Residues::side_atoms(int idx)
{
    return side_atom[idx];
}

/*vector<string> Residues::side_elements_idx(int idx)
{
    return side_element[index[idx]];
}*/

vector<int> Residues::get_side(int idx)
{
	return side[idx];
}

int Residues::get_side(int idx, unsigned int &i)
{
	return side[idx][i];
}

int Residues::get_N(int idx)
{
	return N[idx];
}

int Residues::get_CA(int idx)
{
	return CA[idx];
}

int Residues::get_C(int idx)
{
	return C[idx];
}

int Residues::get_O(int idx)
{
	return O[idx];
}

int Residues::get_side_idx(int idx, unsigned int &i)
{
	return side[index[idx]][i];
}

int Residues::get_N_idx(int idx)
{
	return N[index[idx]];
}

int Residues::get_CA_idx(int idx)
{
	return CA[index[idx]];
}

int Residues::get_C_idx(int idx)
{
	return C[index[idx]];
}

int Residues::get_O_idx(int idx)
{
	return O[index[idx]];
}


bool Residues::valid(int i)
{
    if(N[i]==-1 || CA[i]==-1 || C[i]==-1 || O[i]==-1){
        return 0;
    } else {
        return 1;
    }
}

int Residues::res(int i)
{
    return residue[i];
}

int Residues::res_indexed(int i)
{
    if(index[i]>=0){
        return residue[index[i]];
    } else {
        return -1;
    }
}

vector<int> Residues::get_res()
{
    return residue;
}

int Residues::size()
{
    return residue.size();
}

int Residues::index_size()
{
    return index.size();
}

int Residues::last()
{
    return residue[residue.size()-1];
}

void Residues::view()
{
    cout << endl << "Size: " << residue.size();
    cout << endl << "i\tResNo\tResid";
    for(unsigned int i=0; i<residue.size(); i++){
        cout << endl << i << "\t" << residue[i] << "\t" << resid[i] << index[residue[i]];
    }
    
    return;
}

void Residues::create(PDBfile &pdb1)
{
    int current_resnum = -1000;
    int resnum;
    int idx = -1;
    vector<int> empty;
	vector<double> emptyd;
    vector<string> empty_string;
    string atom_type;
    string atom_element;
	vector<vector<double> > Bv;
    
	residue.clear();
	index.clear();
	side.clear();
	side_atom.clear();
	N.clear();
	CA.clear();
	C.clear();
	O.clear();
	resid.clear();
	B.clear();
    complete.clear();
	
    pdb = &pdb1;

    for(int i=0; i<pdb1.size(); i++){
        resnum = pdb1.get_resnum(i);
        atom_type = pdb1.get_atom(i);
        atom_element = pdb1.get_element(i);
        if(resnum > current_resnum){		//new residue
            residue.push_back(resnum);
            resid.push_back(pdb1.get_resid(i));
            current_resnum = resnum;
            side.push_back(empty);
            side_atom.push_back(empty_string);
            side_element.push_back(empty_string);
            Bv.push_back(emptyd);
            N.push_back(-1);
            CA.push_back(-1);
            C.push_back(-1);
            O.push_back(-1);
            idx++;
        }
       if(USE_DNARNA){
          if(atom_type == " O5'"){
             N[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " C1'"){
             CA[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " C4'"){
             C[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " O3'"){
             O[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else {
             side[idx].push_back(i);
             side_atom[idx].push_back(atom_type);
             side_element[idx].push_back(atom_element);
          }
       } else {
          if(atom_type == " N  "){
             N[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " CA "){
             CA[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " C  "){
             C[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else if (atom_type == " O  "){
             O[idx] = i;
             Bv[idx].push_back(pdb1.get_bfact(i));
          } else {
             side[idx].push_back(i);
             side_atom[idx].push_back(atom_type);
             side_element[idx].push_back(atom_element);
          }
       }
    }
    for(unsigned int i=0; i<residue.size(); i++){
        if(Bv[i].size()!=4){
            residue.erase(residue.begin()+i);
            resid.erase(resid.begin()+i);
            side.erase(side.begin()+i);
            side_atom.erase(side_atom.begin()+i);
            side_element.erase(side_element.begin()+i);
            N.erase(N.begin()+i);
            CA.erase(CA.begin()+i);
            C.erase(C.begin()+i);
            O.erase(O.begin()+i);
            Bv.erase(Bv.begin()+i);
            i--;
        } else {
            B.push_back((Bv[i][0]+Bv[i][1]+Bv[i][2]+Bv[i][3])/4);
            complete.push_back(complete_residue(resid[i],side[i].size()));
		}
    }

    for(int i=0; i<=residue.back(); i++){
        index.push_back(-1);
    }
    for(unsigned int i=0; i<residue.size(); i++){
        index[residue[i]] = i;
    }
	return;
}

/*void Residues::write_formatted_res(string file)
 //writes formatted res info, ready for ProSMART ALIGN to read.
 {
 ofstream outfile;
 
 outfile.open(file.c_str());
 if(outfile.is_open()){
 for(unsigned int i=0; i<residue.size(); i++){
 outfile << residue[i] << "\t" 
 << index[i] << "\t"
 << side[i].size() << "\t";
 for(unsigned int j=0; j<side[i].size(); j++){
 outfile << side[i][j] << "\t";
 }
 outfile << side_atom[i].size() << "\t";
 for(unsigned int j=0; j<side_atom[i].size(); j++){
 outfile << side_atom[i][j] << "\t";
 }
 outfile << N[i] << "\t"
 << CA[i] << "\t"
 << C[i] << "\t"
 << O[i] << "\t"
 << resid[i] << "\t"
 << B[i] << "\n";
 }
 outfile.close();
 } else {
 cout << endl << endl << "Error - cannot open " << file << " for writing." << endl << endl;
 exit(-1);
 }
 return;
 }
 
 void Residues::read_formatted_res(string file, PDBfile &pdb1)
 {
 ifstream infile(file.c_str());
 
 if(!infile){
 cout << endl << endl << "Error - cannot open " << file << " for reading." << endl << endl;
 exit(-1);
 }
 
 vector<int> temp_vi;
 vector<string> temp_vs;
 
 pdb = &pdb1;
 
 string tmp;
 int n;
 while(!infile.eof()) {
 
 getline(infile,tmp,'\t');
 if(infile.eof()){break;}
 residue.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 index.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 n=str_to_int(tmp);
 temp_vi.clear();
 for(int i=0; i<n; i++){
 getline(infile,tmp,'\t');
 temp_vi.push_back(str_to_int(tmp));
 }
 side.push_back(temp_vi);
 
 getline(infile,tmp,'\t');
 n=str_to_int(tmp);
 temp_vs.clear();
 for(int i=0; i<n; i++){
 getline(infile,tmp,'\t');
 temp_vs.push_back(tmp);
 }
 side_atom.push_back(temp_vs);
 
 getline(infile,tmp,'\t');
 N.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 CA.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 C.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 O.push_back(str_to_int(tmp));
 
 getline(infile,tmp,'\t');
 resid.push_back(tmp);
 
 getline(infile,tmp,'\t');
 B.push_back(str_to_int(tmp));
 }
 
 infile.close();
 return;
 }*/

bool complete_residue(string &resid, unsigned int n)
{
    bool result = 1;
    if(resid == "ALA"){
        if(n<1)result = 0;
    } else if(resid == "ARG"){
        if(n<7)result = 0;
    } else if(resid == "ASN"){
        if(n<4)result = 0;
    } else if(resid == "ASP"){
        if(n<4)result = 0;
    } else if(resid == "CYS"){
        if(n<2)result = 0;
    } else if(resid == "GLU"){
        if(n<5)result = 0;
    } else if(resid == "GLN"){
        if(n<5)result = 0;
    } else if(resid == "GLY"){
        if(n<0)result = 0;
    } else if(resid == "HIS"){
        if(n<6)result = 0;
    } else if(resid == "ILE"){
        if(n<4)result = 0;
    } else if(resid == "LEU"){
        if(n<4)result = 0;
    } else if(resid == "LYS"){
        if(n<5)result = 0;
    } else if(resid == "MET"){
        if(n<4)result = 0;
    } else if(resid == "PHE"){
        if(n<7)result = 0;
    } else if(resid == "PRO"){
        if(n<3)result = 0;
    } else if(resid == "SER"){
        if(n<2)result = 0;
    } else if(resid == "THR"){
        if(n<3)result = 0;
    } else if(resid == "TRP"){
        if(n<10)result = 0;
    } else if(resid == "TYR"){
        if(n<8)result = 0;
    } else if(resid == "VAL"){
        if(n<3)result = 0;
    } else if(resid == "MSE"){
        if(n<4)result = 0;
    }
    return result;
}
