//
// This file is part of ProSMART.
//

#ifndef alignClass_Residues_H
#define alignClass_Residues_H

#include "prosmartClass_PDBfile.h"
#include "alignClass_Align.h"

class Residues		//note - the Residues class is indiscriminate of chain - if a particular
{					//chain is required, then it should be separated from the PDBfile object
private:			//prior to creation of an object of class Residues.
	PDBfile* pdb;
	vector<int> residue;				//lists residues in pdb.
	vector<int> index;					//indexes the 'residue' vector.
	vector<vector<int> > side;			//side[i] contains pdb indexes of sidechain atoms in residue residue[i].
	vector<vector<string> > side_atom;	//stores atom name; corresponds to 'side'.
	vector<vector<string> > side_element;	//stores atom element; corresponds to 'side'.
	vector<int> N;						//CA[i] indexes the element of atom[i] that corresponds to the residue's CA atom (CA[i]=-1 if it doesnt exist).
	vector<int> CA;
	vector<int> C;	
	vector<int> O;
	vector<string> resid;
	vector<double> B;					//average B-factor of main chain atoms
    vector<bool> complete;              // 1 if N_atoms is expected, given residue type
public:
	void create(PDBfile &);
	void view();
	int size();
    void erase(int);
	int index_size();
	int last();
	int res(int);
	int res_indexed(int);
	vector<int> get_res();
	bool valid(int);
	coord crd_N(int);
	coord crd_CA(int);
	coord crd_C(int);
	coord crd_O(int);
	double get_bfact(int);
	vector<int> get_side(int);
	int get_side(int, unsigned int &);
	int get_side_idx(int, unsigned int &);
	int get_res(int);
    string get_orig_resnum(int);
    string get_orig_resnum_idx(int);
	int get_N(int);
	int get_CA(int);
	int get_C(int);
	int get_O(int);
    int get_N_idx(int);
	int get_CA_idx(int);
	int get_C_idx(int);
	int get_O_idx(int);
	Coords crd_side(int,bool);
	Coords crd_side_idx(int,bool);
	vector<string> side_atoms(int);
	vector<string> side_atoms_idx(int);
	//vector<string> side_elements_idx(int);
	vector<string> get_resid(Align &, int);
	string get_seq();    
	string get_resid(int);
	string get_resid_indexed(int);
	bool get_complete_indexed(int);
	double get_asa_indexed(int);
    bool valid_occup_indexed(int);
    bool valid_alt_indexed(int);
    vector<unsigned int> get_incomplete_residues();
	Coords crds1norm(vector<residue_alignment> &);
	Coords crds2norm(vector<residue_alignment> &);
	Coords crds1(vector<residue_alignment> &);
	Coords crds1_all();
	Coords crds2(vector<residue_alignment> &);
	//void write_formatted_res(string);
	//void read_formatted_res(string, PDBfile&);
};

bool complete_residue(string &, unsigned int);

#endif
