//
// This file is part of ProSMART.
//

#ifndef align_alignment_algorithm_H
#define align_alignment_algorithm_H

#include "align_helix.h"
#include "jama_eig.h"

//#define ALIGN_REFINE_COUTS

Array2D<double> fragDM_CA(Frag &, Frag &, Array1D<Coords> &, Array1D<Coords> &, vector<double> &, vector<double> &);
Array2D<double> fragDM_all(Frag &, Frag &, Array1D<Coords> &, Array1D<Coords> &, vector<double> &, vector<double> &);
Array2D<double> fragDM_all(Frag &, Frag &);
Array1D<double> eigenvalues(Coords &);
void output_align_moments(Align &, Frag &, Frag &, Array2D<double> &);
void output_moments(Align &, Frag &, Frag &, Array2D<double> &);
Align dynamAlign(Array2D<double>&, Frag&, Frag&, double, double);
Align identicalAlign(Frag &, Frag &, vector<res_corresp> &, vector<res_corresp> &);
Align align_refine(Align &, Array2D<double> &);
bool align_refine_point(Array2D<double> &, vector<int> &, vector<int> &, vector<int> &);
bool align_refine_segment(Array2D<double> &, vector<int> &, vector<int> &, vector<int> &);
bool align_refine_max(Array2D<double> &, vector<int> &, vector<int> &, vector<int> &);
double frag_seq_score(int, int, int, Array2D<double> &);
Align align_residues(Frag &, Frag &, Align &, Array2D<double> &, unsigned short);
Align refine_alignment(Align &, Array2D<double> &, unsigned short);
void ensure_res_corresp(Align &, Frag &, Frag &, Array2D<double> &, vector<res_corresp> &, vector<res_corresp> &);
bool further_refine_extend(Align &, Frag &, Frag &, Array2D<double> &);
bool further_refine_point(Align &, Frag &, Frag &, Array2D<double> &);
bool further_refine_erase(Align &, Frag &, Frag &, Array2D<double> &);
bool further_refine_erase_iterate(Align &, Frag &, Frag &, Array2D<double> &, int, vector<bool>&);

Array2D<double> mod_FDM_by_sequence(Frag &, Frag &, Array2D<double> &, bool, double &);
bool compare_fragment_sequence(Frag &, Frag &, int &, int &);

#endif
