//
// This file is part of ProSMART.
//

#include "align_alignment_scoring.h"

void get_res_align(Align &alignment, Frag &frag1, Frag &frag2, Array2D<double> &FDM, vector<residue_alignment> &Res_align, double frag_mod, vector<residue_alignment> &Res_align_sim, double ALIGN_SCORE, double &SeqID, double &SeqIDsim, Residues &res1, Residues &res2, vector<double> &frag_rot, vector<vector<double> > &other_scores, vector<string> &res_sse1, vector<string> &res_sse2, bool NORM_PROC, bool USE_MAINCHAIN_FOR_SIDERMSD, double &NUM_DIST_THRESHOLD, bool FIX_SIDE_CHAIN_ERRORS,bool SCORE_STRICT)
//new function. Assumes fragment alignment implies one-to-one residue correspondence.
//alignment is based on the minimum score, not the central.
{
    SeqID = 0.0;
    SeqIDsim = 0.0;
    residue_alignment temp;
    int N = frag1.len();
    
    int offset = (N-1)/2;
    vector<double> min_score;
    vector<int> min_offset;
    vector<double> cen_score;
    vector<int> cen_idx;
    vector<int> f1;
    vector<int> f2;
    vector<int> f1_cen;
    vector<int> f2_cen;
    vector<int> r1;
    vector<int> r2;
    double temp_score;
    int idx;
	//vector<string> type1;
	//vector<string> type2;
	int tmp1;
	int tmp2;
    
    //get minimum score
    for(unsigned int i=1; i<=alignment.len(); i++){
		tmp1 = alignment.get(1,i);
		tmp2 = alignment.get(2,i);
        idx = frag1.idx(tmp1);
        while((int)min_score.size() < idx+N){	//ensure arrays are long enough
            min_score.push_back(-1.0);
            min_offset.push_back(0);
            cen_score.push_back(-1.0);
            cen_idx.push_back(-1);
            f1.push_back(-1);
            f2.push_back(-1);
            r1.push_back(-1);
            r2.push_back(-1);
            f1_cen.push_back(-1);
            f2_cen.push_back(-1);
            //type1.push_back("NA");
            //type2.push_back("NA");
        }
        temp_score = FDM[tmp1][tmp2];	//get score corresponding to fragment
        for(int j=0; j<N; j++){
            if(NORM_PROC==0){
                if(temp_score < min_score[idx+j] || min_score[idx+j] < 0.0){
                    min_score[idx+j] = temp_score;
                    min_offset[idx+j] = j - offset;
                    f1[idx+j] = tmp1;
                    f2[idx+j] = tmp2;
                    r1[idx+j] = idx+j;
                    r2[idx+j] = frag2.idx(tmp2)+j;
                }
            } else if(temp_score > min_score[idx+j] || min_score[idx+j] < 0.0){	//this is for standardised Procrustes SIMilarity score, where higher scores indicate better score.
                min_score[idx+j] = temp_score;
                min_offset[idx+j] = j - offset;
                f1[idx+j] = tmp1;
                f2[idx+j] = tmp2;
                r1[idx+j] = idx+j;
                r2[idx+j] = frag2.idx(tmp2)+j;
            }
        }
        cen_idx[idx+offset] = i;
        f1_cen[idx+offset] = tmp1;
        f2_cen[idx+offset] = tmp2;
    }
    /*for(unsigned int i=0; i<min_score.size(); i++){
     cout << f1[i] << " " << f2[i] << "  " << r1[i] << " " << r2[i] << "  " << min_score[i] << "  " << f1_cen[i] << "  " << f2_cen[i] << endl;
     }*/
    
	vector<double> emptyv;
	for(unsigned int i=0; i<other_scores[0].size(); i++){
		emptyv.push_back(-1);
	}
	
#ifdef RUN_AREAIMOL
    temp.asa1 = 0.0;
    temp.asa2 = 0.0;
#endif
    
    vector<string> side_atoms1;
    vector<double> interatomic_distances;
    vector<double> interatomic_distances_global;
    //construct Res_Align object
    for(unsigned int i=0; i<min_score.size(); i++){
        //cout << endl << f1[i] << " " << f2[i] << "  " << r1[i] << " " << r2[i] << "  " << min_score[i] << " " << min_offset[i] << "  " << cen_score[i];
        //cout << "   " << cen_idx[i] << "  " << f1_cen[i] << " " << f2_cen[i];
        
        if(f1[i] >= 0){
            //if(f1_cen[i] >= 0){			//if this residue-pair has been assigned a fragment-pair for calculation of central score
            
            //cout << "  " << FDM[f1_cen[i]][f2_cen[i]];
            //cout << "  " << res1.get_resid_indexed(r1[i]);
            //cout << " " << res2.get_resid_indexed(r2[i]);
            
            temp.res1 = r1[i];
            temp.res2 = r2[i];
            temp.type1 = res_sse1[r1[i]];
            temp.type2 = res_sse2[r2[i]];
            temp.dist = min_score[i];									//minimum score
            if(f1_cen[i] >= 0){
                temp.dist2 = FDM[f1_cen[i]][f2_cen[i]];		//central score
                temp.rot = frag_rot[cen_idx[i]-1];
                temp.other = other_scores[cen_idx[i]-1];
                //cout << endl << f1_cen[i] << " " << f2_cen[i] << " " << temp.dist2 << " " << cen_idx[i] << " " << other_scores[cen_idx[i]-1];
            } else {
                temp.dist2 = -1;
                temp.rot = -1;
                temp.other = emptyv;
            }
            temp.dist4 = sidechain_AV(frag1,frag2,f1[i],f2[i],min_offset[i]);
            //cout << "  " << temp.dist4;
            temp.atoms.clear();
            temp.atom_indexes.clear();
                       
           if(SCORE_STRICT){  //complete side chains
            temp.complete1 = res1.get_complete_indexed(r1[i]);
            temp.complete2 = res2.get_complete_indexed(r2[i]);
           }
            bool USE_SIDE_CHAIN_SCORES = 0;
           if(res1.get_resid_indexed(r1[i]) == res2.get_resid_indexed(r2[i])){  //require same residue type
              if(SCORE_STRICT){
                 if(temp.complete1 && temp.complete2) //complete side chains
                    if(res1.valid_occup_indexed(r1[i]) && res2.valid_occup_indexed(r2[i]))   //all non-zero occupancies
                       if(res1.valid_alt_indexed(r1[i]) && res2.valid_alt_indexed(r2[i])) //no alts
                          USE_SIDE_CHAIN_SCORES = 1;
              } else {
                 USE_SIDE_CHAIN_SCORES = 1;
              }
           }
            
            if(USE_SIDE_CHAIN_SCORES){
                interatomic_distances = sidechain_distances(frag1,frag2,f1[i],f2[i],min_offset[i],side_atoms1,USE_MAINCHAIN_FOR_SIDERMSD,temp.atoms,temp.atom_indexes,FIX_SIDE_CHAIN_ERRORS);
                //list of atom names stored in side_atoms1
                temp.dist3 = RMSD(interatomic_distances);
                temp.dist5 = max(interatomic_distances);
               
#ifdef INCLUDE_SCORE_NUMDIST
                temp.dist6 = no_greater_than(interatomic_distances,NUM_DIST_THRESHOLD);    //number of atoms with distances greater than X.
#else
                temp.dist6 = -1;
#endif
#ifdef INCLUDE_SCORE_NUMTOTAL
               temp.dist7 = (int)interatomic_distances.size();    //number of atoms in residue.
#else
               temp.dist7 = -1;
#endif
                //temp.dist3 = sidechain_RMSD(frag1,frag2,f1[i],f2[i],min_offset[i]);
                //cout << " * " << temp.dist3; // << " " << sidechain_RMSD(frag1,frag2,f1_cen[i],f2_cen[i],0);

            } else {
                temp.dist3 = -1.0;
                temp.dist5 = -1.0;
                temp.dist6 = -1;
                temp.dist7 = -1;
            }
#ifdef RUN_AREAIMOL
            temp.asa1 = res1.get_asa_indexed(r1[i]);
            temp.asa2 = res2.get_asa_indexed(r2[i]);
#endif
            Res_align.push_back(temp);
            if(temp.dist <= ALIGN_SCORE){
                Res_align_sim.push_back(temp);
            }
            
            if(res1.get_resid_indexed(r1[i]) == res2.get_resid_indexed(r2[i])){
                SeqID++;
                if(temp.dist <= ALIGN_SCORE){
                    SeqIDsim++;
                }
            }
        }
    }
    
    if(Res_align.size()>0){
        SeqID = (double)((SeqID*100.0)/Res_align.size());
    } else {
        SeqID = 0.0;
    }
    if(Res_align_sim.size()>0){
        SeqIDsim = (double)((SeqIDsim*100.0)/Res_align_sim.size());
    } else {
        SeqIDsim = 0.0;
    }
    
    return;
}

/*
 double get_residue_alignment(Align &alignment, Frag &frag1, Frag &frag2, Array2D<double> &FDM, vector<residue_alignment> &Res_align, double frag_mod, vector<residue_alignment> &Res_align_sim, vector<residue_alignment> &Res_align_conserved, double ALIGN_SCORE, double &SeqIDsim, double &SeqIDconserved)
 // this is the old function, that only aligns the central residue
 {
 double SeqID = 0.0;
 SeqIDsim = 0.0;
 SeqIDconserved = 0.0;
 residue_alignment temp;
 vector<double> min_score;
 double temp_score;
 int idx;
 int idx2;
 int N = frag1.len();
 
 for(unsigned int i=1; i<=alignment.len(); i++){
 idx = frag1.idx(alignment.get(1,i));
 while(min_score.size() < idx+N){
 min_score.push_back(-1.0);
 }
 temp_score = FDM[alignment.get(1,i)][alignment.get(2,i)];
 for(unsigned int j=0; j<N; j++){
 if(temp_score < min_score[idx+j] || min_score[idx+j] < 0.0){
 min_score[idx+j] = temp_score;
 }
 }
 }
 
 int tmp;
 Res_align_sim.clear();
 for(unsigned int i=1; i<=alignment.len(); i++){
 idx = alignment.get(1,i);
 idx2 = alignment.get(2,i);
 temp.res1 = frag1.idx(idx)+frag_mod;
 temp.res2 = frag2.idx(idx2)+frag_mod;
 temp.dist = FDM[idx][idx2];	//central
 temp.dist2 = min_score[temp.res1];							//minimum
 if(frag1.get_resid_frag(idx,frag_mod) == frag2.get_resid_frag(idx2,frag_mod)){
 temp.dist3 = sidechain_RMSD(frag1,frag2,idx,idx2);
 } else {
 temp.dist3 = -1.0;
 }
 temp.dist4 = sidechain_AV(frag1,frag2,idx,idx2);
 Res_align.push_back(temp);
 //cout << endl << i << " " << idx << " " << idx2 << " " << temp.res1 << " " << temp.res2 << " " << temp.dist << " " << temp.dist2;
 //cout << " " << frag1.get_resid_frag(idx,frag_mod) << " " << frag2.get_resid_frag(idx2,frag_mod);
 if(temp.dist2 <= ALIGN_SCORE){
 Res_align_sim.push_back(temp);
 }
 if(temp.dist <= ALIGN_SCORE){
 Res_align_conserved.push_back(temp);
 }
 if(frag1.get_resid_frag(idx,frag_mod).compare(frag2.get_resid_frag(idx2,frag_mod)) == 0){
 SeqID++;
 //cout << " conserved";
 if(temp.dist2 <= ALIGN_SCORE){
 SeqIDsim++;
 }
 if(temp.dist <= ALIGN_SCORE){
 SeqIDconserved++;
 }
 }
 }
 SeqIDsim = (double)((SeqIDsim*100.0)/Res_align_sim.size());
 SeqIDconserved = (double)((SeqIDconserved*100.0)/Res_align_conserved.size());
 
 return (double)((SeqID*100.0)/Res_align.size());
 }
 */

void side_global_RMSD(vector<residue_alignment> &Res_align, Residues &res1, Residues &res2, double &SUPERPOSE, string &fileout_side)
{        
    ////////
    //Get global transformation, based on 'similar' alignment
    vector<residue_alignment> Res_align_sim;
    if(SUPERPOSE>1000){
        Res_align_sim = Res_align;
    } else {
        for(unsigned int i=0; i<Res_align.size(); i++){
            if(Res_align[i].dist <= SUPERPOSE){
                Res_align_sim.push_back(Res_align[i]);
            }
        }
        if(Res_align_sim.size()==0){
            Res_align_sim = Res_align;
        }
    }
    
    Transform global_transf;
	if(Res_align_sim.size()==0){
		global_transf.create();
	} else {
        
#define USE_SIDE_CHAIN_COORDS
#ifdef USE_SIDE_CHAIN_COORDS
        Coords c1;
        Coords c2;
        for(unsigned int i=0; i<Res_align.size(); i++){
            Coords tmp1 = res1.crd_side_idx(Res_align[i].res1,1);
            Coords tmp2 = res2.crd_side_idx(Res_align[i].res2,1);
            if(tmp1.size()==tmp2.size()){
                c1.append(tmp1);
                c2.append(tmp2);
            }
        }
#else
		Coords c1 = res1.crds1(Res_align_sim);
        Coords c2 = res2.crds2(Res_align_sim);
#endif
		/*coord mean1 = c1.mean();
		coord mean2 = c2.mean();
		Coords c1n = c1-mean1;
		Coords c2n = c2-mean2;
		Array2D<double> RM = rotateM(c1n,c2n);
		global_transf.create(mean2,RM,mean1);*/		//translate to origin, rotate to agree with chain1, translate onto chain1.
        global_transf = get_transf(c1,c2);
    }
    
    side_global_RMSD(Res_align,res1,res2,fileout_side,global_transf);
    
    return;
}

void side_global_RMSD(vector<residue_alignment> &Res_align, Residues &res1, Residues &res2, string &fileout_side, Transform &global_transf)
{
    
    bool USE_MAINCHAIN_FOR_SIDERMSD = 1;
    bool FIX_SIDE_CHAIN_ERRORS = 0;
    
    ////////

    stringstream ss;
    ss << "# " << get_filename(fileout_side) << endl;
    ss << "Res1\tRes2\tAtom\tRMSD\n";


   for(unsigned int i=0; i<Res_align.size(); i++){
        
        ////////
        //Get list of atoms in residue
        vector<string> side_atoms1 = res1.side_atoms_idx(Res_align[i].res1);
        vector<string> side_atoms2 = res2.side_atoms_idx(Res_align[i].res2);
        if(USE_MAINCHAIN_FOR_SIDERMSD){
            side_atoms1.insert(side_atoms1.begin()," O  ");
            side_atoms2.insert(side_atoms2.begin()," O  ");
            side_atoms1.insert(side_atoms1.begin()," C  ");
            side_atoms2.insert(side_atoms2.begin()," C  ");
            side_atoms1.insert(side_atoms1.begin()," CA ");
            side_atoms2.insert(side_atoms2.begin()," CA ");
            side_atoms1.insert(side_atoms1.begin()," N  ");
            side_atoms2.insert(side_atoms2.begin()," N  ");
        } else {
            side_atoms1.insert(side_atoms1.begin()," CA ");
            side_atoms2.insert(side_atoms2.begin()," CA ");
        }
        
        ////////
        //get coords corresponding to atoms
        Coords side1 = res1.crd_side_idx(Res_align[i].res1,USE_MAINCHAIN_FOR_SIDERMSD);
        Coords side2 = res2.crd_side_idx(Res_align[i].res2,USE_MAINCHAIN_FOR_SIDERMSD);
        
        ////////
        //require atoms to have the same nomenclature.
        //remove atoms not found in both side chains - modify 'side1'.
        //identify corresponding atoms - modify 'side2'.
        //store atom names corresponding to coordinates 'side1' and 'side2' in 'atoms'.
        Coords side1_temp;
        Coords side2_temp;
        vector<string> atoms;
        vector<int> side_idx;
        if(side_atoms1 != side_atoms2){		//either there are missing atoms, or the atoms are in a different order in the PDB file.
            for(unsigned int i=0; i<side_atoms1.size(); i++){
                side_idx.push_back(-1);			//fill vector with false values (-1 in this case)
            }
            for(unsigned int i=0; i<side_atoms1.size(); i++){
                for(unsigned int j=0; j<side_atoms2.size(); j++){
                    if(side_atoms1[i]==side_atoms2[j]){     //require the atom names to be identical
                        side_idx[i] = j;
                        break;
                    }
                }
            }
            for(unsigned int i=0; i<side_idx.size(); i++){
                if(side_idx[i]>=0){ //atom present in both side chains
                    atoms.push_back(side_atoms1[i]);
                    side1_temp.add(side1.get_crd(i));
                    side2_temp.add(side2.get_crd(side_idx[i]));
                }
            }
            side1 = side1_temp;
            side2 = side2_temp;
        } else {
            atoms = side_atoms1;
        }
        
        
        ////////
        //apply global transformation to atoms from chain2
        Coords side2_transf = global_transf.transform(side2);
        ////////
        //fix nomenclature issues, and allow flips
        //get distances between corresponding atoms
        vector<double> atomic_distances;
        vector<int> atom_indexes;
        for(unsigned int j=0; j<atoms.size(); j++){
            atom_indexes.push_back(j);
        }
        if(side1.size()==side2_transf.size()){     //note: this should always be true
            vector<coord> tmp1;
            vector<coord> tmp2;
            for(int j=0; j<side1.size(); j++){
                tmp1.push_back(side1.get_crd(j));
#ifdef SIDE_SCORES_ORIG_COORD_FRAME
                tmp2.push_back(side2.get_crd(j));
#else
                tmp2.push_back(side2_transf.get_crd(j));
#endif
            }
            
            for(unsigned int j=0; j<tmp1.size(); j++){
                atomic_distances.push_back(dist(tmp1[j],tmp2[j]));
            }
            
            //detect and fix any nomenclature issues
            string resid = res1.get_resid_indexed(Res_align[i].res1);
            bool fixed = 0;
            if(resid == "PHE" || resid == "TYR")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," CD1"," CD2"," CE1"," CE2");
            else if(resid == "ARG")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," NH1"," NH2");
            else if(resid == "ASP")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," OD1"," OD2");
            else if(resid == "GLU")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," OE1"," OE2");
            else if(resid == "VAL")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," CG1"," CG2");
            else if(resid == "LEU")
                fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," CD1"," CD2");
            if(!fixed && FIX_SIDE_CHAIN_ERRORS){
                if(resid == "HIS")
                    fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," ND1"," CD2"," CE1"," NE2");
                else if(resid == "THR")
                    fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," OG1"," CG2");
                else if(resid == "ASN")
                    fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," OD1"," ND2");
                else if(resid == "GLN")
                    fixed = fix_nomenclature(1,atom_indexes,atomic_distances,atoms,tmp1,tmp2," OE1"," NE2");
            }
        }
        
#ifdef OVERWRITE_MAXDIST_NDIST_SCORES
        ////////
        //get scores
        //overwrite dist5 and dist6 in Res_align
        double max_dist = 0.0;
        int n_dist = 0;
        for(unsigned int j=0; j<atomic_distances.size(); j++){
            if(atomic_distances[j]>1.0)
                n_dist++;
            if(atomic_distances[j]>max_dist)
                max_dist = atomic_distances[j];
        }
        Res_align[i].dist5 = max_dist;
        Res_align[i].dist6 = n_dist;
        Res_align[i].dist7 = (int)atomic_distances.size();
#endif 
       
      
#ifdef CYRUS_SPECIAL_RMSD_FORMAT
        for(unsigned int j=0; j<atomic_distances.size(); j++){
            if(atomic_distances[j]<1.0)continue;
            ss.precision(2);
            ss << i << "\t" << atoms[j] << "\t" << atomic_distances[j] << endl;
        }
#else
        /*for(unsigned int j=0; j<atomic_distances.size(); j++){
            ss << i << "\t" << j << "\t" << atoms[j] << "\t" << atomic_distances[j] << endl;
        }*/
        
        for(unsigned int j=0; j<atomic_distances.size(); j++){
           ss << res1.get_orig_resnum_idx(Res_align[i].res1) << "\t" << res2.get_orig_resnum_idx(Res_align[i].res2) << "\t" << atoms[j] << "\t" << atomic_distances[j] << endl;
            //ss << Res_align[i].res1 << "\t" << Res_align[i].res2 << "\t" << atoms[j] << "\t" << atomic_distances[j] << endl;
        }
        
        
        
#endif
        
        /*cout << endl << Res_align[i].res1
        << "\t" << Res_align[i].res2
        << endl << "\t" << side_atoms1
        << endl << "\t" << side_atoms2
        << endl << "\t" << atoms
        << endl << side1
        << endl << side2_transf
        << endl << atomic_distances
        << endl << Res_align[i].dist5 << "\t" << max_dist
        << endl << Res_align[i].dist6 << "\t" << n_dist
        << endl;*/
    }
    
    ofstream outfile;
    outfile.open(fileout_side.c_str());
    if(outfile.is_open()){
        outfile << ss.str();
        outfile.close();
    }
    
    return;
}

vector<double> sidechain_distances(Frag &f1, Frag &f2, int idx, int idx2, int offset, vector<string> &side_atoms1, bool USE_MAINCHAIN_FOR_SIDERMSD, vector<string> &atoms, vector<int> &atom_indexes, bool FIX_SIDE_CHAIN_ERRORS)
//returns vector of distance between atoms, after fragments have been superimposed.
//may or may not include mainchain atoms.
//it is assumed that residues are of the same type
{
    Coords frag1;
    Coords frag2;
    Transform transf1;
    Transform transf2;
    
    f1.crds(frag1,idx);
    f2.crds(frag2,idx2);
    coord mean1 = frag1.mean();
    coord mean2 = frag2.mean();
    Coords f1n = frag1-mean1;
    Coords f2n = frag2-mean2;
    
    //cout << endl << frag1 << endl;
    //cout << frag2 << endl;
    //cout << RMSD(frag1,frag2) << endl;
    //cout << RMSD(f1n,f2n) << endl;
    
    Array2D<double> RM = rotateM(f1n,f2n);
    //Coords f2n_rot = f2n*RM;
    //cout << RMSD(f1n,f2n_rot) << endl;
    
    transf1.create(mean1);
    transf2.create(mean2,RM);
    
    vector<double> result;
    Coords side1_transf;
    Coords side2_transf;
    
    Coords side1;
    Coords side2;
    if(USE_MAINCHAIN_FOR_SIDERMSD){
        side1 = f1.central_side(idx,offset,1);       //use all mainchain.
        side2 = f2.central_side(idx2,offset,1);
    } else {
        side1 = f1.central_side(idx,offset,0);       //use only CA.
        side2 = f2.central_side(idx2,offset,0);
    }
    //cout << endl << "side1:" << endl << side1 << endl;
    //cout << endl << "side2:" << endl << side2 << endl;
    
    side_atoms1.clear();
    side_atoms1 = f1.get_side_atom(idx,offset);
    vector<string> side_atoms2 = f2.get_side_atom(idx2,offset);
    if(USE_MAINCHAIN_FOR_SIDERMSD){
        side_atoms1.insert(side_atoms1.begin()," O  ");
        side_atoms2.insert(side_atoms2.begin()," O  ");
        side_atoms1.insert(side_atoms1.begin()," C  ");
        side_atoms2.insert(side_atoms2.begin()," C  ");
        side_atoms1.insert(side_atoms1.begin()," CA ");
        side_atoms2.insert(side_atoms2.begin()," CA ");
        side_atoms1.insert(side_atoms1.begin()," N  ");
        side_atoms2.insert(side_atoms2.begin()," N  ");
    } else {
        side_atoms1.insert(side_atoms1.begin()," CA ");
        side_atoms2.insert(side_atoms2.begin()," CA ");
    }
    
    //cout << endl << f1.get_side_resid(idx,offset) << "  " << f2.get_side_resid(idx2,offset);
    //cout << endl << "1:  " << side_atoms1;
    //cout << endl << "2:  " << side_atoms2 << endl;
    
    /*vector<string> side_elements1 = f1.get_side_element(idx,offset);
    vector<string> side_elements2 = f2.get_side_element(idx2,offset);
    //sort out atom correspondences here. This does not include main chain atoms (inc CA).
    if(USE_MAINCHAIN_FOR_SIDERMSD){
        side_elements1.insert(side_elements1.begin()," O");
        side_elements2.insert(side_elements2.begin()," O");
        side_elements1.insert(side_elements1.begin()," C");
        side_elements2.insert(side_elements2.begin()," C");
        side_elements1.insert(side_elements1.begin()," C");
        side_elements2.insert(side_elements2.begin()," C");
        side_elements1.insert(side_elements1.begin()," N");
        side_elements2.insert(side_elements2.begin()," N");
    } else {
        side_elements1.insert(side_elements1.begin()," C");
        side_elements2.insert(side_elements2.begin()," C");
    }
    cout << "1t: " << side_elements1;
    cout << endl << "2t: " << side_elements2 << endl;*/
    
    ////////////////////////////
    
    //get direct correspondences between side chain atoms. Requires identical atom naming conventions.
    //vector<string> atoms1;
    //vector<string> atoms2;
    Coords side1_temp;
    Coords side2_temp;
    vector<int> side_idx;
    if(side_atoms1 != side_atoms2){		//either there are missing atoms, or the atoms are in a different order in the PDB file.
        for(unsigned int i=0; i<side_atoms1.size(); i++){
            side_idx.push_back(-1);			//fill vector with false values (-1 in this case)
        }
        for(unsigned int i=0; i<side_atoms1.size(); i++){
            for(unsigned int j=0; j<side_atoms2.size(); j++){
                if(side_atoms1[i]==side_atoms2[j]){     //require the atom names to be identical
                    side_idx[i] = j;
                    break;
                }
            }
        }
        for(unsigned int i=0; i<side_idx.size(); i++){
            if(side_idx[i]>=0){ //atom present in both side chains
                atoms.push_back(side_atoms1[i]);
                //atoms1.push_back(side_atoms1[i]);
                //atoms2.push_back(side_atoms2[side_idx[i]]);
                side1_temp.add(side1.get_crd(i));
                side2_temp.add(side2.get_crd(side_idx[i]));
            }
        }
        side1 = side1_temp;
        side2 = side2_temp;
        //side_atoms1 = atoms1;
        //side_atoms2 = atoms2;
    } else {
        atoms = side_atoms1;
    }
    
    ////////////////////////////
    
    for(unsigned int i=0; i<atoms.size(); i++){
        atom_indexes.push_back(i);
    }
        
    if(side1.size()==side2.size()){     //note: this should always be true
        side1_transf = transf1.transform(side1);
        side2_transf = transf2.transform(side2);
        vector<coord> tmp1;
        vector<coord> tmp2;
        for(int i=0; i<side1_transf.size(); i++){
            tmp1.push_back(side1_transf.get_crd(i));
            tmp2.push_back(side2_transf.get_crd(i));
        }

        for(unsigned int i=0; i<tmp1.size(); i++){
            result.push_back(dist(tmp1[i],tmp2[i]));
        }

        //detect and fix any nomenclature issues
        string resid = f1.get_side_resid(idx,offset);
        bool fixed = 0;
        if(resid == "PHE" || resid == "TYR")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," CD1"," CD2"," CE1"," CE2");
        else if(resid == "ARG")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," NH1"," NH2");
        else if(resid == "ASP")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," OD1"," OD2");
        else if(resid == "GLU")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," OE1"," OE2");
        else if(resid == "VAL")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," CG1"," CG2");
        else if(resid == "LEU")
            fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," CD1"," CD2");
        if(fixed)
            cout << "Accounting for potential nomenclature inconsistency:    " << resid << " " << f1.get_side_orig(idx,offset) << " and " << f2.get_side_orig(idx2,offset) << endl;
        else if(FIX_SIDE_CHAIN_ERRORS){
            if(resid == "HIS")
                fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," ND1"," CD2"," CE1"," NE2");
            else if(resid == "THR")
                fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," OG1"," CG2");
            else if(resid == "ASN")
                fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," OD1"," ND2");
            else if(resid == "GLN")
                fixed = fix_nomenclature(1,atom_indexes,result,atoms,tmp1,tmp2," OE1"," NE2");
            if(fixed)
                cout << "Accounting for potential side chain conformation error: " << resid << " " << f1.get_side_orig(idx,offset) << " and " << f2.get_side_orig(idx2,offset) << " (warning - swapping atoms of different types)" << endl;
        }
    }
    for(unsigned int i=0; i<result.size(); i++){
        if(result[i] < 0.000001){
            result[i] = 0.0;
        }
    }
    
    if(USE_MAINCHAIN_FOR_SIDERMSD){
        for(int i=0; i<4; i++){
            atoms.erase(atoms.begin());
            atom_indexes.erase(atom_indexes.begin());
        }
        for(unsigned int i=0; i<atom_indexes.size(); i++){
            atom_indexes[i] -=4;
        }
    } else {
        atoms.erase(atoms.begin());
        atom_indexes.erase(atom_indexes.begin());
        for(unsigned int i=0; i<atom_indexes.size(); i++){
            atom_indexes[i]--;
        }
    }
    
    
    return result;
}

bool fix_nomenclature(bool fix, vector<int> &atom_indexes, vector<double> &result, vector<string> &atoms, vector<coord> &tmp1, vector<coord> &tmp2, string s1, string s2)
{
    for(unsigned int i=0; i<atoms.size(); i++){
        if(atoms[i]==s1){
            for(unsigned int j=0; j<atoms.size(); j++){
                if(atoms[j]==s2){
                    double d1 = dist(tmp1[i],tmp2[j]);
                    double d2 = dist(tmp1[j],tmp2[i]);
                    if((d1+d2)<(result[i]+result[j])){
                        if(fix){
                            result[i] = d1;
                            result[j] = d2;
                            atom_indexes[i] = j;
                            atom_indexes[j] = i;
                        }
                        return 1;
                    } break;
                }
            } break;
        }
    }
    return 0;
}

bool fix_nomenclature(bool fix, vector<int> &atom_indexes, vector<double> &result, vector<string> &atoms, vector<coord> &tmp1, vector<coord> &tmp2, string s1, string s2, string s3, string s4)
{
    for(unsigned int i=0; i<atoms.size(); i++){
        if(atoms[i]==s1){
            for(unsigned int j=0; j<atoms.size(); j++){
                if(atoms[j]==s2){
                    for(unsigned int i2=0; i2<atoms.size(); i2++){
                        if(atoms[i2]==s3){
                            for(unsigned int j2=0; j2<atoms.size(); j2++){
                                if(atoms[j2]==s4){
                                    double d1 = dist(tmp1[i],tmp2[j]);
                                    double d2 = dist(tmp1[j],tmp2[i]);
                                    double d3 = dist(tmp1[i2],tmp2[j2]);
                                    double d4 = dist(tmp1[j2],tmp2[i2]);
                                    if((d1+d2+d3+d4)<(result[i]+result[j]+result[i2]+result[j2])){
                                        if(fix){
                                            result[i] = d1;
                                            result[j] = d2;
                                            result[i2] = d3;
                                            result[j2] = d4;
                                            atom_indexes[i] = j;
                                            atom_indexes[j] = i;
                                            atom_indexes[i2] = j2;
                                            atom_indexes[j2] = i2;
                                        }
                                        return 1;
                                    } break;
                                }
                            } break;
                        }
                    } break;
                }
            } break;
        }
    }
    return 0;
}



/*double sidechain_RMSD(Frag &f1, Frag &f2, int idx, int idx2, int offset)
//returns RMSD of sidechain, after fragments have been superimposed.
//returns -1 if sidechain is of different length.
{
    double result = -1.0;
    
    Coords frag1;
    Coords frag2;
    Transform transf1;
    Transform transf2;
    Coords side1_transf;
    Coords side2_transf;
    
    f1.crds(frag1,idx);
    f2.crds(frag2,idx2);
    coord mean1 = frag1.mean();
    coord mean2 = frag2.mean();
    Coords f1n = frag1-mean1;
    Coords f2n = frag2-mean2;
    
    //cout << endl << frag1 << endl;
    //cout << frag2 << endl;
    //cout << RMSD(frag1,frag2) << endl;
    //cout << RMSD(f1n,f2n) << endl;
    
    Array2D<double> RM = rotateM(f1n,f2n);
    //Coords f2n_rot = f2n*RM;
    //cout << RMSD(f1n,f2n_rot) << endl;
    
    transf1.create(mean1);
    transf2.create(mean2,RM);
    
    Coords side1 = f1.central_side(idx,offset);
    Coords side2 = f2.central_side(idx2,offset);
    
    //cout << endl << "side1:" << endl << side1 << endl;
    //cout << endl << "side2:" << endl << side2 << endl;
    
    vector<string> side_atoms1 = f1.get_side_atom(idx,offset);
    vector<string> side_atoms2 = f2.get_side_atom(idx2,offset);
	
	side_atoms1.insert(side_atoms1.begin()," CA ");
	side_atoms2.insert(side_atoms2.begin()," CA ");
    
#ifdef ALTERNATIVE_SIDE_CHAIN_SCORING
    side_atoms1.insert(side_atoms1.begin()," N  ");
	side_atoms2.insert(side_atoms2.begin()," N  ");
    side_atoms1.insert(side_atoms1.begin()," C  ");
	side_atoms2.insert(side_atoms2.begin()," C  ");
    side_atoms1.insert(side_atoms1.begin()," O  ");
	side_atoms2.insert(side_atoms2.begin()," O  ");
#endif
    
    //vector<string> side_atoms1_temp;
    //vector<string> side_atoms2_temp;
    Coords side1_temp;
    Coords side2_temp;
    vector<int> side_idx;
    if(side_atoms1 != side_atoms2){		//either there are missing atoms, or the atoms are in a different order in the PDB file.
        for(unsigned int i=0; i<side_atoms1.size(); i++){
            side_idx.push_back(-1);			//fill vector with false values (-1 in this case)
        }
        for(unsigned int i=0; i<side_atoms1.size(); i++){
            for(unsigned int j=0; j<side_atoms2.size(); j++){
                if(side_atoms1[i]==side_atoms2[j]){
                    side_idx[i] = j;
                    break;
                }
            }
        }
        for(unsigned int i=0; i<side_idx.size(); i++){
            if(side_idx[i]>=0){
                //side_atoms1_temp.push_back(side_atoms1[i]);
                //side_atoms2_temp.push_back(side_atoms2[side_idx[i]]);
                side1_temp.add(side1.get_crd(i));
                side2_temp.add(side2.get_crd(side_idx[i]));
            }
        }
        side1.clear();
        side2.clear();
        side1 = side1_temp;
        side2 = side2_temp;
    }
    
    if(side1.size()==side2.size()){
        //cout << RMSD(side1,side2) << endl;
        side1_transf = transf1.transform(side1);
        side2_transf = transf2.transform(side2);
        //cout << endl << "side1:" << endl << side1_transf << endl;
        //cout << endl << "side2:" << endl << side2_transf << endl;
#ifdef ALTERNATIVE_SIDE_CHAIN_SCORING
        result = max_dist(side1_transf,side2_transf);
#else
        result = RMSD(side1_transf,side2_transf);
#endif
        //cout << result << endl;
    }
    if(result < 0.000001){
        result = 0.0;
    }
    return result;
}*/

double sidechain_AV(Frag &f1, Frag &f2, int idx, int idx2, int offset)
//returns RMSD of sidechain of central+offset residue of fragment, after fragments have been superimposed.
//returns -1 if sidechain is of different length.
{
    double result = -1.0;
    
    Coords frag1;
    Coords frag2;
    Transform transf1;
    Transform transf2;
    
    f1.crds(frag1,idx);
    f2.crds(frag2,idx2);
    coord mean1 = frag1.mean();
    coord mean2 = frag2.mean();
    Coords f1n = frag1-mean1;
    Coords f2n = frag2-mean2;
    
    //cout << endl << frag1 << endl;
    //cout << frag2 << endl;
    //cout << RMSD(frag1,frag2) << endl;
    //cout << RMSD(f1n,f2n) << endl;
    
    Array2D<double> RM = rotateM(f1n,f2n);
    //Coords f2n_rot = f2n*RM;
    //cout << RMSD(f1n,f2n_rot) << endl;
    
    transf1.create(mean1);					//get transformation required to superimpose fragment
    transf2.create(mean2,RM);
    
    Coords side1 = f1.central_side(idx,offset,0);		//get sidechain of central residue
    Coords side2 = f2.central_side(idx2,offset,0);      //the '0' specifies to use only CA from mainchain.
    
    //cout << endl << "side1:" << endl << side1 << endl;
    //cout << endl << "side2:" << endl << side2 << endl;
    
    Coords side1_transf = transf1.transform(side1);	//transform sidechain coords
    Coords side2_transf = transf2.transform(side2);
    //cout << endl << "side1:" << endl << side1_transf << endl;
    //cout << endl << "side2:" << endl << side2_transf << endl;
    
    coord side1_av = side1_transf.mean();
    coord side2_av = side2_transf.mean();
    result = dist(side1_av,side2_av);
    //cout << result << endl;
    if(result < 0.000001){
        result = 0.0;
    }
    return result;
}

/*
 double residue_scores(Align &alignment, Frag &frag1, Frag &frag2, Array2D<double> &FDM, vector<residue_alignment> &Res_align)
 {
 double temp;
 int idx;
 int idx2;
 bool conserved;
 double SeqID = 0.0;
 
 int N = frag1.last_res()+1;			//N = number of residues
 Array1D<double> score(N,-1.0);		//these Array1Ds are accessed via final_residues1.
 Array1D<double> score_av(N,-1.0);
 Array1D<double> result(N,-1.0);		//central fragment score
 Array1D<double> result_av(N,-1.0);	//average fragment score
 Array1D<double> result_min(N,-1.0);	//minimum fragment score
 Array1D<int> divider(N,0);
 Array1D<int> divider_av(N,0);
 
 //these will have the same length = number of aligned residues:
 vector<int> final_residues1 = frag1.get_residues(alignment,1);
 vector<int> final_residues2 = frag2.get_residues(alignment,2);
 vector<Array1D<double> > scoreV;
 
 //identify the index(es) of the fragment(s) used for central scores.
 int j_lower=1;
 int j_higher=frag1.len();
 while(j_lower+1 < j_higher){
 j_lower++;
 j_higher--;
 }
 
 for(unsigned int i=1; i<=alignment.len(); i++){
 idx = alignment.get(1,i);
 idx2 = frag1.idx(idx);
 temp = FDM[idx][alignment.get(2,i)];
 
 for(int j=0; j<frag1.len(); j++){		//get minimum fragment score
 if(temp < result_min[idx2+j] || result_min[idx2+j] < 0.0){
 result_min[idx2+j] = temp;
 }
 }
 if(score[idx2+j_lower] < 0.0){
 score[idx2+j_lower] = 0.0;
 }
 
 score[idx2+j_lower] += temp;			//get central fragment(s) score
 divider[idx2+j_lower] += 1;
 if(j_lower < j_higher){
 if(score[idx2+j_higher] < 0.0){
 score[idx2+j_higher] = 0.0;
 }
 score[idx2+j_higher] += temp;
 divider[idx2+j_higher] += 1;
 }
 
 for(int j=0; j<frag1.len(); j++){		//get average fragment score (this info is required for computation of central fragment score)
 if(score_av[idx2+j] < 0.0){
 score_av[idx2+j] = 0.0;
 }
 score_av[idx2+j] += temp;
 divider_av[idx2+j] += 1;
 }
 }
 #ifdef TROUBLESHOOTING_COUTS
 cout << endl << endl << "Final Residue Alignment: " << endl;
 cout << endl <<  "Res1\tRes2\tScore\tDivider";
 for(unsigned int i=0; i<final_residues1.size(); i++){
 cout << endl << final_residues1[i] << "\t" << final_residues2[i] << "\t" << score[final_residues1[i]] << "\t" << divider[final_residues1[i]];
 }
 #endif
 
 for(int i=0; i<N; i++){
 if(divider[i]>0){
 result[i] = score[i]/divider[i];
 }
 if(divider_av[i]>0){
 result_av[i] = score_av[i]/divider_av[i];
 }
 if(result[i] < 0.0){
 result[i] = result_av[i];
 }
 }
 
 #ifdef DISPLAY_ALIGN
 cout << endl << endl << endl << "Residue-Residue Alignment:" << endl; 
 cout << endl << "Index\t  Res1\t\tRes2\t\tSeqId\tScore\tFragment_Overlap";
 #endif
 
 residue_alignment temp_res_align;
 idx = 0;
 idx2 = 0;
 for(unsigned int i=0; i<final_residues1.size(); i++){
 if(final_residues1[i] == frag1.res_idx(idx)){
 if(final_residues2[i] == frag2.res_idx(idx2)){
 if(frag1.get_resid(idx).compare(frag2.get_resid(idx2)) == 0){
 SeqID++;
 }
 #ifdef DISPLAY_ALIGN
 if(frag1.get_resid(idx).compare(frag2.get_resid(idx2)) == 0){
 conserved = 1;
 } else {
 conserved = 0;
 }
 cout << endl << i+1 << ":\t  " << final_residues1[i] << " " << frag1.get_resid(idx) << "   \t" << final_residues2[i] << " " << frag2.get_resid(idx2) << "  \t" << conserved << "\t" << result[final_residues1[i]] << "    \t" << divider[final_residues1[i]];
 #endif
 temp_res_align.res1 = final_residues1[i];
 temp_res_align.res2 = final_residues2[i];
 temp_res_align.dist = result[final_residues1[i]];		//central
 temp_res_align.dist2 = result_min[final_residues1[i]];	//minimum
 Res_align.push_back(temp_res_align);
 idx2++;
 idx++;
 } else {
 #ifdef DISPLAY_ALIGN
 cout << endl << "\t\t\t" << frag2.res_idx(idx2) << " " << frag2.get_resid(idx2);
 #endif
 i--;
 idx2++;
 }
 } else {
 #ifdef DISPLAY_ALIGN
 cout << endl << "\t  " << frag1.res_idx(idx) << " " << frag1.get_resid(idx);
 #endif
 i--;
 idx++;
 }
 }
 #ifdef DISPLAY_ALIGN
 for(unsigned int i=idx; i<frag1.res_size(); i++){
 cout << endl << "\t  " << frag1.res_idx(i) << " " << frag1.get_resid(i);
 }
 for(unsigned int i=idx2; i<frag2.res_size(); i++){
 cout << endl << "\t\t\t" << frag2.res_idx(i) << " " << frag2.get_resid(i);
 }
 cout << endl;
 #endif
 
 return (SeqID*100)/Res_align.size();
 }
 */

double alignment_RMSD(vector<residue_alignment> &Res_align, Residues &res1, Residues &res2)
{
    Coords crds1norm = res1.crds1norm(Res_align);
    Coords crds2norm = res2.crds2norm(Res_align);
    
    Array2D<double> RM = rotateM(crds1norm,crds2norm);
    Coords crds2R = crds2norm*RM;
    double result = RMSD(crds1norm,crds2R);
    if(result < 0.000001){
        result = 0.0;
    }
    return result;
}


double av_frag_RMSD(Frag &frag1, Frag &frag2, Align &alignment)
{
    Coords crds1norm;
    Coords crds2norm;
    Array2D<double> RM(3,3);
    Coords crds2R;
    Array1D<double> RMSD1(alignment.len(),-1.0);
    
    for(unsigned int i=1; i<=alignment.len(); i++){
        crds1norm = frag1.crds_norm(alignment.get(1,i));
        crds2norm = frag2.crds_norm(alignment.get(2,i));
        RM = rotateM(crds1norm,crds2norm);
        crds2R = crds2norm*RM;
        RMSD1[i-1] = RMSD(crds1norm,crds2R);
    }
    
    return average(RMSD1);
}

double av_frag_procrustes(Array2D<double> &FDM, Align &alignment)
{
    double procrustes_score = 0.0;
    
    for(unsigned int i=1; i<=alignment.len(); i++){
        procrustes_score += FDM[alignment.get(1,i)][alignment.get(2,i)];
    }
    
    return procrustes_score/alignment.len();
}

double min_central_score(vector<residue_alignment> &Res_align)
{
    double result = -1.0;
    for(unsigned int i=0; i<Res_align.size(); i++)
        if(Res_align[i].dist2 >= 0)
            if(Res_align[i].dist2 < result || result < 0.0)
                result = Res_align[i].dist2;
    
    return result;
}

double av_central_score(vector<residue_alignment> &Res_align)
{
    double result = 0.0;
    int N = 0;
    
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist2 >= 0){
            result += Res_align[i].dist2;
            N++;
        }
    }
    
    if(N>0) return result/N;
    else return -1.0;
}

double av_min_score(vector<residue_alignment> &Res_align)
{
    double result = 0.0;
    int N = 0;
    
    // replace result with a particular sideav score - temp hack for AJ.
    //return Res_align[2].dist4;
    
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist >= 0){
            result += Res_align[i].dist;
            N++;
        }
    }
    
    if(N>0) return result/N;
    
    else return -1.0;
}

double av_sideRMSD(vector<residue_alignment> &Res_align)
{
    double result = 0.0;
    int N = 0;
    
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist3 >= 0){
            result += Res_align[i].dist3;
            N++;
        }
    }
    
    if(N>0) return result/N;
    else return -1.0;
}

double av_sideMaxDist(vector<residue_alignment> &Res_align)
{
    double result = 0.0;
    int N = 0;
    
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist5 >= 0){
            result += Res_align[i].dist5;
            N++;
        }
    }
    
    if(N>0) return result/N;
    else return -1.0;
}

vector<int> no_large_side_dist(vector<residue_alignment> &Res_align)
{
    vector<int> result;
    
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist6 >= 0){
            while((int)result.size()<=Res_align[i].dist6){
                result.push_back(0);
            }
            result[Res_align[i].dist6]++;
        }
    }
    
    return result;
}

double asa_correlation(vector<residue_alignment> &Res_align)
{
    vector<double> asa;
    vector<double> max_dist;
    
#ifdef RUN_AREAIMOL
    for(unsigned int i=0; i<Res_align.size(); i++){
        if(Res_align[i].dist5>=0){
            asa.push_back(max(Res_align[i].asa1,Res_align[i].asa2));
            max_dist.push_back(Res_align[i].dist5);
        }
    }
#endif
    
    return spearman_rank_corr_coef(asa,max_dist);
}

vector<double> score_prediction(Align &alignment, Frag &f1, Frag &f2, Array1D<Coords> &frag_norm1, Array1D<Coords> &frag_norm2, vector<double> &trcov1, vector<double> &trcov2)
{
	int i1=0;
	int i2=0;
	int i1_=0;
	int i2_=0;
	Array2D<double> RM(3,3);
	vector<double> result;
	double tmp;
	coord mn1x;
	coord mn1y;
	coord mn2x;
	coord mn2y;
	coord mndx;
	coord mndy;
	coord mnrdy;
	coord T = mndx-mnrdy;
	double XYR = 0.0;
	int N = frag_norm1[0].size();
	Coords frag_norm2aR;
	
	result.push_back(-1);		//first alignment has no score.
	for(unsigned int i=1; i<alignment.len(); i++){
		//make sure that alignment is consecutive
		i1 = alignment.get(1,i);
		i1_=i1+1;
		if(i1_ != alignment.get(1,i+1)){
			result.push_back(-1);
			continue;			
		}
		i2 = alignment.get(2,i);
		i2_=i2+1;
		if(i2_ != alignment.get(2,i+1)){
			result.push_back(-1);
			continue;
		}
		
		//get rotation
		RM = rotateM(frag_norm1[i1],frag_norm2[i2]);
		
		//get translation component
		mn1x = f1.get_mean(i1);
		mn1y = f2.get_mean(i2);
		mn2x = f1.get_mean(i1_);
		mn2y = f2.get_mean(i2_);
		mndx = mn1x-mn2x;
		mndy = mn1y-mn2y;
		mnrdy = mndy*RM;
		T = mndx-mnrdy;
		
		//get covariance term
		XYR = 0.0;
		frag_norm2aR = frag_norm2[i2_]*RM;
		for(int k=0; k<N; k++){
			XYR += frag_norm1[i1_].x(k)*frag_norm2aR.x(k);
			XYR += frag_norm1[i1_].y(k)*frag_norm2aR.y(k);
			XYR += frag_norm1[i1_].z(k)*frag_norm2aR.z(k);
		}
		
		tmp = sqrt((trcov1[i1_]+trcov2[i2_]+tr_cov(T)-(2*XYR))/N);
		if(tmp < 0.00001){	//this ensures that identical fragments are identified as identical.
			tmp = 0.0;			//sometimes rounding error causes d<0 when fragments are exactly the same!
		}
		result.push_back(tmp);
	}
	
	return result;
}

vector<double> interfragment_rotation(Align &alignment, Frag &f1, Frag &f2, Array1D<Coords> &frag_norm1, Array1D<Coords> &frag_norm2)
{
	int i1=0;
	int i2=0;
	Array2D<double> RM1(3,3);
	Array2D<double> RM2(3,3);
	vector<double> result;
	double tmp;
	Coords temp_left;
	Coords temp_right;
	Coords crds1_left;
	Coords crds1_right;
	Coords crds2_left;
	Coords crds2_right;
	
	for(unsigned int i=1; i<=alignment.len(); i++){
		i1 = alignment.get(1,i);
		i2 = alignment.get(2,i);
		
		//get mean-normalised half-fragment matrices
		frag_norm1[i1].get_ends(temp_left,temp_right);
		crds1_left = temp_left.rmmean();
		crds1_right = temp_right.rmmean();
		frag_norm2[i2].get_ends(temp_left,temp_right);
		crds2_left = temp_left.rmmean();
		crds2_right = temp_right.rmmean();
		
		//get rotations
		RM1 = rotateM(crds1_left,crds2_left);
		RM2 = rotateM(crds1_right,crds2_right);
		
		//get trace of differential rotation matrix
		tmp = 0.0;
		for(int j=0; j<3; j++){
			for(int k=0; k<3; k++){
				tmp += RM1[j][k]*RM2[j][k];
			}
		}
		result.push_back((3-tmp)/2);
		if(result[i-1]<0.00000001){result[i-1] = 0.0;}		//rotation is identical.
	}
	
	return result;
}	

vector<vector<double> > get_other_scores(Align &alignment, Frag &f1, Frag &f2, Array1D<Coords> &frag_norm1, Array1D<Coords> &frag_norm2, Array2D<double> &FDM)
{
	vector<vector<double> > result;
	vector<double> temp;
	int i1 = 0;
	int i2 = 0;
	
	/*double stdProc = 0.0;
     double Cav = 0.0;
     
     double k1 = -3.85;
     double k2 = 2.64;
     double k3 = -0.257;
     
     double ks1 = 0.909;
     double ks2 = -0.0752;*/
	
	//double cdf = 0.0;
	//double pdf = 0.0;
	//double lpdf = 0.0;
	//double k0 = 1/sqrt(8*atan(1.0));			//PI = 4*atan(1.0)
	//double lk0 = log(k0);
	
	for(unsigned int i=1; i<=alignment.len(); i++){
		i1 = alignment.get(1,i);
		i2 = alignment.get(2,i);
		//Cav = (frag_norm1[i1].centroid() + frag_norm2[i2].centroid())/2;						//average centroid size
		//stdProc = (FDM[i1][i2] - (k1 + (k2*Cav) + (k3*Cav*Cav)))/(ks1 + (ks2*Cav));	//normalised Procrustes score
		//cdf = (1 + erf(stdProc/sqrt(2)))/2;
		//if(cdf < 0.00001){cdf = 0;}
        //if(cdf > 1){cdf = 1;}
		//pdf = k0*exp(-(stdProc*stdProc)/2);
		//lpdf = lk0 - (stdProc*stdProc/2);
		
		temp.clear();
		temp.push_back(frag_norm1[i1].centroid());
		temp.push_back(frag_norm2[i2].centroid());
		//temp.push_back(Cav);
		//temp.push_back(stdProc);
		//temp.push_back(cdf);
		//temp.push_back(pdf);
		//temp.push_back(lpdf);
		result.push_back(temp);
	}
	
	return result;
}

double get_av_centroid(Array1D<Coords> &frag_norm)
{
	double result = 0.0;
	for(int i=0; i<frag_norm.dim1(); i++){
		result += frag_norm[i].centroid();
	}
	return result/frag_norm.dim1();
}

vector<vector<string> > get_sse_types(Frag &f1, Frag &f2, vector<vector<string> > &config, string &library, vector<vector<double> > &scores)
{
    vector<vector<string> > result;
	vector<string> result1;
	vector<string> result2;
	
	PDBfile pdb_sse;
	Residues res_sse;
	Frag frag_sse;
	Array2D<double> DM1;
	Array2D<double> DM2;
	vector<vector<double> > scores1;
	vector<vector<double> > scores2;
	vector<double> temp;
	vector<double> temp1;
	vector<double> temp2;
    
	for(unsigned int i=0; i<config.size(); i++){
		pdb_sse.readPDB(library+config[i][0]+".pdb", config[i][1][0]);
		pdb_sse.trim(f1.len());
		res_sse.create(pdb_sse);
		frag_sse.create(res_sse,f1.len(),0);
		
		DM1 = fragDM_all(f1,frag_sse);
		temp.clear();
		for(int j=0; j<DM1.dim1(); j++){
			temp.push_back(DM1[j][0]);
		}
		scores1.push_back(temp);
        
		DM2 = fragDM_all(f2,frag_sse);
		temp.clear();
		for(int j=0; j<DM2.dim1(); j++){
			temp.push_back(DM2[j][0]);
		}
		scores2.push_back(temp);
	}
    
	temp1.clear();
	for(int i=0; i<DM1.dim1(); i++){
		temp1.push_back(-1);
		result1.push_back("NA");
		for(unsigned int j=0; j<config.size(); j++){
			if(scores1[j][i] <= atof(config[j][3].c_str())){
				if(scores1[j][i] <= temp1[i] || temp1[i] < 0){
					temp1[i] = scores1[j][i];
					result1[i] = config[j][2];
				}
			}
		}
	}
	temp2.clear();
	for(int i=0; i<DM2.dim1(); i++){
		temp2.push_back(-1);
		result2.push_back("NA");
		for(unsigned int j=0; j<config.size(); j++){
			if(scores2[j][i] <= atof(config[j][3].c_str())){
				if(scores2[j][i] <= temp2[i] || temp2[i] < 0){
					temp2[i] = scores2[j][i];
					result2[i] = config[j][2];
				}
			}
		}
	}
	
	result.push_back(result1);
	result.push_back(result2);
	scores.push_back(temp1);
	scores.push_back(temp2);
	
	return result;
}

vector<vector<string> > get_res_sse(Frag &f1, Frag &f2, vector<vector<string> > &types, vector<vector<double> > &scores, vector<vector<double> > &res_scores)
{
	vector<vector<string> > res_types;
	vector<double> res_score;
	vector<string> res_type;
	int idx;
	int N = f1.len();
	
	for(unsigned int i=0; i<types[0].size(); i++){		// fragment = i
		idx = f1.idx(i);																// residue = idx
		if(scores[0][i] < 0.0){continue;}
		while((int)res_score.size() < idx+N){	//ensure arrays are long enough
			res_score.push_back(-1.0);
			res_type.push_back("NA");
		}
		for(int j=0; j<N; j++){
			if(scores[0][i] < res_score[idx+j] || res_score[idx+j] < 0.0){
				res_score[idx+j] = scores[0][i];
				res_type[idx+j] = types[0][i];
			}
		}
	}
	res_types.push_back(res_type);
	res_scores.push_back(res_score);
	
	res_type.clear();
	res_score.clear();
	for(unsigned int i=0; i<types[1].size(); i++){
		idx = f2.idx(i);
		if(scores[1][i] < 0.0){continue;}
		while((int)res_score.size() < idx+N){	//ensure arrays are long enough
			res_score.push_back(-1.0);
			res_type.push_back("NA");
		}
		for(int j=0; j<N; j++){
			if(scores[1][i] < res_score[idx+j] || res_score[idx+j] < 0.0){
				res_score[idx+j] = scores[1][i];
				res_type[idx+j] = types[1][i];
			}
		}
	}
	res_types.push_back(res_type);
	res_scores.push_back(res_score);
	
	return res_types;
}

double get_KS(vector<vector<double> > &S)
{
	unsigned int N = S.size();
	vector<double> myvector;
	for(unsigned int i=0; i<N; i++){
		myvector.push_back(S[i][1]);
	}
	sort(myvector.begin(), myvector.end());
	/*for(unsigned int i=0; i<N; i++){
     cout << endl << myvector[i];
     }*/
	
	double cdf = 0.0;
	double cdfN = 0.0;
	double k = 1.0/sqrt(2);
	double interval = 1.0/(double)N;
	double temp = 0.0;
	double result = 0.0;
	
	for(unsigned int i=0; i<N; i++){
		cdf += interval;
		cdfN = (1 + erf(myvector[i]*k))/2;
		temp = cdf-cdfN;
		if(temp > result){
			result = temp;
		}
	}
	
	return result;
}

double get_Score(vector<vector<double> > &S)
{
	unsigned int N = S.size();
	double l0 = -log(8*atan(1.0))/2;			//PI = 4*atan(1.0)
	double lpdf = 0.0;
	double temp = 0.0;
	double result = 0.0;
	
	for(unsigned int i=0; i<N; i++){
		if(S[i][1] < 0){
			lpdf = l0 - (S[i][1]*S[i][1]/2);
		} else {
			lpdf = l0;
		}
		temp += lpdf;
	}
	result = exp(temp/N);
	return result;
}

vector<int> new_sse(Residues &res, vector<vector<string> > &config, string &library, vector<string> &types)
{
	Frag frag;
	PDBfile pdb_sse;
	Residues res_sse;
	Frag frag_sse;	
	Array2D<double> DM;
	vector<double> scores;
	vector<double> temp;
	int fraglen = 1;
	int idx = 0;
	double cutoff = 0.0;
	vector<int> result;
	
	types.clear();
	while((int)types.size() <= res.last()){	//ensure arrays are long enough
		types.push_back("NA");
		result.push_back(-1);
		scores.push_back(-1.0);
		temp.push_back(-1.0);
	}

	vector<vector<double> > temps;
	vector<res_corresp> original_res;
	for(unsigned int i=0; i<config.size(); i++){				
		fraglen = atoi(config[i][4].c_str());
		frag.create(res,fraglen,0);
        
		pdb_sse.clear();
		pdb_sse.readPDB(library+config[i][0]+".pdb", config[i][1][0]);		
		pdb_sse.rename_resnum(original_res, fraglen);
		
		pdb_sse.trim(fraglen);
		res_sse.create(pdb_sse);
        if(res_sse.size()==0){
            continue;   //e.g. protein fragment compared with fragment intended for DNA/RNA, and vice versa.
        }
		frag_sse.create(res_sse,fraglen,0);
		
		DM = fragDM_all(frag,frag_sse);
		
		for(unsigned int j=0; j<temp.size(); j++){	//reset temp
			temp[j] = -1.0;
		}

		for(int j=0; j<DM.dim1(); j++){
			idx = frag.idx(j);											//index of residue of fragment j
			for(int k=0; k<fraglen; k++){
				if(DM[j][0] < temp[idx+k] || temp[idx+k] < 0.0){
					temp[idx+k] = DM[j][0];							//temp stores sse scores corresponding to residues
				}
			}
		}
		
		cutoff = atof(config[i][3].c_str());
		for(unsigned int j=0; j<temp.size(); j++){
			if(temp[j] <= cutoff && temp[j] >= 0){		//residue belongs to ss type
				if(temp[j] < scores[j] || scores[j] < 0){		//closer to this ss type than previous
					scores[j] = temp[j];
					types[j] = config[i][2];
					result[j] = i;
				}
			}
		}
		temps.push_back(temp);
	}
	
	/*cout.precision(3);
     for(unsigned int i=0; i<scores.size(); i++){
     cout << endl << i;
     for(unsigned int j=0; j<temps.size(); j++){
     cout << "\t" << temps[j][i];
     }
     cout << "\t" << types[i];
     }*/
	
	return result;
}

void fragment_library_types(Frag &frag, vector<vector<string> > &config, string &library, vector<string> &types, int fraglen)
// called if OUTPUT_ALIGNMENT_FOR_ANALYSIS variable is defined
{
	PDBfile pdb_sse;
	Residues res_sse;
	Frag frag_sse;	
	vector<Array2D<double> > vDM;
	vector<double> scores;
	vector<double> temp;
	double cutoff = 0.0;
    
	vector<res_corresp> original_res;
	for(unsigned int i=0; i<config.size(); i++){		
		pdb_sse.readPDB(library+config[i][0]+".pdb", config[i][1][0]);		
		pdb_sse.rename_resnum(original_res, fraglen);
		pdb_sse.trim(fraglen);
		res_sse.create(pdb_sse);
		frag_sse.create(res_sse,fraglen,0);
		vDM.push_back(fragDM_all(frag,frag_sse));
	}
	
	types.clear();
	for(int i=0; i<vDM[0].dim1(); i++){
		scores.push_back(-1.0);
		types.push_back("NA");
	}
	
	for(int i=0; i<vDM[0].dim1(); i++){
		for(unsigned int j=0; j<vDM.size(); j++){
			cutoff = atof(config[j][3].c_str());
			if((vDM[j][i][0] < scores[i] || scores[i] < 0.0) && (vDM[j][i][0]<cutoff)){
				scores[i] = vDM[j][i][0];
				types[i] = config[j][2];
			}
		}
	}
	
	return;
}

/*vector<double> get_proc_norm(Align &alignment, Array1D<Coords> &frag_norm1, Array1D<Coords> &frag_norm2, Array2D<double> &FDM)
 {
 vector<double> result;
 Array1D<double> eigen1;
 Array1D<double> eigen2;
 vector<frag_score> observed;
 frag_score tmp;
 int i1;
 int i2;
 
 for(unsigned int i=1; i<=alignment.len(); i++){
 i1 = alignment.get(1,i);
 i2 = alignment.get(2,i);
 eigen1 = eigenvalues(frag_norm1[i1]);
 eigen2 = eigenvalues(frag_norm2[i2]);
 
 tmp.eig1 = ((eigen1[0]+eigen2[0])/2);
 tmp.eig2 = ((eigen1[1]+eigen2[1])/2);
 tmp.eig3 = ((eigen1[2]+eigen2[2])/2);
 tmp.score = FDM[i1][i2];
 tmp.mean = 0.0;
 tmp.sd = 0.0;
 tmp.len = 0;
 observed.push_back(tmp);
 }
 
 get_procrustes_normalisation(observed);
 
 exit(-1);
 return result;
 }*/

Array2D<double> get_proc_norm(Array1D<Coords> &frag_norm1, Array1D<Coords> &frag_norm2, Array2D<double> &FDM, int fraglen)
{
	vector<Array1D<double> > eigen1;
	vector<Array1D<double> > eigen2;
	vector<frag_score> observed;
	frag_score tmp;
	int N1 = FDM.dim1();
	int N2 = FDM.dim2();
	Array2D<double> FDMnorm(N1,N2);
	
	for(int i=0; i<N1; i++){
		eigen1.push_back(eigenvalues(frag_norm1[i]));
	}
	for(int i=0; i<N2; i++){
		eigen2.push_back(eigenvalues(frag_norm2[i]));
	}
	for(int i=0; i<N1; i++){
		for(int j=0; j<N2; j++){
			//if(i>=j){continue;}
			tmp.eig1 = ((eigen1[i][0]+eigen2[j][0])/2);
			tmp.eig2 = ((eigen1[i][1]+eigen2[j][1])/2);
			tmp.eig3 = ((eigen1[i][2]+eigen2[j][2])/2);
			tmp.score = FDM[i][j];
			tmp.mean = 0.0;
			tmp.sd = 0.0;
			tmp.len = 0;
			observed.push_back(tmp);
		}
	}
    
	get_procrustes_normalisation(observed, fraglen);
    
	int ctr = 0;
	double OFFSET = 0.0;		//should be zero. Produces strange alignments if non-zero.
	for(int i=0; i<N1; i++){
		for(int j=0; j<N2; j++){
			FDMnorm[i][j] = OFFSET + (observed[ctr].score-observed[ctr].mean)/observed[ctr].sd;
			if(FDMnorm[i][j] > OFFSET){
				FDMnorm[i][j] = OFFSET;
			} /*else if(FDMnorm[i][j] < 0.0){
               FDMnorm[i][j] = 0.0;
               }*/
			ctr++;
		}
	}
	
	return FDMnorm;
}

void get_procrustes_normalisation(vector<frag_score> &observed, int fraglen)
{
	//string input_file = "frag9_0.1_mean200.txt"; // "./frag9_0.1_all.txt";
	string input_file = "frag" + int_to_str(fraglen) + "_0.1_200_5_91.txt";
	vector<vector<string> > data = read_file_lines(input_file);
	
	int MAX_EIG1 = str_to_int(data[0][1]);
	int MAX_EIG2 = str_to_int(data[0][2]);
	int MAX_EIG3 = str_to_int(data[0][3]);
	int NO_BOXES = str_to_int(data[0][4]);
	data.erase(data.begin());
	
	double RATIO1=(double)NO_BOXES/MAX_EIG1;
	double RATIO2=(double)NO_BOXES/MAX_EIG2;
	//double RATIO3=(double)NO_BOXES/MAX_EIG3;
	
	frag_score BOX;
	BOX.eig1 = (double)MAX_EIG1/NO_BOXES;
	BOX.eig2 = (double)MAX_EIG2/NO_BOXES;
	BOX.eig3 = (double)MAX_EIG3/NO_BOXES;
    
	/*cout << MAX_EIG1 << endl;
     cout << MAX_EIG2 << endl;
     cout << MAX_EIG3 << endl;
     cout << NO_BOXES << endl;
     cout << BOX.eig1 << endl;
     cout << BOX.eig2 << endl;
     cout << BOX.eig3 << endl;*/
    
	//read data about score, stddev, and len, given eigenvalues.
	//Also create 3D matrix of indexes.
	Array2D<int> indexes(NO_BOXES,NO_BOXES,-1);
	vector<frag_score> frag_data;
	frag_score tmp;
	for(unsigned int i=0; i<data.size(); i++){
		if(data[i].size()>=6){
			tmp.eig1 = str_to_double(data[i][0]);
			tmp.eig2 = str_to_double(data[i][1]);
			tmp.eig3 = str_to_double(data[i][2]);
			tmp.score = str_to_double(data[i][3]);
			tmp.sd = str_to_double(data[i][4]);
			tmp.len = str_to_int(data[i][5]);
			frag_data.push_back(tmp);
			indexes[(int)floor(tmp.eig1*RATIO1)][(int)floor(tmp.eig2*RATIO2)] = i;
		}
	}
    
	///////////////
	
	//REPLACE OBSERVATIONS WITH DATA - THIS IS FOR INSPECTING SMOOTHING ONLY
	/*observed.clear();
     for(unsigned int i=0; i<frag_data.size(); i++){
     tmp.eig1 = frag_data[i].eig1;
     tmp.eig2 = frag_data[i].eig2;
     tmp.eig3 = frag_data[i].eig3;
     tmp.score = 0.0;
     tmp.mean = 0.0;
     tmp.sd = 0.0;
     tmp.len = 0;
     observed.push_back(tmp);
     }*/
	
	//REPLACE OBSERVATIONS WITH POSITIONS OF ALL GRID CELLS - THIS IS FOR ILLUSTRATING SMOOTHING OVER ALL SPACE
	/*observed.clear();
     for(unsigned int i=0; i<NO_BOXES; i++){
     for(unsigned int j=0; j<NO_BOXES; j++){
     tmp.eig1 = i*BOX.eig1;
     tmp.eig2 = j*BOX.eig2;
     tmp.eig3 = 0.0;
     tmp.score = 0.0;
     tmp.mean = 0.0;
     tmp.sd = 0.0;
     tmp.len = 0;
     observed.push_back(tmp);
     }
     }*/
	
	//REPLACE OBSERVATIONS WITH DATA FROM FILE - THIS IS FOR LOOKING AT REDUNDANT DATASET
	/*string data_file = "./sample_of_all_frags.txt";
     //string data_file = "./sample_of_all_frags_dissimilar.txt";
     vector<vector<string> > sample = read_file_lines(data_file);
     observed.clear();
     for(unsigned int i=0; i<sample.size(); i++){
     if(sample[i].size()==4){
     tmp.eig1 = str_to_double(sample[i][0]);
     tmp.eig2 = str_to_double(sample[i][1]);
     tmp.eig3 = str_to_double(sample[i][2]);
     tmp.score = str_to_double(sample[i][3]);
     tmp.mean = 0.0;
     tmp.sd = 0.0;
     tmp.len = 0;
     observed.push_back(tmp);
     }
     }*/
	
	///////////////
	
	unsigned int N = 9;	//number of close data points to identify (acts as a sort of smoothing)
	int maxN = 20; //maximum weight of any given cell during smoothing
	
	int n = 0;	//number of boxes, from central box, to search.
	int tmp1 = -1;
	int tmp2 = -1;
	int idx = -1;
	double t1;
	double t2;
	double t3;
	vector<int> idx_v;
	vector<double> idx_v_score;
	vector<int> idx_v_final;
	vector<vector<int> > close_to_observed;
	for(unsigned int i=0; i<observed.size(); i++){
		tmp1 = (int)floor(observed[i].eig1*RATIO1);
		tmp2 = (int)floor(observed[i].eig2*RATIO2);
		/*cout << endl << observed[i].eig1 << " " 
         << observed[i].eig2 << " "
         << observed[i].eig3 << " "
         << observed[i].score << " "
         << tmp1 << " "
         << tmp2 << " "
         << endl << endl;*/
		n = 1;
		idx_v.clear();
		//keep widening the search grid until there are sufficient data points
		while(idx_v.size()<N){
			idx_v.clear();
			idx_v_score.clear();
			//look in each cell of the search grid
			for(int j=tmp1-n; j<=tmp1+n; j++){
				if(j<0){j=0;}
				if(j>=NO_BOXES){break;}
				for(int k=tmp2-n; k<=tmp2+n; k++){
					if(k<0){k=0;}
					if(k>=NO_BOXES){break;}
					idx = indexes[j][k];
					if(idx < 0){continue;}	//indicates that there is not any data in this box
					t1 = (frag_data[idx].eig1-observed[i].eig1)/BOX.eig1;
					t2 = (frag_data[idx].eig2-observed[i].eig2)/BOX.eig2;
					t3 = sqrt(t1*t1 + t2*t2);
					//Identify which data points are sufficiently close (if any)
					if(t3>n){continue;}
					idx_v.push_back(idx);
					idx_v_score.push_back(t3);
					/*cout << "[" << j << "," << k << "] "
                     << frag_data[idx].eig1 << " "
                     << frag_data[idx].eig2 << " "
                     << frag_data[idx].eig3 << " "
                     << frag_data[idx].score << " "
                     << frag_data[idx].sd << " "
                     << frag_data[idx].len	<< "\t"
                     << t3
                     << endl;*/
				}
			}
			n++;
		}
		//cout << endl;
		//find the N closest data points by (crudely) sorting those identified as meeting the criteria.
		idx_v_final.clear();
		while(idx_v_final.size()<N){
			idx = 0;
			//cout << 0 << " " << idx_v[0] << " " << idx_v_score[0] << endl;
			for(unsigned int j=1; j<idx_v.size(); j++){
				//cout << j << " " << idx_v[j] << " " << idx_v_score[j] << endl;
				if(idx_v_score[j] < idx_v_score[idx]){
					idx = j;
				}
			}
			//cout << "\t" << idx << " " << idx_v[idx] << " " << idx_v_score[idx] << endl;
			idx_v_final.push_back(idx_v[idx]);
			idx_v.erase(idx_v.begin()+idx);
			idx_v_score.erase(idx_v_score.begin()+idx);
		}
		close_to_observed.push_back(idx_v_final);
	}
	
	/*cout << endl << endl << "Results:" << endl;
     for(unsigned int i=0; i<observed.size(); i++){
     cout << observed[i].eig1 << "\t";
     for(unsigned int j=0; j<close_to_observed[i].size(); j++){
     cout << close_to_observed[i][j] << " ";
     }
     cout << endl;
     }*/
	
	//Combine the N closest data bins (conceptually) and calculate mean and sd
	vector<double> meanv;
	vector<double> sdv;
	vector<int> lenv;
	for(unsigned int i=0; i<observed.size(); i++){
		/*cout << endl << i << " :  " << observed[i].eig1 << "  "
         << observed[i].eig2 << "  "
         << observed[i].eig3 << "  "
         << observed[i].score << "  "
         << observed[i].sd << "  "
         << observed[i].len << endl;*/
		meanv.clear();
		sdv.clear();
		lenv.clear();
		for(unsigned int j=0; j<close_to_observed[i].size(); j++){
			/*cout << close_to_observed[i][j] << "  " 
             << frag_data[close_to_observed[i][j]].eig1 << "  " 
             << frag_data[close_to_observed[i][j]].eig2 << "  " 
             << frag_data[close_to_observed[i][j]].eig3 << "  " 
             << frag_data[close_to_observed[i][j]].score << "  " 
             << frag_data[close_to_observed[i][j]].sd << "  " 
             << frag_data[close_to_observed[i][j]].len << endl;*/
			meanv.push_back(frag_data[close_to_observed[i][j]].score);
			sdv.push_back(frag_data[close_to_observed[i][j]].sd);
			lenv.push_back(frag_data[close_to_observed[i][j]].len);
		}
		observed[i].mean = get_mean(meanv,lenv,maxN);
		observed[i].sd = get_sd(meanv,sdv,lenv,maxN);
		observed[i].len = sum(lenv);
		/*cout << "score: " << observed[i].score << endl
         << "mean:  " << observed[i].mean << endl
         << "sd:    " << observed[i].sd << endl
         << "len:   " << observed[i].len << endl;
         cout << endl;*/
	}
	
	string fileout = "./results_";
	fileout += int_to_str(fraglen);
	fileout += ".txt";
	ofstream outfile;	
	
	outfile.open(fileout.c_str());
	//outfile.open(fileout.c_str(),ios:app);	//"app" to create one file for multiple chains
	if(outfile){
		for(unsigned int i=0; i<observed.size(); i++){
			outfile << observed[i].eig1 << " "
			<< observed[i].eig2 << " "
			<< observed[i].eig3 << " "
			<< observed[i].score << " "
			<< observed[i].mean << " "
			<< observed[i].sd << " "
			<< observed[i].len << endl;
		}
		outfile.close();
	}
	
	return;
}

double get_mean(vector<double> &mn, vector<int> &len, int maxN)
{
	double result = 0.0;
	int n = 0;
	int tmplen;
    
	for(unsigned int i=0; i<mn.size(); i++){
		if(len[i]>maxN){
			tmplen = maxN;
		} else {
			tmplen = len[i];
		}		
		n += tmplen;
		result += mn[i]*(double)tmplen;
	}
	
    return (result/(double)n);
}

double get_sd(vector<double> &mn, vector<double> &sd, vector<int> &len, int maxN)
{
	double sum_x2 = 0.0;
	double sum_x = 0.0;
	int n = 0;
	int tmplen;
	
	for(unsigned int i=0; i<mn.size(); i++){
		if(len[i]>maxN){
			tmplen = maxN;
		} else {
			tmplen = len[i];
		}
		sum_x += mn[i]*(double)tmplen;
		sum_x2 += (((double)tmplen-1.0)*sd[i]*sd[i]) + (((double)tmplen)*mn[i]*mn[i]);
		n += tmplen;
	}
    
    return sqrt((sum_x2 - (sum_x*sum_x/(double)n))/((double)n-1.0));	
}

vector<vector<int> > get_full_atomic_alignment(Residues &res1, Residues &res2, vector<residue_alignment> &Res_align)
{
    vector<vector<int> > result;
    vector<int> idx1;
    vector<int> idx2;
        
    for(unsigned int i=0; i<Res_align.size(); i++){
        
//#define EXTRA_COUTS
#ifdef EXTRA_COUTS
        cout << endl << Res_align[i].res1
        << "\t" << Res_align[i].res2
        << "\t" << res1.get_orig_resnum_idx(Res_align[i].res1)
        << "\t" << res2.get_orig_resnum_idx(Res_align[i].res2);
#endif
        if(res1.get_resid_indexed(Res_align[i].res1) == res2.get_resid_indexed(Res_align[i].res2)){
            idx1.push_back(res1.get_N_idx(Res_align[i].res1));
            idx2.push_back(res2.get_N_idx(Res_align[i].res2));
            idx1.push_back(res1.get_CA_idx(Res_align[i].res1));
            idx2.push_back(res2.get_CA_idx(Res_align[i].res2));
            idx1.push_back(res1.get_C_idx(Res_align[i].res1));
            idx2.push_back(res2.get_C_idx(Res_align[i].res2));
            idx1.push_back(res1.get_O_idx(Res_align[i].res1));
            idx2.push_back(res2.get_O_idx(Res_align[i].res2));
            
            vector<string> side_atoms1 = res1.side_atoms_idx(Res_align[i].res1);
            vector<string> side_atoms2 = res2.side_atoms_idx(Res_align[i].res2);
#ifdef EXTRA_COUTS
            cout << endl << "\t" << Res_align[i].atoms;
            cout << endl << "\t" << Res_align[i].atom_indexes;
            cout << endl << "\t" << side_atoms1;
            cout << endl << "\t" << side_atoms2;
#endif
            for(unsigned int j=0; j<Res_align[i].atoms.size(); j++){
                for(unsigned int k=0; k<side_atoms1.size(); k++){
                    if(Res_align[i].atoms[j]==side_atoms1[k]){
#ifdef EXTRA_COUTS
                        cout << endl << "\t" << side_atoms1[k];
#endif
                        for(unsigned int l=0; l<side_atoms2.size(); l++){
                            if(Res_align[i].atoms[Res_align[i].atom_indexes[j]]==side_atoms2[l]){
                                idx1.push_back(res1.get_side_idx(Res_align[i].res1,k));
                                idx2.push_back(res2.get_side_idx(Res_align[i].res2,l));
#ifdef EXTRA_COUTS
                                cout << "\t" << side_atoms2[l];
                                cout << "\t" << res1.get_side_idx(Res_align[i].res1,k);
                                cout << "\t" << res2.get_side_idx(Res_align[i].res2,l);
                                //cout << idx1.back() << " " << pdb1.line(idx1.back());
                                //cout << idx2.back() << " " << pdb2.line(idx2.back());
#endif
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            
        } /*else {
            side1 = f1.central_side(idx,offset,0);
            side2 = f2.central_side(idx2,offset,0);
        }*/
    }
    
    result.push_back(idx1);
    result.push_back(idx2);
    
    return result;
}

vector<double> get_global_RMSD_scores(PDBfile &pdb1, PDBfile &pdb2, vector<vector<int> > &atomic_alignment, Transform &transf)
{
    vector<double> result;
    
    for(unsigned int i=0; i<atomic_alignment[0].size(); i++){
        /*cout << endl << pdb1.line(atomic_alignment[0][i]) << pdb2.line(atomic_alignment[1][i]);
        coord tmp1 = pdb1.crd(atomic_alignment[0][i]);
        coord tmp2 = transf.transform(pdb2.crd(atomic_alignment[1][i]));
        cout.precision(4);
        cout << pdb1.get_orig_resnum(atomic_alignment[0][i]) << "\t"
        << pdb1.get_resid(atomic_alignment[0][i]) << "\t"
        << pdb1.get_atom(atomic_alignment[0][i]) << "\t"
        << pdb2.get_orig_resnum(atomic_alignment[1][i]) << "\t"
        << pdb2.get_resid(atomic_alignment[1][i]) << "\t"
        << pdb2.get_atom(atomic_alignment[1][i]) << "\t"
        << dist(tmp1,tmp2) << endl;*/
    }
    
    return result;
}


