//
// This file is part of ProSMART.
//

#ifndef align_alignment_scoring_H
#define align_alignment_scoring_H

#include "align_alignment_algorithm.h"

struct frag_score
{
  double eig1;
	double eig2;
	double eig3;
	double score;
	double mean;
	double sd;
	int len;
};

void get_res_align(Align &, Frag &, Frag &, Array2D<double> &, vector<residue_alignment> &, double, vector<residue_alignment> &, double, double &, double &, Residues &, Residues &, vector<double>&, vector<vector<double> >&, vector<string>&, vector<string>&, bool, bool, double &, bool, bool);
vector<double> sidechain_distances(Frag &, Frag &, int, int, int, vector<string> &, bool, vector<string> &, vector<int> &, bool);
bool fix_nomenclature(bool, vector<int> &, vector<double> &, vector<string> &, vector<coord> &, vector<coord> &, string, string);
bool fix_nomenclature(bool, vector<int> &, vector<double> &, vector<string> &, vector<coord> &, vector<coord> &, string, string, string, string);
//double sidechain_RMSD(Frag &, Frag &, int, int, int);
double sidechain_AV(Frag &, Frag &, int, int, int);
double alignment_RMSD(vector<residue_alignment> &, Residues &, Residues &);
void side_global_RMSD(vector<residue_alignment> &, Residues &, Residues &, double &, string &);
void side_global_RMSD(vector<residue_alignment> &, Residues &, Residues &, string &, Transform &);
double av_frag_RMSD(Frag &, Frag &, Align &);
double av_frag_procrustes(Array2D<double> &, Align &);
double min_central_score(vector<residue_alignment> &);
double av_central_score(vector<residue_alignment> &);
double av_min_score(vector<residue_alignment> &);
double av_sideRMSD(vector<residue_alignment> &);
double av_sideMaxDist(vector<residue_alignment> &);
vector<int> no_large_side_dist(vector<residue_alignment> &);
double asa_correlation(vector<residue_alignment> &);
vector<double> score_prediction(Align &, Frag &, Frag &, Array1D<Coords> &, Array1D<Coords> &, vector<double> &, vector<double> &);
vector<double> interfragment_rotation(Align &, Frag &, Frag &, Array1D<Coords> &, Array1D<Coords> &);
vector<vector<double> > get_other_scores(Align &, Frag &, Frag &, Array1D<Coords> &, Array1D<Coords> &, Array2D<double> &);
double get_av_centroid(Array1D<Coords> &);
vector<vector<string> > get_sse_types(Frag &, Frag &, vector<vector<string> > &, string &, vector<vector<double> > &);
vector<vector<string> > get_res_sse(Frag &, Frag &, vector<vector<string> > &, vector<vector<double> > &, vector<vector<double> > &);
double get_KS(vector<vector<double> > &);
double get_Score(vector<vector<double> > &);
vector<int> new_sse(Residues &, vector<vector<string> > &, string &, vector<string> &);
void fragment_library_types(Frag &, vector<vector<string> > &, string &, vector<string> &, int);

Array2D<double> get_proc_norm(Array1D<Coords> &, Array1D<Coords> &, Array2D<double> &, int);
vector<double> get_proc_norm(Align &, Array1D<Coords> &, Array1D<Coords> &, Array2D<double> &);
void get_procrustes_normalisation(vector<frag_score> &, int);
double get_mean(vector<double> &, vector<int> &, int);
double get_sd(vector<double> &, vector<double> &, vector<int> &, int);

vector<vector<int> > get_full_atomic_alignment(Residues &, Residues &, vector<residue_alignment> &);
vector<double> get_global_RMSD_scores(PDBfile &, PDBfile &, vector<vector<int> > &, Transform &);

#endif
