//
// This file is part of ProSMART.
//

#include "align_cluster.h"

int rigid_substructure_identification(Align &alignment, vector<double> &frag_rot, Array2D<double> &FDM, Frag &f1, Frag &f2, Residues &res1, Residues &res2, string &workingdirectory, string &obj1, string &obj2, unsigned short &fragLen, unsigned short &frag_mod, double &CLUSTER_SCORE, double &cluster_degrees, double &CLUSTER_LINKAGE, unsigned int &CLUSTER_MIN, double &CLUSTER_RIGIDITY, vector<Transform> &cluster_transf, vector<vector<residue_alignment> > &Res_align_clusters, vector<Align> &align_clusters, vector<vector<double> > &cluster_costheta_all, vector<vector<double> > &cluster_translate_all, bool OUTPUT_CLUSTER_DM, vector<double> &CLUSTER_COLOUR_v,bool USE_SIDE, double &TRANSLATE_LINKAGE, double &TRANSLATE_MAX)
{
	vector<coord> p1;									//vector of positions corresponding to aligned fragment centres.
	vector<coord> p2;
	vector<Array2D<double> > RM;
	Coords align_norm1;
	Coords align_norm2;
	
	cout << endl << endl << "Finding rigidly conserved structural units:" << endl;
	
	cout << endl << "Calculating between-fragment transformations..." << endl;
	
	///////////////////////////
	//this is only needed to output rotational dissimilarity matrix of all alignments
	
	int N_align_all = alignment.len();		
	cout << endl << "Starting with " << N_align_all << " fragment-pairs aligned." << endl;
	
	/*for(unsigned int i=1; i<=alignment.len(); i++){
	 cout << endl << i << "\t" << frag_rot[i-1] << "\t" << FDM[alignment.get(1,i)][alignment.get(2,i)];
	 }*/
	
	if(OUTPUT_CLUSTER_DM==1){
        for(int i=1; i<=N_align_all; i++){
            p1.push_back(f1.get_mean(alignment.get(1,i)));
            p2.push_back(f2.get_mean(alignment.get(2,i)));
            align_norm1 = f1.crds_norm(alignment.get(1,i));			//this could probably be optimised by utilising coordinates stored in memory from calculations for distance matrix above.
            align_norm2 = f2.crds_norm(alignment.get(2,i));
            RM.push_back(rotateM(align_norm1,align_norm2));
        }
        
        //get differential translation matrix
        Array2D<double> transM(N_align_all,N_align_all,0.0);
        get_translation_matrix(transM,p1,p2);
        
        //get differential rotation matrix
        Array2D<double> costheta_all(N_align_all,N_align_all);
        get_rotation_matrix(costheta_all,RM);
        
        //output costheta matrix
        fileoutput_costheta(costheta_all,workingdirectory+"costheta_all.txt");
        fileoutput_translate(transM,workingdirectory+"translate_all.txt");
	}
	///////////////////////////
	
	Align falign = clustering_filter(alignment,frag_rot,cluster_degrees,FDM,CLUSTER_SCORE);		//filter alignment so that clusters are more likely to be well-defined and have larger seperability
	int N_align = falign.len();
	//for(int i=1; i<=N_align; i++){cout << endl << "falign: " << i << "\tfrag_i: " << falign.get(1,i) << "\tscore: " << FDM[falign.get(1,i)][falign.get(2,i)] << "\tfrag_rot: " << frag_rot[falign.get(1,i)];}
	
	cout << endl << N_align << " fragment-pairs remaining after filtering (Procrustes < " << CLUSTER_SCORE << ", Hinging < " << cluster_degrees << ")." << endl;
	
    if(N_align==0){
        return 0;
    }
    
	RM.clear();
    p1.clear();
    p2.clear();
	//get fragment centres and rotation matrices
	for(int i=1; i<=N_align; i++){
		p1.push_back(f1.get_mean(falign.get(1,i)));
		p2.push_back(f2.get_mean(falign.get(2,i)));
        align_norm1 = f1.crds_norm(falign.get(1,i));			//this could probably be optimised by utilising coordinates stored in memory from calculations for distance matrix above.
		align_norm2 = f2.crds_norm(falign.get(2,i));
		RM.push_back(rotateM(align_norm1,align_norm2));
	}
	
	//get differential and max translation matrices
    Array2D<double> transM(N_align_all,N_align_all,0.0);
    get_translation_matrix(transM,p1,p2);
	
	//get differential rotation matrix
	Array2D<double> costheta(N_align,N_align);
	get_rotation_matrix(costheta,RM);
	
	if(OUTPUT_CLUSTER_DM==1){
        //output costheta matrix
        fileoutput_costheta(costheta,workingdirectory+"costheta_filtered.txt");
        fileoutput_translate(transM,workingdirectory+"translate_filtered.txt");
	}
	
	cout << endl << "Performing single linkage clustering (cosine linkage parameter: " << CLUSTER_LINKAGE << ", minimum fragments per cluster: " << CLUSTER_MIN << ")" << endl;
	
	//whilst single linkage method may not always successfully find clusters, it is very quick.
	//it always finds well-separated clusters, and so would be a great initial cluster pre-filter.
	//currently only utilises differential rotation matrix, ignores the translational component.
	vector<vector<int> > clusters = single_linkage_clusters(costheta,CLUSTER_LINKAGE,transM,TRANSLATE_LINKAGE,TRANSLATE_MAX,fragLen);
	//for(unsigned int i=0; i<clusters.size(); i++){cout << endl; for(unsigned int j=0; j<clusters[i].size(); j++){cout << clusters[i][j] << " ";}}
	
	for(unsigned int i=0; i<clusters.size(); i++){
		if(clusters[i].size() < CLUSTER_MIN){
			clusters.erase(clusters.begin()+i);
			i--;
		}
	}
	
	if(OUTPUT_CLUSTER_DM==1){
	//output costheta matrix for preliminary clusters
	fileoutput_costheta(costheta,clusters,workingdirectory+"costheta_cluster_preliminary.txt");
	}
	
	//get quaternions for all fragment-pairs
	vector<quarternion> quart = get_quarternions(RM);
	
	//get quaternions corresponding to cluster 'centres'
	vector<quarternion> quart_clust = get_average_quarternions(quart,clusters);
	
	//get rotations corresponding to cluster 'centres'
	vector<Array2D<double> > RM_clust = get_rot_from_quart(quart_clust);
	
	vector<Array2D<double> > RM_test;
	vector<vector<int> > clusters_tmp;
	vector<int> tmpv;

	if(OUTPUT_CLUSTER_DM==1){
		RM_test = RM;
		clusters_tmp = clusters;
		for(unsigned int i=0; i<RM_clust.size(); i++){
			RM_test.push_back(RM_clust[i]);
		}
		
		Array2D<double> costheta_all_test(RM_test.size(),RM_test.size());
		get_rotation_matrix(costheta_all_test,RM_test);
		for(unsigned int i=1; i<=clusters.size(); i++){
			tmpv.push_back(RM_test.size()-i);
		}
		if(tmpv.size()>0){
			clusters_tmp.push_back(tmpv);
		}
		//same as for preliminary clusters, but with cluster averages also.
		fileoutput_costheta(costheta_all_test,clusters_tmp,workingdirectory+"costheta_cluster_quart.txt");
	}
	
	unsigned int no_clusters = clusters.size();
	
	//get costheta between each cluster and all of its elements.
	
	vector<vector<double> > cluster_costheta;
	get_costheta_clusters(cluster_costheta, quart, quart_clust, clusters);
    
	/*vector<vector<double> > cluster_costheta_rm;
	 get_costheta_clusters(cluster_costheta_rm, RM, RM_clust, clusters);
	 cout << endl;
	 cout.precision(6);
	 for(unsigned int i=0; i<cluster_costheta.size(); i++){
	 cout << endl;
	 for(unsigned int j=0; j<cluster_costheta[i].size(); j++){
	 cout << cluster_costheta_rm[i][j] << "\t" << cluster_costheta[i][j] << endl;
	 }			
	 }
	 cout << endl;*/
	
	if(no_clusters > 0){
		cout << endl << "Preliminary clustering results:";
		cout << endl << "Cluster\t\tFragments\tMean CosTheta\tSD CosTheta";
		cout.precision(4);
		double mn_costheta = 0.0;
		for(unsigned int i=0; i<no_clusters; i++){
			mn_costheta = average(cluster_costheta[i]);
			cout << endl << i << "\t\t" << clusters[i].size() << "\t\t" << mn_costheta << "\t\t" << stddev(cluster_costheta[i],mn_costheta);
		}
		
		cout << endl << endl << "Refining clusters to improve superposition (rigidity parameter: " << CLUSTER_RIGIDITY << ")" << endl;
		//cut clusters down to improve superimposition
		filter_clusters(clusters,cluster_costheta,CLUSTER_RIGIDITY);
		
		no_clusters = clusters.size();
	}
	
	
	if(no_clusters > 0){
		
		//get quaternions corresponding to cluster 'centres'
		quart_clust = get_average_quarternions(quart,clusters);
		
		//get rotations corresponding to cluster 'centres'
		RM_clust = get_rot_from_quart(quart_clust);
		
		if(OUTPUT_CLUSTER_DM==1){
            RM_test = RM;
            for(unsigned int i=0; i<RM_clust.size(); i++){
                RM_test.push_back(RM_clust[i]);
            }
            
            Array2D<double> costheta_all_test_final(RM_test.size(),RM_test.size());
            get_rotation_matrix(costheta_all_test_final,RM_test);
            clusters_tmp = clusters;
            tmpv.clear();
            for(unsigned int i=1; i<=clusters.size(); i++){
                tmpv.push_back(RM_test.size()-i);
            }
            if(tmpv.size()>0){
                clusters_tmp.push_back(tmpv);
            }			
            //with cluster averages also.
            fileoutput_costheta(costheta_all_test_final,clusters_tmp,workingdirectory+"costheta_cluster_final.txt");
		}
		
		//vector<vector<double> > cluster_costheta_final;
		//get_costheta_clusters(cluster_costheta_final, RM, RM_clust, clusters);
		
		vector<vector<double> > cluster_costheta_final;
		get_costheta_clusters(cluster_costheta_final, quart, quart_clust, clusters);
		
		
		cout << endl << "Final clustering results:";
		cout << endl << "Cluster\t\tFragments\tMean CosTheta\tSD CosTheta";
		cout.precision(4);
		double mn_costheta = 0.0;
		double sd_costheta = 0.0;
		for(unsigned int i=0; i<no_clusters; i++){
			mn_costheta = average(cluster_costheta_final[i]);
            sd_costheta = stddev(cluster_costheta_final[i],mn_costheta);
			cout << endl << i << "\t\t" << clusters[i].size() << "\t\t" << mn_costheta << "\t\t" << sd_costheta;
		}
		
	} else {
		cout << endl << "No clusters were found that meet the criteria." << endl;
	}
	cout << endl;

	Array2D<double> cluster_costheta_clusters(no_clusters,no_clusters);
	
	if(no_clusters > 0){
		
		align_clusters = get_align_clusters(clusters,falign);
		//for(unsigned int k=0; k<align_clusters.size(); k++){cout << endl;for(unsigned int i=1; i<=align_clusters[k].len(); i++){cout << endl << "falign: " << i << "\tfrag_i: " << align_clusters[k].get(1,i) << "\tscore: " << FDM[align_clusters[k].get(1,i)][align_clusters[k].get(2,i)] << "\tfrag_rot: " << frag_rot[align_clusters[k].get(1,i)];}}
		
		RM_clust = get_rot_from_quart(quart_clust);
		
		for(unsigned int i=0; i<no_clusters; i++){
			//get central residues of fragments in the cluster.
			Res_align_clusters.push_back(get_central_res_cluster(align_clusters[i],f1,f2,frag_mod));
		}
		
		//get transform to superpose clusters
		//this determines the rotations, which are used to subsequently calculate scores
		cluster_transf.clear();
		for(unsigned int i=0; i<no_clusters; i++){
            /*Transform tmp_transf;
            if(Res_align_clusters[i].size()==0){
                tmp_transf.create();
            } else {
                Coords c1 = res1.crds1(Res_align_clusters[i]);                  //main chain of residues in cluster definition
                Coords c2 = res2.crds2(Res_align_clusters[i]);
                //Coords c1;
                //Coords c2;
                //get_coords_inc_side(res1,res2,Res_align_clusters[i],c1,c2);   //main+side chain of residues in cluster definition
                tmp_transf = get_transf(c1,c2,RM_clust[i]);     //fix rotation, optimise translation
            }
            cluster_transf.push_back(tmp_transf);*/
        
			
            //get transformation in usual way to begin with, using residues from the cluster
			cluster_transf.push_back(get_transf(res1,res2,Res_align_clusters[i],USE_SIDE));
			//overwrite the rotation matrix (calculated by superposing residues)
			//with the one arising from normalised average quaternion, and then
			//redefine final translation to account for the rotational difference.
//#define FORCE_R_FROM_QUATERNION
#ifdef FORCE_R_FROM_QUATERNION
            cluster_transf[i].set_r(RM_clust[i]);
#endif
			//THIS SHOULD BE OPTIONAL - USING SUPERPOSITION-BASED TRANSFORMATION SHOULD BE AN OPTION!!!
            
		}
		
		////////////////////////////////////////////////////////////////////////////////////////////
		// get other scores
		
		//get ALL fragment rotation matrices
        vector<Array2D<double> > RM_all;					//this is partially repeated calculations - this could be done quicker by doing earlier.
		Coords pos1;
        Coords pos2;
        for(unsigned int i=1; i<=alignment.len(); i++){
            pos1.add(f1.get_mean(alignment.get(1,i)));
            pos2.add(f2.get_mean(alignment.get(2,i)));
            align_norm1 = f1.crds_norm(alignment.get(1,i));
			align_norm2 = f2.crds_norm(alignment.get(2,i));
			RM_all.push_back(rotateM(align_norm1,align_norm2));
		}
		
		//get scores for all clusters with ALL fragments
		get_all_rotation_vectors(cluster_costheta_all,cluster_transf,RM_all);
        get_all_translation_vectors(cluster_translate_all,cluster_transf,pos1,pos2);

        
		/*cout << endl << endl;
        for(unsigned int i=0; i<cluster_costheta_all[0].size(); i++){
            cout << endl;
            for(unsigned int j=0; j<cluster_costheta_all.size(); j++){
                cout << cluster_costheta_all[j][i] << " " << trans_scores[i][j] << endl;
            }
            break;
        }
        cout << endl << endl;*/
		
		/////////////
		
		//get costheta scores for all-on-all clusters
		get_cluster_rotations(cluster_costheta_clusters,cluster_transf);
        
        
        /*vector<double> cluster_rot_score(no_clusters,0.0);
        for(unsigned int i=0; i<no_clusters; i++){
			for(unsigned int j=0; j<no_clusters; j++){
                if(i!=j){
                    cluster_rot_score[i] += cluster_costheta_clusters[i][j];
                }
            }
            cluster_rot_score[i] = cluster_rot_score[i]/(no_clusters-1);
        }*/
        
        //colour ratio should increase with mncostheta, and decrease with (average?) cluster_rot_score[i].
        for(unsigned int i=0; i<no_clusters; i++){
            double mn_costheta = average(cluster_costheta[i]);
            double sd_costheta = stddev(cluster_costheta[i],mn_costheta);
            CLUSTER_COLOUR_v.push_back(1.0-(mn_costheta-3.0*sd_costheta));
            //cout << endl << i << "\t" << clusters[i].size() << "\t" << mn_costheta << "\t" << sd_costheta << "\t" << CLUSTER_COLOUR_v[i];
        }
		
		double costheta_to_degrees = 45.0/atan(1.0);
		cout << endl << endl << "Inter-Cluster Rotational Dissimilarity (degrees):" << endl;
		cout.precision(1);
		for(unsigned int i=0; i<no_clusters; i++){cout << "\t" << i;}
		for(unsigned int i=0; i<no_clusters; i++){
			cout << endl << i;
			for(unsigned int j=0; j<no_clusters; j++){
				if(i==j){
					cout << "\t0";
				} else {
					cout << "\t" << acos(cluster_costheta_clusters[i][j])*costheta_to_degrees;
				}
			}
		}
		/*cout << endl;
        cout << endl << endl << "Inter-Cluster Translational Difference:" << endl;
        for(unsigned int i=0; i<no_clusters; i++){cout << "\t" << i;}
		for(unsigned int i=0; i<no_clusters; i++){
			cout << endl << i;
			for(unsigned int j=0; j<no_clusters; j++){
				if(i==j){
					cout << "\t0";
				} else {
					cout << "\t" <<
				}
			}
		}*/
		
		/*cout.precision(3);
		 for(unsigned int i=0; i<cluster_transf.size(); i++){
		 cout << endl << "Cluster " << i << endl << cluster_transf[i] << endl;
		 }*/        
	}
	cout << endl;
    return no_clusters;
}

Align clustering_filter(Align &alignment, vector<double> &frag_rot, double DEGREES, Array2D<double> &FDM, double ALIGN_SCORE)
{
	Align result = alignment;
	double ANGLE_RESOLUTION = 2.0;
	if(DEGREES < 180){
		ANGLE_RESOLUTION = (1-cos(DEGREES*(atan(1.0)/45)));		//PI ~ 4*atan(1.0)
	}
		
	int j=-1;
	for(unsigned int i=1; i<=result.len(); i++){
		j++;
		//cout << endl << i << "\t" << frag_rot[j] << "\t" << FDM[result.get(1,i)][result.get(2,i)];
		if(frag_rot[j] <= ANGLE_RESOLUTION){					// 0.12 ~20degrees; 0.07 ~15degrees.
			if(FDM[result.get(1,i)][result.get(2,i)] <= ALIGN_SCORE){
				continue;
			}
		}
		result.erase(i-1);
		i--;
	}
	
	return result;
}

void filter_clusters(vector<vector<int> > &clusters, vector<vector<double> > &costheta, double ALIGN_SCORE)
{
	for(unsigned int i=0; i<clusters.size(); i++){
		for(unsigned int j=0; j<clusters[i].size(); j++){
			if(costheta[i][j] >= ALIGN_SCORE){
				continue;
			}
			clusters[i].erase(clusters[i].begin()+j);
			costheta[i].erase(costheta[i].begin()+j);
			j--;
		}
		if(clusters[i].size() == 0){
			clusters.erase(clusters.begin()+i);
			costheta.erase(costheta.begin()+i);
			i--;
		}
	}
	return;
}

void get_translation_matrix(Array2D<double> &transM, vector<coord> &p1, vector<coord> &p2)
{
	double d1 = 0.0;
	double d2 = 0.0;
	int N = transM.dim1();
	for(int i=0; i<N; i++){
		for(int j=i+1; j<N; j++){
            d1 = dist(p1[i],p1[j]);
            d2 = dist(p2[i],p2[j]);
            if(d1>=d2){
                transM[i][j] = d1;
                transM[j][i] = d2;
            } else {
                transM[i][j] = d2;
                transM[j][i] = d1;
            }
		}
	}
	//for(int i=0; i<15; i++){cout << endl;for(int j=0; j<15; j++){cout << dTM[i][j] << " ";}}
	return;
}

void get_rotation_matrix(Array2D<double> &dRM, vector<Array2D<double> > &RM)
{
	double temp_d = 0.0;
	int N = dRM.dim1();
	for(int i=0; i<N; i++){								//this could probably be optimised by filtering out bad fragment-pairs (e.g. using differential translation matrix)
		dRM[i][i] = 1.0;
		for(int j=i+1; j<N; j++){
			temp_d = 0.0;
			for(int x=0; x<3; x++){
				for(int y=0; y<3; y++){
					temp_d += RM[i][x][y]*RM[j][x][y];
				}
			}
         if(temp_d>3.0){temp_d=3.0;}
			dRM[i][j] = (temp_d-1)/2;								// = cos(theta)
			dRM[j][i] = dRM[i][j];
		}
	}
	//for(int i=0; i<15; i++){cout << endl;for(int j=0; j<15; j++){cout << dRM[i][j] << " ";}}
	return;
}

void get_costheta_clusters(vector<vector<double> > &dRM, vector<Array2D<double> > &RM, vector<Array2D<double> > &RMclust, vector<vector<int> > &clusters)
{
	double temp_d = 0.0;
	vector<double> tmpv;
	for(unsigned int i=0; i<clusters.size(); i++){
		tmpv.clear();
		for(unsigned int j=0; j<clusters[i].size(); j++){
			temp_d = 0.0;
			for(unsigned int x=0; x<3; x++){
				for(unsigned int y=0; y<3; y++){
					temp_d += RMclust[i][x][y]*RM[clusters[i][j]][x][y];
				}
			}
         if(temp_d>3.0){temp_d=3.0;}
			tmpv.push_back((temp_d-1)/2);
		}
		dRM.push_back(tmpv);
	}
	return;
}

void get_costheta_clusters(vector<vector<double> > &dRM, vector<quarternion> &q, vector<quarternion> &qc, vector<vector<int> > &clusters)
{
	double temp_d = 0.0;
	vector<double> tmpv;
	//quarternion tmpq;
	//quarternion tmpinv;
	for(unsigned int i=0; i<clusters.size(); i++){
		tmpv.clear();
		for(unsigned int j=0; j<clusters[i].size(); j++){
			/*temp_d = q[clusters[i][j]].q1*qc[i].q4 - q[clusters[i][j]].q2*qc[i].q3 + q[clusters[i][j]].q3*qc[i].q2 - q[clusters[i][j]].q4*qc[i].q1;
			//temp_d = q[clusters[i][j]].q4*qc[i].q1 - q[clusters[i][j]].q2*qc[i].q3 + q[clusters[i][j]].q3*qc[i].q2 - q[clusters[i][j]].q1*qc[i].q4;
			//tmpq = multiply_quarternion_conj(qc[i],q[clusters[i][j]]);
			tmpinv.q1 = q[clusters[i][j]].q1;
			tmpinv.q2 = -q[clusters[i][j]].q2;
			tmpinv.q3 = -q[clusters[i][j]].q3;
			tmpinv.q4 = -q[clusters[i][j]].q4;
			tmpq = multiply_quarternions(tmpinv,q[clusters[i][j]]);
			//tmpq = multiply_quarternions(tmpinv,q[clusters[i][j]]);
			temp_d = tmpq.q4;
			cout << endl << temp_d << " " << 2*acos(temp_d) << endl;
			cout << q[clusters[i][j]].q1 << " " << qc[i].q1 << " " << tmpinv.q1 << " " << tmpq.q1 << endl;
			cout << q[clusters[i][j]].q2 << " " << qc[i].q2 << " " << tmpinv.q2 << " " << tmpq.q2 << endl;
			cout << q[clusters[i][j]].q3 << " " << qc[i].q3 << " " << tmpinv.q3 << " " << tmpq.q3 << endl;
			cout << q[clusters[i][j]].q4 << " " << qc[i].q4 << " " << tmpinv.q4 << " " << tmpq.q4 << endl;
*/
			
			temp_d = q[clusters[i][j]].q1*qc[i].q1 + q[clusters[i][j]].q2*qc[i].q2 + q[clusters[i][j]].q3*qc[i].q3 + q[clusters[i][j]].q4*qc[i].q4;
			
			
			tmpv.push_back(2*temp_d*temp_d - 1);
			//tmpv.push_back(cos(2*acos(temp_d)));
		}
		dRM.push_back(tmpv);
	}
	return;
}

/*void get_translation_vectors(vector<vector<double> > &cluster_TM, vector<vector<Transform> > &cluster_transf, vector<coord> &p1, vector<coord> &p2, vector<vector<int> > &clusters)
{
	double temp_d = 0.0;
	coord cp1;
	coord cp2;
	vector<double> temp_vd;
	for(unsigned int i=0; i<clusters.size(); i++){
		cp1 = cluster_transf[i][0].get_t();
		cp2 = cluster_transf[i][1].get_t();
		cluster_TM.push_back(temp_vd);
		for(unsigned int j=0; j<clusters[i].size(); j++){
			temp_d = dist(cp1,p1[clusters[i][j]]) - dist(cp2,p2[clusters[i][j]]);
			cluster_TM[i].push_back(absol(temp_d));
		}
	}
	return;
}*/

void get_rotation_vectors(vector<vector<double> > &cluster_costheta, vector<Transform> &cluster_transf, vector<Array2D<double> > &RM, vector<vector<int> > &clusters)
{
	double temp_d = 0.0;
	Array2D<double> cRM(3,3);
	vector<double> temp_vd;
	for(unsigned int i=0; i<clusters.size(); i++){
		cRM = cluster_transf[i].get_r();
		temp_vd.clear();
		for(unsigned int j=0; j<clusters[i].size(); j++){
			temp_d = 0.0;
			for(int x=0; x<3; x++){
				for(int y=0; y<3; y++){
					temp_d += cRM[x][y]*RM[clusters[i][j]][x][y];
				}
			}
         if(temp_d>3.0){temp_d=3.0;}
			temp_vd.push_back((temp_d-1)/2);
		}
		cluster_costheta.push_back(temp_vd);
	}
	
	return;
}

/*void get_all_translation_vectors(vector<vector<double> > &cluster_TM, vector<Transform> &cluster_transf, vector<coord> &p1, vector<coord> &p2)
{
	double temp_d = 0.0;
	coord cp1;
	coord cp2;
	vector<double> temp_vd;
	for(unsigned int i=0; i<cluster_transf.size(); i++){
		cp1 = cluster_transf[i][0].get_t();
		cp2 = cluster_transf[i][1].get_t();
		cluster_TM.push_back(temp_vd);
		for(unsigned int j=0; j<p1.size(); j++){
			temp_d = dist(cp1,p1[j]) - dist(cp2,p2[j]);
			cluster_TM[i].push_back(absol(temp_d));
		}
	}
	return;
}*/

void get_all_translation_vectors(vector<vector<double> > &cluster_TM, vector<Transform> &cluster_transf, Coords &pos1, Coords &pos2)
{
	Coords pos2_transf;
	vector<double> temp_vd;
	for(unsigned int i=0; i<cluster_transf.size(); i++){
		pos2_transf = cluster_transf[i].transform(pos2);
		cluster_TM.push_back(temp_vd);
		for(int j=0; j<pos1.size(); j++){
			cluster_TM[i].push_back(dist(pos1.get(j),pos2_transf.get(j)));
		}
	}
	return;
}

void get_all_rotation_vectors(vector<vector<double> > &costheta, vector<Transform> &cluster_transf, vector<Array2D<double> > &RM)
{
	double temp_d = 0.0;
	Array2D<double> cRM(3,3);
	vector<double> temp_vd;
	for(unsigned int i=0; i<cluster_transf.size(); i++){
		cRM = cluster_transf[i].get_r();
		temp_vd.clear();
		for(unsigned int j=0; j<RM.size(); j++){
			temp_d = 0.0;
			for(int x=0; x<3; x++){
				for(int y=0; y<3; y++){
					temp_d += cRM[x][y]*RM[j][x][y];
				}
			}
         if(temp_d>3.0){temp_d=3.0;}
			temp_vd.push_back((temp_d-1)/2);
		}
		costheta.push_back(temp_vd);
	}
	
	return;
}

void get_cluster_rotations(Array2D<double> &costheta, vector<Transform> &cluster_transf)
{
	double temp_d = 0.0;
	Array2D<double> cRM1(3,3);
	Array2D<double> cRM2(3,3);
	double N = cluster_transf.size();
	
	for(unsigned int i=0; i<N; i++){
		costheta[i][i] = 1.0;
		cRM1 = cluster_transf[i].get_r();
		for(unsigned int j=i+1; j<N; j++){
			cRM2 = cluster_transf[j].get_r();
			temp_d = 0.0;
			for(int x=0; x<3; x++){
				for(int y=0; y<3; y++){
					temp_d += cRM1[x][y]*cRM2[x][y];
				}
			}
         if(temp_d>3.0){temp_d=3.0;}
			costheta[i][j] = (temp_d-1)/2;
			costheta[j][i] = costheta[i][j];
		}
	}
	
	return;
}

vector<vector<int> > single_linkage_clusters(Array2D<double> &costheta, double &CLUSTER_SCORE, Array2D<double> &transM, double &TRANSLATE_SCORE, double &TRANSLATE_MAX, unsigned short &fraglen)
{
	vector<vector<int> > clusters;
	vector<int> temp_cluster;
	vector<int> clustered;
	int N = costheta.dim1();
	int modifier = (int)fraglen - 2;
	
	for(int i=0; i<N; i++){
		clustered.push_back(-1);
	}

	int cluster_no = -1;
	for(int i=0; i<N; i++){
		if(clustered[i] == -1){
			cluster_no++;
			clustered[i] = cluster_no;
			add_to_cluster(costheta,transM,clustered,i,CLUSTER_SCORE,TRANSLATE_SCORE,TRANSLATE_MAX,modifier);
		}
	}
	
	for(int i=0; i<N; i++){
		if(clustered[i] >= (int)clusters.size()){
			clusters.push_back(temp_cluster);
		}
		clusters[clustered[i]].push_back(i);
	}
		
	return clusters;
}

void add_to_cluster(Array2D<double> &costheta, Array2D<double> &transM, vector<int> &clustered, int &i, double &CLUSTER_SCORE, double &TRANSLATE_SCORE, double &TRANSLATE_MAX, int &modifier)
{
   //cout << endl << endl << "add to cluster";
	for(int j=0; j<costheta.dim1(); j++){		//have to check all, not just diagonal
		if(clustered[j] == -1){
         //cout << endl << j;
			if(j+modifier < i || i < j-modifier){							//fragments too close have too few degrees of freedom to be reliable for the single linkage method.
            //cout << "\t" << costheta[i][j] << "\t" << transM[i][j];
				if(costheta[i][j] >= CLUSTER_SCORE){
                    if(transM[i][j] <= TRANSLATE_MAX){
                       //cout << "\t*";
                        if(transM[i][j]-transM[j][i] <= TRANSLATE_SCORE){
                            clustered[j] = clustered[i];
                           //cout << "**";
                            add_to_cluster(costheta,transM,clustered,j,CLUSTER_SCORE,TRANSLATE_SCORE,TRANSLATE_MAX,modifier);
                        }
                    }
				}
			}
		}
	}
	return;
}

vector<Align> get_align_clusters(vector<vector<int> > &clusters, Align &falign)
{
	vector<Align> result;
	
	for(unsigned int i=0; i<clusters.size(); i++){
		result.push_back(falign.get_cluster(clusters[i]));
	}
	
	return result;
}

vector<residue_alignment> get_central_res_cluster(Align &align_cluster, Frag &f1, Frag &f2, int frag_mod)
{
	vector<residue_alignment> result;
	residue_alignment temp;
	temp.type1 = " ";
	temp.type2 = " ";
	temp.dist = -1.0;
	temp.dist2 = -1.0;
	temp.dist3 = -1.0;
	temp.dist4 = -1.0;
	temp.rot = -1.0;
	temp.other.clear();
	temp.frag1 = -1;
	temp.frag2 = -1;
	
	for(unsigned int i=1; i<=align_cluster.len(); i++){
		temp.res1 = f1.idx(align_cluster.get(1,i))+frag_mod;
		temp.res2 = f2.idx(align_cluster.get(2,i))+frag_mod;
		result.push_back(temp);
	}
	
	return result;
}

vector<residue_alignment> get_frag_res_cluster(Align &align_cluster, Frag &f1, Frag &f2, unsigned short fragLen)
{
	vector<residue_alignment> result;
	residue_alignment temp;
	temp.type1 = " ";
	temp.type2 = " ";
	temp.dist = -1.0;
	temp.dist2 = -1.0;
	temp.dist3 = -1.0;
	temp.dist4 = -1.0;
	temp.rot = -1.0;
	temp.other.clear();
	temp.frag1 = -1;
	temp.frag2 = -1;	
	
	int res1 = f1.idx(align_cluster.get(1,1));
	int res2 = f2.idx(align_cluster.get(2,1));
	for(unsigned short j=0; j<fragLen; j++){
		temp.res1 = res1 + j;
		temp.res2 = res2 + j;
		result.push_back(temp);
	}
	
	for(unsigned int i=2; i<=align_cluster.len(); i++){
		res1 = f1.idx(align_cluster.get(1,i));
		res2 = f2.idx(align_cluster.get(2,i));
		for(unsigned short j=0; j<fragLen; j++){
			if(res1+j > result[result.size()-1].res1){
				temp.res1 = res1 + j;
				temp.res2 = res2 + j;
				result.push_back(temp);
			}
		}
	}
	
	return result;
}

vector<residue_alignment> get_all_res_cluster(Align &alignment, Frag &f1, Frag &f2, unsigned short fragLen)
{
	vector<residue_alignment> result;
	residue_alignment temp;	//stays empty
	temp.res1 = -1;
	temp.res2 = -1;
	temp.type1 = " ";
	temp.type2 = " ";
	temp.dist = -1.0;
	temp.dist2 = -1.0;
	temp.dist3 = -1.0;
	temp.dist4 = -1.0;
	temp.rot = -1.0;
	temp.other.clear();
	temp.frag1 = -1;
	temp.frag2 = -1;
	temp.frags.clear();
	
	int res1 = f1.idx(alignment.get(1,1));
	int res2 = f2.idx(alignment.get(2,1));
	for(unsigned short j=0; j<fragLen; j++){
		while((int)result.size()<=res1+j){
			result.push_back(temp);
		}
		result[res1+j].res1 = res1+j;
		result[res1+j].res2 = res2+j;
		result[res1+j].frags.push_back(0);
	}
	
	for(unsigned int i=2; i<=alignment.len(); i++){
		res1 = f1.idx(alignment.get(1,i));
		res2 = f2.idx(alignment.get(2,i));
		for(unsigned short j=0; j<fragLen; j++){
			while((int)result.size()<=res1+j){
				result.push_back(temp);
			}
			result[res1+j].res1 = res1+j;
			result[res1+j].res2 = res2+j;
			result[res1+j].frags.push_back(i-1);
		}
	}
	
	//cout << endl << endl << endl;
	for(unsigned int i=0; i<result.size(); i++){
		if(result[i].res1 == -1){
			result.erase(result.begin()+i);
			i--;
			continue;
		}
		/*cout << endl << i << "\t" << result[i].res1 << "\t" << result[i].res2 << "\t";
		for(unsigned int j=0; j<result[i].frags.size(); j++){
			cout << result[i].frags[j] << " ";
		}*/
	}
	
	return result;
}

//this is for writing alignment file specifiying all cluster belongingness scores, as angle in degrees
void write_cluster_alignment(vector<residue_alignment> &Res_align_all, vector<res_corresp> &original_res1, vector<res_corresp> &original_res2, vector<vector<double> > &cluster_costheta_all, string &fileout, double &ORIGINAL_CLUSTER_RIGIDITY, bool DISPLAY_AS_COSINE_DISTANCE)
{
    unsigned int no_clusters = cluster_costheta_all.size();
    double costheta_to_degrees = 45.0/atan(1.0);
    double temp_d = 0.0;
    int temp_i = -1;
    
    ofstream outfile;

    outfile.open(fileout.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Residue-Based Cluster Rotational Dissimilarity File" << endl;
        outfile << "Res1\tRes2\tClust";
        for(unsigned int i=0; i<no_clusters; i++){
            outfile << "\tClust" << i;
        }
        outfile << endl;
        for(unsigned int j=0; j<Res_align_all.size(); j++){
            outfile << original_res1[Res_align_all[j].res1].res << original_res1[Res_align_all[j].res1].ins;
            outfile << "\t" << original_res2[Res_align_all[j].res2].res << original_res2[Res_align_all[j].res2].ins;
            
            temp_d = 0.0;
            temp_i = -1;
            for(unsigned int i=0; i<no_clusters; i++){
                for(unsigned int k=0; k<Res_align_all[j].frags.size(); k++){
                    if(cluster_costheta_all[i][Res_align_all[j].frags[k]] > temp_d){
                        temp_d = cluster_costheta_all[i][Res_align_all[j].frags[k]];
                        temp_i = i;
                    }
                }
            }
            if(temp_i>=0){
                if(temp_d < ORIGINAL_CLUSTER_RIGIDITY){
                    temp_i = -1;
                }
            }
            if(temp_i>=0){
                outfile << "\t" << temp_i;
            } else {
                outfile << "\tNA";
            }
            
            for(unsigned int i=0; i<no_clusters; i++){
                temp_d = 0.0;
                for(unsigned int k=0; k<Res_align_all[j].frags.size(); k++){
                    if(cluster_costheta_all[i][Res_align_all[j].frags[k]] > temp_d){
                        temp_d = cluster_costheta_all[i][Res_align_all[j].frags[k]];
                    }
                }
               if(temp_d>1.0){
                  temp_d = 1.0;
               }
                if(DISPLAY_AS_COSINE_DISTANCE){
                    outfile << "\t" << decimal_places(1-temp_d,5);
                } else {
                    outfile << "\t" << decimal_places(acos(temp_d)*costheta_to_degrees,2);
                }
            }
            outfile << endl;
        }
        
        outfile.close();
		cout << endl << "Cluster alignment file written to: " << fileout;
    } else {
        cout << "Unable to open output file " << fileout << " for writing" << endl;
    }

    
    return;
}

void write_pymol_cluster(vector<string> &info, vector<vector<residue_alignment> > &Res_align, Residues &res1, Residues &res2, string obj1_, string obj2_, string file, char domain1, char domain2, vector<res_corresp> &original_res1, vector<res_corresp> &original_res2)
{
  ofstream outfile;
	string obj1 = obj1_ + "*";
	string obj2 = obj2_ + "*";			//this means that all files starting with obj2 will be coloured (i.e. original and all clusters)
  
  vector<int> All_Res1 = res1.get_res();		//stores the residue numbers for all residues.
  vector<int> All_Res2 = res2.get_res();
  Array1D<int> scores1(All_Res1.size(),-1);		//will store the scores corresponding to the residues
  Array1D<int> scores2(All_Res2.size(),-1);		//if a residue is unaligned then it scores -1
  unsigned int N = Res_align.size();
	int idx = 0;
	
	if(N > 18){
		cout << endl << endl << "Warning: too many clusters - not all clusters will be assigned colors in color files." << endl << endl;
	}
	
	for(unsigned int k=0; k<N; k++){
		idx = 0;
		for(unsigned int i=0; i<Res_align[k].size(); i++){
			if(All_Res1[idx]==Res_align[k][i].res1){
				scores1[idx] = k;
			} else {
				i--;
			}
			idx++;
		}
		idx = 0;
		for(unsigned int i=0; i<Res_align[k].size(); i++){
			if(All_Res2[idx]==Res_align[k][i].res2){
				scores2[idx] = k;
			} else {
				i--;
			}
			idx++;
		}
	}
	
  vector<double> colors11;
  vector<double> colors12;
  vector<double> colors13;
  vector<double> colors21;
  vector<double> colors22;
  vector<double> colors23;
  for(int i=0; i<scores1.dim1(); i++){
		//cout << endl << i << " " << scores1[i];
		switch(scores1[i]){
			case -1: 
					colors11.push_back(1);
					colors12.push_back(1);
					colors13.push_back(1);
				break;
			case 0: 
					colors11.push_back(1);
					colors12.push_back(0);
					colors13.push_back(0);
				break;
			case 1: 
					colors11.push_back(0);
					colors12.push_back(1);
					colors13.push_back(0);
				break;
			case 2: 
					colors11.push_back(0);
					colors12.push_back(0);
					colors13.push_back(1);
				break;
			case 3: 
					colors11.push_back(1);
					colors12.push_back(1);
					colors13.push_back(0);
				break;
			case 4: 
					colors11.push_back(1);
					colors12.push_back(0);
					colors13.push_back(1);
				break;
			case 5: 
					colors11.push_back(0);
					colors12.push_back(1);
					colors13.push_back(1);
				break;
			case 6: 
					colors11.push_back(0.5);
					colors12.push_back(0);
					colors13.push_back(0);
				break;
			case 7: 
					colors11.push_back(0);
					colors12.push_back(0.5);
					colors13.push_back(0);
				break;
			case 8: 
					colors11.push_back(0);
					colors12.push_back(0);
					colors13.push_back(0.5);
				break;
			case 9: 
					colors11.push_back(0.5);
					colors12.push_back(0.5);
					colors13.push_back(0);
				break;
			case 10: 
					colors11.push_back(0.5);
					colors12.push_back(0);
					colors13.push_back(0.5);
				break;
			case 11: 
					colors11.push_back(0);
					colors12.push_back(0.5);
					colors13.push_back(0.5);
				break;
			case 12: 
					colors11.push_back(0.5);
					colors12.push_back(1);
					colors13.push_back(1);
				break;
			case 13: 
					colors11.push_back(1);
					colors12.push_back(0.5);
					colors13.push_back(1);
				break;
			case 14: 
					colors11.push_back(1);
					colors12.push_back(1);
					colors13.push_back(0.5);
				break;
			case 15: 
					colors11.push_back(0.5);
					colors12.push_back(0.5);
					colors13.push_back(1);
				break;
			case 16: 
					colors11.push_back(0.5);
					colors12.push_back(1);
					colors13.push_back(0.5);
				break;
			case 17: 
					colors11.push_back(1);
					colors12.push_back(0.5);
					colors13.push_back(0.5);
				break;
			default:
					colors11.push_back(0);	//black
					colors12.push_back(0);
					colors13.push_back(0);
		}
  }
  for(int i=0; i<scores2.dim1(); i++){
    switch(scores2[i]){
			case -1: 
				colors21.push_back(1);
				colors22.push_back(1);
				colors23.push_back(1);
				break;
			case 0: 
				colors21.push_back(1);
				colors22.push_back(0);
				colors23.push_back(0);
				break;
			case 1: 
				colors21.push_back(0);
				colors22.push_back(1);
				colors23.push_back(0);
				break;
			case 2: 
				colors21.push_back(0);
				colors22.push_back(0);
				colors23.push_back(1);
				break;
			case 3: 
				colors21.push_back(1);
				colors22.push_back(1);
				colors23.push_back(0);
				break;
			case 4: 
				colors21.push_back(1);
				colors22.push_back(0);
				colors23.push_back(1);
				break;
			case 5: 
				colors21.push_back(0);
				colors22.push_back(1);
				colors23.push_back(1);
				break;
			case 6: 
				colors21.push_back(0.5);
				colors22.push_back(0);
				colors23.push_back(0);
				break;
			case 7: 
				colors21.push_back(0);
				colors22.push_back(0.5);
				colors23.push_back(0);
				break;
			case 8: 
				colors21.push_back(0);
				colors22.push_back(0);
				colors23.push_back(0.5);
				break;
			case 9: 
				colors21.push_back(0.5);
				colors22.push_back(0.5);
				colors23.push_back(0);
				break;
			case 10: 
				colors21.push_back(0.5);
				colors22.push_back(0);
				colors23.push_back(0.5);
				break;
			case 11: 
				colors21.push_back(0);
				colors22.push_back(0.5);
				colors23.push_back(0.5);
				break;
			case 12: 
				colors21.push_back(0.5);
				colors22.push_back(1);
				colors23.push_back(1);
				break;
			case 13: 
				colors21.push_back(1);
				colors22.push_back(0.5);
				colors23.push_back(1);
				break;
			case 14: 
				colors21.push_back(1);
				colors22.push_back(1);
				colors23.push_back(0.5);
				break;
			case 15: 
				colors21.push_back(0.5);
				colors22.push_back(0.5);
				colors23.push_back(1);
				break;
			case 16: 
				colors21.push_back(0.5);
				colors22.push_back(1);
				colors23.push_back(0.5);
				break;
			case 17: 
				colors21.push_back(1);
				colors22.push_back(0.5);
				colors23.push_back(0.5);
				break;
			default:
				colors21.push_back(0);	//black
				colors22.push_back(0);
				colors23.push_back(0);
		}
		
  }
  
  outfile.open(file.c_str());
  if(outfile.is_open()){
    outfile << "# ProSMART Colour File" << endl;
		for(unsigned int i=0; i<info.size(); i++){
			outfile << info[i] << endl;
		}
		outfile << "color white, (" << obj1 << "//" << domain1 << "/*/*)" << endl;
		for(int i=0; i<scores1.dim1(); i++){
			if(colors11[i]==1 && colors12[i]==1 && colors13[i]==1){
				continue;		//already coloured white!
			}
			outfile << "set_color newcolor" << i << " = [" << colors11[i] << "," << colors12[i] << "," << colors13[i] << "]; color newcolor" << i << ", (" << obj1 << "//" << domain1 << "/" << original_res1[All_Res1[i]].res;
			if(original_res1[All_Res1[i]].ins != ' '){
				outfile << original_res1[All_Res1[i]].ins; 
			}
			outfile << "/*)" << endl;
		}
		outfile << "color white, (" << obj2 << "//" << domain2 << "/*/*)" << endl;
		for(int i=0; i<scores2.dim1(); i++){
			if(colors21[i]==1 && colors22[i]==1 && colors23[i]==1){
				continue;		//already coloured white!
			}
			outfile << "set_color newcolorA" << i << " = [" << colors21[i] << "," << colors22[i] << "," << colors23[i] << "]; color newcolorA" << i << ", (" << obj2 << "//" << domain2 << "/" << original_res2[All_Res2[i]].res;
			if(original_res2[All_Res2[i]].ins != ' '){
				outfile << original_res2[All_Res2[i]].ins;
			}
			outfile << "/*)" << endl;
		}
    outfile.close();
		cout << endl << "Colour script written to: " << file;
  } else {
    cout << "Unable to open output file " << file << " for writing" << endl;
  }
   
   //write chimera colour script
   string chimera_file = get_folder(file) + "Chimera/" + get_filename(file) + ".com";
   outfile.open(chimera_file.c_str());
   if(outfile.is_open()){
      outfile << "# ProSMART Colour File - Chimera Command Script\n";
      outfile << "color white prosmart1; color white prosmart2; ";
      for(int i=0; i<scores1.dim1(); i++){
         if(colors11[i]==1 && colors12[i]==1 && colors13[i]==1){
				continue;		//already coloured white!
			}
         outfile << "select prosmart1 & :" << original_res1[All_Res1[i]].res;
         if(original_res1[All_Res1[i]].ins != ' '){
				outfile << original_res1[All_Res1[i]].ins; 
			}
			outfile << "; color " << colors11[i] << "," << colors12[i] << "," << colors13[i] << " sel; ";
		}
      for(int i=0; i<scores2.dim1(); i++){
         if(colors21[i]==1 && colors22[i]==1 && colors23[i]==1){
				continue;		//already coloured white!
			}
         outfile << "select prosmart2 & :" << original_res2[All_Res2[i]].res;
         if(original_res2[All_Res2[i]].ins != ' '){
				outfile << original_res2[All_Res2[i]].ins; 
			}
         outfile << "; color " << colors21[i] << "," << colors22[i] << "," << colors23[i] << " sel; ";
		}
      outfile << "~select";
      outfile.close();
		cout << endl << "Colour script written to: " << chimera_file;
   } else {
      cout << "Unable to open output file " << chimera_file << " for writing" << endl;
   }
  
  return;
}

void write_pymol_cluster_score(vector<string> &info, vector<residue_alignment> &Res_align, vector<double> &res_scores, Residues &res1, Residues &res2, string obj1_, string obj2_, string file, char domain1, char domain2, vector<res_corresp> &original_res1, vector<res_corresp> &original_res2, int &cluster_no)
{
    ofstream outfile;
	string obj1 = obj1_ + "*";
	string obj2 = obj2_ + "*";			//this means that all files starting with obj2 will be coloured (i.e. original and all clusters)
	
    vector<int> All_Res1 = res1.get_res();		//stores the residue numbers for all residues.
    vector<int> All_Res2 = res2.get_res();
    Array1D<double> scores1(All_Res1.size(),-1);		//will store the scores corresponding to the residues
    Array1D<double> scores2(All_Res2.size(),-1);		//if a residue is unaligned then it scores -1
    unsigned int N = Res_align.size();

	int idx = 0;
    for(unsigned int i=0; i<N; i++){
        if(All_Res1[idx]==Res_align[i].res1){
            scores1[idx] = res_scores[i];
            if(scores1[idx]>1.0){
                scores1[idx] = 1.0;
            }
        } else {
            i--;
        }
        idx++;
    }
    idx = 0;
    for(unsigned int i=0; i<N; i++){
        if(All_Res2[idx]==Res_align[i].res2){
            scores2[idx] = res_scores[i];
            if(scores2[idx]>1.0){
                scores2[idx] = 1.0;
            }
        } else {
            i--;
        }
        idx++;
    }
	
	double color1;
    double color2;
    double color3;
	switch(cluster_no){
		case -1: 
			color1 = 1;
			color2 = 1;
			color3 = 1;
			break;
		case 0: 
			color1 = 1;
			color2 = 0;
			color3 = 0;
			break;
		case 1: 
			color1 = 0;
			color2 = 1;
			color3 = 0;
			break;
		case 2: 
			color1 = 0;
			color2 = 0;
			color3 = 1;
			break;
		case 3: 
			color1 = 1;
			color2 = 1;
			color3 = 0;
			break;
		case 4: 
			color1 = 1;
			color2 = 0;
			color3 = 1;
			break;
		case 5: 
			color1 = 0;
			color2 = 1;
			color3 = 1;
			break;
		case 6: 
			color1 = 0.5;
			color2 = 0;
			color3 = 0;
			break;
		case 7: 
			color1 = 0;
			color2 = 0.5;
			color3 = 0;
			break;
		case 8: 
			color1 = 0;
			color2 = 0;
			color3 = 0.5;
			break;
		case 9: 
			color1 = 0.5;
			color2 = 0.5;
			color3 = 0;
			break;
		case 10: 
			color1 = 0.5;
			color2 = 0;
			color3 = 0.5;
			break;
		case 11: 
			color1 = 0;
			color2 = 0.5;
			color3 = 0.5;
			break;
		case 12: 
			color1 = 0.5;
			color2 = 1;
			color3 = 1;
			break;
		case 13: 
			color1 = 1;
			color2 = 0.5;
			color3 = 1;
			break;
		case 14: 
			color1 = 1;
			color2 = 1;
			color3 = 0.5;
			break;
		case 15: 
			color1 = 0.5;
			color2 = 0.5;
			color3 = 1;
			break;
		case 16: 
			color1 = 0.5;
			color2 = 1;
			color3 = 0.5;
			break;
		case 17: 
			color1 = 1;
			color2 = 0.5;
			color3 = 0.5;
			break;
		default:
			color1 = 0;	//black
			color2 = 0;
			color3 = 0;
	}
    
    outfile.open(file.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Colour File - PyMOL Script" << endl;
		outfile << "color white, (" << obj1 << "//" << domain1 << "/*/*)" << endl;
		outfile << "color white, (" << obj2 << "//" << domain2 << "/*/*)" << endl;
        double val = 0.0;
        double ival = 0.0;
        int NO_COL = 100;   //this will actually cause NO_COL+1 colours to be created...
        for(int i=0; i<=NO_COL; i++){
            val = ((double)i/NO_COL);
            ival = 1.0 - val;
            double color1_tmp = val + color1*ival;
            double color2_tmp = val + color2*ival;
            double color3_tmp = val + color3*ival;
            outfile << "set_color newcolor" << i << " = [" << color1_tmp << "," << color2_tmp << "," << color3_tmp << "]" << endl;
        }
      
        int index = -1;
        for(int i=0; i<scores1.dim1(); i++){
            val = (double)NO_COL*scores1[i];
            if(val >= 0.0 && val<(double)NO_COL){
                index = floor(val);
                outfile << "color newcolor" << index << ", (" << obj1 << "//" << domain1 << "/";
                if(int_to_str(original_res1[All_Res1[i]].res)[0]=='-'){
                    outfile << "\\";
                }
                outfile << original_res1[All_Res1[i]].res;
                if(original_res1[All_Res1[i]].ins != ' '){
                    outfile << original_res1[All_Res1[i]].ins; 
                }
                outfile << "/*)" << endl;
            }
        }
        for(int i=0; i<scores2.dim1(); i++){
            val = (double)NO_COL*scores2[i];
            if(val >= 0.0 && val<(double)NO_COL){
                index = floor(val);
                outfile << "color newcolor" << index << ", (" << obj2 << "//" << domain2 << "/";
                if(int_to_str(original_res2[All_Res2[i]].res)[0]=='-'){
                    outfile << "\\";
                }
                outfile << original_res2[All_Res2[i]].res;
                if(original_res2[All_Res2[i]].ins != ' '){
                    outfile << original_res2[All_Res2[i]].ins; 
                }
                outfile << "/*)" << endl;
            }
        }
        outfile.close();
		cout << endl << "Colour script written to: " << file;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }
   
   //write chimera colour script
   string chimera_file = get_folder(file) + "Chimera/" + get_filename(file) + ".com";
   outfile.open(chimera_file.c_str());
   if(outfile.is_open()){
      outfile << "# ProSMART Colour File - Chimera Command Script\n";
      outfile << "color white prosmart1; color white prosmart2; ";
      double ival = 0.0;
      double color1_tmp = 0.0;
      double color2_tmp = 0.0;
      double color3_tmp = 0.0;
      for(int i=0; i<scores1.dim1(); i++){
         if(scores1[i]>=0.0 && scores1[i]<1.0){
            ival = 1.0 - scores1[i];
            color1_tmp = scores1[i] + color1*ival;
            color2_tmp = scores1[i] + color2*ival;
            color3_tmp = scores1[i] + color3*ival;
            outfile << "select prosmart1 & :" << original_res1[All_Res1[i]].res;
            if(original_res1[All_Res1[i]].ins != ' '){
               outfile << original_res1[All_Res1[i]].ins;
            }
            outfile << "; color " << color1_tmp << "," << color2_tmp << "," << color3_tmp << " sel; ";
         }
		}
      for(int i=0; i<scores2.dim1(); i++){
         if(scores2[i]>=0.0 && scores2[i]<1.0){
            ival = 1.0 - scores2[i];
            color1_tmp = scores2[i] + color1*ival;
            color2_tmp = scores2[i] + color2*ival;
            color3_tmp = scores2[i] + color3*ival;
            outfile << "select prosmart2 & :" << original_res2[All_Res2[i]].res;
            if(original_res2[All_Res2[i]].ins != ' '){
               outfile << original_res2[All_Res2[i]].ins;
            }
            outfile << "; color " << color1_tmp << "," << color2_tmp << "," << color3_tmp << " sel; ";
         }
		}
      outfile << "~select";
      outfile.close();
		cout << endl << "Colour script written to: " << chimera_file;
   } else {
      cout << "Unable to open output file " << chimera_file << " for writing" << endl;
   }
  
    return;
}

void fileoutput_translate(Array2D<double> &matrix1, string fileout)
{
    ofstream outfile;
	int N = matrix1.dim1();
	int M = matrix1.dim2();
    
    outfile.open(fileout.c_str(),ios::trunc);
    if(outfile.is_open()){
        for(int i=0; i<N; i++){
            for(int j=0; j<M; j++){
                if(j==i){
                    outfile << "0 ";
                } else {
                    outfile << matrix1[i][j] << " ";
                }
            }
            outfile << endl;
        }
		cout << "2D array written to: " << fileout << endl;
    }
    
    outfile.close();
    return;
}

void fileoutput_costheta(Array2D<double> &matrix1, string fileout)
{
  ofstream outfile;
	int N = matrix1.dim1();
	int M = matrix1.dim2();

  outfile.open(fileout.c_str(),ios::trunc);
  if(outfile.is_open()){
			for(int i=0; i<N; i++){
				for(int j=0; j<M; j++){
					if(j==i){
						outfile << "0 ";
					} else {
						outfile << 1-matrix1[i][j] << " ";
					}
				}
				outfile << endl;
			}
		cout << "2D array written to: " << fileout << endl;
  }
		
  outfile.close();
  return;
}

void fileoutput_costheta(Array2D<double> &matrix1, vector<vector<int> > &clusters, string fileout)
{
  ofstream outfile;
	
	vector<int> all_clusters;
	for(unsigned int i=0; i<clusters.size(); i++){
		for(unsigned int j=0; j<clusters[i].size(); j++){
			all_clusters.push_back(clusters[i][j]);
		}
	}
	int N = all_clusters.size();
  
  outfile.open(fileout.c_str(),ios::trunc);
  if(outfile.is_open()){
			for(int i=0; i<N; i++){
				for(int j=0; j<N; j++){
					if(j==i){
						outfile << "0 ";
					} else {
						outfile << 1-matrix1[all_clusters[i]][all_clusters[j]] << " ";
					}
				}
				outfile << endl;
			}
		cout << "2D array written to: " << fileout << endl;
  }
	
  outfile.close();
  return;
}



