//
// This file is part of ProSMART.
//

#ifndef align_cluster_H
#define align_cluster_H

#include "alignClass_Frag.h"
#include "align_output_filehandling.h"

int rigid_substructure_identification(Align &, vector<double> &, Array2D<double> &, Frag &, Frag &, Residues &, Residues &, string &, string &, string &, unsigned short &, unsigned short &, double &, double &, double &, unsigned int &, double &, vector<Transform> &, vector<vector<residue_alignment> > &, vector<Align> &, vector<vector<double> > &, vector<vector<double> > &, bool, vector<double> &,bool, double&, double&);

Align clustering_filter(Align &, vector<double> &, double, Array2D<double> &, double);
void filter_clusters(vector<vector<int> > &, vector<vector<double> > &, double);

void get_translation_matrix(Array2D<double> &, vector<coord> &, vector<coord> &);
void get_rotation_matrix(Array2D<double> &, vector<Array2D<double> > &);
void get_costheta_clusters(vector<vector<double> > &, vector<Array2D<double> > &, vector<Array2D<double> > &, vector<vector<int> > &);
void get_costheta_clusters(vector<vector<double> > &, vector<quarternion> &, vector<quarternion> &, vector<vector<int> > &);
//void get_translation_vectors(vector<vector<double> > &, vector<vector<Transform> > &, vector<coord> &, vector<coord> &, vector<vector<int> > &);
void get_rotation_vectors(vector<vector<double> > &, vector<Transform> &, vector<Array2D<double> > &, vector<vector<int> > &);
//void get_all_translation_vectors(vector<vector<double> > &, vector<vector<Transform> > &, vector<coord> &, vector<coord> &);
void get_all_translation_vectors(vector<vector<double> > &, vector<Transform> &, Coords &, Coords &);
void get_all_rotation_vectors(vector<vector<double> > &, vector<Transform> &, vector<Array2D<double> > &);
void get_cluster_rotations(Array2D<double> &, vector<Transform> &);

vector<vector<int> > single_linkage_clusters(Array2D<double> &, double &, Array2D<double> &, double &, double &, unsigned short &);
void add_to_cluster(Array2D<double> &, Array2D<double> &, vector<int> &, int &, double &, double &, double &, int &);

vector<Align> get_align_clusters(vector<vector<int> > &, Align &);
void get_res_cluster(Align &, Frag &, Frag &, Array2D<double> &, vector<residue_alignment> &, double, Residues &, Residues &, vector<double> &, vector<vector<double> > &);
vector<residue_alignment> get_central_res_cluster(Align &, Frag &, Frag &, int);
vector<residue_alignment> get_frag_res_cluster(Align &, Frag &, Frag &, unsigned short);
vector<residue_alignment> get_all_res_cluster(Align &, Frag &, Frag &, unsigned short);

void write_pymol_cluster(vector<string> &, vector<vector<residue_alignment> > &, Residues &, Residues &, string, string, string, char, char, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_cluster_score(vector<string> &, vector<residue_alignment> &, vector<double> &, Residues &, Residues &, string, string, string, char, char, vector<res_corresp> &, vector<res_corresp> &, int &);

void fileoutput_translate(Array2D<double> &, string);
void fileoutput_costheta(Array2D<double> &, string);
void fileoutput_costheta(Array2D<double> &, vector<vector<int> > &, string);

//void write_cluster_alignment(Residues &, Residues &, vector<string> &, vector<residue_alignment> &, string, vector<res_corresp> &, vector<res_corresp> &);
void write_cluster_alignment(vector<residue_alignment> &, vector<res_corresp> &, vector<res_corresp> &, vector<vector<double> > &, string &, double &, bool);

#endif
