//
// ProSMART - Procrustes Structural Matching Alignment and Restraints Tool
//
// Copyright (C) 2011-2014 Robert Nicholls and Garib Murshudov
//
//
// This file is part of ProSMART.
//
// ProSMART is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// ProSMART is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with ProSMART. If not, see <http://www.gnu.org/licenses/>.

#include "prosmart_results.h"
#include "prosmart_multiple_superposition.h"
#include "prosmartClass_Restraints.h"
#include "prosmart_params.h"
//#include <sys/sysctl.h>

int main(int argc, char *argv[])
{
	/*int mib[2];
     size_t len;
     int maxproc = 1;
     mib[0] = CTL_HW;
     mib[1] = HW_NCPU;
     len = sizeof(maxproc);
     if (sysctl(mib, 2, &maxproc, &len, NULL, 0)) {
     perror("could not determine number of cpus available");
     }
     cout << endl << endl << "No of cores: " << maxproc << endl << endl;
     return 0;*/
	
	vector<string> args;
	bool VALID;
	ofstream outfile;
    vector<pid_t> pIDs;
    int status=0;
	
	params PARAMS;
	set_params(PARAMS);
	print_header();
	initialise_reflectM();	//set up global variable, which stores 3x3 reflection matrix
    
#ifdef PERFORMANCE
	double t1 = get_time_sec();
#endif
    
	args = get_args(argv,argc,PARAMS);
	if(args.size()==0){return 0;}

	read_args(args,PARAMS);

   if(USE_DNARNA){
      PARAMS.ALIGN_SCORE=d_to_str(str_to_double(PARAMS.ALIGN_SCORE)*2.0);
      PARAMS.SIDE_SCORE=d_to_str(str_to_double(PARAMS.SIDE_SCORE)*2.0);
   }
   
    param_validation(args,PARAMS);

#ifndef WINDOWS
    //special mode - perform all-on-all sequence alignment
   if(PARAMS.SEQUENCE_ALIGNMENT){
        return sequence_alignment(PARAMS.filenames1,PARAMS.chains1,PARAMS.MAX_THREADS,PARAMS.SEQ_MIN,PARAMS.SEQ_RATIO,PARAMS.SEQ_ID,PARAMS.SEQ_ID_MAX);
   }
#endif
   
	//rename chain if requested.
    if(PARAMS.filenames1.size()>0){
        if(PARAMS.new_chain != " "){
			rename_chain(PARAMS.error_file, PARAMS.filenames1[0],PARAMS.new_chain);
			xml_entry(PARAMS.error_file,2,0,PARAMS.filenames1[0]);
			xml_entry(PARAMS.error_file,3,0);
			cout << endl << "ProSMART completed." << endl << endl;
			return 0;
		}
    }
	
	//initialise colours
	coord col1;
	coord col2;
	col1.x = 255*atof(PARAMS.G1.c_str());	//HTML requires rgb to be specified on [0,255]
	col1.y = 255*atof(PARAMS.G2.c_str());
	col1.z = 255*atof(PARAMS.G3.c_str());
	col2.x = 255*atof(PARAMS.R1.c_str());
	col2.y = 255*atof(PARAMS.R2.c_str());
	col2.z = 255*atof(PARAMS.R3.c_str());
	global_score_coloring(col1,col2);	//this is needed, to initialise colors for use in HTML page for multiple global scores
	    
	//sort out directory structure
	//note: PARAMS.output_dir has already been created in prosmart_params.cpp
	string workingdirectory = make_subdirectory(PARAMS.error_file,PARAMS.output_dir,"Output_Files");
    PARAMS.WORKING_DIRECTORY = format_wd(workingdirectory);
	string Results_dir = make_subdirectory(PARAMS.error_file,workingdirectory,".HTML_files");
	string tmp_dir = make_subdirectory(PARAMS.error_file,Results_dir,"tmp");
    PARAMS.ALIGN_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Residue_Alignment_Scores");
	string resnum_filename = make_subdirectory(PARAMS.error_file,workingdirectory,"Global_Statistics");
	string SINGLE_dir = make_subdirectory(PARAMS.error_file,resnum_filename,"Single");
    string MULTI_dir = make_subdirectory(PARAMS.error_file,resnum_filename,"Multiple");
    output_stylesheet(PARAMS.error_file,MULTI_dir);
	if(PARAMS.OUT_COLOR=="1"){
		PARAMS.PYMOL_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Colour_Scripts");
		tmp_dir = make_subdirectory(PARAMS.error_file,tmp_dir,"Colour");
	}
    string LOADER_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Loader_Scripts");
   string CHIMERA_dir = make_subdirectory(PARAMS.error_file,LOADER_dir,"Chimera");
   string PYMOL_LOADER_dir = make_subdirectory(PARAMS.error_file,LOADER_dir,"PyMOL");
    string SUPER_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Superposition");
	PARAMS.TRANS_dir = make_subdirectory(PARAMS.error_file,SUPER_dir,"Transformations");
	if(PARAMS.OUT_PDB=="1"){
		PARAMS.PDB_dir = make_subdirectory(PARAMS.error_file,SUPER_dir,"PDB_files");
	}
    string SEQ_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Sequence");
    string RES_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Restraints");
    if(PARAMS.OUTPUT_PDB_CHAIN_RESTRAINTS){
        tmp_dir = make_subdirectory(PARAMS.error_file,RES_dir,"PDB_Chain");
    }
	RES_dir = make_subdirectory(PARAMS.error_file,RES_dir,"Chain_Chain");
	string NMR_dir;
	if(PARAMS.NMR == 1){
		NMR_dir = make_subdirectory(PARAMS.error_file,workingdirectory,"Input_PDB");
	}
	PARAMS.INPUTCHAINS_dir = make_subdirectory(PARAMS.error_file,workingdirectory,".Input_Chains");

	// interpret NMR files
    if(PARAMS.NMR == 1){
        if(PARAMS.filenames1.size()!=1){
			xml_entry(PARAMS.error_file,0,2);
            cout << endl << "Error - only one input -p1 PDB file may be given when using -nmr. Program terminated." << endl;
			return 0;
		} else {
			PARAMS.filenames2.clear();
			PARAMS.chains2.clear();
            PARAMS.filenames2 = rename_nmr(PARAMS.error_file,PARAMS.filenames1[0],NMR_dir);	//put all nmr models in PARAMS.filenames2
			PARAMS.filenames1.clear();
			if(PARAMS.filenames2.size()>0){								//if successful 
				PARAMS.filenames1.push_back(PARAMS.filenames2[PARAMS.NMR_TARGET-1]);		//get target model
				PARAMS.filenames2.erase(PARAMS.filenames2.begin()+PARAMS.NMR_TARGET-1);	//remove target model from list of secondaries
			}
		}
    }
    
    ////////////////////////////////////////////////

    set_hbond_parameters(PARAMS);

	////////////////////////////////////////////////

	VALID = get_binaries(PARAMS);
    if(!VALID)return 0;

	VALID = get_filenames(PARAMS);          //this includes removing spaces from filenames
    if(!VALID)return 0;

    if(PARAMS.MERGE_CHAINS){
        if(PARAMS.HELIX=="1"){
            cout << endl << "Warning - chains will not be merged, due to the use of the fragment library." << endl;
            PARAMS.MERGE_CHAINS = 0;
        } else {
            VALID = combine_chains(PARAMS);
            if(!VALID)return 0;
            //PARAMS.OUT_PDB_FULL = "1";        // otherwise no chains would be present in the output PDBs, since there is no chain X.
            if(PARAMS.RESTRAIN){
                cout << endl << "Warning - ProSMART RESTRAIN will not be executed, due to use of the '-merge' keyword." << endl;
                PARAMS.RESTRAIN = 0;    // ProSMART RESTRAIN not supported for merged chains (chainID not accounted for in residue score files; residue renumbering would lead to non-sensical restraints)
            }
        }
    }
    
    if(!PARAMS.ALIGN && !PARAMS.RESTRAIN){
        cout << endl << "Neither ProSMART ALIGN nor ProSMART RESTRAIN are to be executed." << endl;
        cout << "Nothing to do... program terminated." << endl << endl;
        return 0;
    }
    
	VALID = param_validation2(PARAMS);      //this includes outputting formatted chain files
    if(!VALID)return 0;
   
   if(ONLY_OUTPUT_SEQUENCE_FILES){
      cout << "Sequence files created. ProSMART completed." << endl << endl;
      return 0;
   }
    
    //VALID = check_for_replication(PARAMS);return 0;
    //if(!VALID)return 0;
    
	////////////////////////////////////////////////
	
    //Create Subdirectories based on filenames
	string sub_dir;
	string tmp;
	string tmp2;
	for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
		tmp = get_filename(PARAMS.filenames1[i])+"_"+PARAMS.chains1[i];
		sub_dir = make_subdirectory(PARAMS.error_file,PARAMS.ALIGN_dir,tmp);
		sub_dir = make_subdirectory(PARAMS.error_file,PARAMS.TRANS_dir,tmp);
		for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
			if(PARAMS.HELIX=="0" || PARAMS.HBOND_RESTRAINTS){
                if(PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET){
                    if(i!=j)continue;
                } else if(PARAMS.ALL_ON_ALL==1){
					if(PARAMS.TRIANGULAR==1){
						if(i>=j){
							continue;
						}
					}
					if(i==j){
						continue;
					}
				}
				tmp2 = tmp+"_"+get_filename(PARAMS.filenames2[j])+"_"+PARAMS.chains2[j];
				if(PARAMS.OUT_PDB=="1"){
					sub_dir = make_subdirectory(PARAMS.error_file,PARAMS.PDB_dir,tmp2);
				}
				if(PARAMS.OUT_COLOR=="1"){
					sub_dir = make_subdirectory(PARAMS.error_file,PARAMS.PYMOL_dir,tmp2);
					sub_dir = make_subdirectory(PARAMS.error_file,sub_dir,"Chimera");
				}
			}
		}
	}
    
    ////////////////////////////////////////////////
    
	//Display parameters
	print_parameters(PARAMS, PARAMS.output_dir);

	//Write HTML results files, in case error occurs.
	string fileout_results = PARAMS.output_dir + "ProSMART_Results.html";
	write_html_message(PARAMS.error_file,Results_dir,0);	//also refreshes logfiles
	write_html_parameters(Results_dir+"parameters.html", PARAMS, PARAMS.output_dir);
	write_html(PARAMS.error_file,fileout_results,0,"0","0","0", PARAMS.ALIGN, PARAMS.RESTRAIN, 0, 0, 0, 0, "Output_Files/.HTML_files/", PARAMS.output_dir);
    
    ////////////////////////////////////////////////
    //Generate bonds etc using refmac5
    
    string bonds_filename;
    bool bonds_exists;
    
    if(PARAMS.RESTRAIN == 1){
        //generate bonds
        if(PARAMS.GET_BONDS == "1" && PARAMS.MAINCHAIN_ONLY == "0"){
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                //check that PARAMS.filenames1[i] has not already been considered (sometimes PARAMS.filenames1[0]==PARAMS.filenames1[1], etc.)
                bonds_filename = PARAMS.filenames1[i];
                bonds_exists = 0;
                for(unsigned int j=0; j<i; j++){
                    if(bonds_filename == PARAMS.filenames1[j]){
                        bonds_exists = 1;
                        break;
                    }
                }
                
                //if this is a new pdb file to consider...
                if(bonds_exists == 0){
                    bonds_filename = workingdirectory+get_filename(PARAMS.filenames1[i])+"_bonds.txt";
					bonds_exists = check_file(bonds_filename);	//check whether valid bonds file exists
					//attempt to create bonds
					if(bonds_exists==0){
                        string refmac_logfile = PARAMS.output_dir + "refmac5_logfile.html";
                        get_bonds(PARAMS.error_file,bonds_filename,PARAMS.filenames1[i],pIDs,PARAMS.MAX_THREADS,PARAMS.REFMAC_NAME,refmac_logfile);   
					}
				}
			}
		}
    }

	////////////////////////////////////////////////
    //Run prosmart align
    
	bool ALIGN_MULTI = 0;
    int temp=0;
    vector<pid_t> newpIDs;
    
    string temp_string = workingdirectory + "outfile";
    string fileout = workingdirectory + "align_script";
    string temp_fileout;
	string tempstr;
	string RANGE1;
    vector<vector<string> > logfiles;
    string tmpstr;
    
    stringstream temp_stringstream;
    
    vector<string> args1;
    vector<string> args2;
    vector<string> args3;
    vector<string> sys_string;
    vector<string> message;
    
    vector<vector<double> > align_scores;
    
    if(PARAMS.ALIGN == 1){
		args1.clear();
		args2.clear();
		temp = 0;
		
		RANGE1 = "";
		for(unsigned int i=0; i<PARAMS.RANGE1A.size(); i++){
			if(PARAMS.PDB1A[i].size()==0 || PARAMS.PDB1A[i]==PARAMS.filenames1[0]){
				if(PARAMS.CHAIN1A[i].size()==0 || PARAMS.CHAIN1A[i]==PARAMS.chains1[0]){
					if(PARAMS.PDB1B[i].size()==0 || PARAMS.PDB1B[i]==PARAMS.filenames1[1]){
						if(PARAMS.CHAIN1B[i].size()==0 || PARAMS.CHAIN1B[i]==PARAMS.chains1[1]){
							RANGE1 += PARAMS.RANGE1A[i] + "_" + PARAMS.RANGE1B[i]+"_";
						}
					}
				}
			}
		}
		if(RANGE1==""){RANGE1 = "-";}
		
		//create program launch vector, to be put in file to source.
		args1.push_back(PARAMS.align_location);
		args1.push_back("");                            //File 1
		args1.push_back("");                            //File 2
		args1.push_back("");                            //Chain identifier from file 1. Must be of length 1.
		args1.push_back("");                            //Chain identifier from file 2. Must be of length 1.
        args1.push_back(PARAMS.WORKING_DIRECTORY);
		args1.push_back(PARAMS.FRAG_LEN);				//Fragment length, in residues.
		args1.push_back(PARAMS.CLUSTER_DEGREES);
		args1.push_back("0");                           //Fragment alignment distance cutoff
		args1.push_back(PARAMS.CLUSTER);				//indicates whether or not to perform clustering.
		args1.push_back(PARAMS.LIB_DIR);
		args1.push_back(PARAMS.ALIGN_SCORE);			//score that defines similar residues.
		args1.push_back(PARAMS.ALIGN_MODE);				//use ca's or all mainchain atoms.
		args1.push_back(PARAMS.EXTRA_REFINEMENT);		//specifies whether to refine alignment to achieve better-scoring alignment.
		args1.push_back(PARAMS.SIDE_SCORE);
		args1.push_back(PARAMS.HELIX);
		args1.push_back(PARAMS.IDENTICAL);
		args1.push_back(PARAMS.HELIX_CUTOFF);
		args1.push_back(PARAMS.HELIX_PENALTY);
		args1.push_back(PARAMS.CLUSTER_MIN);
		args1.push_back(PARAMS.CLUSTER_LINKAGE);
		args1.push_back(PARAMS.CLUSTER_RIGIDITY);
		args1.push_back(PARAMS.CLUSTER_COLOR);
		args1.push_back(PARAMS.G1);
		args1.push_back(PARAMS.G2);
		args1.push_back(PARAMS.G3);
		args1.push_back(PARAMS.R1);
		args1.push_back(PARAMS.R2);
		args1.push_back(PARAMS.R3);
		args1.push_back(PARAMS.OUT_PDB);
		args1.push_back(PARAMS.OUT_COLOR);
		args1.push_back(PARAMS.SUPERPOSE);
		args1.push_back(PARAMS.CLUSTER_SCORE);
		args1.push_back(PARAMS.OUTPUT_CLUSTER_DM);
		args1.push_back(RANGE1);
        args1.push_back(PARAMS.SCORE_THRESHOLD);
        args1.push_back(PARAMS.DISPLAY_AS_COSINE_DISTANCE);
        args1.push_back(PARAMS.OUT_PDB_FULL);
        args1.push_back(PARAMS.USE_MAINCHAIN_FOR_SIDERMSD);
        args1.push_back(PARAMS.NUM_DIST_THRESHOLD);
        args1.push_back("0");   //do not search for internal replication
        args1.push_back(PARAMS.FIX_SIDE_CHAIN_ERRORS);
        args1.push_back(PARAMS.NO_REWARD_SEQ);
        args1.push_back(PARAMS.REWARD_SEQ);
       args1.push_back(int_to_str(USE_DNARNA));
       args1.push_back(PARAMS.SCORE_STRICT);
       args1.push_back(PARAMS.SUPERPOSE_SIDE);
       args1.push_back(PARAMS.OUTPUT_RMSD_FILES);
       args1.push_back(int_to_str(USE_SIEVE));
       args1.push_back(d_to_str(SIEVE_PARAMETER));
       args1.push_back(PARAMS.OUTPUT_SCREW);
       args1.push_back(PARAMS.CLUSTER_TRANS_LINKAGE);
       args1.push_back(PARAMS.CLUSTER_TRANS_MAX);
		args1.push_back("");
        
		for(unsigned int i=0; i<PARAMS.chains1.size(); i++){
            for(unsigned int j=0; j<PARAMS.chains2.size(); j++){
                if(PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET){
                    if(i!=j)continue;
                } else if(PARAMS.ALL_ON_ALL==1){
					if(PARAMS.TRIANGULAR==1){
						if(i>=j)continue;		//don't align chains to themselves
					}
					if(i==j)continue;			//don't align chains to themselves
				}
                args1[1] = "\"" + PARAMS.filenames1[i] + "\"";
				args1[2] = "\"" + PARAMS.filenames2[j] + "\"";
				args1[3] = PARAMS.chains1[i];
				args1[4] = PARAMS.chains2[j];
				if(PARAMS.HELIX=="1"){
					args1[6] = PARAMS.lib_fraglen[j];
					args1[11] = PARAMS.lib_score[j];
				}
                temp++;
				temp_stringstream.str("");
				temp_stringstream << temp_string << temp;
                args1[args1.size()-1] = "> \""+temp_stringstream.str()+"\"";

                message.push_back("Aligning " + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + " to " + get_filename(PARAMS.filenames2[j]) + "_" + PARAMS.chains2[j]);
                args2.push_back("\""+temp_stringstream.str()+"\"");    //ready for concatenating logfiles
                args3.push_back(temp_stringstream.str());              //ready for deleting logfiles
                sys_string.push_back(vector_to_string(args1));
            }
		}
        //if too many bonds are being generated, wait for bonds to be generated before running ProSMART ALIGN.
        while((int)pIDs.size() >= PARAMS.MAX_THREADS)wait(&status);     //wait for any child process to terminate
        
		xml_entry(PARAMS.error_file,2,1);
		cout << endl << "ProSMART ALIGN launched:  " << get_time() << endl << endl;
        spawn_external(PARAMS.error_file,sys_string,message,pIDs,newpIDs,PARAMS.MAX_THREADS);	//launch prosmart align, and wait for all instances to terminate before continuing.

        //concatenate log files and delete originals
        for(unsigned int i=0; i<args3.size(); i++)logfiles.push_back(read_file_line_string(args3[i]));
        tmpstr = PARAMS.output_dir + "prosmart_align_logfile.txt";
        write_to_file(tmpstr,logfiles);
        for(unsigned int i=0; i<args3.size(); i++)unlink(args3[i].c_str());       
        
        //output multiple score files
        if(PARAMS.HELIX == "0"){
            if(PARAMS.ALL_ON_ALL == 0 || (PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET)){
                if(PARAMS.chains1.size()>1 || PARAMS.chains2.size()>1){
                    ALIGN_MULTI = 1;
                    if(PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET){
                        align_scores = write_scores(PARAMS.error_file, PARAMS.filenames1, PARAMS.filenames2, PARAMS.chains1, PARAMS.chains2, SINGLE_dir, MULTI_dir,1);
                    } else {
                        align_scores = write_scores(PARAMS.error_file, PARAMS.filenames1, PARAMS.filenames2, PARAMS.chains1, PARAMS.chains2, SINGLE_dir, MULTI_dir,0);
                    }
                }
            } else if(PARAMS.chains1.size()>2){
                ALIGN_MULTI = 1;
                if(PARAMS.TRIANGULAR == 1){
                    write_scores_triangular(PARAMS.error_file, PARAMS.filenames1, PARAMS.chains1, SINGLE_dir, MULTI_dir);
                } else {
                    write_scores_allonall(PARAMS.error_file, PARAMS.filenames1, PARAMS.chains1, SINGLE_dir, MULTI_dir);
                }
            }
        }

        xml_entry(PARAMS.error_file,2,2);
        cout << endl << "ProSMART ALIGN completed: " << get_time() << endl
        << "See " << PARAMS.output_dir << "prosmart_align_logfile.txt for details." << endl << endl;
        update_pIDs(pIDs);
        if(pIDs.size()>0){
            cout << "waiting for REFMAC5 to complete..." << endl;
        }
    } 
    for(unsigned int i=0; i<pIDs.size(); i++)waitpid(pIDs[i],&status,0); //wait for bonds to be generated.
    pIDs.clear();

    ////////////////////////////////////////////////
    //Validate alignment files (performed for both alignment and restraint generation)
    //Also generate average pymol color file if -id is specified
   
    string firstline = "# ProSMART Alignment File";
    string temp_filename;
    bool return_status;
    vector<vector<res_alignment> > align_v;
    Array2D<vector<res_alignment> > align_m(PARAMS.filenames1.size(),PARAMS.filenames2.size());
    Array2D<vector<vector<string> > > align_m_clust(PARAMS.filenames1.size(),PARAMS.filenames2.size());
#ifdef ANALYSE_PAIRWISE_RESULTS
    Array2D<vector<vector<string> > > align_atom_m(PARAMS.filenames1.size(),PARAMS.filenames2.size());
#endif
    vector<res_alignment> align_max;
    vector<vector<res_alignment> > align_types;
    vector<string> align_obj2;
    
    if(!PARAMS.GENERIC)
    for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
        string obj1tmp = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
        string tempstr = PARAMS.ALIGN_dir + obj1tmp + "/" + obj1tmp + "_";
        for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
            if(PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET){
                if(i!=j)continue;
            } else if(PARAMS.ALL_ON_ALL==1){
                if(PARAMS.TRIANGULAR==1){
                    if(i>=j){			//don't align chains to themselves
                        continue;
                    }
                }
                if(i==j){
                    continue;
                }
            }
            string obj2tmp = get_filename(PARAMS.filenames2[j])+"_"+PARAMS.chains2[j];
            temp_filename = tempstr+obj2tmp+".txt";
            return_status = validate_file(temp_filename,firstline);
            if(return_status == 1){
                if(PARAMS.ALIGN == 1){
                    xml_entry(PARAMS.error_file,0,7,temp_filename);
                    cout << "Error - alignment file: " << temp_filename << " was not created successfully. Program terminated." << endl;
                } else {
                    xml_entry(PARAMS.error_file,0,8,temp_filename);
                    cout << "Error - alignment file: " << temp_filename << " could not be found. Program terminated." << endl;
                }
                return 0;
            } else if(PARAMS.IDENTICAL=="1" || PARAMS.filenames1.size()==1){	//read alignment file
                align_v.push_back(file_read_alignment(temp_filename));
                align_obj2.push_back(obj2tmp);
            } else {    //create all-on-all max dissimilar output files
                align_m[i][j] = file_read_alignment(temp_filename);
                string temp_filename_clust = delete_ext(temp_filename)+"_clusters.txt";
                align_m_clust[i][j] = read_file_lines(temp_filename_clust);
#ifdef ANALYSE_PAIRWISE_RESULTS
                string temp_filename_rmsd = delete_ext(temp_filename)+"_rmsd.txt";
                align_atom_m[i][j] = read_file_lines(temp_filename_rmsd);
#endif
                //cout << endl << PARAMS.filenames1[i] << "\t" << PARAMS.filenames2[j];
            }
        }
    }

#ifdef ANALYSE_PAIRWISE_RESULTS
    analyse_pairwise_results(align_atom_m,PARAMS.filenames1,PARAMS.chains1);
#endif
    
    //Construct fragment type alignment files, if library is used
    if(PARAMS.HELIX=="1" && PARAMS.HELIX_ONLY=="0" && PARAMS.STRAND_ONLY=="0"){
        int best_idx;
        double best_score;
        vector<res_alignment> align_type_result;
        res_alignment single_result;
        for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
            tempstr = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
            tempstr = PARAMS.ALIGN_dir + tempstr + "/types_" + tempstr;
            align_types.clear();
            align_type_result.clear();
            for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
                temp_filename = tempstr+"_"+get_filename(PARAMS.filenames2[j])+"_"+PARAMS.chains2[j]+".txt";
                align_types.push_back(file_read_align_types(temp_filename));
            }
            for(unsigned int j=0; j<align_types[0].size(); j++){
                best_idx = -1;
                best_score = -1.0;
                for(unsigned int k=0; k<align_types.size(); k++){
                    if(align_types[k][j].min >= 0){
                        if(best_idx < 0 || (align_types[k][j].min < best_score)){
                            best_idx = k;
                            best_score = align_types[k][j].min;
                        }
                    }
                    //cout << align_types[k][j].res1 << " " << align_types[k][j].min << "\t";
                }
                single_result.res1 = align_types[0][j].res1;
                if(best_idx < 0){
                    single_result.res2 = "-";
                } else {
                    single_result.res2 = PARAMS.config[best_idx][2];
                }
                //cout << endl << single_result.res1 << "\t" << single_result.res1;
                align_type_result.push_back(single_result);
            }
            tempstr += ".txt";
            write_residue_type(PARAMS.error_file,tempstr,align_type_result);
        }
    }

    double DEGREES = 15;
    double ANGLE_RESOLUTION = 1000*(1-cos(DEGREES*(atan(1.0)/45.0)));		//PI = 4*atan(1.0)
    
    coord green;
    coord red;
    green.x = str_to_double(PARAMS.G1);	//0		// definition of colors representing similar/dissimilar
    green.y = str_to_double(PARAMS.G2);	//1		// variables defined in align_output_filehandling
    green.z = str_to_double(PARAMS.G3);	//0
    red.x = str_to_double(PARAMS.R1);		//0.8
    red.y = str_to_double(PARAMS.R2);		//0
    red.z = str_to_double(PARAMS.R3);		//0
    define_pymol_colors(green,red);		//must be run before creating color scripts
    
    //get max alignment and output alignment and pymol files.
    if(PARAMS.HELIX=="0" && !PARAMS.GENERIC){
        if(PARAMS.IDENTICAL=="1"){
            if(align_v[0].size()>1){
                /*for(unsigned int i=0; i<align_v.size(); i++){
                 cout << endl << "got here" << endl;
                 for(unsigned int j=0; j<align_v[i].size(); j++){
                 cout << endl << i << " " << j << "\t" << align_v[i][j].res1 << " " << align_v[i][j].res2; 
                 }
                 }*/
                align_max = max_align_scores(align_v);
                temp_filename = PARAMS.ALIGN_dir + "max_dissimilar.txt";
                write_align(align_max,temp_filename);
                
                if(PARAMS.OUT_COLOR=="1"){
                    vector<string> objs;
                    vector<char> chains;
                    objs.push_back("*");		//colors a particular residue from ALL objects/chains with one color
                    chains.push_back('*');
                    
                    double DEGREES = 15;
                    double ANGLE_RESOLUTION = 1000*(1-cos(DEGREES*(atan(1.0)/45.0)));		//PI = 4*atan(1.0)
                    
                    coord green;
                    coord red;
                    green.x = str_to_double(PARAMS.G1);	//0		// definition of colors representing similar/dissimilar
                    green.y = str_to_double(PARAMS.G2);	//1		// variables defined in align_output_filehandling
                    green.z = str_to_double(PARAMS.G3);	//0
                    red.x = str_to_double(PARAMS.R1);		//0.8
                    red.y = str_to_double(PARAMS.R2);		//0
                    red.z = str_to_double(PARAMS.R3);		//0
                    define_pymol_colors(green,red);		//must be run before creating color scripts
                    
                    //temp_filename = PARAMS.PYMOL_dir + get_filename(PARAMS.filenames1[0]) + "_" + PARAMS.chains1[0] + "min.pml";
                    string MAX_dir = make_subdirectory(PARAMS.error_file,PARAMS.PYMOL_dir,"max_dissimilar");
                    temp_filename = MAX_dir + "flexible.pml";
                    write_pymol(1,align_max,temp_filename,objs,chains,str_to_double(PARAMS.ALIGN_SCORE));
                    temp_filename = MAX_dir + "procrustes.pml";
                    write_pymol(2,align_max,temp_filename,objs,chains,str_to_double(PARAMS.ALIGN_SCORE));
                    temp_filename = MAX_dir + "sidechainRMSD.pml";
                    write_pymol(3,align_max,temp_filename,objs,chains,str_to_double(PARAMS.SIDE_SCORE));
                    temp_filename = MAX_dir + "sidechainAV.pml";
                    write_pymol(4,align_max,temp_filename,objs,chains,str_to_double(PARAMS.SIDE_SCORE));
                    temp_filename = MAX_dir + "hinging.pml";
                    if((bool)str_to_int(PARAMS.DISPLAY_AS_COSINE_DISTANCE))
                        write_pymol(5,align_max,temp_filename,objs,chains,ANGLE_RESOLUTION);
                    else 
                        write_pymol(6,align_max,temp_filename,objs,chains,ANGLE_RESOLUTION);
                   temp_filename = MAX_dir + "sidechainMAX.pml";
                   write_pymol(7,align_max,temp_filename,objs,chains,str_to_double(PARAMS.SIDE_SCORE));
                }
            }
        } else if(PARAMS.filenames1.size()==1){    //PARAMS.IDENTICAL!="0" so need to deal with it differently
            vector<res_alignment> max_scores;
            res_alignment empty_scores;
            empty_scores.res1 = "0";
            empty_scores.res2 = "0";
            empty_scores.min = -1.0;
            empty_scores.central = -1.0;
            empty_scores.rot = -1.0;
            empty_scores.sideRMS = -1.0;
            empty_scores.sideAV = -1.0;
            empty_scores.MaxDist = -1.0;
            for(unsigned int i=0; i<align_v.size(); i++){
                for(unsigned int j=0; j<align_v[i].size(); j++){
                    /*cout << endl << i << " " << j 
                    << "\t" << align_v[i][j].res1 
                    << "\t" << align_v[i][j].res2
                    << "\t" << align_v[i][j].min 
                    << "\t" << align_v[i][j].central 
                    << "\t" << align_v[i][j].rot 
                    << "\t" << align_v[i][j].sideRMS 
                    << "\t" << align_v[i][j].sideAV;*/
                    int idx=-1;
                    for(unsigned int k=0; k<max_scores.size(); k++){
                        if(max_scores[k].res1 == align_v[i][j].res1){
                            idx = (int)k;
                            break;
                        }
                    }
                    if(idx < 0){
                        idx = max_scores.size();
                        max_scores.push_back(empty_scores);
                        max_scores[idx].res1 = align_v[i][j].res1;
                    }
                    if(max_scores[idx].min < align_v[i][j].min)
                        max_scores[idx].min = align_v[i][j].min;
                    if(max_scores[idx].central < align_v[i][j].central)
                        max_scores[idx].central = align_v[i][j].central;
                    if(max_scores[idx].rot > align_v[i][j].rot || max_scores[idx].rot < 0)
                        max_scores[idx].rot = align_v[i][j].rot;
                    if(max_scores[idx].sideRMS < align_v[i][j].sideRMS)
                        max_scores[idx].sideRMS = align_v[i][j].sideRMS;
                    if(max_scores[idx].sideAV < align_v[i][j].sideAV)
                        max_scores[idx].sideAV = align_v[i][j].sideAV;
                    if(max_scores[idx].MaxDist < align_v[i][j].MaxDist)
                        max_scores[idx].MaxDist = align_v[i][j].MaxDist;
                }
            }
            /*for(unsigned int i=0; i<max_scores.size(); i++){
                cout << endl << i
                << "\t" << max_scores[i].res1 
                << "\t" << max_scores[i].res2
                << "\t" << max_scores[i].min 
                << "\t" << max_scores[i].central 
                << "\t" << max_scores[i].rot 
                << "\t" << max_scores[i].sideRMS 
                << "\t" << max_scores[i].sideAV
                << "\t" << max_scores[i].MaxDist;
            }*/
            
            string file1 = get_filename(PARAMS.filenames1[0]) + "_" + PARAMS.chains1[0];
            string MAX_dir = make_subdirectory(PARAMS.error_file,PARAMS.PYMOL_dir,"max_dissimilar");
            temp_filename = MAX_dir + "flexible.pml";
            write_pymol_nonidentical(1,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,str_to_double(PARAMS.ALIGN_SCORE));
            temp_filename = MAX_dir + "procrustes.pml";
            write_pymol_nonidentical(2,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,str_to_double(PARAMS.ALIGN_SCORE));
            temp_filename = MAX_dir + "sidechainRMSD.pml";
            write_pymol_nonidentical(3,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,str_to_double(PARAMS.SIDE_SCORE));
            temp_filename = MAX_dir + "sidechainAV.pml";
            write_pymol_nonidentical(4,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,str_to_double(PARAMS.SIDE_SCORE));
            temp_filename = MAX_dir + "hinging.pml";
            if((bool)str_to_int(PARAMS.DISPLAY_AS_COSINE_DISTANCE))
                write_pymol_nonidentical(5,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,ANGLE_RESOLUTION);
            else 
                write_pymol_nonidentical(6,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,ANGLE_RESOLUTION);
            temp_filename = MAX_dir + "sidechainMAX.pml";
            write_pymol_nonidentical(7,max_scores,align_v,temp_filename,file1,PARAMS.chains1[0],align_obj2,PARAMS.chains2,str_to_double(PARAMS.SIDE_SCORE));
        } else {    
            //PARAMS.filenames1.size()>1

            vector<string> unique_filenames;
            vector<string> unique_chains;
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                bool file_got = 0;
                for(unsigned int j=0; j<unique_filenames.size(); j++){    //do this if want to combine all chains
                    if(PARAMS.filenames1[i]==unique_filenames[j] && PARAMS.chains1[i]==unique_chains[j]){
                        file_got = 1;
                        break;
                    }
                }
                if(!file_got){
                    unique_filenames.push_back(PARAMS.filenames1[i]);
                    unique_chains.push_back(PARAMS.chains1[i]);
                }
            }
            for(unsigned int i=0; i<PARAMS.filenames2.size(); i++){
                bool file_got = 0;
                for(unsigned int j=0; j<unique_filenames.size(); j++){    //do this if want to combine all chains
                    if(PARAMS.filenames2[i]==unique_filenames[j] && PARAMS.chains2[i]==unique_chains[j]){
                        file_got = 1;
                        break;
                    }
                }
                if(!file_got){
                    unique_filenames.push_back(PARAMS.filenames2[i]);
                    unique_chains.push_back(PARAMS.chains2[i]);
                }
            }
            
            vector<vector<res_alignment> > max_scores;
            vector<res_alignment> empty_v;
            res_alignment empty_scores;
            empty_scores.res1 = "0";
            empty_scores.res2 = "0";
            empty_scores.min = -1.0;
            empty_scores.central = -1.0;
            empty_scores.rot = -1.0;
            empty_scores.sideRMS = -1.0;
            empty_scores.sideAV = -1.0;
            empty_scores.MaxDist = -1.0;
            
            //start by looking at filenames1
            for(unsigned int i=0; i<unique_filenames.size(); i++){
                max_scores.push_back(empty_v);
                for(unsigned int j=0; j<PARAMS.filenames1.size(); j++){
                    if(unique_filenames[i]==PARAMS.filenames1[j] && unique_chains[i]==PARAMS.chains1[j]){
                        for(unsigned int k=0; k<PARAMS.filenames2.size(); k++){
                            for(unsigned int l=0; l<align_m[j][k].size(); l++){
                                int idx=-1;
                                for(unsigned int m=0; m<max_scores[i].size(); m++){
                                    if(max_scores[i][m].res1==align_m[j][k][l].res1){
                                        idx = (int)m;
                                        break;
                                    }
                                }
                                if(idx < 0){
                                    idx = max_scores[i].size();
                                    max_scores[i].push_back(empty_scores);
                                    max_scores[i][idx].res1 = align_m[j][k][l].res1;
                                }
                                if(max_scores[i][idx].min < align_m[j][k][l].min)
                                    max_scores[i][idx].min = align_m[j][k][l].min;
                                if(max_scores[i][idx].central < align_m[j][k][l].central)
                                    max_scores[i][idx].central = align_m[j][k][l].central;
                                if(max_scores[i][idx].rot > align_m[j][k][l].rot || max_scores[i][idx].rot < 0)
                                    max_scores[i][idx].rot = align_m[j][k][l].rot;
                                if(max_scores[i][idx].sideRMS < align_m[j][k][l].sideRMS)
                                    max_scores[i][idx].sideRMS = align_m[j][k][l].sideRMS;
                                if(max_scores[i][idx].sideAV < align_m[j][k][l].sideAV)
                                    max_scores[i][idx].sideAV = align_m[j][k][l].sideAV;
                                if(max_scores[i][idx].MaxDist < align_m[j][k][l].MaxDist)
                                    max_scores[i][idx].MaxDist = align_m[j][k][l].MaxDist;
                            }
                        }
                    }
                }
            }
            //now look at filenames2
            for(unsigned int i=0; i<unique_filenames.size(); i++){
                for(unsigned int j=0; j<PARAMS.filenames1.size(); j++){
                    for(unsigned int k=0; k<PARAMS.filenames2.size(); k++){
                        if(unique_filenames[i]==PARAMS.filenames2[k] && unique_chains[i]==PARAMS.chains2[k]){
                            for(unsigned int l=0; l<align_m[j][k].size(); l++){ //note - align_m[j][k].size() may be zero if triangular all-on-all.
                                int idx=-1;
                                for(unsigned int m=0; m<max_scores[i].size(); m++){
                                    if(max_scores[i][m].res1==align_m[j][k][l].res2){
                                        idx = (int)m;
                                        break;
                                    }
                                }
                                if(idx < 0){
                                    idx = max_scores[i].size();
                                    max_scores[i].push_back(empty_scores);
                                    max_scores[i][idx].res1 = align_m[j][k][l].res2;
                                }
                                if(max_scores[i][idx].min < align_m[j][k][l].min)
                                    max_scores[i][idx].min = align_m[j][k][l].min;
                                if(max_scores[i][idx].central < align_m[j][k][l].central)
                                    max_scores[i][idx].central = align_m[j][k][l].central;
                                if(max_scores[i][idx].rot > align_m[j][k][l].rot || max_scores[i][idx].rot < 0)
                                    max_scores[i][idx].rot = align_m[j][k][l].rot;
                                if(max_scores[i][idx].sideRMS < align_m[j][k][l].sideRMS)
                                    max_scores[i][idx].sideRMS = align_m[j][k][l].sideRMS;
                                if(max_scores[i][idx].sideAV < align_m[j][k][l].sideAV)
                                    max_scores[i][idx].sideAV = align_m[j][k][l].sideAV;
                                if(max_scores[i][idx].MaxDist < align_m[j][k][l].MaxDist)
                                    max_scores[i][idx].MaxDist = align_m[j][k][l].MaxDist;
                            }
                        }
                    }
                }
            }
            /*cout << endl << unique_filenames << endl;
            for(unsigned int i=0; i<max_scores.size(); i++){
                for(unsigned int j=0; j<max_scores[i].size(); j++){
                    cout << endl << i << " " << j 
                    << "\t" << max_scores[i][j].res1 
                    << "\t" << max_scores[i][j].res2
                    << "\t" << max_scores[i][j].min 
                    << "\t" << max_scores[i][j].central 
                    << "\t" << max_scores[i][j].rot 
                    << "\t" << max_scores[i][j].sideRMS 
                    << "\t" << max_scores[i][j].sideAV
                    << "\t" << max_scores[i][j].MaxDist;
                }
            }*/
            vector<string> unique_obj;
            for(unsigned int i=0; i<unique_filenames.size(); i++){
                unique_obj.push_back(get_filename(unique_filenames[i])+"_"+unique_chains[i]);
            }
            string MAX_dir = make_subdirectory(PARAMS.error_file,PARAMS.PYMOL_dir,"max_dissimilar");
            
            temp_filename = MAX_dir + "flexible.pml";
            write_pymol_nonidentical(1,max_scores,temp_filename,unique_obj,unique_chains,str_to_double(PARAMS.ALIGN_SCORE));
            temp_filename = MAX_dir + "procrustes.pml";
            write_pymol_nonidentical(2,max_scores,temp_filename,unique_obj,unique_chains,str_to_double(PARAMS.ALIGN_SCORE));
            temp_filename = MAX_dir + "sidechainRMSD.pml";
            write_pymol_nonidentical(3,max_scores,temp_filename,unique_obj,unique_chains,str_to_double(PARAMS.SIDE_SCORE));
            temp_filename = MAX_dir + "sidechainAV.pml";
            write_pymol_nonidentical(4,max_scores,temp_filename,unique_obj,unique_chains,str_to_double(PARAMS.SIDE_SCORE));
            temp_filename = MAX_dir + "hinging.pml";
            if((bool)str_to_int(PARAMS.DISPLAY_AS_COSINE_DISTANCE))
                write_pymol_nonidentical(5,max_scores,temp_filename,unique_obj,unique_chains,ANGLE_RESOLUTION);
            else 
                write_pymol_nonidentical(6,max_scores,temp_filename,unique_obj,unique_chains,ANGLE_RESOLUTION);
            temp_filename = MAX_dir + "sidechainMAX.pml";
            write_pymol_nonidentical(7,max_scores,temp_filename,unique_obj,unique_chains,str_to_double(PARAMS.SIDE_SCORE));
        }
    }
   
   //output pdb loader scripts
   string fileout_pdb;
   ofstream outfile_pdb;
   string dir_i;
   string dir_j;
   string dir_0;
   string cluster_file;
   vector<string> cluster_pdbs;
   if(PARAMS.HELIX=="0" && PARAMS.OUT_PDB=="1" && !PARAMS.HBOND_RESTRAINTS){
      
      /*for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
         if(PARAMS.TRIANGULAR==1 && PARAMS.ALL_ON_ALL==1){
            if(i == PARAMS.filenames1.size()-1){
               break;
            }
         }
         dir_i = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
         fileout_pdb = PYMOL_LOADER_dir + dir_i + "_global.pml";
         outfile_pdb.open(fileout_pdb.c_str());
         if(outfile_pdb.is_open()){
            if(PARAMS.filenames2.size()>1)
               dir_0 = get_filename(PARAMS.filenames2[1]) + "_" + PARAMS.chains2[1];
            else 
               dir_0 = get_filename(PARAMS.filenames2[0]) + "_" + PARAMS.chains2[0];
            outfile_pdb << "load ../../Superposition/PDB_files/" + dir_i + "_" + dir_0 + "/" + dir_i + ".pdb" << endl;
            for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
               dir_j = get_filename(PARAMS.filenames2[j]) + "_" + PARAMS.chains2[j];
               outfile_pdb << "load ../../Superposition/PDB_files/" + dir_i + "_" + dir_j + "/" + dir_j + ".pdb" << endl;
            }
            outfile_pdb.close();
            //cout << "Pymol PDB loader written to: " << fileout_pdb << endl;
         } else {
            cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
            xml_entry(PARAMS.error_file,0,5,fileout_pdb);
         }
      }*/
      
      //output pymol pdb loader scripts for clusters
      /*if(PARAMS.CLUSTER == "1"){
         vector<vector<string> > cluster_pdbs;
         string cluster_file;
         string cluster_dir;
         for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
            if(PARAMS.TRIANGULAR==1 && PARAMS.ALL_ON_ALL==1){
               if(i == PARAMS.filenames1.size()-1){
                  break;
               }
            }
            cluster_pdbs.clear();
            dir_i = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
            for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
               cluster_file = PARAMS.PDB_dir + dir_i + "_" + get_filename(PARAMS.filenames2[j]) + "_" + PARAMS.chains2[j] + "/.clusters.txt";
               cluster_pdbs.push_back(read_file(cluster_file));
            }
            fileout_pdb = PYMOL_LOADER_dir + dir_i + "_clusters.pml";
            outfile_pdb.open(fileout_pdb.c_str());
            if(outfile_pdb.is_open()){
               if(PARAMS.filenames2.size()>1)
                  dir_0 = get_filename(PARAMS.filenames2[1]) + "_" + PARAMS.chains2[1];
               else 
                  dir_0 = get_filename(PARAMS.filenames2[0]) + "_" + PARAMS.chains2[0];
               outfile_pdb << "load ../../Superposition/PDB_files/" + dir_i + "_" + dir_0 + "/" + dir_i + ".pdb" << endl;
               for(unsigned int j=0; j<cluster_pdbs.size(); j++){
                  for(unsigned int k=0; k<cluster_pdbs[j].size(); k++){
                     outfile_pdb << "load ../../Superposition/PDB_files/" + cluster_pdbs[j][k] << endl;
                  }
               }
               outfile_pdb.close();
               //cout << "Pymol PDB loader written to: " << fileout_pdb << endl;
            } else {
               cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
               xml_entry(PARAMS.error_file,0,5,fileout_pdb);
            }
         }
      }*/
      
      for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
         if(PARAMS.TRIANGULAR==1 && PARAMS.ALL_ON_ALL==1){
            if(i == PARAMS.filenames1.size()-1){
               break;
            }
         }
         dir_i = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
         for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
            dir_j = get_filename(PARAMS.filenames2[j]) + "_" + PARAMS.chains2[j];
            cluster_file = PARAMS.PDB_dir + dir_i + "_" + dir_j + "/.clusters.txt";
            cluster_pdbs = read_file(cluster_file);
            
            //output pymol pdb loader scripts
            fileout_pdb = PYMOL_LOADER_dir + dir_i + "_" + dir_j + ".pml";
            outfile_pdb.open(fileout_pdb.c_str());
            if(outfile_pdb.is_open()){
               outfile_pdb << "load ../../Superposition/PDB_files/" + dir_i + "_" + dir_j + "/" + dir_i + ".pdb\n";
               outfile_pdb << "load ../../Superposition/PDB_files/" + dir_i + "_" + dir_j + "/" + dir_j + ".pdb\n";
               for(unsigned int k=0; k<cluster_pdbs.size(); k++){
                  outfile_pdb << "load ../../Superposition/PDB_files/" + cluster_pdbs[k] + "\n";
               }
               outfile_pdb.close();
            } else {
               cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
               xml_entry(PARAMS.error_file,0,5,fileout_pdb);
            }
            
            //output chimera pdb loader scripts
            fileout_pdb = CHIMERA_dir + dir_i + "_" + dir_j + ".com";
            outfile_pdb.open(fileout_pdb.c_str());
            if(outfile_pdb.is_open()){
               outfile_pdb << "open ../../Superposition/PDB_files/" + dir_i + "_" + dir_j + "/" + dir_i + ".pdb\n";
               outfile_pdb << "open ../../Superposition/PDB_files/" + dir_i + "_" + dir_j + "/" + dir_j + ".pdb\n";
               for(unsigned int k=0; k<cluster_pdbs.size(); k++){
                  outfile_pdb << "open ../../Superposition/PDB_files/" + cluster_pdbs[k] + "\n";
               }
               outfile_pdb << "select #0\n" << "namesel prosmart1\n";
               outfile_pdb << "select #1";
               for(unsigned int k=0; k<cluster_pdbs.size(); k++){
                  outfile_pdb << " #" << k+2;
               }
               outfile_pdb << "\n" << "namesel prosmart2\n";
               outfile_pdb << "~select";
               outfile_pdb.close();
            } else {
               cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
               xml_entry(PARAMS.error_file,0,5,fileout_pdb);
            }
            
         }
      }
      
   }
   
    ////////////////////////////////////////////////
    // Perform multiple structure superposition
    
    if(0)
    if(PARAMS.HELIX=="0" && !PARAMS.HBOND_RESTRAINTS && !PARAMS.GENERIC && PARAMS.TRIANGULAR==1 && PARAMS.ALL_ON_ALL==1){
        cout << endl << "Performing multiple structure superposition using generalised Procrustes analysis..." << endl;
        //residue alignment stored in align_m, clusters stored in align_m_clust.
        
        //get whole PDB files corresponding to each structure
        Array1D<PDBfile> pdb_v_all = get_pdb_files(workingdirectory,PARAMS.filenames1,PARAMS.chains1);
        
        //get list of residues for each PDB, and a list of atoms for each residue.
        Array1D<vector<vector<unsigned int> > > res_v_all = get_residues(pdb_v_all);
                
        //get residue alignment (indexes in res_align[i][j] correspond to residues in res_v_all[i])
        //res_align replaces align_m. (could be quicker by using knowledge of last aligned residue)
        Array2D<vector<unsigned int> > res_align = get_residue_alignment(pdb_v_all,res_v_all,align_m);
        cout << endl << "Residue alignment size matrix:" << endl;
        for(int i=0; i<res_align.dim1(); i++){
            for(int j=0; j<res_align.dim1(); j++){
                cout << "\t" << res_align[i][j].size();
            }
            cout << endl;
        }
  
        //ensuring residue consensus doesn't fit in with plans about identifying subgraphs.
/*        //need to optionally ensure residue consensus here.
//#define ENSURE_RESIDUE_CONSENSUS
#ifdef ENSURE_RESIDUE_CONSENSUS
        //optionally ensure atom consensus.
        cout << endl << "Ensuring consensus between aligned residues..." << endl;
        ensure_consensus(res_align);
        cout << "Final residue alignment size:  " << res_align[0][1].size() << endl;
#endif*/
        
        //get atom alignment directly corresponding to res_align
        Array2D<vector<unsigned int> > a_ij = get_atom_alignment(pdb_v_all,res_v_all,res_align);
        cout << endl << "Atomic alignment size matrix:" << endl;
        for(int i=0; i<a_ij.dim1(); i++){
            for(int j=0; j<a_ij.dim1(); j++){
                cout << "\t" << a_ij[i][j].size();
            }
            cout << endl;
        }
        
        ///////////////////////////////////////////
        
        /*//Identify maximal subgraphs
        
        //get aligned coords (could be quicker by storing vector<coord*> instead)
        Array2D<Coords> pair_crds = get_aligned_coords(pdb_v_all,a_ij);

        //get transformations corresponding to pairwise superpositions
        Array2D<Transform> pair_transf = get_all_transformations(pair_crds);

        return 0;*/
        
        //temporary fix:
        vector<int> group1; group1.push_back(1); group1.push_back(2); group1.push_back(4);
        vector<int> group2; group2.push_back(3); group2.push_back(5);
        for(unsigned int i=0; i<group1.size(); i++){
            for(unsigned int j=0; j<group2.size(); j++){
                a_ij[group1[i]][group2[j]].clear();
                a_ij[group2[j]][group1[i]].clear();
            }
        }
        
        cout << endl << "Atomic alignment size matrix:" << endl;
        for(int i=0; i<a_ij.dim1(); i++){
            for(int j=0; j<a_ij.dim1(); j++){
                cout << "\t" << a_ij[i][j].size();
            }
            cout << endl;
        }
        
        ///////////////////////////////////////////

        //need to allow side chain flips...
        //flip_side_chains

//#define ENSURE_FINAL_ATOM_CONSENSUS_LOOSE
#ifndef ENSURE_FINAL_ATOM_CONSENSUS_LOOSE
#define ENSURE_FINAL_ATOM_CONSENSUS
#endif

#ifdef ENSURE_FINAL_ATOM_CONSENSUS
        //optionally ensure atom consensus.
        cout << endl << "Ensuring consensus between aligned atoms, requiring completeness..." << endl;
        ensure_consensus(a_ij);
        cout << "Atomic alignment size:  " << a_ij[0][1].size() << endl;
#elif defined ENSURE_FINAL_ATOM_CONSENSUS_LOOSE
        //generalised so that consensus doesn't have to be complete, just not clash
        cout << endl << "Ensuring consensus between aligned atoms, allowing missing atoms..." << endl;
        ensure_consensus_loose(a_ij);
        cout << "Atomic alignment size:  " << a_ij[0][1].size() << endl;
#endif
      
        bool VALID = 0;
        for(int i=0; i<a_ij.dim1(); i++){
            for(int j=0; j<a_ij.dim2(); j++){
                if(a_ij[i][j].size()>0){
                    VALID = 1;
                    break;
                }
            }
            if(VALID)break;
        }
        if(!VALID){return 0;}
        
        //optionally pairwise sieve-fit alignment
        bool PAIRWISE_SIEVE_ATOMS = 0;
        Array2D<vector<unsigned int> > a_ij_superpose(a_ij);
        if(PAIRWISE_SIEVE_ATOMS){
            cout << endl << "Pairwise sieve-fitting atomic alignments..." << endl;
            sieve_fit_atoms(pdb_v_all,a_ij_superpose);
            
#ifdef ENSURE_FINAL_ATOM_CONSENSUS
            //optionally ensure atom consensus.
            //need to generalise, so that consensus doesn't have to be complete, just not clash
            cout << endl << "Ensuring consensus between aligned atoms..." << endl;
            ensure_consensus(a_ij_superpose);
            cout << "Atomic alignment size:  " << a_ij_superpose[0][1].size() << endl;
#endif
        }

        //get atomic alignment weights, if used.
        Array2D<vector<double> > w_ij(0,0);
#define USE_WEIGHTED_MULTIPLE_SUPERPOSITION
#ifdef USE_WEIGHTED_MULTIPLE_SUPERPOSITION
        w_ij = get_alignment_weights(a_ij_superpose);
#endif
        
        // END OF MULTIPLE STRUCTURE SUPERPOSITION PREPROCCESSING

        //get aligned coords (could be quicker by storing vector<coord*> instead)
        Array2D<Coords> aij_Xi = get_aligned_coords(pdb_v_all,a_ij_superpose);
        
        double t1 = get_time_sec();

        //get initial transformations, which superpose all onto the first structure. 
        //performs sieve fitting if flag is set
        Array1D<Transform> transf_0 = get_initial_transformation(aij_Xi);
        double t2 = get_time_sec();
        cout << endl << "initial transformation: " << t2-t1;
        
        //calculate rmsd for validation. Brute force approach.
        vector<double> ss_temp;
        t1 = get_time_sec();
        ss_temp.push_back(brute_force_ss(aij_Xi,w_ij,transf_0));
        t2 = get_time_sec();
        cout << endl << "initial ss: " << ss_temp.back() << "\t" << t2-t1;
        
        //optimise rotations given translations (iterative)
        
        t1 = get_time_sec();
        Array1D<Transform> transf_current = optimise_rotations(aij_Xi,w_ij,transf_0);
        ss_temp.push_back(brute_force_ss(aij_Xi,w_ij,transf_current));
        t2 = get_time_sec();
        cout << endl << "current ss (rotate 0):   " << ss_temp.back() << "\t" << t2-t1;
        
        //don't need to do the iterative optimisation if assuming consensus atomic alignment and equal weights.
        
        unsigned int ctr = 0;
        //create_empty_file(PARAMS.error_file,"loader_all.pml");
        while(1){
            ctr++;

            //optimise translations given rotations (analytic)
            t1 = get_time_sec();
            optimise_translations(aij_Xi,w_ij,transf_current);
            //ss_temp.push_back(brute_force_ss(aij_Xi,w_ij,transf_current));
            t2 = get_time_sec();
            cout << endl << "current ss (translate " << ctr << "):" << "\t\t" << t2-t1;
            
            //optimise rotations given translations (iterative)
            t1 = get_time_sec();
            transf_current = optimise_rotations(aij_Xi,w_ij,transf_current);
            t2 = get_time_sec();
            ss_temp.push_back(brute_force_ss(aij_Xi,w_ij,transf_current)); //should be done using tr
            cout << endl << "current ss (rotate " << ctr << "):   " << ss_temp.back() << "\t" << t2-t1;
            
            //appends to loader.pml - note does not reset!!!
            //output_multiple_superposition(PARAMS.filenames1,PARAMS.chains1,transf_current,(int)ctr);

            if(ss_temp[ss_temp.size()-2] - ss_temp.back() < 0.001)break;
        }
        
        output_multiple_superposition(PARAMS.filenames1,PARAMS.chains1,transf_0,"_initial",0);
        output_multiple_superposition(PARAMS.filenames1,PARAMS.chains1,transf_current,"_final",1);
        
#ifdef ENSURE_FINAL_ATOM_CONSENSUS
        pymol_multiple_superposition("superpose_consensus.pml",PARAMS.filenames1,PARAMS.chains1,pdb_v_all,a_ij_superpose);
        pymol_multiple_superposition("atom_consensus.pml",PARAMS.filenames1,PARAMS.chains1,pdb_v_all,a_ij);
        //write_pymol_concensus("atom_consensus.pml",PARAMS.filenames1,PARAMS.chains1,pdb_align);
        //multiple_structure_scoring(PARAMS.filenames1,pdb_align,transf_v);
#endif
        
        vector<double> colvec;
        colvec.push_back(str_to_double(PARAMS.G1));
        colvec.push_back(str_to_double(PARAMS.G2));
        colvec.push_back(str_to_double(PARAMS.G3));
        colvec.push_back(str_to_double(PARAMS.R1));
        colvec.push_back(str_to_double(PARAMS.R2));
        colvec.push_back(str_to_double(PARAMS.R3));
        //multiple_structure_scoring(PARAMS.filenames1,pdb_v_all,a_ij,transf_current,colvec);
        
        cout << endl << "Multiple structure superposition completed." << endl << endl;
        return 0;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////


    ////////////////////////////////////////////////
    // Perform multiple structure superposition
    
#ifdef PERFORM_MULTIPLE_SUPERPOSITION
    if(PARAMS.HELIX=="0" && !PARAMS.HBOND_RESTRAINTS && !PARAMS.GENERIC && PARAMS.TRIANGULAR==1 && PARAMS.ALL_ON_ALL==1){
        cout << endl << "Performing multiple structure superposition using iterative generalised Procrustes analysis..." << endl;

        //filter all unallowed residues (due to alternative conformations, missing atoms, etc.)
        for(int i=0; i<align_m.dim1(); i++){
            for(int j=i+1; j<align_m.dim2(); j++){
                if(align_m_clust[i][j].size()>0){
                    align_m_clust[i][j].erase(align_m_clust[i][j].begin()); //remove column titles
                }
                //cout << endl << i << "\t" << j << "\t" << endl;
                for(unsigned int k=0; k<align_m[i][j].size(); k++){
                    //cout << align_m[i][j][k];
//#define REQUIRE_SEQUENCE_IDENTITY
#ifdef REQUIRE_SEQUENCE_IDENTITY
                    if(align_m[i][j][k].sideRMS>=0.0){              //residue has side chain scores
                        continue;
                    }
                    align_m[i][j].erase(align_m[i][j].begin()+k);
                    align_m_clust[i][j].erase(align_m_clust[i][j].begin()+k);
                    k--;
#endif
                }
            }
        }

#ifdef FILTER_CLUSTERS_FOR_MULTIPLE
        //filter clusters
        for(int i=0; i<align_m.dim1(); i++){
            for(int j=i+1; j<align_m.dim2(); j++){
                for(unsigned int k=0; k<align_m[i][j].size(); k++){
                    if(align_m_clust[i][j][k].size()>3){        //at least one cluster exists
                        if(align_m_clust[i][j][k][2]!="NA"){    //residue is clustered
                            continue;
                        }
                    }
                    align_m[i][j].erase(align_m[i][j].begin()+k);
                    align_m_clust[i][j].erase(align_m_clust[i][j].begin()+k);
                    k--;
                }
            }
        }
#endif
        
        vector<res_alignment> res_scores;
        vector<vector<string> > concensus;
        Array2D<PDBfile> pdb_m;
        
#define REQUIRE_CONSENSUS_RESIDUES
#define REQUIRE_CONSENSUS_ATOMS
        
#ifdef USE_ALL_RESIDUES_ATOMS_FOR_SCORING
        Array2D<vector<res_alignment> > orig_align_m = align_m.copy();  //copy function is required, otherwise reference is passed.
#endif
        
        //get consensus alignment, if required
#if defined REQUIRE_CONSENSUS_RESIDUES || defined REQUIRE_CONSENSUS_ATOMS
        cout << endl << "Ensuring consensus residue alignment between all chains...";
        concensus = get_concensus_alignment(align_m,res_scores); //note: filters align_m
#endif

        // get matrix of pairwise corresponding coords (diagonal elements are empty)
#ifdef REQUIRE_CONSENSUS_ATOMS
        cout << endl << "Ensuring consensus atomic correspondence between all chains...";
        //get consensus atomic correspondence, given (required) consensus residue correspondence
        pdb_m = get_concensus_pdbs(workingdirectory,PARAMS.filenames1,PARAMS.chains1,concensus,0);
        vector<PDBfile> pdb_align;
        pdb_align.push_back(pdb_m[0][1]);
        for(int i=1; i<pdb_m.dim1(); i++){
            pdb_align.push_back(pdb_m[i][0]);
        }
#else
        cout << endl << "Finding pairwise consensus atomic correspondence...";
        //get pairwise atomic correspondence, given (possible consensus) residue correspondence
        pdb_m = get_aligned_pdbs(workingdirectory,PARAMS.filenames1,PARAMS.chains1,align_m);
#endif
        for(int i=0; i<pdb_m.dim1(); i++){
            cout << endl;
            for(int j=0; j<pdb_m.dim2(); j++){
                cout << "  " << pdb_m[i][j].size();
            }
        }
        
#define OUTPUT_RESIDUE_SCORES_FOR_ALL_CHAINPAIRS
#ifdef OUTPUT_RESIDUE_SCORES_FOR_ALL_CHAINPAIRS
        string file = "residues_all_chainpairs.txt";
        ofstream outfile1;
        outfile1.open(file.c_str());
        if(outfile1.is_open()){
            for(int i=0; i<align_m.dim1(); i++){
                for(int j=i+1; j<align_m.dim2(); j++){
                    for(unsigned int k=0; k<align_m[i][j].size(); k++){
                        outfile1 << align_m[i][j][k].sideRMS << "\t" << align_m[i][j][k].MaxDist << endl;
                    }
                }
            }
            outfile1.close();
        }

#endif

        bool PERFORM_SIEVE_FITTING = 1;
        bool ENSURE_FINAL_ATOMIC_CORRESPONDENCE = 0;
#ifdef REQUIRE_CONSENSUS_ATOMS
        ENSURE_FINAL_ATOMIC_CORRESPONDENCE = 1;
#endif
        if(PERFORM_SIEVE_FITTING){
            cout << endl << "Performing pairwise superpositions with sieve fitting to filter atom-pair outliers...";
            if(ENSURE_FINAL_ATOMIC_CORRESPONDENCE){
                cout << endl << "(ensuring that final atomic correspondence is in consensus between all chains)";
            }
        }
        //get coords corresponding to pdb_m. Filter coords if required (e.g. sieve fitting). Also filters pdb_m.
        Array2D<Coords> crd_m = get_coord_m(pdb_m,PERFORM_SIEVE_FITTING,ENSURE_FINAL_ATOMIC_CORRESPONDENCE);
        
        vector<PDBfile> pdb_final;
        if(ENSURE_FINAL_ATOMIC_CORRESPONDENCE){
            pdb_final.push_back(pdb_m[0][1]);
            for(int i=1; i<pdb_m.dim1(); i++){
                pdb_final.push_back(pdb_m[i][0]);
            }
        }
        
        for(int i=0; i<pdb_m.dim1(); i++){
            cout << endl;
            for(int j=0; j<pdb_m.dim2(); j++){
                cout << "  " << pdb_m[i][j].size();
            }
        }
        
        //output max and pooled difference between atoms in final correspondence, using pairwise superpositions.
        if(ENSURE_FINAL_ATOMIC_CORRESPONDENCE){
            // crd_m - atoms in filtered consensus atomic alignment used for superposition
            // pdb_align - atoms in unfiltered consensus atomic alignment used for scoring
            output_pairwise_superpositions(crd_m,pdb_align);
        }
        
        //output pairwise colour scripts to identify final atomic alignment.
        //write_pymol_concensus(PARAMS.filenames1,PARAMS.chains1,pdb_m);

        cout << endl << "Identifying translations, ready for multiple structure rotation optimisation...";
        //identify translations and normalise coords
        vector<coord> translate_v = identify_translations(crd_m);   //normalises crd_m
        
        //need some validation, e.g. test if coordinates are zero length
        
        // perform multiple structure superposition
        cout << endl << "Performing multiple structure superposition...";
#define GENERALISED_PROCRUSTES_USE_MEAN
#ifdef GENERALISED_PROCRUSTES_USE_MEAN
        vector<Transform> transf_v = multiple_structure_superposition1(crd_m,translate_v);
        
        for(unsigned int i=0; i<transf_v.size(); i++){
            cout << endl << transf_v[i] << endl;
        }
        
#else 
#ifdef GENERALISED_PROCRUSTES_UPDATE_ROTATIONS

#else
        
#endif
#endif
        // NEED TO OUTPUT CONSENSUS ALIGNMENT CORRESPONDING TO SIEVED ALIGNMENT
        
        // NEED TO BE ABLE TO INCLUDE RESIDUES OF DIFFERENT TYPES!!!! E.G. ALIGN GLY TO ALA, AND ONLY REMOVE CB.
        
#ifdef USE_ALL_RESIDUES_ATOMS_FOR_SCORING
        cout << endl << "Getting extended consensus residue alignment ready for scoring...";
        concensus = get_extended_concensus_alignment(orig_align_m,res_scores); //note: replaces res_scores and concensus
        
        ofstream outfile_mult;
        outfile_mult.open("for_garib.txt");
        if(outfile_mult.is_open()){
            outfile_mult << "# ProSMART Multiple Alignment File";
            if(concensus.size()>0){
                outfile_mult << endl << get_filename(PARAMS.filenames1[0]);
                for(unsigned int k=1; k<PARAMS.filenames1.size(); k++){
                    outfile_mult << "\t" << get_filename(PARAMS.filenames1[k]);
                }
                outfile_mult << endl << PARAMS.chains1[0];
                for(unsigned int k=1; k<PARAMS.chains1.size(); k++){
                    outfile_mult << "\t" << PARAMS.chains1[k];
                }
                for(unsigned int k=0; k<concensus[0].size(); k++){
                    outfile_mult << endl << concensus[0][k];
                    for(unsigned int i=1; i<concensus.size(); i++){
                        outfile_mult << "\t" << concensus[i][k];
                    }
                }
            }
            outfile_mult.close();
        }
                
        pdb_m = get_concensus_pdbs(workingdirectory,PARAMS.filenames1,PARAMS.chains1,concensus,1);

        pdb_align.clear();
        pdb_align.push_back(pdb_m[0][1]);
        for(int i=1; i<pdb_m.dim1(); i++){
            pdb_align.push_back(pdb_m[i][0]);
        }
#endif
        
        bool OUT_PDB_FULL = 0;
        vector<string> info;
        //output PDB files
        string empty_s="";
        string tmp="super1";
        create_directory(empty_s,tmp);
        
        for(unsigned int i=0; i<transf_v.size(); i++){
            string fileout2 = "super1/"+get_full_filename(PARAMS.filenames1[i]);
            output_pdb(info,PARAMS.filenames1[i],fileout2,PARAMS.chains1[i][0],transf_v[i],1,OUT_PDB_FULL);
        }
        
        //output PDB file loader
        ofstream outfile;
        outfile.open("loader.pml");
        if(outfile.is_open()){
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                outfile << "load super1/"+get_full_filename(PARAMS.filenames1[i]) << endl;
            }
            outfile.close();
        }
        
#if defined REQUIRE_CONSENSUS_RESIDUES || defined REQUIRE_CONSENSUS_ATOMS
#ifdef OUTPUT_CONCENSUS_PYMOL
        //output colour scripts for consensus scores
        //consensus is multiple structure residue-based. Scores are from pairwise alignement.
        write_pymol_concensus("concensus.pml",PARAMS.filenames1,PARAMS.chains1,concensus);
        vector<double> scores;
        for(unsigned int i=0; i<res_scores.size(); i++) scores.push_back(res_scores[i].min);
        output_pymol_residues("resmin.pml",PARAMS.filenames1,PARAMS.chains1,concensus,scores,1.0);
        scores.clear();
        for(unsigned int i=0; i<res_scores.size(); i++) scores.push_back(res_scores[i].MaxDist);
        output_pymol_residues("resmaxdist.pml",PARAMS.filenames1,PARAMS.chains1,concensus,scores,2.0);
        scores.clear();
        for(unsigned int i=0; i<res_scores.size(); i++) scores.push_back(res_scores[i].asa1);
        output_pymol_residues("resmaxasa.pml",PARAMS.filenames1,PARAMS.chains1,concensus,scores,30.0);
#endif
#endif

#ifdef REQUIRE_CONSENSUS_ATOMS
        if(ENSURE_FINAL_ATOMIC_CORRESPONDENCE){
            //output colur script for final consensus used for superposition
            write_pymol_concensus("superpose_consensus.pml",PARAMS.filenames1,PARAMS.chains1,pdb_final);
            write_pymol_concensus("atom_consensus.pml",PARAMS.filenames1,PARAMS.chains1,pdb_align);
        }
        //output colur script for consensus atomic max rmsd
        multiple_structure_scoring(PARAMS.filenames1,pdb_align,transf_v);
#endif

        cout << endl << endl;
        return 0;
        ////////////////////////////////////////////////

/*
        if(concensus[0].size()==0){
            cout << endl << "Could not achieve concensus alignment. Multiple structure superposition cancelled." << endl;
        } else {
            vector<PDBfile> pdb_v = get_concensus_pdbs(workingdirectory,PARAMS.filenames1,PARAMS.chains1,concensus);
            if(pdb_v.size()==0){
                cout << endl << "Error - unable to determine side chains correspondence in concensus alignment. Cowardly refusing to continue with multiple structure superposition." << endl;
            } else {
#ifdef GENERALISED_PROCRUSTES_BRUTE_FORCE
                vector<Transform> transf_v = multiple_structure_superposition1(pdb_v,PARAMS.filenames1,PARAMS.chains1);
#else
#ifdef GENERALISED_PROCRUSTES_UPDATE_ROTATIONS
                vector<Transform> transf_v = multiple_structure_superposition3(pdb_v,PARAMS.filenames1,PARAMS.chains1);                
#else
                vector<Transform> transf_v = multiple_structure_superposition2(pdb_v,PARAMS.filenames1,PARAMS.chains1);
#endif
#endif
                
                //get atomic dissimilarity scores for all atoms (not just clusters)
                //vector<PDBfile> pdb_v_all = get_concensus_pdbs(workingdirectory,PARAMS.filenames1,PARAMS.chains1,concensus_all);
                //multiple_structure_scoring(PARAMS.filenames1,pdb_v_all,transf_v);
                
                multiple_structure_scoring(PARAMS.filenames1,pdb_v,transf_v);
            }
        }
        cout << endl;

    */
    }
#endif
    
    ////////////////////////////////////////////////
    //Get chain-pairs for ProSMART RESTRAIN

    vector<vector<int> > restrain_chains;
    vector<int> tmp_chain_pairs;
    vector<string> file2;
    bool ALREADY_GOT = 0;
    
    int best_j;
    double best_d;
    vector<vector<string> > read_scores;
    
    if(PARAMS.GENERIC || (PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET)){ //for generic self-restraints, all target chains are restrained to themselves.
    //if(PARAMS.GENERIC){ //for generic self-restraints, all target chains are restrained to themselves.
        restrain_chains.clear();
        for(unsigned int i=0; i<PARAMS.chains1.size(); i++){
            tmp_chain_pairs.clear();
            tmp_chain_pairs.push_back(i);
            restrain_chains.push_back(tmp_chain_pairs);
        }
    } else {
        if(PARAMS.RESTRAIN == 1){
            if(PARAMS.ALL_ON_ALL==1){
                PARAMS.RESTRAIN_OPTION = 2;
                if(PARAMS.TRIANGULAR==0){
                    PARAMS.RESTRAIN_TO_SELF = 0;
                }
            }
            if(PARAMS.HELIX=="1"){
                PARAMS.RESTRAIN_OPTION = 1;
            }
            
            for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
                ALREADY_GOT=0;
                for(unsigned int k=0; k<file2.size(); k++){
                    if(PARAMS.filenames2[j]==file2[k]){
                        ALREADY_GOT=1;
                        break;
                    }
                }
                if(ALREADY_GOT==0){
                    file2.push_back(PARAMS.filenames2[j]);
                }
            }
            
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                tmp_chain_pairs.clear();
                switch(PARAMS.RESTRAIN_OPTION){
                    case 1:	//take all chains (used by default for fragment type id)
                      tempstr = SINGLE_dir + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_";
                        for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
                           if(PARAMS.HELIX!="1"){ //only test validity if not using fragment library
                              temp_fileout = tempstr+get_filename(PARAMS.filenames2[j])+"_"+PARAMS.chains2[j]+".txt";
                              read_scores = read_file_lines(temp_fileout);
                              //conditions on sequence identity and net procrustes (minimum) score required for restraint generation.
                              if(str_to_double(read_scores[2][1])<PARAMS.RESTRAIN_SEQID || str_to_double(read_scores[4][1])>PARAMS.RESTRAIN_SCORE){
                                 continue;
                              }
                              if(PARAMS.RESTRAIN_TO_SELF==0){
                                 if(PARAMS.filenames1[i]==PARAMS.filenames2[j]){
                                    if(PARAMS.chains1[i]==PARAMS.chains2[j]){
                                       continue;
                                    }
                                 }
                              }
                           }
                            tmp_chain_pairs.push_back(j);
                        }
                        break;
                    case 2:	//p2 not specified - triangular all-on-all chains
                        for(unsigned int j=i+1; j<PARAMS.filenames2.size(); j++){
                            tmp_chain_pairs.push_back(j);
                        }
                        break;
                    default:	//take only the best chain from each PDB (default)
                        tempstr = SINGLE_dir + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_";
                        for(unsigned k=0; k<file2.size(); k++){
                            best_j = -1;
                            best_d = -1;
                            for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
                                if(PARAMS.filenames2[j]!=file2[k]){
                                    continue;
                                }
                                if(PARAMS.RESTRAIN_TO_SELF==0){
                                    if(PARAMS.filenames1[i]==PARAMS.filenames2[j]){
                                        if(PARAMS.chains1[i]==PARAMS.chains2[j]){
                                            continue;
                                        }
                                    }
                                }
                                temp_fileout = tempstr+get_filename(PARAMS.filenames2[j])+"_"+PARAMS.chains2[j]+".txt";
                                read_scores = read_file_lines(temp_fileout);
                                                              
                               //conditions on sequence identity and net procrustes (minimum) score required for restraint generation.
                               if(str_to_double(read_scores[2][1])<PARAMS.RESTRAIN_SEQID || str_to_double(read_scores[4][1])>PARAMS.RESTRAIN_SCORE){
                                  continue;
                               }
                               
                                if(best_d > str_to_double(read_scores[4][1]) || best_d < 0){
                                    best_d = str_to_double(read_scores[4][1]);
                                    best_j = j;
                                }
                            }
                            if(best_j >= 0){
                                tmp_chain_pairs.push_back(best_j);
                            }
                        }
                        break;
                }
                restrain_chains.push_back(tmp_chain_pairs);
            }
        }
    }

    ////////////////////////////////////////////////
    //Validate bonds files
    
    if(PARAMS.RESTRAIN == 1){
        if(PARAMS.GET_BONDS == "1" && PARAMS.MAINCHAIN_ONLY == "0"){
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                //check that PARAMS.filenames1[i] has not already been considered (sometimes PARAMS.filenames1[0]==PARAMS.filenames1[1], etc.)
                bonds_filename = PARAMS.filenames1[i];
                bonds_exists = 0;
                for(unsigned int j=0; j<i; j++){
                    if(bonds_filename == PARAMS.filenames1[j]){
                        bonds_exists = 1;
                        break;
                    }
                }
                
                //if this is a new pdb file to consider...
                if(bonds_exists == 0){	
                    bonds_filename = workingdirectory+get_filename(PARAMS.filenames1[i])+"_bonds.txt";
                    bonds_exists = check_file(bonds_filename);	//check whether valid bonds file exists.
                    
                    //if bonds file was not successfully generated, then delete the file.
                    if(bonds_exists==0){
                        xml_entry(PARAMS.error_file,1,0,bonds_filename);
                        cout << endl << "Warning: bonds file " << bonds_filename << " was not created successfully by refmac5."
                        << endl << "Please check that refmac5 version 5.6.0081 or later is installed."
                        << endl << "Please check that refmac5 can be executed by typing:  " << PARAMS.REFMAC_NAME
                        << endl << "Alternatively, use the '-refmac' keyword to manually specify the name of the appropriate refmac5 executable."
                        << endl << "If refmac5 did run but failed, try closing and restarting the shell."
                        << endl << endl << "ProSMART Restrain will not continue." << endl << endl;
                        unlink(windows_file(bonds_filename).c_str());     //remove file, if it exists
                        return 0;
                    }
                }
            }
        }
    }
    
    ////////////////////////////////////////////////
    //Run prosmart restrain
    
    string multiple_restrain_file;
    string current_filename;
    string final_restrain_file;
    vector<string> final_restrain_files;
    vector<string> final_restrain_names;
    vector<vector<string> > filenames_chain2;
    vector<string> filenames_all;
   vector<string> fail_message;
    
    if(PARAMS.RESTRAIN == 1){
        temp_string = workingdirectory + "res_outfile";
        fileout = workingdirectory + "restrain_script";
        newpIDs.clear();
        args1.clear();
        args2.clear();
        args3.clear();
        sys_string.clear();
        message.clear();
        temp = 0;

        //create program launch vector, to be put in file to source.
        args1.push_back(PARAMS.restrain_location);
		args1.push_back("");                            //File 1
		args1.push_back("");                            //File 2
		args1.push_back("");                            //Chain identifier from file 1. Must be of length 1.
		args1.push_back("");                            //Chain identifier from file 2. Must be of length 1.
        args1.push_back(format_wd(workingdirectory));
        args1.push_back(PARAMS.sphere);					//Size of sphere for generating restraints.
        args1.push_back(PARAMS.sigma);						//Uniform sigma for all restraints
        args1.push_back(PARAMS.MIN_DISTANCE);
        args1.push_back(PARAMS.sigma_method);
        args1.push_back(PARAMS.score_cutoff);
        args1.push_back(PARAMS.RESTRAIN_SIDE_CUTOFF);
        args1.push_back(PARAMS.RESTRAIN_MULTIPLIER_CUTOFF);
        args1.push_back(PARAMS.SIGMA_WEIGHT);
        args1.push_back(PARAMS.HELIX);
        args1.push_back(PARAMS.MINIMUM_SIGMA);
        args1.push_back(PARAMS.GET_BONDS);
        args1.push_back(PARAMS.BFAC1);
        args1.push_back(PARAMS.BFAC2);
        args1.push_back(PARAMS.MAINCHAIN_ONLY);
        args1.push_back("-");
        args1.push_back("-");
        args1.push_back(PARAMS.TYPE);
        args1.push_back(int_to_str(PARAMS.GENERIC));
        args1.push_back("-");
        args1.push_back("");
        for(unsigned int i=0; i<PARAMS.chains1.size(); i++){
            
           if(restrain_chains[i].size()==0){              
              fail_message.push_back("Warning - no restraints will be generated for " + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + ". If this is not as intended, see keywords: -restrain_seqid and -restrain_score.");
           }
           
            for(unsigned int j=0; j<restrain_chains[i].size(); j++){
                create_empty_file(PARAMS.error_file,RES_dir+get_filename(PARAMS.filenames1[i])+"_"+PARAMS.chains1[i]+"_"+get_filename(PARAMS.filenames2[restrain_chains[i][j]])+"_"+PARAMS.chains2[restrain_chains[i][j]]+".txt");
                args1[1] = "\""+PARAMS.filenames1[i]+"\"";
                args1[2] = "\""+PARAMS.filenames2[restrain_chains[i][j]]+"\"";
                args1[3] = PARAMS.chains1[i];
                args1[4] = PARAMS.chains2[restrain_chains[i][j]];
                args1[20] = get_restraints_range(PARAMS,i);
                args1[21] = get_restraints_range_rm(PARAMS,i);
                if(PARAMS.HBOND_RESTRAINTS){
                    if(!PARAMS.H_HELIX && !PARAMS.H_SHEET){
                        args1[24] = "\""+PARAMS.H_FILENAMES[0]+"\"";        //for main-chain bond restraints, it should always be PARAMS.H_FILENAMES[0]
                    } else {
                        args1[24] = "\""+PARAMS.H_FILENAMES[restrain_chains[i][j]]+"\"";
                    }
                }
                temp++;
                temp_stringstream.str("");
                temp_stringstream << temp_string << temp;
                args1[args1.size()-1] = "> \""+temp_stringstream.str()+"\"";
                
                if(PARAMS.HBOND_RESTRAINTS){
                    message.push_back("Generating Generic Bond Restraints for " + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i]);
                } else {
                    message.push_back("Generating Restraints for " + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + " using " + get_filename(PARAMS.filenames2[restrain_chains[i][j]]) + "_" + PARAMS.chains2[restrain_chains[i][j]]);
                }
                args2.push_back("\""+temp_stringstream.str()+"\"");    //ready for concatenating logfiles
                args3.push_back(temp_stringstream.str());              //ready for deleting logfiles
                sys_string.push_back(vector_to_string(args1));
            }
        }
        xml_entry(PARAMS.error_file,2,3);
        cout << endl << "ProSMART RESTRAIN launched:  " << get_time() << endl << endl;
       for(unsigned int i=0; i<fail_message.size(); i++){
          cout << fail_message[i] << endl;
       }
        spawn_external(PARAMS.error_file,sys_string,message,pIDs,newpIDs,PARAMS.MAX_THREADS);	//launch prosmart restrain, and wait for all instances to terminate before continuing.
        
        //concatenate log files and delete originals
        logfiles.clear();
        for(unsigned int i=0; i<args3.size(); i++)logfiles.push_back(read_file_line_string(args3[i]));
        tmpstr = PARAMS.output_dir + "prosmart_restrain_logfile.txt";
        write_to_file(tmpstr,logfiles);
        for(unsigned int i=0; i<args3.size(); i++)unlink(args3[i].c_str());
        
        ////////////////////////////////////////////////
        //Validate restrain files
        
        for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
            tempstr = RES_dir + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_";
            for(unsigned int j=0; j<restrain_chains[i].size(); j++){
                temp_filename = tempstr+get_filename(PARAMS.filenames2[restrain_chains[i][j]])+"_"+PARAMS.chains2[restrain_chains[i][j]]+".txt";
                return_status = validate_file(temp_filename);
                if(return_status == 1){
                    xml_entry(PARAMS.error_file,0,9,temp_filename);
                    cout << "Error - restraints file: " << temp_filename << " was not created successfully. Program terminated." << endl;
                    return 0;
                }
            }
        }
        
        ////////////////////////////////////////////////
        //Read restraint files
        /*
         Restraints Res1;
         
         
         for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
         tempstr = RES_dir + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_";
         for(unsigned int j=0; j<restrain_chains[i].size(); j++){
         temp_filename = tempstr+get_filename(PARAMS.filenames2[restrain_chains[i][j]])+"_"+PARAMS.chains2[restrain_chains[i][j]]+".txt";
         Res1.read_Res(temp_filename);
         Res1.view();
         break;
         }
         break;
         }
         */
        
        ////////////////////////////////////////////////
        //Output PyMOL scripts to auto-load PDBs in colour and displaying restraints
        
        /////////////////
        //For h-bond restraints, output one file for each PDB, for each of main, helix and sheet.
                
        if(PARAMS.HBOND_RESTRAINTS && PARAMS.OUT_PDB=="1"){
            //vector<string> unique_filenames;
            /*for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                bool file_got = 0;
                for(unsigned int j=0; j<unique_filenames.size(); j++){    //do this if want to combine all chains
                    if(PARAMS.filenames1[i]==unique_filenames[j]){
                        file_got = 1;
                        break;
                    }
                }
                if(!file_got)unique_filenames.push_back(PARAMS.filenames1[i]);
            }*/
            string subdir;
            string dir_j;
            for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
                dir_i = get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i];
                if(!PARAMS.H_HELIX && !PARAMS.H_SHEET){
                    subdir = dir_i + "_" + dir_i;
                    
                    //pymol script to display residue separation
                    fileout_pdb = LOADER_dir + dir_i + "_hbond_main_residue_separation.pml";
                    outfile_pdb.open(fileout_pdb.c_str());
                    if(outfile_pdb.is_open()){
                        outfile_pdb << "load ../Superposition/PDB_files/" + subdir + "/" + dir_i + ".pdb" << endl;
                        outfile_pdb << "@../Restraints/Chain_Chain/" + subdir + "_distances.pml" << endl;
                        outfile_pdb << "@../Colour_Scripts/" + subdir + "/bond_residue_separation.pml" << endl;
                        outfile_pdb << "hide all" << endl;
                        outfile_pdb << "show cartoon" << endl;
                        outfile_pdb << "show dashes" << endl;
                        outfile_pdb << "show sticks, (n;N,C,CA,O)" << endl;
                        outfile_pdb << "bg_color white" << endl;
                        outfile_pdb << "zoom" << endl;
                        outfile_pdb.close();
                    } else {
                        cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
                        xml_entry(PARAMS.error_file,0,5,fileout);
                    }
                    
                    //pymol script to display number of restraints per atom
                    fileout_pdb = LOADER_dir + dir_i + "_hbond_main_no_restraints.pml";
                    outfile_pdb.open(fileout_pdb.c_str());
                    if(outfile_pdb.is_open()){
                        outfile_pdb << "load ../Superposition/PDB_files/" + subdir + "/" + dir_i + ".pdb" << endl;
                        outfile_pdb << "@../Restraints/Chain_Chain/" + subdir + "_distances.pml" << endl;
                        outfile_pdb << "@../Colour_Scripts/" + subdir + "/bond_restraints_per_atom.pml" << endl;
                        outfile_pdb << "hide all" << endl;
                        outfile_pdb << "show dashes" << endl;
                        outfile_pdb << "set dash_color, black" << endl;
                        outfile_pdb << "show sticks, (n;N,C,CA,O)" << endl;
                        outfile_pdb << "bg_color white" << endl;
                        outfile_pdb << "zoom" << endl;
                        outfile_pdb.close();
                    } else {
                        cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
                        xml_entry(PARAMS.error_file,0,5,fileout);
                    }
                } else {
                    for(unsigned int j=0; j<PARAMS.filenames2.size(); j++){
                        dir_j = get_filename(PARAMS.filenames2[j]) + "_" + PARAMS.chains2[j];
                        subdir = dir_i + "_" + dir_j;
                        
                        //pymol script to display residue separation
                        fileout_pdb = LOADER_dir + subdir + "_hbond_main_residue_separation.pml";
                        outfile_pdb.open(fileout_pdb.c_str());
                        if(outfile_pdb.is_open()){
                            outfile_pdb << "load ../Superposition/PDB_files/" + dir_i + ".pdb" << endl;
                            outfile_pdb << "@../Restraints/Chain_Chain/" + subdir + "_distances.pml" << endl;
                            outfile_pdb << "@../Colour_Scripts/" + subdir + "/bond_residue_separation.pml" << endl;
                            outfile_pdb << "hide all" << endl;
                            outfile_pdb << "show cartoon" << endl;
                            outfile_pdb << "show dashes" << endl;
                            outfile_pdb << "show sticks, (n;N,C,CA,O)" << endl;
                            outfile_pdb << "bg_color white" << endl;
                            outfile_pdb << "zoom" << endl;
                            outfile_pdb.close();
                        } else {
                            cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
                            xml_entry(PARAMS.error_file,0,5,fileout);
                        }
                        
                        //pymol script to display number of restraints per atom
                        fileout_pdb = LOADER_dir + subdir + "_hbond_main_no_restraints.pml";
                        outfile_pdb.open(fileout_pdb.c_str());
                        if(outfile_pdb.is_open()){
                            outfile_pdb << "load ../Superposition/PDB_files/" + dir_i + ".pdb" << endl;
                            outfile_pdb << "@../Restraints/Chain_Chain/" + subdir + "_distances.pml" << endl;
                            outfile_pdb << "@../Colour_Scripts/" + subdir + "/bond_restraints_per_atom.pml" << endl;
                            outfile_pdb << "hide all" << endl;
                            outfile_pdb << "show dashes" << endl;
                            outfile_pdb << "set dash_color, black" << endl;
                            outfile_pdb << "show sticks, (n;N,C,CA,O)" << endl;
                            outfile_pdb << "bg_color white" << endl;
                            outfile_pdb << "zoom" << endl;
                            outfile_pdb.close();
                        } else {
                            cout << "Unable to open output file " << fileout_pdb << " for writing" << endl;
                            xml_entry(PARAMS.error_file,0,5,fileout);
                        }
                    }
                }
            }
        }
        
        ////////////////////////////////////////////////
        
        //Create final restraint files
        //don't output PDB_chain any more by default...
        if((PARAMS.HELIX=="1" || PARAMS.RESTRAIN_OPTION==1) && PARAMS.OUTPUT_PDB_CHAIN_RESTRAINTS){
            //outputs one file for each fragment, for each PDB
            if(PARAMS.H_HELIX){
                filenames_chain2 = write_restraints_chain2(PARAMS.filenames1,PARAMS.filenames2,PARAMS.chains1,PARAMS.chains2,restrain_chains,PARAMS.error_file,"0", RES_dir, workingdirectory, PARAMS.TROUBLESHOOT_RESTRAINT_FILES);
            } else {
                filenames_chain2 = write_restraints_chain2(PARAMS.filenames1,PARAMS.filenames2,PARAMS.chains1,PARAMS.chains2,restrain_chains,PARAMS.error_file,PARAMS.HELIX, RES_dir, workingdirectory, PARAMS.TROUBLESHOOT_RESTRAINT_FILES);
            }
        }
        //contains all restraints
        vector<string> multi_filenames;
        if(PARAMS.H_HELIX){
            filenames_all = write_restraints(PARAMS.filenames1,PARAMS.filenames2,PARAMS.chains1,PARAMS.chains2,restrain_chains,PARAMS.error_file,"0", RES_dir, workingdirectory, PARAMS.TROUBLESHOOT_RESTRAINT_FILES,multi_filenames,PARAMS.COPY_FINAL_RESTRAINTS_FILES);
        } else {
            filenames_all = write_restraints(PARAMS.filenames1,PARAMS.filenames2,PARAMS.chains1,PARAMS.chains2,restrain_chains,PARAMS.error_file,PARAMS.HELIX, RES_dir, workingdirectory, PARAMS.TROUBLESHOOT_RESTRAINT_FILES,multi_filenames,PARAMS.COPY_FINAL_RESTRAINTS_FILES);
        }
        if(PARAMS.COPY_FINAL_RESTRAINTS_FILES){
            for(unsigned int i=0; i<multi_filenames.size(); i++){
                string finalfile = PARAMS.output_dir + get_full_filename(multi_filenames[i]);
                bool result = validate_file(finalfile);
                if(!result){
                    cout << endl << "Final restraints file copied to: " << finalfile;
                }
            }
        }
        
        xml_entry(PARAMS.error_file,2,4);
        cout << endl << "ProSMART RESTRAIN completed: " << get_time() << endl
        << "See " << PARAMS.output_dir << "prosmart_restrain_logfile.txt for details." << endl;
    }
    
    ////////////////////////////////////////////////
    //Create html output files
    
    bool HBOND_FILE_OPTIONS = 0;
    if(PARAMS.HBOND_RESTRAINTS && !PARAMS.H_HELIX && !PARAMS.H_SHEET)HBOND_FILE_OPTIONS=1;
    
    vector<string> files1;
    vector<string> files2;
    for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
        files1.push_back(get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i]);
    }
    for(unsigned int i=0; i<PARAMS.filenames2.size(); i++){
        files2.push_back(get_filename(PARAMS.filenames2[i]) + "_" + PARAMS.chains2[i]);
    }
    
    bool USE_LIB=0;
    if(PARAMS.HELIX=="1" && PARAMS.HELIX_ONLY=="0" && PARAMS.STRAND_ONLY=="0"){
        USE_LIB=1;
    }
    
    if(PARAMS.ALIGN==1){
        if(USE_LIB==1){
            write_html_ssetype(PARAMS.error_file,workingdirectory,files1,files2);
        }
        if(PARAMS.HELIX=="1"){
            write_html_frag_score(PARAMS.error_file, workingdirectory, files1, files2);
        } else {
            write_html_transformations(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.ALL_ON_ALL,PARAMS.TRIANGULAR,HBOND_FILE_OPTIONS);
        }
        write_html_pairwise(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.ALL_ON_ALL,PARAMS.TRIANGULAR,HBOND_FILE_OPTIONS);
        write_html_scores(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.ALL_ON_ALL,PARAMS.TRIANGULAR,HBOND_FILE_OPTIONS);
        if(PARAMS.OUT_COLOR=="1"){
            if(PARAMS.HELIX=="0"){
                write_html_pymol(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.ALL_ON_ALL,PARAMS.TRIANGULAR,HBOND_FILE_OPTIONS);
            } else {
                write_html_pymol_helix(PARAMS.error_file,workingdirectory,files1,files2);
            }
        }
        if(PARAMS.OUT_PDB=="1"){
            if(PARAMS.HELIX=="0"){
                write_html_pdb(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.ALL_ON_ALL,PARAMS.TRIANGULAR,HBOND_FILE_OPTIONS);
            } else {
                write_html_pdb_helix(PARAMS.error_file,workingdirectory,files1);
            }
        }
        write_html_sequence(PARAMS.error_file,workingdirectory,files1,files2,PARAMS.HELIX);
        
        if(ALIGN_MULTI == 1){
            write_html_multi(PARAMS.error_file,workingdirectory,files1,files2);
        }
    }
    if(PARAMS.RESTRAIN==1){
        write_html_restrain(PARAMS.error_file,workingdirectory,files1,files2,final_restrain_names,PARAMS.HELIX,restrain_chains,filenames_chain2,filenames_all);
    }
    write_html_message(PARAMS.error_file,Results_dir,1);
    
    write_html(PARAMS.error_file,fileout_results,USE_LIB,PARAMS.HELIX_ONLY,PARAMS.STRAND_ONLY, PARAMS.CLUSTER, PARAMS.ALIGN, PARAMS.RESTRAIN, ALIGN_MULTI, 1, (bool)str_to_int(PARAMS.OUT_PDB), (bool)str_to_int(PARAMS.OUT_COLOR), "Output_Files/.HTML_files/", PARAMS.output_dir);
    cout << endl << "Results written to: " << fileout_results << endl;
    
    ////////////////////////////////////////////////
    
    xml_entry(PARAMS.error_file,3,0);
    copy_xml(PARAMS.error_file,workingdirectory);
    
    cout << endl << "ProSMART completed." << endl << endl;
    
#ifdef PERFORMANCE
    double t2 = get_time_sec();
    write_performance_file("Prosmart.txt","NA","NA",0,0,0,0,t2-t1);
#endif
    
    return 0;
}

/*	//this could be added at a later date, as an option.
 
 //output multiple residue-based sidechain rmsd files		  
 for(int i=0; i<PARAMS.chains1.size(); i++){
 scores_in.clear();
 output_filename = MULTI_RESI_dir + "SidechainRMSD_" + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_";
 for(int j=0; j<PARAMS.chains1.size(); j++){
 if(i!=j){
 output_filename += "_" + get_filename(PARAMS.filenames1[j]) + "_" + PARAMS.chains1[j];
 temp_filename = MULTI_RESI_dir + "SidechainRMSD_" + get_filename(PARAMS.filenames1[i]) + "_" + PARAMS.chains1[i] + "_" + get_filename(PARAMS.filenames1[j]) + "_" + PARAMS.chains1[j] + ".tmp";
 scores_in.push_back(read_file(temp_filename));
 }
 }
 output_filename += ".txt";
 output_multi_res(scores_in,output_filename);
 }
 temp_filename = MULTI_RESI_dir + "*.tmp";
 delete_file_no_check(temp_filename);	//delete temporary pairwise sidechain rmsd files
 */
