//
// This file is part of ProSMART.
//

#include "prosmartClass_Restraints.h"

void Restraints::read_Res(string &filein)
{
	vector<vector<string> > lines = read_file_lines(filein);
	
	for(unsigned int i=0; i<lines.size(); i++){
		if(lines[i].size()!=24){continue;}
		res1.push_back(str_to_int(lines[i][6]));
		ins1.push_back(lines[i][8][0]);
		atom1.push_back(lines[i][10]);
		res2.push_back(str_to_int(lines[i][15]));
		ins2.push_back(lines[i][17][0]);
		atom2.push_back(lines[i][19]);
		val.push_back(str_to_double(lines[i][21]));
		sigma.push_back(str_to_double(lines[i][23]));
	}

  return;
}

void Restraints::view()
{	
	for(unsigned int i=0; i<res1.size(); i++){
		cout << endl
		<< res1[i] << "\t"
		<< ins1[i] << "\t"
		<< atom1[i] << "\t"
		<< res2[i] << "\t"
		<< ins2[i] << "\t"
		<< atom2[i] << "\t"
		<< val[i] << "\t"
		<< sigma[i];
	}
	
  return;
}
