//
// This file is part of ProSMART.
//

#ifndef prosmartClass_Transform_H
#define prosmartClass_Transform_H

#include "prosmartClass_Coords.h"

extern bool USE_SIEVE;
extern double SIEVE_PARAMETER;

struct quarternion
{  
  double q1;
  double q2;
  double q3;
	double q4;
};

//flexible class to store info about translational and rotational components of coordinate matrices.
class Transform
{
  private:
	coord translate;
	Array2D<double> rotate;
	coord post_translate;
	coord final_translation;		// = post_translate - translate*rotate
                                    //corresponds to rotate then translate
  public:
	void create();
	void create(coord, Array2D<double>);
	void create(Coords &, Coords &, coord &, coord &);
	void create(coord);
	void create(coord, Array2D<double>,coord);
	void create(coord,coord);
    void create_diff(Transform &, Transform &);
	Coords transform(Coords&);
	coord transform(coord);
    void apply(Transform &);
	Coords pre_translate(Coords&);  // formulation: (X+t)R
	coord& get_t();                 // formulation: (X-t)R+p with t=E(X)
	coord& get_p();
	coord& get_f();                 // formulation: XR + t
    coord get_pre();                // formulation: (X+t)R
	Array2D<double>& get_r();
    double get_r_angle();
    double get_r_axis_angle(coord &, coord &, double &);
	void set_r(Array2D<double> &);
	void set_r(Array2D<double> &,coord);
	void set_r_90();
};

void initialise_reflectM();			//critically important - these must be executed at the beginning of the program.
void initialise_identityM();		//otherwise rotateM/get_transf functions will not work!
Array2D<double> get_identityM();

double transdist(Coords&,Coords&);
Array2D<double> rotateM(Coords&,Coords&);
Array2D<double> rotateM(Array2D<double> &);
vector<Transform> coord_transf(vector<Coords> &);
vector<unsigned int> sieve_fit(Coords &, Coords &);
Transform get_transf(Coords, Coords);
Transform get_transf(Coords, Coords, Array2D<double>&);
vector<quarternion> get_quarternions(vector<Array2D<double> > &);
quarternion average_quarternion(vector<quarternion> &, vector<int> &);
quarternion average_quarternion(vector<quarternion> &);
vector<quarternion> get_average_quarternions(vector<quarternion> &, vector<vector<int> > &);
Array2D<double> get_rot_from_quart_single(quarternion &);
vector<Array2D<double> > get_rot_from_quart(vector<quarternion> &);
quarternion multiply_quarternions(quarternion &, quarternion &);
quarternion multiply_quarternion_conj(quarternion &, quarternion &);
Transform get_average_transformation(vector<Transform> &);

ostream& operator<<(ostream&, Transform&);

#endif
