//
// This file is part of ProSMART.
//

#ifndef prosmart_external_programs_H
#define prosmart_external_programs_H

#include "prosmart_file_management.h"
#include "prosmart_align_tools.h"
#include "prosmart_pdb_tools.h"
#include "jama_eig.h"

#define TROUBLESHOOT_RESTRAINTS_FILES

struct alignment
{  
  string res1;
  string res2;
  double central;
  double minimum;
  double rmsd;
  double av;
};

vector<alignment> read_alignment(string &);

vector<vector<string> > get_concensus_alignment(Array2D<vector<res_alignment> > &, vector<res_alignment> &);
vector<vector<string> > get_extended_concensus_alignment(Array2D<vector<res_alignment> > &, vector<res_alignment> &);
Array2D<PDBfile> get_aligned_pdbs(string &, vector<string> &, vector<string> &, Array2D<vector<res_alignment> > &);
void filter_pdb(PDBfile &, vector<res_alignment> &, vector<res_corresp> &, unsigned int);
void ensure_consensus(PDBfile &, PDBfile &);
void ensure_consensus(Array2D<PDBfile> &, Array2D<Coords> &);
Array2D<PDBfile> get_concensus_pdbs(string &, vector<string> &, vector<string> &, vector<vector<string> > &, bool);
void write_pymol_concensus(string &, string &, string &, string &, PDBfile &, PDBfile &);
void write_pymol_concensus(vector<string> &, vector<string> &, vector<string> &, Array2D<PDBfile> &);
void write_pymol_concensus(string, vector<string> &, vector<string> &, vector<PDBfile> &);

void write_pymol_concensus(string, vector<string> &, vector<string> &, vector<vector<string> > &);
void output_pymol_residues(string, vector<string> &, vector<string> &, vector<vector<string> > &, vector<double> &, double);
void apply_side_flips(vector<pdbline> &, vector<pdbline> &, string, string);
void apply_side_flips(vector<pdbline> &, vector<pdbline> &, string, string, string, string);
Array2D<Coords> get_coord_m(Array2D<PDBfile> &, bool, bool);
vector<coord> identify_translations(Array2D<Coords> &);
vector<Transform> multiple_structure_superposition1(Array2D<Coords> &, vector<coord> &);
vector<Transform> multiple_structure_superposition1(vector<PDBfile> &, vector<string> &, vector<string> &);
vector<Transform> multiple_structure_superposition2(vector<PDBfile> &, vector<string> &, vector<string> &);
vector<Transform> multiple_structure_superposition3(vector<PDBfile> &, vector<string> &, vector<string> &);
void output_pdb(vector<string> &, string &, string &, char, Transform &, bool, bool);
double multiple_structure_iteration(vector<Coords> &, vector<Transform> &);
void multiple_structure_scoring(vector<string> &, vector<PDBfile> &, vector<Transform> &);

void output_pairwise_superpositions(Array2D<Coords> &, vector<PDBfile> &);

vector<alignment> filter_res_alignment(vector<alignment> &, double, double);
void multiple_sidechain(vector<vector<int> > &, vector<vector<alignment> > &, vector<string> &, string &);
vector<vector<double> > write_scores(string&, vector<string> &, vector<string> &, vector<string> &, vector<string> &, string &, string &, bool);
void write_scores_allonall(string&, vector<string> &, vector<string> &, string &, string &);
void write_scores_triangular(string&, vector<string> &, vector<string> &, string &, string &);
void global_score_coloring(coord &, coord &);
void write_matrix(string&, string, vector<vector<string> > &, vector<string> &, vector<string> &, double, double, bool);
void write_matrix_all_on_all(string&, string, vector<vector<string> > &, vector<string> &, double, double, bool, double);
void write_matrix_triangular(string&, string, vector<vector<string> > &, vector<string> &, double, double, bool, double);
void write_matrix_triangular_SI(string&, string, vector<vector<string> > &, vector<string> &, double, double, bool, double, vector<vector<string> > &);
void write_residue_type(string &, string &, vector<res_alignment> &);
vector<string> write_restraints(vector<string> &, vector<string> &, vector<string> &, vector<string> &, vector<vector<int> > &, string &, string, string &, string &, bool, vector<string> &, bool);
vector<vector<string> > write_restraints_chain2(vector<string> &, vector<string> &, vector<string> &, vector<string> &, vector<vector<int> > &, string &, string, string &, string &, bool);
void write_restraints_generic(vector<vector<string> > &, vector<string>, string &, string &, string &, bool, bool);
void output_stylesheet(string &, string &);

void analyse_pairwise_results(Array2D<vector<vector<string> > > &, vector<string> &, vector<string> &);
void filter_core(Array2D<vector<string> > &, Array2D<vector<double> > &, unsigned int &, vector<bool> &, vector<unsigned int> &, vector<unsigned int> &);


#endif
