//
// This file is part of ProSMART.
//

#ifndef prosmart_flags_H
#define prosmart_flags_H

#if defined(__WIN32__) || defined(_WIN32)

#define WINDOWS
#define WNOHANG 0
#define SLASH "\\"
#define ALIGN_EXEC "prosmart_align.exe"
#define RESTRAIN_EXEC "prosmart_restrain.exe"

#else

#define SLASH "/"
#define ALIGN_EXEC "prosmart_align"
#define RESTRAIN_EXEC "prosmart_restrain"

#endif


//#define PERFORMANCE
//#define ONLY_OUTPUT_SEQUENCE_FILES

//#define TROUBLESHOOT_RESTRAIN

/////////////////
//General Options

//displays info and writes files
//#define OUTPUT_LOWOCCUP_ALT_COMPLETE_FILES

//displays extra scores in pairwise global scores files
//#define EXTRA_GLOBAL_SCORES

//include completeness columns in residue alignment files
//#define OUTPUT_RESIDUE_COMPLETENESS

//include number of atoms greater than 1A
//#define INCLUDE_SCORE_NUMDIST

//calculate ASA
//#define RUN_AREAIMOL

//output concensus alignment used for multiple superposition
//#define OUTPUT_CONCENSUS_PYMOL

//allow side chains to be flipped when doing multiple structure superposition
#define APPLY_SIDE_FLIPS_MULTIPLE

//method used for multiple structure superposition (default is to use mean)
//#define GENERALISED_PROCRUSTES_BRUTE_FORCE
//#define GENERALISED_PROCRUSTES_UPDATE_ROTATIONS

//#define OUTPUT_JS_FILES


/////////////////
//Special Options

//this forces first cluster to be used as multiple superposition filter - need better approach
//#define FILTER_CLUSTERS_FOR_MULTIPLE

//#define CYRUS_PROJECT
#ifdef CYRUS_PROJECT
#define PERFORM_MULTIPLE_SUPERPOSITION
#define SIDE_SCORES_GLOBAL_COORD_FRAME
#define EXTRA_GLOBAL_SCORES
#define INCLUDE_SCORE_NUMDIST
#define INCLUDE_SCORE_NUMTOTAL
#define RUN_AREAIMOL
#define OUTPUT_CONCENSUS_PYMOL
//#define CYRUS_SPECIAL_RMSD_FORMAT //only display atoms >1A in _rmsd.txt files.
#define APPLY_SIDE_FLIPS_MULTIPLE
#define USE_ALL_RESIDUES_ATOMS_FOR_SCORING

#define OVERWRITE_MAXDIST_NDIST_SCORES

//#define REQUIRE_ONLY_N_SEQID
#define ANALYSE_PAIRWISE_RESULTS
#endif

//for david:
//#define SIDE_SCORES_ORIG_COORD_FRAME

#endif
