//
// This file is part of ProSMART.
//

#ifndef prosmart_params_H
#define prosmart_params_H

#include "prosmart_file_management.h"
#include "prosmart_pdb_tools.h"
#ifdef HAVE_CONFIG_H // using automake
#include <config.h>
#else                // using prosmart makefile
#include "../config.h"
#endif


struct params
{
    bool ALIGN;
    bool RESTRAIN;
    string CLUSTER;
    bool ALL_ON_ALL;
	bool TRIANGULAR;
    int MAX_THREADS;
    bool NMR;
    int NMR_TARGET;
	int MAX_FRAG_LEN;
	string error_file;
	string output_dir;
	vector<string> filenames1;
    vector<string> filenames2;
	vector<string> chains1;
    vector<string> chains2;
	vector<bool> protein_or_dnarna1;
	vector<bool> protein_or_dnarna2;
	string new_chain;
	string BIN_DIR;
	string LIB_DIR;
	string align_location;
	string restrain_location;
	vector<string> lib_fraglen;
	vector<string> lib_score;
	vector<vector<string> > config;
	string library_config;
	string OVERRIDE_LIB_SCORE;
	string OVERRIDE_LIB_FRAGLEN;
    string INPUT_DIR;
    string WORKING_DIRECTORY;
    string ALIGN_dir;
    string TRANS_dir;
    string PDB_dir;
    string PYMOL_dir;
    string INPUTCHAINS_dir;
    bool MERGE_CHAINS;
   double OCCUPANCY_THRESHOLD;
   string SCORE_STRICT;
    
    string HELIX;
	string HELIX_ONLY;
	string STRAND_ONLY;
    string IDENTICAL;
    
	//Colours:
	string G1;
	string G2;
	string G3;
	string R1;
	string R2;
	string R3;
	
	//Align Parameters
    string ALIGN_MODE;
    string FRAG_LEN;
    string SCORE_THRESHOLD;
    string SUPERPOSE;
   string SUPERPOSE_SIDE;
    string HELIX_CUTOFF;
    string HELIX_PENALTY;
    string EXTRA_REFINEMENT;
    string DISPLAY_AS_COSINE_DISTANCE;
    string USE_MAINCHAIN_FOR_SIDERMSD;
    string NUM_DIST_THRESHOLD;
    string FIX_SIDE_CHAIN_ERRORS;
    string NO_REWARD_SEQ;
    string REWARD_SEQ;

	string CLUSTER_SCORE;
	string CLUSTER_DEGREES;
	string CLUSTER_MIN;
	string CLUSTER_LINKAGE;
	string CLUSTER_TRANS_LINKAGE;
	string CLUSTER_TRANS_MAX;
	string CLUSTER_RIGIDITY;
	string CLUSTER_COLOR;
	string OUTPUT_CLUSTER_DM;
    
    string OUT_PDB;
    string OUT_PDB_FULL;
	string OUT_COLOR;
    string ALIGN_SCORE;     // -colour_score
    string SIDE_SCORE;      // -colour_side
   string OUTPUT_RMSD_FILES;
   string OUTPUT_SCREW;

    bool SEQUENCE_ALIGNMENT;
    int SEQ_MIN;
    double SEQ_RATIO;
    double SEQ_ID;
    double SEQ_ID_MAX;
    
	vector<string> PDB1A;
	vector<string> PDB1B;
	vector<string> CHAIN1A;
	vector<string> CHAIN1B;
	vector<string> RANGE1A;
	vector<string> RANGE1B;
    vector<string> ALIGN_PDB;
    vector<string> ALIGN_CHAIN;
    vector<int> ALIGN_RANGE1;
    vector<int> ALIGN_RANGE2;
    vector<string> ALIGN_RM_PDB;
    vector<string> ALIGN_RM_CHAIN;
    vector<string> ALIGN_RM_RESIDUE;
    
	//Restrain Parameters
    bool GENERIC;
	int RESTRAIN_OPTION;
	int RESTRAIN_TO_SELF;
   double RESTRAIN_SEQID;
   double RESTRAIN_SCORE;
   
    string sphere;
    string sigma;
    string MIN_DISTANCE;
    string score_cutoff;
    string sigma_method;
    string RESTRAIN_SIDE_CUTOFF;
    string RESTRAIN_MULTIPLIER_CUTOFF;
    string SIGMA_WEIGHT;
    string MINIMUM_SIGMA;
    string GET_BONDS;
    string GET_ATOMIC_UNCERTAINTY;
	string REFMAC_NAME;
	string BFAC1;
	string BFAC2;
	string MAINCHAIN_ONLY;
    vector<string> RESTRAIN_PDB;
    vector<string> RESTRAIN_CHAIN;
    vector<int> RESTRAIN_RANGE1;
    vector<int> RESTRAIN_RANGE2;
    vector<string> RESTRAIN_RM_PDB;
    vector<string> RESTRAIN_RM_CHAIN;
    vector<string> RESTRAIN_RM_RESIDUE;
    bool OUTPUT_PDB_CHAIN_RESTRAINTS;
    bool COPY_FINAL_RESTRAINTS_FILES;
    string TYPE;
    
    //Generic restraints (e.g. for hydrogen bonds)
    bool HBOND_RESTRAINTS;
    double HBOND_DIST;
    double HBOND_DIST_MAX;
    double HBOND_DIST_MIN;
    int MIN_SEP;
    int MAX_SEP;
    vector<int> ALLOW_SEP;
    vector<int> RM_SEP;
    int HBOND_OPTIONS;
    int OVERRIDE_MAX_BONDS;
    bool STRICT_FRAG;
    
    //Internal generic restraints options
    bool H_HELIX;
    bool H_HELIX_3;
    bool H_HELIX_4;
    bool H_HELIX_5;
    bool H_SHEET;
    bool FORCE_OPTIONS;
    bool FORCE_MIN_SEP;
    bool FORCE_ALLOW_SEP;
    vector<string> H_FILENAMES;
    
    //Troubleshooting Flags
    bool TROUBLESHOOT_RESTRAINT_FILES;
    bool TROUBLESHOOT_HBOND_RESTRAINTS;
};

void set_params(params &);
void print_header();
vector<string> get_args(char *[], int, params &);
void read_args(vector<string> &, params &);

void set_hbond_parameters(params &);
void write_hbond_parameters_file(params &, string &);

void param_validation(vector<string> &, params &);
bool get_filenames(params &);
bool combine_chains(params &);
void combine_chains(vector<string> &, vector<string> &, string &, string);
bool get_binaries(params &);
bool param_validation2(params &);
bool check_for_replication(params &);
void print_parameters(params &, string &);

string get_restraints_range(params &, int);
string get_restraints_range_rm(params &, int);

//single arguments:
template<class T1, class T2> 
bool read_args(vector<string> &, unsigned int &, const char *, T1 &, T2);
template<class T1, class T2, class T3, class T4> 
bool read_args(vector<string> &, unsigned int &, const char *, T1 &, T2, T3 &, T4);
template<class T1, class T2, class T3, class T4, class T5, class T6> 
bool read_args(vector<string> &, unsigned int &, const char *, T1&, T2, T3&, T4, T5&, T6);

//arguments requiring subsequent input:
template<class T1> 
bool read_args(string &, vector<string> &, unsigned int &, const char *, T1 &);
template<class T1> 
bool read_args(string &, vector<string> &, unsigned int &, const char *, T1&, T1&, T1&);
template<class T1>
bool read_args_signed(vector<string> &, unsigned int &, const char *, T1 &);
template<class T1> 
bool read_args_double(string &, vector<string> &, unsigned int &, const char *, T1 &);
template<class T1> 
bool read_args_int(string &, vector<string> &, unsigned int &, const char *, T1 &);
template<class T1> 
bool read_args_v_int(string &, vector<string> &, unsigned int &, const char *, vector<T1> &);


template<class T1, class T2> 
bool read_args(vector<string> &args, unsigned int &i, const char *arg, T1 &x1, T2 y1)
{
    if(args[i] == arg){
        x1 = y1;
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1, class T2, class T3, class T4> 
bool read_args(vector<string> &args, unsigned int &i, const char *arg, T1 &x1, T2 y1, T3 &x2, T4 y2)
{
    if(args[i] == arg){
        x1 = y1;
        x2 = y2;
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1, class T2, class T3, class T4, class T5, class T6> 
bool read_args(vector<string> &args, unsigned int &i, const char *arg, T1 &x1, T2 y1, T3 &x2, T4 y2, T5 &x3, T6 y3)
{
    if(args[i] == arg){
        x1 = y1;
        x2 = y2;
        x3 = y3;
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args(string &error_file, vector<string> &args, unsigned int &i, const char *arg, T1 &x1)
{
    if(args[i] == arg){
        if(args[i+1][0] == '-'){
            xml_entry(error_file,0,0,args[i]);
            cout << endl << "Invalid Syntax: " << args[i] << " not specified. Program terminated." << endl; 
            exit(-1);
        }
        x1 = args[i+1];
        args.erase(args.begin()+i+1);
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args(string &error_file, vector<string> &args, unsigned int &i, const char *arg, T1 &x1, T1 &x2, T1 &x3)
{
    if(args[i] == arg){
        if(args[i+1][0] == '-'){
            xml_entry(error_file,0,0,args[i]);
            cout << endl << "Invalid Syntax: " << args[i] << " not specified. Program terminated." << endl; 
            exit(-1);
        }
        x1 = args[i+1];
        x2 = args[i+2];
        x3 = args[i+3];
        args.erase(args.begin()+i+3);
        args.erase(args.begin()+i+2);
        args.erase(args.begin()+i+1);
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args_signed(vector<string> &args, unsigned int &i, const char *arg, T1 &x1)
{
    if(args[i] == arg){
        x1 = args[i+1];
        args.erase(args.begin()+i+1);
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args_double(string &error_file, vector<string> &args, unsigned int &i, const char *arg, T1 &x1)
{
    if(args[i] == arg){
        if(args[i+1][0] == '-'){
            xml_entry(error_file,0,0,args[i]);
            cout << endl << "Invalid Syntax: " << args[i] << " not specified. Program terminated." << endl; 
            exit(-1);
        }
        x1 = str_to_double(args[i+1]);
        args.erase(args.begin()+i+1);
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args_int(string &error_file, vector<string> &args, unsigned int &i, const char *arg, T1 &x1)
{
    if(args[i] == arg){
        if(args[i+1][0] == '-'){
            xml_entry(error_file,0,0,args[i]);
            cout << endl << "Invalid Syntax: " << args[i] << " not specified. Program terminated." << endl; 
            exit(-1);
        }
        x1 = str_to_int(args[i+1]);
        args.erase(args.begin()+i+1);
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}

template<class T1> 
bool read_args_v_int(string &error_file, vector<string> &args, unsigned int &i, const char *arg, vector<T1> &x1)
{
    if(args[i] == arg){
        if(args[i+1][0] == '-'){
            xml_entry(error_file,0,0,args[i]);
            cout << endl << "Invalid Syntax: " << args[i] << " not specified. Program terminated." << endl; 
            exit(-1);
        }
        while(args.size()>i+1){
            x1.push_back(str_to_int(args[i+1]));
            args.erase(args.begin()+i+1);
            if(args[i+1][0] == '-')break;
        }
        args.erase(args.begin()+i);
        i--;
        return 1;
    }
    return 0;
}
        

#endif
