//
// This file is part of ProSMART.
//

#include "prosmart_results.h"

void write_html(string &error_file, string &fileout, bool USE_SSE, string HELIX_ONLY, string STRAND_ONLY, string CLUSTER, bool ALIGN, bool RESTRAIN, bool ALIGN_MULTI, bool START, bool OUT_PDB, bool OUT_COLOR, string HTML_DIR, string &OUT_DIR)
{
	bool SSE = 0;
	if(USE_SSE==1 || HELIX_ONLY=="1" || STRAND_ONLY=="1"){SSE = 1;}
	
	ofstream outfile;
  outfile.open(fileout.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		
		<< "function loadIframe(iframeName, url, title) {" << endl
		<< "window.frames[iframeName].location = url;" << endl
		<< "document.getElementById('iframe_title').innerHTML = title;}" << endl
		
		
		<< "function change_parent_url(url){document.location=url;}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "h1{font-size:2.5em; margin-bottom:0em;}" << endl
		<< "ul{margin-top:0em; line-height:1.4em; list-style-type:square;}" << endl
        << "a{color:blue}" << endl
		<< "li{color:blue}" << endl
		<< "li.grey{color:grey}" << endl
		<< "b.grey{color:grey}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl
		<< "<h1> ProSMART&nbsp;Results" << endl
		<< "<span style=\"font-weight:normal;font-size:0.3em\">"
		<< "Completed:&nbsp;" << get_time() <<"</span>" << endl;
		outfile << "<p style=\"font-weight:normal;font-size:0.3em;margin-top:0em;\">" << endl
		<< "Procrustes&nbsp;Structural&nbsp;Matching&nbsp;Alignment&nbsp;&&nbsp;Restraints&nbsp;Tool</p>" << endl
		<< "</h1>" << endl;
		
		outfile << "<table width='100%' height='80%' border='0'>" << endl
		<< "<col align='left' width='40em'/>" << endl
		<< "<col align='left' width='100%'/>" << endl
		<< "<tr valign='top'>" << endl;
		
		outfile << "<td>" << endl;
		
		outfile << "<b>Runtime&nbsp;Info</b>" << endl
		<< "<ul type=\"square\">" << endl;
		outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
		<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "parameters.html','');\">" << endl
		<< "Input&nbsp;Parameters</li>" << endl;
		if(ALIGN==1){
			outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
			<< "onclick=\"loadIframe('obj1','prosmart_align_logfile.txt','Source:&nbsp;&nbsp;" << windows_double_slash(OUT_DIR) << "prosmart_align_logfile.txt');\">" << endl
			<< "ProSMART&nbsp;Align&nbsp;Log</li>" << endl;
		} else {
			outfile << "<li class='grey'>ProSMART&nbsp;Align&nbsp;Log</li>" << endl;
		}
		if(RESTRAIN==1){
			outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
			<< "onclick=\"loadIframe('obj1','prosmart_restrain_logfile.txt','Source:&nbsp;&nbsp;" << windows_double_slash(OUT_DIR) << "prosmart_restrain_logfile.txt');\">" << endl
			<< "ProSMART&nbsp;Restrain&nbsp;Log</li>" << endl;
		} else {
			outfile << "<li class='grey'>ProSMART&nbsp;Restrain&nbsp;Log</li>" << endl;
		}
		if(error_file.size()>0){
			outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
#ifdef WINDOWS
			<< "onclick=\"loadIframe('obj1','" << get_full_filename(error_file) << "','Source:&nbsp;&nbsp;" << windows_double_slash(error_file) << "');\">" << endl
#else
			<< "onclick=\"loadIframe('obj1','" << HTML_DIR << get_full_filename(error_file) << "','Source:&nbsp;&nbsp;" << error_file << "');\">" << endl
#endif
			<< "XML&nbsp;Log</li>" << endl;
		} else {
			outfile << "<li class='grey'>XML&nbsp;Log</li>" << endl;
		}
		outfile << "</ul>" << endl;
		
		
		if(ALIGN==1 && START==1){
			outfile	<< "<b>Residue&nbsp;Alignment/Scores</b>" << endl
			<< "<ul type=\"square\">" << endl;
			outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
			<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "pairwise.html','');\">" << endl
			<< "Pairwise</li>" << endl;
			if(USE_SSE==1){
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "ssetype.html','');\">" << endl
				<< "Fragment&nbsp;Type</li>" << endl;
			} else {
				outfile << "<li class='grey'>Fragment&nbsp;Type</li>" << endl;
			}
			if(SSE==1){
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "frag_score.html','');\">" << endl
				<< "Fragment&nbsp;Scores</li>" << endl;
			} else {
				outfile << "<li class='grey'>Fragment&nbsp;Scores</li>" << endl;
			}
			outfile << "</ul>" << endl;
			
			if(SSE==0){
				outfile	<< "<b>Global&nbsp;Scores</b>" << endl
				<< "<ul type=\"square\">" << endl;
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "scores.html','');\">" << endl
				<< "Pairwise</li>" << endl;
				if(ALIGN_MULTI==1){
					outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
					<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "scores_multi.html','');\">" << endl
					<< "Multiple</li>" << endl;
				} else {
					outfile << "<li class='grey'>Multiple</li>" << endl;
				}
				outfile << "</ul>" << endl;
			} else {
				outfile	<< "<b class='grey'>Global&nbsp;Scores</b>" << endl
				<< "<ul type=\"square\">" << endl
				<< "<li class='grey'>Pairwise</li>" << endl
				<< "<li class='grey'>Multiple</li>" << endl
				<< "</ul>" << endl;
			}
			
			if(SSE==1 && OUT_PDB==0){
				outfile << "<b class='grey'>Superpositions</b>" << endl;
			} else {
				outfile << "<b>Superpositions</b>" << endl;
			}
			outfile << "<ul type=\"square\">" << endl;
			if(SSE==0){
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "transformations.html','');\">" << endl
				<< "Transformations</li>" << endl;
			} else {
				outfile << "<li class='grey'>Transformations</li>" << endl;
			}
			if(OUT_PDB==1){
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "pdb.html','');\">" << endl
				<< "PDB&nbsp;Files</li>" << endl;
			} else {
				outfile << "<li class='grey'>PDB&nbsp;Files</li>" << endl;
			}
			outfile << "</ul>" << endl;
			
			if(OUT_COLOR==1){
				outfile << "<b>Colour&nbsp;Scripts</b>"
				<< "<ul type=\"square\">" << endl;
				if(SSE==1){
					outfile << "<li class='grey'>Pairwise</li>" << endl;
					outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
					<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "pymol.html','');\">" << endl
					<< "Fragment&nbsp;Scores</li>" << endl;
				} else {
					outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
					<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "pymol.html','');\">" << endl
					<< "Pairwise</li>" << endl
					<< "<li class='grey'>Fragment&nbsp;Scores</li>" << endl;
				}
				outfile << "</ul>" << endl;
			} else {
				outfile << "<b class='grey'>Colour&nbsp;Scripts</b>" << endl
				<< "<ul type=\"square\">" << endl
				<< "<li class='grey'>Pairwise</li>" << endl
				<< "<li class='grey'>Fragment&nbsp;Scores</li>" << endl
				<< "</ul>" << endl;
			}
			
		} else {
			outfile << "<b class='grey'>Residue&nbsp;Alignment/Scores</b>" << endl
			<< "<ul type=\"square\">" << endl
			<< "<li class='grey'>Pairwise</li>" << endl
			<< "<li class='grey'>Fragment&nbsp;Type</li>" << endl
			<< "<li class='grey'>Fragment&nbsp;Scores</li>" << endl
			<< "</ul>" << endl;
			
			outfile	<< "<b class='grey'>Global&nbsp;Scores</b>" << endl
			<< "<ul type=\"square\">" << endl
			<< "<li class='grey'>Pairwise</li>" << endl
			<< "<li class='grey'>Multiple</li>" << endl
			<< "</ul>" << endl;
			
			outfile << "<b class='grey'>Superpositions</b>"
			<< "<ul type=\"square\">" << endl
			<< "<li class='grey'>Transformations</li>" << endl
			<< "<li class='grey'>PDB&nbsp;Files</li>" << endl
			<< "</ul>" << endl;
			
			outfile << "<b class='grey'>Colour&nbsp;Scripts</b>"
			<< "<ul type=\"square\">" << endl
			<< "<li class='grey'>Pairwise</li>" << endl
			<< "<li class='grey'>Fragment&nbsp;Scores</li>" << endl
			<< "</ul>" << endl;
		}
		
		if(RESTRAIN==1 && START==1){
			outfile << "<b>Atomic&nbsp;Bond&nbsp;Restraints</b>" << endl
			<< "<ul type=\"square\">" << endl;
			if(SSE==1){
				outfile << "<li class='grey'>External&nbsp;Structure</li>" << endl;
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "restrain.html','');\">" << endl
				<< "Fragment</li>" << endl;
			} else {
				outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
				<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "restrain.html','');\">" << endl
				<< "External&nbsp;Structure</li>" << endl;
				outfile << "<li class='grey'>Fragment</li>" << endl;
			}
			outfile << "</ul>" << endl;
		} else {
			outfile << "<b class='grey'>Atomic&nbsp;Bond&nbsp;Restraints</b>" << endl
			<< "<ul type=\"square\">" << endl
			<< "<li class='grey'>External&nbsp;Structure</li>" << endl;
			outfile << "<li class='grey'>Fragment</li>" << endl;
			outfile << "</ul>" << endl;
		}
		
		
		outfile << "<b>Other</b>"
		<< "<ul type=\"square\">" << endl;
		
		if(ALIGN==1 && START==1){
			outfile << "<li onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
			<< "onclick=\"loadIframe('obj1','" << HTML_DIR << "sequence.html','');\">" << endl
			<< "Sequence</li>" << endl;
		} else {
			outfile << "<li class='grey'>Sequence</li>" << endl;
		}
        outfile << "<li><a onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
        << "href=\"http://www2.mrc-lmb.cam.ac.uk/groups/murshudov/\" target=\"_blank\">" << endl
        << "ProSMART&nbsp;Webpage</a></li>" << endl;
      
		outfile << "</ul>" << endl;	
		
		
		outfile << "</td>" << endl;
		
		outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='" << HTML_DIR << "message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }	
	
  return;	
}

void write_html_parameters(string fileout_parameters, params &PARAMS, string &outputdirectory)
{
	ofstream outfile;
	outfile.open(fileout_parameters.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "ol{list-style-type:none; font-size:80%;margin-bottom:0.5em;}" << endl
		<< "ul{list-style-type:none;margin-top:0.5em;}" << endl
		<< "p{font-size:80%;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<b>Execution&nbsp;Info:</b>" << endl;
		outfile << "<ul><table border=\"0\">" << endl
		<< "<col align='left' width='200'/>" << endl
		<< "<col align='left' />" << endl;
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Align&nbsp;Chains</td>";
		if(PARAMS.ALIGN==1){
			outfile << "<td><ol><li>Yes</li></ol></td>";
		} else {
			outfile << "<td><ol><li>No</li></ol></td>";
		}
		outfile << "</tr>";
		
		if(PARAMS.ALIGN==1){
			outfile << "<tr valign='top'>" << endl
			<< "<td>All-On-All</td>";
			if(PARAMS.ALL_ON_ALL==1){
				outfile << "<td><ol><li>Yes</li></ol></td>";
			} else {
				outfile << "<td><ol><li>No</li></ol></td>";
			}
			outfile << "</tr>";
		}
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Generate&nbsp;Restraints</td>";
		if(PARAMS.RESTRAIN==1){
			outfile << "<td><ol><li>Yes</li></ol></td>";
		} else {
			outfile << "<td><ol><li>No</li></ol></td>";
		}
		outfile << "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Use&nbsp;Fragment&nbsp;Library</td>";
		if(PARAMS.HELIX=="1"){
			outfile << "<td><ol><li>Yes";
			if(PARAMS.HELIX_ONLY=="1"){
				outfile << ", helix only";
			} else if(PARAMS.STRAND_ONLY=="1"){
				outfile << ", strand only";
			}
			outfile << "</li></ol></td>";
		} else {
			outfile << "<td><ol><li>No</li></ol></td>";
		}
		outfile << "</tr>";
		
		if(PARAMS.ALIGN==1){
			outfile << "<tr valign='top'>" << endl
			<< "<td>Output&nbsp;Superposed&nbsp;PDBs</td>"
			<< "<td><ol><li>";
			if(PARAMS.OUT_PDB=="0"){
				outfile << "No";
			} else {
				outfile << "Yes";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Output&nbsp;Colour&nbsp;Scripts</td>"
			<< "<td><ol><li>";
			if(PARAMS.OUT_COLOR=="0"){
				outfile << "No";
			} else {
				outfile << "Yes";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
		}
		
		outfile << "</table></ul>";
		
		//////////////////////
		
		outfile << "<b>Input&nbsp;Files:</b>" << endl;
		outfile << "<ul><table border=\"0\">" << endl
		<< "<col align='left' width='200'/>" << endl
		<< "<col align='left' />" << endl;
		
		outfile << "<tr valign='top'>" << endl;
		outfile << endl << "<td>Target&nbsp;Chain";
		if(PARAMS.filenames1.size()>1){outfile << "s";}
		outfile << "</td>";
		outfile << "<td><ol>";
		for(unsigned int i=0; i<PARAMS.filenames1.size(); i++){
			outfile << endl << "<li>" << PARAMS.filenames1[i] << "&nbsp;&nbsp;" << PARAMS.chains1[i] << "</li>";
		}
		outfile << "</ol></td>";
		outfile << "</tr>";
		
		if(PARAMS.ALL_ON_ALL==0){
			outfile << "<tr valign='top'>";
			outfile << endl << "<td>Secondary&nbsp;Chain";
			if(PARAMS.filenames2.size()>1){outfile << "s";}
			outfile << "</td>";
			outfile << "<td><ol>";
			for(unsigned int i=0; i<PARAMS.filenames2.size(); i++){
				outfile << endl << "<li>" << PARAMS.filenames2[i] << "&nbsp;&nbsp;" << PARAMS.chains2[i] << "</li>";
			}
			outfile << "</ol></td>";
			outfile << "</tr>";
		}
		
		outfile << "</table></ul>";
		
		//////////////////////
		
		outfile << "<b>Program&nbsp;Directories:</b>" << endl;
		outfile << "<ul><table border=\"0\">" << endl
		<< "<col align='left' width='200'/>" << endl
		<< "<col align='left' />" << endl;
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Output&nbsp;Directory</td>"
		<< "<td><ol><li>" 
		<< outputdirectory
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Location&nbsp;of&nbsp;Binaries</td>"
		<< "<td><ol><li>" 
		<< PARAMS.BIN_DIR
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Location&nbsp;of&nbsp;Library</td>"
		<< "<td><ol><li>" 
		<< PARAMS.LIB_DIR
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "</table></ul>";
		
		//////////////////////
		
		if(PARAMS.ALIGN==1){
			outfile << "<b>Align&nbsp;Options:</b>" << endl;
			outfile << "<ul><table border=\"0\">" << endl
			<< "<col align='left' width='200'/>" << endl
			<< "<col align='left' />" << endl;
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Alignment&nbsp;Mode</td>"
			<< "<td><ol><li>";
			if(PARAMS.ALIGN_MODE=="0"){
				outfile << "Default";
			} else {
				outfile << PARAMS.ALIGN_MODE;
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Fragment&nbsp;Length</td>"
			<< "<td><ol><li>" 
			<< PARAMS.FRAG_LEN
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Assume&nbsp;Structures&nbsp;Identical</td>"
			<< "<td><ol><li>";
			if(PARAMS.IDENTICAL=="1"){
				outfile << "Yes";
			} else {
				outfile << "No";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Refine&nbsp;Alignment</td>"
			<< "<td><ol><li>";
			if(PARAMS.EXTRA_REFINEMENT=="1"){
				outfile << "Yes";
			} else {
				outfile << "No";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Dynamic&nbsp;Programming&nbsp;Helix&nbsp;Cutoff</td>"
			<< "<td><ol><li>" 
			<< PARAMS.HELIX_CUTOFF
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Dynamic&nbsp;Programming&nbsp;Helix&nbsp;Penalty</td>"
			<< "<td><ol><li>" 
			<< PARAMS.HELIX_PENALTY
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Superposition&nbsp;Score&nbsp;Cutoff</td>"
			<< "<td><ol><li>" 
			<< PARAMS.SUPERPOSE
			<< "</li></ol></td>"
			<< "</tr>";
			
			if(PARAMS.OUT_COLOR=="1"){
				outfile << "<tr valign='top'>" << endl
				<< "<td>Colour&nbsp;Resolution&nbsp;Score&nbsp;Cutoff</td>"
				<< "<td><ol><li>" 
				<< PARAMS.ALIGN_SCORE
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Colour&nbsp;Resolution&nbsp;Sidechain&nbsp;Cutoff</td>"
				<< "<td><ol><li>" 
				<< PARAMS.SIDE_SCORE
				<< "</li></ol></td>"
				<< "</tr>";
			}
			
			if(PARAMS.CLUSTER=="0"){
			
				outfile << "<tr valign='top'>" << endl
				<< "<td>Identify&nbsp;Rigid&nbsp;Substructures</td>"
				<< "<td><ol><li>"
				<< "No"
				<< "</li></ol></td>"
				<< "</tr>";
			
			} else {
				
				outfile << "</ul><ul></table><table border=\"0\">" << endl
				<< "<col align='left' width='200'/>" << endl
				<< "<col align='left' />" << endl;
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Identify&nbsp;Rigid&nbsp;Substructures</td>"
				<< "<td><ol><li>"
				<< "Yes"
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Procrustes&nbsp;Score&nbsp;Cutoff</td>"
				<< "<td><ol><li>" 
				<< PARAMS.CLUSTER_SCORE
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Intrafragment&nbsp;Rotation&nbsp;Score&nbsp;Cutoff</td>"
				<< "<td><ol><li>" 
				<< PARAMS.CLUSTER_DEGREES
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Minimum&nbsp;Fragments&nbsp;In&nbsp;Cluster</td>"
				<< "<td><ol><li>"
				<< PARAMS.CLUSTER_MIN
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Single&nbsp;Linkage&nbsp;Clustering&nbsp;Cutoff</td>"
				<< "<td><ol><li>" 
				<< PARAMS.CLUSTER_LINKAGE
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Cluster&nbsp;Rigidity&nbsp;Cosine&nbsp;Cutoff</td>"
				<< "<td><ol><li>"
				<< PARAMS.CLUSTER_RIGIDITY
				<< "</li></ol></td>"
				<< "</tr>";
				
				outfile << "<tr valign='top'>" << endl
				<< "<td>Cluster&nbsp;Colour&nbsp;Resolution</td>"
				<< "<td><ol><li>"
				<< PARAMS.CLUSTER_COLOR
				<< "</li></ol></td>"
				<< "</tr>";
				
			}
			
			outfile << "</table></ul>";
		}
		
		//////////////////////
		
		if(PARAMS.RESTRAIN==1){
			outfile << "<b>Restrain&nbsp;Options:</b>" << endl;
			outfile << "<ul><table border=\"0\">" << endl
			<< "<col align='left' width='200'/>" << endl
			<< "<col align='left' />" << endl;
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Chain&nbsp;Selection</td>"
			<< "<td><ol><li>";
			if(PARAMS.RESTRAIN_OPTION==0){
				outfile << "Only Use Best Chain From Each PDB";
			} else {
				outfile << "Use All Chains";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Include&nbsp;Self-Restraints</td>"
			<< "<td><ol><li>";
			if(PARAMS.RESTRAIN_TO_SELF==0){
				outfile << "No";
			} else {
				outfile << "Yes";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Max&nbsp;Restraint&nbsp;Distance</td>"
			<< "<td><ol><li>" 
			<< PARAMS.sphere
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Min&nbsp;Restraint&nbsp;Distance</td>"
			<< "<td><ol><li>" 
			<< PARAMS.MIN_DISTANCE
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Sigma&nbsp;Estimation&nbsp;Type</td>"
			<< "<td><ol><li>";
			switch(atoi(PARAMS.sigma_method.c_str())){
				case 0: outfile << "Fixed (Use Default)"; break;
				case 1: outfile << "Estimated, Constant"; break;
				case 2: outfile << "Estimated, Distance Dependent"; break;
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Default&nbsp;Sigma</td>"
			<< "<td><ol><li>" 
			<< PARAMS.sigma
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Minimum&nbsp;Sigma</td>"
			<< "<td><ol><li>" 
			<< PARAMS.MINIMUM_SIGMA
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Sigma&nbsp;Multiplier</td>"
			<< "<td><ol><li>" 
			<< PARAMS.RESTRAIN_MULTIPLIER_CUTOFF
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Scale&nbsp;Sigmas&nbsp;By&nbsp;Bfactor</td>"
			<< "<td><ol><li>";
			if(PARAMS.BFAC1 == "1"){
				if(PARAMS.BFAC2 == "1"){
					outfile << "Target and External";
				} else {
					outfile << "Target Only";
				}
			} else if(PARAMS.BFAC2 == "1"){
				outfile << "External Only";
			} else {
				outfile << "No";
			}
			outfile<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Align&nbsp;Score&nbsp;Cutoff</td>"
			<< "<td><ol><li>" 
			<< PARAMS.score_cutoff
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>SideAV&nbsp;Score&nbsp;Cutoff</td>"
			<< "<td><ol><li>" 
			<< PARAMS.RESTRAIN_SIDE_CUTOFF
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Sigma&nbsp;Weight</td>"
			<< "<td><ol><li>" 
			<< PARAMS.SIGMA_WEIGHT
			<< "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Remove&nbsp;Bonds/Angles</td>"
			<< "<td><ol><li>";
			if(PARAMS.GET_BONDS=="1"){
				outfile << "Yes - Uses REFMAC5, exec name: " << PARAMS.REFMAC_NAME;
			} else {
				outfile << "No";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "<tr valign='top'>" << endl
			<< "<td>Generate&nbsp;Restraints&nbsp;For&nbsp;Side&nbsp;Chains</td>"
			<< "<td><ol><li>";
			if(PARAMS.MAINCHAIN_ONLY=="0"){
				outfile << "Yes";
			} else {
				outfile << "No";
			}
			outfile << "</li></ol></td>"
			<< "</tr>";
			
			outfile << "</table></ul>";
		}
		
		//////////////////////
		
		outfile << "<b>Other Options:</b>" << endl;
		outfile << "<ul><table border=\"0\">" << endl
		<< "<col align='left' width='200'/>" << endl
		<< "<col align='left' />" << endl;
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Max&nbsp;Simultaneous&nbsp;Threads</td>"
		<< "<td><ol><li>" 
		<< PARAMS.MAX_THREADS
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Output&nbsp;XML&nbsp;File</td>"
		<< "<td><ol><li>";
		if(PARAMS.error_file.size()>0){
			outfile << PARAMS.error_file;
		} else {
			outfile << "No";
		}
		outfile << "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Rename&nbsp;Chain</td>"
		<< "<td><ol><li>";
		if(PARAMS.new_chain != " "){
			outfile << "Yes";
		} else {
			outfile << "No";
		}
		outfile << "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Similar&nbsp;Colour</td>"
		<< "<td><ol><li style='color:rgb(" << 255*atof(PARAMS.G1.c_str()) << "," << 255*atof(PARAMS.G2.c_str()) << "," << 255*atof(PARAMS.G3.c_str()) << ")'>"
		<< "(" << PARAMS.G1 << ", " << PARAMS.G2 << ", " << PARAMS.G3 << ")"
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "<tr valign='top'>" << endl
		<< "<td>Dissimilar&nbsp;Colour</td>"
		<< "<td><ol><li style='color:rgb(" << 255*atof(PARAMS.R1.c_str()) << "," << 255*atof(PARAMS.R2.c_str()) << "," << 255*atof(PARAMS.R3.c_str()) << ")'>"
		<< "(" << PARAMS.R1 << ", " << PARAMS.R2 << ", " << PARAMS.R3 << ")"
		<< "</li></ol></td>"
		<< "</tr>";
		
		outfile << "</table></ul>";
		
		//////////////////////
		
		outfile << "<p>See documentation for more information</p><br /><br />" << endl;
		
		outfile << "</ul>";
		outfile << "</body>" << endl
		<< "</html>" << endl;
		
		outfile.close();
  } else {
    xml_entry(PARAMS.error_file,0,5,fileout_parameters);
    cout << "Unable to open output file " << fileout_parameters << " for writing" << endl;
  }
	
	return;
}

void write_html_object1(string &error_file, string &fileout, string &dir, vector<string> &selection, vector<string> &filelist, string col_title, string dir2, string dir3)
{
	write_html_object1A(error_file, fileout, dir, selection, filelist, col_title, dir2, dir3, "", "");
  return;	
}

void write_html_object1A(string &error_file, string &fileout, string &dir, vector<string> &selection, vector<string> &filelist, string col_title, string dir2, string dir3, string ext1, string ext2)
{
	ofstream outfile;
  outfile.open(fileout.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		
		<< "function loadIframe(iframeName, url, source_file) {" << endl
		<< "window.frames[iframeName].location = url;" << endl
		<< "document.getElementById('iframe_title').innerHTML = source_file;}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "p.blue{color:blue;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<table width='100%' height='95%' border='0'>" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' width='800' />" << endl;
		
		outfile << "<tr valign='top'>" << endl;
    outfile << "<td align='middle'>" << endl;
		outfile << "<b><small>" << col_title << "</small></b><br />" << endl;
		outfile << "<select size=\"25\" width=\"50\">";
		for(unsigned int i=0; i<selection.size(); i++){
			outfile << "<option ";
			//if(i==0){outfile << "selected=\"selected\" ";}
#ifdef WINDOWS
			outfile << "onclick=\"loadIframe('obj1','" << windows_double_slash(dir) << windows_double_slash(filelist[i]) << ext2 << "','Source:&nbsp;&nbsp;" << windows_double_slash(dir2) << windows_double_slash(filelist[i]) << ext2 << "');\">" << selection[i] << "</option>" << endl;
#else
			outfile << "onclick=\"loadIframe('obj1','" << dir << filelist[i] << ext1 << "','Source:&nbsp;&nbsp;" << dir2 << filelist[i] << ext2 << "');\">" << selection[i] << "</option>" << endl;
#endif
		}
		outfile << "</select>" << endl
		<< "<br>" << endl
		<< "<p class=blue onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
		<< "onclick=\"loadIframe('obj1','" << duplicate_char(dir3,"\\") << "','<br>');\">"
		<< "[Navigate&nbsp;Directory]</p>" << endl
		<< "</td>" << endl;
		
    outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }	
	
  return;	
}

void write_html_object2(string &error_file, string &fileout, string &dir, vector<string> &selection, vector<vector<string> > &filelist, vector<string> &filedir, string dir2, string dir_ext, string ext)
//made for pdb/pymol files
{
	ofstream outfile;
  outfile.open(fileout.c_str());
	
	if(selection.size()==0){
		if(outfile.is_open()){
			outfile << "<html></html>" << endl;
			outfile.close();
		}
		return;
	}
	
  if(outfile.is_open()){
    outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		<< "function doPDB(){" << endl
		<< "var objTag2 = document.getElementById('obj2').value;" << endl
		<< "var objTag3 = document.getElementById('obj3').value;" << endl
#ifdef WINDOWS
        << "var filename = '..\\\\" << dir_ext << "\\\\' + objTag3 + '\\\\' + objTag2 + '." << ext << "';" << endl
#else
        << "var filename = 'tmp/" << dir_ext << "' + objTag3 + '/' + objTag2 + '.txt';" << endl
#endif
      << "document.getElementById('iframe_title').innerHTML = 'Source:&nbsp;&nbsp;" << windows_double_slash(dir2) << "' + objTag3 + '\\\\' + objTag2 + '." << ext << "';" << endl
		<< "window.frames['obj1'].location = filename;}" << endl
		
		<< "function loadIframe(iframeName, url, source_file) {" << endl
		<< "var objTag3 = document.getElementById('obj3').value;" << endl
#ifdef WINDOWS
		<< "window.frames[iframeName].location = url + objTag3 + '\\\\';" << endl
#else
        << "window.frames[iframeName].location = url + objTag3 + '/';" << endl
#endif
		<< "document.getElementById('iframe_title').innerHTML = source_file;}" << endl
		
		<< "function clearSelect(){" << endl
		<< "document.getElementById('obj2').options.length = 0;}" << endl
		
		<< "function clear_iframe(){" << endl
		<< "window.frames['obj1'].location = 'message.html';" << endl
		<< "document.getElementById('iframe_title').innerHTML = '<br>';}" << endl
		
		<< "function appendSelect(val){" << endl
		<< "var elOptNew = document.createElement('option');" << endl
		<< "elOptNew.text = val;" << endl
		<< "elOptNew.value = val;" << endl
		<< "var elSel = document.getElementById('obj2');" << endl
		<< "try{elSel.add(elOptNew, null);}" << endl
		<< "catch(ex){elSel.add(elOptNew);}}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "p.blue{color:blue;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<table width=\"100%\" height=\"95%\" border=\"0\">" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' width='800' />" << endl
		<< "<tr valign='top'>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Chain&nbsp;Pair</small></b><br />" << endl
		<< "<select onclick=\"clear_iframe()\" size='25' width='50' id='obj3'>";
		for(unsigned int i=0; i<filelist.size(); i++){
			outfile << "<option value=\"" << filedir[i] << "\" ";
			if(i==0){outfile << "selected=\"selected\" ";}
			outfile << "onclick=\"clearSelect()";
			for(unsigned int j=0; j<filelist[i].size(); j++){
				outfile << ";appendSelect('" << filelist[i][j] << "')"; 
			}
			outfile	<< "\">" << selection[i] << "</option>" << endl;
		}
		outfile << "</select>" << endl
		<< "<br>" << endl
		<< "<p class=blue onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
		<< "onclick=\"loadIframe('obj1','" << duplicate_char(dir,"\\") << "','<br>');\">"
		<< "[Navigate&nbsp;Directory]</p>" << endl
		<< "</td>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>File</small></b><br />" << endl
		<< "<select onclick=\"doPDB()\" size=\"25\" width=\"50\" id=\"obj2\">" << endl;
		for(unsigned int i=0; i<filelist[0].size(); i++){
			outfile << "<option value=\"" << filelist[0][i] << "\" >" << filelist[0][i] << "</option>" << endl;
		}
		outfile << "</select>" << endl
		<< "</td>" << endl;
		
		outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }
	
  return;	
}

void write_html_object3(string &error_file, string &fileout, vector<vector<string> > &selection, vector<vector<string> > &filelist, vector<string> &select1, string &dir, string &dir2)
//made for restraint files
{
	ofstream outfile;
  outfile.open(fileout.c_str());
	
	if(selection.size()==0){
		if(outfile.is_open()){
			outfile << "<html></html>" << endl;
			outfile.close();
		}
		return;
	}
	
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		<< "function doPDB(){" << endl
		<< "var objTag2 = document.getElementById('obj2').value;" << endl
		<< "var objTag3 = document.getElementById('obj3').value;" << endl
      << "var filename = '" << windows_double_slash(dir) << "' + objTag2;" << endl
      << "document.getElementById('iframe_title').innerHTML = 'Source:&nbsp;&nbsp;" << windows_double_slash(dir2) << "' + objTag2;" << endl
		<< "window.frames['obj1'].location = filename;}" << endl
		
		<< "function loadIframe(iframeName, url, source_file) {" << endl
		<< "window.frames[iframeName].location = url;" << endl
		<< "document.getElementById('iframe_title').innerHTML = source_file;}" << endl
		
		<< "function clearSelect(){" << endl
		<< "document.getElementById('obj2').options.length = 0;}" << endl
		
		<< "function clear_iframe(){" << endl
		<< "window.frames['obj1'].location = 'message.html';" << endl
		<< "document.getElementById('iframe_title').innerHTML = '<br>';}" << endl
		
		<< "function appendSelect(val,val2){" << endl
		<< "var elOptNew = document.createElement('option');" << endl
		<< "elOptNew.text = val;" << endl
		<< "elOptNew.value = val2;" << endl
		<< "var elSel = document.getElementById('obj2');" << endl
		<< "try{elSel.add(elOptNew, null);}" << endl
		<< "catch(ex){elSel.add(elOptNew);}}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "p.blue{color:blue;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<table width=\"100%\" height=\"95%\" border=\"0\">" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' width='800' />" << endl
		<< "<tr valign='top'>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Type</small></b><br />" << endl
		<< "<select onclick=\"clear_iframe()\" size='25' width='50' id='obj3'>";
		for(unsigned int i=0; i<filelist.size(); i++){
			outfile << "<option value=\"" << select1[i] << "\" ";
			if(i==0){outfile << "selected=\"selected\" ";}
			outfile << "onclick=\"clearSelect()";
			for(unsigned int j=0; j<filelist[i].size(); j++){
				outfile << ";appendSelect('" << selection[i][j] << "','" << filelist[i][j] << "')"; 
			}
			outfile	<< "\">" << select1[i] << "</option>" << endl;
		}
		outfile << "</select>" << endl
		<< "<br>" << endl
		<< "<p class=blue onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
      << "onclick=\"loadIframe('obj1','" << windows_double_slash(dir) << "','<br>');\">"
		<< "[Navigate&nbsp;Directory]</p>" << endl
		<< "</td>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Restraints</small></b><br />" << endl
		<< "<select onclick=\"doPDB()\" size=\"25\" width=\"50\" id=\"obj2\">" << endl;
		for(unsigned int i=0; i<filelist[0].size(); i++){
#ifdef WINDOWS
            outfile << "<option value=\"" << half_char(filelist[0][i],"\\") << "\" >" << selection[0][i] << "</option>" << endl;
#else
            outfile << "<option value=\"" << filelist[0][i] << "\" >" << selection[0][i] << "</option>" << endl;
#endif				
		}
		outfile << "</select>" << endl
		<< "</td>" << endl;
		
		outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }
	
  return;	
}

void write_html_object4(string &error_file, string &fileout, string &dir, vector<string> &selection1, vector<string> &selection2, string dir2, string prefix)
//specific to fragment files for scores
{	
	ofstream outfile;
  outfile.open(fileout.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		
		<< "function doPymol(){" << endl
		<< "var objTag2 = document.getElementById('obj2').value;" << endl
		<< "var objTag3 = document.getElementById('obj3').value;" << endl
      << "var filename = '" << windows_double_slash(dir) << "' + objTag3 + '_' + objTag2 + '.txt';" << endl
      << "document.getElementById('iframe_title').innerHTML = 'Source:&nbsp;&nbsp;" << windows_double_slash(dir2) << "' + objTag3 + '_' + objTag2 + '.txt';" << endl
		<< "window.frames['obj1'].location = filename;}" << endl
		
		<< "function loadIframe(iframeName, url, source_file) {" << endl
		<< "window.frames[iframeName].location = url;" << endl
		<< "document.getElementById('iframe_title').innerHTML = source_file;}" << endl
		
		<< "function clearSelect(){" << endl
		<< "document.getElementById('obj2').options.length = 0;}" << endl
		
		<< "function clear_iframe(){" << endl
		<< "window.frames['obj1'].location = 'message.html';" << endl
		<< "document.getElementById('iframe_title').innerHTML = '<br>';}" << endl
		
		<< "function appendSelect(val){" << endl
		<< "var elOptNew = document.createElement('option');" << endl
		<< "elOptNew.text = val;" << endl
		<< "elOptNew.value = val;" << endl
		<< "var elSel = document.getElementById('obj2');" << endl
		<< "try{elSel.add(elOptNew, null);}" << endl
		<< "catch(ex){elSel.add(elOptNew);}}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "p.blue{color:blue}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<table width=\"100%\" height=\"95%\" border=\"0\">" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' width='800' />" << endl
		<< "<tr valign='top'>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Chain</small></b><br />" << endl
		<< "<select onclick='clear_iframe()' size='25' width='50' id='obj3'>";
		for(unsigned int i=0; i<selection1.size(); i++){
			outfile << "<option ";
			if(i==0){outfile << "selected=\"selected\" ";}
			outfile << "onclick=\"clearSelect()";
			for(unsigned int j=0; j<selection2.size(); j++){
				outfile << ";appendSelect('" << selection2[j] << "')"; 
			}
			outfile	<< "\" value='" << selection1[i] << SLASH << prefix << selection1[i] << "'>" << selection1[i] << "</option>" << endl;
		}
		outfile << "</select>" << endl
		<< "<br>" << endl
		<< "<p class=blue onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
      << "onclick=\"loadIframe('obj1','" << windows_double_slash(dir) << "','<br>');\">"
		<< "[Navigate&nbsp;Directory]</p>" << endl
		<< "</td>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Fragment</small></b><br />" << endl
		<< "<select onclick=\"doPymol()\" size=\"25\" width=\"50\" id=\"obj2\">" << endl;
		for(unsigned int i=0; i<selection2.size(); i++){
			outfile << "<option value=\"" << selection2[i] << "\" >" << selection2[i] << "</option>" << endl;
		}
		outfile << "</select>" << endl;
		outfile << "</td>" << endl;
		
    outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }	
	
  return;	
}

/*void write_html_object5(string &error_file, string &fileout, string &dir, vector<string> &selection1, vector<vector<string> > &selection2, vector<vector<string> > &selection2a, string dir2)
//made for restrain files
{
	ofstream outfile;
  outfile.open(fileout.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<head><script language=\"JavaScript\">" << endl
		<< "function doPDB(){" << endl
		<< "var objTag2 = document.getElementById('obj2').value;" << endl
		<< "var objTag3 = document.getElementById('obj3').value;" << endl
		<< "var filename = '" << dir << "' + objTag2;" << endl
		<< "document.getElementById('iframe_title').innerHTML = 'Source:&nbsp;&nbsp;" << dir2 << "' + objTag2;" << endl
		<< "window.frames['obj1'].location = filename;}" << endl
		
		<< "function loadIframe(iframeName, url, source_file) {" << endl
		<< "window.frames[iframeName].location = url;" << endl
		<< "document.getElementById('iframe_title').innerHTML = source_file;}" << endl
		
		<< "function clearSelect(){" << endl
		<< "document.getElementById('obj2').options.length = 0;}" << endl
		
		<< "function clear_iframe(){" << endl
		<< "window.frames['obj1'].location = 'message.html';" << endl
		<< "document.getElementById('iframe_title').innerHTML = '<br>';}" << endl
		
		<< "function appendSelect(val,val2){" << endl
		<< "var elOptNew = document.createElement('option');" << endl
		<< "elOptNew.text = val;" << endl
		<< "elOptNew.value = val2;" << endl
		<< "var elSel = document.getElementById('obj2');" << endl
		<< "try{elSel.add(elOptNew, null);}" << endl
		<< "catch(ex){elSel.add(elOptNew);}}" << endl
		
		<< "</script></head>" << endl;
		
		outfile << "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "p{font-size:70%;}" << endl
		<< "p.it{font-style:italic;}" << endl
		<< "p.blue{color:blue}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		
		outfile << "<table width=\"100%\" height=\"95%\" border=\"0\">" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' />" << endl
		<< "<col align='left' width='800' />" << endl
		<< "<tr valign='top'>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>File&nbsp;Type</small></b><br />" << endl
		<< "<select onclick=\"clear_iframe()\" size='25' width='50' id='obj3'>";
		for(unsigned int i=0; i<selection1.size(); i++){
			outfile << "<option ";
			if(i==0){outfile << "selected=\"selected\" ";}
			outfile << "onclick=\"clearSelect()";
			for(unsigned int j=0; j<selection2[i].size(); j++){
				outfile << ";appendSelect('" << selection2[i][j] << "','" << selection2a[i][j] << "')"; 
			}
			outfile	<< "\">" << selection1[i] << "</option>" << endl;
		}
		outfile << "</select>" << endl
		<< "<br>" << endl
		<< "<p class=blue onmouseover=\"this.style.cursor='pointer';this.style.textDecoration='underline'\" onmouseout=\"this.style.cursor='normal';this.style.textDecoration='none'\""
		<< "onclick=\"loadIframe('obj1','" << dir << "','<br>');\">"
		<< "[Navigate&nbsp;Directory]</p>" << endl
		<< "</td>" << endl;
		
		outfile << "<td align='middle'>" << endl
		<< "<b><small>Restraint&nbsp;File</small></b><br />" << endl
		<< "<select onclick=\"doPDB()\" size=\"25\" width=\"50\" id=\"obj2\">" << endl;
		for(unsigned int i=0; i<selection2[0].size(); i++){
			outfile << "<option value=\"" << selection2a[0][i] << "\" >" << selection2[0][i] << "</option>" << endl;
		}
		outfile << "</select>" << endl;
		outfile << "</td>" << endl;
		
		outfile << "<td>" << endl
		<< "<p class=it id='iframe_title'><br></p>" << endl
		<< "<iframe name='obj1' src='message.html' frameborder=0 width='100%' height='100%'>" << endl
		<< "Error - Your browser may not support inline frames." << endl
		<< "</iframe>" << endl
		<< "</td>" << endl;
		
		outfile << "</tr></table>" << endl
		<< "</body>" << endl
		<< "</html>" << endl
		<< endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }	
	
  return;	
}*/

void write_html_message(string &error_file, string &HTML_DIR, bool START)
{
	string fileout = HTML_DIR + "message.html";
	ofstream outfile;
  outfile.open(fileout.c_str());
  if(outfile.is_open()){
		outfile << "<html>" << endl
		<< "<style type='text/css'>" << endl
		<< "body{font-family:geneva, 'trebuchet MS', garuda, helvetica, arial, sans-serif, sans, verdana; font-size:100%;}" << endl
		<< "</style>" << endl;
		
		outfile << "<body>" << endl;
		if(START==1){	
			outfile << "&larr; please make selection" << endl;
		} else {
			outfile << "ProSMART has either not yet finished, or did not finish successfully.<br />"
			<< "Please reload this page when ProSMART has finished.<br />"
			<< "Otherwise, please examine shell output and log files to diagnose any issues.<br />" << endl;
		}
		outfile << "</body>" << endl
		<< "</html>" << endl;
		
		outfile.close();
  } else {
    xml_entry(error_file,0,5,fileout);
    cout << "Unable to open output file " << fileout << " for writing" << endl;
  }
	
	if(START==0){
		fileout = HTML_DIR + "../../prosmart_align_logfile.txt";
		outfile.open(fileout.c_str());
		if(outfile.is_open()){
			outfile.close();
		} else {
			xml_entry(error_file,0,5,fileout);
			cout << "Unable to open output file " << fileout << " for writing" << endl;
		}
		fileout = HTML_DIR + "../../prosmart_restrain_logfile.txt";
		outfile.open(fileout.c_str());
		if(outfile.is_open()){
			outfile.close();
		} else {
			xml_entry(error_file,0,5,fileout);
			cout << "Unable to open output file " << fileout << " for writing" << endl;
		}
	}

    return;	
}

void write_html_pairwise(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, bool ALL_ON_ALL, bool TRIANGULAR, bool HBOND_FILE_OPTIONS)
{
	string fileout = workingdirectory + ".HTML_files/pairwise.html";
	string dir = "../Residue_Alignment_Scores/";
	string dir2 = workingdirectory + "Residue_Alignment_Scores/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
            if(HBOND_FILE_OPTIONS){
                if(i!=j)continue;
            } else if(ALL_ON_ALL)
                if(i==j || (TRIANGULAR && i>j))continue;
			selection.push_back(files1[i] + " &nbsp; " + files2[j]);
            filelist.push_back(files1[i] + SLASH + files1[i] + "_" + files2[j] + ".txt");
		}
	}
	write_html_object1(error_file, fileout, dir, selection, filelist, "Chain&nbsp;Pair",dir2,dir);
  return;	
}

void write_html_transformations(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, bool ALL_ON_ALL, bool TRIANGULAR, bool HBOND_FILE_OPTIONS)
{
	string fileout = workingdirectory + ".HTML_files/transformations.html";
	string dir = "../Superposition/Transformations/";
	string dir2 = workingdirectory + "Superposition/Transformations/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
            if(HBOND_FILE_OPTIONS){
                if(i!=j)continue;
            } else if(ALL_ON_ALL)
                if(i==j || (TRIANGULAR && i>j))continue;
			selection.push_back(files1[i] + " &nbsp; " + files2[j]);
            filelist.push_back(files1[i] + SLASH + files1[i] + "_" + files2[j] + ".txt");
		}
	}
	write_html_object1(error_file, fileout, dir, selection, filelist, "Chain&nbsp;Pair",dir2,dir);
  return;	
}

void write_html_scores(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, bool ALL_ON_ALL, bool TRIANGULAR, bool HBOND_FILE_OPTIONS)
{
	string fileout = workingdirectory + ".HTML_files/scores.html";
	string dir = "../Global_Statistics/Single/";
	string dir2 = workingdirectory + "Global_Statistics/Single/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
            if(HBOND_FILE_OPTIONS){
                if(i!=j)continue;
            } else if(ALL_ON_ALL)
                if(i==j || (TRIANGULAR && i>j))continue;
			selection.push_back(files1[i] + " &nbsp; " + files2[j]);
			filelist.push_back(files1[i] + "_" + files2[j] + ".txt");
		}
	}
	write_html_object1(error_file, fileout, dir, selection, filelist, "Chain&nbsp;Pair",dir2,dir);
	return;	
}

void write_html_multi(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2)
{
	string fileout = workingdirectory + ".HTML_files/scores_multi.html";
	string dir = "../Global_Statistics/Multiple/";
	string dir2 = workingdirectory + "Global_Statistics/Multiple/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
   selection.push_back("Number&nbsp;Aligned&nbsp;Residues");
	selection.push_back("Percent&nbsp;Aligned&nbsp;Residues");
	selection.push_back("Aligned&nbsp;Sequence&nbsp;Identity");
	selection.push_back("Average&nbsp;Procrustes&nbsp;Score");
	selection.push_back("Average&nbsp;Flexible&nbsp;Score");
	selection.push_back("Global&nbsp;RMSD");
	filelist.push_back("NumberAligned.html");
	filelist.push_back("PercentAligned.html");
	filelist.push_back("SequenceIdentity.html");
	filelist.push_back("AverageProcrustes.html");
	filelist.push_back("AverageFlexible.html");
	filelist.push_back("GlobalRMSD.html");
	write_html_object1(error_file, fileout, dir, selection, filelist, "Score/Statistic",dir2,dir);
	return;	
}

void write_html_pdb(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, bool ALL_ON_ALL, bool TRIANGULAR, bool HBOND_FILE_OPTIONS)
{
	string fileout = workingdirectory + ".HTML_files/pdb.html";
	string dir = "../Superposition/PDB_files/";
	string dir2 = workingdirectory + "Superposition/PDB_files/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filedir;
	vector<vector<string> > filelist;
	string tmp;
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
            if(HBOND_FILE_OPTIONS){
                if(i!=j)continue;
            } else if(ALL_ON_ALL)
                if(i==j || (TRIANGULAR && i>j))continue;
			selection.push_back(files1[i] + " &nbsp; " + files2[j]);
			filedir.push_back(files1[i]+"_"+files2[j]);
            tmp = workingdirectory+".HTML_files/tmp/"+files1[i]+"_"+files2[j]+".txt";      
			filelist.push_back(read_file(tmp));
		}
	}

#ifndef WINDOWS
	string temp1;
	string TXT_dir;
    //create soft links to pdb files
	for(unsigned int i=0; i<filelist.size(); i++){
		temp1 = workingdirectory + ".HTML_files/tmp/";
		TXT_dir = make_subdirectory(error_file,temp1,filedir[i]);
		for(unsigned int j=0; j<filelist[i].size(); j++){
			system(("ln -fs \"../../../Superposition/PDB_files/"+filedir[i]+"/"+filelist[i][j]+".pdb\" \"" + TXT_dir+filelist[i][j]+".txt\"").c_str());
		}
	}
    write_html_object2(error_file, fileout, dir, selection, filelist, filedir, dir2, "", "pdb");
#else
	write_html_object2(error_file, fileout, dir, selection, filelist, filedir, dir2, "Superposition////PDB_files", "pdb");
#endif
	return;	
}

void write_html_pdb_helix(string &error_file, string &workingdirectory, vector<string> &files1)
{
    vector<string> filelist;
	string fileout = workingdirectory + ".HTML_files/pdb.html";
	string dir = "tmp/";
	string dir2 = workingdirectory + "Superposition/PDB_files/";
    fileout = windows_file(fileout);
    dir2 = windows_file(dir2);
#ifdef WINDOWS
    dir = "..\\Superposition\\PDB_files\\";
#endif
	//create soft links to pdb files
	for(unsigned int i=0; i<files1.size(); i++){
		filelist.push_back(files1[i]);
#ifndef WINDOWS
		system(("ln -fs \"../../Superposition/PDB_files/"+files1[i]+".pdb\" \"" + workingdirectory+".HTML_files/tmp/"+files1[i]+".txt\"").c_str());
#endif
    }
	write_html_object1A(error_file, fileout, dir, files1, filelist, "Chain",dir2,"../Superposition/PDB_files/",".txt",".pdb");
	return;	
}

void write_html_pymol(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, bool ALL_ON_ALL, bool TRIANGULAR, bool HBOND_FILE_OPTIONS)
{
	string fileout = workingdirectory + ".HTML_files/pymol.html";
	string dir = "../Colour_Scripts/";
	string dir2 = workingdirectory + "Colour_Scripts/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filedir;
	vector<vector<string> > filelist;
	string tmp;
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
            if(HBOND_FILE_OPTIONS){
                if(i!=j)continue;
            } else if(ALL_ON_ALL)
                if(i==j || (TRIANGULAR && i>j))continue;
			selection.push_back(files1[i] + " &nbsp; " + files2[j]);
			filedir.push_back(files1[i]+"_"+files2[j]);
			tmp = workingdirectory+".HTML_files/tmp/Colour/"+files1[i]+"_"+files2[j]+".txt";
			filelist.push_back(read_file(tmp));
		}
	}
	
#ifndef WINDOWS
	//create soft links to files
	string temp1;
	string TXT_dir;
	for(unsigned int i=0; i<filelist.size(); i++){
		temp1 = workingdirectory + ".HTML_files/tmp/Colour/";
		TXT_dir = make_subdirectory(error_file,temp1,filedir[i]);
		for(unsigned int j=0; j<filelist[i].size(); j++){
			system(("ln -fs \"../../../../Colour_Scripts/"+filedir[i]+"/"+filelist[i][j]+".pml\" \"" + TXT_dir+filelist[i][j]+".txt\"").c_str());
		}
	}
    write_html_object2(error_file, fileout, dir, selection, filelist, filedir, dir2, "Colour/", "pml");
#else
	write_html_object2(error_file, fileout, dir, selection, filelist, filedir, dir2, "Colour_Scripts", "pml");
#endif	
    return;	
}

void write_html_pymol_helix(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2)
{
	string fileout = workingdirectory + ".HTML_files/pymol.html";
	string dir = "tmp/Colour/";
	string dir2 = workingdirectory + "Colour_Scripts/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	
#ifdef WINDOWS
    dir = "../Colour_Scripts/";
#endif

	//create soft links to pdb files
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<files2.size(); j++){
			selection.push_back(files1[i]+" &nbsp; "+files2[j]);
			filelist.push_back(files1[i]+"_"+files2[j]);
#ifndef WINDOWS
			system(("ln -fs \"../../../Colour_Scripts/"+files1[i]+"_"+files2[j]+".pml\" \"" + workingdirectory+".HTML_files/tmp/Colour/"+files1[i]+"_"+files2[j]+".txt\"").c_str());
#endif
		}
	}
	write_html_object1A(error_file, fileout, dir, selection, filelist, "Chain&nbsp;Pair",dir2,"../Colour_Scripts/",".txt",".pml");
	return;	
}

void write_html_restrain(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, vector<string> &files3, string HELIX, vector<vector<int> > &restrain_chains, vector<vector<string> > &filenames_chain2, vector<string> &filenames_all)
{
	string fileout = workingdirectory + ".HTML_files/restrain.html";
	string filescript = workingdirectory + "restrain_script.txt";
	string dir = "../Restraints/";
	string dir2 = workingdirectory + "Restraints/";
    fileout = windows_file(fileout);
    filescript = windows_file(filescript);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<vector<string> > selection;
	vector<vector<string> > filelist;
	vector<string> temp1;
	vector<string> temp2;
	vector<string> select1;
	
	for(unsigned int i=0; i<files1.size(); i++){
		for(unsigned int j=0; j<restrain_chains[i].size(); j++){
			temp1.push_back(files1[i]+" &nbsp; "+files2[restrain_chains[i][j]]);
#ifdef WINDOWS
            temp2.push_back("Chain_Chain\\\\"+files1[i]+"_"+files2[restrain_chains[i][j]]+".txt");
#else
			temp2.push_back("Chain_Chain/"+files1[i]+"_"+files2[restrain_chains[i][j]]+".txt");
#endif
		}
	}
	selection.push_back(temp1);
	filelist.push_back(temp2);
	select1.push_back("Chain_Chain");
	
	if(filenames_chain2.size()>0){      //this is currently disabled (i.e. filenames_chain2.size()==0) as we don't want to output PDB_chain any more.
		temp1.clear();
		temp2.clear();
		for(unsigned int i=0; i<filenames_chain2[0].size(); i++){
			temp1.push_back(filenames_chain2[1][i]);
#ifdef WINDOWS
			temp2.push_back("PDB_Chain\\\\"+filenames_chain2[0][i]+".txt");
#else
			temp2.push_back("PDB_Chain/"+filenames_chain2[0][i]+".txt");
#endif
		}
		selection.push_back(temp1);
		filelist.push_back(temp2);
		select1.push_back("PDB_Chain");
	}
	
	temp1.clear();
	temp2.clear();
	for(unsigned int i=0; i<filenames_all.size(); i++){
		temp1.push_back(filenames_all[i]);
		if(HELIX=="0"){
			temp2.push_back(filenames_all[i]+".txt");
		} else {
			temp2.push_back("LIB_"+filenames_all[i]+".txt");
		}
	}
	selection.push_back(temp1);
	filelist.push_back(temp2);
	select1.push_back("All (final)");

	write_html_object3(error_file, fileout, selection, filelist, select1, dir, dir2);	 
	return;	
}

void write_html_ssetype(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2)
{
	string fileout = workingdirectory + ".HTML_files/ssetype.html";
	string dir = "../Residue_Alignment_Scores/";
	string dir2 = workingdirectory + "Residue_Alignment_Scores/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	for(unsigned int i=0; i<files1.size(); i++){
		selection.push_back(files1[i]);
		filelist.push_back(files1[i] + SLASH"types_" + files1[i] + ".txt");
	}
	write_html_object1(error_file, fileout, dir, selection, filelist, "Chain",dir2,dir);
  return;	
}

void write_html_frag_score(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2)
{
	string fileout = workingdirectory + ".HTML_files/frag_score.html";
	string dir = "../Residue_Alignment_Scores/";
	string dir2 = workingdirectory + "Residue_Alignment_Scores/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	
	write_html_object4(error_file, fileout, dir, files1, files2, dir2, "types_");
  return;	
}

void write_html_sequence(string &error_file, string &workingdirectory, vector<string> &files1, vector<string> &files2, string HELIX)
{
	string fileout = workingdirectory + ".HTML_files/sequence.html";
	string dir = "../Sequence/";
	string dir2 = workingdirectory + "Sequence/";
    fileout = windows_file(fileout);
    dir = windows_file(dir);
    dir2 = windows_file(dir2);
	vector<string> selection;
	vector<string> filelist;
	for(unsigned int i=0; i<files1.size(); i++){
		selection.push_back(files1[i]);
		filelist.push_back(files1[i] + ".txt");
	}
	if(HELIX!="1"){
		for(unsigned int i=0; i<files2.size(); i++){
			selection.push_back(files2[i]);
			filelist.push_back(files2[i] + ".txt");
		}
		for(unsigned int i=1; i<selection.size(); i++){	//remove repeated entries
			for(unsigned int j=0; j<i; j++){
				if(selection[i]==selection[j]){
					selection.erase(selection.begin()+i);
					filelist.erase(filelist.begin()+i);
					i--;
					break;
				}
			}
		}
	}
	write_html_object1(error_file, fileout, dir, selection, filelist, "Chain",dir2,dir);
  return;	
}

void copy_xml(string &error_file, string &workingdirectory) 
{
#ifndef WINDOWS     //should't need to copy xml in windows...
	if(error_file.size()==0){return;}
	system(("cp \"" + error_file + "\" \"" + workingdirectory + "/.HTML_files/" + get_filename(error_file) + ".xml\"").c_str());
#endif
	return;
}

