//
// This file is part of ProSMART.
//

#include "prosmart_string_tools.h"

string make_valid_directory(string &error_file, string &dir)	//ensures that '/' is at the end of the string
{
    for(unsigned int i=0; i<dir.size(); i++){
        if(dir[i] == "~"[0]){
            cout << endl << "Error - the symbol '~' cannot be used in a directory name." << endl
            << "Program terminated." << endl << endl;
            xml_entry(error_file,0,18);
            exit(-1);
        }
    }
    
    if(dir[dir.size()-1] != SLASH[0]){
        dir += SLASH;
    }
    
    return dir;
}

bool check_ext(string &mystring)
{
    unsigned int i=0;
	bool result = 0;
    while(i<mystring.length())
    {
        if(mystring.compare(i,1,".")==0){
			result = 1;
		}
        i++;
    }
    return result;
}

string delete_spaces(string mystring)
{
    string newstring = mystring;
    int len = newstring.length();
	for(int i=1; i<=len; i++){
		if(newstring.compare(len-i,1," ")==0){
			newstring.erase(len-i,1);
		}
	}
    return newstring;
}

string replace_spaces(string mystring, string ext)
{
    string newstring = mystring;
    unsigned int i=0;
    while(i<newstring.length())
    {
        if(newstring.compare(i,1," ")==0){
            newstring.erase(i,1);
            newstring.insert(i,ext);
        }
        i++;
    }
    return newstring;
}

string replace_chars(string mystring, string c1, string c2)
{
    string newstring = mystring;
    unsigned int i=0;
    while(i<newstring.length())
    {
        if(newstring.compare(i,1,c1)==0){
            newstring.erase(i,1);
            newstring.insert(i,c2);
        }
        i++;
    }
    return newstring;
}

string duplicate_char(string &mystring, string c1)
{
    string newstring = mystring;
    unsigned int i=0;
    while(i<newstring.length())
    {
        if(newstring.compare(i,1,c1)==0){
            newstring.insert(i,c1);
            i++;
        }
        i++;
    }
    //cout << endl << "duplicate: " << mystring << ":" << newstring << endl;
    return newstring;
}

string half_char(string &mystring, string c1)
{
    string newstring = mystring;
    unsigned int i=0;
    while(i<newstring.length()-1){
        if(newstring.compare(i,1,c1)==0){
            if(newstring.compare(i+1,1,c1)==0){
                newstring.erase(newstring.begin()+i);
            }
        }
        i++;
    }
    return newstring;
}

string terminal_spaces(string &mystring)
{
    string newstring = mystring;
    unsigned int i=0;
    while(i<newstring.length())
    {
        if(newstring.compare(i,1," ")==0){
			newstring.insert(i,"\\");
			i+=2;
		}
        i++;
    }
    return newstring;
}

string delete_ext(string myfile)
{
    string file = myfile;
    
    for(unsigned int i=1; i<=file.size(); i++){
        if(file[file.size()-i] == "."[0]){
            file.erase(file.end()-i, file.end());
            break;
        }
    }
    
    return file;
}

string get_filename(string file)
{
    unsigned int lower = 0;
    int upper = file.size()-1;
    string filename;
    
    for(unsigned int i=1; i<=file.size(); i++){
        if(file[file.size()-i] == "/"[0] || file[file.size()-i] == SLASH[0]){
            lower = file.size()-i+1;
            break;
        }
    }
    
	for(unsigned int i=file.size()-1; i>=lower; i--){
        if(file[i] == "."[0]){
            upper = i-1;
            break;
        }
    }
    
    for(int i=lower; i<=upper; i++){
        filename += file[i];
    }
    
    return filename;
}

string get_full_filename(string file)
{
    int lower = 0;
    int upper = file.size();
    string filename;
    
    for(unsigned int i=1; i<=file.size(); i++){
        if(file[file.size()-i] == "/"[0] || file[file.size()-i] == SLASH[0]){
            lower = file.size()-i+1;
            break;
        }
    }
    
    for(int i=lower; i<upper; i++){
        filename += file[i];
    }
	
    return filename;
}

string file_append_name(string file, char name_ext)
{
    string newfile(file);
    string name_ext_string;
    name_ext_string = name_ext;
    
    for(unsigned int i=1; i<=newfile.size(); i++){
        if(newfile[newfile.size()-i] == "."[0]){
			newfile.insert(newfile.size()-i, name_ext_string);
			break;
		}
    }
    
    return newfile;
}

string get_folder(string file)
{
    int upper = file.size();
    string filename;
    
    for(unsigned int i=1; i<=file.size(); i++){
        if(file[file.size()-i] == SLASH[0]){
            upper = file.size()-i+1;
            break;
        }
    }
    
    for(int i=0; i<upper; i++){
        filename += file[i];
    }
    
    if(filename[filename.size()-1] != SLASH[0]){
        filename += SLASH;
    }
    
    return filename;
}

vector<string> string_to_vector(string &line)
{
    vector<string> line_v;
    string temp="";
    for(unsigned int i=0; i<line.size(); i++){
        if(line[i]==' ' || line[i]=='\t'){
            if(temp.size()>0){
                line_v.push_back(temp);
                temp = "";
            }
        } else {
            temp += line[i];
        }
    }
    if(temp.size()>0){
        line_v.push_back(temp);
    }
    return line_v;
}

vector<string> string_to_vector(string &line, char delimiter)
{
    vector<string> line_v;
    string temp="";
    for(unsigned int i=0; i<line.size(); i++){
		if(line[i]==delimiter){
            if(temp.size()>0){
				line_v.push_back(temp);
				temp = "";
			}
		} else {
			temp += line[i];
		}
    }
    if(temp.size()>0){
		line_v.push_back(temp);
    }
    return line_v;
}

string vector_to_string(vector<string> &v)
{
    string result = "";
    if(v.size()>0){
        result = v[0];
    }
    for(unsigned int i=1; i<v.size(); i++){
        result += " " + v[i];
    }
    return result;
}

int str_to_int(string &mystring)
{
    return atoi(mystring.c_str());
}

double str_to_double(string &mystring)
{
    return atof(mystring.c_str());
}

string standardise_double(string str, int len, int dp)	//converts a string storing a double into a standard format.
{
    string result;
    bool is_a_dp = 0;
    
    for(unsigned int i=0; i<str.size(); i++){	//ensure that there is a decimal point
        if(str.compare(i,1,".")==0){
			is_a_dp = 1;
			break;
		}
    }
    if(is_a_dp == 0){
        str += ".0";
		if((int)str.size()>len){
			cout << endl << endl << "Warning: Error converting double to string." << endl << endl;
		}
    }
    
    if((int)str.size()>len){
		str.erase(str.begin()+len,str.end());
    }
    if((int)str.size()<len){			//fill the end of the double out with zeroes.
        for(int i=(int)str.size(); i<len; i++){
            str += "0";
        }
    }
    result = str;
	
    for(unsigned int i=0; i<str.size(); i++){	//this ensures the convention: xxxx.xxx
        if(str.compare(i,1,".")==0){
			if(i+1+dp <= str.size()){
				result.erase(result.begin()+i+1+dp,result.end());
			} 
			if((int)result.size()>len){
				cout << endl << endl << "Warning: Error converting double to string." << endl << endl;
			}
			if((int)result.size()<len){
				for(int j=(int)result.size(); j<len; j++){
					result.insert(0," ");
				}
			}	
			break;
		}
    }
    return result;
}

string fill_out(string &s1, string &s2)
{
	string result;
	
	if(s1.size()>s2.size()){
		return s1;
	} else {
		result = s1;
		for(unsigned int i=0; i<s2.size()-s1.size(); i++){
			result += " ";
		}
	}
	return result;
}

string fill_out_back(string &s1, string &s2)
{
	string result;
	
	if(s1.size()>s2.size()){
		return s1;
	} else {
		result = "";
		for(unsigned int i=0; i<s2.size()-s1.size(); i++){
			result += " ";
		}
		result += s1;
	}
	return result;
}

string int_to_str(int A)
{
	stringstream ss("");
	ss << A;
	return ss.str();
}

string d_to_str(double A)
{
	stringstream ss("");
	ss << A;
	return ss.str();
}

vector<string> read_file(string &file)
//reads a file into a vector<string> where elements are separated in the file by spaces or newlines.
{
    vector<string> result;
    ifstream infile(file.c_str(), ios::in);
    string line;
    string tmp;
    
    if(infile.is_open()){
        while(!infile.eof()){
            getline(infile,line);
			tmp.clear();
			if(line.size()>0){	//check that the line is not commented out
				if(line[0]=='#'){
					continue;
				}
			}
			for(unsigned int i=0; i<line.size(); i++){
				if(line[i]==' ' || line[i]=='\t'){
					if(tmp.size()>0){
						result.push_back(tmp);
						tmp.clear();
					}
				} else {
					tmp += line[i];
				}
			}
			if(tmp.size()>0){
				result.push_back(tmp);
				tmp.clear();
			}
		}
        infile.close();
    }
    
    return result;
}

vector<string> read_file_line_string(string &file)
//reads a file into a vector<string> where elements are separated in the file by spaces or newlines.
{
    vector<string> result;
    ifstream infile(file.c_str(), ios::in);
    string line;
    
    if(infile.is_open()){
        while(!infile.eof()){
            getline(infile,line);
			result.push_back(line);
		}
        infile.close();
    }
    
    return result;
}

vector<vector<string> > read_file_lines(string &file)
{
    vector<vector<string> > result;
	vector<string> tempv;
    ifstream infile(file.c_str(), ios::in);
    string line;
    string tmp;
    
    if(infile.is_open()){
        while(!infile.eof()){
            getline(infile,line);
			if(line.size()>0){	//check that the line is not commented out
				if(line[0]=='#'){
					continue;
				}
			}
			tmp.clear();
			tempv.clear();
			for(unsigned int i=0; i<line.size(); i++){
				if(line[i]==' ' || line[i]=='\t'){
					if(tmp.size()>0){
						tempv.push_back(tmp);
						tmp.clear();
					}
				} else {
					tmp += line[i];
				}
			}
			if(tmp.size()>0){
				tempv.push_back(tmp);
			}
			result.push_back(tempv);
		}
        infile.close();
    }
    
    return result;
}

/*string read_file_first_line(string &file)
 {
 ifstream infile(file.c_str(), ios::in);
 string line;
 
 if(infile.is_open()){
 getline(infile,line);
 infile.close();
 }
 
 return line;
 }*/

vector<vector<int> > read_file_lines_int(string &file)
{
    vector<vector<int> > result;
	vector<int> tempv;
    ifstream infile(file.c_str(), ios::in);
    string line;
    string tmp;
    
    if(infile.is_open()){
        while(!infile.eof()){
            getline(infile,line);
			if(line.size()>0){	//check that the line is not commented out
				if(line[0]=='#'){
					continue;
				}
			}
			tmp.clear();
			tempv.clear();
			for(unsigned int i=0; i<line.size(); i++){
				if(line[i]==' ' || line[i]=='\t'){
					if(tmp.size()>0){
						tempv.push_back(str_to_int(tmp));
						tmp.clear();
					}
				} else {
					tmp += line[i];
				}
			}
			if(tmp.size()>0){
				tempv.push_back(str_to_int(tmp));
			}
			result.push_back(tempv);
		}
        infile.close();
    }
    
    return result;
}

bool check_file_exists(string &file)
{
	ifstream infile(file.c_str(), ios::in);
	if(infile.is_open()){
		infile.close();
		return 1;
	} else {
		return 0;
	}
}

void write_to_file(string &file, vector<vector<string> > &lines)
{
    ofstream outfile;
    
    outfile.open(file.c_str());
    
    if(outfile.is_open()){
		for(unsigned int i=0; i<lines.size(); i++){
            for(unsigned int j=0; j<lines[i].size(); j++){
                outfile << lines[i][j] << endl;
            }
        }
		outfile.close();
    } else {
        cout << endl << "Unable to open output file " << file << " for writing" << endl;
    }
    
    return;
}
