//
// This file is part of ProSMART.
//

#include "prosmart_windows.h"

string format_wd(string x)
{
#ifdef WINDOWS
    x += "\\";
#endif
    return "\"" + x + "\"";
}

string windows_file(string &x)
{
#ifdef WINDOWS
    return replace_chars(x,"/","\\");
#else
    return x;
#endif  
}

void remove_quotes(string &x)
{
#ifndef WINDOWS
    if(x.size()>2 && x[0] == '\"' && x[x.size()-1] == '\"'){
        x.erase(x.end()-1);
        x.erase(x.begin());
    }
#endif
    return;
}

string windows_double_slash(string &str)
{
#ifdef WINDOWS
    return duplicate_char(str,"\\");
#else
    return str;
#endif
}

void get_bindir_libdir(string &error_file, string &BIN_DIR, string &LIB_DIR, string &PKG_ROOT, string &PKG_BIN, string &PKG_LIB)
{
#ifdef WINDOWS
    //If $CCP4 exists, put BIN_DIR=$CCP4/bin and LIB_DIR=$CCP4/share/prosmart_data
    //... if PACKAGE_ROOT_BIN and/or PACKAGE_ROOT_LIB exist, use them as subdirectories of $CCP4.
    //If $CCP4 does not exist, BIN_DIR is set by getting the path of the current process (i.e. prosmart) during runtime.
    //... if PACKAGE_ROOT_LIB exists then LIB_DIR=BIN_DIR$(PACKAGE_ROOT_LIB), otherwise LIB_DIR=BIN_DIR/prosmart_data

    char *CCP4 = getenv("CCP4");
    if(CCP4!=NULL){
        if(PKG_BIN.size()==0){
            PKG_BIN = "/bin";
        }
        if(PKG_LIB.size()==0){
            PKG_LIB = "/share/prosmart_data";
        }
        BIN_DIR = CCP4 + PKG_BIN;
        LIB_DIR = CCP4 + PKG_LIB;
    } else {
        /*if(PKG_LIB.size()==0){
            PKG_LIB = "prosmart_data";
        }*/
        PKG_LIB = "../data/";
        TCHAR szPath[MAX_PATH];
        GetModuleFileName(NULL, szPath, MAX_PATH);
        BIN_DIR = get_folder(szPath);
        LIB_DIR = BIN_DIR + PKG_LIB;
    }
    
    BIN_DIR = windows_file(BIN_DIR);
    LIB_DIR = windows_file(LIB_DIR);

#else
    //PACKAGE_ROOT_BIN+PACKAGE_ROOT_LIB takes priority over PACKAGE_ROOT
    //PACKAGE_ROOT takes priority over PROSMART_DIR
    //PROSMART_DIR takes priority over CCP4
    
    //PACKAGE_ROOT sets BIN_DIR=$PACKAGE_ROOT/bin, LIB_DIR=$PACKAGE_ROOT/share/prosmart_data
    //PROSMART_DIR sets BIN_DIR=$PROSMART_DIR, LIB_DIR=$PROSMART_DIR/prosmart_data
    //CCP4 sets BIN_DIR=$CCP4/bin, LIB_DIR=$CCP4/share/prosmart_data

    if(PKG_BIN.size()>0){
        if(PKG_LIB.size()>0){                           //use PACKAGE_ROOT_BIN and PACKAGE_ROOT_LIB
            BIN_DIR = PKG_BIN;
            if(LIB_DIR.size()==0){               //in case custom library is specified
                LIB_DIR = PKG_LIB;
            }
        }
    } else if(PKG_ROOT.size()>0){                       //use PACKAGE_ROOT
        BIN_DIR = PKG_ROOT;
        BIN_DIR += "/bin";
        if(LIB_DIR.size()==0){
            LIB_DIR = PKG_ROOT;
            LIB_DIR += "/share/prosmart_data";
        }
    } else {
        char *PROSMART_DIR = getenv("PROSMART_DIR");  
		if(PROSMART_DIR!=NULL){                         //use PROSMART_DIR
			BIN_DIR = PROSMART_DIR;
			if(LIB_DIR.size()==0){
                LIB_DIR = PROSMART_DIR;
                LIB_DIR += "/prosmart_data";
			}
		} else {
			char *CCP4 = getenv("CCP4");
			if(CCP4!=NULL){                             //use CCP4
				BIN_DIR = CCP4;
				BIN_DIR += "/bin";
				if(LIB_DIR.size()==0){
                    LIB_DIR = CCP4;
                    LIB_DIR += "/share/prosmart_data";
				}
			}
		}
    }

    //check that BIN_DIR and LIB_DIR are defined.
    if(BIN_DIR.size()==0 || LIB_DIR.size()==0){
        return;
    }
    
    //substitute ~'s for full home path, for BIN_DIR and LIB_DIR
    if(BIN_DIR[0]=='~' || LIB_DIR[0]=='~'){
        string tilde = "";                              //PROSMART_TILDE environment variable is set in config.h
#ifdef PROSMART_TILDE                                   //It is neccesary in case BIN_DIR or LIB_DIR has 1st symbol '~'
        tilde = PROSMART_TILDE;                         //to specify home dir. For example, if the installer has
#else                                                   //different home dir to the user.
        string tilde_file = "prosmart_tmp.txt";
        string sys_tilde = "echo ~ > " + tilde_file;
        system(sys_tilde.c_str());
        vector<string> tmp_tilde = read_file(tilde_file);
        sys_tilde = "rm " + tilde_file;
        system(sys_tilde.c_str());
        if(tmp_tilde.size()==1){
            tilde = tmp_tilde[0];
        }
#endif
        if(BIN_DIR[0]=='~'){
            BIN_DIR.erase(BIN_DIR.begin());
            BIN_DIR.insert(0,tilde);
        }
        if(LIB_DIR[0]=='~'){
            LIB_DIR.erase(LIB_DIR.begin());
            LIB_DIR.insert(0,tilde);
        }
    }
#endif
    return;
}

#ifdef WINDOWS

void wait(int *stat_loc)
//dummy function to replace wait() from sys/wait.h
//this function will never be called unless something has gone wrong...
{
    cout << endl << endl << "Error - wait() function called." << endl << endl;
    exit(-1);
    return;
}

#endif
