//
// This file is part of ProSMART.
//

#include "prosmart_xml.h"

string get_time()
{
  time_t rawtime;
  struct tm *timeinfo;
  time(&rawtime);
  
  timeinfo = localtime ( &rawtime );
  string temptime = asctime(timeinfo);
  temptime.erase(temptime.end()-1);

  string result;
  char buffer[10];
  
  result += temptime[8];
  result += temptime[9];
  result += "/";
  if(((*timeinfo).tm_mon + 1)<10) {result += "0";}
  sprintf(buffer, "%d", (*timeinfo).tm_mon + 1);
  result += buffer;
  result += "/";
  result += temptime[20];
  result += temptime[21];
  result += temptime[22];
  result += temptime[23];
  result += "_";
  result += temptime[11];
  result += temptime[12];
  result += ":";
  result += temptime[14];
  result += temptime[15];
  result += ":";
  result += temptime[17];
  result += temptime[18];

  //Fill any spaces with zeroes, so that, e.g. Jan is '01' rather than ' 1'.
  for(unsigned int i=0; i<result.size(); i++){
    if(result.compare(i,1," ")==0){
	  result.insert(i,"0");
	  result.erase(i+1,1);
	}
  }
  result[10]=' ';
  
  return result;
}

double get_time_sec()
{
	timeval tim;
	gettimeofday(&tim, NULL);
	double t1=tim.tv_sec+(tim.tv_usec/1000000.0);
	return t1;
}

void write_performance_file(string filepath, string obj1, string obj2, int res1, int res2, int f1, int f2, double t)
{
	ofstream outfile;
  
  outfile.open(filepath.c_str(), ios::app);
  if(outfile.is_open()){
    outfile << res1 << "\t" << f1 << "\t" << res2 << "\t" << f2 << "\t" << t << endl;
		outfile.close();
  } else {
    cout << endl << "Could not open file: " << filepath << " for writing." << endl;
		cout << "Program terminated." << endl;
		exit(-1);
  }
  
  return;
}

void initialise_xml(string &filepath)
{
  ofstream outfile;
	
  outfile.open(filepath.c_str(), ios::trunc);
  if(outfile.is_open()){
    outfile << "<PROSMART time=\"" << get_time() << "\">";
	outfile << endl << "</PROSMART>";		//end of xml file
	outfile.close();
  } else {
    cout << endl << "Could not open file: " << filepath << " for writing." << endl;
	cout << "Program terminated." << endl;
	exit(-1);
  }
  
  return;
}

void xml_entry(string &filepath, int code1, int code2)
// code1 specifies tag, e.g. 0=error 1=warning
// code2 specifies sub-type
{
  xml_entry(filepath,code1,code2,"");
  return;
}

void xml_entry(string &filepath, int code1, int code2, string text)
// code1 specifies tag, e.g. 0=error 1=warning
// code2 specifies sub-type
{
  if(filepath.size()==0){return;}
  
  string line;
  vector<string> args;
  ifstream infile;
  ofstream outfile;
  
  infile.open(filepath.c_str(), ios::in);
  if(infile.is_open()){
      while(!infile.eof()){
	    line.clear();
        getline(infile,line);
		args.push_back(line);
	  }
	  infile.close();
  } else {
    cout << endl << "Could not open file: " << filepath << " for reading." << endl;
	cout << "Program terminated." << endl;
	exit(-1);
  }
  
  
  outfile.open(filepath.c_str(), ios::out);
  if(outfile.is_open()){
    for(unsigned int i=0; i<args.size()-1; i++){
	  outfile << args[i] << endl;
	}
	outfile << "<" << xml_tags(code1) << " time=\"" << get_time () << "\"> " << xml_codes(code1,code2) << text << " </" << xml_tags(code1) << ">";
	outfile << endl << "</PROSMART>";		//end of xml file
	outfile.close();
	if(code1==0){							//fatal error
	  xml_entry(filepath,3,1);				//end xml file
	}
  } else {
    cout << endl << "Could not open file: " << filepath << " for writing." << endl;
	cout << "Program terminated." << endl;
	exit(-1);
  }
  
  return;
}

string xml_tags(int type)
{
  string result = "";
  switch(type){
	case 0: result = "ERROR"; break;
	case 1: result = "WARNING"; break;
	case 2: result = "NOTE"; break;
	case 3: result = "END"; break;
	case 4: result = "FILE"; break;
	default: result = "TAG"; break;
  }
  return result;
}

string xml_codes(int type, int idx)
{
  string result = "";
  switch(type){
	case 0:		//ERROR
	  switch(idx){
		case 0: result = "Incorrect specification of argument: "; break;
		case 1: result = "Unknown/invalid argument(s) specified."; break;
		case 2: result = "Input PDB file(s) not correctly specified."; break;
		case 3: result = "Number of input PDB files doesnt match number of input chains."; break;
		case 4: result = "Chain ID not specified. Input PDB is not of valid format. Use -renamechain."; break;
		case 5: result = "Unable to open file for writing: "; break;
		case 6: result = "Environment variable does not exist."; break;
		case 7: result = "Alignment file was not created: "; break;
		case 8: result = "Alignment file could not be found: "; break;
		case 9: result = "Restraints file was not created: "; break;
		case 10: result = "Unable to open directory for reading: "; break;
		case 11: result = "Cannot find: "; break;
		case 12: result = "Unable to create directory: "; break;
		case 13: result = "Unable to open file for reading: "; break;
		case 14: result = "Invalid restraints file."; break;
		case 15: result = "Error spawning child process."; break;
		case 16: result = "NO_ARGS variable incorrectly set."; break;
		case 17: result = "Error allocating memory."; break;
		case 18: result = "Symbol '~' cannot be used in a directory name."; break;
		case 19: result = "Unable to read PDB file: "; break;
		default: result = "Unknown error."; break;
	  } break;
	case 1:		//WARNING
	  switch(idx){
		case 0: result = "Bonds file not created successfully: "; break;
		case 1: result = "Unable to create multiple scores output file."; break;
		default: result = "Unknown warning."; break;
	  } break;
	case 2:		//NOTE
	  switch(idx){
		case 0: result = "Chain number renamed in PDB file: "; break;
		case 1: result = "ProSMART ALIGN launched."; break;
		case 2: result = "ProSMART ALIGN completed."; break;
		case 3: result = "ProSMART RESTRAIN launched."; break;
		case 4: result = "ProSMART RESTRAIN completed."; break;
		case 5: result = "REFMAC5 launched."; break;
		default: result = "Unknown note."; break;
	  } break;
	case 3:		//END
	  switch(idx){
		case 0: result = "Normal completion of ProSMART."; break;
		case 1: result = "ProSMART terminated."; break;
		default: result = "Unknown end."; break;
	  } break;
	case 4:		//FILE
	  switch(idx){
		case 0: result = "Final restraints file written to: "; break;
		default: result = "Unknown end."; break;
	  } break;
	default: result = "Unknown error."; break;
  }
  return result;
}
