//
// This file is part of ProSMART.
//

#include "restrainClass_Atomic_Bonds.h"

void filter_bonds(string filein_bonds, char chain, vector<res_corresp> &rename, vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, PDBfile &pdb1, int MAX_RESNUM, int &SIGMA_METHOD)
{
  //read bonds from file
	
  vector<vector<string> > bonded_orig = file_read_bonds(filein_bonds,chain,MAX_RESNUM);
  
  /*for(unsigned int i=0; i<bonded_orig.size(); i++){
	cout << endl << bonded_orig.size() << " " << i << "\t";
    for(unsigned int j=0; j<bonded_orig[i].size(); j++){
	  cout << bonded_orig[i][j] << " ";
	}
  }
	exit(-1);*/
  
  //convert residue numbering
  if(bonded_orig.size()>0){
    vector<vector<atom_corresp> > bonded = convert_bonds(bonded_orig,rename);
    /*for(int i=0; i<bonded.size(); i++){
      cout << endl;
      for(int j=0; j<bonded[i].size(); j++){
        cout << bonded[i][j].res.res << " " << bonded[i][j].res.ins << " " << bonded[i][j].atom << " ";
      }
    }
		exit(-1);*/

    //generate list of bonded atoms, using atom indexes from pdb1.
    vector<vector<int> > bond_list = get_bond_list(bonded,pdb1);

    //remove bonds from restraints list
    remove_restraints(bond_list,restraints1,restraints2);
    cout << "Bonded atom-pairs removed - " << restraints1.size() << " restraints remaining." << endl;

    //generate list of angled atoms.
    vector<vector<int> > angle_list = get_angle_list(bond_list);

    //remove angles from restraints list
    remove_restraints(angle_list,restraints1,restraints2);
    cout << "Angled atom-pairs removed - " << restraints1.size() << " restraints remaining." << endl;
  } else {
    cout << "Bonded and angled atom-pairs not removed - could not read bonds file." << endl
		<< "Default sigmas will be used." << endl;
	SIGMA_METHOD = 0;
  }
  
  return;
}

vector<vector<atom_corresp> > convert_bonds(vector<vector<string> > &bonded, vector<res_corresp> &rename)
{
  bool found=0;
  int idx1=0;
  int idx2=0;
  int j1=0;
  int j2=0;
  
  atom_corresp temp1;
  atom_corresp temp2;
  vector<atom_corresp> renamed_bond;
  vector<vector<atom_corresp> > renamed_bonds;
  
  res_corresp temp;
  vector<res_corresp> empty;
  vector<vector<res_corresp> > i_rename;	//inverse of rename
  int offset = rename[0].res;		//problem is that sometimes residues have negative indexes
									//but vectors cannot have negative indexes, e.g. i_rename[-1] is not allowed.
									//this is solved by assigning a constant offset to the vector indexes.

  // find inverse of rename
  //cout << endl << "rename_size: " << rename.size();
  for(unsigned int i=0; i<rename.size(); i++){
    //cout << endl << i << " " << rename[i].res << " " << rename[i].ins;
		if(rename[i].res >= offset){	//rename[i].res==-1 indicates residues does not exist/is invalid.
			while((int)i_rename.size() <= rename[i].res-offset){
				i_rename.push_back(empty);
			}
			temp.res = i;
			temp.ins = rename[i].ins;
			i_rename[rename[i].res-offset].push_back(temp);
		}
  }

  /*for(unsigned int i=0; i<i_rename.size(); i++){
    cout << endl << i;
	for(unsigned int j=0; j<i_rename[i].size(); j++){
	  cout << "\t" << i_rename[i][j].res << i_rename[i][j].ins;
	}
  }*/
  
  // get renamed bonds
  for(unsigned int i=0; i<bonded.size(); i++){
	/*cout << endl << bonded.size() << " " << i << "\t";
    for(unsigned int j=0; j<bonded[i].size(); j++){
	  cout << bonded[i][j] << " ";
	}
	*/
	idx1 = str_to_int(bonded[i][1])-offset;
	if(idx1<0){
	  continue;		//sometimes the index can be negative, which indicates refmac generated bonds for a residue that prosmart ignores. This will happen if, e.g., the first residue in the file doesn't contain all four N,C,0,CA atoms.
	}
		
		if(idx1 >= (int)i_rename.size()){	//no further residues are aligned - not neccesary to identify bonds for these.
			break;
		}
	
	found=0;
	for(unsigned int j=0; j<i_rename[idx1].size(); j++){
	  //cout << endl << j << " " << i_rename[idx1][j].ins << " ";
	  if(bonded[i][2]=="."){
	    if(i_rename[idx1][j].ins==' '){
		  found=1;
		  j1=j;
		  break;
		}
	  } else {
	    if(i_rename[idx1][j].ins==bonded[i][2][0]){
		  found=1;
		  j1=j;
		  break;
		}
	  }
	}
	if(found==1){
	  idx2 = str_to_int(bonded[i][5])-offset;
		if(idx2<0 || idx2 >= (int)i_rename.size()){
			continue;
		}
	  found=0;
	  for(unsigned int j=0; j<i_rename[idx2].size(); j++){
	    if(bonded[i][6]=="."){
	      if(i_rename[idx2][j].ins==' '){
		    found=1;
		    j2=j;
		    break;
		  }
	    } else {
	      if(i_rename[idx2][j].ins==bonded[i][6][0]){
		    found=1;
		    j2=j;
		    break;
		  }
	    }
	  }
	
	  if(found==1){
	    temp1.res = i_rename[idx1][j1];
		temp1.atom = bonded[i][3];
		temp2.res = i_rename[idx2][j2];
		temp2.atom = bonded[i][7];
		renamed_bond.clear();
		renamed_bond.push_back(temp1);
		renamed_bond.push_back(temp2);
		renamed_bonds.push_back(renamed_bond);
	    //cout << "\t" << i_rename[idx1][j1].res << i_rename[idx1][j1].ins;
		//cout << "\t" << i_rename[idx2][j2].res << i_rename[idx2][j2].ins;
	  }
	}
	
  }
  
  return renamed_bonds;
}

vector<vector<int> > get_bond_list(vector<vector<atom_corresp> > &bonded, PDBfile &pdb1)
{
  //get indexes of atoms, stored in a vector indexed by residue number.
  //Also, for each atom in pdb, store the atom type with spaces removed.
  vector<vector<int> > res_atom; //indexes atoms in pdb1 by resnum
  vector<int> empty;
  vector<string> atomtypes;
  int n;
  for(int i=0; i<pdb1.size(); i++){
    //cout << endl << i << " " << pdb1.get_resnum(i) << " " << pdb1.get_atom(i);
	n = pdb1.get_resnum(i);
	while((int)res_atom.size()<=n){
	  res_atom.push_back(empty);
	}
	res_atom[n].push_back(i);
	atomtypes.push_back(delete_spaces(pdb1.get_atom(i)));
  }
	
	/*for(int i=0; i<res_atom.size(); i++){
		for(int j=0; j<res_atom[i].size(); j++){
			cout << endl << i << " " << j << "\t" << res_atom[i][j] << "\t" << atomtypes[res_atom[i][j]];
		}
	}
	exit(-1);*/
  
	//get list of bonded atoms, using atom indexes from pdb1.
  vector<vector<int> > bond_list;
  int resnum;
  int atomno1;
  int atomno2;
  string atomtype;
  for(unsigned int i=0; i<bonded.size(); i++){
    atomno1 = -1;
		atomno2 = -1;
    resnum = bonded[i][0].res.res;
		atomtype = bonded[i][0].atom;
		/*cout << endl << i << " " << resnum << " " << atomtype;
		cout << "\t" << bonded[i][1].res.res << " " << bonded[i][1].atom;
		continue;*/
		//cout << endl << i << " " << resnum << " " << atomtype;
    for(unsigned int j=0; j<res_atom[resnum].size(); j++){
			//cout << endl << "\t" << atomtype << " " << atomtypes[res_atom[resnum][j]];
			if(atomtype == atomtypes[res_atom[resnum][j]]){
				//cout << "\t***\t" << res_atom[resnum][j] << " :" << atomtype << ":  :" << atomtypes[res_atom[resnum][j]] << ":" << endl;
				atomno1 = res_atom[resnum][j];
				break;
			}
		}
    resnum = bonded[i][1].res.res;
		atomtype = bonded[i][1].atom;
		//cout << i << " " << resnum;
    for(unsigned int j=0; j<res_atom[resnum].size(); j++){
			if(atomtype == atomtypes[res_atom[resnum][j]]){
				//cout << "\t" << res_atom[resnum][j] << " :" << atomtype << ":  :" << atomtypes[res_atom[resnum][j]] << ":" << endl;
				atomno2 = res_atom[resnum][j];
				break;
			}
		}
		if(atomno1>=0 && atomno2>=0){
			while((int)bond_list.size()<=atomno1 || (int)bond_list.size()<=atomno2){
				bond_list.push_back(empty);
			}
			bond_list[atomno1].push_back(atomno2);
			bond_list[atomno2].push_back(atomno1);
		}
  }
  /*for(unsigned int i=0; i<bond_list.size(); i++){
    cout << endl << i << "\t";
    for(unsigned int j=0; j<bond_list[i].size(); j++){
			cout << " " << bond_list[i][j]; 
		}
  }
	exit(-1);*/

  return bond_list;
}

void remove_restraints(vector<vector<int> > &bond_list, vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2)
{	
	/*for(unsigned int i=0; i<restraints1.size(); i++){
		cout << endl << restraints1[i] << "\t" << restraints2[i];
	}
	exit(-1);*/
  for(unsigned int i=0; i<restraints1.size(); i++){
    //if(i>1000){break;}
		//cout << endl << i << " " << restraints1[i].res1;
		for(unsigned int j=0; j<bond_list[restraints1[i].res1].size(); j++){
			//cout << endl << "\t" << j << " " << bond_list[restraints1[i].res1][j] << " " << restraints1[i].res2; 
			if(bond_list[restraints1[i].res1][j] == restraints1[i].res2){
				//cout << "\t*" << endl;
				restraints1.erase(restraints1.begin()+i);
				restraints2.erase(restraints2.begin()+i);
				i--;
				break;
			}
		}
  }
	//exit(-1);
  return;
}

vector<vector<int> > get_angle_list(vector<vector<int> > &bond_list)
{
  vector<vector<int> > angle_list;
  vector<int> empty;
  unsigned int idx;
  
  for(unsigned int i=0; i<bond_list.size(); i++){
    angle_list.push_back(empty);
  }
  
  for(unsigned int i=0; i<bond_list.size(); i++){
    for(unsigned int j=0; j<bond_list[i].size(); j++){
	  for(unsigned int k=0; k<bond_list[bond_list[i][j]].size(); k++){
	    idx = bond_list[bond_list[i][j]][k];
		if(i != idx){
		  angle_list[i].push_back(idx);
		}
	  }
	}
  }
  
  /*for(unsigned int i=0; i<10; i++){
    cout << endl << i << "\t";
    for(unsigned int j=0; j<angle_list[i].size(); j++){
	  cout << " " << angle_list[i][j]; 
	}
  }*/

  return angle_list;
}
