//
// This file is part of ProSMART.
//

#include "restrainClass_Diff_Info.h"

ostream& operator<<(ostream& out, res_diff_info &record)
{
  cout << record.res1 << " "
	<< record.res2 << " "
	<< record.atom1 << " "
	<< record.atom2 << " "
	<< record.dist1 << " "
	<< record.dist2 << " "
	<< record.score1 << " "
	<< record.score2 << " "
	<< record.b1 << " "
	<< record.b2 << " "
	<< record.sigma << " "
	//<< record.dd
	<< endl;
  return out;
}

ostream& operator<<(ostream& out, Diff_Info &record)
{
  res_diff_info temp;
  if(record.size()>20){
    cout << endl << "idx res1 res2 atom1 atom2 dist1 dist2 score1 score2 b1 b2 sigma" << endl;
    for(int i=0; i<20; i++){
      temp = record.get(i);
      cout << i+1 << " " << temp;
    }
  }
  return out;
}

void Diff_Info::initialise(vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, PDBfile &pdb1, PDBfile &pdb2, vector<double> &res_scores1, vector<double> &res_scores2)
{
  pdbline temp1;
  pdbline temp2;
  pdbline temp3;
  pdbline temp4;
  res_diff_info record;
  record.sigma = -1.0;		//indicates sigma has not been assigned - negative sigma is impossible.
    
  for(unsigned int i=0; i<restraints1.size(); i++){
	temp1 = pdb1.line(restraints1[i].res1);
	temp2 = pdb1.line(restraints1[i].res2);
	temp3 = pdb2.line(restraints2[i].res1);
	temp4 = pdb2.line(restraints2[i].res2);
	record.res1 = temp1.res_num;
	record.res2 = temp2.res_num;
	//record.atom1 = temp1.atom;
	strcpy(record.atom1, temp1.atom);
	strcpy(record.atom2, temp2.atom);
	//record.atom2 = temp2.atom;
	record.dist1 = restraints1[i].dist;
	record.dist2 = restraints2[i].dist;
	record.score1 = res_scores1[temp1.res_num];
    record.score2 = res_scores1[temp2.res_num]; //only use scores from p1 - these should be equivalent to scores in p2 (scores in p2 don't make sense for fragment library)
	record.b1 = temp1.bfact + temp2.bfact;
	record.b2 = temp3.bfact + temp4.bfact;
	//record.dd = diff_dist[i];
	atompairs.push_back(record);
  }
  return;
}

int Diff_Info::size()
{
  return atompairs.size();
}

void Diff_Info::clear()
{
  atompairs.clear();
  return;
}

void Diff_Info::add(res_diff_info &record)
{
  atompairs.push_back(record);
  return;
}

res_diff_info Diff_Info::get(int i)
{
  return atompairs[i];
}

void Diff_Info::normalise(vector<double> &x)
{
  for(unsigned int i=0; i<atompairs.size(); i++){
    atompairs[i].dist1 = atompairs[i].dist1/x[0];
	atompairs[i].dist2 = atompairs[i].dist2/x[0];
	atompairs[i].score1 = atompairs[i].score1/x[1];
	atompairs[i].score2 = atompairs[i].score2/x[1];
	atompairs[i].b1 = atompairs[i].b1/x[2];
  }
  return;
}

void Diff_Info::filter(Diff_Info &X, double cutoff)
{
  X.clear();
  for(unsigned int i=0; i<atompairs.size(); i++){
    if(atompairs[i].dist2 <= cutoff){
	  X.add(atompairs[i]);
	}
  }
  return;
}

vector<double> Diff_Info::get_means()
{
  unsigned int n=atompairs.size();
  double n_d = (double)n;
  vector<double> result;
  for(int i=0; i<3; i++){
    result.push_back(0.0);
  }
  for(unsigned int i=0; i<n; i++){
    result[0] += atompairs[i].dist1;
	result[0] += atompairs[i].dist2;
	result[1] += atompairs[i].score1;
	result[1] += atompairs[i].score2;
	result[2] += atompairs[i].b1;
  }
  for(int i=0; i<6; i++){
    result[i] = result[i]/n_d;
  }
  result[0] = result[0]/(2*n_d);
  result[1] = result[1]/(2*n_d);
  result[2] = result[2]/n_d;
  
  return result;
}

vector<double> Diff_Info::get_d()
{
  vector<double> result;
  for(unsigned int i=0; i<atompairs.size(); i++){
    result.push_back(atompairs[i].dist1);
	//the following line can be used if it is desired for the distribution to be symmetrized about r.
	//result.push_back(((((rand() % 2)*2)-1)*(atompairs[i].dist1-atompairs[i].dist2)) + atompairs[i].dist2);
  }
  return result;
}

vector<double> Diff_Info::get_r()
{
  vector<double> result;
  for(unsigned int i=0; i<atompairs.size(); i++){
    result.push_back(atompairs[i].dist2);
  }
  return result;
}

vector<double> Diff_Info::get_B()
{
  vector<double> result;
  for(unsigned int i=0; i<atompairs.size(); i++){
    result.push_back(atompairs[i].b1);
  }
  return result;
}

vector<double> Diff_Info::get_s()
{
  vector<double> result;
  for(unsigned int i=0; i<atompairs.size(); i++){
    result.push_back((atompairs[i].score1+atompairs[i].score2)/2);
  }
  return result;
}

void remove_bonds_mainchain(vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, PDBfile &pdb1)
{
	pdbline temp1;
	pdbline temp2;
	char N[] = " N  ";
	char CA[] = " CA ";
	char C[] = " C  ";
	char O[] = " O  ";
	bool REMOVE = 0;
	for(unsigned int i=0; i<restraints1.size(); i++){
		temp1 = pdb1.line(restraints1[i].res1);
		temp2 = pdb1.line(restraints1[i].res2);
		REMOVE = 0;
		if(strncmp(N,temp1.atom,4)==0 && temp1.res_num==temp2.res_num){
			if(strncmp(CA,temp2.atom,4)==0 || strncmp(C,temp2.atom,4)==0){
				REMOVE = 1;
			}
		} else if(strncmp(CA,temp1.atom,4)==0 && temp1.res_num==temp2.res_num){
			if(strncmp(C,temp2.atom,4)==0 || strncmp(O,temp2.atom,4)==0){
				REMOVE = 1;
			}
		} else if(strncmp(CA,temp1.atom,4)==0 && temp1.res_num==(temp2.res_num-1)){
			if(strncmp(N,temp2.atom,4)==0){
				REMOVE = 1;
			}	
		} else if(strncmp(C,temp1.atom,4)==0 && strncmp(O,temp2.atom,4)==0 && temp1.res_num==temp2.res_num){
			REMOVE = 1;
		} else if(strncmp(C,temp1.atom,4)==0 && temp1.res_num==(temp2.res_num-1)){
			if(strncmp(N,temp2.atom,4)==0 || strncmp(CA,temp2.atom,4)==0){
				REMOVE = 1;
			}
		} else if(strncmp(O,temp1.atom,4)==0 && strncmp(N,temp2.atom,4)==0 && temp1.res_num==(temp2.res_num-1)){
			if(strncmp(N,temp2.atom,4)==0 || strncmp(CA,temp2.atom,4)==0){
				REMOVE = 1;
			}
		} else
			//and for the opposite case
			if(strncmp(N,temp2.atom,4)==0 && temp1.res_num==temp2.res_num){
				if(strncmp(CA,temp1.atom,4)==0 || strncmp(C,temp1.atom,4)==0){
					REMOVE = 1;
				}
			} else if(strncmp(CA,temp2.atom,4)==0 && temp1.res_num==temp2.res_num){
				if(strncmp(C,temp1.atom,4)==0 || strncmp(O,temp1.atom,4)==0){
					REMOVE = 1;
				}	
			} else if(strncmp(CA,temp2.atom,4)==0 && temp2.res_num==(temp1.res_num-1)){
				if(strncmp(N,temp1.atom,4)==0){
					REMOVE = 1;
				}	
			} else if(strncmp(C,temp2.atom,4)==0 && strncmp(O,temp1.atom,4)==0 && temp1.res_num==temp2.res_num){
				REMOVE = 1;
			} else if(strncmp(C,temp2.atom,4)==0 && temp2.res_num==(temp1.res_num-1)){
				if(strncmp(N,temp1.atom,4)==0 || strncmp(CA,temp1.atom,4)==0){
					REMOVE = 1;
				}
			} else if(strncmp(CA,temp2.atom,4)==0 && strncmp(N,temp1.atom,4)==0 && temp2.res_num==(temp1.res_num-1)){
				if(strncmp(N,temp1.atom,4)==0 || strncmp(CA,temp1.atom,4)==0){
					REMOVE = 1;
				}
			}
		if(REMOVE==1){
			restraints1.erase(restraints1.begin()+i);
			restraints2.erase(restraints2.begin()+i);
			i--;
		}
	}
	
	return;
}
