//
// This file is part of ProSMART.
//

#ifndef restrainClass_Diff_Info_H
#define restrainClass_Diff_Info_H

#include "restrain_align_handler.h"

struct res_diff_info
{
  int res1;			//residue number (from protein 1)
  int res2;			//residue number (from protein 1)
  char atom1[5];	//atom type, e.g. " C  "
  char atom2[5];
  double dist1;		//target distance
  double dist2;		//restraint distance
  double score1;	//residue alignment score
  double score2;
  double b1;		//sum of the two b-factors in target protein
  double b2;		//sum of the two b-factors in restraining protein
  double sigma;		//assigned sigma - to be estimated by the algorithm
  //double dd;		//difference between average positions of the residues.
};

class Diff_Info
	{
  private:
    vector<res_diff_info> atompairs;
  public:
    void initialise(vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &, PDBfile &, vector<double> &, vector<double> &);
    void filter(Diff_Info&, double);
		int size();
		void clear();
		void add(res_diff_info &);
		res_diff_info get(int);
		void normalise(vector<double> &);
		void filter(double);
		vector<double> get_means();
		vector<double> get_d();
		vector<double> get_r();
		vector<double> get_B();
		vector<double> get_s();
	};

ostream& operator<<(ostream&, res_diff_info &);
ostream& operator<<(ostream&, Diff_Info &);
void remove_bonds_mainchain(vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &);

#endif
