//
// This file is part of ProSMART.
//

#include "restrain_boxing_algorithm.h"

vector<coord> get_outer_box(PDBfile &pdb1)
//get min+max coords of smallest box that contains protein
{
  coord temp_box;
  coord min_box = pdb1.crd(0);
  coord max_box = min_box;
  vector<coord> result;
  
  for(int i=1; i<pdb1.size(); i++){
    temp_box = pdb1.crd(i);
	if(temp_box.x < min_box.x)
	  min_box.x = temp_box.x;
	if(temp_box.y < min_box.y)
	  min_box.y = temp_box.y;
	if(temp_box.z < min_box.z)
	  min_box.z = temp_box.z;
	if(temp_box.x > max_box.x)
	  max_box.x = temp_box.x;
	if(temp_box.y > max_box.y)
	  max_box.y = temp_box.y;
	if(temp_box.z > max_box.z)
	  max_box.z = temp_box.z;
  }
  
  min_box.x = floor(min_box.x);
  min_box.y = floor(min_box.y);
  min_box.z = floor(min_box.z);
  max_box.x = ceil(max_box.x);
  max_box.y = ceil(max_box.y);
  max_box.z = ceil(max_box.z);
  
  result.push_back(min_box);
  result.push_back(max_box);

  return result;
}

vector<vector<vector<vector<int> > > > get_boxed_atoms(PDBfile &pdb1, vector<coord> outer_box, double dist_param)
//find out which atoms lie in which box. Want atoms with max distance = dist_param.
{
  vector<vector<vector<vector<int> > > > result;
  int idxx;
  int idxy;
  int idxz;
  vector<int> emptyv;
  vector<vector<int> > emptyvv;
  vector<vector<vector<int> > > emptyvvv;
  coord array_dim = (outer_box[1]-outer_box[0])/dist_param;
  
  for(int i=0; i<array_dim.z; i++)
    emptyvv.push_back(emptyv);
  for(int i=0; i<array_dim.y; i++)
    emptyvvv.push_back(emptyvv);
  for(int i=0; i<array_dim.x; i++)
    result.push_back(emptyvvv);    
    
  coord temp;
  for(int i=0; i<pdb1.size(); i++){
    temp = pdb1.crd(i);
    idxx = (int)floor((temp.x - outer_box[0].x)/dist_param);
    idxy = (int)floor((temp.y - outer_box[0].y)/dist_param);
    idxz = (int)floor((temp.z - outer_box[0].z)/dist_param);
    result[idxx][idxy][idxz].push_back(i);
  }
    
#ifdef TROUBLESHOOT_RESTRAIN
    cout << endl << "here" << endl;
#endif
    return result;
  
  return result;
}

Array1D<coord> get_atom_boxes(vector<vector<vector<vector<int> > > > &boxed_atoms, int N)
//find out which box an atom is in.
{
  Array1D<coord> result(N);
  
  for(unsigned int i=0; i<boxed_atoms.size(); i++){
    for(unsigned int j=0; j<boxed_atoms[i].size(); j++){
      for(unsigned int k=0; k<boxed_atoms[i][j].size(); k++){
        for(unsigned int l=0; l<boxed_atoms[i][j][k].size(); l++){
		  result[boxed_atoms[i][j][k][l]].x = i;
		  result[boxed_atoms[i][j][k][l]].y = j;
		  result[boxed_atoms[i][j][k][l]].z = k;
        }
	  }
    }
  }
  
  return result;
}

vector<vector<vector<vector<int> > > > get_adjacent_atoms_array(vector<vector<vector<vector<int> > > > &boxed_atoms)
//find atoms that lie in the same box or adacent boxes to each atom.
{
  vector<vector<vector<vector<int> > > > result;
  vector<vector<vector<int> > > temp;
  vector<vector<int> > temp1;
  coord box_idx;
  
  for(unsigned int i=0; i<boxed_atoms.size(); i++){
    temp.clear();
    for(unsigned int j=0; j<boxed_atoms[i].size(); j++){
      temp1.clear();
	  for(unsigned int k=0; k<boxed_atoms[i][j].size(); k++){
		box_idx.x = i;
		box_idx.y = j;
		box_idx.z = k;
		temp1.push_back(get_adjacent_atoms(box_idx, boxed_atoms));
      }
	  temp.push_back(temp1);
    }
	result.push_back(temp);
  }
  
  return result;
}

vector<int> get_adjacent_atoms(coord &box, vector<vector<vector<vector<int> > > > &boxed_atoms)
//find atoms that lie in the same box or adacent boxes to the target box: 'box'.
{
  vector<int> result;

  int minx = 0;
  int miny = 0;
  int minz = 0;
  int maxx = boxed_atoms.size()-1;
  int maxy = boxed_atoms[0].size()-1;
  int maxz = boxed_atoms[0][0].size()-1;
  
  if(box.x > 0)
    minx = (int)box.x-1;
  if(box.y > 0)
    miny = (int)box.y-1;
  if(box.z > 0)
    minz = (int)box.z-1;
  if(box.x < boxed_atoms.size()-1)
    maxx = (int)box.x+1;
  if(box.y < boxed_atoms[0].size()-1)
    maxy = (int)box.y+1;
  if(box.z < boxed_atoms[0][0].size()-1)
    maxz = (int)box.z+1;
  for(int i=minx; i<=maxx; i++){
    for(int j=miny; j<=maxy; j++){
      for(int k=minz; k<=maxz; k++){
		for(unsigned int l=0; l<boxed_atoms[i][j][k].size(); l++){
		  result.push_back(boxed_atoms[i][j][k][l]);
		}
	  }
	}
  }
  
  return result;
}

vector<int> get_close_atoms(int target, Array1D<coord> &atom_boxes, vector<vector<vector<vector<int> > > > &array_atoms, PDBfile &pdb1, double dist_param)
//filter the adjacent atoms to identify all atoms that are close to (i.e. within 'dist_param' of) the atom
{
  vector<int> result;
  
  vector<int> *atoms = &array_atoms[(int)atom_boxes[target].x][(int)atom_boxes[target].y][(int)atom_boxes[target].z];
  
  for(unsigned int i=0; i<(*atoms).size(); i++){
	if((*atoms)[i]>target){
	  if(pdb1.get_distance(target,(*atoms)[i]) <= dist_param){
	    result.push_back((*atoms)[i]);
      }
	}
  }
  
  sort(result.begin(),result.end());

  return result;
}
