//
// This file is part of ProSMART.
//

#ifndef restrain_hbond_H
#define restrain_hbond_H

#include "restrain_boxing_algorithm.h"
#include "restrain_atomic_restraints.h"

struct hbond
{
    double DIST;
    double MIN_DIST;
    double MAX_DIST;
    int MIN_RESIDUE_SEPARATION;
    int MAX_RESIDUE_SEPARATION;
    vector<int> ALLOWED_RESIDUE_SEPARATIONS;
    vector<int> REMOVED_RESIDUE_SEPARATIONS;
    int RESTRAINT_TYPE;
    int OVERRIDE_MAX_BONDS;
    bool TROUBLESHOOT;
    double SIGMA;
    bool STRICT_FRAG;
};

bool test_atompair(PDBfile &, int, int, hbond &);
int get_max_bonds(PDBfile &, int, int &);
vector<vector<int> > h_bond_restraints(PDBfile &, vector<res_corresp> &, hbond &, vector<residue_alignment> &, vector<int> &, vector<int> &, vector<string> &);
void filter_restraints_by_max_bonds(PDBfile &, vector<vector<int> > &, vector<vector<int> > &, vector<unsigned int> &, double &);
void restore_hbond_restraints(PDBfile &, vector<res_corresp> &, vector<vector<int> > &, vector<vector<int> > &, vector<unsigned int> &, double &);
bool read_hbond_parameters_file(hbond &, string &);

#endif
