//
// This file is part of ProSMART.
//

#include "restrain_likelihood.h"

//these three functions need to be edited for different choices of the functional form of sigma

vector<double> set_k0(int n)
{
  vector<double> result;
  result.push_back(0.2);
  switch(n){
    case 2:
	  result.push_back(0.1);
  }
  return result;
}

vector<double> get_sigma2(int n, vector<vector<double> > &x_Brs, vector<double> &k)
{
  vector<double> result;
  double temp;
  
  switch(n){
    case 1:
	  for(unsigned int i=0; i<x_Brs[0].size(); i++){
	    temp = k[0];
	    if(temp<=0){
		  temp = 0.001;
	    }
		result.push_back(temp);
      }
	case 2:
	  for(unsigned int i=0; i<x_Brs[0].size(); i++){
	    temp = k[0] + k[1]*x_Brs[0][i];
	    if(temp<=0){
		  temp = 0.001;
	    }
		result.push_back(temp);
      }
  }

  return result;
}

vector<vector<double> > get_grad_sigma2(int n, vector<vector<double> > &x_Brs, vector<double> &k)
{
  vector<vector<double> > result;
  vector<double> temp;
  
  switch(n){
    case 1:
	  for(unsigned int i=0; i<x_Brs[0].size(); i++){
		temp.clear();
		temp.push_back(1);
		result.push_back(temp);
	  }
	case 2:
	  for(unsigned int i=0; i<x_Brs[0].size(); i++){
		temp.clear();
		temp.push_back(1);
		temp.push_back(x_Brs[0][i]);
		result.push_back(temp);
	  }
  }
  
  /*for(int i=0; i<x_Brs[0].size(); i++){
    r_k3 = pow(x_Brs[1][i],k3);
	s_k5 = pow(x_Brs[2][i],k5);
    temp.clear();
	temp.push_back(x_Brs[0][i]);
	temp.push_back(r_k3);
	temp.push_back(k2*r_k3*log(x_Brs[1][i]));
	temp.push_back(s_k5);
	temp.push_back(k4*s_k5*log(x_Brs[2][i]));
    result.push_back(temp);
  }*/

  return result;
}

// the rest of the functions in this file should remain static, assuming the same general functional form of the likelihood function

vector<double> get_x_m_2(vector<double> &x, vector<double> &m)
{
  double temp;
  vector<double> result;
  
  for(unsigned int i=0; i<x.size(); i++){
    temp = x[i]-m[i];
    result.push_back(temp*temp);
  }
  
  return result;
}

vector<double> get_normal(vector<double> &dr2s2, vector<double> &sigma2)
{
  vector<double> result;
  unsigned int n=sigma2.size();
  double PI2 = 8.0*atan(1.0);		// PI ~ 4.0*atan(1.0)
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(exp(-0.5*(dr2s2[i]))/sqrt(PI2*sigma2[i]));
  }
  return result;
}

vector<double> get_f_d(double w, double unif_1_n, vector<double> &f_n)
{
  vector<double> result;
  unsigned int n=f_n.size();
  double tmp = w*unif_1_n;
  double w1 = 1-w;

  for(unsigned int i=0; i<n; i++){
	result.push_back(tmp + w1*f_n[i]);
  }
  return result;
}

double logL_(vector<double> &f)	
{
  unsigned int n = f.size();
  double result = 0.0;

  for(unsigned int i=0; i<n; i++){
    result -= log(f[i]);
  }

  return result;
}

vector<double> grad_logL_(vector<double> &f_d, vector<double> &f_n, vector<double> &k, vector<double> &sigma2, vector<double> &xm2s2, vector<vector<double> > &grad_sigma2, double unif_1_n)
{
  vector<double> result;
  unsigned int n = f_d.size();
  unsigned int n1 = grad_sigma2[0].size();
  double temp;
  
  for(unsigned int i=0; i<n1; i++){
    result.push_back(0.0);
  }

  for(unsigned int i=0; i<n; i++){
	temp = (k[0]*f_n[i]*sigma2[i]*(xm2s2[i]-0.5))/f_d[i];
	result[0] -= (unif_1_n-f_n[i])/f_d[i];
	for(unsigned int j=1; j<n1; j++){
	  result[j] -= temp*grad_sigma2[i][j-1];
	}
  }
  
  return result;
}


double logL(vector<double> &x_m_2, vector<double> &s2)	
// x_m_2:(observation-mean)^2 s2:variance
//this function calculates -log(likelihood). Negative so that the output function can be minismised, rather than maximised.
{
  unsigned int n = x_m_2.size();
  double result = n*log(8.0*atan(1.0));		// PI is approximated by 4*atan(1.0)
  
  for(unsigned int i=0; i<n; i++){
    result += log(s2[i]) + (x_m_2[i]/s2[i]);
  }

  return (result*0.5);
}

vector<double> grad_logL(vector<double> &x_m_2, vector<double> &s2, vector<vector<double> > &grad_s2)
// x_m_2:(observation-mean)^2 s2:variance grad_s2:derivative of s2 w.r.t. the parameters
// x_m_2.size() = s2.size() = grad_s2.size()
// grad_s2[i].size() = number of parameters
{
  double temp;
  unsigned int n = grad_s2[0].size();	// n = number of parameters
  vector<double> result;
  for(unsigned int i=0; i<n; i++){
    result.push_back(0.0);
  }
  
  for(unsigned int i=0; i<x_m_2.size(); i++){
    temp = (1-(x_m_2[i]/s2[i]))/s2[i];
	for(unsigned int j=0; j<n; j++){
	  result[j] += temp*grad_s2[i][j];
	}
  }
  
  for(unsigned int j=0; j<n; j++){
	result[j] = result[j]/2;
  }

  return result;
}
