//
// This file is part of ProSMART.
//

#include "restrain_vector_operations.h"

double sd(vector<double> &x)
{
  return sqrt(var(x));
}

double var(vector<double> &x)
{
  double v = 0.0;
  double result;
  double n = x.size();
  
  for(int i=0; i<n; i++){
    v += x[i]*x[i];
  }
  
  result = v/(n-1);
  
  return result;
}

int get_inverse(vector<vector<double> > &M, vector<vector<double> > &MI)
{
  Array2D<double> M1 = convert_array(M);
  Array2D<double> M2;
  int result = get_inverse(M1, M2);
  if(result != 0){
    MI = convert_array(M2);
  }
  return result;
}

int get_inverse(Array2D<double> &M, Array2D<double> &MI)
//taken from: http://wiki.cs.princeton.edu/index.php/TNT
{
  // solve for inverse with LU decomposition
  JAMA::LU<double> lu(M);

  // create identity matrix
  Array2D<double> id1(M.dim1(), M.dim2(), (double)0);
  for (int i = 0; i < M.dim1(); i++) id1[i][i] = 1;

  // solves A * A_inv = Identity
  MI = lu.solve(id1);
  
  return lu.isNonsingular();	//returns 0 if matrix is singular, in which case MI is empty
}

Array2D<double> convert_array(vector<vector<double> > &M)
{
  TNT::Array2D<double> M1(M.size(), M.size(), (double)0);
  for(unsigned int i=0; i<M.size(); i++){
    for(unsigned int j=0; j<M.size(); j++){
      M1[i][j] = M[i][j];
    }
  }
  return M1;
}

vector<vector<double> > convert_array(Array2D<double> &M)
{
  vector<vector<double> > M1;
  vector<double> M2;
  for(int i=0; i<M.dim1(); i++){
    M2.clear();
    for(int j=0; j<M.dim2(); j++){
      M2.push_back(M[i][j]);
    }
	M1.push_back(M2);
  }
  return M1;
}

vector<vector<double> > identity(int n)
{
  vector<vector<double> > M;
  vector<double> v;
  for(int i=0; i<n; i++){
    v.push_back(0);
  }
  for(int i=0; i<n; i++){
    M.push_back(v);
  }
  for(int i=0; i<n; i++){
	M[i][i] = 1;
  }
  return M;
}

vector<vector<double> > diag(vector<double> n)
{
  vector<vector<double> > M;
  vector<double> v;
  for(unsigned int i=0; i<n.size(); i++){
    v.push_back(0);
  }
  for(unsigned int i=0; i<n.size(); i++){
    M.push_back(v);
  }
  for(unsigned int i=0; i<n.size(); i++){
	M[i][i] = n[i];
  }
  return M;
}

double mod(vector<double> &v)
{
  double result = 0.0;
  for(unsigned int i=0; i<v.size(); i++){
    if(v[i]>0){
      result += v[i];
	} else {
	  result += -v[i];
	}
  }
  return result;
}

vector<vector<double> > crossprod(vector<vector<double> > &M1, vector<vector<double> > &M2)
// M1 = nxm
// M2 = mxn
{
  vector<vector<double> > result;
  vector<double> temp;
  double temp1;
  unsigned int n=M1.size();
  unsigned int m=M2.size();
  
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<n; j++){
	  temp1 = 0.0;
	  for(unsigned int k=0; k<m; k++){
	    temp1 += M1[i][k]*M2[k][j];
	  }
	  temp.push_back(temp1);
	}
    result.push_back(temp);
  }
  return result;
}

vector<vector<double> > M_mult(double s, vector<vector<double> > &M)
{
  vector<vector<double> > result;
  vector<double> temp;
  unsigned int n=M.size();
  unsigned int m=M[0].size();
  
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<m; j++){
	  temp.push_back(M[i][j]*s);
	}
    result.push_back(temp);
  }
  return result;
}

void M_view(vector<vector<double> > &M)
{
  unsigned int n=M.size();
  unsigned int m=M[0].size();
  cout << endl;
  for(unsigned int i=0; i<n; i++){
	for(unsigned int j=0; j<m; j++){
	  cout << M[i][j] << " ";
	}
    cout << endl;
  }
  return;
}

vector<vector<double> > M_negative(vector<vector<double> > M)
{
  vector<vector<double> > result;
  vector<double> temp;
  unsigned int n=M.size();
  unsigned int m=M[0].size();
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<m; j++){
	  temp.push_back(-M[i][j]);
	}
    result.push_back(temp);
  }
  return result;
}


vector<vector<double> > M_add(vector<vector<double> > &M1, vector<vector<double> > &M2)
{
  vector<vector<double> > result;
  vector<double> temp;
  unsigned int n=M1.size();
  unsigned int m=M1[0].size();
  
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<m; j++){
	  temp.push_back(M1[i][j]+M2[i][j]);
	}
    result.push_back(temp);
  }
  return result;
}

vector<vector<double> > M_subtract(vector<vector<double> > &M1, vector<vector<double> > &M2)
{
  vector<vector<double> > result;
  vector<double> temp;
  unsigned int n=M1.size();
  unsigned int m=M1[0].size();
  
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<m; j++){
	  temp.push_back(M1[i][j]-M2[i][j]);
	}
    result.push_back(temp);
  }
  return result;
}

vector<double> v_prod(vector<vector<double> > &M, vector<double> &v)
// M = mxn
// v = nx1
{
  vector<double> result;
  double temp;
  unsigned int m=M.size();
  unsigned int n=v.size();
  
  for(unsigned int i=0; i<m; i++){
    temp = 0.0;
	for(unsigned int j=0; j<n; j++){
	  temp += M[i][j]*v[j];
	}
    result.push_back(temp);
  }
  return result;
}

vector<vector<double> > v_prod_T(vector<double> &v1, vector<double> &v2)
// v1 = nx1
// v2 = 1xn
{
  vector<vector<double> > result;
  vector<double> temp;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
    temp.clear();
	for(unsigned int j=0; j<n; j++){
	  temp.push_back(v1[i]*v2[j]);
	}
    result.push_back(temp);
  }
  return result;
}

double v_prod(vector<double> &v1, vector<double> &v2)
// v1 = 1xn
// v2 = nx1
{
  double result = 0.0;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
	result += v1[i]*v2[i];
  }
  return result;
}

vector<double> operator*(vector<double> &v1, vector<double> &v2)
//element-by-element multiplication
{
  vector<double> result;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(v1[i]*v2[i]);
  }
  return result;
}

vector<double> operator/(vector<double> &v1, vector<double> &v2)
//element-by-element division
{
  vector<double> result;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(v1[i]/v2[i]);
  }
  return result;
}

vector<double> s_prod(double s, vector<double> &v)
{
  vector<double> result;
  unsigned int n=v.size();
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(s*v[i]);
  }
  return result;
}

vector<double> v_add(vector<double> &v1, vector<double> v2)
{
  vector<double> result;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(v1[i]+v2[i]);
  }
  return result;
}

vector<double> v_subtract(vector<double> &v1, vector<double> &v2)
{
  vector<double> result;
  unsigned int n=v1.size();
  
  for(unsigned int i=0; i<n; i++){
	result.push_back(v1[i]-v2[i]);
  }
  return result;
}

vector<double> v_negative(vector<double> v)
{
  vector<double> result;
  for(unsigned int i=0; i<v.size(); i++){
    result.push_back(-v[i]);
  }
  return result;
}
