//
// This file is part of ProSMART.
//

////////////////////////////////////////////////
//options for when outputting fragment moments to file
//#define OUTPUT_FRAGMENTS	//output fragment moments to file
//#define FILTER_OUTPUT		//only output fragment-pairs that have a similar centroid distance

//#define FILTER_HELIX		//only output helical fragments
#ifndef FILTER_HELIX
//#define FILTER_STRAND		//only output strand fragments
#endif
#ifndef FILTER_HELIX
#ifndef FILTER_STRAND
//#define REMOVE_ALIGN		//dont output aligned fragments
//#define REMOVE_HELIX			//dont output helical fragments
//#define REMOVE_STRAND			//dont output helical fragments
#endif
#endif
////////////////////////////////////////////////

//#define OUTPUT_ALIGNMENT_FOR_ANALYSIS

//#define OUTPUT_DISTANCE_MATRICES
//#define PERFORM_CLUSTERING
//#define TROUBLESHOOTING_COUTS
//#define DISPLAY_ALIGN
//#define DISPLAY_ALIGN_REFINEMENT
//#define DISPLAY_RESIDUE_RECODING

#include "align_alignment_scoring.h"
#include "align_cluster.h"

int main(int argc, char *argv[]) 
{
    cout << "////////////////////////////////////////////////" << endl;
    cout << endl << "ProSMART ALIGN" << endl;
    
    if(argc != 53){
        cout << endl << "Error - incorrect arguments passed to ProSMART ALIGN."
        << endl << "Instance launched with command: " << endl;
        for(int i=0; i<argc; i++){
            cout << " " << argv[i];
        }
        cout << endl << "Note - 'prosmart_align' should not be manually executed. Please use 'prosmart'."
        << endl << "Program terminated." << endl;
        return 0;
    }
    
	initialise_reflectM();	//set up global variable, which stores 3x3 unitary reflection matrix
	initialise_identityM();	//set up global variable, which stores 3x3 identity matrix
	
    string filein1 = argv[1];
    string filename1 = get_full_filename(filein1);
    string filein2 = argv[2];
    string filename2 = get_full_filename(filein2);
    char domain1 = argv[3][0];
    char domain2 = argv[4][0];
    string workingdirectory = get_folder(argv[5]);
    
    /*vector<string> a1;
    output_pdb(a1,filein1,"tmp.pdb",domain1,0);*/

	
	// Length of fragment (in residues)
	unsigned short fragLen = atoi(argv[6]);	//default 9.
	if(fragLen%2==0){
        fragLen++;							//ensures fragLen is odd.
        cout << endl << "Fragment length must be odd. Changed to " << fragLen << "." << endl;
	}
	unsigned short frag_mod = (fragLen-1)/2;	//modifies residue index to get to centre of fragment
	
	double cluster_degrees = atof(argv[7]);	//default 15
	
	bool fragment_alignment_cutoff = atoi(argv[8]);	// default 0;
    
	bool PERFORM_CLUSTER = 1;
	PERFORM_CLUSTER = atoi(argv[9]);
	
	string library = argv[10];
	
	double ALIGN_SCORE = atof(argv[11]);	// colour score threshold for Procrustes score
	
	int ALIGN_MODE = atoi(argv[12]);		
    //mode=0 rotate/score using mainchain atoms.
	//mode=1 rotate/score using CAs.
	//mode=2 rotate using mainchain atoms, scoring using CAs. 
	
	bool EXTRA_REFINEMENT = atoi(argv[13]);	//specifies whether to refine alignment to achieve better-scoring alignment.
	
	double SIDE_SCORE = atof(argv[14]);     // colour score threshold for side chain RMSD
	
	bool HELIX = atoi(argv[15]);
	
	bool IDENTICAL = atoi(argv[16]);
	
	double HELIX_CUTOFF = atof(argv[17]);
	
	double HELIX_PENALTY = atof(argv[18]);
	
	unsigned int CLUSTER_MIN = atoi(argv[19]);
	
	double CLUSTER_LINKAGE = atof(argv[20]);
	
	double CLUSTER_RIGIDITY = atof(argv[21]);
	
	double CLUSTER_COLOR = atof(argv[22]);  //allows user-defined scaling
	vector<double> CLUSTER_COLOR_v;         //will contain relative weights
    
	coord green;
	coord red;
	green.x = atof(argv[23]);	//0		// definition of colors representing similar/dissimilar
	green.y = atof(argv[24]);	//1		// variables defined in align_output_filehandling
	green.z = atof(argv[25]);	//0
	red.x = atof(argv[26]);		//0.8
	red.y = atof(argv[27]);		//0
	red.z = atof(argv[28]);		//0
	define_pymol_colors(green,red);		//must be run before creating color scripts
	
	bool OUT_PDB = atoi(argv[29]);
	
	bool OUT_COLOR = atoi(argv[30]);
	
	double SUPERPOSE = atof(argv[31]);
    
	double CLUSTER_SCORE = atof(argv[32]);
	
	bool OUTPUT_CLUSTER_DM = atoi(argv[33]);
	
	string RANGE1 = argv[34];
    
    double SCORE_THRESHOLD = atof(argv[35]);
    
    bool DISPLAY_AS_COSINE_DISTANCE = atoi(argv[36]);
    
    bool OUT_PDB_FULL = atoi(argv[37]);
    		
    bool USE_MAINCHAIN_FOR_SIDERMSD = atoi(argv[38]);

    double NUM_DIST_THRESHOLD = atoi(argv[39]);

    bool FIND_REPLICATION = atoi(argv[40]);
    
    bool FIX_SIDE_CHAIN_ERRORS = atoi(argv[41]);
    
    bool NO_REWARD_SEQ = atoi(argv[42]);

    double REWARD_SEQ = atof(argv[43]);
   
   USE_DNARNA = atoi(argv[44]);
    
   bool SCORE_STRICT = atoi(argv[45]);
   
   bool USE_SIDE = atoi(argv[46]);
   
   bool OUTPUT_RMSD_FILES = atoi(argv[47]);

   USE_SIEVE = atoi(argv[48]);

   SIEVE_PARAMETER = atof(argv[49]);
   
   bool OUTPUT_SCREW = atoi(argv[50]);

	double CLUSTER_TRANS_LINKAGE = atof(argv[51]);

	double CLUSTER_TRANS_MAX = atof(argv[52]);
   
   bool NORMALISED_PROCRUSTES = 0;


	//###############
	
	vector<string> RANGE1v;
	vector<vector<int> > res_ranges1;
	vector<int> tmp_range;

    //specify range for fragment alignment using fragment library (only)
	if(RANGE1!="-" && HELIX==1){
		RANGE1v = string_to_vector(RANGE1,'_');
		for(unsigned int i=0; i<RANGE1v.size(); i++){
			tmp_range.clear();
			tmp_range.push_back(str_to_int(RANGE1v[i]));
			i++;
			tmp_range.push_back(str_to_int(RANGE1v[i]));
			res_ranges1.push_back(tmp_range);
		}
	}
    
    //###############
    
	//double PI = 4*atan(1.0);
	
    string fileout1;
    string fileout2;
    
    fileout1 = workingdirectory + filename1;
    fileout1 = file_append_name(fileout1,domain1);
    fileout2 = workingdirectory + filename2;
    fileout2 = file_append_name(fileout2,domain2);
    
    //###############	PDB file interface:
	
#ifdef PERFORMANCE
	double t1;
	double t2;
	t1 = get_time_sec();
#endif
	
    cout << endl << "Reading PDB files..." << endl;
    PDBfile pdb1;
	PDBfile pdb2;
	
	string obj1 = get_filename(filename1) + "_" + domain1;
	string obj2 = get_filename(filename2) + "_" + domain2;
	
	string input1 = workingdirectory + ".Input_Chains/" + obj1;
	string input2 = workingdirectory + ".Input_Chains/" + obj2;
	
	pdb1.read_formatted_pdb(input1);	//format that ProSMART launcher outputs.
	pdb2.read_formatted_pdb(input2);
	        
	//protocol for recording computation expense
	/*double t1;
     double t2;
     t1 = get_time_sec();
     
     t2 = get_time_sec();
     ofstream outfile("tmp.txt",ios::app);
     outfile << t2-t1 << endl;
     outfile.close();
     return 0;*/
	
	//cout << endl << pdb1 << endl;
	//pdb1.readPDB(filein1, domain1);	// read pdbfile
    //pdb2.readPDB(filein2, domain2);	
    //pdb1.filter_alt_atoms();      //only the first conformation is taken - any other alternative conformations are removed.
    //pdb2.filter_alt_atoms();
	//cout << endl << pdb1 << endl << pdb2 << endl;
	
	/*
     //this outputs the number of atoms in each PDB file. Results are appended to an existing file, if it exists.
     ofstream outfile;
     outfile.open("./no_of_atoms.txt",ios::app);
     if(outfile.is_open()){
     outfile << pdb1.size() << "\t" << pdb2.size() << endl;
     outfile.close();
     } else {
     cout << endl << "Failed - could not open file: ./no_of_atoms.txt";
     }	
     return 0;*/
    
    vector<res_corresp> original_res1 = read_original_res(input1+"_orig");
    vector<res_corresp> original_res2 = read_original_res(input2+"_orig");
    
	//vector<res_corresp> original_res1;
	//vector<res_corresp> original_res2;
    //pdb1.rename_resnum(original_res1, fragLen);
    //pdb2.rename_resnum(original_res2, fragLen);
    
	/*if(HELIX==1){
     pdb2.trim(fragLen);
     //cout << endl << pdb2 << endl;
     }*/
    
	///////////////////////////

    Residues res1;
    Residues res2;
    res1.create(pdb1);		//Establish res1 to be linked to pdb1.
	res2.create(pdb2);
	//res1.read_formatted_res(input1+"_res",pdb1);
    //res2.read_formatted_res(input2+"_res",pdb2);

#ifdef OUTPUT_LOWOCCUP_ALT_COMPLETE_FILES
    vector<unsigned int> incomplete1 = res1.get_incomplete_residues();
    vector<unsigned int> incomplete2 = res2.get_incomplete_residues();
    if(incomplete1.size()>0){
        string out_complete1 = "log/" + obj1 + "_incomplete.txt";
        ofstream out_complete;
        if(!check_file_exists(out_complete1)){
            out_complete.open(out_complete1.c_str());
            if(out_complete.is_open()){
                for(unsigned int i=0; i<incomplete1.size(); i++){
                    out_complete << obj1 << " " << original_res1[incomplete1[i]].res << original_res1[incomplete1[i]].ins << endl;
                }
                out_complete.close();
            }
        }
    }
    if(incomplete2.size()>0){
        string out_complete2 = "log/" + obj2 + "_incomplete.txt";
        ofstream out_complete;
        if(!check_file_exists(out_complete2)){
            out_complete.open(out_complete2.c_str());
            if(out_complete.is_open()){
                for(unsigned int i=0; i<incomplete2.size(); i++){
                    out_complete << obj2 << " " << original_res2[incomplete2[i]].res << original_res2[incomplete2[i]].ins << endl;
                }
                out_complete.close();
            }
        }
    }
#endif

	Frag f1;
	Frag f2;
	f1.create(res1,fragLen,ALIGN_MODE);	//Establish f1 to be linked to res1.
	f2.create(res2,fragLen,ALIGN_MODE);	//Establish f2 to be linked to res2.
    
	vector<int> custom_fragments1;
    
    int N1 = f1.size();
    int N2 = f2.size();
	string tmp_1 = int_to_str(pdb1.size());
	string tmp_2 = int_to_str(pdb2.size());
	string tmp_3 = int_to_str(res1.size());
	string tmp_4 = int_to_str(res2.size());
	string tmp_5 = int_to_str(N1);
	string tmp_6 = int_to_str(N2);
	
    cout << "pdb1:  " << fill_out(filename1,filename2) << "  chain " << domain1 << "   "; 
    cout << fill_out_back(tmp_1,tmp_2) << " atoms,  ";
    cout << fill_out_back(tmp_3,tmp_4) << " residues,  ";
    cout << fill_out_back(tmp_5,tmp_6) << " fragments." << endl;
    cout << "pdb2:  " << fill_out(filename2,filename1) << "  chain " << domain2 << "   ";
    cout << fill_out_back(tmp_2,tmp_1) << " atoms,  ";
    cout << fill_out_back(tmp_4,tmp_3) << " residues,  ";
    cout << fill_out_back(tmp_6,tmp_5) << " fragments." << endl;
    
    //############### Align Fragments:
    
    Align alignment;
    vector<residue_alignment> Res_align;
    vector<residue_alignment> Res_align_sim;
    double SeqID_sim;
    double SeqID;
    string SEQ_dir;
	vector<string> info_helix = info_vector_helix(filename1, filename2, domain1, domain2, fragLen, fragment_alignment_cutoff, res1.size(), res2.size(), SUPERPOSE, ALIGN_MODE, EXTRA_REFINEMENT, SIDE_SCORE);
	
	string ALIGN_dir = workingdirectory + "Residue_Alignment_Scores/" + obj1 + "/";
	string tempfileout1 = ALIGN_dir + obj1 + "_" + obj2 + ".txt";
	string tempfileout1_types = ALIGN_dir + "types_" + obj1 + "_" + obj2 + ".txt";
	
	if(N1 <= 0 || N2 <= 0){
		//write empty alignment file, then exit
		write_alignment(res1, res2, info_helix, Res_align, tempfileout1, original_res1, original_res2, DISPLAY_AS_COSINE_DISTANCE);
        cout << endl << "Error - no fragments established for 1 or more chains." << endl;
		cout << "Program terminated." << endl;
		return 0; 
    }
    
#ifdef PERFORMANCE
	t2 = get_time_sec();
	write_performance_file("Input.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
	
#ifdef PERFORMANCE
	t1 = get_time_sec();
#endif
    cout << endl << "Creating fragment dissimilarity matrix..." << endl;
    Array2D<double> FDM;
	Array1D<Coords> frag_norm1(f1.size());
    Array1D<Coords> frag_norm2(f2.size());
    vector<double> trcov1;
    vector<double> trcov2;
    if(ALIGN_MODE==2){
        FDM = fragDM_CA(f1,f2,frag_norm1,frag_norm2,trcov1,trcov2);		//transform with all, score with CA.
    } else {
        FDM = fragDM_all(f1,f2,frag_norm1,frag_norm2,trcov1,trcov2);	//transform and score with same matrix (whether all or just CA). 
	}
#ifdef PERFORMANCE
	t2 = get_time_sec();
	write_performance_file("DM.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
	    
	//this output gives the correct protocol used for accessing information about the original residue.
	/*for(unsigned int i=0; i<f1.size(); i++){
     cout << endl << "frag: " << i << "\t res_i: " << f1.idx(i) << "\t central_res_i: " << f1.idx(i)+frag_mod << "\t orig_res: " << original_res1[f1.idx(i)+frag_mod].res;
     }*/
	
    //############### Secondary structure alignment (optional)
    //double align_percent_helix;
    //vector<string> info_helix;
    //vector<Transform> transf_helix;
    if(HELIX==1){
		if(res_ranges1.size()>0){
			// custom range is supplied - do not need to align.
			custom_fragments1 = f1.filter(original_res1,res_ranges1);
			alignment = helix_alignment(custom_fragments1);
		} else {
			// align fragments based on dissimilarity criteria.
			alignment = helix_alignment(FDM,ALIGN_SCORE);
		}
		
		//cout << endl << pdb1 << endl;
		//cout << alignment;
		
		get_res_align_helix(alignment, f1, FDM, Res_align);
		/*for(unsigned int i=0; i<Res_align.size(); i++){
         cout << endl << Res_align[i].res1 << " " << Res_align[i].res2 << " " << Res_align[i].dist << " " << Res_align[i].dist2 << " " << Res_align[i].dist3;
         }*/
		
		double align_percent_helix = (double)((Res_align.size()*100.0)/res1.size());
        
		cout.precision(1);
        cout << endl << fixed << "Full Alignment: " << Res_align.size() <<  " (" << align_percent_helix << "%)" << " residues aligned";
		cout.precision(3);
		cout << endl;
        
		//output alignment
		write_alignment(res1, res2, info_helix,Res_align,tempfileout1, original_res1, original_res2, DISPLAY_AS_COSINE_DISTANCE);
		write_residue_types(info_helix,Res_align,tempfileout1_types, original_res1);
		
		/*if(Res_align.size()==0){
		 cout << endl << endl << "ProSMART ALIGN finished." << endl;
		 return 0;
		 }*/
		
		if(OUT_PDB==1){
			//output pdb
			string PDBOUT_dir = workingdirectory + "Superposition/PDB_files/";
			tempfileout1 = PDBOUT_dir + obj1 + ".pdb";
			output_pdb(info_helix,filein1,tempfileout1,domain1,OUT_PDB_FULL);	//whole chain, protein 1
		}
		
		if(OUT_COLOR==1){
			//output pymol color
			string PYMOL_dir = workingdirectory + "Colour_Scripts/";
			tempfileout1 = PYMOL_dir + obj1 + "_" + obj2 + ".pml";
			write_pymol_helix(info_helix, Res_align, res1, obj1, tempfileout1, domain1, ALIGN_SCORE, original_res1);
		}
        
		//create alignment matrix
		string align_fileout = ALIGN_dir + "." + obj1 + "_" + obj2 + ".res";
		create_alignment_matrix(res1,alignment,f1,FDM,fragLen,Res_align,align_fileout);
        
		cout << endl << endl << "ProSMART ALIGN completed." << endl << endl;
        return 0;
    }
	//############### End secondary structure alignment - everything after this point applies only to ordinary pairwise alignment
    
    
	//############### Get standardised Procrustes distance matrix
    
	Array2D<double> FDMorig = FDM;
	if(NORMALISED_PROCRUSTES==1){
		FDM = get_proc_norm(frag_norm1, frag_norm2, FDMorig, fragLen);
		HELIX_PENALTY = 0.0;
	}
    
    /////////////// START OF SPATIAL STRUCTURAL ALIGNMENT
    
#ifdef NEW_SPATIAL_ALIGNMENT

    // (1) For each chain, for each fragment, find all fragments that are close in space (with XÅ)
    // Subject to criteria, e.g. >=N residues apart in sequence
    // Fragment position is represented by central CA atom (although in general other criteria could be used to determine whether fragments are "close").
    FragPair frag_pair1(f1);
    
    
    
    cout << endl << "Got to end" << endl;
    return 0;
    
#endif
    
    /////////////// END OF SPATIAL STRUCTURAL ALIGNMENT
    
    //############### Dynamic alignment and refinement
    if(IDENTICAL == 0){
        
#ifdef PERFORMANCE
		t1 = get_time_sec();
#endif
        //any modification to fragment distance matrix can go here.
        Array2D<double> FDM_new = mod_FDM_by_sequence(f1,f2,FDM,NO_REWARD_SEQ,REWARD_SEQ);   //if fragments are sequence-identical, reward score.
        
        cout << endl << "Using dynamic programming to align fragments..." << endl;
        if(FIND_REPLICATION){
            Array2D<double> FDM_mod = FDM;
            double penalty1 = 0.3;
            for(int i=0; i<FDM_mod.dim1(); i++){
                FDM_mod[i][0] = penalty1;
                FDM_mod[i][FDM_mod.dim1()-1] = penalty1;
            }
            for(int i=0; i<FDM_mod.dim2(); i++){
                FDM_mod[0][i] = penalty1;
                FDM_mod[FDM_mod.dim2()-1][i] = penalty1;
            }
            for(int i=0; i<FDM_mod.dim1(); i++){
                FDM_mod[i][i] = 100.0;      //put arbitrarily large score on matrix diagonals
            }
            alignment = dynamAlign(FDM_mod,f1,f2,HELIX_CUTOFF,HELIX_PENALTY);
            
            string tmp_out = obj1 + "_" + obj2 + ".txt";
            fileoutput_array(FDM_mod,tmp_out,"_FDM",0);
        } else {
            alignment = dynamAlign(FDM_new,f1,f2,HELIX_CUTOFF,HELIX_PENALTY);			//align and refine one-to-one fragment correspondence
        }
        //string tmp_out = obj1 + "_" + obj2 + ".txt";
		//fileoutput_array(FDM_new,tmp_out,"_FDMnew",0);
		//fileoutput_array(FDM,tmp_out,"_FDM",0);
		/*double tmp_score = 0.0;
         for(unsigned int i=1; i<=alignment.len(); i++){
         tmp_score += FDM[alignment.get(1,i)][alignment.get(2,i)]-5.0;
         cout << FDM[alignment.get(1,i)][alignment.get(2,i)]-5.0 << ",";
         }
         cout << endl << endl << tmp_score << endl << alignment.len() << endl << tmp_score/alignment.len() << endl << endl;
         */
        
#ifdef PERFORMANCE
		t2 = get_time_sec();
		write_performance_file("DynamicProgramming.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
#ifdef PERFORMANCE
		t1 = get_time_sec();
#endif

		if(EXTRA_REFINEMENT==1){
			cout << endl << "Refining fragment alignment..." << endl;
			alignment = align_refine(alignment,FDM_new);
        }

#ifdef PERFORMANCE
		t2 = get_time_sec();
		write_performance_file("Refinement.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
#ifdef PERFORMANCE
		t1 = get_time_sec();
#endif
		ensure_res_corresp(alignment,f1,f2,FDM_new,original_res1,original_res2);	//refine fragment alignment, ensuring one-to-one residue correspondence

#ifdef PERFORMANCE
		t2 = get_time_sec();
		write_performance_file("Optimisation.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
	} else {
        cout << endl << "Aligning fragments..." << endl;
        alignment = identicalAlign(f1,f2,original_res1,original_res2);
    }
	
    /////////////// END OF CONFORMATION INDEPENDENT STRUCTURAL ALIGNMENT
    
    cout << endl << alignment.len() << " structural fragments aligned." << endl;
    
    if(SCORE_THRESHOLD==1000.0){
        cout << endl << "Fragment alignment not filtered by Procrustes score." << endl;
    } else {
        // Filter Alignment by Procrustes score
        cout << endl << "Removing fragment-pairs with Procrustes score >" << SCORE_THRESHOLD << endl;
        for(unsigned int i=1; i<=alignment.len(); i++){
            if(FDM[alignment.get(1,i)][alignment.get(2,i)] > SCORE_THRESHOLD){
                i--;
                alignment.erase(i);
            }
        }
        cout << alignment.len() << " structural fragments aligned after score filtering." << endl;
    }
    
    /*if(alignment.len() <= 0){
        cout << endl << endl << "An alignment could not be established."
		<< endl << "Possible solution: try different parameter values."
		<< endl << endl << "ProSMART ALIGN finished." << endl << endl;
		return 0;
    }*/
	
	///////////////
	
	//OUTPUT EIGENVALUES AND SCORES FOR ALIGNED FRAGMENT PAIRS
	/*vector<frag_score> observed;
     frag_score tmp;
     Array1D<double> eigen1;
     Array1D<double> eigen2;
     for(unsigned int i=1; i<=alignment.len(); i++){
     eigen1 = eigenvalues(frag_norm1[alignment.get(1,i)]);
     eigen2 = eigenvalues(frag_norm2[alignment.get(2,i)]);
     tmp.eig1 = ((eigen1[0]+eigen2[0])/2);
     tmp.eig2 = ((eigen1[1]+eigen2[1])/2);
     tmp.eig3 = ((eigen1[2]+eigen2[2])/2);
     tmp.score = FDMorig[alignment.get(1,i)][alignment.get(2,i)];
     tmp.mean = 0.0;
     tmp.sd = 0.0;
     tmp.len = 0;
     observed.push_back(tmp);
     }
     get_procrustes_normalisation(observed,fragLen);
     
     return 0;*/
	
	///////////////
	
	//read library config file
	string filename = library + "config.txt";
	vector<vector<string> > config = read_file_lines(filename);
	for(unsigned int i=0; i<config.size(); i++){
		if(config[i].size()!=8){
			config.erase(config.begin()+i);
			i--;
			continue;
		}
	}
	
#ifdef OUTPUT_ALIGNMENT_FOR_ANALYSIS
	//double cent1 = get_av_centroid(frag_norm1);	//average of centroid sizes over whole alignment
	//double cent2 = get_av_centroid(frag_norm2);
	int i1 = 0;
	int i2 = 0;
	vector<string> frag_types1;
	vector<string> frag_types2;
	ofstream outfile;
	string fileout_string = workingdirectory + "Alignment/" + get_filename(filename1) + "_" + domain1 + "_" + get_filename(filename2) + "_" + domain2 + ".txt";
	Array1D<double> eigen1;
	Array1D<double> eigen2;
	outfile.open(fileout_string.c_str());
    if(outfile.is_open()){
		//outfile << "# Cent1\tCent2\tType1\tType2\tCentral" << endl;
        outfile.precision(4);
		fragment_library_types(f1,config,library,frag_types1,fragLen);
		fragment_library_types(f2,config,library,frag_types2,fragLen);
		for(unsigned int i=1; i<=alignment.len(); i++){
			i1 = alignment.get(1,i);
			i2 = alignment.get(2,i);
			eigen1 = eigenvalues(frag_norm1[i1]);
			eigen2 = eigenvalues(frag_norm2[i2]);
			outfile << FDM[i1][i2] << "\t" 
			<< frag_types1[i1] << "\t"
			<< frag_types2[i2] << "\t"
			<< eigen1[0] << "\t" << eigen1[1] << "\t" //<< eigen1[2] << "\t"
			<< eigen2[0] << "\t" << eigen2[1] << "\t" //<< eigen2[2] << "\t"
			<< endl;
		}
		cout << endl << "Alignment file written to: " << fileout_string;
		outfile.close();
    }
	return 0;
#endif
	
	
    //this output gives a good indication of the correct protocol used for accessing information about the original residue from the fragment alignment.
    /*for(unsigned int i=1; i<=alignment.len(); i++){
	 cout << endl << "alignment: " << i << "\tscore: " << FDM[alignment.get(1,i)][alignment.get(2,i)];
	 cout << endl << "\tfrag_i: " << alignment.get(1,i) << "\t res_i: " << f1.idx(alignment.get(1,i)) << "\t central_res_i: " << f1.idx(alignment.get(1,i))+frag_mod << "\t orig_res: " << original_res1[f1.idx(alignment.get(1,i))+frag_mod].res;
	 cout << endl << "\tfrag_i: " << alignment.get(2,i) << "\t res_i: " << f2.idx(alignment.get(2,i)) << "\t central_res_i: " << f2.idx(alignment.get(2,i))+frag_mod << "\t orig_res: " << original_res2[f2.idx(alignment.get(2,i))+frag_mod].res;
	 }*/
	
#ifdef OUTPUT_FRAGMENTS
	output_moments(alignment,f1,f2,FDM);
	output_align_moments(alignment,f1,f2,FDM);
#endif
	
	
	//############### Fragment Scoring
	
	//prediction of procrustes scores of consecutively aligned fragment pairs
	//vector<double> fwd_pred = score_prediction(alignment,f1,f2,frag_norm1,frag_norm2,trcov1,trcov2);
	//vector<double> back_pred = back_score_prediction(alignment,f1,f2,frag_norm1,frag_norm2,trcov1,trcov2);
#ifdef PERFORMANCE
	t1 = get_time_sec();
#endif
	vector<double> frag_rot = interfragment_rotation(alignment,f1,f2,frag_norm1,frag_norm2);
	
	vector<vector<double> > other_scores = get_other_scores(alignment,f1,f2,frag_norm1,frag_norm2,FDM);
	
	//vector<double> proc_norm;
	//if(NORMALISED_PROCRUSTES==1){
    //get normalised procrustes score, but for the ordinary alignment.
    //this should not be done in general, but does provide useful information for comparison
    //proc_norm = get_proc_norm(alignment,frag_norm1,frag_norm2,FDM);
	//}
	
	//get colours for each fragment in the library
	vector<coord> library_colors;
	coord tmp_crd;
	for(unsigned int i=0; i<config.size(); i++){
		tmp_crd.x = atof(config[i][5].c_str());
		tmp_crd.y = atof(config[i][6].c_str());
		tmp_crd.z = atof(config[i][7].c_str());
		library_colors.push_back(tmp_crd);
	}
    
	//fragment type identification - gets codes ready for main alignment output file and for Normalised Procrustes score calculation.
	vector<string> res_sse1;
	vector<int> res_type1 = new_sse(res1,config,library,res_sse1);
	vector<string> res_sse2;
	vector<int> res_type2 = new_sse(res2,config,library,res_sse2);
	
    //############### Residue Scoring
    //get residue alignment, residue scores, and global sequence identity
    //for full alignment, and also just for similar residues
	
	//filter alignment so that only fragment-pairs better than random are identified
	if(NORMALISED_PROCRUSTES==1){
		/*for(unsigned int i=1; i<=alignment.len(); i++){
         if(FDM[alignment.get(1,i)][alignment.get(2,i)] >= 0.0){
         alignment.erase(i-1);
         i--;
         }
         }*/
        
		//TEMPORARY SOLUTION, CONVERTING NEGATIVE DISSIMILARITY SCORES INTO POSITIVE SIMILARITY SCORES
		for(unsigned int i=1; i<=alignment.len(); i++){
			if(FDM[alignment.get(1,i)][alignment.get(2,i)] != 0.0){
				FDM[alignment.get(1,i)][alignment.get(2,i)] = -FDM[alignment.get(1,i)][alignment.get(2,i)];
			}
		}
	}

    if(alignment.len()>0){
        get_res_align(alignment, f1, f2, FDM, Res_align,frag_mod,Res_align_sim,SUPERPOSE,SeqID,SeqID_sim,res1,res2,frag_rot,other_scores,res_sse1,res_sse2,NORMALISED_PROCRUSTES,USE_MAINCHAIN_FOR_SIDERMSD,NUM_DIST_THRESHOLD,FIX_SIDE_CHAIN_ERRORS,SCORE_STRICT);
	}
    //cout << endl << SeqID << " " << SeqID_sim << endl;
    /*cout << endl << endl << Res_align.size() << endl << Res_align_sim.size() << endl;
    cout << endl << "Res1\tRes2\torig1\torig2\tmin\tcentral\tside\trot";
    cout.precision(4);
    for(unsigned int i=0; i<Res_align.size(); i++){
        cout << endl << Res_align[i].res1
        << "\t" << Res_align[i].res2
        << "\t" << original_res1[Res_align[i].res1].res
        << "\t" << original_res2[Res_align[i].res2].res
        << "\t" << Res_align[i].dist
        << "\t" << Res_align[i].dist2
        << "\t" << Res_align[i].dist3
        << "\t" << Res_align[i].rot;
        cout << endl << "\t" << pdb1.line(res1.get_CA_idx(Res_align[i].res1));
        cout << "\t" << pdb2.line(res2.get_CA_idx(Res_align[i].res2));
    }*/
    
    //check that there is actually an alignment!
    /*if(Res_align.size() <= 0){
        cout << endl << endl << "An alignment could not be established."
		<< endl << "Possible solution: try different parameter values."
		<< endl << endl << "ProSMART ALIGN finished." << endl << endl;
		return 0;
    }*/
	
   if(OUTPUT_RMSD_FILES){
       string fileout_side = workingdirectory + "Residue_Alignment_Scores/" + get_filename(filename1) + "_" + domain1 + "/" + get_filename(filename1) + "_" + domain1 + "_" + get_filename(filename2) + "_" + domain2 + "_global.txt";
      side_global_RMSD(Res_align,res1,res2,SUPERPOSE,fileout_side);    //this overwrites some scores in Res_align if OVERWRITE_MAXDIST_NDIST_SCORES is defined
   }
    
    //get global scores
    double av_score_central = 0.0;
    double min_score_central = -1.0;
    double av_score_min = 0.0;
    double align_rmsd = 0.0;
    double align_percent = 0.0;
    double av_sideRMSD_score = 0.0;
    double av_sideMaxDist_score = 0.0;
    vector<int> no_large_side;
    double asa_corr = 0.0;
    
    if(alignment.len()>0){
        min_score_central = min_central_score(Res_align);
        av_score_central = av_central_score(Res_align);
        av_score_min = av_min_score(Res_align);
        align_rmsd = alignment_RMSD(Res_align,res1,res2);
        align_percent = (double)(Res_align.size()*100.0)/max(res1.size(),res2.size());
#ifdef EXTRA_GLOBAL_SCORES
        av_sideRMSD_score = av_sideRMSD(Res_align);
        av_sideMaxDist_score = av_sideMaxDist(Res_align);
        no_large_side = no_large_side_dist(Res_align);
        asa_corr = asa_correlation(Res_align);
#endif
        //double KS = get_KS(other_scores);
        //double NewScore = get_Score(other_scores);

    } else {
        SeqID = 0.0;
        SeqID_sim = 0.0;
    }

    cout.precision(1);
    cout << endl << fixed << "Alignment: " << Res_align.size() <<  " (" << align_percent << "%)" << " residues aligned";
    if(alignment.len()>0){
        cout << endl << "Strict sequence identity of aligned residues: " << SeqID << "%";
        cout.precision(3);
        cout << endl << fixed << "Rigid alignment global RMSD = " << align_rmsd;
        cout << endl << "Average residue scores:";
        cout << endl << "\tProcrustes = " << av_score_central;
        cout << endl << "\tFlexible   = " << av_score_min;
        //cout << endl << "Normalised scores:";
        //cout << endl << "\tKolmogorov-Smirnov  = " << KS;
        //cout << endl << "\tDissimilarity Score = " << NewScore;
    }
    cout << endl;
    
    /*if(Res_align_sim.size() <= 0){
	 cout << endl << endl 
	 << "Warning - there were no well-aligned residues, according to the criteria that score < " << ALIGN_SCORE << "."
	 << endl << "Possible solution: try increasing the value of the parameter: -score"
	 << endl << endl;// << "ProSMART ALIGN finished." << endl << endl;
	 //return 0;
	 }
	 
	 double av_score_central_sim = -1.0;
	 double av_score_min_sim = -1.0;
	 double align_rmsd_sim =  -1.0;
	 double align_percent_sim = 0.0;
	 
	 if(Res_align_sim.size() > 0){
	 av_score_central_sim = av_central_score(Res_align_sim);
	 av_score_min_sim = av_min_score(Res_align_sim);
	 align_rmsd_sim =  alignment_RMSD(Res_align_sim,res1,res2);
	 align_percent_sim = (double)(Res_align_sim.size()*100.0)/min(res1.size(),res2.size());
	 cout.precision(1);
	 cout << endl << fixed << "Well Aligned: " << Res_align_sim.size() <<  " (" << align_percent_sim << "%)" << " residues aligned";
	 cout << endl << "Strict sequence identity of aligned residues: " << SeqID_sim << "%";
	 cout.precision(3);
	 cout << endl << fixed << "Rigid alignment average RMSD = " << align_rmsd_sim;
	 cout << endl << "Average residue scores:";
	 cout << endl << "\tCentral = " << av_score_central_sim;
	 cout << endl << "\tMinimum = " << av_score_min_sim;
	 cout << endl;
	 }*/
	
#ifdef PERFORMANCE
	t2 = get_time_sec();
	write_performance_file("Scoring.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
	
    //############### output files
#ifdef PERFORMANCE
	t1 = get_time_sec();
#endif
    //write a vector<string> identifying the input parameters supplied via command line arguments, etc.
    //this info is inserted into appriate output files.
    vector<string> info = info_vector(filename1, filename2, domain1, domain2, fragLen, fragment_alignment_cutoff, res1.size(), res2.size(), Res_align.size(), SeqID, align_rmsd, av_score_central, av_score_min, ALIGN_SCORE, ALIGN_MODE, EXTRA_REFINEMENT, SIDE_SCORE);
    /*for(unsigned int i=0; i<info.size(); i++){
	 cout << endl << info[i];
	 }*/
	
    //Output global statistics. Create files in: Scores/Single
    output_scores(filename1,filename2,domain1,domain2,workingdirectory,Res_align.size(),align_percent,SeqID,align_rmsd,av_score_central,av_score_min,min_score_central,info,av_sideRMSD_score,av_sideMaxDist_score,no_large_side,asa_corr);
    //output_scores("Similar",filename1,filename2,domain1,domain2,workingdirectory,Res_align_sim.size(),align_percent_sim,SeqID_sim,align_rmsd_sim,av_score_central_sim,av_score_min_sim, info);

    //writes pdb files of the two chains, superposed, based on the full residue alignment.
    //writes pymol files that color the chains by residue alignment score.
    //writes alignment files
    Transform global_transf = output_alignment(info, pdb1, pdb2, Res_align, Res_align_sim, f1, f2, res1, res2, filein1, fileout1, domain1, filein2, fileout2, domain2, workingdirectory, filename1, filename2, original_res1, original_res2, ALIGN_SCORE, SIDE_SCORE, res_type1, res_type2, library_colors, OUT_PDB, OUT_COLOR, NORMALISED_PROCRUSTES, SUPERPOSE, DISPLAY_AS_COSINE_DISTANCE, OUT_PDB_FULL, USE_SIDE);

   if(OUTPUT_SCREW){
      //write pymol screw axis-angle representation corresponding to global superposition. This is useful for looking at NCS operators.
      string pymol_screw_out = workingdirectory + "Superposition/Transformations/" + obj1 + "/" + obj1 + "_" + obj2;
      write_pymol_screw_axis(global_transf,pymol_screw_out,"global");
   }
   
#ifdef PERFORMANCE
	t2 = get_time_sec();
	write_performance_file("Output.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
	
	/////////////////////////////
	//these output to Scores/Residues. These files are sidechainRMSD score vs residue index.
	//this is operational, but disabled at current until it is deemed to be useful.
	//generate file of residue-based sidechain rmsd scores
    /*string temp;
	 temp = make_subdirectory(workingdirectory,"Scores");
	 temp = make_subdirectory(temp,"Residues"); 
	 string res_fileout = temp + "SidechainRMSD_" + delete_ext(filename1) + "_" + domain1 + "_"  + delete_ext(filename2) + "_" + domain2 + ".tmp";
	 string res_fileout2 = temp + "SidechainRMSD_" + delete_ext(filename2) + "_" + domain2 + "_"  + delete_ext(filename1) + "_" + domain1 + ".tmp";
	 vector<string> res_list = pdb1.get_reslist();								//list of resnums in pdb
	 vector<string> res_list2 = pdb2.get_reslist();							//list of resnums in pdb
	 vector<string> align_list = get_orig_res1(Res_align_sim,original_res1);	//list of original resnums corresponding to residue alignment
	 vector<string> align_list2 = get_orig_res2(Res_align_sim,original_res2);	//list of original resnums corresponding to residue alignment
	 vector<int> res_corresp = get_resnum_corresp(res_list,align_list);		//indentifies the indexes within Res_align_sim that correspond to residues
	 vector<int> res_corresp2 = get_resnum_corresp(res_list2,align_list2);		//indentifies the indexes within Res_align_sim that correspond to residues
	 output_residue_scores(Res_align_sim,res_list,res_corresp,res_fileout,info);	//output to file
	 output_residue_scores(Res_align_sim,res_list2,res_corresp2,res_fileout2,info);	//output to file
	 */
	
	///////////////////////////
	/*
	 #ifdef OUTPUT_DISTANCE_MATRICES	
	 //for troubleshooting
	 fileoutput_array(FDM,fileout1,"_FDM",0);
	 Array2D<double> FDM_alignment = alignment.align_DM(FDM);
	 fileoutput_array(FDM_alignment,fileout1,"_alignment",0);
	 Array2D<double> FDM_new_alignment = refined_alignment.align_DM(FDM);
	 fileoutput_array(FDM_new_alignment,fileout1,"_new_alignment",0);
	 #endif
	 */
	
	///////////////////////////		//unneeded functionality currently disabled
    
    //output files that specify residue numbers
    //string residue_list = workingdirectory + "Scores/Residues/" + delete_ext(filename1) + "_" + domain1 + ".residues";
    //pdb1orig.output_resnum(domain1,residue_list);
    //residue_list = workingdirectory + "Scores/Residues/" + delete_ext(filename2) + "_" + domain2 + ".residues";
    //pdb2orig.output_resnum(domain2,residue_list);
	
    /*string ncs_fileout;
	 vector<residue_alignment> Res_align_ncs;
	 vector<string> align_list_ncs;
	 vector<int> res_corresp_ncs;
	 //generate NCS residue selection script
	 if(USE_NCS==1){
	 sys_return = system(("mkdir -p " + workingdirectory + "NCS/").c_str());
	 ncs_fileout = workingdirectory + "NCS/" + delete_ext(filename1) + "_" + domain1 + "_"  + delete_ext(filename2) + "_" + domain2 + ".txt";
	 Res_align_ncs = filter_align_rmsd(Res_align_sim,SIDE_SCORE);
	 align_list_ncs = get_orig_res1(Res_align_ncs,original_res1);	//list of original resnums corresponding to residue alignment
	 res_corresp_ncs = get_resnum_corresp(res_list,align_list_ncs);	//indentifies the indexes within Res_align_ncs that correspond to residues
	 output_ncs(Res_align_ncs,res_list,res_corresp_ncs,domain1,domain2,ncs_fileout,NCS_WEIGHT);		//converts to ncs format
	 }*/
	///////////////////////////
	
    int no_clusters = 0;
    vector<Transform> cluster_transf;
    
	//identify rigidly conserved structural units.
    if(alignment.len() < CLUSTER_MIN){
        cout << endl << endl << "Insufficient aligned fragment-pairs for rigid substructure identification - at least "
        << CLUSTER_MIN << " required.";
        
	} else if(PERFORM_CLUSTER == 1){
#ifdef PERFORMANCE
		t1 = get_time_sec();
#endif
		//this output gives a good indication of the correct protocol used for accessing information about the original residue from the fragment alignment.
		/*for(unsigned int i=1; i<=alignment.len(); i++){
		 cout << endl << "alignment: " << i << "\tscore: " << FDM[alignment.get(1,i)][alignment.get(2,i)];
		 cout << endl << "\tfrag_i: " << alignment.get(1,i) << "\t res_i: " << f1.idx(alignment.get(1,i)) << "\t central_res_i: " << f1.idx(alignment.get(1,i))+frag_mod << "\t orig_res: " << original_res1[f1.idx(alignment.get(1,i))+frag_mod].res;
		 cout << endl << "\tfrag_i: " << alignment.get(2,i) << "\t res_i: " << f2.idx(alignment.get(2,i)) << "\t central_res_i: " << f2.idx(alignment.get(2,i))+frag_mod << "\t orig_res: " << original_res2[f2.idx(alignment.get(2,i))+frag_mod].res;
		 }*/

		vector<vector<residue_alignment> > Res_align_clusters;
		vector<Align> align_clusters;
		vector<vector<double> > cluster_costheta_all;
		vector<vector<double> > cluster_translate_all;
		
		no_clusters = rigid_substructure_identification(alignment,frag_rot,FDM,f1,f2,res1,res2,workingdirectory,obj1,obj2,fragLen,frag_mod,CLUSTER_SCORE,cluster_degrees,CLUSTER_LINKAGE,CLUSTER_MIN,CLUSTER_RIGIDITY,cluster_transf,Res_align_clusters,align_clusters,cluster_costheta_all,cluster_translate_all,OUTPUT_CLUSTER_DM,CLUSTER_COLOR_v,USE_SIDE,CLUSTER_TRANS_LINKAGE,CLUSTER_TRANS_MAX);
		
		if(no_clusters == 0){	//search for more flexible clusters
            CLUSTER_LINKAGE -= 0.001;   //should equal 0.998
			CLUSTER_RIGIDITY -= 0.001;
			cout << endl << "Restarting rigid substructure search with relaxed clustering parameters..." << endl;
			cluster_transf.clear();
			Res_align_clusters.clear();
			align_clusters.clear();
			cluster_costheta_all.clear();
            no_clusters = rigid_substructure_identification(alignment,frag_rot,FDM,f1,f2,res1,res2,workingdirectory,obj1,obj2,fragLen,frag_mod,CLUSTER_SCORE,cluster_degrees,CLUSTER_LINKAGE,CLUSTER_MIN,CLUSTER_RIGIDITY,cluster_transf,Res_align_clusters,align_clusters,cluster_costheta_all,cluster_translate_all,OUTPUT_CLUSTER_DM,CLUSTER_COLOR_v,USE_SIDE,CLUSTER_TRANS_LINKAGE,CLUSTER_TRANS_MAX);
		}
        if(no_clusters == 0){	//search for more flexible clusters
            CLUSTER_LINKAGE -= 0.003;   //should equal 0.995
			CLUSTER_RIGIDITY -= 0.003;
            CLUSTER_SCORE += 0.2;
            cluster_degrees += 2;
			cout << endl << "Restarting rigid substructure search with further relaxed clustering parameters..." << endl;
			cluster_transf.clear();
			Res_align_clusters.clear();
			align_clusters.clear();
			cluster_costheta_all.clear();
            no_clusters = rigid_substructure_identification(alignment,frag_rot,FDM,f1,f2,res1,res2,workingdirectory,obj1,obj2,fragLen,frag_mod,CLUSTER_SCORE,cluster_degrees,CLUSTER_LINKAGE,CLUSTER_MIN,CLUSTER_RIGIDITY,cluster_transf,Res_align_clusters,align_clusters,cluster_costheta_all,cluster_translate_all,OUTPUT_CLUSTER_DM,CLUSTER_COLOR_v,USE_SIDE,CLUSTER_TRANS_LINKAGE,CLUSTER_TRANS_MAX);
		}
        if(no_clusters == 0){	//search for more flexible clusters
            CLUSTER_LINKAGE -= 0.005;   //should equal 0.99
			CLUSTER_RIGIDITY -= 0.005;
            CLUSTER_SCORE += 0.2;
            cluster_degrees += 2;
			cout << endl << "Restarting rigid substructure search with further relaxed clustering parameters..." << endl;
			cluster_transf.clear();
			Res_align_clusters.clear();
			align_clusters.clear();
			cluster_costheta_all.clear();
            no_clusters = rigid_substructure_identification(alignment,frag_rot,FDM,f1,f2,res1,res2,workingdirectory,obj1,obj2,fragLen,frag_mod,CLUSTER_SCORE,cluster_degrees,CLUSTER_LINKAGE,CLUSTER_MIN,CLUSTER_RIGIDITY,cluster_transf,Res_align_clusters,align_clusters,cluster_costheta_all,cluster_translate_all,OUTPUT_CLUSTER_DM,CLUSTER_COLOR_v,USE_SIDE,CLUSTER_TRANS_LINKAGE,CLUSTER_TRANS_MAX);
		}
        
        if(no_clusters>0){
            //output cluster transformation files
            string tempfileout1 = workingdirectory + "Superposition/Transformations/" + obj1 + "/" + obj1 + "_" + obj2 + ".txt";
            for(int i=0; i<no_clusters; i++){
                write_transformation(cluster_transf[i],"Cluster"+int_to_str(i),tempfileout1,obj2,0);
            }
            
            //get axis-angle representation corresponding to movement relative to original coord frame
            //output axis-angle representation for pymol
           if(OUTPUT_SCREW){
              tempfileout1 = workingdirectory + "Superposition/Transformations/" + obj1 + "/" + obj1 + "_" + obj2;
              for(int i=0; i<no_clusters; i++){
                 write_pymol_screw_axis(cluster_transf[i],tempfileout1,"cluster"+int_to_str(i));
              }
              for(int i=0; i<no_clusters; i++){
                 for(int j=0; j<no_clusters; j++){
                    if(i!=j){
                       Transform transf_diff1;
                       Transform transf_diff2;
                       transf_diff1.create_diff(cluster_transf[j],cluster_transf[i]);
                       write_pymol_screw_axis(transf_diff1,tempfileout1,"clusters"+int_to_str(i)+"_"+int_to_str(j));
                    }
                 }
              }
           }
            
           if(OUTPUT_RMSD_FILES){
              for(int i=0; i<no_clusters; i++){
                 string fileout_side_clust = workingdirectory + "Residue_Alignment_Scores/" + get_filename(filename1) + "_" + domain1 + "/" + get_filename(filename1) + "_" + domain1 + "_" + get_filename(filename2) + "_" + domain2 + "_clust" + int_to_str(i) + ".txt";
                 side_global_RMSD(Res_align,res1,res2,fileout_side_clust,cluster_transf[i]);
              }
           }
        }
        
#ifdef PERFORMANCE
		t2 = get_time_sec();
		write_performance_file("Clustering.txt",obj1,obj2,res1.size(),res2.size(),N1,N2,t2-t1);
#endif
		
		//From here is always performed, even when no clusters are found
		////////////////////
		
		stringstream ss;
		ofstream outfile;
		string cluster_out;
		string PDB_dir = workingdirectory + "Superposition/PDB_files/" + obj1 + "_" + obj2 + "/";
		
		//output clusters
		if(OUT_PDB==1){
			
			//output pymol cluster pdb loader
            string cluster_out;
            string clusterfileout = PDB_dir + ".clusters.txt";
            ofstream outfile;
            outfile.open(clusterfileout.c_str());
            if(outfile.is_open()){
                for(int i=0; i<no_clusters; i++){
                    ss.str("");
                    ss << i;
                    cluster_out = obj1 + "_" + obj2 + "/" + obj2 + "_Cluster" + ss.str() + ".pdb";	//only need to output chain 2
                    outfile << cluster_out << endl;
                }
                outfile.close();
            } else {
                cout << endl << endl << "Unable to open output file " << clusterfileout << " for writing. Program terminated." << endl << endl;
                return 0;
            }
			
			tempfileout1 = workingdirectory + ".HTML_files/tmp/" + obj1 + "_" + obj2 + ".txt";
			outfile.open(tempfileout1.c_str(),ios::app);
			if(outfile.is_open()){
				for(int i=0; i<no_clusters; i++){
					ss.str("");
					ss << i;
					cluster_out = obj2 + "_Cluster" + ss.str();	//only need to output chain 2
					outfile << cluster_out << endl;
					output_pdb(info,filein2,PDB_dir+cluster_out+".pdb",domain2,cluster_transf[i],OUT_PDB_FULL);
				}
				outfile.close();
			} else {
				cout << endl << "Cannot open " << tempfileout1 << " for writing." << endl;
			}	
			
			//output pymol pdb loader
			/*ofstream outfile_pdb;
			 string fileout_pdb = workingdirectory + "Superposition/PDB_files/" + obj1 + "_" + obj2 + ".pml";
			 outfile_pdb.open(fileout_pdb.c_str());
			 if(outfile_pdb.is_open()){
			 outfile_pdb << "load " + obj1 + "/" + obj1 + ".pdb" << endl;
			 outfile_pdb << "load " + obj2 + "/" + obj2 + ".pdb" << endl;
			 for(unsigned int i=0; i<no_clusters; i++){
			 ss.str("");
			 ss << i;
			 outfile_pdb << "load " + obj2 + "/" + obj2 + "_Cluster" + ss.str() + ".pdb" << endl;
			 }
			 outfile_pdb.close();
			 } else {
			 cout << endl << endl << "Unable to open output file " << fileout_pdb << " for writing." << endl << endl;
			 }*/
		}
		
        ////////////////////
        // Output cluster alignment files
        
        /*Res_align_clusters.clear();
        for(int i=0; i<no_clusters; i++){
            //get all residues belonging to clustered fragments, not just the central residues
            Res_align_clusters.push_back(get_frag_res_cluster(align_clusters[i],f1,f2,fragLen));
        }*/
        
        string CLUSTER_fileout = workingdirectory + "Residue_Alignment_Scores/" + obj1 + "/" + obj1 + "_" + obj2 + "_clusters.txt";
        
        //write_cluster_alignment(res1,res2,info,Res_align,CLUSTER_fileout, original_res1, original_res2, Res_align_clusters);

        //get correspondence between residues and aligned fragments
        //used for both 'write_cluster_alignment' and 'OUT_COLOR'.
        vector<residue_alignment> Res_align_all;
        Res_align_all = get_all_res_cluster(alignment,f1,f2,fragLen);
        
        //this is for writing alignment file specifiying all cluster belongingness scores, as angle in degrees
        write_cluster_alignment(Res_align_all, original_res1, original_res2, cluster_costheta_all, CLUSTER_fileout, CLUSTER_RIGIDITY, DISPLAY_AS_COSINE_DISTANCE);
        
        ////////////////////
		
		if(OUT_COLOR==1){
			
			//output Pymol color file to display clusters
			string PYMOL_fileout = workingdirectory + "Colour_Scripts/" + obj1 + "_" + obj2 + "/clusters.pml";
			write_pymol_cluster(info, Res_align_clusters, res1, res2, obj1, obj2, PYMOL_fileout, domain1, domain2, original_res1, original_res2);
			
			////////////////////
			
            double temp_d_r = 0.0;
            double temp_d_t = 0.0;
            double TRANSLATION_MIN = 0.1;
            double TRANSLATION_MAX = 1.0;
            double TRANSLATION_DIFF = TRANSLATION_MAX-TRANSLATION_MIN;
            //vector<residue_alignment> Res_align_all;
            //Res_align_all = get_all_res_cluster(alignment,f1,f2,fragLen);
            
			//get best cluster-fragment costheta score for each aligned residue, for each cluster.
			tempfileout1 = workingdirectory + ".HTML_files/tmp/Colour/" + obj1 + "_" + obj2 + ".txt";
			for(int i=0; i<no_clusters; i++){
				//get all residues belonging to clustered fragments, not just the central residues
                vector<double> res_scores_translate;
                vector<double> res_scores_rotate;
                vector<double> res_scores_combined;
				for(unsigned int j=0; j<Res_align_all.size(); j++){
					temp_d_r = 0.0;
					temp_d_t = 100.0;
					for(unsigned int k=0; k<Res_align_all[j].frags.size(); k++){
						if(cluster_costheta_all[i][Res_align_all[j].frags[k]] > temp_d_r){
							temp_d_r = cluster_costheta_all[i][Res_align_all[j].frags[k]];    //colour score = best fragment cluster rotation score
						}
                        if(cluster_translate_all[i][Res_align_all[j].frags[k]] < temp_d_t){
							temp_d_t = cluster_translate_all[i][Res_align_all[j].frags[k]];    //colour score = best fragment cluster translation score
						}
					}
                    res_scores_rotate.push_back((1.0 - temp_d_r)*CLUSTER_COLOR/CLUSTER_COLOR_v[i]);
                    res_scores_translate.push_back(0.0);
                    if(temp_d_t>TRANSLATION_MIN){
                        res_scores_translate.back() = (temp_d_t-TRANSLATION_MIN)/TRANSLATION_DIFF;
                    }
                    res_scores_combined.push_back(res_scores_rotate.back()+res_scores_translate.back());
                    //cout.precision(5);
					//cout << endl << i << " " << j << "\t" << Res_align_all[j].res1 << "\t" << 1.0-Res_align_all[j].dist;
				}
				
				//write pymol cluster score files
				//Scores in Res_align_all are re-assigned every iteration of i
				ss.str("");
				ss << i;
				cluster_out = "cluster_" + ss.str();
				//PYMOL_fileout = workingdirectory + "Colour_Scripts/" + obj1 + "_" + obj2 + "/" + cluster_out + "_translate.pml";
				//write_pymol_cluster_score(info, Res_align_all, res_scores_translate, res1, res2, obj1, obj2, PYMOL_fileout, domain1, domain2, original_res1, original_res2,i);
				//PYMOL_fileout = workingdirectory + "Colour_Scripts/" + obj1 + "_" + obj2 + "/" + cluster_out + "_rotate.pml";
				//write_pymol_cluster_score(info, Res_align_all, res_scores_rotate, res1, res2, obj1, obj2, PYMOL_fileout, domain1, domain2, original_res1, original_res2,i);
				PYMOL_fileout = workingdirectory + "Colour_Scripts/" + obj1 + "_" + obj2 + "/" + cluster_out + ".pml";
				write_pymol_cluster_score(info, Res_align_all, res_scores_combined, res1, res2, obj1, obj2, PYMOL_fileout, domain1, domain2, original_res1, original_res2,i);
				
				outfile.open(tempfileout1.c_str(),ios::app);
				if(outfile.is_open()){
					outfile << cluster_out << endl;
					outfile.close();
				} else {
					cout << endl << "Cannot open " << tempfileout1 << " for writing." << endl;
				}	
			}
			
			outfile.open(tempfileout1.c_str(),ios::app);
			if(outfile.is_open()){
				outfile << "clusters" << endl;
				outfile.close();
			} else {
				cout << endl << "Cannot open " << tempfileout1 << " for writing." << endl;
			}	
			
		}

		////////////////////
	}
	
    //output atom-based global RMSD score files and colour scripts, for global and any clusters
    //global_transf
    //cluster_transf
    //vector<vector<int> > atomic_alignment = get_full_atomic_alignment(res1,res2,Res_align);
    //vector<double> global_RMSD = get_global_RMSD_scores(pdb1,pdb2,atomic_alignment,global_transf);


    cout << endl << endl;
    cout << "ProSMART ALIGN completed." << endl << endl;
    return 0;
}



