//
// This file is part of ProSMART.
//

#include "alignClass_Align.h"

ostream& operator<<(ostream& out, Align &al)
{
  Array2D<int> temp = al.get();

  for(unsigned int i=0; i<al.len(); i++){
	cout << i+1 << ": ";
	for(unsigned int j=0; j<2; j++){
      cout << temp[i][j] << " ";
    }
    cout << endl;
  }
  
  return out;
}

void Align::printout(Array2D<double> &DM)
{
  for(unsigned int i=0; i<align1.size(); i++){
	cout << i+1 << ": ";
	cout << align1[i] << " " << align2[i];
	cout << "\t" << DM[align1[i]][align2[i]];
    cout << endl;
  }
  
  return;
}

void Align::printout(int x, int y)
{
  for(int i=(x-1); i<y; i++){
	cout << i+1 << ": " << align1[i] << " " << align2[i] << endl;
  }
  return;
}

void Align::add(int x1,int x2)
{
  align1.push_back(x1);
  align2.push_back(x2);
}

void Align::erase(int i)
{
  align1.erase(align1.begin()+i);
  align2.erase(align2.begin()+i);
}

void Align::edit(int arrayidx, int alignidx, int x)
{
  if(arrayidx==1){
    align1[alignidx] = x;
  }
  if(arrayidx==2){
    align2[alignidx] = x;
  }
  return;
}

void Align::edit_entry(int alignidx, int x, int y)
{
  align1[alignidx] = x;
  align2[alignidx] = y;
  return;
}

void Align::insert_start(int i, int j)
{
  align1.insert(align1.begin(),i);
  align2.insert(align2.begin(),j);
  return;
}

void Align::insert(int x, int i, int j)
{
  align1.insert(align1.begin()+x,i);
  align2.insert(align2.begin()+x,j);
  return;
}

void Align::insert(vector<int> &i, vector<int> &j)
{
  if(i[0] < align1[0]){
    for(unsigned int z=0; z<i.size(); z++){
	  align1.insert(align1.begin()+z,i[z]);
	  align2.insert(align2.begin()+z,j[z]);
	}
  } else {
    if(i[0] > align1[align1.size()-1]){
      for(unsigned int z=0; z<i.size(); z++){
	    align1.push_back(i[z]);
	    align2.push_back(j[z]);
	  }
    } else {
      for(unsigned int k=1; k<align1.size(); k++){
        if(i[0] > align1[k-1] && i[0] < align1[k]){
	      for(unsigned int z=0; z<i.size(); z++){
		    align1.insert(align1.begin()+k+z,i[z]);
	        align2.insert(align2.begin()+k+z,j[z]);
		  }
          break;
		}
	  }
	}
  }
  return;
}

Array2D<int> Align::get()
{
  int N = align1.size();
  Array2D<int> temp(N,2);
  
  for(int i=0; i<N; i++){
    temp[i][0] = align1[i];
	temp[i][1] = align2[i];
  }
  
  return temp;
}

Array2D<int> Align::get_residues(int fragLen)
{
  vector<int> residues1;
  vector<int> residues2;
  int current = 0;

  for(unsigned int i=0; i<align1.size(); i++){
    for(int j=0; j<fragLen; j++){
	  if(align1[i]+j > current){
	    current = align1[i]+j;
	    residues1.push_back(current);
		residues2.push_back(align2[i]+j);
	  }
	}
  }
  
  int N = residues1.size();
  Array2D<int> temp(N,2);
  
  for(int i=0; i<N; i++){
    temp[i][0] = residues1[i];
	temp[i][1] = residues2[i];
  }
  
  return temp;
}

Array2D<int> Align::get_T()
{
  int N = align1.size();
  Array2D<int> temp(2,N);
  
  for(int i=0; i<N; i++){
    temp[0][i] = align1[i];
	temp[1][i] = align2[i];
  }
  
  return temp;
}

Array2D<int> Align::get(vector<int> clust)
{
  int N = clust.size();
  Array2D<int> temp(2,N);
  
  for(int i=0; i<N; i++){
    temp[0][i] = align1[clust[i]];
	temp[1][i] = align2[clust[i]];
  }
  
  return temp;
}

Align Align::get_cluster(vector<int> clust)
{
  int N = clust.size();
  Align temp;
  
  for(int i=0; i<N; i++){
		temp.add(align1[clust[i]],align2[clust[i]]);
  }
  
  return temp;
}

int Align::get(int protein, int idx)
{
  int temp = 0;
  if(protein==1){
    temp = align1[idx-1];
  }
  if(protein==2){
    temp = align2[idx-1];
  }
  return temp;
}

unsigned int Align::len()
{
  return align1.size();
}

int Align::last1()
{
  return align1.back();
}

int Align::last2()
{
  return align2.back();
}

void Align::clear()
{
  align1.clear();
  align2.clear();
  return;
}

void Align::reorder_align()
{
  vector<int> temp1 = align1;
  vector<int> temp2 = align2;
  align1.clear();
  align2.clear();
  Array1D<bool> aligned(temp1.size());
  int smallest;
  int smallalign = 0;
  int biggest;
  
  biggest = temp1[0];
  for(unsigned int i=0; i<temp1.size(); i++){
    aligned[i] = 0;
	if(temp1[i]>biggest){
	  biggest = temp1[i];
	}
  }
  biggest++;
  
  while(smallalign>=0){
    smallest = biggest;
    smallalign = -1;
    for(unsigned int i=0; i<temp1.size(); i++){
      if(temp1[i]<smallest && aligned[i]==0){
	    smallest = temp1[i];
	    smallalign = i;
	  }
    }
    if(smallalign>=0){
      aligned[smallalign] = 1;
	  align1.push_back(temp1[smallalign]);
	  align2.push_back(temp2[smallalign]);
    }
  }
  
  return;
}

Array2D<double> Align::align_DM(Array2D<double> &DM)
{
  Array2D<double> result(DM.dim1(),DM.dim2(),1.0);
  
  for(unsigned int i=0; i<align1.size(); i++){
    result[align1[i]][align2[i]] = 0.0;
  }
  
  return result;
}

void Align::pop_back()
{
  align1.pop_back();
  align2.pop_back();
  return;
}
