//
// This file is part of ProSMART.
//

#ifndef alignClass_Frag_H
#define alignClass_Frag_H

#include "alignClass_Residues.h"

class Frag
{
  private:
    Residues* res;			//pointer to a Residues object, which is linked to a PDBfile object.
	vector<int> frag;			//indexes fragments by storing the index of the start-residue of fragment i.
	int frag_len;
	int mode;				//mode=0 rotate/score using mainchain atoms.
									//mode=1 rotate/score using CAs.
									//mode=2 rotate using mainchain atoms, scoring using CAs. 
  public:
    //Frag(Residues&,int,int);
	void create(Residues&,int,int);
	vector<int> filter(vector<res_corresp> &, vector<vector<int> > &);
	int size();
    void erase(int);
	int res_size();
	int len();
	int last_res();
	void ca_crds(Coords&,int);
	Coords ca_crds_norm(int);
	Coords ca_crds_mainnorm(int);
	void crds(Coords&,int);
    Coords get_central_ca();
	Coords central_side(int, int, bool);
	vector<string> get_side_atom(int, int);
	string get_side_resid(int, int);
	string get_side_orig(int, int);
	//vector<string> get_side_element(int, int);
	Coords crds_norm(int);
	Coords get_crds(int);
	coord get_mean(int);
	int idx(int);			//returns the number of the residue that corresponds to the ith fragment
	int res_idx(int);		//returns the number of the ith residue.
	vector<int> get_residues(Align&, int);
	vector<string> get_resid(Align&, int);
	string get_resid(int);					//resid corresponding to residue indexed by i
	string get_resid_frag(int, int);		//resid corresponging to fragment i, +mod residues
};

#endif
