//
// This file is part of ProSMART.
//

#include "align_helix.h"

vector<string> info_vector_helix(string filein1, string filein2, char domain1, char domain2, unsigned short fragLen, bool align_cutoff, int Nres1, int Nres2, double ALIGN_SCORE, int ALIGN_MODE, bool EXTRA_REFINEMENT, double SIDE_SCORE)
{
  vector<string> info;
  return info;
}

void get_res_align_helix(Align &alignment, Frag &frag1, Array2D<double> &FDM, vector<residue_alignment> &Res_align)
//generates Res_align object for repetitive structure
{
  residue_alignment temp;
  int N = frag1.len();
  vector<double> min_score;
  vector<int> cen_idx;
  vector<int> r1;
  vector<int> r2;
  double temp_score;
  int idx;
  
	temp.type1 = "NA";
	temp.type2 = "NA";
  temp.dist2 = -1.0;
  temp.dist3 = -1.0;
  temp.dist4 = -1.0;
   temp.dist5 = -1.0;

  //get minimum score
  for(unsigned int i=1; i<=alignment.len(); i++){
    idx = frag1.idx(alignment.get(1,i));
    while((int)min_score.size() < idx+N){	//ensure arrays are long enough
	  min_score.push_back(-1.0);
	  r1.push_back(-1);
	  r2.push_back(-1);
	}
	temp_score = FDM[alignment.get(1,i)][alignment.get(2,i)];	//get score corresponding to fragment
	for(int j=0; j<N; j++){
	  if(temp_score < min_score[idx+j] || min_score[idx+j] < 0.0){
	    min_score[idx+j] = temp_score;
		r1[idx+j] = idx+j;
	  }
	  r2[idx+j] = j;
	}
  }
  
  //construct Res_Align object
  for(unsigned int i=0; i<min_score.size(); i++){
    if(min_score[i]>=0.0){
	  temp.res1 = r1[i];
	  temp.res2 = r2[i];
	  temp.dist = min_score[i];
	  Res_align.push_back(temp);
	}
  }
  
  return;
}

Align helix_alignment(Array2D<double> &FDM, double cutoff)
{
  Align result;
  for(int i=0; i<FDM.dim1(); i++){
	if(FDM[i][0] <= cutoff){
	  result.add(i,0);
	}
  }
  return result;
}

Align helix_alignment(vector<int> &idx)
{
  Align result;
  for(unsigned int i=0; i<idx.size(); i++){
		result.add(idx[i],0);
  }
  return result;
}

void create_alignment_matrix(Residues &res1, Align &alignment, Frag &f1, Array2D<double> &FDM, unsigned int fragLen, vector<residue_alignment> &Res_align, string &fileout)
{
	ofstream outfile;
	int temp;
	int N = Res_align.size();
	
	Array2D<int> M1(N,fragLen,-1);
	Array2D<double> MS(N,fragLen,-1);
	
	vector<int> indexes;	//maps residues to aligned residues
	if(N>0){
		for(int i=0; i<=Res_align[N-1].res1; i++){
			indexes.push_back(-1);
		}
	}
	for(int i=0; i<N; i++){
		indexes[Res_align[i].res1] = i;
	}

	for(unsigned int i=1; i<=alignment.len(); i++){
		temp = indexes[f1.idx(alignment.get(1,i))];
		for(unsigned int j=0; j<fragLen; j++){
			for(unsigned int k=0; k<fragLen-j; k++){
				if(MS[temp+j][k]==-1 || MS[temp+j][k]>FDM[alignment.get(1,i)][alignment.get(2,i)]){
					M1[temp+j][k]=j;
					MS[temp+j][k]=FDM[alignment.get(1,i)][alignment.get(2,i)];
				}
			}
		}
	}
	
	outfile.open(fileout.c_str());
	if(outfile.is_open()){
		for(int i=0; i<N; i++){
			for(unsigned int j=0; j<fragLen; j++){
				if(M1[i][j]<0){break;}
				outfile << M1[i][j] << " ";
			}
			outfile << endl;
		}
		outfile.close();
	} else {
		cout << endl << "Unable to open output file " << fileout << " for writing" << endl;
	}

	
  return;	
}

PDBfile get_helix(unsigned short no_residues)
{
  pdbline temp;
  string tmp = "GLY";
  temp.alt = ' ';
  strcpy(temp.resid, tmp.c_str());
  temp.chain = 'A';
  temp.ins_code = ' ';
  temp.occup = 1.0;
  temp.bfact = 20.0;
  
  PDBfile result;
  pdbline temp1;
  string tempstr;

temp1 = temp;
temp1.crd.x = -6.301;
temp1.crd.y = -3.016;
temp1.crd.z = -10.149;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 1;
if(1 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -6.636;
temp1.crd.y = -4.117;
temp1.crd.z = -9.234;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 1;
if(1 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.465;
temp1.crd.y = -4.383;
temp1.crd.z = -8.285;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 1;
if(1 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.649;
temp1.crd.y = -4.515;
temp1.crd.z = -7.066;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 1;
if(1 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.293;
temp1.crd.y = -4.453;
temp1.crd.z = -8.886;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 2;
if(2 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.036;
temp1.crd.y = -4.702;
temp1.crd.z = -8.164;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 2;
if(2 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.827;
temp1.crd.y = -3.628;
temp1.crd.z = -7.094;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 2;
if(2 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.499;
temp1.crd.y = -3.935;
temp1.crd.z = -5.939;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 2;
if(2 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.025;
temp1.crd.y = -2.396;
temp1.crd.z = -7.525;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 3;
if(3 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.878;
temp1.crd.y = -1.214;
temp1.crd.z = -6.663;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 3;
if(3 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.812;
temp1.crd.y = -1.327;
temp1.crd.z = -5.456;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 3;
if(3 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.403;
temp1.crd.y = -1.095;
temp1.crd.z = -4.309;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 3;
if(3 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.045;
temp1.crd.y = -1.682;
temp1.crd.z = -5.764;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 4;
if(4 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -6.104;
temp1.crd.y = -1.849;
temp1.crd.z = -4.757;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 4;
if(4 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.68;
temp1.crd.y = -2.889;
temp1.crd.z = -3.719;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 4;
if(4 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.81;
temp1.crd.y = -2.671;
temp1.crd.z = -2.506;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 4;
if(4 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.182;
temp1.crd.y = -3.995;
temp1.crd.z = -4.24;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 5;
if(5 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.714;
temp1.crd.y = -5.124;
temp1.crd.z = -3.424;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 5;
if(5 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.617;
temp1.crd.y = -4.656;
temp1.crd.z = -2.463;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 5;
if(5 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.643;
temp1.crd.y = -4.97;
temp1.crd.z = -1.264;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 5;
if(5 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.686;
temp1.crd.y = -3.914;
temp1.crd.z = -3.033;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 6;
if(6 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.542;
temp1.crd.y = -3.36;
temp1.crd.z = -2.296;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 6;
if(6 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.037;
temp1.crd.y = -2.488;
temp1.crd.z = -1.14;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 6;
if(6 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.559;
temp1.crd.y = -2.604;
temp1.crd.z = -0.001;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 6;
if(6 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.988;
temp1.crd.y = -1.637;
temp1.crd.z = -1.479;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 7;
if(7 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.606;
temp1.crd.y = -0.706;
temp1.crd.z = -0.524;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 7;
if(7 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.22;
temp1.crd.y = -1.482;
temp1.crd.z = 0.643;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 7;
if(7 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.023;
temp1.crd.y = -1.134;
temp1.crd.z = 1.816;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 7;
if(7 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.951;
temp1.crd.y = -2.517;
temp1.crd.z = 0.272;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 8;
if(8 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -5.633;
temp1.crd.y = -3.4;
temp1.crd.z = 1.23;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 8;
if(8 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.614;
temp1.crd.y = -4.008;
temp1.crd.z = 2.197;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 8;
if(8 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.822;
temp1.crd.y = -4.019;
temp1.crd.z = 3.419;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 8;
if(8 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.539;
temp1.crd.y = -4.497;
temp1.crd.z = 1.607;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 9;
if(9 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.436;
temp1.crd.y = -5.126;
temp1.crd.z = 2.347;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 9;
if(9 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.865;
temp1.crd.y = -4.145;
temp1.crd.z = 3.372;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 9;
if(9 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.652;
temp1.crd.y = -4.495;
temp1.crd.z = 4.542;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 9;
if(9 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.638;
temp1.crd.y = -2.937;
temp1.crd.z = 2.89;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 10;
if(10 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.092;
temp1.crd.y = -1.84;
temp1.crd.z = 3.702;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 10;
if(10 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.999;
temp1.crd.y = -1.579;
temp1.crd.z = 4.907;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 10;
if(10 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.526;
temp1.crd.y = -1.453;
temp1.crd.z = 6.046;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 10;
if(10 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.282;
temp1.crd.y = -1.508;
temp1.crd.z = 4.607;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 11;
if(11 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.327;
temp1.crd.y = -1.264;
temp1.crd.z = 5.612;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 11;
if(11 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.272;
temp1.crd.y = -2.343;
temp1.crd.z = 6.695;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 11;
if(11 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.311;
temp1.crd.y = -2.042;
temp1.crd.z = 7.897;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 11;
if(11 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.183;
temp1.crd.y = -3.572;
temp1.crd.z = 6.225;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 12;
if(12 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.119;
temp1.crd.y = -4.758;
temp1.crd.z = 7.09;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 12;
if(12 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.921;
temp1.crd.y = -4.65;
temp1.crd.z = 8.037;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 12;
if(12 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.041;
temp1.crd.y = -4.887;
temp1.crd.z = 9.248;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 12;
if(12 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.798;
temp1.crd.y = -4.293;
temp1.crd.z = 7.443;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 13;
if(13 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.528;
temp1.crd.y = -4.129;
temp1.crd.z = 8.165;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 13;
if(13 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.689;
temp1.crd.y = -3.094;
temp1.crd.z = 9.279;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 13;
if(13 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.269;
temp1.crd.y = -3.318;
temp1.crd.z = 10.425;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 13;
if(13 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.297;
temp1.crd.y = -1.985;
temp1.crd.z = 8.899;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 14;
if(14 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.555;
temp1.crd.y = -0.861;
temp1.crd.z = 9.81;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 14;
if(14 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.387;
temp1.crd.y = -1.334;
temp1.crd.z = 11.003;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 14;
if(14 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.074;
temp1.crd.y = -1.025;
temp1.crd.z = 12.163;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 14;
if(14 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.428;
temp1.crd.y = -2.075;
temp1.crd.z = 10.672;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 15;
if(15 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -4.36;
temp1.crd.y = -2.633;
temp1.crd.z = 11.662;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 15;
if(15 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.602;
temp1.crd.y = -3.51;
temp1.crd.z = 12.659;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 15;
if(15 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -3.791;
temp1.crd.y = -3.399;
temp1.crd.z = 13.879;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 15;
if(15 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -2.761;
temp1.crd.y = -4.358;
temp1.crd.z = 12.097;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 16;
if(16 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.931;
temp1.crd.y = -5.294;
temp1.crd.z = 12.87;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 16;
if(16 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -1.053;
temp1.crd.y = -4.522;
temp1.crd.z = 13.857;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 16;
if(16 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.962;
temp1.crd.y = -4.875;
temp1.crd.z = 15.042;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 16;
if(16 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.433;
temp1.crd.y = -3.485;
temp1.crd.z = 13.326;
tempstr = " N  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 17;
if(17 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = 0.459;
temp1.crd.y = -2.606;
temp1.crd.z = 14.096;
tempstr = " CA ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 17;
if(17 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = -0.296;
temp1.crd.y = -2.002;
temp1.crd.z = 15.282;
tempstr = " C  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 17;
if(17 <= no_residues){result.add(temp1);}
temp1 = temp;
temp1.crd.x = 0.201;
temp1.crd.y = -1.997;
temp1.crd.z = 16.418;
tempstr = " O  ";
strcpy(temp1.atom,tempstr.c_str());
temp1.res_num = 17;
if(17 <= no_residues){result.add(temp1);}
    
  return result;
}

