//
// This file is part of ProSMART.
//

#ifndef align_output_filehandling_H
#define align_output_filehandling_H

#include "alignClass_Frag.h"
#include "prosmart_file_management.h"

//generates info to act as a header in all files
vector<string> info_vector(string, string, char, char, unsigned short, bool, int, int, int, double, double, double, double, double, int, bool, double);

//manages output operations
Transform output_alignment(vector<string> &, PDBfile &, PDBfile &, vector<residue_alignment> &, vector<residue_alignment> &, Frag &, Frag &, Residues &, Residues &, string, string, char, string, string, char, string, string, string, vector<res_corresp> &, vector<res_corresp> &, double, double, vector<int> &, vector<int> &, vector<coord> &, bool, bool, bool, double, bool, bool, bool);
void output_scores(string, string, char, char, string, int, double, double, double, double, double, double, vector<string> &, double &, double &, vector<int> &, double &);
//void output_scores_full(string, string, string, char, char, string, int, double, double, double, double, double, vector<string> &);
void output_residue_scores(vector<residue_alignment> &, vector<string> &, vector<int> &, string &, vector<string> &);
void write_transformation(Transform &, string, string &, string &, bool);
void write_pymol_screw_axis(Transform &, string &, string);
//void write_pymol_screw_axis(Transform &, Transform &, string &, string);

//creates particular output files
void define_pymol_colors(coord &, coord &);
void write_pymol(vector<string> &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &, vector<int> &, vector<int> &, Array1D<double> &, Array1D<double> &);
void write_pymol_minimum(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_central(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_rot(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_sidechainRMSD(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_sidechainMAX(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_sidechainAV(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, double, vector<res_corresp> &, vector<res_corresp> &);
void write_pymol_helix(vector<string> &, vector<residue_alignment> &, Residues &, string, string, char, double, vector<res_corresp> &);
void write_pymol_sse(vector<string> &, vector<residue_alignment> &, Residues &, Residues &, string, string, string, char, char, vector<res_corresp> &, vector<res_corresp> &, vector<int> &, vector<int> &, vector<coord> &);


Transform write_full_pdb(vector<string> &, Residues &, Residues &, vector<residue_alignment> &, string, string, char, string, string, char, bool, bool);
void write_alignment(Residues &, Residues &, vector<string> &, vector<residue_alignment> &, string, vector<res_corresp> &, vector<res_corresp> &, bool);
void write_residue_types(vector<string> &, vector<residue_alignment> &, string, vector<res_corresp> &);

//get transformation that superimposes a set of aligned residues
Transform get_transf(Residues &, Residues &, vector<residue_alignment> &, bool);
//if using side chains, reorder coordinates to account for differences in ordering in the PDB file
void get_coords_inc_side(Residues &, Residues &, vector<residue_alignment> &, Coords &, Coords &);
//outputs whole pdb files, with given coordinate transformations
void output_pdb(vector<string> &, string, string, char, bool);
void output_pdb(vector<string> &, string, string, char, Transform&, bool);
void output_pdb(vector<string> &, string &, string &, char, Transform&, bool, bool);

vector<string> get_orig_res1(vector<residue_alignment> &, vector<res_corresp> &);
vector<string> get_orig_res2(vector<residue_alignment> &, vector<res_corresp> &);
vector<int> get_resnum_corresp(vector<string> &, vector<string> &);

#endif
