//
// This file is part of ProSMART.
//

#include "prosmartClass_Coords.h"

double tr_cov(coord &T)
{
	return ((T.x*T.x)+(T.y*T.y)+(T.z*T.z));
}

void cov(Array2D<double> &M, Coords &A, Coords &B)
{
  for(int i=0; i<3; i++){
    for(int j=0; j<3; j++){
	  M[i][j] = 0.0;
    }
  }
  
  for(int i=0; i<A.size(); i++){
    M[0][0] += A.x(i)*B.x(i);
	M[0][1] += A.x(i)*B.y(i);
	M[0][2] += A.x(i)*B.z(i);
	M[1][0] += A.y(i)*B.x(i);
	M[1][1] += A.y(i)*B.y(i);
	M[1][2] += A.y(i)*B.z(i);
	M[2][0] += A.z(i)*B.x(i);
	M[2][1] += A.z(i)*B.y(i);
	M[2][2] += A.z(i)*B.z(i);
  }
  
  return;
}

void covariance(Array2D<double> &M, Coords &A, Coords &B)
{
  for(int i=0; i<3; i++){
    for(int j=0; j<3; j++){
			M[i][j] = 0.0;
    }
  }
  for(int i=0; i<A.size(); i++){
    M[0][0] += A.x(i)*B.x(i);
		M[0][1] += A.x(i)*B.y(i);
		M[0][2] += A.x(i)*B.z(i);
		M[1][0] += A.y(i)*B.x(i);
		M[1][1] += A.y(i)*B.y(i);
		M[1][2] += A.y(i)*B.z(i);
		M[2][0] += A.z(i)*B.x(i);
		M[2][1] += A.z(i)*B.y(i);
		M[2][2] += A.z(i)*B.z(i);
  }
	for(int i=0; i<3; i++){
    for(int j=0; j<3; j++){
			M[i][j] = M[i][j]/A.size();
    }
  }
  return;
}

double dist2(coord &crd)
{
  return (crd.x*crd.x) + (crd.y*crd.y) + (crd.z*crd.z);
}

double dist(coord &crd, coord &crd2)
{
  return sqrt(((crd.x-crd2.x)*(crd.x-crd2.x)) + ((crd.y-crd2.y)*(crd.y-crd2.y)) + ((crd.z-crd2.z)*(crd.z-crd2.z)));
}

double dist(coord *crd, coord *crd2)
{
    return sqrt((((*crd).x-(*crd2).x)*((*crd).x-(*crd2).x)) + (((*crd).y-(*crd2).y)*((*crd).y-(*crd2).y)) + (((*crd).z-(*crd2).z)*((*crd).z-(*crd2).z)));
}

double dist(coord &crd)
{
  return sqrt((crd.x*crd.x) + (crd.y*crd.y) + (crd.z*crd.z));
}

Coords mean_coords(vector<Coords> &crd_v)
{
    Coords result;
    if(crd_v.size()>0){
        result = crd_v[0];
        for(unsigned int i=1; i<crd_v.size(); i++){
            result = result + crd_v[i];
        }
        result = result / (int)crd_v.size();
    }
    
    return result;
}
 
Array2D<double> operator*(Coords &A, Coords &B)
{
  Array2D<double> temp(3,3);
  int N = A.size();
  //maybe a dimension check is required.
  
  for(unsigned int i=0; i<3; i++){
    for(unsigned int j=0; j<3; j++){
	  temp[i][j] = 0;
	  for(int k=0; k<N; k++){
	    temp[i][j] += A.get(k,i)*B.get(k,j);
	  }
	}
  }
  
  return temp;
}

Array2D<double> crossprod_weight(Coords &A, Coords &B, vector<double> &w)
{
    Array2D<double> temp(3,3);
    int N = A.size();
    //maybe a dimension check is required.
    
    for(unsigned int i=0; i<3; i++){
        for(unsigned int j=0; j<3; j++){
            temp[i][j] = 0;
            for(int k=0; k<N; k++){
                temp[i][j] += A.get(k,i)*B.get(k,j)*w[k];
            }
        }
    }
    
    return temp;
}

coord crossprod(coord &a, coord &b)
{
    coord result;
    result.x = a.y*b.z-a.z*b.y;
    result.y = a.z*b.x-a.x*b.z;
    result.z = a.x*b.y-a.y*b.x;
    
    return result;
}

double dotprod(coord &a, coord &b)
{
    return ((a.x*b.x)+(a.y*b.y)+(a.z*b.z));
}

Coords operator*(Coords A, coord &B)
{
  Coords result;
  coord temp;
  
	for(int i=0; i<A.size(); i++){
		temp.x = A.x(i)*B.x;
		temp.y = A.y(i)*B.y;
		temp.z = A.z(i)*B.z;
		result.add(temp);
  }
  
  return result;
}

Coords operator*(Coords &A, Array2D<double> &B)
{
  Coords result;
  coord temp;
  //maybe a dimension check is required.
  
  for(int i=0; i<A.size(); i++){
    temp.x=0;
	temp.y=0;
	temp.z=0;
	for(int j=0; j<3; j++){
	  temp.x += A.get(i,j)*B[j][0];
	  temp.y += A.get(i,j)*B[j][1];
	  temp.z += A.get(i,j)*B[j][2];
	}
	result.add(temp);
  }
  
  return result;
}

coord operator*(coord &A, Array2D<double> &B)
{
  coord result;
  result.x=0;
  result.y=0;
  result.z=0;
  result.x = A.x*B[0][0] + A.y*B[1][0] + A.z*B[2][0];
  result.y = A.x*B[0][1] + A.y*B[1][1] + A.z*B[2][1];
  result.z = A.x*B[0][2] + A.y*B[1][2] + A.z*B[2][2];
  return result;
}

coord operator*(Array2D<double> &B, coord &A)
{
    coord result;
    result.x=0;
    result.y=0;
    result.z=0;
    result.x = A.x*B[0][0] + A.y*B[0][1] + A.z*B[0][2];
    result.y = A.x*B[1][0] + A.y*B[1][1] + A.z*B[1][2];
    result.z = A.x*B[2][0] + A.y*B[2][1] + A.z*B[2][2];
    return result;
}

ostream& operator<<(ostream& out, coord& crd)
{
  cout << crd.x << " "
	<< crd.y << " "
	<< crd.z 
	<< endl;
  return out;
}

ostream& operator<<(ostream& out, Coords& crds)
{
  cout << endl;
  for(int i=0; i<crds.size(); i++){
	cout << i+1 << ": "
	  << *crds.get(i);
  }
  cout << endl;
  return out;
}

coord operator-(coord &c1, coord &c2)
{
  coord result;
  result.x = c1.x - c2.x;
  result.y = c1.y - c2.y;
  result.z = c1.z - c2.z;
  return result;
}

Coords operator-(Coords &C1, coord &c2)
{
  Coords result;
  coord temp;
  for(int i=0; i<C1.size(); i++){
    temp = *(C1.get(i)) - c2;
	result.add(temp);
  }
  return result;
}

Coords operator-(Coords C1, Coords C2)
{
    int N = C1.size();
    if(N>C2.size())N=C2.size();
    Coords result;
    coord temp;
    for(int i=0; i<N; i++){
        temp = *(C1.get(i)) - *(C2.get(i));
        result.add(temp);
    }
    return result;
}

coord operator+(coord &c1, coord &c2)
{
  coord result;
  result.x = c1.x + c2.x;
  result.y = c1.y + c2.y;
  result.z = c1.z + c2.z;
  return result;
}

coord add_coords(coord &c1, coord c2)
{
  coord result;
  result.x = c1.x + c2.x;
  result.y = c1.y + c2.y;
  result.z = c1.z + c2.z;
  return result;
}

Coords operator+(Coords &C1, coord &c2)
{
  Coords result;
  coord temp;
  for(int i=0; i<C1.size(); i++){
    temp = *(C1.get(i)) + c2;
	result.add(temp);
  }
  return result;
}

Coords operator+(Coords &C1, Coords &C2)
{
    int N = C1.size();
    if(N>C2.size())N=C2.size();
    Coords result;
    coord temp;
    for(int i=0; i<N; i++){
        temp = *(C1.get(i)) + *(C2.get(i));
        result.add(temp);
    }
    return result;
}

coord operator/(coord c1, int div)
{
  coord result;
  result.x = c1.x/div;
  result.y = c1.y/div;
  result.z = c1.z/div;
  return result;
}

coord operator/(coord c1, double div)
{
  coord result;
  result.x = c1.x/div;
  result.y = c1.y/div;
  result.z = c1.z/div;
  return result;
}

coord operator*(coord &c1, double val)
{
    coord result;
    result.x = c1.x*val;
    result.y = c1.y*val;
    result.z = c1.z*val;
    return result;
}

Coords operator/(Coords C1, int div)
{
    Coords result;
    coord temp;
    for(int i=0; i<C1.size(); i++){
        temp = *(C1.get(i)) / div;
        result.add(temp);
    }
    return result;
}

void Coords::add(coord newcoords)
{
   coordvector.push_back(newcoords);
   return;
}

void Coords::erase(unsigned int i)
{
    coordvector.erase(coordvector.begin()+i);
    return;
}

coord* Coords::get(int record)
{
   return &coordvector[record];
}

coord Coords::get_crd(int record)
{
   return coordvector[record];
}

double Coords::get(int record, int xyz)
{
  double temp=0.0;
  if(xyz==0){
    temp = coordvector[record].x;
  } else {
    if(xyz==1){
      temp = coordvector[record].y;
    } else {
      if(xyz==2){
        temp = coordvector[record].z;
      }
    }
  }
  return temp;
}

double Coords::x(int record)
{
   return coordvector[record].x;
}

double Coords::y(int record)
{
   return coordvector[record].y;
}

double Coords::z(int record)
{
   return coordvector[record].z;
}

void Coords::getall(vector<coord> &newcoords)
{
   newcoords.reserve(coordvector.capacity()); //Allocate memory
   for(unsigned int ctr=0; ctr<coordvector.size(); ctr++){
     newcoords.push_back(coordvector[ctr]);
   }
   return;
}

int Coords::size()
{
   return coordvector.size();
}

void Coords::clear()
{
   coordvector.clear();
   return;
}

Array2D<double> Coords::asmatrix()
{
  Array2D<double> M(coordvector.size(),3);
  for(unsigned int i=0; i<coordvector.size(); i++){
    M[i][0] = coordvector[i].x;
	M[i][1] = coordvector[i].y;
	M[i][2] = coordvector[i].z;
  }
  return M;
}

coord Coords::mean()
{
  coord mn = coordvector[0];
  for(unsigned int i=1; i<coordvector.size(); i++){
	mn = mn + coordvector[i];
  }
  return mn/(int)coordvector.size();
}

Coords Coords::rmmean()
{
  coord mn = coordvector[0];
  Coords result;
  coord temp;
  
  for(unsigned int i=1; i<coordvector.size(); i++){
	mn = mn + coordvector[i];
  }
  mn = mn/(int)coordvector.size();
  
  for(unsigned int i=0; i<coordvector.size(); i++){
    temp = coordvector[i] - mn;
	result.add(temp);
  }

  return result;
}

Array1D<double> Coords::weighted_sum(vector<double> &w)
{
    Array1D<double> result(3,0.0);
    for(unsigned int i=0; i<coordvector.size(); i++){
        result[0] += coordvector[i].x*w[i];
        result[1] += coordvector[i].y*w[i];
        result[2] += coordvector[i].z*w[i];
    }    
    return result;
}

Array1D<double> Coords::sum()
{
    Array1D<double> result(3,0.0);
    for(unsigned int i=0; i<coordvector.size(); i++){
        result[0] += coordvector[i].x;
        result[1] += coordvector[i].y;
        result[2] += coordvector[i].z;
    }    
    return result;
}

void Coords::append(Coords &crds)
{
  for(int i=0; i<crds.size(); i++){
	coordvector.push_back(*crds.get(i));
  }
  return;
}

double Coords::tr_cov()
{
  double temp = 0.0;
  for(unsigned int i=0; i<coordvector.size(); i++){
    temp += coordvector[i].x*coordvector[i].x;
		temp += coordvector[i].y*coordvector[i].y;
		temp += coordvector[i].z*coordvector[i].z;
  }
  return temp;
}

double Coords::tr_cov(vector<double> &w)
{
    double temp = 0.0;
    for(unsigned int i=0; i<coordvector.size(); i++){
        temp += w[i]*coordvector[i].x*coordvector[i].x;
		temp += w[i]*coordvector[i].y*coordvector[i].y;
		temp += w[i]*coordvector[i].z*coordvector[i].z;
    }
    return temp;
}

vector<double> Coords::tr_cov_v()
{
    double tempx = 0.0;
	double tempy = 0.0;
	double tempz = 0.0;
	vector<double> temp;
    for(unsigned int i=0; i<coordvector.size(); i++){
        tempx += coordvector[i].x*coordvector[i].x;
		tempy += coordvector[i].y*coordvector[i].y;
		tempz += coordvector[i].z*coordvector[i].z;
    }
	temp.push_back(tempx);
	temp.push_back(tempy);
	temp.push_back(tempz);
    return temp;
}

double RMSD(Coords &crds1, Coords &crds2)
{
  int N = crds1.size();
  double result = 0.0;
  coord temp1;
  coord temp2;
  coord temp3;

  for(int i=0; i<N; i++){
    temp1 = crds1.get_crd(i);
    temp2 = crds2.get_crd(i);
		temp3 = temp1-temp2;
		result += dist2(temp3);
  }
  
  return sqrt(result/N);
}

double RMSD(vector<double> &distances)
{
    unsigned int N = distances.size();
    double result = 0.0;
    for(unsigned int i=0; i<N; i++){
		result += distances[i]*distances[i];
    }
    return sqrt(result/N);
}

/*double max(vector<double> &distances)
{
    double result = 0.0;
    for(unsigned int i=0; i<distances.size(); i++){
        if(distances[i]>result){
            result = distances[i];
        }
    }
    return result;
}*/

int no_greater_than(vector<double> &distances, double val)
{
    int result = 0;
    for(unsigned int i=0; i<distances.size(); i++){
        if(distances[i]>val){
            result++;
        }
    }
    return result;
}

double Coords::centroid()
{
	double result = 0.0;
	for(unsigned int i=0; i<coordvector.size(); i++){
    result += sqrt(dist2(coordvector[i]));
  }
	return result/coordvector.size();
}

double Coords::centroid_sd()
{
	double result = 0.0;
	double mn = 0.0;
	double temp = 0.0;
	for(unsigned int i=0; i<coordvector.size(); i++){
    result += sqrt(dist2(coordvector[i]));
  }
	mn = result/coordvector.size();
	
	result=0.0;
	for(unsigned int i=0; i<coordvector.size(); i++){
    temp = (sqrt(dist2(coordvector[i])) - mn);
		result += temp*temp;
  }
	
	return result/coordvector.size();
}

vector<double> Coords::moments(int n)
//calculates standardised spherical moments, up to order n
//i.e. moments of distribution of distance between coordinates and the origin.
//assumes coordinates are normalised before - i.e. origin is 0.
{
  double temp = 0.0;
	double temp1 = 0.0;
	double sd = 0.0;
	vector<double> result;
	for(int i=0; i<n; i++){
		result.push_back(0.0);
	}
	
	//get mean = result[0]
  for(unsigned int i=0; i<coordvector.size(); i++){
    temp = sqrt(dist2(coordvector[i]));
		result[0] += temp;
  }
	result[0] = result[0]/coordvector.size();
	if(n==1){
		return result;
	}
	
	//get var = result[1]
	for(unsigned int i=0; i<coordvector.size(); i++){
    temp = sqrt(dist2(coordvector[i]))-result[0];
		result[1] += temp*temp;
  }
	result[1] = result[1]/coordvector.size();
	if(n==2){
		return result;
	}
	
	//get standard deviation
	sd = sqrt(result[1]);
	
	//get other moments, if required
	for(unsigned int i=0; i<coordvector.size(); i++){
    temp = (sqrt(dist2(coordvector[i]))-result[0])/sd;
		temp1 = temp*temp;
		for(int j=2; j<n; j++){
			temp1 = temp1*temp;
			result[j] += temp1;
		}
  }	
	for(int i=2; i<n; i++){
		result[i] = result[i]/coordvector.size();
	}
  return result;
}

void Coords::get_ends(Coords &C1, Coords &C2)
//places first half of coords in C1, second half in C2. Skips central residue.
{
	int N = (int)(((int)coordvector.size() - 1)/2);
	C1.clear();
	C2.clear();
	for(int i=0; i<N; i++){
	  C1.add(coordvector[i]);
		C2.add(coordvector[N+1+i]);
	}
	return;
}

Coords Coords::swap(unsigned int &i, unsigned int &j)
{
    vector<coord> crds = coordvector;
    crds[i] = coordvector[j];
    crds[j] = coordvector[i];
    
    Coords result;
    for(unsigned int k=0; k<crds.size(); k++)
        result.add(crds[k]);
    
    return result;
}



