//
// This file is part of ProSMART.
//

#ifndef prosmartClass_Coords_H
#define prosmartClass_Coords_H

#include "prosmart_array_tools.h"

struct coord
{  
  double x;
  double y;
  double z;
};

class Coords
{
  private:
	vector<coord> coordvector;
  public:
    void add(coord);				// add a new coord to the object
    void erase(unsigned int);
	coord* get(int);				// returns address of a coord in the object
	coord get_crd(int);
	double get(int, int);
	double x(int);					
	double y(int);
	double z(int);
	void getall(vector<coord> &);	// Copys the object by reference
	int size();						// Number of coordinates
	void clear();					// Clear the object
	coord mean();
	Coords rmmean();
    Array1D<double> weighted_sum(vector<double> &);
    Array1D<double> sum();
	Array2D<double> asmatrix();
	void append(Coords&);
	double tr_cov();
	double tr_cov(vector<double> &);
	vector<double> tr_cov_v();
	vector<double> moments(int);
	double centroid();
	double centroid_sd();
	void get_ends(Coords &, Coords &);
    Coords swap(unsigned int &, unsigned int &);
};

double dist2(coord&);
double dist(coord&,coord&);
double dist(coord*,coord*);
double dist(coord&);
double RMSD(Coords&,Coords&);
void cov(Array2D<double> &, Coords &, Coords &);
void covariance(Array2D<double> &, Coords &, Coords &);
double tr_cov(coord&);
Coords mean_coords(vector<Coords> &);

double RMSD(vector<double> &);
//double max(vector<double> &);
int no_greater_than(vector<double> &,double);

Array2D<double> crossprod_weight(Coords &, Coords &, vector<double> &);
coord crossprod(coord &, coord &);
double dotprod(coord &, coord &);
Array2D<double> operator*(Coords &, Coords &);
Coords operator*(Coords &, Array2D<double> &);
Coords operator*(Coords, coord &);
coord operator*(coord &, Array2D<double> &);
coord operator*(Array2D<double> &, coord &);
ostream& operator<<(ostream&, coord&);
ostream& operator<<(ostream&, Coords&);
coord operator-(coord &, coord &);
Coords operator-(Coords &, coord &);
Coords operator-(Coords, Coords);
coord operator+(coord &, coord &);
coord add_coords(coord &, coord);
Coords operator+(Coords &, coord &);
Coords operator+(Coords &, Coords &);
coord operator/(coord, int);
coord operator/(coord, double);
coord operator*(coord &, double);
Coords operator/(Coords, int);

#endif
