//
// This file is part of ProSMART.
//

#ifndef prosmartClass_PDBfile_H
#define prosmartClass_PDBfile_H

#include "prosmartClass_Transform.h"
#include "prosmart_string_tools.h"

extern bool USE_DNARNA;
extern bool ONLY_OUTPUT_SEQUENCE_FILES;

struct res_corresp
{
    int res;
    char ins;
};

struct pdbline
{
    //direct from PDB file:
    char atom[5];
    char alt;
    char resid[4];
    char chain;
    int res_num;
    char ins_code;
    coord crd;
    double occup;
    double bfact;
    char element[3];
    char charge[3];
    
    //from areaimol PDB file:
    double asa;
    
    //from refmac sigma file:
    double sigma;
    
    //store original residue number (with insertion code)
    string orig_resnum;
};

class PDBfile
{
private:
    vector<pdbline> pdbfile;
public:
	bool readPDB(string,char);
	bool readPDB(string &,string);
    bool readPDB(string &, string &, char);
	void write_formatted_pdb(string &);
	void read_formatted_pdb(string &);
	void read_formatted_pdb_mainchain(string &);
	//void output_pdb(string, string, char, vector<int>, bool, Coords);
	//void output_pdb(vector<string> &, string, string, char, Transform); 
	//void output_pdb(string, string, char, Transform); 
	//void output_pdb(string, string, char, vector<int>, Transform); 
	//void output_pdb(string, string, char, vector<int>, Transform, bool, coord);
	void add(pdbline &);					//adds a new line
    void erase(int&);
    void erase(unsigned int&);
	pdbline line(int);						//returns a line
	int size();								//returns no of lines in pdbfile
	void clear();							//clears the object
	void mainchain(PDBfile &);				//Takes the mainchain atoms only
	//void domain(PDBfile&, char);			//Takes a single domain
	void trim(int);							//Takes residues with resnum no greater than n
	void getcoords(Coords&);				//Returns coordinates
	void getcoords(Coords&, vector<int>);	//Returns coordinates corresponding to the atoms indexed by the vector<int>
	void getcoords(Coords&, vector<unsigned int>);	//Returns coordinates corresponding to the atoms indexed by the vector<int>
	//vector<int> get_resnum(vector<int> &);      //should be deleteted
	//vector<string> get_resid(vector<int> &);    //should be deleted
	int get_resnum(int);
    void set_resnum(int&,int);
    void swap_atoms(int&,int&);
	char* get_resid(int);
	//char& get_resid_address(int);
    string get_sequence();
	string get_atom(int);
	char get_chain(int);
	string get_element(int);
	double get_bfact(int);
	double get_occup(int);
	char get_alt(int);
	string get_orig_resnum(int);
	double get_asa(int);
	double get_sigma(int);
	coord crd(int);
	//void remove_all_alt_atoms();
	//void remove_all_ins_code();
	void output_resid(char, string&, vector<int> &, vector<int> &);
	//void output_resnum(char, string&);
	void rename_resnum(vector<res_corresp> &, unsigned short);
	void filter_alt_atoms();
    void remove_alt_atoms(string&);
    void remove_low_occup(string&,double);
    void flag_occup_alt(string &);
	//PDBfile filter_alt_atoms();
	//vector<string> get_reslist();
	//vector<int> get_renamedreslist();
    void filter_residues_by_range(vector<int> &, vector<int> &);
    void filter_residues_by_removal(vector<string> &);
    void merge_asa(PDBfile &);
    void import_sigma(string &);
    
	//for restrain:
	//void readPDBfile(string, string);
	//void convertPDB(string, string);
	//int readbinPDB(string);
	double get_distance(int,int);			//returns distance between the two indexed atoms
	double get_av_bfact(int,int);			//returns average bfactor of the two indexed atoms
	//int get_atom_resnum(int);
	//string get_atom_resid(int);
	//string get_atom_atom(int);
	//char get_atom_chain(int);
	vector<coord> av_pos();
	//void rename_resnum(vector<res_corresp> &);
	int get_highest_resnum();
	//coord getcoord(int);
};

//Coords getcoords(PDBfile&,vector<int>&);
//void pdb_transf(PDBfile&,PDBfile&,vector<int>&,vector<int>&,Coords&,Coords&);
char convert_resid(char *);
void write_original_res(string, vector<res_corresp> &);
vector<res_corresp> read_original_res(string);

ostream& operator<<(ostream&, pdbline);
ostream& operator<<(ostream&, PDBfile&);
ostream& operator<<(ostream&, res_corresp&);
ostream& operator<<(ostream&, vector<res_corresp>&);

#endif
