//
// This file is part of ProSMART.
//

#ifndef prosmart_align_tools_H
#define prosmart_align_tools_H

#include "prosmart_string_tools.h"
#include "prosmartClass_Coords.h"

//important note - this is specific to the prosmart binary ONLY - not prosmart align.
struct res_alignment
{  
    string res1;
    string res2;
    double min;
    double central;
	double rot;
    double sideRMS;
    double sideAV;
    double MaxDist;
    int NumDist;
    double asa1;
    double asa2;
};

vector<res_alignment> file_read_alignment(string &);
vector<res_alignment> file_read_align_types(string &);
void write_align(vector<res_alignment>&, string&);
vector<res_alignment> max_align_scores(vector<vector<res_alignment> > &);
void define_pymol_colors(coord &, coord &);
void write_pymol(int, vector<res_alignment> &, string &, vector<string> &, vector<char> &, double);
void write_pymol_nonidentical(int, vector<res_alignment> &, vector<vector<res_alignment> > &, string &, string &, string &, vector<string> &, vector<string> &, double);
void write_pymol_nonidentical(int, vector<vector<res_alignment> > &, string &, vector<string> &, vector<string> &, double);

ostream& operator<<(ostream&, res_alignment &);

#endif
