//
// This file is part of ProSMART.
//

#include "prosmart_file_management.h"

int glbctr = 0;			//global variable, for uniqueness of temporary filenames.

vector<string> read_dir(string &error_file, string path)
{
    DIR *dp;
    struct dirent *ep;
    vector<string> result;
	
    dp = opendir(path.c_str());
    if(dp != NULL){
		while ((ep = readdir(dp))){
            result.push_back(ep->d_name);
		}
		closedir(dp);
    } else {
		cout << endl << "Error - could not open directory: " << path << " for reading." << endl
		<< "Program terminated." << endl << endl;
		xml_entry(error_file,0,10,path);
		exit(-1);
    }
	
    return result;
}

bool check_dir_exists(string &path)
{
    DIR *dp;     
    dp = opendir(path.c_str());
    if(dp != NULL){
        closedir(dp);
        return 1;
    } else {
        return 0;
    }
}

void check_dir(string &error_file, vector<string> &strv, string str, string path)
//checks that 'str' is present in 'strv' - exit if not
{
    
#ifdef WINDOWS
    return;
#endif
    
    for(unsigned int i=0; i<strv.size(); i++){
        if(strv[i]==str){
            return;
        }
    }
    
    cout << endl << "Error - '" << str << "' cannot be found in " << path << endl;
    cout << "Solutions:" << endl << endl
    << "(1) Copy '" << str << "' into " << path << " or" << endl << endl
    << "(2) Create and export the variable PROSMART_DIR, which contains the path of the PROSMART directory containing '" << str << "'." << endl << endl
    << "(3) Reinstall ProSMART, ensuring that the desired installation location is specified in the makefile." << endl << endl;
    cout << "Program terminated." << endl << endl;
    xml_entry(error_file,0,11,str);
    exit(-1);
}

string make_subdirectory(string &workingdirectory, string subdirectory)
{ 
    string error_file = "";
    return make_subdirectory(error_file,workingdirectory,subdirectory);
}

string make_subdirectory(string &error_file, string &workingdirectory, string subdirectory)
{ 
    string result = workingdirectory + subdirectory + "/";
    create_directory(error_file, result);
    return result;
}

void create_directory(string &error_file, string &directory)
{
    bool valid;
#ifdef WINDOWS
    directory = replace_chars(directory,"/","\\");
    CreateDirectory(directory.c_str(),NULL);
#else
    valid = check_dir_exists(directory);	//check whether subdirectory exists
    if(valid){return;}
    valid = system(("mkdir -p \"" + directory + "\"").c_str());
#endif
    
    valid = check_dir_exists(directory);	//check whether directory exists - exit if not.
    if(valid == 0){
        cout << endl << "Error - directory '" << directory << "' could not be created." << endl
		<< "Program terminated." << endl << endl;
        xml_entry(error_file,0,12,directory);
        exit(-1);
    }
    
    return;
}

bool validate_file(string &filename, string &firstline)
{
    ifstream infile;
    string line;
    infile.open(filename.c_str(), ifstream::in);
    if(!infile.is_open())return 1;				//file doesn't exist
    getline(infile,line);
    infile.close();
    if(firstline != line)return 1;				//file isn't valid
    return 0;
}

bool validate_file(string &filename)
{
    ifstream infile;
    infile.open(filename.c_str(), ifstream::in);
    if(!infile.is_open())return 1;				//file doesn't exist
    return 0;
}

void create_empty_file(string &error_file,string fileout)
{
	ofstream outfile;
	outfile.open(fileout.c_str(),ios::trunc);
	if(!outfile.is_open()){
		xml_entry(error_file,0,5,fileout);
		cout << "Unable to open output file " << fileout << " for writing. Program terminated." << endl;
		exit(-1);
	}
	outfile.close();
    return;
}

void stream_file_copy(string &error_file, string filein, string fileout)
{
    ifstream infile;
    ofstream outfile;
    string line;
    infile.open(filein.c_str(), ifstream::in);
    if(infile.is_open()){
        outfile.open(fileout.c_str());
        if(outfile.is_open()){
            while(!infile.eof()) {
                getline(infile,line);
                outfile << line << endl;
            }
            outfile.close();
        } else {
            infile.close();
            xml_entry(error_file,0,5,fileout);
            cout << "Unable to open output file " << fileout << " for writing. Program terminated." << endl;
            exit(-1);
        }
        infile.close();
    } else {
        xml_entry(error_file,0,5,filein);
        cout << "Unable to open input file " << filein << " for reading. Program terminated." << endl;
        exit(-1);
    }
    
    return;
}
