//
// This file is part of ProSMART.
//

#ifndef prosmart_multiple_superposition_H
#define prosmart_multiple_superposition_H

#include "prosmart_external_programs.h"

Array1D<PDBfile> get_pdb_files(string &, vector<string> &, vector<string> &);
Array1D<vector<vector<unsigned int> > > get_residues(Array1D<PDBfile> &);
Array2D<vector<unsigned int> > get_residue_alignment(Array1D<PDBfile> &, Array1D<vector<vector<unsigned int> > > &, Array2D<vector<res_alignment> > &);
Array2D<vector<unsigned int> > get_atom_alignment(Array1D<PDBfile> &, Array1D<vector<vector<unsigned int> > > &, Array2D<vector<unsigned int> > &);
void sieve_fit_atoms(Array1D<PDBfile> &, Array2D<vector<unsigned int> > &);
void ensure_consensus(Array2D<vector<unsigned int> > &);
Array2D<vector<double> > get_alignment_weights(Array2D<vector<unsigned int> > &);
Array2D<Coords> get_aligned_coords(Array1D<PDBfile> &, Array2D<vector<unsigned int> > &);
Array2D<coord> get_initial_positions(Array2D<Coords> &);
Array1D<Transform> get_initial_transformation(Array2D<Coords> &);
Array2D<Transform> get_all_transformations(Array2D<Coords> &);
Array1D<Transform> optimise_rotations(Array2D<Coords> &, Array2D<vector<double> > &, Array1D<Transform> &);
void optimise_translations(Array2D<Coords> &, Array2D<vector<double> > &, Array1D<Transform> &);
double brute_force_ss(Array2D<Coords> &, Array2D<vector<double> > &, Array1D<Transform> &);
void output_multiple_superposition(vector<string> &, vector<string> &, Array1D<Transform> &, string, bool);
void output_multiple_superposition(vector<string> &, vector<string> &, Array1D<Transform> &, int);
void pymol_multiple_superposition(string, vector<string> &, vector<string> &, Array1D<PDBfile> &, Array2D<vector<unsigned int> > &);
void multiple_structure_scoring(vector<string> &, Array1D<PDBfile> &, Array2D<vector<unsigned int> > &, Array1D<Transform> &, vector<double> &);

#endif
