//
// This file is part of ProSMART.
//

#include "prosmart_pdb_tools.h"
#ifndef WINDOWS
#include <unistd.h>
#endif

vector<string> rename_nmr(string &error_file, string filein, string dirout) 
{
  string line="";
  char buffer[128];
  char *lptr;
  lptr = buffer;
  
  string fileout="";
  int mod_no=0;
  stringstream ss;
  vector<string> outfiles;
    
  ifstream infile(filein.c_str(), ios::in);
  ofstream outfile;
	bool FIRST = 1;
  
  if(infile.is_open()){
      while(!infile.eof()){						//for each line (that is not inside a model)
	    line.clear();
        getline(infile,line);
	    memset(lptr,'\0',128);
        strcpy(lptr, line.c_str());
		if(strncmp("MODEL",lptr,5)==0 || strncmp("END",lptr,3)==0 || FIRST==1){			//found a new model
			//line.erase(0,5);
		  
			FIRST = 1;	//don't ignore this atom line.

			if(strncmp("ATOM",lptr,4)!=0)
				continue;
			
			
		  /*if(mod_no>10){						//temporary cap on number of nmr files
		    infile.close();
			return outfiles;
		  }*/
				
			mod_no++;								//get model number
		  
		  ss.str("");
		  ss << mod_no;
		  
		  fileout = dirout + get_filename(filein) + ".pdb";
		  for(unsigned int i=1; i<=fileout.size(); i++){
			if(fileout[fileout.size()-i] == "."[0]){
			  fileout.insert(fileout.size()-i, ss.str());	//get new fileout name
			  break;
			}
		  }
		  		  
		  outfile.open(fileout.c_str());
		  if(outfile.is_open()){
			while(!infile.eof()){					//for each line in the model
				if(FIRST==0){
					line.clear();
					getline(infile,line);
					memset(lptr,'\0',128);
					strcpy(lptr, line.c_str());
				} else {
					FIRST = 0;
				}
				
			  if(strncmp("ENDMDL",lptr,6)==0)		//got to end of nmr model
				break;
				
				if(strncmp("END",lptr,3)==0){			//got to end of md model
					FIRST = 1;
					break;
				}
			  
			  if(strncmp("ATOM",lptr,4)!=0)
				continue;
				
			  outfile << line << endl;
		    }
			cout << "PDB file written to: " << fileout << endl;
			outfiles.push_back(fileout);
			outfile.close();
		  } else {
			cout << "Unable to open output file " << fileout << " for writing" << endl;
			xml_entry(error_file,0,5,fileout);
			infile.close();
			exit(-1);
		  }
		}
	  }
    infile.close();
  } else {
    xml_entry(error_file,0,3,filein);
    cout << "Unable to open " << filein << " for reading" << endl;
	exit(-1);
  }	
	
  return outfiles;
}

void rename_chain(string &error_file, string filein, string chainin) 
{ 
  string line;
  char buffer[128];
  char *lptr;
  lptr = buffer;
    
  ifstream infile(filein.c_str(), ios::in);
  
  string fileout = filein;
  for(unsigned int i=1; i<=fileout.size(); i++){
    if(fileout[fileout.size()-i] == "."[0]){
	  fileout.insert(fileout.size()-i, chainin);
	  break;
	}
  }
  
  ofstream outfile;
  outfile.open(fileout.c_str());
  
  if(infile.is_open()){
    if(outfile.is_open()){
      while(!infile.eof()){
	    line.clear();
        getline(infile,line);
	    memset(lptr,'\0',128);
        strcpy(lptr, line.c_str());
	    if(strncmp("ATOM",lptr,4)!=0)
	      continue;

        line[21] = chainin[0];			//rename the chainID
		outfile << line << endl;
	  }
	  cout << endl << "PDB file written to: " << fileout << endl;
	  outfile.close();
	} else {
	  cout << "Unable to open output file " << fileout << " for writing" << endl;
	  xml_entry(error_file,0,5,fileout);
	  infile.close();
	  exit(-1);
	}
    infile.close();
  } else {
    xml_entry(error_file,0,3,filein);
    cout << "Unable to open " << filein << " for reading" << endl;
	exit(-1);
  }
  return;
}

vector<string> get_chains(string &error_file, string filein, bool skip_mainchain_check)
{
   PDBfile pdb;
   pdb.readPDB(error_file,filein);
   
   vector<char> chains;
   bool valid = 0;
   bool gotN = 0;
   bool gotC = 0;
   bool gotO = 0;
   bool gotCA = 0;
   for(int i=0; i<pdb.size(); i++){
      valid = 1;
      for(unsigned int j=0; j<chains.size(); j++){
         if(pdb.line(i).chain == chains[j]){
            valid = 0;
         }
      }
      if(valid == 1){							//if haven't already included this chain
         if(skip_mainchain_check){
            chains.push_back(pdb.line(i).chain);			//assume that this is a valid chain
            continue;
         }
         if(USE_DNARNA){
            if(strncmp(" O5'",pdb.line(i).atom,4)==0) gotN = 1;
            else if(strncmp(" C4'",pdb.line(i).atom,4)==0) gotC = 1;
            else if(strncmp(" O3'",pdb.line(i).atom,4)==0) gotO = 1;
            else if(strncmp(" C1'",pdb.line(i).atom,4)==0) gotCA = 1;
         } else {
            if(strncmp(" N  ",pdb.line(i).atom,4)==0) gotN = 1;
            else if(strncmp(" C  ",pdb.line(i).atom,4)==0) gotC = 1;
            else if(strncmp(" O  ",pdb.line(i).atom,4)==0) gotO = 1;
            else if(strncmp(" CA ",pdb.line(i).atom,4)==0) gotCA = 1;
         }
         if(gotN==1 && gotC==1 && gotO==1 && gotCA==1){	//if the four mainchain atoms have been found for this chain
            chains.push_back(pdb.line(i).chain);			//assume that this is a valid chain
            gotN = 0;
            gotC = 0;
            gotO = 0;
            gotCA = 0;
         }
      }
   }
    
  vector<string> str_chains;
  string temp;
  for(unsigned int i=0; i<chains.size(); i++){
    temp = chains[i];
	str_chains.push_back(temp);
  }
  
  return str_chains;
}

bool validate_files(PDBfile &pdb1, int fragLen)
{	
    bool valid = 0;
    bool gotN = 0;
    bool gotC = 0;
    bool gotO = 0;
    bool gotCA = 0;
   
   if(USE_DNARNA){
      for(int i=0; i<pdb1.size(); i++){
         if(strncmp(" O5'",pdb1.line(i).atom,4)==0){
            gotN = 1;
         } else if(strncmp(" C4'",pdb1.line(i).atom,4)==0){
            gotC = 1;
         } else if(strncmp(" O3'",pdb1.line(i).atom,4)==0){
            gotO = 1;
         } else if(strncmp(" C1'",pdb1.line(i).atom,4)==0){
            gotCA = 1;
         }
         if(gotN==1 && gotC==1 && gotO==1 && gotCA==1){
            valid = 1;
            break;
         }
      }
   } else {
      for(int i=0; i<pdb1.size(); i++){
         if(strncmp(" N  ",pdb1.line(i).atom,4)==0){
            gotN = 1;
         } else if(strncmp(" C  ",pdb1.line(i).atom,4)==0){
            gotC = 1;
         } else if(strncmp(" O  ",pdb1.line(i).atom,4)==0){
            gotO = 1;
         } else if(strncmp(" CA ",pdb1.line(i).atom,4)==0){
            gotCA = 1;
         }
         if(gotN==1 && gotC==1 && gotO==1 && gotCA==1){
            valid = 1;
            break;
         }
      }
   }

    if(!valid){
        return 0;
    }
    valid = 0;
	
	int ctr = 0;
	int current = 0;
	int last = 0;
	for(int i=0; i<pdb1.size(); i++){
		current = pdb1.get_resnum(i);
		if(ctr == 0){
			ctr++;
			last = current;
		} else if(current == last){
			continue;
		} else if(current == last+1){
			ctr++;
			last = current;
			if(ctr >= fragLen){ //require sufficient consecutive residues
				valid = 1;
				break;
			}
		} else {
			ctr = 0;
		}
	}
    return valid;
}

bool validate_files(string &out_dir, string &filename, char chain, int fragLen, bool HELIX, vector<int> &RANGE1, vector<int> &RANGE2, vector<string> &RM_RES, bool USE_SIGMAS, double OCCUPANCY_THRESHOLD)
{   
	PDBfile pdb1;
    bool result = pdb1.readPDB(filename, chain);	// read pdbfile
    if(!result){
        return 0;
    }
    
#ifdef RUN_AREAIMOL
    //read PDB file with ASA calculations
    string file_asa = out_dir + ".Input_Chains/" + get_filename(filename) + "_asa.pdb";
    PDBfile pdb_asa;
	pdb_asa.readPDB(file_asa, chain);
    pdb1.merge_asa(pdb_asa);
#endif
    
    if(USE_SIGMAS){
        string file_sigma = out_dir + ".Input_Chains/" + get_filename(filename) + "_sigmas.txt";
        pdb1.import_sigma(file_sigma);
    }
	
    if(RANGE1.size()>0){
        pdb1.filter_residues_by_range(RANGE1,RANGE2);
    }
    if(RM_RES.size()>0){
        pdb1.filter_residues_by_removal(RM_RES);
    }
    
    string file = get_filename(filename) + "_" + chain;

   if(OCCUPANCY_THRESHOLD>=0.0 && OCCUPANCY_THRESHOLD<=1.0){
      pdb1.remove_low_occup(file,OCCUPANCY_THRESHOLD);    //removes any atoms with zero occupancy.
   }
   
    pdb1.filter_alt_atoms();    //only the first conformation is taken - any other alternative conformations are removed.
	if(validate_files(pdb1,fragLen) == 0){
		return 0;
	}
    
	//output sequence files, providing they don't already exist.
    //this must be done from the original pdb objects.
    string seq_fileout1 = out_dir + "Sequence/" + file + ".txt";
    ifstream inp;
    inp.open(seq_fileout1.c_str(), ifstream::in);
    inp.close();
    /*cout << endl << "Outputing sequence file for " << file;
    if(RANGE1.size()>0){
        cout << " (note: modified residue range)";
    }*/
    pdb1.output_resid(chain,seq_fileout1,RANGE1,RANGE2);

   if(ONLY_OUTPUT_SEQUENCE_FILES){
      return 1;
   }
    
    string fileout = out_dir + ".Input_Chains/" + file;
	vector<res_corresp> original_res1;
	pdb1.rename_resnum(original_res1, fragLen);
	write_original_res(fileout + "_orig", original_res1);
	if(HELIX==1){
        pdb1.trim(fragLen);
    }
	
	pdb1.write_formatted_pdb(fileout);

    return 1;
}

void run_areaimol(string &filein, string &fileout)
{
    string scriptout = file_append_name(fileout,'_');
    ofstream outfile;
    outfile.open(scriptout.c_str());
    if(outfile.is_open()){
		outfile << "areaimol XYZIN \"" << filein << "\" XYZOUT \"" << fileout << "\" <<eof-area" << endl
        << "SMODE IMOL" << endl
        << "SYMMETRY \"`grep '^CRYST1 ' " << filein << " | cut -c56-66`\"" << endl
        << "OUTPUT" << endl
        << "END" << endl
        << "eof-area" << endl;
		outfile.close();
    } else {
        cout << "Unable to open output file " << scriptout << " for writing" << endl;
    }
    system((". \"" + scriptout + "\" > /dev/null; rm \"" + scriptout + "\"").c_str());
    //system((". \"" + scriptout + "\" > " + get_filename(fileout) + "areaimol_log.txt; rm \"" + scriptout + "\"").c_str());
    return;
}

void output_sequence_identity(vector<vector<int> > &seq_scores, vector<string> &obj, vector<string> &sequences, int &i, double &SEQ_ID, double &SEQ_ID_MAX)
{
    string filepath = "ProSMART_Output/" + obj[i] + ".txt";
    unsigned int n1 = sequences[i].size();
    unsigned int n2 = 0;
    double id = 0.0;
    ofstream outfile;
    outfile.open(filepath.c_str(), ios::trunc);
    if(outfile.is_open()){
        for(unsigned int j=0; j<seq_scores[i].size(); j++){
            if(seq_scores[i][j]<0)continue;                     // seq_scores[i][j]<0 means do not output to file
            n2 = sequences[j].size();
            if(n1<n2)
                id = (double)seq_scores[i][j]/n1;
            else 
                id = (double)seq_scores[i][j]/n2;
            if(id<SEQ_ID)continue;                        // require sufficient sequence identity
            if(id>SEQ_ID_MAX)continue;
            outfile << obj[i] << "\t" << obj[j] << "\t"
            << n1 << "\t" << n2 << "\t"
            << seq_scores[i][j] << "\t"
            << id << endl;
        }
        outfile.close();
    } else {
        cout << endl << "Error - could not open file: " << filepath << " for writing.";
    }
    
    return;
}

void append_lines(vector<string> &obj, unsigned int &i, vector<string> &final)
{
    string filein = "ProSMART_Output/" + obj[i] + ".txt";
    
    string line;
    ifstream infile(filein.c_str(), ios::in);
    if(infile.is_open()){
        while(!infile.eof()){
            line.clear();
            getline(infile,line);
            if(line.size()>0)
                final.push_back(line);
        }
        infile.close();
    } else {
        cout << endl << "Error - could not open file: " << filein << " for reading.";
    }
    
    return;
}

void write_final_file(vector<string> &final)
{
    string filepath = "final.txt";
    
    ofstream outfile;
    outfile.open(filepath.c_str(), ios::trunc);
    if(outfile.is_open()){
        for(unsigned int i=0; i<final.size(); i++){
            outfile << final[i] << endl;
        }
        outfile.close();
    } else {
        cout << endl << "Error - could not open file: " << filepath << " for writing.";
    }
    
    return;
}

string read_sequence(string &filein)
{    
    string result = "";
    string line;
    ifstream infile(filein.c_str(), ios::in);
    if(infile.is_open()){
        while(!infile.eof()){
            line.clear();
            getline(infile,line);
            if(line.size()==0)continue;
            if(line[0]=='>')continue;
            result = line;
            while(!infile.eof()){
                line.clear();
                getline(infile,line);
                if(line.size()>0)
                    cerr << endl << "Warning: Uninterpreted line in " << filein << " : " << line;
            }
            break;
        }
        infile.close();
    } else {
        cout << endl << "Error - could not open file: " << filein << " for reading.";
    }
    
    return result;
}

unsigned int compare_sequences(string &v1, string &v2)
{
    unsigned int n1 = v1.size();
    unsigned int n2 = v2.size();
    Array2D<int> F(n1,n2,0);
    
    //construct boolean sequence identity matrix 
    for(unsigned int i=0; i<n1; i++)
        for(unsigned int j=0; j<n2; j++)
            if(v1[i]==v2[j])
                F[i][j] = 1;

    //turn sequence identity matrix into cost matrix
    for(unsigned int i=1; i<n1; i++)		//fill first row and column.
        if(F[i-1][0]==1)
            F[i][0] = 1;
    for(unsigned int j=1; j<n2; j++)		//fill first row and column.
        if(F[0][j-1]==1)
            F[0][j] = 1;
    for(unsigned int i=1; i<n1; i++)		//fill rest of matrix.
        for(unsigned int j=1; j<n2; j++)
            if(F[i][j-1] > F[i-1][j]){
                if(F[i][j-1] > F[i-1][j-1])
                    F[i][j] = F[i][j-1];    //note: score cannot improve unless on a diagonal
                else
                    F[i][j] += F[i-1][j-1];
            } else {
                if(F[i-1][j] > F[i-1][j-1])
                    F[i][j] = F[i-1][j];
                else
                    F[i][j] += F[i-1][j-1];
            }
    //number of sequence-identical residues = F[n1-1,n2-1]
    
    

    //find best path through matrix
    /*if(1){
        vector<unsigned int> a1;
        vector<unsigned int> a2;
        unsigned int x1 = n1-1;
        unsigned int x2 = n2-1;
        a1.push_back(x1);
        a2.push_back(x2);
        while(x1>0 && x2>0){
            if(v1[x1]==v2[x2] && v1[x1-1]==v2[x2-1]){
                x1 -= 1;
                x2 -= 1;
            } else if(F[x1-1][x2-1]>=F[x1][x2-1] && F[x1-1][x2-1]>=F[x1-1][x2]){
                x1 -= 1;
                x2 -= 1;
            } else if(F[x1][x2-1] > F[x1-1][x2])
                x2 -= 1;
            else
                x1 -= 1;
            a1.push_back(x1);
            a2.push_back(x2);
        }
        //fill out the end (actually the start!) of the path
        if(x2!=0)
            for(int i=x2-1; i>=0; i--){
                a1.push_back(0);
                a2.push_back(i);
            }
        else if(x1!=0)
            for(int i=x1-1; i>=0; i--){
                a1.push_back(i);
                a2.push_back(0);
            }
        
        //remove non-identical residues.
        for(unsigned int i=0; i<a1.size(); i++)
            if(v1[a1[i]]!=v2[a2[i]]){
                a1.erase(a1.begin()+i);
                a2.erase(a2.begin()+i);
                i--;
            }
        
        string filepath = "log.txt";
        ofstream outfile;
        outfile.open(filepath.c_str(), ios::app);
        if(outfile.is_open()){
            for(unsigned int i=a1.size()-1; i>=0; i--)
                outfile << a1[i] << "\t" << a2[i] << "\t" << v1[a1[i]] << "\t" << v2[a2[i]] << endl;
            outfile.close();
        } else {
            cout << endl << "Error - could not open file: " << filepath << " for writing.";
        }
        
    }*/
    
    /*cout << endl << endl << F;
    //cout << endl << endl << a1 << endl << endl << a2 << endl << endl;
    for(unsigned int i=0; i<a1.size(); i++)
     cout << a1[i] << " " << a2[i] << " " << F[a1[i]][a2[i]] << " " << v1[a1[i]] << " " << v2[a2[i]] << endl;
    cout << endl << endl;*/
    
    return F[n1-1][n2-1];
}

#ifndef WINDOWS
int sequence_alignment(vector<string> &filenames1, vector<string> &chains1, int &MAX_THREADS, int &SEQ_MIN, double &SEQ_RATIO, double &SEQ_ID, double &SEQ_ID_MAX)
{
    if(SEQ_RATIO<0){
        cout << endl << "Error - maximum sequence ratio must be positive. Current value: " << SEQ_RATIO;
        cout << endl << "Program terminated." << endl << endl;
        return 1;
    }
    if(SEQ_ID<0 || SEQ_ID>1){
        cout << endl << "Error - minimum sequence identity must be in the range [0,1]. Current value: " << SEQ_ID;
        cout << endl << "Program terminated." << endl << endl;
        return 1;
    }
    if(SEQ_ID_MAX<0 || SEQ_ID_MAX>1){
        cout << endl << "Error - maximum sequence identity must be in the range [0,1]. Current value: " << SEQ_ID_MAX;
        cout << endl << "Program terminated." << endl << endl;
        return 1;
    }
    if(SEQ_ID_MAX<SEQ_ID){
        cout << endl << "Error - maximum sequence identity must be no less than minimum sequence identity.";
        cout << endl << "Program terminated." << endl << endl;
        return 1;
    }
    
    if(SEQ_RATIO>0.0 && SEQ_RATIO<1.0)
        SEQ_RATIO = 1.0/SEQ_RATIO;      //ensure >1 if specified
    
    double T1 = get_time_sec();
    double t1 = T1;
    double t2;
    vector<pid_t> pIDs;
    int status=0;
    pid_t pIDstatus;

    cout << "Number of files: " << filenames1.size() << endl << endl;
    
    ////////////////////////////////////////////////
    
    cout << "Loading sequences into memory...";
    t1 = get_time_sec();
    vector<string> sequences;
    vector<string> obj;
//#define USE_SEQUENCE
#ifdef USE_SEQUENCE
    //this gets sequence from input sequence file
    for(unsigned int i=0; i<filenames1.size(); i++){
        obj.push_back(get_filename(filenames1[i]));
        sequences.push_back(read_sequence(filenames1[i]));
    }
#else
    //this gets sequence from PDB file
    for(unsigned int i=0; i<filenames1.size(); i++){
        obj.push_back(get_filename(filenames1[i]) + "_" + chains1[i]);
        PDBfile pdb_tmp;
        pdb_tmp.readPDB(filenames1[i], chains1[i][0]);
        sequences.push_back(pdb_tmp.get_sequence());
        //cout << endl << sequences.back();
        if(i%100==0)cout << endl << "done " << i;
    }
#endif
    t2 = get_time_sec();
    cout << endl << "Finished getting " << sequences.size() << " sequences.";
    cout << endl << "Time: " << t2-t1 << " seconds." << endl << endl;
    
    ////////////////////////////////////////////////

    unsigned int n = sequences.size();
    if(SEQ_MIN>0){
        for(unsigned int i=0; i<n; i++){
            if((int)sequences[i].size()<SEQ_MIN){
                sequences.erase(sequences.begin()+i);
                obj.erase(obj.begin()+i);
                i--;
            }
        }
        cout << "Removed " << n-sequences.size() << " sequences shorter than: " << SEQ_MIN << " residues." << endl << endl;
        n = sequences.size();
    }
    
    ////////////////////////////////////////////////
    
    pid_t pID;
    vector<vector<int> > seq_scores;
    vector<int> tmp_vi;
    for(unsigned int i=0; i<sequences.size(); i++){
        seq_scores.push_back(tmp_vi);
    }
    unsigned int ctr = 0;
    unsigned int N = n*(n-1)/2;
    cout << "Comparing " << n << " sequences." << endl;
    cout << "Performing " << N << " pairwise sequence alignments...";
    t1 = get_time_sec();
    for(int i=n-1; i>=0; i--){
        for(unsigned int j=0; j<pIDs.size(); j++){  //update_pIDs()
            pIDstatus = waitpid(pIDs[j],&status,WNOHANG);
            if(pIDstatus != 0){								
                pIDs.erase(pIDs.begin()+j);					
                j--;
            }
        }
		if((int)pIDs.size() >= MAX_THREADS){		//make sure that not too many threads are started
			wait(&status);                          //wait for any process to terminate
		}
        pID = fork();
		if(pID == 0){
            if(SEQ_RATIO>0){
                double tmp;
                for(int j=0; j<i; j++){
                    if(sequences[i].size()>sequences[j].size())
                        tmp = (double)sequences[i].size()/sequences[j].size();
                    else
                        tmp = (double)sequences[j].size()/sequences[i].size();
                    if(tmp > SEQ_RATIO)
                        seq_scores[i].push_back(-1);
                    else 
                        seq_scores[i].push_back(compare_sequences(sequences[i],sequences[j]));
                }
            } else {
                for(int j=0; j<i; j++){
                    seq_scores[i].push_back(compare_sequences(sequences[i],sequences[j]));
                }
            }
            output_sequence_identity(seq_scores,obj,sequences,i,SEQ_ID,SEQ_ID_MAX);
            _exit(status);	//ensure child process is terminated.
        } else if(pID < 0){
			cout << endl << "Error spawning child process. Program terminated.";
			return -1;
		}
        pIDs.push_back(pID);				//store process ID of this process
        
        ctr += i;
        if(i%10==0)cout << endl << "launched " << ctr;
    }
    for(unsigned int i=0; i<pIDs.size(); i++)waitpid(pIDs[i],&status,0); //wait for all threads to finish
    t2 = get_time_sec();
    cout << endl << "Finished. Number of jobs: " << ctr;
    cout << endl << "Time: " << t2-t1 << " seconds.";
    cout << endl << "Time per alignment: " << (t2-t1)/N << " seconds.";
    cout << endl << endl;
    
    ////////////////////////////////////////////////

    cout << "Writing final alignment file...";
    t1 = get_time_sec();
    vector<string> final;
    for(unsigned int i=0; i<sequences.size(); i++){
        append_lines(obj,i,final);
    }
    write_final_file(final);
    t2 = get_time_sec();
    cout << endl << "Finished.";
    cout << endl << "Time: " << t2-t1 << " seconds.";
    cout << endl << endl;
    
    if(SEQ_RATIO>0){
        cout << "Removed sequence-pairs with length ratio greater than: " << SEQ_RATIO << endl;
    }
    if(SEQ_ID>0){
        cout << "Removed sequence-pairs with sequence identity less than: " << SEQ_ID << endl;
    }
    if(SEQ_ID_MAX<1){
        cout << "Removed sequence-pairs with sequence identity greater than: " << SEQ_ID_MAX << endl;
    }
    
    cout << endl << "Final number of output sequence-pairs " << final.size() << endl;
    
    ////////////////////////////////////////////////
    
    double T2 = get_time_sec();
    cout << endl << "Task finished.";
    cout << endl << "Total time: " << T2-T1 << " seconds.";
    cout << endl << endl;
    
    return 0;
}
#endif
