//
// This file is part of ProSMART.
//

#ifndef prosmart_pdb_tools_H
#define prosmart_pdb_tools_H

#include "prosmartClass_PDBfile.h"
#ifndef WINDOWS
#include <sys/wait.h>
#endif

vector<string> rename_nmr(string&, string, string);
void rename_chain(string&, string, string);
vector<string> get_chains(string &, string, bool);
bool validate_files(string &, string &, char, int, bool, vector<int> &, vector<int> &, vector<string> &, bool, double);
bool validate_files(PDBfile &, int);
unsigned int compare_sequences(string &, string &);
string read_sequence(string &);
void output_sequence_identity(vector<vector<int> > &, vector<string> &, vector<string> &, int &, double &);
void append_lines(vector<string> &, unsigned int &, vector<string> &);
void write_final_file(vector<string> &);
void run_areaimol(string &, string &);
#ifndef WINDOWS
int sequence_alignment(vector<string> &, vector<string> &, int &, int &, double &, double &, double &);
#endif
#endif
