//
// This file is part of ProSMART.
//

#ifndef prosmart_process_management_H
#define prosmart_process_management_H

#include "prosmart_windows.h"

#include "prosmart_string_tools.h"
#include <sstream>
#include <unistd.h>
#ifndef WINDOWS
#include <sys/wait.h>
#endif

void validate_pdb_file(string &, vector<string> &, string &);
bool check_file(string);	//specific to checking bonds files outputted by refmac.
void get_bonds(string &, string &, string &, vector<pid_t> &, int, string &, string &);
void get_atomic_uncertainty(string &, string &, string &, string &, vector<pid_t> &, int, string &, string &);

void update_pIDs(vector<pid_t> &);
void wait_for_pIDs(vector<pid_t> &, vector<pid_t> &);

void spawn_external(string &, vector<string> &, vector<string> &, vector<pid_t> &, vector<pid_t> &, int);
#ifndef WINDOWS
void spawn_external(string &, vector<string> &, vector<string> &, vector<string> &, vector<string> &, bool, vector<pid_t> &, vector<pid_t> &, int);
#endif

#endif
