//
// This file is part of ProSMART.
//

#ifndef prosmart_string_tools_H
#define prosmart_string_tools_H

#include "prosmart_flags.h"
#include "prosmart_xml.h"
#include <sstream>

string make_valid_directory(string&,string&);
bool check_ext(string &);
string delete_spaces(string);
string replace_spaces(string, string);
string replace_chars(string, string, string);
string duplicate_char(string &, string);
string half_char(string &, string);
string terminal_spaces(string &);
string delete_ext(string);
string get_filename(string);
string get_folder(string);
vector<string> string_to_vector(string &);
vector<string> string_to_vector(string &, char);
string vector_to_string(vector<string> &);
int str_to_int(string&);
double str_to_double(string&);

vector<string> read_file(string&);
vector<string> read_file_line_string(string &);
vector<vector<string> > read_file_lines(string &);
vector<vector<int> > read_file_lines_int(string &);
bool check_file_exists(string &);
void write_to_file(string &, vector<vector<string> > &);

//for align:
string file_append_name(string,char);
string get_full_filename(string);
string standardise_double(string, int, int);
string fill_out(string &, string &);
string fill_out_back(string &, string &);
string int_to_str(int);
string d_to_str(double);

#endif
