//
// This file is part of ProSMART.
//

#ifndef restrainClass_Atomic_Bonds_H
#define restrainClass_Atomic_Bonds_H

#include "restrain_align_handler.h"

struct atom_corresp
{
  res_corresp res;
  string atom;
};

void filter_bonds(string, char, vector<res_corresp> &, vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &, int, int &);
vector<vector<atom_corresp> > convert_bonds(vector<vector<string> > &, vector<res_corresp> &);
vector<vector<int> > get_bond_list(vector<vector<atom_corresp> > &, PDBfile &);
void remove_restraints(vector<vector<int> > &, vector<residue_alignment> &, vector<residue_alignment> &);
vector<vector<int> > get_angle_list(vector<vector<int> > &);

#endif
