//
// This file is part of ProSMART.
//

#include "restrainClass_Residues.h"

void Residues::initialise(PDBfile &pdb1)
{
  unsigned int resnum;
  vector<int> empty_v;
  
  res = &pdb1;
  
  for(int i=0; i<pdb1.size(); i++){
    resnum = pdb1.get_resnum(i);
    while(atoms.size() <= resnum){
      atoms.push_back(empty_v);
    }
    atoms[resnum].push_back(i);
  }

  return;
}

string Residues::get_resid(int i)
{
  return (*res).get_resid(atoms[i][0]);
}

vector<int> Residues::get_atoms(int i)
{
  return atoms[i];
}

vector<string> Residues::get_amino(int x)
{
  vector<string> result;
  for(unsigned int i=0; i<atoms[x].size(); i++){
    result.push_back((*res).get_atom(atoms[x][i]));
  }
  
  return result;
}
